/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.fun;

import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.fun.SqlConvertFunction;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.util.Static;

public class SqlTranslateFunction
extends SqlConvertFunction {
    protected SqlTranslateFunction(String name) {
        super(name, SqlKind.TRANSLATE, ReturnTypes.ARG0, null, null, SqlFunctionCategory.STRING);
    }

    @Override
    public void validateCall(SqlCall call, SqlValidator validator, SqlValidatorScope scope, SqlValidatorScope operandScope) {
        List<SqlNode> operands = call.getOperandList();
        assert (operands.size() == 2);
        operands.get(0).validateExpr(validator, scope);
        assert (operands.get(1) instanceof SqlIdentifier);
        String src_charset = operands.get(1).toString();
        SqlUtil.getCharset(src_charset);
        super.validateQuantifier(validator, call);
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        RelDataType t = callBinding.getOperandType(0);
        if (SqlTypeUtil.isNull(t)) {
            return true;
        }
        if (!SqlTypeUtil.inCharFamily(t)) {
            if (throwOnFailure) {
                throw callBinding.newValidationError(Static.RESOURCE.unsupportedTypeInConvertFunc(t.getFullTypeString(), "TRANSLATE", "CHARACTER"));
            }
            return false;
        }
        return true;
    }

    @Override
    public String getSignatureTemplate(int operandsCount) {
        switch (operandsCount) {
            case 2: {
                return "{0}({1} USING {2})";
            }
        }
        throw new IllegalStateException("operandsCount should be 2, got " + operandsCount);
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.of(2);
    }
}

