/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.events;

import com.carrotsearch.ant.tasks.junit4.events.AbstractEvent;
import com.carrotsearch.ant.tasks.junit4.events.EventType;
import com.carrotsearch.ant.tasks.junit4.gson.stream.JsonReader;
import com.carrotsearch.ant.tasks.junit4.gson.stream.JsonToken;
import com.carrotsearch.ant.tasks.junit4.gson.stream.JsonWriter;
import java.lang.management.ManagementFactory;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class BootstrapEvent
extends AbstractEvent {
    private static final List GUARANTEED_PROPERTIES = Arrays.asList("java.version", "java.vendor", "java.vendor.url", "java.home", "java.vm.specification.version", "java.vm.specification.vendor", "java.vm.specification.name", "java.vm.version", "java.vm.vendor", "java.vm.name", "java.specification.version", "java.specification.vendor", "java.specification.name", "java.class.version", "java.class.path", "java.library.path", "java.io.tmpdir", "java.compiler", "java.ext.dirs", "os.name", "os.arch", "os.version", "file.separator", "path.separator", "line.separator", "user.name", "user.home", "user.dir");
    private String defaultCharset = Charset.defaultCharset().name();
    private Map systemProperties;
    private String pidString;

    public BootstrapEvent() {
        super(EventType.BOOTSTRAP);
        try {
            this.pidString = ManagementFactory.getRuntimeMXBean().getName();
        }
        catch (Throwable throwable) {
            this.pidString = "<pid acquire exception: " + throwable.toString() + ">";
        }
        this.systemProperties = this.collectSystemProperties();
        this.systemProperties.put("junit4.memory.total", Long.toString(Runtime.getRuntime().totalMemory()));
        this.systemProperties.put("junit4.processors", Long.toString(Runtime.getRuntime().availableProcessors()));
        this.systemProperties.put("junit4.pidString", this.pidString);
    }

    private Map collectSystemProperties() {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            object = System.getProperties().propertyNames();
            while (object.hasMoreElements()) {
                arrayList.add((String)object.nextElement());
            }
        }
        catch (SecurityException securityException) {
            arrayList.addAll(GUARANTEED_PROPERTIES);
        }
        object = new TreeMap();
        for (String string : arrayList) {
            try {
                String string2 = System.getProperty(string);
                if (string2 == null) continue;
                ((TreeMap)object).put(string, string2);
            }
            catch (SecurityException securityException) {}
        }
        return object;
    }

    public String getDefaultCharsetName() {
        return this.defaultCharset;
    }

    public Map getSystemProperties() {
        return this.systemProperties;
    }

    public String getPidString() {
        return this.pidString;
    }

    @Override
    public void serialize(JsonWriter jsonWriter) {
        jsonWriter.beginObject();
        jsonWriter.name("defaultCharset").value(this.defaultCharset);
        jsonWriter.name("pidString").value(this.pidString);
        jsonWriter.name("systemProperties").beginObject();
        for (Map.Entry entry : this.systemProperties.entrySet()) {
            jsonWriter.name((String)entry.getKey()).value((String)entry.getValue());
        }
        jsonWriter.endObject();
        jsonWriter.endObject();
    }

    @Override
    public void deserialize(JsonReader jsonReader) {
        jsonReader.beginObject();
        this.defaultCharset = BootstrapEvent.readStringProperty(jsonReader, "defaultCharset");
        this.pidString = BootstrapEvent.readStringProperty(jsonReader, "pidString");
        BootstrapEvent.expectProperty(jsonReader, "systemProperties");
        jsonReader.beginObject();
        this.systemProperties = new LinkedHashMap();
        while (jsonReader.peek() != JsonToken.END_OBJECT) {
            this.systemProperties.put(jsonReader.nextName(), jsonReader.nextString());
        }
        jsonReader.endObject();
        jsonReader.endObject();
    }
}

