/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core;

import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.AttributeException;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Context;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Converter;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.ElementException;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Entry;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.PersistenceException;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Traverser;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.strategy.Type;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.stream.InputNode;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.stream.OutputNode;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.stream.Position;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.stream.Style;

class CompositeKey
implements Converter {
    private final Context context;
    private final Traverser root;
    private final Style style;
    private final Entry entry;
    private final Type type;

    public CompositeKey(Context context, Entry entry, Type type) {
        this.root = new Traverser(context);
        this.style = context.getStyle();
        this.context = context;
        this.entry = entry;
        this.type = type;
    }

    @Override
    public Object read(InputNode inputNode) {
        Position position = inputNode.getPosition();
        Class clazz = this.type.getType();
        String string = this.entry.getKey();
        if (string == null) {
            string = this.context.getName(clazz);
        }
        if (this.entry.isAttribute()) {
            throw new AttributeException("Can not have %s as an attribute for %s at %s", clazz, this.entry, position);
        }
        return this.read(inputNode, string);
    }

    @Override
    public Object read(InputNode inputNode, Object object) {
        Position position = inputNode.getPosition();
        Class clazz = this.type.getType();
        if (object != null) {
            throw new PersistenceException("Can not read key of %s for %s at %s", clazz, this.entry, position);
        }
        return this.read(inputNode);
    }

    private Object read(InputNode inputNode, String string) {
        String string2 = this.style.getElement(string);
        Class clazz = this.type.getType();
        if (string2 != null) {
            inputNode = inputNode.getNext(string2);
        }
        if (inputNode == null) {
            return null;
        }
        if (inputNode.isEmpty()) {
            return null;
        }
        return this.root.read(inputNode, clazz);
    }

    @Override
    public boolean validate(InputNode inputNode) {
        Position position = inputNode.getPosition();
        Class clazz = this.type.getType();
        String string = this.entry.getKey();
        if (string == null) {
            string = this.context.getName(clazz);
        }
        if (this.entry.isAttribute()) {
            throw new ElementException("Can not have %s as an attribute for %s at %s", clazz, this.entry, position);
        }
        return this.validate(inputNode, string);
    }

    private boolean validate(InputNode inputNode, String string) {
        String string2 = this.style.getElement(string);
        InputNode inputNode2 = inputNode.getNext(string2);
        Class clazz = this.type.getType();
        if (inputNode2 == null) {
            return true;
        }
        if (inputNode2.isEmpty()) {
            return true;
        }
        return this.root.validate(inputNode2, clazz);
    }

    @Override
    public void write(OutputNode outputNode, Object object) {
        Class clazz = this.type.getType();
        String string = this.entry.getKey();
        if (this.entry.isAttribute()) {
            throw new ElementException("Can not have %s as an attribute for %s", clazz, this.entry);
        }
        if (string == null) {
            string = this.context.getName(clazz);
        }
        String string2 = this.style.getElement(string);
        this.root.write(outputNode, object, clazz, string2);
    }
}

