/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableList;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableSortedAsList;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableSortedSet;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Multiset;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Ordering;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.SortedIterables;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;

final class RegularImmutableSortedSet
extends ImmutableSortedSet {
    static final RegularImmutableSortedSet NATURAL_EMPTY_SET = new RegularImmutableSortedSet(ImmutableList.of(), Ordering.natural());
    private final transient ImmutableList elements;

    RegularImmutableSortedSet(ImmutableList immutableList, Comparator comparator) {
        super(comparator);
        this.elements = immutableList;
    }

    @Override
    public UnmodifiableIterator iterator() {
        return this.elements.iterator();
    }

    @Override
    public UnmodifiableIterator descendingIterator() {
        return this.elements.reverse().iterator();
    }

    @Override
    public Spliterator spliterator() {
        return this.asList().spliterator();
    }

    @Override
    public void forEach(Consumer consumer) {
        this.elements.forEach(consumer);
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public boolean contains(@Nullable Object object) {
        try {
            return object != null && this.unsafeBinarySearch(object) >= 0;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    @Override
    public boolean containsAll(Collection collection) {
        if (collection instanceof Multiset) {
            collection = ((Multiset)collection).elementSet();
        }
        if (!SortedIterables.hasSameComparator(this.comparator(), collection) || collection.size() <= 1) {
            return super.containsAll(collection);
        }
        UnmodifiableIterator unmodifiableIterator = this.iterator();
        Iterator iterator = collection.iterator();
        if (!unmodifiableIterator.hasNext()) {
            return false;
        }
        Object e = iterator.next();
        Object e2 = unmodifiableIterator.next();
        try {
            while (true) {
                int n;
                if ((n = this.unsafeCompare(e2, e)) < 0) {
                    if (!unmodifiableIterator.hasNext()) {
                        return false;
                    }
                    e2 = unmodifiableIterator.next();
                    continue;
                }
                if (n == 0) {
                    if (!iterator.hasNext()) {
                        return true;
                    }
                    e = iterator.next();
                    continue;
                }
                if (n > 0) break;
            }
            return false;
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            return false;
        }
    }

    private int unsafeBinarySearch(Object object) {
        return Collections.binarySearch(this.elements, object, this.unsafeComparator());
    }

    @Override
    boolean isPartialView() {
        return this.elements.isPartialView();
    }

    @Override
    int copyIntoArray(Object[] objectArray, int n) {
        return this.elements.copyIntoArray(objectArray, n);
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Set)) {
            return false;
        }
        Set set = (Set)object;
        if (this.size() != set.size()) {
            return false;
        }
        if (this.isEmpty()) {
            return true;
        }
        if (SortedIterables.hasSameComparator(this.comparator, set)) {
            Iterator iterator = set.iterator();
            try {
                for (Object e : this) {
                    Object e2 = iterator.next();
                    if (e2 != null && this.unsafeCompare(e, e2) == 0) continue;
                    return false;
                }
                return true;
            }
            catch (ClassCastException classCastException) {
                return false;
            }
            catch (NoSuchElementException noSuchElementException) {
                return false;
            }
        }
        return this.containsAll((Collection)set);
    }

    @Override
    public Object first() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.elements.get(0);
    }

    @Override
    public Object last() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.elements.get(this.size() - 1);
    }

    @Override
    public Object lower(Object object) {
        int n = this.headIndex(object, false) - 1;
        return n == -1 ? null : this.elements.get(n);
    }

    @Override
    public Object floor(Object object) {
        int n = this.headIndex(object, true) - 1;
        return n == -1 ? null : this.elements.get(n);
    }

    @Override
    public Object ceiling(Object object) {
        int n = this.tailIndex(object, true);
        return n == this.size() ? null : this.elements.get(n);
    }

    @Override
    public Object higher(Object object) {
        int n = this.tailIndex(object, false);
        return n == this.size() ? null : this.elements.get(n);
    }

    @Override
    ImmutableSortedSet headSetImpl(Object object, boolean bl) {
        return this.getSubSet(0, this.headIndex(object, bl));
    }

    int headIndex(Object object, boolean bl) {
        int n = Collections.binarySearch(this.elements, Preconditions.checkNotNull(object), this.comparator());
        if (n >= 0) {
            return bl ? n + 1 : n;
        }
        return ~n;
    }

    @Override
    ImmutableSortedSet subSetImpl(Object object, boolean bl, Object object2, boolean bl2) {
        return this.tailSetImpl(object, bl).headSetImpl(object2, bl2);
    }

    @Override
    ImmutableSortedSet tailSetImpl(Object object, boolean bl) {
        return this.getSubSet(this.tailIndex(object, bl), this.size());
    }

    int tailIndex(Object object, boolean bl) {
        int n = Collections.binarySearch(this.elements, Preconditions.checkNotNull(object), this.comparator());
        if (n >= 0) {
            return bl ? n : n + 1;
        }
        return ~n;
    }

    Comparator unsafeComparator() {
        return this.comparator;
    }

    RegularImmutableSortedSet getSubSet(int n, int n2) {
        if (n == 0 && n2 == this.size()) {
            return this;
        }
        if (n < n2) {
            return new RegularImmutableSortedSet(this.elements.subList(n, n2), this.comparator);
        }
        return RegularImmutableSortedSet.emptySet(this.comparator);
    }

    @Override
    int indexOf(@Nullable Object object) {
        int n;
        if (object == null) {
            return -1;
        }
        try {
            n = Collections.binarySearch(this.elements, object, this.unsafeComparator());
        }
        catch (ClassCastException classCastException) {
            return -1;
        }
        return n >= 0 ? n : -1;
    }

    @Override
    ImmutableList createAsList() {
        return this.size() <= 1 ? this.elements : new ImmutableSortedAsList(this, this.elements);
    }

    @Override
    ImmutableSortedSet createDescendingSet() {
        Comparator comparator = Collections.reverseOrder(this.comparator);
        return this.isEmpty() ? RegularImmutableSortedSet.emptySet(comparator) : new RegularImmutableSortedSet(this.elements.reverse(), comparator);
    }
}

