var doc_start =
[
    [ "Overview", "doc_overview.html", null ],
    [ "License", "doc_license.html", [
      [ "AngelCode Scripting Library", "doc_license.html#doc_lic_1", null ]
    ] ],
    [ "Compile the library", "doc_compile_lib.html", [
      [ "Set compile time options", "doc_compile_lib.html#doc_compile_lib_1", null ],
      [ "Linking with the library", "doc_compile_lib.html#doc_compile_lib_2", [
        [ "1. Include library source files in project", "doc_compile_lib.html#doc_compile_lib_2_1", null ],
        [ "2. Compile a static library and link into project", "doc_compile_lib.html#doc_compile_lib_2_2", null ],
        [ "3. Compile a dynamically loaded library with an import library", "doc_compile_lib.html#doc_compile_lib_2_3", null ],
        [ "4. Load the dynamically loaded library manually", "doc_compile_lib.html#doc_compile_lib_2_4", null ]
      ] ],
      [ "Considerations for specific platforms", "doc_compile_lib.html#doc_compile_platforms", [
        [ "Windows 64bit", "doc_compile_lib.html#doc_compile_win64", null ],
        [ "Microsoft Visual C++", "doc_compile_lib.html#doc_compile_msvc_sdk", null ],
        [ "GNUC based compilers", "doc_compile_lib.html#doc_compile_gnuc", null ],
        [ "Pocket PC with ARM CPU", "doc_compile_lib.html#doc_compile_pocketpc", null ],
        [ "Marmalade", "doc_compile_lib.html#doc_compile_marmalade", null ]
      ] ],
      [ "Size of the library", "doc_compile_lib.html#doc_compile_size", null ]
    ] ],
    [ "Your first script", "doc_hello_world.html", [
      [ "Helper functions", "doc_hello_world.html#doc_hello_world_1", null ]
    ] ],
    [ "Good practices", "doc_good_practice.html", [
      [ "Always check return values for registrations", "doc_good_practice.html#doc_checkretval", null ],
      [ "Use the message callback to receive detailed error messages", "doc_good_practice.html#doc_usemsgcallbck", null ],
      [ "Always verify return value after executing script function", "doc_good_practice.html#doc_checkexceptions", null ]
    ] ],
    [ "Versions", "doc_versions.html", [
      [ "History", "doc_versions.html#doc_versions_milestones", [
        [ "2003 - Birth and first public release", "doc_versions.html#doc_versions_2003", null ],
        [ "2005 - Version 2, sand box, object handles, script classes, and garbage collection", "doc_versions.html#doc_versions_2005", null ],
        [ "2006 - Script interface", "doc_versions.html#doc_versions_2006", null ],
        [ "2009 - Inheritance, template types, operator overloads, and JIT compilation", "doc_versions.html#doc_versions_2009", null ],
        [ "2010 - Function pointers", "doc_versions.html#doc_versions_2010", null ],
        [ "2011 - Automatic garbage collection and debugging", "doc_versions.html#doc_versions_2011", null ],
        [ "2012 - Namespaces and mixins", "doc_versions.html#doc_versions_2012", null ],
        [ "2013 - Improved template types, delegates, weak references, and initialization lists", "doc_versions.html#doc_versions_2013", null ],
        [ "2014 - Named arguments and auto", "doc_versions.html#doc_versions_2014", null ],
        [ "2015 - Anonymous functions", "doc_versions.html#doc_versions_2015", null ]
      ] ]
    ] ]
];