/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.carbon.CFRange;
import org.eclipse.swt.internal.carbon.CGPoint;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Link
extends Control {
    String text;
    TextLayout layout;
    Color linkColor;
    Color disabledColor;
    Point[] offsets;
    Point selection;
    String[] ids;
    int[] mnemonics;
    int focusIndex;
    static final RGB LINK_FOREGROUND = new RGB(0, 51, 153);
    static final RGB LINK_DISABLED_FOREGROUND = new RGB(172, 168, 153);
    static final String[] AX_ATTRIBUTES = new String[]{"AXTitle"};

    public Link(Composite composite, int n) {
        super(composite, n);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    int callFocusEventHandler(int n, int n2) {
        return 0;
    }

    public Point computeSize(int n, int n2, boolean bl) {
        int n3;
        int n4;
        Rectangle rectangle;
        this.checkWidget();
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        int n5 = this.layout.getWidth();
        if (n == 0) {
            this.layout.setWidth(1);
            rectangle = this.layout.getBounds();
            n4 = 0;
            n3 = rectangle.height;
        } else {
            this.layout.setWidth(n);
            rectangle = this.layout.getBounds();
            n4 = rectangle.width;
            n3 = rectangle.height;
        }
        this.layout.setWidth(n5);
        if (n != -1) {
            n4 = n;
        }
        if (n2 != -1) {
            n3 = n2;
        }
        int n6 = this.getBorderWidth();
        return new Point(n4 += n6 * 2, n3 += n6 * 2);
    }

    void createHandle() {
        this.state |= 0x820;
        int n = 4;
        int[] nArray = new int[1];
        int n2 = OS.GetControlOwner(this.parent.handle);
        OS.CreateUserPaneControl(n2, null, n, nArray);
        if (nArray[0] == 0) {
            this.error(2);
        }
        this.handle = nArray[0];
        this.layout = new TextLayout(this.display);
        this.linkColor = new Color(this.display, LINK_FOREGROUND);
        this.disabledColor = new Color(this.display, LINK_DISABLED_FOREGROUND);
        this.offsets = new Point[0];
        this.ids = new String[0];
        this.mnemonics = new int[0];
        this.selection = new Point(-1, -1);
        this.focusIndex = -1;
    }

    void createWidget() {
        super.createWidget();
        this.layout.setFont(this.getFont());
        this.text = "";
    }

    void drawBackground(int n, int n2) {
        this.fillBackground(n, n2, null);
        if (!this.hasFocus() || !this.drawFocusRing() || this.focusIndex == -1) {
            return;
        }
        int[] nArray = new int[1];
        OS.GetThemeMetric(7, nArray);
        nArray[0] = nArray[0] - 1;
        Rect rect = new Rect();
        Rectangle[] rectangleArray = this.getRectangles(this.focusIndex);
        int n3 = 0;
        while (n3 < rectangleArray.length) {
            Rectangle rectangle = rectangleArray[n3];
            rect.left = (short)(rectangle.x + nArray[0]);
            rect.top = (short)(rectangle.y + nArray[0]);
            rect.right = (short)(rect.left + rectangle.width - nArray[0] * 2);
            rect.bottom = (short)(rect.top + rectangle.height - nArray[0] * 2);
            OS.DrawThemeFocusRect(rect, true);
            ++n3;
        }
    }

    void drawWidget(int n, int n2, int n3, int n4, int n5) {
        GCData gCData = new GCData();
        gCData.paintEvent = n5;
        gCData.visibleRgn = n4;
        GC gC = GC.carbon_new(this, gCData);
        int n6 = this.selection.x;
        int n7 = this.selection.y;
        if (n6 > n7) {
            n6 = this.selection.y;
            n7 = this.selection.x;
        }
        n7 = -1;
        n6 = -1;
        if ((this.state & 8) != 0) {
            gC.setForeground(this.disabledColor);
        }
        this.layout.draw(gC, 0, 0, n6, n7, null, null);
        gC.dispose();
        super.drawWidget(n, n2, n3, n4, n5);
    }

    void enableWidget(boolean bl) {
        super.enableWidget(bl);
        TextStyle textStyle = new TextStyle(null, bl ? this.linkColor : this.disabledColor, null);
        textStyle.underline = true;
        int n = 0;
        while (n < this.offsets.length) {
            Point point = this.offsets[n];
            this.layout.setStyle(textStyle, point.x, point.y);
            ++n;
        }
        this.redraw();
    }

    String[] getAxAttributes() {
        return AX_ATTRIBUTES;
    }

    String getNameText() {
        return this.getText();
    }

    Rectangle[] getRectangles(int n) {
        int n2 = this.layout.getLineCount();
        Rectangle[] rectangleArray = new Rectangle[n2];
        int[] nArray = this.layout.getLineOffsets();
        Point point = this.offsets[n];
        int n3 = 1;
        while (point.x > nArray[n3]) {
            ++n3;
        }
        int n4 = 1;
        while (point.y > nArray[n4]) {
            ++n4;
        }
        int n5 = 0;
        if (n3 == n4) {
            rectangleArray[n5++] = this.layout.getBounds(point.x, point.y);
        } else {
            rectangleArray[n5++] = this.layout.getBounds(point.x, nArray[n3] - 1);
            rectangleArray[n5++] = this.layout.getBounds(nArray[n4 - 1], point.y);
            if (n4 - n3 > 1) {
                int n6 = n3;
                while (n6 < n4 - 1) {
                    rectangleArray[n5++] = this.layout.getLineBounds(n6);
                    ++n6;
                }
            }
        }
        if (rectangleArray.length != n5) {
            Rectangle[] rectangleArray2 = new Rectangle[n5];
            System.arraycopy(rectangleArray, 0, rectangleArray2, 0, n5);
            rectangleArray = rectangleArray2;
        }
        return rectangleArray;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    int kEventAccessibleGetNamedAttribute(int n, int n2, int n3) {
        String string;
        int n4 = -9874;
        int[] nArray = new int[1];
        OS.GetEventParameter(n2, 1635020397, 1667658612, null, 4, null, nArray);
        int n5 = 0;
        if (nArray[0] != 0) {
            n5 = OS.CFStringGetLength(nArray[0]);
        }
        char[] cArray = new char[n5];
        CFRange cFRange = new CFRange();
        cFRange.length = n5;
        OS.CFStringGetCharacters(nArray[0], cFRange, cArray);
        String string2 = new String(cArray);
        if (string2.equals("AXRole") || string2.equals("AXRoleDescription")) {
            String string3 = "AXLink";
            cArray = new char[string3.length()];
            string3.getChars(0, cArray.length, cArray, 0);
            nArray[0] = OS.CFStringCreateWithCharacters(0, cArray, cArray.length);
            if (nArray[0] != 0) {
                if (string2.equals("AXRole")) {
                    OS.SetEventParameter(n2, 1635022444, 1667658612, 4, nArray);
                } else {
                    int n6 = OS.HICopyAccessibilityRoleDescription(nArray[0], 0);
                    OS.SetEventParameter(n2, 1635022444, 1667658612, 4, new int[]{n6});
                    OS.CFRelease(n6);
                }
                OS.CFRelease(nArray[0]);
                n4 = 0;
            }
        } else if ((string2.equals("AXTitle") || string2.equals("AXDescription")) && (string = this.parse(this.getText())) != null) {
            cArray = new char[string.length()];
            string.getChars(0, cArray.length, cArray, 0);
            nArray[0] = OS.CFStringCreateWithCharacters(0, cArray, cArray.length);
            if (nArray[0] != 0) {
                OS.SetEventParameter(n2, 1635022444, 1667658612, 4, nArray);
                OS.CFRelease(nArray[0]);
                n4 = 0;
            }
        }
        if (this.accessible != null) {
            n4 = this.accessible.internal_kEventAccessibleGetNamedAttribute(n, n2, n4);
        }
        return n4;
    }

    int kEventControlGetFocusPart(int n, int n2, int n3) {
        return 0;
    }

    int kEventControlSetFocusPart(int n, int n2, int n3) {
        int n4 = super.kEventControlSetFocusPart(n, n2, n3);
        if (n4 == 0) {
            this.redraw();
        }
        return n4;
    }

    int kEventMouseMoved(int n, int n2, int n3) {
        int n4 = super.kEventMouseMoved(n, n2, n3);
        if (n4 == 0) {
            return n4;
        }
        CGPoint cGPoint = new CGPoint();
        OS.GetEventParameter(n2, 2003660661, 1751740532, null, 8, null, cGPoint);
        OS.HIViewConvertPoint(cGPoint, 0, this.handle);
        int n5 = (int)cGPoint.x;
        int n6 = (int)cGPoint.y;
        int n7 = 0;
        while (n7 < this.offsets.length) {
            Rectangle[] rectangleArray = this.getRectangles(n7);
            int n8 = 0;
            while (n8 < rectangleArray.length) {
                Rectangle rectangle = rectangleArray[n8];
                if (rectangle.contains(n5, n6)) {
                    this.setCursor(this.display.getSystemCursor(21));
                    return n4;
                }
                ++n8;
            }
            ++n7;
        }
        this.setCursor(null);
        return n4;
    }

    int kEventUnicodeKeyPressed(int n, int n2, int n3) {
        int n4 = super.kEventUnicodeKeyPressed(n, n2, n3);
        if (n4 == 0) {
            return n4;
        }
        if (this.focusIndex == -1) {
            return n4;
        }
        int[] nArray = new int[1];
        OS.GetEventParameter(n2, 1953721189, 1702261350, null, nArray.length * 4, null, nArray);
        int[] nArray2 = new int[1];
        OS.GetEventParameter(nArray[0], 1801678692, 1835100014, null, nArray2.length * 4, null, nArray2);
        switch (nArray2[0]) {
            case 36: 
            case 49: 
            case 76: {
                Event event = new Event();
                event.text = this.ids[this.focusIndex];
                this.sendEvent(13, event);
                break;
            }
            case 48: {
                boolean bl;
                int[] nArray3 = new int[1];
                OS.GetEventParameter(nArray[0], 1802334052, 1835100014, null, 4, null, nArray3);
                boolean bl2 = bl = (nArray3[0] & 0x200) == 0;
                if (bl) {
                    if (this.focusIndex >= this.offsets.length - 1) break;
                    ++this.focusIndex;
                    this.redraw();
                    break;
                }
                if (this.focusIndex <= 0) break;
                --this.focusIndex;
                this.redraw();
            }
        }
        return n4;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.layout != null) {
            this.layout.dispose();
        }
        this.layout = null;
        if (this.linkColor != null) {
            this.linkColor.dispose();
        }
        this.linkColor = null;
        if (this.disabledColor != null) {
            this.disabledColor.dispose();
        }
        this.disabledColor = null;
        this.offsets = null;
        this.ids = null;
        this.mnemonics = null;
        this.text = null;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    String parse(String string) {
        int n;
        int n2;
        int n3 = string.length();
        this.offsets = new Point[n3 / 4];
        this.ids = new String[n3 / 4];
        this.mnemonics = new int[n3 / 4 + 1];
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[n3];
        string.getChars(0, string.length(), cArray, 0);
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        while (n4 < n3) {
            n2 = Character.toLowerCase(cArray[n4]);
            block0 : switch (n5) {
                case 0: {
                    if (n2 != 60) break;
                    n8 = n4;
                    ++n5;
                    break;
                }
                case 1: {
                    if (n2 != 97) break;
                    ++n5;
                    break;
                }
                case 2: {
                    switch (n2) {
                        case 104: {
                            n5 = 7;
                            break block0;
                        }
                        case 62: {
                            n9 = n4 + 1;
                            ++n5;
                            break block0;
                        }
                    }
                    if (Character.isWhitespace((char)n2)) break;
                    n5 = 13;
                    break;
                }
                case 3: {
                    if (n2 != 60) break;
                    n10 = n4;
                    ++n5;
                    break;
                }
                case 4: {
                    n5 = n2 == 47 ? n5 + 1 : 3;
                    break;
                }
                case 5: {
                    n5 = n2 == 97 ? n5 + 1 : 3;
                    break;
                }
                case 6: {
                    if (n2 == 62) {
                        this.mnemonics[n6] = this.parseMnemonics(cArray, n7, n8, stringBuffer);
                        n = stringBuffer.length();
                        this.parseMnemonics(cArray, n9, n10, stringBuffer);
                        this.offsets[n6] = new Point(n, stringBuffer.length() - 1);
                        if (this.ids[n6] == null) {
                            this.ids[n6] = new String(cArray, n9, n10 - n9);
                        }
                        ++n6;
                        n10 = n11 = n4 + 1;
                        n9 = n11;
                        n8 = n11;
                        n7 = n11;
                        n5 = 0;
                        break;
                    }
                    n5 = 3;
                    break;
                }
                case 7: {
                    n5 = n2 == 114 ? n5 + 1 : 0;
                    break;
                }
                case 8: {
                    n5 = n2 == 101 ? n5 + 1 : 0;
                    break;
                }
                case 9: {
                    n5 = n2 == 102 ? n5 + 1 : 0;
                    break;
                }
                case 10: {
                    n5 = n2 == 61 ? n5 + 1 : 0;
                    break;
                }
                case 11: {
                    if (n2 == 34) {
                        ++n5;
                        n11 = n4 + 1;
                        break;
                    }
                    n5 = 0;
                    break;
                }
                case 12: {
                    if (n2 != 34) break;
                    this.ids[n6] = new String(cArray, n11, n4 - n11);
                    n5 = 2;
                    break;
                }
                case 13: {
                    if (Character.isWhitespace((char)n2)) {
                        n5 = 0;
                        break;
                    }
                    if (n2 != 61) break;
                    ++n5;
                    break;
                }
                case 14: {
                    n5 = n2 == 34 ? n5 + 1 : 0;
                    break;
                }
                case 15: {
                    if (n2 != 34) break;
                    n5 = 2;
                    break;
                }
                default: {
                    n5 = 0;
                }
            }
            ++n4;
        }
        if (n7 < n3) {
            n2 = this.parseMnemonics(cArray, n7, n8, stringBuffer);
            n = this.parseMnemonics(cArray, Math.max(n8, n9), n3, stringBuffer);
            if (n == -1) {
                n = n2;
            }
            this.mnemonics[n6] = n;
        } else {
            this.mnemonics[n6] = -1;
        }
        if (this.offsets.length != n6) {
            Point[] pointArray = new Point[n6];
            System.arraycopy(this.offsets, 0, pointArray, 0, n6);
            this.offsets = pointArray;
            String[] stringArray = new String[n6];
            System.arraycopy(this.ids, 0, stringArray, 0, n6);
            this.ids = stringArray;
            int[] nArray = new int[n6 + 1];
            System.arraycopy(this.mnemonics, 0, nArray, 0, n6 + 1);
            this.mnemonics = nArray;
        }
        return stringBuffer.toString();
    }

    int parseMnemonics(char[] cArray, int n, int n2, StringBuffer stringBuffer) {
        int n3 = -1;
        int n4 = n;
        while (n4 < n2) {
            if (cArray[n4] == '&') {
                if (n4 + 1 < n2 && cArray[n4 + 1] == '&') {
                    stringBuffer.append(cArray[n4]);
                    ++n4;
                } else {
                    n3 = stringBuffer.length();
                }
            } else {
                stringBuffer.append(cArray[n4]);
            }
            ++n4;
        }
        return n3;
    }

    boolean sendMouseEvent(int n, short s, int n2, int n3, boolean bl, int n4, short s2, short s3, int n5) {
        boolean bl2 = super.sendMouseEvent(n, s, n2, n3, bl, n4, s2, s3, n5);
        switch (n) {
            case 3: {
                if (s != 1 || n2 != 1) break;
                int n6 = this.layout.getOffset(s2, s3, null);
                int n7 = this.selection.x;
                int n8 = this.selection.y;
                this.selection.x = n6;
                this.selection.y = -1;
                if (n7 != -1 && n8 != -1) {
                    if (n7 > n8) {
                        int n9 = n7;
                        n7 = n8;
                        n8 = n9;
                    }
                    Rectangle rectangle = this.layout.getBounds(n7, n8);
                    this.redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
                }
                int n10 = 0;
                while (n10 < this.offsets.length) {
                    Rectangle[] rectangleArray = this.getRectangles(n10);
                    int n11 = 0;
                    while (n11 < rectangleArray.length) {
                        Rectangle rectangle = rectangleArray[n11];
                        if (rectangle.contains(s2, s3)) {
                            this.focusIndex = n10;
                            this.redraw();
                            this.setFocus();
                            return bl2;
                        }
                        ++n11;
                    }
                    ++n10;
                }
                break;
            }
            case 5: {
                if ((n4 & 1) == 0) break;
                int n12 = this.selection.y;
                this.selection.y = this.layout.getOffset(s2, s3, null);
                if (this.selection.y == n12) break;
                int n13 = this.selection.y;
                if (n12 > n13) {
                    int n14 = n12;
                    n12 = n13;
                    n13 = n14;
                }
                Rectangle rectangle = this.layout.getBounds(n12, n13);
                this.redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
                break;
            }
            case 4: {
                if (this.focusIndex == -1 || s != 1) break;
                Rectangle[] rectangleArray = this.getRectangles(this.focusIndex);
                int n15 = 0;
                while (n15 < rectangleArray.length) {
                    Rectangle rectangle = rectangleArray[n15];
                    if (rectangle.contains(s2, s3)) {
                        Event event = new Event();
                        event.text = this.ids[this.focusIndex];
                        this.notifyListeners(13, event);
                        return bl2;
                    }
                    ++n15;
                }
                break;
            }
        }
        return bl2;
    }

    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3) {
        int n5 = super.setBounds(n, n2, n3, n4, bl, bl2, bl3);
        if ((n5 & 0x80) != 0) {
            this.layout.setWidth(n3 > 0 ? n3 : -1);
        }
        return n5;
    }

    void setFontStyle(Font font) {
        super.setFontStyle(font);
        this.layout.setFont(this.getFont());
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(this.text)) {
            return;
        }
        this.text = string;
        this.layout.setText(this.parse(string));
        this.focusIndex = this.offsets.length > 0 ? 0 : -1;
        this.selection.y = -1;
        this.selection.x = -1;
        boolean bl = (this.state & 8) == 0;
        TextStyle textStyle = new TextStyle(null, bl ? this.linkColor : this.disabledColor, null);
        textStyle.underline = true;
        int n = 0;
        while (n < this.offsets.length) {
            Point point = this.offsets[n];
            this.layout.setStyle(textStyle, point.x, point.y);
            ++n;
        }
        this.redraw();
    }

    int traversalCode(int n, int n2) {
        if (this.offsets.length == 0) {
            return 0;
        }
        int n3 = super.traversalCode(n, n2);
        if (n == 48 && n2 != 0) {
            boolean bl;
            int[] nArray = new int[1];
            OS.GetEventParameter(n2, 1802334052, 1835100014, null, 4, null, nArray);
            boolean bl2 = bl = (nArray[0] & 0x200) == 0;
            if (bl && this.focusIndex < this.offsets.length - 1) {
                return n3 & 0xFFFFFFEF;
            }
            if (!bl && this.focusIndex > 0) {
                return n3 & 0xFFFFFFF7;
            }
        }
        return n3;
    }
}

