/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.gltrace.views.detail;

import com.android.ide.eclipse.gltrace.state.GLCompositeProperty;
import com.android.ide.eclipse.gltrace.state.GLStateType;
import com.android.ide.eclipse.gltrace.state.GLStringProperty;
import com.android.ide.eclipse.gltrace.state.IGLProperty;
import com.android.ide.eclipse.gltrace.views.detail.IStateDetailProvider;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class ShaderSourceDetailsProvider
implements IStateDetailProvider {
    private Text mTextControl;

    @Override
    public boolean isApplicable(IGLProperty state) {
        return this.getShaderSourceProperty(state) != null;
    }

    @Override
    public void createControl(Composite parent) {
        this.mTextControl = new Text(parent, 2890);
        this.mTextControl.setEditable(false);
    }

    @Override
    public void disposeControl() {
    }

    @Override
    public Control getControl() {
        return this.mTextControl;
    }

    @Override
    public void updateControl(IGLProperty state) {
        IGLProperty shaderSrcProperty = this.getShaderSourceProperty(state);
        if (shaderSrcProperty instanceof GLStringProperty) {
            String shaderSrc = ((GLStringProperty)shaderSrcProperty).getStringValue();
            this.mTextControl.setText(shaderSrc);
            this.mTextControl.setEnabled(true);
        } else {
            this.mTextControl.setText("");
            this.mTextControl.setEnabled(false);
        }
    }

    private IGLProperty getShaderSourceProperty(IGLProperty state) {
        if (state.getType() == GLStateType.SHADER_SOURCE) {
            return state;
        }
        if (state.getType() != GLStateType.PER_SHADER_STATE) {
            state = state.getParent();
        }
        if (state != null && state.getType() == GLStateType.PER_SHADER_STATE) {
            return ((GLCompositeProperty)state).getProperty(GLStateType.SHADER_SOURCE);
        }
        return null;
    }

    @Override
    public List<IContributionItem> getToolBarItems() {
        return Collections.emptyList();
    }
}

