/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.manifmerger.MergingReport;
import com.android.manifmerger.XmlAttribute;
import com.android.manifmerger.XmlNode;
import com.google.common.base.Joiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class AttributeModel {
    @NonNull
    private final XmlNode.NodeName mName;
    private final boolean mIsPackageDependent;
    @Nullable
    private final String mDefaultValue;
    @Nullable
    private final Validator mOnReadValidator;
    @Nullable
    private final Validator mOnWriteValidator;
    @NonNull
    private final MergingPolicy mMergingPolicy;
    static final MergingPolicy STRICT_MERGING_POLICY = new MergingPolicy(){

        @Override
        public boolean shouldMergeDefaultValues() {
            return false;
        }

        @Override
        @Nullable
        public String merge(@NonNull String higherPriority, @NonNull String lowerPriority) {
            return higherPriority.equals(lowerPriority) ? higherPriority : null;
        }
    };
    static final MergingPolicy OR_MERGING_POLICY = new MergingPolicy(){

        @Override
        public boolean shouldMergeDefaultValues() {
            return true;
        }

        @Override
        @Nullable
        public String merge(@NonNull String higherPriority, @NonNull String lowerPriority) {
            return Boolean.toString(BooleanValidator.isTrue(higherPriority) || BooleanValidator.isTrue(lowerPriority));
        }
    };
    static final MergingPolicy NO_MERGING_POLICY = new MergingPolicy(){

        @Override
        public boolean shouldMergeDefaultValues() {
            return true;
        }

        @Override
        @Nullable
        public String merge(@NonNull String higherPriority, @NonNull String lowerPriority) {
            return higherPriority;
        }
    };

    private AttributeModel(@NonNull XmlNode.NodeName name, boolean isPackageDependent, @Nullable String defaultValue, @Nullable Validator onReadValidator, @Nullable Validator onWriteValidator, @NonNull MergingPolicy mergingPolicy) {
        this.mName = name;
        this.mIsPackageDependent = isPackageDependent;
        this.mDefaultValue = defaultValue;
        this.mOnReadValidator = onReadValidator;
        this.mOnWriteValidator = onWriteValidator;
        this.mMergingPolicy = mergingPolicy;
    }

    @NonNull
    XmlNode.NodeName getName() {
        return this.mName;
    }

    boolean isPackageDependent() {
        return this.mIsPackageDependent;
    }

    @Nullable
    String getDefaultValue() {
        return this.mDefaultValue;
    }

    @Nullable
    public Validator getOnReadValidator() {
        return this.mOnReadValidator;
    }

    @Nullable
    public Validator getOnWriteValidator() {
        return this.mOnWriteValidator;
    }

    @NonNull
    public MergingPolicy getMergingPolicy() {
        return this.mMergingPolicy;
    }

    static Builder newModel(String attributeName) {
        return new Builder(attributeName);
    }

    private static int decodeDecOrHexString(String s) {
        long decodedValue;
        long l = decodedValue = s.startsWith("0x") || s.startsWith("0X") ? Long.decode(s) : Long.parseLong(s);
        if (decodedValue < 0xFFFFFFFFL) {
            return (int)decodedValue;
        }
        throw new IllegalArgumentException("Value " + s + " too big for 32 bits.");
    }

    static class Hexadecimal32BitsWithMinimumValue
    extends Hexadecimal32Bits {
        private final int mMinimumValue;

        Hexadecimal32BitsWithMinimumValue(int minimumValue) {
            this.mMinimumValue = minimumValue;
        }

        @Override
        public boolean validates(@NonNull MergingReport.Builder mergingReport, @NonNull XmlAttribute attribute, @NonNull String value) {
            boolean valid = super.validates(mergingReport, attribute, value);
            if (valid) {
                try {
                    Long decodedValue = Long.decode(value);
                    valid = decodedValue >= (long)this.mMinimumValue && decodedValue < 0xFFFFFFFFL;
                }
                catch (NumberFormatException e) {
                    valid = false;
                }
                if (!valid) {
                    attribute.addMessage(mergingReport, MergingReport.Record.Severity.ERROR, String.format("Attribute %1$s at %2$s is not a valid hexadecimal value, minimum is 0x%3$08X, maximum is 0x%4$08X, found %5$s", attribute.getId(), attribute.printPosition(), this.mMinimumValue, Integer.MAX_VALUE, value));
                }
                return valid;
            }
            return false;
        }
    }

    static class Hexadecimal32Bits
    implements Validator {
        protected static final Pattern PATTERN = Pattern.compile("0[xX]([0-9a-fA-F]+)");

        Hexadecimal32Bits() {
        }

        @Override
        public boolean validates(@NonNull MergingReport.Builder mergingReport, @NonNull XmlAttribute attribute, @NonNull String value) {
            boolean valid;
            Matcher matcher = PATTERN.matcher(value);
            boolean bl = valid = matcher.matches() && matcher.group(1).length() <= 8;
            if (!valid) {
                attribute.addMessage(mergingReport, MergingReport.Record.Severity.ERROR, String.format("Attribute %1$s at %2$s is not a valid hexadecimal 32 bit value, found %3$s", attribute.getId(), attribute.printPosition(), value));
            }
            return valid;
        }
    }

    static class IntegerValueValidator
    implements Validator {
        IntegerValueValidator() {
        }

        @Override
        public boolean validates(@NonNull MergingReport.Builder mergingReport, @NonNull XmlAttribute attribute, @NonNull String value) {
            try {
                return Integer.parseInt(value) > 0;
            }
            catch (NumberFormatException e) {
                attribute.addMessage(mergingReport, MergingReport.Record.Severity.ERROR, String.format("Attribute %1$s at %2$s must be an integer, found %3$s", attribute.getId(), attribute.printPosition(), value));
                return false;
            }
        }
    }

    static class MultiValueValidator
    implements Validator {
        private final String[] multiValues;
        private final String allValues;

        MultiValueValidator(String ... multiValues) {
            this.multiValues = multiValues;
            this.allValues = Joiner.on(',').join(multiValues);
        }

        @Override
        public boolean validates(@NonNull MergingReport.Builder mergingReport, @NonNull XmlAttribute attribute, @NonNull String value) {
            for (String multiValue : this.multiValues) {
                if (!multiValue.equals(value)) continue;
                return true;
            }
            attribute.addMessage(mergingReport, MergingReport.Record.Severity.ERROR, String.format("Invalid value for attribute %1$s at %2$s, value=(%3$s), acceptable values are (%4$s)", attribute.getId(), attribute.printPosition(), value, this.allValues));
            return false;
        }
    }

    static class BooleanValidator
    implements Validator {
        private static final Pattern TRUE_PATTERN = Pattern.compile("true|True|TRUE");
        private static final Pattern FALSE_PATTERN = Pattern.compile("false|False|FALSE");

        BooleanValidator() {
        }

        private static boolean isTrue(String value) {
            return TRUE_PATTERN.matcher(value).matches();
        }

        @Override
        public boolean validates(@NonNull MergingReport.Builder mergingReport, @NonNull XmlAttribute attribute, @NonNull String value) {
            boolean matches;
            boolean bl = matches = TRUE_PATTERN.matcher(value).matches() || FALSE_PATTERN.matcher(value).matches();
            if (!matches) {
                attribute.addMessage(mergingReport, MergingReport.Record.Severity.ERROR, String.format("Attribute %1$s at %2$s has an illegal value=(%3$s), expected 'true' or 'false'", attribute.getId(), attribute.printPosition(), value));
            }
            return matches;
        }
    }

    static interface Validator {
        public boolean validates(@NonNull MergingReport.Builder var1, @NonNull XmlAttribute var2, @NonNull String var3);
    }

    static interface MergingPolicy {
        public boolean shouldMergeDefaultValues();

        @Nullable
        public String merge(@NonNull String var1, @NonNull String var2);
    }

    static class Builder {
        private final String mName;
        private boolean mIsPackageDependent = false;
        private String mDefaultValue;
        private Validator mOnReadValidator;
        private Validator mOnWriteValidator;
        private MergingPolicy mMergingPolicy = STRICT_MERGING_POLICY;

        Builder(String name) {
            this.mName = name;
        }

        Builder setIsPackageDependent() {
            this.mIsPackageDependent = true;
            return this;
        }

        Builder setDefaultValue(String value) {
            this.mDefaultValue = value;
            return this;
        }

        Builder setOnReadValidator(Validator validator) {
            this.mOnReadValidator = validator;
            return this;
        }

        Builder setOnWriteValidator(Validator validator) {
            this.mOnWriteValidator = validator;
            return this;
        }

        Builder setMergingPolicy(MergingPolicy mergingPolicy) {
            this.mMergingPolicy = mergingPolicy;
            return this;
        }

        AttributeModel build() {
            return new AttributeModel(XmlNode.fromXmlName("android:" + this.mName), this.mIsPackageDependent, this.mDefaultValue, this.mOnReadValidator, this.mOnWriteValidator, this.mMergingPolicy);
        }
    }
}

