/*
 * Decompiled with CFR 0.152.
 */
package com.android.monkeyrunner.controller;

import com.android.chimpchat.core.IChimpDevice;
import com.google.common.collect.Sets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;

public class VariableFrame
extends JFrame {
    private static final Logger LOG = Logger.getLogger(VariableFrame.class.getName());
    private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool();
    private IChimpDevice device;

    private static <E> E getNthElement(Set<E> set, int offset) {
        int current = 0;
        for (E elem : set) {
            if (current == offset) {
                return elem;
            }
            ++current;
        }
        return null;
    }

    public VariableFrame() {
        super("Variables");
        this.setDefaultCloseOperation(1);
        this.setLayout(new BoxLayout(this.getContentPane(), 1));
        final VariableTableModel tableModel = new VariableTableModel();
        JButton refreshButton = new JButton("Refresh");
        this.add(refreshButton);
        refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                tableModel.refresh();
            }
        });
        JTable table = new JTable(tableModel);
        this.add(table);
        tableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                VariableFrame.this.pack();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                tableModel.refresh();
            }
        });
        this.pack();
    }

    public void init(IChimpDevice device) {
        this.device = device;
    }

    private class VariableTableModel
    extends AbstractTableModel {
        private final TreeSet<VariableHolder> set = Sets.newTreeSet();

        private VariableTableModel() {
        }

        public void refresh() {
            Collection variables = VariableFrame.this.device.getPropertyList();
            for (final String variable : variables) {
                EXECUTOR.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        String value = VariableFrame.this.device.getProperty(variable);
                        if (value == null) {
                            value = "";
                        }
                        TreeSet treeSet = VariableTableModel.this.set;
                        synchronized (treeSet) {
                            VariableTableModel.this.set.add(new VariableHolder(variable, value));
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    VariableTableModel.this.fireTableDataChanged();
                                }
                            });
                        }
                    }
                });
            }
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getRowCount() {
            TreeSet<VariableHolder> treeSet = this.set;
            synchronized (treeSet) {
                return this.set.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            VariableHolder nthElement;
            TreeSet<VariableHolder> treeSet = this.set;
            synchronized (treeSet) {
                nthElement = (VariableHolder)VariableFrame.getNthElement(this.set, rowIndex);
            }
            if (columnIndex == 0) {
                return nthElement.getKey();
            }
            return nthElement.getValue();
        }
    }

    private static class VariableHolder
    implements Comparable<VariableHolder> {
        private final String key;
        private final String value;

        public VariableHolder(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        @Override
        public int compareTo(VariableHolder o) {
            return this.key.compareTo(o.key);
        }
    }
}

