/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.ui;

import com.android.SdkConstants;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public abstract class SwtBaseDialog
extends Dialog {
    private static final int MIN_Y = SdkConstants.CURRENT_PLATFORM == 3 ? 20 : 0;
    private static Map<Class<?>, Point> sLastSizeMap = new HashMap();
    private volatile boolean mQuitRequested = false;
    private boolean mReturnValue;
    private Shell mShell;

    public SwtBaseDialog(Shell parent, int swtStyle, String title) {
        super(parent, swtStyle);
        if (title != null) {
            this.setText(title);
        }
    }

    public boolean open() {
        if (!this.mQuitRequested) {
            this.createShell();
        }
        if (!this.mQuitRequested) {
            this.createContents();
        }
        if (!this.mQuitRequested) {
            this.positionShell();
        }
        if (!this.mQuitRequested) {
            this.postCreate();
        }
        if (!this.mQuitRequested) {
            this.mShell.open();
            this.mShell.layout();
            this.eventLoop();
        }
        return this.mReturnValue;
    }

    protected void createShell() {
        this.mShell = new Shell(this.getParent(), 67696);
        this.mShell.setMinimumSize(new Point(450, 300));
        this.mShell.setSize(450, 300);
        if (this.getText() != null) {
            this.mShell.setText(this.getText());
        }
        this.mShell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SwtBaseDialog.this.saveSize();
            }
        });
    }

    protected abstract void createContents();

    protected abstract void postCreate();

    protected void eventLoop() {
        Display display = this.getParent().getDisplay();
        while (!this.mQuitRequested && !this.mShell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    protected boolean getReturnValue() {
        return this.mReturnValue;
    }

    protected void setReturnValue(boolean returnValue) {
        this.mReturnValue = returnValue;
    }

    protected Shell getShell() {
        return this.mShell;
    }

    protected void close() {
        if (this.mShell != null && !this.mShell.isDisposed()) {
            this.saveSize();
            this.getShell().close();
        }
        this.mQuitRequested = true;
    }

    private void positionShell() {
        Shell child = this.mShell;
        Shell parent = this.getParent();
        if (child != null && parent != null) {
            int y;
            Rectangle parentArea = parent.getClientArea();
            Point parentLoc = parent.getLocation();
            int px = parentLoc.x;
            int py = parentLoc.y;
            int pw = parentArea.width;
            int ph = parentArea.height;
            Point childSize = sLastSizeMap.get(((Object)((Object)this)).getClass());
            if (childSize == null) {
                childSize = child.getSize();
            }
            int cw = childSize.x;
            int ch = childSize.y;
            int x = px + (pw - cw) / 2;
            if (x < 0) {
                x = 0;
            }
            if ((y = py + (ph - ch) / 2) < MIN_Y) {
                y = MIN_Y;
            }
            child.setLocation(x, y);
            child.setSize(cw, ch);
        }
    }

    private void saveSize() {
        if (this.mShell != null && !this.mShell.isDisposed()) {
            sLastSizeMap.put(((Object)((Object)this)).getClass(), this.mShell.getSize());
        }
    }
}

