/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.bidi.internal;

import org.eclipse.equinox.bidi.advanced.ISTextExpert;
import org.eclipse.equinox.bidi.custom.STextCharTypes;
import org.eclipse.equinox.bidi.custom.STextOffsets;
import org.eclipse.equinox.bidi.custom.STextTypeHandler;

public abstract class STextDelims
extends STextTypeHandler {
    public STextDelims() {
    }

    public STextDelims(String separators) {
        super(separators);
    }

    public int indexOfSpecial(ISTextExpert expert, String text, STextCharTypes charTypes, STextOffsets offsets, int caseNumber, int fromIndex) {
        char delim = this.getDelimiters().charAt((caseNumber - 1) * 2);
        return text.indexOf(delim, fromIndex);
    }

    public int processSpecial(ISTextExpert expert, String text, STextCharTypes charTypes, STextOffsets offsets, int caseNumber, int separLocation) {
        STextTypeHandler.processSeparator(text, charTypes, offsets, separLocation);
        int loc = separLocation + 1;
        char delim = this.getDelimiters().charAt(caseNumber * 2 - 1);
        loc = text.indexOf(delim, loc);
        if (loc < 0) {
            return text.length();
        }
        return loc + 1;
    }

    protected abstract String getDelimiters();
}

