/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.bidi.advanced;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.equinox.bidi.STextProcessor;
import org.eclipse.equinox.bidi.STextTypeHandlerFactory;
import org.eclipse.equinox.bidi.advanced.ISTextExpert;
import org.eclipse.equinox.bidi.advanced.STextEnvironment;
import org.eclipse.equinox.bidi.custom.STextTypeHandler;
import org.eclipse.equinox.bidi.internal.STextImpl;

public final class STextExpertFactory {
    private static final String defaultSeparators = STextProcessor.getDefaultSeparators();
    private static Map sharedDefaultExperts = new HashMap();
    private static Map sharedExperts = new HashMap();
    private static ISTextExpert defaultExpert;

    private STextExpertFactory() {
    }

    public static ISTextExpert getExpert() {
        if (defaultExpert == null) {
            STextTypeHandler handler = new STextTypeHandler(defaultSeparators);
            defaultExpert = new STextImpl(handler, STextEnvironment.DEFAULT, false);
        }
        return defaultExpert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ISTextExpert getExpert(String type) {
        ISTextExpert expert;
        Map map = sharedDefaultExperts;
        synchronized (map) {
            expert = (ISTextExpert)sharedDefaultExperts.get(type);
            if (expert == null) {
                STextTypeHandler handler = STextTypeHandlerFactory.getHandler(type);
                if (handler == null) {
                    throw new IllegalArgumentException("Invalid type argument");
                }
                expert = new STextImpl(handler, STextEnvironment.DEFAULT, false);
                sharedDefaultExperts.put(type, expert);
            }
        }
        return expert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ISTextExpert getExpert(String type, STextEnvironment environment) {
        ISTextExpert expert;
        if (environment == null) {
            environment = STextEnvironment.DEFAULT;
        }
        Map map = sharedExperts;
        synchronized (map) {
            HashMap<String, ISTextExpert> experts = (HashMap<String, ISTextExpert>)sharedExperts.get(type);
            if (experts == null) {
                experts = new HashMap<String, ISTextExpert>();
                sharedExperts.put(type, experts);
            }
            if ((expert = (ISTextExpert)experts.get(environment)) == null) {
                STextTypeHandler handler = STextTypeHandlerFactory.getHandler(type);
                if (handler == null) {
                    throw new IllegalArgumentException("Invalid type argument");
                }
                expert = new STextImpl(handler, environment, false);
                experts.put(type, expert);
            }
        }
        return expert;
    }

    public static ISTextExpert getStatefulExpert(String type) {
        return STextExpertFactory.getStatefulExpert(type, STextEnvironment.DEFAULT);
    }

    public static ISTextExpert getStatefulExpert(String type, STextEnvironment environment) {
        STextTypeHandler handler = STextTypeHandlerFactory.getHandler(type);
        if (handler == null) {
            throw new IllegalArgumentException("Invalid type argument");
        }
        return STextExpertFactory.getStatefulExpert(handler, environment);
    }

    public static ISTextExpert getStatefulExpert(STextTypeHandler handler, STextEnvironment environment) {
        if (environment == null) {
            environment = STextEnvironment.DEFAULT;
        }
        return new STextImpl(handler, environment, true);
    }
}

