/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceDeltaKind;
import com.android.ide.common.resources.ResourceFile;
import com.android.ide.common.resources.ResourceFolder;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceUrl;
import com.android.ide.common.resources.ScanningContext;
import com.android.ide.common.resources.configuration.Configurable;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LanguageQualifier;
import com.android.ide.common.resources.configuration.RegionQualifier;
import com.android.io.IAbstractFile;
import com.android.io.IAbstractFolder;
import com.android.io.IAbstractResource;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public abstract class ResourceRepository {
    private final IAbstractFolder mResourceFolder;
    protected Map<ResourceFolderType, List<ResourceFolder>> mFolderMap = new EnumMap<ResourceFolderType, List<ResourceFolder>>(ResourceFolderType.class);
    protected Map<ResourceType, Map<String, ResourceItem>> mResourceMap = new EnumMap<ResourceType, Map<String, ResourceItem>>(ResourceType.class);
    private Map<Map<String, ResourceItem>, Collection<ResourceItem>> mReadOnlyListMap = new IdentityHashMap<Map<String, ResourceItem>, Collection<ResourceItem>>();
    private final boolean mFrameworkRepository;
    private boolean mCleared = true;
    private boolean mInitializing = false;

    protected ResourceRepository(@NonNull IAbstractFolder resFolder, boolean isFrameworkRepository) {
        this.mResourceFolder = resFolder;
        this.mFrameworkRepository = isFrameworkRepository;
    }

    public IAbstractFolder getResFolder() {
        return this.mResourceFolder;
    }

    public boolean isFrameworkRepository() {
        return this.mFrameworkRepository;
    }

    public synchronized void clear() {
        this.mCleared = true;
        this.mFolderMap = new EnumMap<ResourceFolderType, List<ResourceFolder>>(ResourceFolderType.class);
        this.mResourceMap = new EnumMap<ResourceType, Map<String, ResourceItem>>(ResourceType.class);
        this.mReadOnlyListMap = new IdentityHashMap<Map<String, ResourceItem>, Collection<ResourceItem>>();
    }

    public synchronized boolean ensureInitialized() {
        if (this.mCleared && !this.mInitializing) {
            IAbstractResource[] resources;
            ScanningContext context = new ScanningContext(this);
            this.mInitializing = true;
            for (IAbstractResource res : resources = this.mResourceFolder.listMembers()) {
                IAbstractResource[] files;
                IAbstractFolder folder;
                ResourceFolder resFolder;
                if (!(res instanceof IAbstractFolder) || (resFolder = this.processFolder(folder = (IAbstractFolder)res)) == null) continue;
                for (IAbstractResource fileRes : files = folder.listMembers()) {
                    if (!(fileRes instanceof IAbstractFile)) continue;
                    IAbstractFile file = (IAbstractFile)fileRes;
                    resFolder.processFile(file, ResourceDeltaKind.ADDED, context);
                }
            }
            this.mInitializing = false;
            this.mCleared = false;
            return true;
        }
        return false;
    }

    private ResourceFolder add(@NonNull ResourceFolderType type, @NonNull FolderConfiguration config, @NonNull IAbstractFolder folder) {
        List<ResourceFolder> list = this.mFolderMap.get((Object)type);
        if (list == null) {
            list = new ArrayList<ResourceFolder>();
            ResourceFolder cf = new ResourceFolder(type, config, folder, this);
            list.add(cf);
            this.mFolderMap.put(type, list);
            return cf;
        }
        for (ResourceFolder cFolder : list) {
            if (!cFolder.mConfiguration.equals(config)) continue;
            cFolder.mFolder = folder;
            return cFolder;
        }
        ResourceFolder cf = new ResourceFolder(type, config, folder, this);
        list.add(cf);
        return cf;
    }

    @Nullable
    public ResourceFolder removeFolder(@NonNull ResourceFolderType type, @NonNull IAbstractFolder removedFolder, @Nullable ScanningContext context) {
        this.ensureInitialized();
        List<ResourceFolder> list = this.mFolderMap.get((Object)type);
        if (list != null) {
            int count = list.size();
            for (int i = 0; i < count; ++i) {
                ResourceFolder resFolder = list.get(i);
                IAbstractFolder folder = resFolder.getFolder();
                if (!removedFolder.equals(folder)) continue;
                list.remove(i);
                resFolder.dispose(context);
                return resFolder;
            }
        }
        return null;
    }

    public boolean hasResourceItem(@NonNull String url) {
        if (url.startsWith("?")) {
            String remainder = url.substring("?".length());
            if (url.startsWith("?attr/")) {
                url = "@" + url.substring("?".length());
                return this.hasResourceItem(url);
            }
            int colon = url.indexOf(58);
            if (colon != -1) {
                if (remainder.indexOf(47, colon) == -1) {
                    remainder = remainder.substring(0, colon) + "attr" + '/' + remainder.substring(colon);
                }
                url = "@" + remainder;
                return this.hasResourceItem(url);
            }
            int slash = url.indexOf(47);
            if (slash == -1) {
                url = "@attr/" + remainder;
                return this.hasResourceItem(url);
            }
        }
        if (!url.startsWith("@")) {
            return false;
        }
        assert (url.startsWith("@") || url.startsWith("?")) : url;
        this.ensureInitialized();
        int typeEnd = url.indexOf(47, 1);
        if (typeEnd != -1) {
            String typeName;
            ResourceType type;
            int nameBegin = typeEnd + 1;
            int typeBegin = url.startsWith("@+") ? 2 : 1;
            int colon = url.lastIndexOf(58, typeEnd);
            if (colon != -1) {
                typeBegin = colon + 1;
            }
            if ((type = ResourceType.getEnum(typeName = url.substring(typeBegin, typeEnd))) != null) {
                String name = url.substring(nameBegin);
                return this.hasResourceItem(type, name);
            }
        }
        return false;
    }

    public boolean hasResourceItem(@NonNull ResourceType type, @NonNull String name) {
        ResourceItem resourceItem;
        this.ensureInitialized();
        Map<String, ResourceItem> map = this.mResourceMap.get((Object)type);
        return map != null && (resourceItem = map.get(name)) != null;
    }

    @NonNull
    public ResourceItem getResourceItem(@NonNull ResourceType type, @NonNull String name) {
        this.ensureInitialized();
        ResourceItem item = this.findDeclaredResourceItem(type, name);
        if (item == null || item.isDeclaredInline()) {
            ResourceItem oldItem = item != null && item.isDeclaredInline() ? item : null;
            item = this.createResourceItem(name);
            Map<String, ResourceItem> map = this.mResourceMap.get((Object)type);
            if (map == null) {
                if (this.isFrameworkRepository()) {
                    int size;
                    switch (type) {
                        case PUBLIC: {
                            size = 1734;
                            break;
                        }
                        case DRAWABLE: {
                            size = 1508;
                            break;
                        }
                        case STRING: {
                            size = 1255;
                            break;
                        }
                        case ATTR: {
                            size = 1064;
                            break;
                        }
                        case STYLE: {
                            size = 783;
                            break;
                        }
                        case ID: {
                            size = 347;
                            break;
                        }
                        case DECLARE_STYLEABLE: {
                            size = 210;
                            break;
                        }
                        case LAYOUT: {
                            size = 187;
                            break;
                        }
                        case COLOR: {
                            size = 120;
                            break;
                        }
                        case ANIM: {
                            size = 95;
                            break;
                        }
                        case DIMEN: {
                            size = 81;
                            break;
                        }
                        case BOOL: {
                            size = 54;
                            break;
                        }
                        case INTEGER: {
                            size = 52;
                            break;
                        }
                        case ARRAY: {
                            size = 51;
                            break;
                        }
                        case PLURALS: {
                            size = 20;
                            break;
                        }
                        case XML: {
                            size = 14;
                            break;
                        }
                        case INTERPOLATOR: {
                            size = 13;
                            break;
                        }
                        case ANIMATOR: {
                            size = 8;
                            break;
                        }
                        case RAW: {
                            size = 4;
                            break;
                        }
                        case MENU: {
                            size = 2;
                            break;
                        }
                        case MIPMAP: {
                            size = 2;
                            break;
                        }
                        case FRACTION: {
                            size = 1;
                            break;
                        }
                        default: {
                            size = 2;
                        }
                    }
                    map = new HashMap<String, ResourceItem>(size, 1.0f);
                } else {
                    map = new HashMap<String, ResourceItem>();
                }
                this.mResourceMap.put(type, map);
            }
            map.put(item.getName(), item);
            if (oldItem != null) {
                map.remove(oldItem.getName());
            }
        }
        return item;
    }

    @NonNull
    protected abstract ResourceItem createResourceItem(@NonNull String var1);

    @Nullable
    public ResourceFolder processFolder(@NonNull IAbstractFolder folder) {
        FolderConfiguration config;
        this.ensureInitialized();
        String[] folderSegments = folder.getName().split("-");
        ResourceFolderType type = ResourceFolderType.getTypeByName(folderSegments[0]);
        if (type != null && (config = FolderConfiguration.getConfig(folderSegments)) != null) {
            return this.add(type, config, folder);
        }
        return null;
    }

    @Nullable
    public List<ResourceFolder> getFolders(@NonNull ResourceFolderType type) {
        this.ensureInitialized();
        return this.mFolderMap.get((Object)type);
    }

    @NonNull
    public List<ResourceType> getAvailableResourceTypes() {
        this.ensureInitialized();
        ArrayList<ResourceType> list = new ArrayList<ResourceType>();
        for (ResourceFolderType folderType : this.mFolderMap.keySet()) {
            List<ResourceType> types = FolderTypeRelationship.getRelatedResourceTypes(folderType);
            if (types.size() == 1) {
                if (list.contains((Object)types.get(0))) continue;
                list.add(types.get(0));
                continue;
            }
            List<ResourceFolder> folders = this.mFolderMap.get((Object)folderType);
            if (folders == null) continue;
            for (ResourceFolder folder : folders) {
                Collection<ResourceType> folderContent = folder.getResourceTypes();
                for (ResourceType folderResType : folderContent) {
                    if (list.contains((Object)folderResType)) continue;
                    list.add(folderResType);
                }
            }
        }
        return list;
    }

    @NonNull
    public Collection<ResourceItem> getResourceItemsOfType(@NonNull ResourceType type) {
        this.ensureInitialized();
        Map<String, ResourceItem> map = this.mResourceMap.get((Object)type);
        if (map == null) {
            return Collections.emptyList();
        }
        Collection<ResourceItem> roList = this.mReadOnlyListMap.get(map);
        if (roList == null) {
            roList = Collections.unmodifiableCollection(map.values());
            this.mReadOnlyListMap.put(map, roList);
        }
        return roList;
    }

    public boolean hasResourcesOfType(@NonNull ResourceType type) {
        this.ensureInitialized();
        Map<String, ResourceItem> items = this.mResourceMap.get((Object)type);
        return items != null && items.size() > 0;
    }

    @Nullable
    public ResourceFolder getResourceFolder(@NonNull IAbstractFolder folder) {
        this.ensureInitialized();
        Collection<List<ResourceFolder>> values = this.mFolderMap.values();
        for (List<ResourceFolder> list : values) {
            for (ResourceFolder resFolder : list) {
                IAbstractFolder wrapper = resFolder.getFolder();
                if (!wrapper.equals(folder)) continue;
                return resFolder;
            }
        }
        return null;
    }

    @Nullable
    public ResourceFile getMatchingFile(@NonNull String name, @NonNull ResourceFolderType type, @NonNull FolderConfiguration config) {
        List<ResourceType> types = FolderTypeRelationship.getRelatedResourceTypes(type);
        for (ResourceType t : types) {
            ResourceFile match;
            if (t == ResourceType.ID || (match = this.getMatchingFile(name, t, config)) == null) continue;
            return match;
        }
        return null;
    }

    @Nullable
    public ResourceFile getMatchingFile(@NonNull String name, @NonNull ResourceType type, @NonNull FolderConfiguration config) {
        List<ResourceFile> files;
        ResourceItem item;
        Map<String, ResourceItem> items;
        this.ensureInitialized();
        String resourceName = name;
        int dot = resourceName.indexOf(46);
        if (dot != -1) {
            resourceName = resourceName.substring(0, dot);
        }
        if ((items = this.mResourceMap.get((Object)type)) != null && (item = items.get(resourceName)) != null && (files = item.getSourceFileList()) != null) {
            ResourceFile matchingFile;
            if (files.size() > 1) {
                String v;
                ResourceValue value = item.getResourceValue(type, config, this.isFrameworkRepository());
                if (value != null && (v = value.getValue()) != null) {
                    ResourceFile f2;
                    ResourceUrl url = ResourceUrl.parse(v);
                    if (url != null) {
                        return this.getMatchingFile(url.name, url.type, config);
                    }
                    for (ResourceFile f2 : files) {
                        if (!v.equals(f2.getFile().getOsLocation())) continue;
                        return f2;
                    }
                    File file = new File(v);
                    if (file.exists() && (f2 = this.findResourceFile(file)) != null) {
                        return f2;
                    }
                }
            } else if (files.size() == 1 && (matchingFile = files.get(0)).getFolder().getConfiguration().isMatchFor(config)) {
                return matchingFile;
            }
        }
        return null;
    }

    @Nullable
    protected ResourceFile findResourceFile(@NonNull File file) {
        String parentName = file.getParentFile().getName();
        IAbstractFolder folder = this.getResFolder().getFolder(parentName);
        if (folder != null) {
            ResourceFile resourceFile;
            ResourceFolderType folderType;
            FolderConfiguration configForFolder;
            ResourceFolder resourceFolder = this.getResourceFolder(folder);
            if (resourceFolder == null && (configForFolder = FolderConfiguration.getConfigForFolder(parentName)) != null && (folderType = ResourceFolderType.getFolderType(parentName)) != null) {
                resourceFolder = this.add(folderType, configForFolder, folder);
            }
            if (resourceFolder != null && (resourceFile = resourceFolder.getFile(file.getName())) != null) {
                return resourceFile;
            }
        }
        return null;
    }

    @Nullable
    public List<ResourceFile> getSourceFiles(@NonNull ResourceType type, @NonNull String name, @Nullable FolderConfiguration referenceConfig) {
        this.ensureInitialized();
        Collection<ResourceItem> items = this.getResourceItemsOfType(type);
        for (ResourceItem item : items) {
            if (!name.equals(item.getName())) continue;
            if (referenceConfig != null) {
                Configurable match = referenceConfig.findMatchingConfigurable(item.getSourceFileList());
                if (match instanceof ResourceFile) {
                    return Collections.singletonList((ResourceFile)match);
                }
                return null;
            }
            return item.getSourceFileList();
        }
        return null;
    }

    @NonNull
    public Map<ResourceType, Map<String, ResourceValue>> getConfiguredResources(@NonNull FolderConfiguration referenceConfig) {
        this.ensureInitialized();
        return this.doGetConfiguredResources(referenceConfig);
    }

    @NonNull
    protected final Map<ResourceType, Map<String, ResourceValue>> doGetConfiguredResources(@NonNull FolderConfiguration referenceConfig) {
        this.ensureInitialized();
        EnumMap<ResourceType, Map<String, ResourceValue>> map = new EnumMap<ResourceType, Map<String, ResourceValue>>(ResourceType.class);
        for (ResourceType key : ResourceType.values()) {
            map.put(key, this.getConfiguredResource(key, referenceConfig));
        }
        return map;
    }

    @NonNull
    public SortedSet<String> getLanguages() {
        this.ensureInitialized();
        TreeSet<String> set = new TreeSet<String>();
        Collection<List<ResourceFolder>> folderList = this.mFolderMap.values();
        for (List<ResourceFolder> folderSubList : folderList) {
            for (ResourceFolder folder : folderSubList) {
                FolderConfiguration config = folder.getConfiguration();
                LanguageQualifier lang = config.getLanguageQualifier();
                if (lang == null) continue;
                set.add(lang.getShortDisplayValue());
            }
        }
        return set;
    }

    @NonNull
    public SortedSet<String> getRegions(@NonNull String currentLanguage) {
        this.ensureInitialized();
        TreeSet<String> set = new TreeSet<String>();
        Collection<List<ResourceFolder>> folderList = this.mFolderMap.values();
        for (List<ResourceFolder> folderSubList : folderList) {
            for (ResourceFolder folder : folderSubList) {
                RegionQualifier region;
                FolderConfiguration config = folder.getConfiguration();
                LanguageQualifier lang = config.getLanguageQualifier();
                if (lang == null || !lang.getShortDisplayValue().equals(currentLanguage) || (region = config.getRegionQualifier()) == null) continue;
                set.add(region.getShortDisplayValue());
            }
        }
        return set;
    }

    public void loadResources() {
        this.clear();
        this.ensureInitialized();
    }

    protected void removeFile(@NonNull Collection<ResourceType> types, @NonNull ResourceFile file) {
        this.ensureInitialized();
        for (ResourceType type : types) {
            this.removeFile(type, file);
        }
    }

    protected void removeFile(@NonNull ResourceType type, @NonNull ResourceFile file) {
        Map<String, ResourceItem> map = this.mResourceMap.get((Object)type);
        if (map != null) {
            Collection<ResourceItem> values = map.values();
            ArrayList<ResourceItem> toDelete = null;
            for (ResourceItem item : values) {
                item.removeFile(file);
                if (!item.hasNoSourceFile()) continue;
                if (toDelete == null) {
                    toDelete = new ArrayList<ResourceItem>(values.size());
                }
                toDelete.add(item);
            }
            if (toDelete != null) {
                for (ResourceItem item : toDelete) {
                    map.remove(item.getName());
                }
            }
        }
    }

    @NonNull
    private Map<String, ResourceValue> getConfiguredResource(@NonNull ResourceType type, @NonNull FolderConfiguration referenceConfig) {
        Map<String, ResourceItem> items = this.mResourceMap.get((Object)type);
        if (items == null) {
            return new HashMap<String, ResourceValue>();
        }
        HashMap<String, ResourceValue> map = new HashMap<String, ResourceValue>(items.size());
        for (ResourceItem item : items.values()) {
            ResourceValue value = item.getResourceValue(type, referenceConfig, this.isFrameworkRepository());
            if (value == null) continue;
            map.put(item.getName(), value);
        }
        return map;
    }

    public void postUpdateCleanUp() {
        Collection<Map<String, ResourceItem>> maps = this.mResourceMap.values();
        for (Map<String, ResourceItem> map : maps) {
            Set<String> keySet = map.keySet();
            Iterator<String> iterator = keySet.iterator();
            while (iterator.hasNext()) {
                String name = iterator.next();
                ResourceItem resourceItem = map.get(name);
                if (!resourceItem.hasNoSourceFile()) continue;
                iterator.remove();
            }
        }
    }

    @Nullable
    private ResourceItem findDeclaredResourceItem(@NonNull ResourceType type, @NonNull String name) {
        ResourceItem resourceItem;
        Map<String, ResourceItem> map = this.mResourceMap.get((Object)type);
        if (map != null && (resourceItem = map.get(name)) != null && !resourceItem.isDeclaredInline()) {
            return resourceItem;
        }
        return null;
    }
}

