/*
 * Decompiled with CFR 0.152.
 */
package com.android.ant;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class GetEmmaFilterTask
extends Task {
    private static final String[] FILTER_CLASSES = new String[]{"R", "R$*", "Manifest", "BuildConfig"};
    private String mAppPackage;
    private String mLibraryPackagesRefId;
    private String mFilterOut;

    public void setAppPackage(String appPackage) {
        this.mAppPackage = appPackage;
    }

    public void setLibraryPackagesRefId(String libraryPackagesRefId) {
        this.mLibraryPackagesRefId = libraryPackagesRefId;
    }

    public void setFilterOut(String filterOut) {
        this.mFilterOut = filterOut;
    }

    public void execute() throws BuildException {
        if (this.mAppPackage == null) {
            throw new BuildException("Missing attribute appPackage");
        }
        if (this.mLibraryPackagesRefId == null) {
            throw new BuildException("Missing attribute libraryPackagesRefId");
        }
        if (this.mFilterOut == null) {
            throw new BuildException("Missing attribute filterOut");
        }
        StringBuilder sb = new StringBuilder();
        String libraryPackagesValue = this.getProject().getProperty(this.mLibraryPackagesRefId);
        if (libraryPackagesValue != null && libraryPackagesValue.length() > 0) {
            String[] libPackages;
            for (String libPackage : libPackages = libraryPackagesValue.split(";")) {
                if (libPackage.length() <= 0) continue;
                for (String filterClass : FILTER_CLASSES) {
                    sb.append(libPackage).append('.').append(filterClass).append(',');
                }
            }
        }
        int count = FILTER_CLASSES.length;
        for (int i = 0; i < count; ++i) {
            sb.append(this.mAppPackage).append('.').append(FILTER_CLASSES[i]);
            if (i >= count - 1) continue;
            sb.append(',');
        }
        this.getProject().setProperty(this.mFilterOut, sb.toString());
    }
}

