/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewerlib.ui;

import com.android.ddmlib.Log;
import com.android.hierarchyviewerlib.HierarchyViewerDirector;
import com.android.hierarchyviewerlib.device.IHvDevice;
import com.android.hierarchyviewerlib.models.TreeViewModel;
import com.android.hierarchyviewerlib.models.ViewNode;
import com.android.hierarchyviewerlib.ui.util.DrawableViewNode;
import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class InvokeMethodPrompt
extends Composite
implements TreeViewModel.ITreeChangeListener {
    private TreeViewModel mModel;
    private DrawableViewNode mSelectedNode;
    private Text mText;
    private static final Splitter CMD_SPLITTER = Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)", ")).trimResults().omitEmptyStrings();

    public InvokeMethodPrompt(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)new FillLayout());
        this.mText = new Text((Composite)this, 2048);
        this.mText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent ke) {
            }

            public void keyPressed(KeyEvent ke) {
                InvokeMethodPrompt.this.onKeyPress(ke);
            }
        });
        this.mModel = TreeViewModel.getModel();
        this.mModel.addTreeChangeListener(this);
    }

    private void onKeyPress(KeyEvent ke) {
        if (ke.keyCode == 13) {
            String cmd = this.mText.getText().trim();
            if (!cmd.isEmpty()) {
                this.invokeViewMethod(cmd);
            }
            this.mText.setText("");
        }
    }

    private void invokeViewMethod(String cmd) {
        Iterator segmentIterator = CMD_SPLITTER.split((CharSequence)cmd).iterator();
        String method = null;
        if (!segmentIterator.hasNext()) {
            return;
        }
        method = (String)segmentIterator.next();
        ArrayList<Object> args = new ArrayList<Object>(10);
        while (segmentIterator.hasNext()) {
            String arg = (String)segmentIterator.next();
            if (arg.equalsIgnoreCase("true")) {
                args.add(Boolean.TRUE);
                continue;
            }
            if (arg.equalsIgnoreCase("false")) {
                args.add(Boolean.FALSE);
                continue;
            }
            char typeSpecifier = Character.toUpperCase(arg.charAt(arg.length() - 1));
            try {
                switch (typeSpecifier) {
                    case 'L': {
                        args.add(Long.valueOf(arg.substring(0, arg.length())));
                        break;
                    }
                    case 'D': {
                        args.add(Double.valueOf(arg.substring(0, arg.length())));
                        break;
                    }
                    case 'F': {
                        args.add(Float.valueOf(arg.substring(0, arg.length())));
                        break;
                    }
                    case 'S': {
                        args.add(Short.valueOf(arg.substring(0, arg.length())));
                        break;
                    }
                    case 'B': {
                        args.add(Byte.valueOf(arg.substring(0, arg.length())));
                        break;
                    }
                    default: {
                        args.add(Integer.valueOf(arg));
                        break;
                    }
                }
            }
            catch (NumberFormatException e) {
                Log.e("hv", "Unable to parse method argument: " + arg);
                return;
            }
        }
        HierarchyViewerDirector.getDirector().invokeMethodOnSelectedView(method, args);
    }

    @Override
    public void selectionChanged() {
        this.mSelectedNode = this.mModel.getSelection();
        this.refresh();
    }

    private boolean isViewUpdateEnabled(ViewNode viewNode) {
        IHvDevice device = viewNode.window.getHvDevice();
        return device != null && device.isViewUpdateEnabled();
    }

    private void refresh() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                InvokeMethodPrompt.this.mText.setEnabled(InvokeMethodPrompt.this.mSelectedNode != null && InvokeMethodPrompt.this.isViewUpdateEnabled(((InvokeMethodPrompt)InvokeMethodPrompt.this).mSelectedNode.viewNode));
            }
        });
    }

    @Override
    public void treeChanged() {
        this.selectionChanged();
    }

    @Override
    public void viewportChanged() {
    }

    @Override
    public void zoomChanged() {
    }
}

