/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewerlib.actions;

import com.android.ddmuilib.ImageLoader;
import com.android.hierarchyviewerlib.HierarchyViewerDirector;
import com.android.hierarchyviewerlib.actions.ImageAction;
import com.android.hierarchyviewerlib.actions.PixelPerfectEnabledAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class LoadOverlayAction
extends PixelPerfectEnabledAction
implements ImageAction {
    private static LoadOverlayAction sAction;
    private Image mImage;
    private Shell mShell;

    private LoadOverlayAction(Shell shell) {
        super("Load &Overlay");
        this.mShell = shell;
        this.setAccelerator(SWT.MOD1 + 79);
        ImageLoader imageLoader = ImageLoader.getLoader(HierarchyViewerDirector.class);
        this.mImage = imageLoader.loadImage("load-overlay.png", Display.getDefault());
        this.setImageDescriptor(ImageDescriptor.createFromImage(this.mImage));
        this.setToolTipText("Load an image to overlay the screenshot");
    }

    public static LoadOverlayAction getAction(Shell shell) {
        if (sAction == null) {
            sAction = new LoadOverlayAction(shell);
        }
        return sAction;
    }

    @Override
    public void run() {
        HierarchyViewerDirector.getDirector().loadOverlay(this.mShell);
    }

    @Override
    public Image getImage() {
        return this.mImage;
    }
}

