
test_that("`mode_possible_min()` works correctly", {
  expect_equal(mode_possible_min(x1 ), 9)
  expect_equal(mode_possible_min(x2 ), NA_real_)
  expect_equal(mode_possible_min(x3 ), 7)
  expect_equal(mode_possible_min(x4 ), c("a", "b"))
  expect_equal(mode_possible_min(x5 ), NA_real_)
  expect_equal(mode_possible_min(x6 ), 5)
  expect_equal(mode_possible_min(x7 ), c("y", "z"))
  expect_equal(mode_possible_min(x8 ), 1)
  expect_equal(mode_possible_min(x9 ), 1)
  expect_equal(mode_possible_min(x10), 1)
  expect_equal(mode_possible_min(x11), 1)
  expect_equal(mode_possible_min(x12), "a")
  expect_equal(mode_possible_min(x13), 1)
  expect_equal(mode_possible_min(x14), NA_real_)
  expect_equal(mode_possible_min(x15), NA_real_)
  expect_equal(mode_possible_min(x16), 1)
  expect_equal(mode_possible_min(x17), NA_real_)
})

test_that("`mode_possible_min()` works correctly with `multiple = TRUE`", {
  expect_equal(mode_possible_min(x1 , TRUE), 9)
  expect_equal(mode_possible_min(x2 , TRUE), NA_real_)
  expect_equal(mode_possible_min(x3 , TRUE), 7)
  expect_equal(mode_possible_min(x4 , TRUE), c("a", "b"))
  expect_equal(mode_possible_min(x5 , TRUE), c(1, 2))
  expect_equal(mode_possible_min(x6 , TRUE), 5)
  expect_equal(mode_possible_min(x7 , TRUE), c("y", "z"))
  expect_equal(mode_possible_min(x8 , TRUE), 1)
  expect_equal(mode_possible_min(x9 , TRUE), 1)
  expect_equal(mode_possible_min(x10, TRUE), 1)
  expect_equal(mode_possible_min(x11, TRUE), 1)
  expect_equal(mode_possible_min(x12, TRUE), "a")
  expect_equal(mode_possible_min(x13, TRUE), 1)
  expect_equal(mode_possible_min(x14, TRUE), c(1, 2))
  expect_equal(mode_possible_min(x15, TRUE), NA_real_)
  expect_equal(mode_possible_min(x16, TRUE), 1)
  expect_equal(mode_possible_min(x17, TRUE), c(1, 2))
})


# 2. `mode_possible_max()`

test_that("`mode_possible_max()` works correctly by default", {
  expect_equal(mode_possible_max(x1 ), 9)
  expect_equal(mode_possible_max(x2 ), c(2, 1))
  expect_equal(mode_possible_max(x3 ), 7)
  expect_equal(mode_possible_max(x4 ), c("a", "b"))
  expect_equal(mode_possible_max(x5 ), NA_real_)
  expect_equal(mode_possible_max(x6 ), 5)
  expect_equal(mode_possible_max(x7 ), c("y", "z"))
  expect_equal(mode_possible_max(x8 ), c(1, 2))
  expect_equal(mode_possible_max(x9 ), c(1, 2))
  expect_equal(mode_possible_max(x10), 1)
  expect_equal(mode_possible_max(x11), 1)
  expect_equal(mode_possible_max(x12), c("a", "b"))
  expect_equal(mode_possible_max(x13), 1)
  expect_equal(mode_possible_max(x14), NA_real_)
  expect_equal(mode_possible_max(x15), 1)
  expect_equal(mode_possible_max(x16), NA_real_)
  expect_equal(mode_possible_max(c(x16, 1)), 1)
  expect_equal(mode_possible_max(x17), NA_real_)
})

test_that("`mode_possible_max()` works correctly with `multiple = TRUE`", {
  expect_equal(mode_possible_max(x1 , TRUE), 9)
  expect_equal(mode_possible_max(x2 , TRUE), c(2, 1))
  expect_equal(mode_possible_max(x3 , TRUE), 7)
  expect_equal(mode_possible_max(x4 , TRUE), c("a", "b"))
  expect_equal(mode_possible_max(x5 , TRUE), c(1, 2))
  expect_equal(mode_possible_max(x6 , TRUE), c(5))
  expect_equal(mode_possible_max(x7 , TRUE), c("y", "z"))
  expect_equal(mode_possible_max(x8 , TRUE), c(1, 2))
  expect_equal(mode_possible_max(x9 , TRUE), c(1, 2))
  expect_equal(mode_possible_max(x10, TRUE), 1)
  expect_equal(mode_possible_max(x11, TRUE), c(1))
  expect_equal(mode_possible_max(x12, TRUE), c("a", "b"))
  expect_equal(mode_possible_max(x13, TRUE), c(1))
  expect_equal(mode_possible_max(x14, TRUE), c(1, 2, 3))
  expect_equal(mode_possible_max(x15, TRUE), c(1))
  expect_equal(mode_possible_max(x16, TRUE), c(1, 2, 3))
  expect_equal(mode_possible_max(x17, TRUE), c(1, 2))
})

