/*
 * Decompiled with CFR 0.152.
 */
package org.polymc;

import java.util.HashMap;
import java.util.Map;
import org.polymc.Launcher;
import org.polymc.impl.OneSixLauncher;
import org.polymc.utils.Parameters;

public final class LauncherFactory {
    private static final LauncherFactory INSTANCE = new LauncherFactory();
    private final Map<String, LauncherProvider> launcherRegistry = new HashMap<String, LauncherProvider>();

    private LauncherFactory() {
        this.launcherRegistry.put("onesix", new LauncherProvider(){

            @Override
            public Launcher provide(Parameters parameters) {
                return new OneSixLauncher(parameters);
            }
        });
    }

    public Launcher createLauncher(Parameters parameters) {
        String string = parameters.first("launcher");
        LauncherProvider launcherProvider = this.launcherRegistry.get(string);
        if (launcherProvider == null) {
            throw new IllegalArgumentException("Invalid launcher type: " + string);
        }
        return launcherProvider.provide(parameters);
    }

    public static LauncherFactory getInstance() {
        return INSTANCE;
    }

    public static interface LauncherProvider {
        public Launcher provide(Parameters var1);
    }
}

