/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.gui.io.SaveLayerInfo;
import org.openstreetmap.josm.gui.util.CellEditorSupport;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

class ActionFlagsTableCell
extends JPanel
implements TableCellRenderer,
TableCellEditor {
    private final JCheckBox[] checkBoxes = new JCheckBox[2];
    private final transient CellEditorSupport cellEditorSupport = new CellEditorSupport(this);

    ActionFlagsTableCell() {
        this.checkBoxes[0] = new JCheckBox(I18n.tr("Upload", new Object[0]));
        this.checkBoxes[1] = new JCheckBox(I18n.tr("Save", new Object[0]));
        this.setLayout(new GridBagLayout());
        ActionListener al = e -> this.cellEditorSupport.fireEditingStopped();
        ActionMap am = this.getActionMap();
        for (final JCheckBox b : this.checkBoxes) {
            b.setPreferredSize(new Dimension(b.getPreferredSize().width, 19));
            b.addActionListener(al);
            am.put(b.getText(), new AbstractAction(this){
                final /* synthetic */ ActionFlagsTableCell this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    b.setSelected(!b.isSelected());
                    this.this$0.cellEditorSupport.fireEditingStopped();
                }
            });
        }
    }

    protected void updateCheckboxes(Object v) {
        if (v != null && this.checkBoxes[0] != null && this.checkBoxes[1] != null) {
            boolean[] values = v instanceof SaveLayerInfo ? new boolean[]{((SaveLayerInfo)v).isDoUploadToServer(), ((SaveLayerInfo)v).isDoSaveToFile()} : (boolean[])v;
            this.checkBoxes[0].setSelected(values[0]);
            this.checkBoxes[1].setSelected(values[1]);
        }
    }

    private void updatePanel(SaveLayerInfo info) {
        StringBuilder sb = new StringBuilder(128).append("<html>").append(I18n.tr("Select which actions to perform for this layer, if you click the leftmost button.", new Object[0]));
        this.removeAll();
        if (info != null) {
            if (info.isUploadable()) {
                sb.append("<br/>").append(I18n.tr("Check \"Upload\" to upload the changes to the OSM server.", new Object[0]));
                this.add((Component)this.checkBoxes[0], GBC.eol().fill(2));
            }
            if (info.isSavable()) {
                sb.append("<br/>").append(I18n.tr("Check \"Save\" to save the layer to the file specified on the left.", new Object[0]));
                this.add((Component)this.checkBoxes[1], GBC.eol().fill(2));
            }
        }
        sb.append("</html>");
        this.setToolTipText(sb.toString());
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.cellEditorSupport.addCellEditorListener(l);
    }

    @Override
    public void cancelCellEditing() {
        this.cellEditorSupport.fireEditingCanceled();
    }

    @Override
    public Object getCellEditorValue() {
        boolean[] values = new boolean[]{this.checkBoxes[0].isSelected(), this.checkBoxes[1].isSelected()};
        return values;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.cellEditorSupport.removeCellEditorListener(l);
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        this.cellEditorSupport.fireEditingStopped();
        return true;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.updatePanel((SaveLayerInfo)value);
        this.updateCheckboxes(value);
        return this;
    }
}

