/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.tags;

import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractCellEditor;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.table.TableCellEditor;
import org.openstreetmap.josm.gui.conflict.tags.MultiValueDecisionType;
import org.openstreetmap.josm.gui.conflict.tags.MultiValueResolutionDecision;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;
import org.openstreetmap.josm.gui.widgets.JosmComboBoxModel;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class MultiValueCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private final JosmComboBox<Object> editor;
    private final JosmComboBoxModel<Object> editorModel = new JosmComboBoxModel();
    private final CopyOnWriteArrayList<NavigationListener> listeners;

    public void addNavigationListener(NavigationListener listener) {
        if (listener != null) {
            this.listeners.addIfAbsent(listener);
        }
    }

    public void removeNavigationListener(NavigationListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireGotoNextDecision() {
        for (NavigationListener l : this.listeners) {
            l.gotoNextDecision();
        }
    }

    protected void fireGotoPreviousDecision() {
        for (NavigationListener l : this.listeners) {
            l.gotoPreviousDecision();
        }
    }

    public MultiValueCellEditor() {
        this.editor = new JosmComboBox<Object>(this.editorModel){

            @Override
            public void processKeyEvent(KeyEvent e) {
                if (e.getID() == 401) {
                    int keyCode = e.getKeyCode();
                    if (keyCode == 10) {
                        MultiValueCellEditor.this.fireGotoNextDecision();
                    } else if (keyCode == 9) {
                        if (e.isShiftDown()) {
                            MultiValueCellEditor.this.fireGotoPreviousDecision();
                        } else {
                            MultiValueCellEditor.this.fireGotoNextDecision();
                        }
                    } else if (keyCode == 127 || keyCode == 8) {
                        if (MultiValueCellEditor.this.editorModel.getIndexOf((Object)MultiValueDecisionType.KEEP_NONE) > 0) {
                            MultiValueCellEditor.this.editorModel.setSelectedItem((Object)MultiValueDecisionType.KEEP_NONE);
                            MultiValueCellEditor.this.fireGotoNextDecision();
                        }
                    } else if (keyCode == 27) {
                        MultiValueCellEditor.this.cancelCellEditing();
                    }
                }
                super.processKeyEvent(e);
            }
        };
        this.editor.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                MultiValueCellEditor.this.editor.showPopup();
            }
        });
        this.editor.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.fireEditingStopped();
            }
        });
        this.editor.setRenderer(new EditorCellRenderer());
        this.listeners = new CopyOnWriteArrayList();
    }

    protected void initEditor(MultiValueResolutionDecision decision) {
        this.editorModel.removeAllElements();
        if (!decision.isDecided()) {
            this.editorModel.addElement((Object)MultiValueDecisionType.UNDECIDED);
        }
        for (String value : decision.getValues()) {
            this.editorModel.addElement(value);
        }
        if (decision.canSumAllNumeric()) {
            this.editorModel.addElement((Object)MultiValueDecisionType.SUM_ALL_NUMERIC);
        }
        if (decision.canKeepNone()) {
            this.editorModel.addElement((Object)MultiValueDecisionType.KEEP_NONE);
        }
        if (decision.canKeepAll()) {
            this.editorModel.addElement((Object)MultiValueDecisionType.KEEP_ALL);
        }
        switch (decision.getDecisionType()) {
            case UNDECIDED: {
                this.editor.setSelectedItem((Object)MultiValueDecisionType.UNDECIDED);
                break;
            }
            case KEEP_ONE: {
                this.editor.setSelectedItem(decision.getChosenValue());
                break;
            }
            case KEEP_NONE: {
                this.editor.setSelectedItem((Object)MultiValueDecisionType.KEEP_NONE);
                break;
            }
            case KEEP_ALL: {
                this.editor.setSelectedItem((Object)MultiValueDecisionType.KEEP_ALL);
                break;
            }
            case SUM_ALL_NUMERIC: {
                this.editor.setSelectedItem((Object)MultiValueDecisionType.SUM_ALL_NUMERIC);
                break;
            }
            default: {
                Logging.error("Unknown decision type in initEditor(): " + String.valueOf((Object)decision.getDecisionType()));
            }
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        MultiValueResolutionDecision decision = (MultiValueResolutionDecision)value;
        this.initEditor(decision);
        this.editor.requestFocus();
        return this.editor;
    }

    @Override
    public Object getCellEditorValue() {
        return this.editor.getSelectedItem();
    }

    public static interface NavigationListener {
        public void gotoNextDecision();

        public void gotoPreviousDecision();
    }

    private static class EditorCellRenderer
    extends JLabel
    implements ListCellRenderer<Object> {
        EditorCellRenderer() {
            this.setOpaque(true);
        }

        protected void renderColors(boolean selected) {
            if (selected) {
                this.setForeground(UIManager.getColor("ComboBox.selectionForeground"));
                this.setBackground(UIManager.getColor("ComboBox.selectionBackground"));
            } else {
                this.setForeground(UIManager.getColor("ComboBox.foreground"));
                this.setBackground(UIManager.getColor("ComboBox.background"));
            }
        }

        protected void renderValue(Object value) {
            String comboBoxFont = "ComboBox.font";
            this.setFont(UIManager.getFont("ComboBox.font"));
            if (value instanceof String) {
                this.setText((String)value);
            } else if (value instanceof MultiValueDecisionType) {
                switch ((MultiValueDecisionType)((Object)value)) {
                    case UNDECIDED: {
                        this.setText(I18n.tr("Choose a value", new Object[0]));
                        this.setFont(UIManager.getFont("ComboBox.font").deriveFont(3));
                        break;
                    }
                    case KEEP_NONE: {
                        this.setText(I18n.tr("none", new Object[0]));
                        this.setFont(UIManager.getFont("ComboBox.font").deriveFont(3));
                        break;
                    }
                    case KEEP_ALL: {
                        this.setText(I18n.tr("all", new Object[0]));
                        this.setFont(UIManager.getFont("ComboBox.font").deriveFont(3));
                        break;
                    }
                    case SUM_ALL_NUMERIC: {
                        this.setText(I18n.tr("sum", new Object[0]));
                        this.setFont(UIManager.getFont("ComboBox.font").deriveFont(3));
                        break;
                    }
                }
            }
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.renderColors(isSelected);
            this.renderValue(value);
            return this;
        }
    }
}

