/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.preferences;

import java.util.Objects;
import org.openstreetmap.josm.data.preferences.CachingProperty;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.spi.preferences.IPreferences;
import org.openstreetmap.josm.spi.preferences.PreferenceChangeEvent;
import org.openstreetmap.josm.spi.preferences.PreferenceChangedListener;
import org.openstreetmap.josm.tools.ListenableWeakReference;
import org.openstreetmap.josm.tools.bugreport.BugReport;

public abstract class AbstractProperty<T> {
    protected final IPreferences preferences = Config.getPref();
    protected final String key;
    protected final T defaultValue;

    protected AbstractProperty(String key, T defaultValue) {
        this.key = key;
        this.defaultValue = defaultValue;
    }

    protected void storeDefaultValue() {
        if (this.getPreferences() != null) {
            this.get();
        }
    }

    public String getKey() {
        return this.key;
    }

    public boolean isSet() {
        return this.getPreferences().getKeySet().contains(this.key);
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public void remove() {
        this.getPreferences().put(this.key, null);
    }

    public abstract T get();

    public abstract boolean put(T var1);

    protected IPreferences getPreferences() {
        return this.preferences;
    }

    public CachingProperty<T> cached() {
        return new CachingProperty(this);
    }

    public void addListener(ValueChangeListener<? super T> listener) {
        try {
            this.addListenerImpl(new PreferenceChangedListenerAdapter(listener));
        }
        catch (RuntimeException e) {
            throw BugReport.intercept(e).put("listener", listener).put("preference", this.key);
        }
    }

    protected void addListenerImpl(PreferenceChangedListener adapter) {
        this.getPreferences().addKeyPreferenceChangeListener(this.getKey(), adapter);
    }

    public void addWeakListener(ValueChangeListener<? super T> listener) {
        try {
            WeakPreferenceAdapter weakListener = new WeakPreferenceAdapter(listener);
            PreferenceChangedListenerAdapter adapter = new PreferenceChangedListenerAdapter(weakListener);
            this.addListenerImpl(adapter);
        }
        catch (RuntimeException e) {
            throw BugReport.intercept(e).put("listener", listener).put("preference", this.key);
        }
    }

    public void removeListener(ValueChangeListener<? super T> listener) {
        try {
            this.removeListenerImpl(new PreferenceChangedListenerAdapter(listener));
        }
        catch (RuntimeException e) {
            throw BugReport.intercept(e).put("listener", listener).put("preference", this.key);
        }
    }

    protected void removeListenerImpl(PreferenceChangedListener adapter) {
        this.getPreferences().removeKeyPreferenceChangeListener(this.getKey(), adapter);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.preferences);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractProperty other = (AbstractProperty)obj;
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        return !(this.preferences == null ? other.preferences != null : !this.preferences.equals(other.preferences));
    }

    private final class PreferenceChangedListenerAdapter
    implements PreferenceChangedListener {
        private final ValueChangeListener<? super T> listener;

        PreferenceChangedListenerAdapter(ValueChangeListener<? super T> listener) {
            this.listener = listener;
        }

        @Override
        public void preferenceChanged(PreferenceChangeEvent e) {
            this.listener.valueChanged(new ValueChangeEvent(e, AbstractProperty.this));
        }

        public int hashCode() {
            return Objects.hash(this.getOuterType(), this.listener);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            PreferenceChangedListenerAdapter other = (PreferenceChangedListenerAdapter)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this.listener == null ? other.listener != null : !this.listener.equals(other.listener));
        }

        private AbstractProperty<T> getOuterType() {
            return AbstractProperty.this;
        }

        public String toString() {
            return "PreferenceChangedListenerAdapter [listener=" + String.valueOf(this.listener) + "]";
        }
    }

    @FunctionalInterface
    public static interface ValueChangeListener<T> {
        public void valueChanged(ValueChangeEvent<? extends T> var1);
    }

    private class WeakPreferenceAdapter
    extends ListenableWeakReference<ValueChangeListener<? super T>>
    implements ValueChangeListener<T> {
        WeakPreferenceAdapter(ValueChangeListener<? super T> referent) {
            super(referent);
        }

        @Override
        public void valueChanged(ValueChangeEvent<? extends T> e) {
            ValueChangeListener r = (ValueChangeListener)super.get();
            if (r != null) {
                r.valueChanged(e);
            }
        }

        @Override
        protected void onDereference() {
            AbstractProperty.this.removeListenerImpl(new PreferenceChangedListenerAdapter(this));
        }
    }

    public static class InvalidPreferenceValueException
    extends RuntimeException {
        public InvalidPreferenceValueException(String message, Throwable cause) {
            super(message, cause);
        }

        public InvalidPreferenceValueException(String message) {
            super(message);
        }

        public InvalidPreferenceValueException(Throwable cause) {
            super(cause);
        }
    }

    public static class ValueChangeEvent<T> {
        private final PreferenceChangeEvent base;
        private final AbstractProperty<T> source;

        ValueChangeEvent(PreferenceChangeEvent base, AbstractProperty<T> source) {
            this.base = base;
            this.source = source;
        }

        public final PreferenceChangeEvent getBaseEvent() {
            return this.base;
        }

        public AbstractProperty<T> getProperty() {
            return this.source;
        }
    }
}

