/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.awt.Component;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.josm.actions.downloadtasks.AbstractChangesetDownloadTask;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.ChangesetCache;
import org.openstreetmap.josm.data.osm.ChangesetDataSet;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.io.OsmTransferCanceledException;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.xml.sax.SAXException;

public class ChangesetContentDownloadTask
extends AbstractChangesetDownloadTask {
    public ChangesetContentDownloadTask(int changesetId) {
        this((Component)MainApplication.getMainFrame(), changesetId);
    }

    public ChangesetContentDownloadTask(Collection<Integer> changesetIds) {
        this((Component)MainApplication.getMainFrame(), changesetIds);
    }

    public ChangesetContentDownloadTask(Component parent, int changesetId) {
        if (changesetId <= 0) {
            throw new IllegalArgumentException(MessageFormat.format("Expected integer value > 0 for parameter ''{0}'', got ''{1}''", "changesetId", changesetId));
        }
        this.setDownloadTask(new DownloadTask(parent, Collections.singleton(changesetId)));
    }

    public ChangesetContentDownloadTask(Component parent, Collection<Integer> changesetIds) {
        this.setDownloadTask(new DownloadTask(parent, changesetIds));
    }

    protected static boolean isAvailableLocally(int changesetId) {
        return ChangesetCache.getInstance().get(changesetId) != null;
    }

    class DownloadTask
    extends AbstractChangesetDownloadTask.RunnableDownloadTask {
        private final List<Integer> toDownload;

        DownloadTask(Component parent, Collection<Integer> ids) {
            super(parent, I18n.tr("Downloading changeset content", new Object[0]));
            this.toDownload = new ArrayList<Integer>();
            for (Integer id : ids != null ? ids : Collections.emptyList()) {
                if (id == null || id <= 0) continue;
                this.toDownload.add(id);
            }
        }

        protected void downloadChangeset(int changesetId) throws OsmTransferException {
            Changeset cs = this.reader.readChangeset(changesetId, false, this.getProgressMonitor().createSubTaskMonitor(0, false));
            ChangesetCache.getInstance().update(cs);
        }

        @Override
        protected void realRun() throws SAXException, IOException, OsmTransferException {
            block6: {
                try {
                    this.getProgressMonitor().setTicksCount(this.toDownload.size());
                    int i = 0;
                    for (int id : this.toDownload) {
                        ++i;
                        if (!ChangesetContentDownloadTask.isAvailableLocally(id)) {
                            this.getProgressMonitor().setCustomText(I18n.tr("({0}/{1}) Downloading changeset {2}...", i, this.toDownload.size(), id));
                            this.downloadChangeset(id);
                        }
                        if (ChangesetContentDownloadTask.this.isCanceled()) {
                            return;
                        }
                        this.getProgressMonitor().setCustomText(I18n.tr("({0}/{1}) Downloading content for changeset {2}...", i, this.toDownload.size(), id));
                        ChangesetDataSet ds = this.reader.downloadChangeset(id, this.getProgressMonitor().createSubTaskMonitor(0, false));
                        Changeset cs = ChangesetCache.getInstance().get(id);
                        cs.setContent(ds);
                        ChangesetCache.getInstance().update(cs);
                        this.downloadedChangesets.add(cs);
                        this.getProgressMonitor().worked(1);
                    }
                }
                catch (OsmTransferCanceledException e) {
                    ChangesetContentDownloadTask.this.setCanceled(true);
                    Logging.trace(e);
                }
                catch (OsmTransferException e) {
                    if (ChangesetContentDownloadTask.this.isCanceled()) break block6;
                    this.rememberLastException(e);
                }
            }
        }

        @Override
        protected void finish() {
            ChangesetContentDownloadTask.this.rememberDownloadedData(this.downloadedChangesets);
            if (ChangesetContentDownloadTask.this.isCanceled()) {
                return;
            }
            if (this.lastException != null) {
                ExceptionDialogUtil.explainException(this.lastException);
            }
        }
    }
}

