/*
 * Copyright 2006-2008 The FLWOR Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#include "stdafx.h"

#include <algorithm>
#include <cassert>
#include <cstdlib>
#include <cwchar>
#include <functional>                   /* for binary_function */
#include <utility>                      /* for pair */

#ifndef ZORBA_NO_ICU
# include <unicode/normlzr.h>
# include <unicode/uchar.h>
# include <unicode/ustring.h>
#endif /* ZORBA_NO_ICU */

#include <zorba/internal/cxx_util.h>
#include "ascii_util.h"
#include "unicode_util.h"
#include "utf8_util.h"

using namespace std;
#ifndef ZORBA_NO_ICU
U_NAMESPACE_USE
#endif /* ZORBA_NO_ICU */

namespace zorba {
namespace unicode {

code_point const SubChar = 0xFFFD;

///////////////////////////////////////////////////////////////////////////////

namespace {

typedef code_point case_table_entry[2];

//
// See: http://unicode.org/Public/UNIDATA/CaseFolding.txt
//
case_table_entry const upper2lower[] = {
  { 0x00041, 0x00061 }, // LATIN CAPITAL LETTER A
  { 0x00042, 0x00062 }, // LATIN CAPITAL LETTER B
  { 0x00043, 0x00063 }, // LATIN CAPITAL LETTER C
  { 0x00044, 0x00064 }, // LATIN CAPITAL LETTER D
  { 0x00045, 0x00065 }, // LATIN CAPITAL LETTER E
  { 0x00046, 0x00066 }, // LATIN CAPITAL LETTER F
  { 0x00047, 0x00067 }, // LATIN CAPITAL LETTER G
  { 0x00048, 0x00068 }, // LATIN CAPITAL LETTER H
  { 0x00049, 0x00069 }, // LATIN CAPITAL LETTER I
  { 0x0004A, 0x0006A }, // LATIN CAPITAL LETTER J
  { 0x0004B, 0x0006B }, // LATIN CAPITAL LETTER K
  { 0x0004C, 0x0006C }, // LATIN CAPITAL LETTER L
  { 0x0004D, 0x0006D }, // LATIN CAPITAL LETTER M
  { 0x0004E, 0x0006E }, // LATIN CAPITAL LETTER N
  { 0x0004F, 0x0006F }, // LATIN CAPITAL LETTER O
  { 0x00050, 0x00070 }, // LATIN CAPITAL LETTER P
  { 0x00051, 0x00071 }, // LATIN CAPITAL LETTER Q
  { 0x00052, 0x00072 }, // LATIN CAPITAL LETTER R
  { 0x00053, 0x00073 }, // LATIN CAPITAL LETTER S
  { 0x00054, 0x00074 }, // LATIN CAPITAL LETTER T
  { 0x00055, 0x00075 }, // LATIN CAPITAL LETTER U
  { 0x00056, 0x00076 }, // LATIN CAPITAL LETTER V
  { 0x00057, 0x00077 }, // LATIN CAPITAL LETTER W
  { 0x00058, 0x00078 }, // LATIN CAPITAL LETTER X
  { 0x00059, 0x00079 }, // LATIN CAPITAL LETTER Y
  { 0x0005A, 0x0007A }, // LATIN CAPITAL LETTER Z
  { 0x000B5, 0x003BC }, // MICRO SIGN
  { 0x000C0, 0x000E0 }, // LATIN CAPITAL LETTER A WITH GRAVE
  { 0x000C1, 0x000E1 }, // LATIN CAPITAL LETTER A WITH ACUTE
  { 0x000C2, 0x000E2 }, // LATIN CAPITAL LETTER A WITH CIRCUMFLEX
  { 0x000C3, 0x000E3 }, // LATIN CAPITAL LETTER A WITH TILDE
  { 0x000C4, 0x000E4 }, // LATIN CAPITAL LETTER A WITH DIAERESIS
  { 0x000C5, 0x000E5 }, // LATIN CAPITAL LETTER A WITH RING ABOVE
  { 0x000C6, 0x000E6 }, // LATIN CAPITAL LETTER AE
  { 0x000C7, 0x000E7 }, // LATIN CAPITAL LETTER C WITH CEDILLA
  { 0x000C8, 0x000E8 }, // LATIN CAPITAL LETTER E WITH GRAVE
  { 0x000C9, 0x000E9 }, // LATIN CAPITAL LETTER E WITH ACUTE
  { 0x000CA, 0x000EA }, // LATIN CAPITAL LETTER E WITH CIRCUMFLEX
  { 0x000CB, 0x000EB }, // LATIN CAPITAL LETTER E WITH DIAERESIS
  { 0x000CC, 0x000EC }, // LATIN CAPITAL LETTER I WITH GRAVE
  { 0x000CD, 0x000ED }, // LATIN CAPITAL LETTER I WITH ACUTE
  { 0x000CE, 0x000EE }, // LATIN CAPITAL LETTER I WITH CIRCUMFLEX
  { 0x000CF, 0x000EF }, // LATIN CAPITAL LETTER I WITH DIAERESIS
  { 0x000D0, 0x000F0 }, // LATIN CAPITAL LETTER ETH
  { 0x000D1, 0x000F1 }, // LATIN CAPITAL LETTER N WITH TILDE
  { 0x000D2, 0x000F2 }, // LATIN CAPITAL LETTER O WITH GRAVE
  { 0x000D3, 0x000F3 }, // LATIN CAPITAL LETTER O WITH ACUTE
  { 0x000D4, 0x000F4 }, // LATIN CAPITAL LETTER O WITH CIRCUMFLEX
  { 0x000D5, 0x000F5 }, // LATIN CAPITAL LETTER O WITH TILDE
  { 0x000D6, 0x000F6 }, // LATIN CAPITAL LETTER O WITH DIAERESIS
  { 0x000D8, 0x000F8 }, // LATIN CAPITAL LETTER O WITH STROKE
  { 0x000D9, 0x000F9 }, // LATIN CAPITAL LETTER U WITH GRAVE
  { 0x000DA, 0x000FA }, // LATIN CAPITAL LETTER U WITH ACUTE
  { 0x000DB, 0x000FB }, // LATIN CAPITAL LETTER U WITH CIRCUMFLEX
  { 0x000DC, 0x000FC }, // LATIN CAPITAL LETTER U WITH DIAERESIS
  { 0x000DD, 0x000FD }, // LATIN CAPITAL LETTER Y WITH ACUTE
  { 0x000DE, 0x000FE }, // LATIN CAPITAL LETTER THORN
  { 0x00100, 0x00101 }, // LATIN CAPITAL LETTER A WITH MACRON
  { 0x00102, 0x00103 }, // LATIN CAPITAL LETTER A WITH BREVE
  { 0x00104, 0x00105 }, // LATIN CAPITAL LETTER A WITH OGONEK
  { 0x00106, 0x00107 }, // LATIN CAPITAL LETTER C WITH ACUTE
  { 0x00108, 0x00109 }, // LATIN CAPITAL LETTER C WITH CIRCUMFLEX
  { 0x0010A, 0x0010B }, // LATIN CAPITAL LETTER C WITH DOT ABOVE
  { 0x0010C, 0x0010D }, // LATIN CAPITAL LETTER C WITH CARON
  { 0x0010E, 0x0010F }, // LATIN CAPITAL LETTER D WITH CARON
  { 0x00110, 0x00111 }, // LATIN CAPITAL LETTER D WITH STROKE
  { 0x00112, 0x00113 }, // LATIN CAPITAL LETTER E WITH MACRON
  { 0x00114, 0x00115 }, // LATIN CAPITAL LETTER E WITH BREVE
  { 0x00116, 0x00117 }, // LATIN CAPITAL LETTER E WITH DOT ABOVE
  { 0x00118, 0x00119 }, // LATIN CAPITAL LETTER E WITH OGONEK
  { 0x0011A, 0x0011B }, // LATIN CAPITAL LETTER E WITH CARON
  { 0x0011C, 0x0011D }, // LATIN CAPITAL LETTER G WITH CIRCUMFLEX
  { 0x0011E, 0x0011F }, // LATIN CAPITAL LETTER G WITH BREVE
  { 0x00120, 0x00121 }, // LATIN CAPITAL LETTER G WITH DOT ABOVE
  { 0x00122, 0x00123 }, // LATIN CAPITAL LETTER G WITH CEDILLA
  { 0x00124, 0x00125 }, // LATIN CAPITAL LETTER H WITH CIRCUMFLEX
  { 0x00126, 0x00127 }, // LATIN CAPITAL LETTER H WITH STROKE
  { 0x00128, 0x00129 }, // LATIN CAPITAL LETTER I WITH TILDE
  { 0x0012A, 0x0012B }, // LATIN CAPITAL LETTER I WITH MACRON
  { 0x0012C, 0x0012D }, // LATIN CAPITAL LETTER I WITH BREVE
  { 0x0012E, 0x0012F }, // LATIN CAPITAL LETTER I WITH OGONEK
  { 0x00132, 0x00133 }, // LATIN CAPITAL LIGATURE IJ
  { 0x00134, 0x00135 }, // LATIN CAPITAL LETTER J WITH CIRCUMFLEX
  { 0x00136, 0x00137 }, // LATIN CAPITAL LETTER K WITH CEDILLA
  { 0x00139, 0x0013A }, // LATIN CAPITAL LETTER L WITH ACUTE
  { 0x0013B, 0x0013C }, // LATIN CAPITAL LETTER L WITH CEDILLA
  { 0x0013D, 0x0013E }, // LATIN CAPITAL LETTER L WITH CARON
  { 0x0013F, 0x00140 }, // LATIN CAPITAL LETTER L WITH MIDDLE DOT
  { 0x00141, 0x00142 }, // LATIN CAPITAL LETTER L WITH STROKE
  { 0x00143, 0x00144 }, // LATIN CAPITAL LETTER N WITH ACUTE
  { 0x00145, 0x00146 }, // LATIN CAPITAL LETTER N WITH CEDILLA
  { 0x00147, 0x00148 }, // LATIN CAPITAL LETTER N WITH CARON
  { 0x0014A, 0x0014B }, // LATIN CAPITAL LETTER ENG
  { 0x0014C, 0x0014D }, // LATIN CAPITAL LETTER O WITH MACRON
  { 0x0014E, 0x0014F }, // LATIN CAPITAL LETTER O WITH BREVE
  { 0x00150, 0x00151 }, // LATIN CAPITAL LETTER O WITH DOUBLE ACUTE
  { 0x00152, 0x00153 }, // LATIN CAPITAL LIGATURE OE
  { 0x00154, 0x00155 }, // LATIN CAPITAL LETTER R WITH ACUTE
  { 0x00156, 0x00157 }, // LATIN CAPITAL LETTER R WITH CEDILLA
  { 0x00158, 0x00159 }, // LATIN CAPITAL LETTER R WITH CARON
  { 0x0015A, 0x0015B }, // LATIN CAPITAL LETTER S WITH ACUTE
  { 0x0015C, 0x0015D }, // LATIN CAPITAL LETTER S WITH CIRCUMFLEX
  { 0x0015E, 0x0015F }, // LATIN CAPITAL LETTER S WITH CEDILLA
  { 0x00160, 0x00161 }, // LATIN CAPITAL LETTER S WITH CARON
  { 0x00162, 0x00163 }, // LATIN CAPITAL LETTER T WITH CEDILLA
  { 0x00164, 0x00165 }, // LATIN CAPITAL LETTER T WITH CARON
  { 0x00166, 0x00167 }, // LATIN CAPITAL LETTER T WITH STROKE
  { 0x00168, 0x00169 }, // LATIN CAPITAL LETTER U WITH TILDE
  { 0x0016A, 0x0016B }, // LATIN CAPITAL LETTER U WITH MACRON
  { 0x0016C, 0x0016D }, // LATIN CAPITAL LETTER U WITH BREVE
  { 0x0016E, 0x0016F }, // LATIN CAPITAL LETTER U WITH RING ABOVE
  { 0x00170, 0x00171 }, // LATIN CAPITAL LETTER U WITH DOUBLE ACUTE
  { 0x00172, 0x00173 }, // LATIN CAPITAL LETTER U WITH OGONEK
  { 0x00174, 0x00175 }, // LATIN CAPITAL LETTER W WITH CIRCUMFLEX
  { 0x00176, 0x00177 }, // LATIN CAPITAL LETTER Y WITH CIRCUMFLEX
  { 0x00178, 0x000FF }, // LATIN CAPITAL LETTER Y WITH DIAERESIS
  { 0x00179, 0x0017A }, // LATIN CAPITAL LETTER Z WITH ACUTE
  { 0x0017B, 0x0017C }, // LATIN CAPITAL LETTER Z WITH DOT ABOVE
  { 0x0017D, 0x0017E }, // LATIN CAPITAL LETTER Z WITH CARON
  { 0x0017F, 0x00073 }, // LATIN SMALL LETTER LONG S
  { 0x00181, 0x00253 }, // LATIN CAPITAL LETTER B WITH HOOK
  { 0x00182, 0x00183 }, // LATIN CAPITAL LETTER B WITH TOPBAR
  { 0x00184, 0x00185 }, // LATIN CAPITAL LETTER TONE SIX
  { 0x00186, 0x00254 }, // LATIN CAPITAL LETTER OPEN O
  { 0x00187, 0x00188 }, // LATIN CAPITAL LETTER C WITH HOOK
  { 0x00189, 0x00256 }, // LATIN CAPITAL LETTER AFRICAN D
  { 0x0018A, 0x00257 }, // LATIN CAPITAL LETTER D WITH HOOK
  { 0x0018B, 0x0018C }, // LATIN CAPITAL LETTER D WITH TOPBAR
  { 0x0018E, 0x001DD }, // LATIN CAPITAL LETTER REVERSED E
  { 0x0018F, 0x00259 }, // LATIN CAPITAL LETTER SCHWA
  { 0x00190, 0x0025B }, // LATIN CAPITAL LETTER OPEN E
  { 0x00191, 0x00192 }, // LATIN CAPITAL LETTER F WITH HOOK
  { 0x00193, 0x00260 }, // LATIN CAPITAL LETTER G WITH HOOK
  { 0x00194, 0x00263 }, // LATIN CAPITAL LETTER GAMMA
  { 0x00196, 0x00269 }, // LATIN CAPITAL LETTER IOTA
  { 0x00197, 0x00268 }, // LATIN CAPITAL LETTER I WITH STROKE
  { 0x00198, 0x00199 }, // LATIN CAPITAL LETTER K WITH HOOK
  { 0x0019C, 0x0026F }, // LATIN CAPITAL LETTER TURNED M
  { 0x0019D, 0x00272 }, // LATIN CAPITAL LETTER N WITH LEFT HOOK
  { 0x0019F, 0x00275 }, // LATIN CAPITAL LETTER O WITH MIDDLE TILDE
  { 0x001A0, 0x001A1 }, // LATIN CAPITAL LETTER O WITH HORN
  { 0x001A2, 0x001A3 }, // LATIN CAPITAL LETTER OI
  { 0x001A4, 0x001A5 }, // LATIN CAPITAL LETTER P WITH HOOK
  { 0x001A6, 0x00280 }, // LATIN LETTER YR
  { 0x001A7, 0x001A8 }, // LATIN CAPITAL LETTER TONE TWO
  { 0x001A9, 0x00283 }, // LATIN CAPITAL LETTER ESH
  { 0x001AC, 0x001AD }, // LATIN CAPITAL LETTER T WITH HOOK
  { 0x001AE, 0x00288 }, // LATIN CAPITAL LETTER T WITH RETROFLEX HOOK
  { 0x001AF, 0x001B0 }, // LATIN CAPITAL LETTER U WITH HORN
  { 0x001B1, 0x0028A }, // LATIN CAPITAL LETTER UPSILON
  { 0x001B2, 0x0028B }, // LATIN CAPITAL LETTER V WITH HOOK
  { 0x001B3, 0x001B4 }, // LATIN CAPITAL LETTER Y WITH HOOK
  { 0x001B5, 0x001B6 }, // LATIN CAPITAL LETTER Z WITH STROKE
  { 0x001B7, 0x00292 }, // LATIN CAPITAL LETTER EZH
  { 0x001B8, 0x001B9 }, // LATIN CAPITAL LETTER EZH REVERSED
  { 0x001BC, 0x001BD }, // LATIN CAPITAL LETTER TONE FIVE
  { 0x001C4, 0x001C6 }, // LATIN CAPITAL LETTER DZ WITH CARON
  { 0x001C5, 0x001C6 }, // LATIN CAPITAL LETTER D WITH SMALL LETTER Z WITH CARON
  { 0x001C7, 0x001C9 }, // LATIN CAPITAL LETTER LJ
  { 0x001C8, 0x001C9 }, // LATIN CAPITAL LETTER L WITH SMALL LETTER J
  { 0x001CA, 0x001CC }, // LATIN CAPITAL LETTER NJ
  { 0x001CB, 0x001CC }, // LATIN CAPITAL LETTER N WITH SMALL LETTER J
  { 0x001CD, 0x001CE }, // LATIN CAPITAL LETTER A WITH CARON
  { 0x001CF, 0x001D0 }, // LATIN CAPITAL LETTER I WITH CARON
  { 0x001D1, 0x001D2 }, // LATIN CAPITAL LETTER O WITH CARON
  { 0x001D3, 0x001D4 }, // LATIN CAPITAL LETTER U WITH CARON
  { 0x001D5, 0x001D6 }, // LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON
  { 0x001D7, 0x001D8 }, // LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE
  { 0x001D9, 0x001DA }, // LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON
  { 0x001DB, 0x001DC }, // LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE
  { 0x001DE, 0x001DF }, // LATIN CAPITAL LETTER A WITH DIAERESIS AND MACRON
  { 0x001E0, 0x001E1 }, // LATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRON
  { 0x001E2, 0x001E3 }, // LATIN CAPITAL LETTER AE WITH MACRON
  { 0x001E4, 0x001E5 }, // LATIN CAPITAL LETTER G WITH STROKE
  { 0x001E6, 0x001E7 }, // LATIN CAPITAL LETTER G WITH CARON
  { 0x001E8, 0x001E9 }, // LATIN CAPITAL LETTER K WITH CARON
  { 0x001EA, 0x001EB }, // LATIN CAPITAL LETTER O WITH OGONEK
  { 0x001EC, 0x001ED }, // LATIN CAPITAL LETTER O WITH OGONEK AND MACRON
  { 0x001EE, 0x001EF }, // LATIN CAPITAL LETTER EZH WITH CARON
  { 0x001F1, 0x001F3 }, // LATIN CAPITAL LETTER DZ
  { 0x001F2, 0x001F3 }, // LATIN CAPITAL LETTER D WITH SMALL LETTER Z
  { 0x001F4, 0x001F5 }, // LATIN CAPITAL LETTER G WITH ACUTE
  { 0x001F6, 0x00195 }, // LATIN CAPITAL LETTER HWAIR
  { 0x001F7, 0x001BF }, // LATIN CAPITAL LETTER WYNN
  { 0x001F8, 0x001F9 }, // LATIN CAPITAL LETTER N WITH GRAVE
  { 0x001FA, 0x001FB }, // LATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTE
  { 0x001FC, 0x001FD }, // LATIN CAPITAL LETTER AE WITH ACUTE
  { 0x001FE, 0x001FF }, // LATIN CAPITAL LETTER O WITH STROKE AND ACUTE
  { 0x00200, 0x00201 }, // LATIN CAPITAL LETTER A WITH DOUBLE GRAVE
  { 0x00202, 0x00203 }, // LATIN CAPITAL LETTER A WITH INVERTED BREVE
  { 0x00204, 0x00205 }, // LATIN CAPITAL LETTER E WITH DOUBLE GRAVE
  { 0x00206, 0x00207 }, // LATIN CAPITAL LETTER E WITH INVERTED BREVE
  { 0x00208, 0x00209 }, // LATIN CAPITAL LETTER I WITH DOUBLE GRAVE
  { 0x0020A, 0x0020B }, // LATIN CAPITAL LETTER I WITH INVERTED BREVE
  { 0x0020C, 0x0020D }, // LATIN CAPITAL LETTER O WITH DOUBLE GRAVE
  { 0x0020E, 0x0020F }, // LATIN CAPITAL LETTER O WITH INVERTED BREVE
  { 0x00210, 0x00211 }, // LATIN CAPITAL LETTER R WITH DOUBLE GRAVE
  { 0x00212, 0x00213 }, // LATIN CAPITAL LETTER R WITH INVERTED BREVE
  { 0x00214, 0x00215 }, // LATIN CAPITAL LETTER U WITH DOUBLE GRAVE
  { 0x00216, 0x00217 }, // LATIN CAPITAL LETTER U WITH INVERTED BREVE
  { 0x00218, 0x00219 }, // LATIN CAPITAL LETTER S WITH COMMA BELOW
  { 0x0021A, 0x0021B }, // LATIN CAPITAL LETTER T WITH COMMA BELOW
  { 0x0021C, 0x0021D }, // LATIN CAPITAL LETTER YOGH
  { 0x0021E, 0x0021F }, // LATIN CAPITAL LETTER H WITH CARON
  { 0x00220, 0x0019E }, // LATIN CAPITAL LETTER N WITH LONG RIGHT LEG
  { 0x00222, 0x00223 }, // LATIN CAPITAL LETTER OU
  { 0x00224, 0x00225 }, // LATIN CAPITAL LETTER Z WITH HOOK
  { 0x00226, 0x00227 }, // LATIN CAPITAL LETTER A WITH DOT ABOVE
  { 0x00228, 0x00229 }, // LATIN CAPITAL LETTER E WITH CEDILLA
  { 0x0022A, 0x0022B }, // LATIN CAPITAL LETTER O WITH DIAERESIS AND MACRON
  { 0x0022C, 0x0022D }, // LATIN CAPITAL LETTER O WITH TILDE AND MACRON
  { 0x0022E, 0x0022F }, // LATIN CAPITAL LETTER O WITH DOT ABOVE
  { 0x00230, 0x00231 }, // LATIN CAPITAL LETTER O WITH DOT ABOVE AND MACRON
  { 0x00232, 0x00233 }, // LATIN CAPITAL LETTER Y WITH MACRON
  { 0x0023A, 0x02C65 }, // LATIN CAPITAL LETTER A WITH STROKE
  { 0x0023B, 0x0023C }, // LATIN CAPITAL LETTER C WITH STROKE
  { 0x0023D, 0x0019A }, // LATIN CAPITAL LETTER L WITH BAR
  { 0x0023E, 0x02C66 }, // LATIN CAPITAL LETTER T WITH DIAGONAL STROKE
  { 0x00241, 0x00242 }, // LATIN CAPITAL LETTER GLOTTAL STOP
  { 0x00243, 0x00180 }, // LATIN CAPITAL LETTER B WITH STROKE
  { 0x00244, 0x00289 }, // LATIN CAPITAL LETTER U BAR
  { 0x00245, 0x0028C }, // LATIN CAPITAL LETTER TURNED V
  { 0x00246, 0x00247 }, // LATIN CAPITAL LETTER E WITH STROKE
  { 0x00248, 0x00249 }, // LATIN CAPITAL LETTER J WITH STROKE
  { 0x0024A, 0x0024B }, // LATIN CAPITAL LETTER SMALL Q WITH HOOK TAIL
  { 0x0024C, 0x0024D }, // LATIN CAPITAL LETTER R WITH STROKE
  { 0x0024E, 0x0024F }, // LATIN CAPITAL LETTER Y WITH STROKE
  { 0x00345, 0x003B9 }, // COMBINING GREEK YPOGEGRAMMENI
  { 0x00370, 0x00371 }, // GREEK CAPITAL LETTER HETA
  { 0x00372, 0x00373 }, // GREEK CAPITAL LETTER ARCHAIC SAMPI
  { 0x00376, 0x00377 }, // GREEK CAPITAL LETTER PAMPHYLIAN DIGAMMA
  { 0x00386, 0x003AC }, // GREEK CAPITAL LETTER ALPHA WITH TONOS
  { 0x00388, 0x003AD }, // GREEK CAPITAL LETTER EPSILON WITH TONOS
  { 0x00389, 0x003AE }, // GREEK CAPITAL LETTER ETA WITH TONOS
  { 0x0038A, 0x003AF }, // GREEK CAPITAL LETTER IOTA WITH TONOS
  { 0x0038C, 0x003CC }, // GREEK CAPITAL LETTER OMICRON WITH TONOS
  { 0x0038E, 0x003CD }, // GREEK CAPITAL LETTER UPSILON WITH TONOS
  { 0x0038F, 0x003CE }, // GREEK CAPITAL LETTER OMEGA WITH TONOS
  { 0x00391, 0x003B1 }, // GREEK CAPITAL LETTER ALPHA
  { 0x00392, 0x003B2 }, // GREEK CAPITAL LETTER BETA
  { 0x00393, 0x003B3 }, // GREEK CAPITAL LETTER GAMMA
  { 0x00394, 0x003B4 }, // GREEK CAPITAL LETTER DELTA
  { 0x00395, 0x003B5 }, // GREEK CAPITAL LETTER EPSILON
  { 0x00396, 0x003B6 }, // GREEK CAPITAL LETTER ZETA
  { 0x00397, 0x003B7 }, // GREEK CAPITAL LETTER ETA
  { 0x00398, 0x003B8 }, // GREEK CAPITAL LETTER THETA
  { 0x00399, 0x003B9 }, // GREEK CAPITAL LETTER IOTA
  { 0x0039A, 0x003BA }, // GREEK CAPITAL LETTER KAPPA
  { 0x0039B, 0x003BB }, // GREEK CAPITAL LETTER LAMDA
  { 0x0039C, 0x003BC }, // GREEK CAPITAL LETTER MU
  { 0x0039D, 0x003BD }, // GREEK CAPITAL LETTER NU
  { 0x0039E, 0x003BE }, // GREEK CAPITAL LETTER XI
  { 0x0039F, 0x003BF }, // GREEK CAPITAL LETTER OMICRON
  { 0x003A0, 0x003C0 }, // GREEK CAPITAL LETTER PI
  { 0x003A1, 0x003C1 }, // GREEK CAPITAL LETTER RHO
  { 0x003A3, 0x003C3 }, // GREEK CAPITAL LETTER SIGMA
  { 0x003A4, 0x003C4 }, // GREEK CAPITAL LETTER TAU
  { 0x003A5, 0x003C5 }, // GREEK CAPITAL LETTER UPSILON
  { 0x003A6, 0x003C6 }, // GREEK CAPITAL LETTER PHI
  { 0x003A7, 0x003C7 }, // GREEK CAPITAL LETTER CHI
  { 0x003A8, 0x003C8 }, // GREEK CAPITAL LETTER PSI
  { 0x003A9, 0x003C9 }, // GREEK CAPITAL LETTER OMEGA
  { 0x003AA, 0x003CA }, // GREEK CAPITAL LETTER IOTA WITH DIALYTIKA
  { 0x003AB, 0x003CB }, // GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA
  { 0x003C2, 0x003C3 }, // GREEK SMALL LETTER FINAL SIGMA
  { 0x003CF, 0x003D7 }, // GREEK CAPITAL KAI SYMBOL
  { 0x003D0, 0x003B2 }, // GREEK BETA SYMBOL
  { 0x003D1, 0x003B8 }, // GREEK THETA SYMBOL
  { 0x003D5, 0x003C6 }, // GREEK PHI SYMBOL
  { 0x003D6, 0x003C0 }, // GREEK PI SYMBOL
  { 0x003D8, 0x003D9 }, // GREEK LETTER ARCHAIC KOPPA
  { 0x003DA, 0x003DB }, // GREEK LETTER STIGMA
  { 0x003DC, 0x003DD }, // GREEK LETTER DIGAMMA
  { 0x003DE, 0x003DF }, // GREEK LETTER KOPPA
  { 0x003E0, 0x003E1 }, // GREEK LETTER SAMPI
  { 0x003E2, 0x003E3 }, // COPTIC CAPITAL LETTER SHEI
  { 0x003E4, 0x003E5 }, // COPTIC CAPITAL LETTER FEI
  { 0x003E6, 0x003E7 }, // COPTIC CAPITAL LETTER KHEI
  { 0x003E8, 0x003E9 }, // COPTIC CAPITAL LETTER HORI
  { 0x003EA, 0x003EB }, // COPTIC CAPITAL LETTER GANGIA
  { 0x003EC, 0x003ED }, // COPTIC CAPITAL LETTER SHIMA
  { 0x003EE, 0x003EF }, // COPTIC CAPITAL LETTER DEI
  { 0x003F0, 0x003BA }, // GREEK KAPPA SYMBOL
  { 0x003F1, 0x003C1 }, // GREEK RHO SYMBOL
  { 0x003F4, 0x003B8 }, // GREEK CAPITAL THETA SYMBOL
  { 0x003F5, 0x003B5 }, // GREEK LUNATE EPSILON SYMBOL
  { 0x003F7, 0x003F8 }, // GREEK CAPITAL LETTER SHO
  { 0x003F9, 0x003F2 }, // GREEK CAPITAL LUNATE SIGMA SYMBOL
  { 0x003FA, 0x003FB }, // GREEK CAPITAL LETTER SAN
  { 0x003FD, 0x0037B }, // GREEK CAPITAL REVERSED LUNATE SIGMA SYMBOL
  { 0x003FE, 0x0037C }, // GREEK CAPITAL DOTTED LUNATE SIGMA SYMBOL
  { 0x003FF, 0x0037D }, // GREEK CAPITAL REVERSED DOTTED LUNATE SIGMA SYMBOL
  { 0x00400, 0x00450 }, // CYRILLIC CAPITAL LETTER IE WITH GRAVE
  { 0x00401, 0x00451 }, // CYRILLIC CAPITAL LETTER IO
  { 0x00402, 0x00452 }, // CYRILLIC CAPITAL LETTER DJE
  { 0x00403, 0x00453 }, // CYRILLIC CAPITAL LETTER GJE
  { 0x00404, 0x00454 }, // CYRILLIC CAPITAL LETTER UKRAINIAN IE
  { 0x00405, 0x00455 }, // CYRILLIC CAPITAL LETTER DZE
  { 0x00406, 0x00456 }, // CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I
  { 0x00407, 0x00457 }, // CYRILLIC CAPITAL LETTER YI
  { 0x00408, 0x00458 }, // CYRILLIC CAPITAL LETTER JE
  { 0x00409, 0x00459 }, // CYRILLIC CAPITAL LETTER LJE
  { 0x0040A, 0x0045A }, // CYRILLIC CAPITAL LETTER NJE
  { 0x0040B, 0x0045B }, // CYRILLIC CAPITAL LETTER TSHE
  { 0x0040C, 0x0045C }, // CYRILLIC CAPITAL LETTER KJE
  { 0x0040D, 0x0045D }, // CYRILLIC CAPITAL LETTER I WITH GRAVE
  { 0x0040E, 0x0045E }, // CYRILLIC CAPITAL LETTER SHORT U
  { 0x0040F, 0x0045F }, // CYRILLIC CAPITAL LETTER DZHE
  { 0x00410, 0x00430 }, // CYRILLIC CAPITAL LETTER A
  { 0x00411, 0x00431 }, // CYRILLIC CAPITAL LETTER BE
  { 0x00412, 0x00432 }, // CYRILLIC CAPITAL LETTER VE
  { 0x00413, 0x00433 }, // CYRILLIC CAPITAL LETTER GHE
  { 0x00414, 0x00434 }, // CYRILLIC CAPITAL LETTER DE
  { 0x00415, 0x00435 }, // CYRILLIC CAPITAL LETTER IE
  { 0x00416, 0x00436 }, // CYRILLIC CAPITAL LETTER ZHE
  { 0x00417, 0x00437 }, // CYRILLIC CAPITAL LETTER ZE
  { 0x00418, 0x00438 }, // CYRILLIC CAPITAL LETTER I
  { 0x00419, 0x00439 }, // CYRILLIC CAPITAL LETTER SHORT I
  { 0x0041A, 0x0043A }, // CYRILLIC CAPITAL LETTER KA
  { 0x0041B, 0x0043B }, // CYRILLIC CAPITAL LETTER EL
  { 0x0041C, 0x0043C }, // CYRILLIC CAPITAL LETTER EM
  { 0x0041D, 0x0043D }, // CYRILLIC CAPITAL LETTER EN
  { 0x0041E, 0x0043E }, // CYRILLIC CAPITAL LETTER O
  { 0x0041F, 0x0043F }, // CYRILLIC CAPITAL LETTER PE
  { 0x00420, 0x00440 }, // CYRILLIC CAPITAL LETTER ER
  { 0x00421, 0x00441 }, // CYRILLIC CAPITAL LETTER ES
  { 0x00422, 0x00442 }, // CYRILLIC CAPITAL LETTER TE
  { 0x00423, 0x00443 }, // CYRILLIC CAPITAL LETTER U
  { 0x00424, 0x00444 }, // CYRILLIC CAPITAL LETTER EF
  { 0x00425, 0x00445 }, // CYRILLIC CAPITAL LETTER HA
  { 0x00426, 0x00446 }, // CYRILLIC CAPITAL LETTER TSE
  { 0x00427, 0x00447 }, // CYRILLIC CAPITAL LETTER CHE
  { 0x00428, 0x00448 }, // CYRILLIC CAPITAL LETTER SHA
  { 0x00429, 0x00449 }, // CYRILLIC CAPITAL LETTER SHCHA
  { 0x0042A, 0x0044A }, // CYRILLIC CAPITAL LETTER HARD SIGN
  { 0x0042B, 0x0044B }, // CYRILLIC CAPITAL LETTER YERU
  { 0x0042C, 0x0044C }, // CYRILLIC CAPITAL LETTER SOFT SIGN
  { 0x0042D, 0x0044D }, // CYRILLIC CAPITAL LETTER E
  { 0x0042E, 0x0044E }, // CYRILLIC CAPITAL LETTER YU
  { 0x0042F, 0x0044F }, // CYRILLIC CAPITAL LETTER YA
  { 0x00460, 0x00461 }, // CYRILLIC CAPITAL LETTER OMEGA
  { 0x00462, 0x00463 }, // CYRILLIC CAPITAL LETTER YAT
  { 0x00464, 0x00465 }, // CYRILLIC CAPITAL LETTER IOTIFIED E
  { 0x00466, 0x00467 }, // CYRILLIC CAPITAL LETTER LITTLE YUS
  { 0x00468, 0x00469 }, // CYRILLIC CAPITAL LETTER IOTIFIED LITTLE YUS
  { 0x0046A, 0x0046B }, // CYRILLIC CAPITAL LETTER BIG YUS
  { 0x0046C, 0x0046D }, // CYRILLIC CAPITAL LETTER IOTIFIED BIG YUS
  { 0x0046E, 0x0046F }, // CYRILLIC CAPITAL LETTER KSI
  { 0x00470, 0x00471 }, // CYRILLIC CAPITAL LETTER PSI
  { 0x00472, 0x00473 }, // CYRILLIC CAPITAL LETTER FITA
  { 0x00474, 0x00475 }, // CYRILLIC CAPITAL LETTER IZHITSA
  { 0x00476, 0x00477 }, // CYRILLIC CAPITAL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT
  { 0x00478, 0x00479 }, // CYRILLIC CAPITAL LETTER UK
  { 0x0047A, 0x0047B }, // CYRILLIC CAPITAL LETTER ROUND OMEGA
  { 0x0047C, 0x0047D }, // CYRILLIC CAPITAL LETTER OMEGA WITH TITLO
  { 0x0047E, 0x0047F }, // CYRILLIC CAPITAL LETTER OT
  { 0x00480, 0x00481 }, // CYRILLIC CAPITAL LETTER KOPPA
  { 0x0048A, 0x0048B }, // CYRILLIC CAPITAL LETTER SHORT I WITH TAIL
  { 0x0048C, 0x0048D }, // CYRILLIC CAPITAL LETTER SEMISOFT SIGN
  { 0x0048E, 0x0048F }, // CYRILLIC CAPITAL LETTER ER WITH TICK
  { 0x00490, 0x00491 }, // CYRILLIC CAPITAL LETTER GHE WITH UPTURN
  { 0x00492, 0x00493 }, // CYRILLIC CAPITAL LETTER GHE WITH STROKE
  { 0x00494, 0x00495 }, // CYRILLIC CAPITAL LETTER GHE WITH MIDDLE HOOK
  { 0x00496, 0x00497 }, // CYRILLIC CAPITAL LETTER ZHE WITH DESCENDER
  { 0x00498, 0x00499 }, // CYRILLIC CAPITAL LETTER ZE WITH DESCENDER
  { 0x0049A, 0x0049B }, // CYRILLIC CAPITAL LETTER KA WITH DESCENDER
  { 0x0049C, 0x0049D }, // CYRILLIC CAPITAL LETTER KA WITH VERTICAL STROKE
  { 0x0049E, 0x0049F }, // CYRILLIC CAPITAL LETTER KA WITH STROKE
  { 0x004A0, 0x004A1 }, // CYRILLIC CAPITAL LETTER BASHKIR KA
  { 0x004A2, 0x004A3 }, // CYRILLIC CAPITAL LETTER EN WITH DESCENDER
  { 0x004A4, 0x004A5 }, // CYRILLIC CAPITAL LIGATURE EN GHE
  { 0x004A6, 0x004A7 }, // CYRILLIC CAPITAL LETTER PE WITH MIDDLE HOOK
  { 0x004A8, 0x004A9 }, // CYRILLIC CAPITAL LETTER ABKHASIAN HA
  { 0x004AA, 0x004AB }, // CYRILLIC CAPITAL LETTER ES WITH DESCENDER
  { 0x004AC, 0x004AD }, // CYRILLIC CAPITAL LETTER TE WITH DESCENDER
  { 0x004AE, 0x004AF }, // CYRILLIC CAPITAL LETTER STRAIGHT U
  { 0x004B0, 0x004B1 }, // CYRILLIC CAPITAL LETTER STRAIGHT U WITH STROKE
  { 0x004B2, 0x004B3 }, // CYRILLIC CAPITAL LETTER HA WITH DESCENDER
  { 0x004B4, 0x004B5 }, // CYRILLIC CAPITAL LIGATURE TE TSE
  { 0x004B6, 0x004B7 }, // CYRILLIC CAPITAL LETTER CHE WITH DESCENDER
  { 0x004B8, 0x004B9 }, // CYRILLIC CAPITAL LETTER CHE WITH VERTICAL STROKE
  { 0x004BA, 0x004BB }, // CYRILLIC CAPITAL LETTER SHHA
  { 0x004BC, 0x004BD }, // CYRILLIC CAPITAL LETTER ABKHASIAN CHE
  { 0x004BE, 0x004BF }, // CYRILLIC CAPITAL LETTER ABKHASIAN CHE WITH DESCENDER
  { 0x004C0, 0x004CF }, // CYRILLIC LETTER PALOCHKA
  { 0x004C1, 0x004C2 }, // CYRILLIC CAPITAL LETTER ZHE WITH BREVE
  { 0x004C3, 0x004C4 }, // CYRILLIC CAPITAL LETTER KA WITH HOOK
  { 0x004C5, 0x004C6 }, // CYRILLIC CAPITAL LETTER EL WITH TAIL
  { 0x004C7, 0x004C8 }, // CYRILLIC CAPITAL LETTER EN WITH HOOK
  { 0x004C9, 0x004CA }, // CYRILLIC CAPITAL LETTER EN WITH TAIL
  { 0x004CB, 0x004CC }, // CYRILLIC CAPITAL LETTER KHAKASSIAN CHE
  { 0x004CD, 0x004CE }, // CYRILLIC CAPITAL LETTER EM WITH TAIL
  { 0x004D0, 0x004D1 }, // CYRILLIC CAPITAL LETTER A WITH BREVE
  { 0x004D2, 0x004D3 }, // CYRILLIC CAPITAL LETTER A WITH DIAERESIS
  { 0x004D4, 0x004D5 }, // CYRILLIC CAPITAL LIGATURE A IE
  { 0x004D6, 0x004D7 }, // CYRILLIC CAPITAL LETTER IE WITH BREVE
  { 0x004D8, 0x004D9 }, // CYRILLIC CAPITAL LETTER SCHWA
  { 0x004DA, 0x004DB }, // CYRILLIC CAPITAL LETTER SCHWA WITH DIAERESIS
  { 0x004DC, 0x004DD }, // CYRILLIC CAPITAL LETTER ZHE WITH DIAERESIS
  { 0x004DE, 0x004DF }, // CYRILLIC CAPITAL LETTER ZE WITH DIAERESIS
  { 0x004E0, 0x004E1 }, // CYRILLIC CAPITAL LETTER ABKHASIAN DZE
  { 0x004E2, 0x004E3 }, // CYRILLIC CAPITAL LETTER I WITH MACRON
  { 0x004E4, 0x004E5 }, // CYRILLIC CAPITAL LETTER I WITH DIAERESIS
  { 0x004E6, 0x004E7 }, // CYRILLIC CAPITAL LETTER O WITH DIAERESIS
  { 0x004E8, 0x004E9 }, // CYRILLIC CAPITAL LETTER BARRED O
  { 0x004EA, 0x004EB }, // CYRILLIC CAPITAL LETTER BARRED O WITH DIAERESIS
  { 0x004EC, 0x004ED }, // CYRILLIC CAPITAL LETTER E WITH DIAERESIS
  { 0x004EE, 0x004EF }, // CYRILLIC CAPITAL LETTER U WITH MACRON
  { 0x004F0, 0x004F1 }, // CYRILLIC CAPITAL LETTER U WITH DIAERESIS
  { 0x004F2, 0x004F3 }, // CYRILLIC CAPITAL LETTER U WITH DOUBLE ACUTE
  { 0x004F4, 0x004F5 }, // CYRILLIC CAPITAL LETTER CHE WITH DIAERESIS
  { 0x004F6, 0x004F7 }, // CYRILLIC CAPITAL LETTER GHE WITH DESCENDER
  { 0x004F8, 0x004F9 }, // CYRILLIC CAPITAL LETTER YERU WITH DIAERESIS
  { 0x004FA, 0x004FB }, // CYRILLIC CAPITAL LETTER GHE WITH STROKE AND HOOK
  { 0x004FC, 0x004FD }, // CYRILLIC CAPITAL LETTER HA WITH HOOK
  { 0x004FE, 0x004FF }, // CYRILLIC CAPITAL LETTER HA WITH STROKE
  { 0x00500, 0x00501 }, // CYRILLIC CAPITAL LETTER KOMI DE
  { 0x00502, 0x00503 }, // CYRILLIC CAPITAL LETTER KOMI DJE
  { 0x00504, 0x00505 }, // CYRILLIC CAPITAL LETTER KOMI ZJE
  { 0x00506, 0x00507 }, // CYRILLIC CAPITAL LETTER KOMI DZJE
  { 0x00508, 0x00509 }, // CYRILLIC CAPITAL LETTER KOMI LJE
  { 0x0050A, 0x0050B }, // CYRILLIC CAPITAL LETTER KOMI NJE
  { 0x0050C, 0x0050D }, // CYRILLIC CAPITAL LETTER KOMI SJE
  { 0x0050E, 0x0050F }, // CYRILLIC CAPITAL LETTER KOMI TJE
  { 0x00510, 0x00511 }, // CYRILLIC CAPITAL LETTER REVERSED ZE
  { 0x00512, 0x00513 }, // CYRILLIC CAPITAL LETTER EL WITH HOOK
  { 0x00514, 0x00515 }, // CYRILLIC CAPITAL LETTER LHA
  { 0x00516, 0x00517 }, // CYRILLIC CAPITAL LETTER RHA
  { 0x00518, 0x00519 }, // CYRILLIC CAPITAL LETTER YAE
  { 0x0051A, 0x0051B }, // CYRILLIC CAPITAL LETTER QA
  { 0x0051C, 0x0051D }, // CYRILLIC CAPITAL LETTER WE
  { 0x0051E, 0x0051F }, // CYRILLIC CAPITAL LETTER ALEUT KA
  { 0x00520, 0x00521 }, // CYRILLIC CAPITAL LETTER EL WITH MIDDLE HOOK
  { 0x00522, 0x00523 }, // CYRILLIC CAPITAL LETTER EN WITH MIDDLE HOOK
  { 0x00531, 0x00561 }, // ARMENIAN CAPITAL LETTER AYB
  { 0x00532, 0x00562 }, // ARMENIAN CAPITAL LETTER BEN
  { 0x00533, 0x00563 }, // ARMENIAN CAPITAL LETTER GIM
  { 0x00534, 0x00564 }, // ARMENIAN CAPITAL LETTER DA
  { 0x00535, 0x00565 }, // ARMENIAN CAPITAL LETTER ECH
  { 0x00536, 0x00566 }, // ARMENIAN CAPITAL LETTER ZA
  { 0x00537, 0x00567 }, // ARMENIAN CAPITAL LETTER EH
  { 0x00538, 0x00568 }, // ARMENIAN CAPITAL LETTER ET
  { 0x00539, 0x00569 }, // ARMENIAN CAPITAL LETTER TO
  { 0x0053A, 0x0056A }, // ARMENIAN CAPITAL LETTER ZHE
  { 0x0053B, 0x0056B }, // ARMENIAN CAPITAL LETTER INI
  { 0x0053C, 0x0056C }, // ARMENIAN CAPITAL LETTER LIWN
  { 0x0053D, 0x0056D }, // ARMENIAN CAPITAL LETTER XEH
  { 0x0053E, 0x0056E }, // ARMENIAN CAPITAL LETTER CA
  { 0x0053F, 0x0056F }, // ARMENIAN CAPITAL LETTER KEN
  { 0x00540, 0x00570 }, // ARMENIAN CAPITAL LETTER HO
  { 0x00541, 0x00571 }, // ARMENIAN CAPITAL LETTER JA
  { 0x00542, 0x00572 }, // ARMENIAN CAPITAL LETTER GHAD
  { 0x00543, 0x00573 }, // ARMENIAN CAPITAL LETTER CHEH
  { 0x00544, 0x00574 }, // ARMENIAN CAPITAL LETTER MEN
  { 0x00545, 0x00575 }, // ARMENIAN CAPITAL LETTER YI
  { 0x00546, 0x00576 }, // ARMENIAN CAPITAL LETTER NOW
  { 0x00547, 0x00577 }, // ARMENIAN CAPITAL LETTER SHA
  { 0x00548, 0x00578 }, // ARMENIAN CAPITAL LETTER VO
  { 0x00549, 0x00579 }, // ARMENIAN CAPITAL LETTER CHA
  { 0x0054A, 0x0057A }, // ARMENIAN CAPITAL LETTER PEH
  { 0x0054B, 0x0057B }, // ARMENIAN CAPITAL LETTER JHEH
  { 0x0054C, 0x0057C }, // ARMENIAN CAPITAL LETTER RA
  { 0x0054D, 0x0057D }, // ARMENIAN CAPITAL LETTER SEH
  { 0x0054E, 0x0057E }, // ARMENIAN CAPITAL LETTER VEW
  { 0x0054F, 0x0057F }, // ARMENIAN CAPITAL LETTER TIWN
  { 0x00550, 0x00580 }, // ARMENIAN CAPITAL LETTER REH
  { 0x00551, 0x00581 }, // ARMENIAN CAPITAL LETTER CO
  { 0x00552, 0x00582 }, // ARMENIAN CAPITAL LETTER YIWN
  { 0x00553, 0x00583 }, // ARMENIAN CAPITAL LETTER PIWR
  { 0x00554, 0x00584 }, // ARMENIAN CAPITAL LETTER KEH
  { 0x00555, 0x00585 }, // ARMENIAN CAPITAL LETTER OH
  { 0x00556, 0x00586 }, // ARMENIAN CAPITAL LETTER FEH
  { 0x010A0, 0x02D00 }, // GEORGIAN CAPITAL LETTER AN
  { 0x010A1, 0x02D01 }, // GEORGIAN CAPITAL LETTER BAN
  { 0x010A2, 0x02D02 }, // GEORGIAN CAPITAL LETTER GAN
  { 0x010A3, 0x02D03 }, // GEORGIAN CAPITAL LETTER DON
  { 0x010A4, 0x02D04 }, // GEORGIAN CAPITAL LETTER EN
  { 0x010A5, 0x02D05 }, // GEORGIAN CAPITAL LETTER VIN
  { 0x010A6, 0x02D06 }, // GEORGIAN CAPITAL LETTER ZEN
  { 0x010A7, 0x02D07 }, // GEORGIAN CAPITAL LETTER TAN
  { 0x010A8, 0x02D08 }, // GEORGIAN CAPITAL LETTER IN
  { 0x010A9, 0x02D09 }, // GEORGIAN CAPITAL LETTER KAN
  { 0x010AA, 0x02D0A }, // GEORGIAN CAPITAL LETTER LAS
  { 0x010AB, 0x02D0B }, // GEORGIAN CAPITAL LETTER MAN
  { 0x010AC, 0x02D0C }, // GEORGIAN CAPITAL LETTER NAR
  { 0x010AD, 0x02D0D }, // GEORGIAN CAPITAL LETTER ON
  { 0x010AE, 0x02D0E }, // GEORGIAN CAPITAL LETTER PAR
  { 0x010AF, 0x02D0F }, // GEORGIAN CAPITAL LETTER ZHAR
  { 0x010B0, 0x02D10 }, // GEORGIAN CAPITAL LETTER RAE
  { 0x010B1, 0x02D11 }, // GEORGIAN CAPITAL LETTER SAN
  { 0x010B2, 0x02D12 }, // GEORGIAN CAPITAL LETTER TAR
  { 0x010B3, 0x02D13 }, // GEORGIAN CAPITAL LETTER UN
  { 0x010B4, 0x02D14 }, // GEORGIAN CAPITAL LETTER PHAR
  { 0x010B5, 0x02D15 }, // GEORGIAN CAPITAL LETTER KHAR
  { 0x010B6, 0x02D16 }, // GEORGIAN CAPITAL LETTER GHAN
  { 0x010B7, 0x02D17 }, // GEORGIAN CAPITAL LETTER QAR
  { 0x010B8, 0x02D18 }, // GEORGIAN CAPITAL LETTER SHIN
  { 0x010B9, 0x02D19 }, // GEORGIAN CAPITAL LETTER CHIN
  { 0x010BA, 0x02D1A }, // GEORGIAN CAPITAL LETTER CAN
  { 0x010BB, 0x02D1B }, // GEORGIAN CAPITAL LETTER JIL
  { 0x010BC, 0x02D1C }, // GEORGIAN CAPITAL LETTER CIL
  { 0x010BD, 0x02D1D }, // GEORGIAN CAPITAL LETTER CHAR
  { 0x010BE, 0x02D1E }, // GEORGIAN CAPITAL LETTER XAN
  { 0x010BF, 0x02D1F }, // GEORGIAN CAPITAL LETTER JHAN
  { 0x010C0, 0x02D20 }, // GEORGIAN CAPITAL LETTER HAE
  { 0x010C1, 0x02D21 }, // GEORGIAN CAPITAL LETTER HE
  { 0x010C2, 0x02D22 }, // GEORGIAN CAPITAL LETTER HIE
  { 0x010C3, 0x02D23 }, // GEORGIAN CAPITAL LETTER WE
  { 0x010C4, 0x02D24 }, // GEORGIAN CAPITAL LETTER HAR
  { 0x010C5, 0x02D25 }, // GEORGIAN CAPITAL LETTER HOE
  { 0x01E00, 0x01E01 }, // LATIN CAPITAL LETTER A WITH RING BELOW
  { 0x01E02, 0x01E03 }, // LATIN CAPITAL LETTER B WITH DOT ABOVE
  { 0x01E04, 0x01E05 }, // LATIN CAPITAL LETTER B WITH DOT BELOW
  { 0x01E06, 0x01E07 }, // LATIN CAPITAL LETTER B WITH LINE BELOW
  { 0x01E08, 0x01E09 }, // LATIN CAPITAL LETTER C WITH CEDILLA AND ACUTE
  { 0x01E0A, 0x01E0B }, // LATIN CAPITAL LETTER D WITH DOT ABOVE
  { 0x01E0C, 0x01E0D }, // LATIN CAPITAL LETTER D WITH DOT BELOW
  { 0x01E0E, 0x01E0F }, // LATIN CAPITAL LETTER D WITH LINE BELOW
  { 0x01E10, 0x01E11 }, // LATIN CAPITAL LETTER D WITH CEDILLA
  { 0x01E12, 0x01E13 }, // LATIN CAPITAL LETTER D WITH CIRCUMFLEX BELOW
  { 0x01E14, 0x01E15 }, // LATIN CAPITAL LETTER E WITH MACRON AND GRAVE
  { 0x01E16, 0x01E17 }, // LATIN CAPITAL LETTER E WITH MACRON AND ACUTE
  { 0x01E18, 0x01E19 }, // LATIN CAPITAL LETTER E WITH CIRCUMFLEX BELOW
  { 0x01E1A, 0x01E1B }, // LATIN CAPITAL LETTER E WITH TILDE BELOW
  { 0x01E1C, 0x01E1D }, // LATIN CAPITAL LETTER E WITH CEDILLA AND BREVE
  { 0x01E1E, 0x01E1F }, // LATIN CAPITAL LETTER F WITH DOT ABOVE
  { 0x01E20, 0x01E21 }, // LATIN CAPITAL LETTER G WITH MACRON
  { 0x01E22, 0x01E23 }, // LATIN CAPITAL LETTER H WITH DOT ABOVE
  { 0x01E24, 0x01E25 }, // LATIN CAPITAL LETTER H WITH DOT BELOW
  { 0x01E26, 0x01E27 }, // LATIN CAPITAL LETTER H WITH DIAERESIS
  { 0x01E28, 0x01E29 }, // LATIN CAPITAL LETTER H WITH CEDILLA
  { 0x01E2A, 0x01E2B }, // LATIN CAPITAL LETTER H WITH BREVE BELOW
  { 0x01E2C, 0x01E2D }, // LATIN CAPITAL LETTER I WITH TILDE BELOW
  { 0x01E2E, 0x01E2F }, // LATIN CAPITAL LETTER I WITH DIAERESIS AND ACUTE
  { 0x01E30, 0x01E31 }, // LATIN CAPITAL LETTER K WITH ACUTE
  { 0x01E32, 0x01E33 }, // LATIN CAPITAL LETTER K WITH DOT BELOW
  { 0x01E34, 0x01E35 }, // LATIN CAPITAL LETTER K WITH LINE BELOW
  { 0x01E36, 0x01E37 }, // LATIN CAPITAL LETTER L WITH DOT BELOW
  { 0x01E38, 0x01E39 }, // LATIN CAPITAL LETTER L WITH DOT BELOW AND MACRON
  { 0x01E3A, 0x01E3B }, // LATIN CAPITAL LETTER L WITH LINE BELOW
  { 0x01E3C, 0x01E3D }, // LATIN CAPITAL LETTER L WITH CIRCUMFLEX BELOW
  { 0x01E3E, 0x01E3F }, // LATIN CAPITAL LETTER M WITH ACUTE
  { 0x01E40, 0x01E41 }, // LATIN CAPITAL LETTER M WITH DOT ABOVE
  { 0x01E42, 0x01E43 }, // LATIN CAPITAL LETTER M WITH DOT BELOW
  { 0x01E44, 0x01E45 }, // LATIN CAPITAL LETTER N WITH DOT ABOVE
  { 0x01E46, 0x01E47 }, // LATIN CAPITAL LETTER N WITH DOT BELOW
  { 0x01E48, 0x01E49 }, // LATIN CAPITAL LETTER N WITH LINE BELOW
  { 0x01E4A, 0x01E4B }, // LATIN CAPITAL LETTER N WITH CIRCUMFLEX BELOW
  { 0x01E4C, 0x01E4D }, // LATIN CAPITAL LETTER O WITH TILDE AND ACUTE
  { 0x01E4E, 0x01E4F }, // LATIN CAPITAL LETTER O WITH TILDE AND DIAERESIS
  { 0x01E50, 0x01E51 }, // LATIN CAPITAL LETTER O WITH MACRON AND GRAVE
  { 0x01E52, 0x01E53 }, // LATIN CAPITAL LETTER O WITH MACRON AND ACUTE
  { 0x01E54, 0x01E55 }, // LATIN CAPITAL LETTER P WITH ACUTE
  { 0x01E56, 0x01E57 }, // LATIN CAPITAL LETTER P WITH DOT ABOVE
  { 0x01E58, 0x01E59 }, // LATIN CAPITAL LETTER R WITH DOT ABOVE
  { 0x01E5A, 0x01E5B }, // LATIN CAPITAL LETTER R WITH DOT BELOW
  { 0x01E5C, 0x01E5D }, // LATIN CAPITAL LETTER R WITH DOT BELOW AND MACRON
  { 0x01E5E, 0x01E5F }, // LATIN CAPITAL LETTER R WITH LINE BELOW
  { 0x01E60, 0x01E61 }, // LATIN CAPITAL LETTER S WITH DOT ABOVE
  { 0x01E62, 0x01E63 }, // LATIN CAPITAL LETTER S WITH DOT BELOW
  { 0x01E64, 0x01E65 }, // LATIN CAPITAL LETTER S WITH ACUTE AND DOT ABOVE
  { 0x01E66, 0x01E67 }, // LATIN CAPITAL LETTER S WITH CARON AND DOT ABOVE
  { 0x01E68, 0x01E69 }, // LATIN CAPITAL LETTER S WITH DOT BELOW AND DOT ABOVE
  { 0x01E6A, 0x01E6B }, // LATIN CAPITAL LETTER T WITH DOT ABOVE
  { 0x01E6C, 0x01E6D }, // LATIN CAPITAL LETTER T WITH DOT BELOW
  { 0x01E6E, 0x01E6F }, // LATIN CAPITAL LETTER T WITH LINE BELOW
  { 0x01E70, 0x01E71 }, // LATIN CAPITAL LETTER T WITH CIRCUMFLEX BELOW
  { 0x01E72, 0x01E73 }, // LATIN CAPITAL LETTER U WITH DIAERESIS BELOW
  { 0x01E74, 0x01E75 }, // LATIN CAPITAL LETTER U WITH TILDE BELOW
  { 0x01E76, 0x01E77 }, // LATIN CAPITAL LETTER U WITH CIRCUMFLEX BELOW
  { 0x01E78, 0x01E79 }, // LATIN CAPITAL LETTER U WITH TILDE AND ACUTE
  { 0x01E7A, 0x01E7B }, // LATIN CAPITAL LETTER U WITH MACRON AND DIAERESIS
  { 0x01E7C, 0x01E7D }, // LATIN CAPITAL LETTER V WITH TILDE
  { 0x01E7E, 0x01E7F }, // LATIN CAPITAL LETTER V WITH DOT BELOW
  { 0x01E80, 0x01E81 }, // LATIN CAPITAL LETTER W WITH GRAVE
  { 0x01E82, 0x01E83 }, // LATIN CAPITAL LETTER W WITH ACUTE
  { 0x01E84, 0x01E85 }, // LATIN CAPITAL LETTER W WITH DIAERESIS
  { 0x01E86, 0x01E87 }, // LATIN CAPITAL LETTER W WITH DOT ABOVE
  { 0x01E88, 0x01E89 }, // LATIN CAPITAL LETTER W WITH DOT BELOW
  { 0x01E8A, 0x01E8B }, // LATIN CAPITAL LETTER X WITH DOT ABOVE
  { 0x01E8C, 0x01E8D }, // LATIN CAPITAL LETTER X WITH DIAERESIS
  { 0x01E8E, 0x01E8F }, // LATIN CAPITAL LETTER Y WITH DOT ABOVE
  { 0x01E90, 0x01E91 }, // LATIN CAPITAL LETTER Z WITH CIRCUMFLEX
  { 0x01E92, 0x01E93 }, // LATIN CAPITAL LETTER Z WITH DOT BELOW
  { 0x01E94, 0x01E95 }, // LATIN CAPITAL LETTER Z WITH LINE BELOW
  { 0x01E9B, 0x01E61 }, // LATIN SMALL LETTER LONG S WITH DOT ABOVE
  { 0x01EA0, 0x01EA1 }, // LATIN CAPITAL LETTER A WITH DOT BELOW
  { 0x01EA2, 0x01EA3 }, // LATIN CAPITAL LETTER A WITH HOOK ABOVE
  { 0x01EA4, 0x01EA5 }, // LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND ACUTE
  { 0x01EA6, 0x01EA7 }, // LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND GRAVE
  { 0x01EA8, 0x01EA9 }, // LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE
  { 0x01EAA, 0x01EAB }, // LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND TILDE
  { 0x01EAC, 0x01EAD }, // LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND DOT BELOW
  { 0x01EAE, 0x01EAF }, // LATIN CAPITAL LETTER A WITH BREVE AND ACUTE
  { 0x01EB0, 0x01EB1 }, // LATIN CAPITAL LETTER A WITH BREVE AND GRAVE
  { 0x01EB2, 0x01EB3 }, // LATIN CAPITAL LETTER A WITH BREVE AND HOOK ABOVE
  { 0x01EB4, 0x01EB5 }, // LATIN CAPITAL LETTER A WITH BREVE AND TILDE
  { 0x01EB6, 0x01EB7 }, // LATIN CAPITAL LETTER A WITH BREVE AND DOT BELOW
  { 0x01EB8, 0x01EB9 }, // LATIN CAPITAL LETTER E WITH DOT BELOW
  { 0x01EBA, 0x01EBB }, // LATIN CAPITAL LETTER E WITH HOOK ABOVE
  { 0x01EBC, 0x01EBD }, // LATIN CAPITAL LETTER E WITH TILDE
  { 0x01EBE, 0x01EBF }, // LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE
  { 0x01EC0, 0x01EC1 }, // LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE
  { 0x01EC2, 0x01EC3 }, // LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
  { 0x01EC4, 0x01EC5 }, // LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND TILDE
  { 0x01EC6, 0x01EC7 }, // LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOW
  { 0x01EC8, 0x01EC9 }, // LATIN CAPITAL LETTER I WITH HOOK ABOVE
  { 0x01ECA, 0x01ECB }, // LATIN CAPITAL LETTER I WITH DOT BELOW
  { 0x01ECC, 0x01ECD }, // LATIN CAPITAL LETTER O WITH DOT BELOW
  { 0x01ECE, 0x01ECF }, // LATIN CAPITAL LETTER O WITH HOOK ABOVE
  { 0x01ED0, 0x01ED1 }, // LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND ACUTE
  { 0x01ED2, 0x01ED3 }, // LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND GRAVE
  { 0x01ED4, 0x01ED5 }, // LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE
  { 0x01ED6, 0x01ED7 }, // LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND TILDE
  { 0x01ED8, 0x01ED9 }, // LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND DOT BELOW
  { 0x01EDA, 0x01EDB }, // LATIN CAPITAL LETTER O WITH HORN AND ACUTE
  { 0x01EDC, 0x01EDD }, // LATIN CAPITAL LETTER O WITH HORN AND GRAVE
  { 0x01EDE, 0x01EDF }, // LATIN CAPITAL LETTER O WITH HORN AND HOOK ABOVE
  { 0x01EE0, 0x01EE1 }, // LATIN CAPITAL LETTER O WITH HORN AND TILDE
  { 0x01EE2, 0x01EE3 }, // LATIN CAPITAL LETTER O WITH HORN AND DOT BELOW
  { 0x01EE4, 0x01EE5 }, // LATIN CAPITAL LETTER U WITH DOT BELOW
  { 0x01EE6, 0x01EE7 }, // LATIN CAPITAL LETTER U WITH HOOK ABOVE
  { 0x01EE8, 0x01EE9 }, // LATIN CAPITAL LETTER U WITH HORN AND ACUTE
  { 0x01EEA, 0x01EEB }, // LATIN CAPITAL LETTER U WITH HORN AND GRAVE
  { 0x01EEC, 0x01EED }, // LATIN CAPITAL LETTER U WITH HORN AND HOOK ABOVE
  { 0x01EEE, 0x01EEF }, // LATIN CAPITAL LETTER U WITH HORN AND TILDE
  { 0x01EF0, 0x01EF1 }, // LATIN CAPITAL LETTER U WITH HORN AND DOT BELOW
  { 0x01EF2, 0x01EF3 }, // LATIN CAPITAL LETTER Y WITH GRAVE
  { 0x01EF4, 0x01EF5 }, // LATIN CAPITAL LETTER Y WITH DOT BELOW
  { 0x01EF6, 0x01EF7 }, // LATIN CAPITAL LETTER Y WITH HOOK ABOVE
  { 0x01EF8, 0x01EF9 }, // LATIN CAPITAL LETTER Y WITH TILDE
  { 0x01EFA, 0x01EFB }, // LATIN CAPITAL LETTER MIDDLE-WELSH LL
  { 0x01EFC, 0x01EFD }, // LATIN CAPITAL LETTER MIDDLE-WELSH V
  { 0x01EFE, 0x01EFF }, // LATIN CAPITAL LETTER Y WITH LOOP
  { 0x01F08, 0x01F00 }, // GREEK CAPITAL LETTER ALPHA WITH PSILI
  { 0x01F09, 0x01F01 }, // GREEK CAPITAL LETTER ALPHA WITH DASIA
  { 0x01F0A, 0x01F02 }, // GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA
  { 0x01F0B, 0x01F03 }, // GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA
  { 0x01F0C, 0x01F04 }, // GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA
  { 0x01F0D, 0x01F05 }, // GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA
  { 0x01F0E, 0x01F06 }, // GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI
  { 0x01F0F, 0x01F07 }, // GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI
  { 0x01F18, 0x01F10 }, // GREEK CAPITAL LETTER EPSILON WITH PSILI
  { 0x01F19, 0x01F11 }, // GREEK CAPITAL LETTER EPSILON WITH DASIA
  { 0x01F1A, 0x01F12 }, // GREEK CAPITAL LETTER EPSILON WITH PSILI AND VARIA
  { 0x01F1B, 0x01F13 }, // GREEK CAPITAL LETTER EPSILON WITH DASIA AND VARIA
  { 0x01F1C, 0x01F14 }, // GREEK CAPITAL LETTER EPSILON WITH PSILI AND OXIA
  { 0x01F1D, 0x01F15 }, // GREEK CAPITAL LETTER EPSILON WITH DASIA AND OXIA
  { 0x01F28, 0x01F20 }, // GREEK CAPITAL LETTER ETA WITH PSILI
  { 0x01F29, 0x01F21 }, // GREEK CAPITAL LETTER ETA WITH DASIA
  { 0x01F2A, 0x01F22 }, // GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA
  { 0x01F2B, 0x01F23 }, // GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA
  { 0x01F2C, 0x01F24 }, // GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA
  { 0x01F2D, 0x01F25 }, // GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA
  { 0x01F2E, 0x01F26 }, // GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI
  { 0x01F2F, 0x01F27 }, // GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI
  { 0x01F38, 0x01F30 }, // GREEK CAPITAL LETTER IOTA WITH PSILI
  { 0x01F39, 0x01F31 }, // GREEK CAPITAL LETTER IOTA WITH DASIA
  { 0x01F3A, 0x01F32 }, // GREEK CAPITAL LETTER IOTA WITH PSILI AND VARIA
  { 0x01F3B, 0x01F33 }, // GREEK CAPITAL LETTER IOTA WITH DASIA AND VARIA
  { 0x01F3C, 0x01F34 }, // GREEK CAPITAL LETTER IOTA WITH PSILI AND OXIA
  { 0x01F3D, 0x01F35 }, // GREEK CAPITAL LETTER IOTA WITH DASIA AND OXIA
  { 0x01F3E, 0x01F36 }, // GREEK CAPITAL LETTER IOTA WITH PSILI AND PERISPOMENI
  { 0x01F3F, 0x01F37 }, // GREEK CAPITAL LETTER IOTA WITH DASIA AND PERISPOMENI
  { 0x01F48, 0x01F40 }, // GREEK CAPITAL LETTER OMICRON WITH PSILI
  { 0x01F49, 0x01F41 }, // GREEK CAPITAL LETTER OMICRON WITH DASIA
  { 0x01F4A, 0x01F42 }, // GREEK CAPITAL LETTER OMICRON WITH PSILI AND VARIA
  { 0x01F4B, 0x01F43 }, // GREEK CAPITAL LETTER OMICRON WITH DASIA AND VARIA
  { 0x01F4C, 0x01F44 }, // GREEK CAPITAL LETTER OMICRON WITH PSILI AND OXIA
  { 0x01F4D, 0x01F45 }, // GREEK CAPITAL LETTER OMICRON WITH DASIA AND OXIA
  { 0x01F59, 0x01F51 }, // GREEK CAPITAL LETTER UPSILON WITH DASIA
  { 0x01F5B, 0x01F53 }, // GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA
  { 0x01F5D, 0x01F55 }, // GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA
  { 0x01F5F, 0x01F57 }, // GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI
  { 0x01F68, 0x01F60 }, // GREEK CAPITAL LETTER OMEGA WITH PSILI
  { 0x01F69, 0x01F61 }, // GREEK CAPITAL LETTER OMEGA WITH DASIA
  { 0x01F6A, 0x01F62 }, // GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA
  { 0x01F6B, 0x01F63 }, // GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA
  { 0x01F6C, 0x01F64 }, // GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA
  { 0x01F6D, 0x01F65 }, // GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA
  { 0x01F6E, 0x01F66 }, // GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI
  { 0x01F6F, 0x01F67 }, // GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI
  { 0x01F88, 0x01F80 }, // GREEK CAPITAL LETTER ALPHA WITH PSILI AND PROSGEGRAMMENI
  { 0x01F89, 0x01F81 }, // GREEK CAPITAL LETTER ALPHA WITH DASIA AND PROSGEGRAMMENI
  { 0x01F8A, 0x01F82 }, // GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA AND PROSGEGRAMMENI
  { 0x01F8B, 0x01F83 }, // GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA AND PROSGEGRAMMENI
  { 0x01F8C, 0x01F84 }, // GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA AND PROSGEGRAMMENI
  { 0x01F8D, 0x01F85 }, // GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA AND PROSGEGRAMMENI
  { 0x01F8E, 0x01F86 }, // GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI
  { 0x01F8F, 0x01F87 }, // GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
  { 0x01F98, 0x01F90 }, // GREEK CAPITAL LETTER ETA WITH PSILI AND PROSGEGRAMMENI
  { 0x01F99, 0x01F91 }, // GREEK CAPITAL LETTER ETA WITH DASIA AND PROSGEGRAMMENI
  { 0x01F9A, 0x01F92 }, // GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA AND PROSGEGRAMMENI
  { 0x01F9B, 0x01F93 }, // GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA AND PROSGEGRAMMENI
  { 0x01F9C, 0x01F94 }, // GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA AND PROSGEGRAMMENI
  { 0x01F9D, 0x01F95 }, // GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA AND PROSGEGRAMMENI
  { 0x01F9E, 0x01F96 }, // GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI
  { 0x01F9F, 0x01F97 }, // GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
  { 0x01FA8, 0x01FA0 }, // GREEK CAPITAL LETTER OMEGA WITH PSILI AND PROSGEGRAMMENI
  { 0x01FA9, 0x01FA1 }, // GREEK CAPITAL LETTER OMEGA WITH DASIA AND PROSGEGRAMMENI
  { 0x01FAA, 0x01FA2 }, // GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA AND PROSGEGRAMMENI
  { 0x01FAB, 0x01FA3 }, // GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA AND PROSGEGRAMMENI
  { 0x01FAC, 0x01FA4 }, // GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA AND PROSGEGRAMMENI
  { 0x01FAD, 0x01FA5 }, // GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA AND PROSGEGRAMMENI
  { 0x01FAE, 0x01FA6 }, // GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI
  { 0x01FAF, 0x01FA7 }, // GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
  { 0x01FB8, 0x01FB0 }, // GREEK CAPITAL LETTER ALPHA WITH VRACHY
  { 0x01FB9, 0x01FB1 }, // GREEK CAPITAL LETTER ALPHA WITH MACRON
  { 0x01FBA, 0x01F70 }, // GREEK CAPITAL LETTER ALPHA WITH VARIA
  { 0x01FBB, 0x01F71 }, // GREEK CAPITAL LETTER ALPHA WITH OXIA
  { 0x01FBC, 0x01FB3 }, // GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI
  { 0x01FBE, 0x003B9 }, // GREEK PROSGEGRAMMENI
  { 0x01FC8, 0x01F72 }, // GREEK CAPITAL LETTER EPSILON WITH VARIA
  { 0x01FC9, 0x01F73 }, // GREEK CAPITAL LETTER EPSILON WITH OXIA
  { 0x01FCA, 0x01F74 }, // GREEK CAPITAL LETTER ETA WITH VARIA
  { 0x01FCB, 0x01F75 }, // GREEK CAPITAL LETTER ETA WITH OXIA
  { 0x01FCC, 0x01FC3 }, // GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI
  { 0x01FD8, 0x01FD0 }, // GREEK CAPITAL LETTER IOTA WITH VRACHY
  { 0x01FD9, 0x01FD1 }, // GREEK CAPITAL LETTER IOTA WITH MACRON
  { 0x01FDA, 0x01F76 }, // GREEK CAPITAL LETTER IOTA WITH VARIA
  { 0x01FDB, 0x01F77 }, // GREEK CAPITAL LETTER IOTA WITH OXIA
  { 0x01FE8, 0x01FE0 }, // GREEK CAPITAL LETTER UPSILON WITH VRACHY
  { 0x01FE9, 0x01FE1 }, // GREEK CAPITAL LETTER UPSILON WITH MACRON
  { 0x01FEA, 0x01F7A }, // GREEK CAPITAL LETTER UPSILON WITH VARIA
  { 0x01FEB, 0x01F7B }, // GREEK CAPITAL LETTER UPSILON WITH OXIA
  { 0x01FEC, 0x01FE5 }, // GREEK CAPITAL LETTER RHO WITH DASIA
  { 0x01FF8, 0x01F78 }, // GREEK CAPITAL LETTER OMICRON WITH VARIA
  { 0x01FF9, 0x01F79 }, // GREEK CAPITAL LETTER OMICRON WITH OXIA
  { 0x01FFA, 0x01F7C }, // GREEK CAPITAL LETTER OMEGA WITH VARIA
  { 0x01FFB, 0x01F7D }, // GREEK CAPITAL LETTER OMEGA WITH OXIA
  { 0x01FFC, 0x01FF3 }, // GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI
  { 0x02126, 0x003C9 }, // OHM SIGN
  { 0x0212A, 0x0006B }, // KELVIN SIGN
  { 0x0212B, 0x000E5 }, // ANGSTROM SIGN
  { 0x02132, 0x0214E }, // TURNED CAPITAL F
  { 0x02160, 0x02170 }, // ROMAN NUMERAL ONE
  { 0x02161, 0x02171 }, // ROMAN NUMERAL TWO
  { 0x02162, 0x02172 }, // ROMAN NUMERAL THREE
  { 0x02163, 0x02173 }, // ROMAN NUMERAL FOUR
  { 0x02164, 0x02174 }, // ROMAN NUMERAL FIVE
  { 0x02165, 0x02175 }, // ROMAN NUMERAL SIX
  { 0x02166, 0x02176 }, // ROMAN NUMERAL SEVEN
  { 0x02167, 0x02177 }, // ROMAN NUMERAL EIGHT
  { 0x02168, 0x02178 }, // ROMAN NUMERAL NINE
  { 0x02169, 0x02179 }, // ROMAN NUMERAL TEN
  { 0x0216A, 0x0217A }, // ROMAN NUMERAL ELEVEN
  { 0x0216B, 0x0217B }, // ROMAN NUMERAL TWELVE
  { 0x0216C, 0x0217C }, // ROMAN NUMERAL FIFTY
  { 0x0216D, 0x0217D }, // ROMAN NUMERAL ONE HUNDRED
  { 0x0216E, 0x0217E }, // ROMAN NUMERAL FIVE HUNDRED
  { 0x0216F, 0x0217F }, // ROMAN NUMERAL ONE THOUSAND
  { 0x02183, 0x02184 }, // ROMAN NUMERAL REVERSED ONE HUNDRED
  { 0x024B6, 0x024D0 }, // CIRCLED LATIN CAPITAL LETTER A
  { 0x024B7, 0x024D1 }, // CIRCLED LATIN CAPITAL LETTER B
  { 0x024B8, 0x024D2 }, // CIRCLED LATIN CAPITAL LETTER C
  { 0x024B9, 0x024D3 }, // CIRCLED LATIN CAPITAL LETTER D
  { 0x024BA, 0x024D4 }, // CIRCLED LATIN CAPITAL LETTER E
  { 0x024BB, 0x024D5 }, // CIRCLED LATIN CAPITAL LETTER F
  { 0x024BC, 0x024D6 }, // CIRCLED LATIN CAPITAL LETTER G
  { 0x024BD, 0x024D7 }, // CIRCLED LATIN CAPITAL LETTER H
  { 0x024BE, 0x024D8 }, // CIRCLED LATIN CAPITAL LETTER I
  { 0x024BF, 0x024D9 }, // CIRCLED LATIN CAPITAL LETTER J
  { 0x024C0, 0x024DA }, // CIRCLED LATIN CAPITAL LETTER K
  { 0x024C1, 0x024DB }, // CIRCLED LATIN CAPITAL LETTER L
  { 0x024C2, 0x024DC }, // CIRCLED LATIN CAPITAL LETTER M
  { 0x024C3, 0x024DD }, // CIRCLED LATIN CAPITAL LETTER N
  { 0x024C4, 0x024DE }, // CIRCLED LATIN CAPITAL LETTER O
  { 0x024C5, 0x024DF }, // CIRCLED LATIN CAPITAL LETTER P
  { 0x024C6, 0x024E0 }, // CIRCLED LATIN CAPITAL LETTER Q
  { 0x024C7, 0x024E1 }, // CIRCLED LATIN CAPITAL LETTER R
  { 0x024C8, 0x024E2 }, // CIRCLED LATIN CAPITAL LETTER S
  { 0x024C9, 0x024E3 }, // CIRCLED LATIN CAPITAL LETTER T
  { 0x024CA, 0x024E4 }, // CIRCLED LATIN CAPITAL LETTER U
  { 0x024CB, 0x024E5 }, // CIRCLED LATIN CAPITAL LETTER V
  { 0x024CC, 0x024E6 }, // CIRCLED LATIN CAPITAL LETTER W
  { 0x024CD, 0x024E7 }, // CIRCLED LATIN CAPITAL LETTER X
  { 0x024CE, 0x024E8 }, // CIRCLED LATIN CAPITAL LETTER Y
  { 0x024CF, 0x024E9 }, // CIRCLED LATIN CAPITAL LETTER Z
  { 0x02C00, 0x02C30 }, // GLAGOLITIC CAPITAL LETTER AZU
  { 0x02C01, 0x02C31 }, // GLAGOLITIC CAPITAL LETTER BUKY
  { 0x02C02, 0x02C32 }, // GLAGOLITIC CAPITAL LETTER VEDE
  { 0x02C03, 0x02C33 }, // GLAGOLITIC CAPITAL LETTER GLAGOLI
  { 0x02C04, 0x02C34 }, // GLAGOLITIC CAPITAL LETTER DOBRO
  { 0x02C05, 0x02C35 }, // GLAGOLITIC CAPITAL LETTER YESTU
  { 0x02C06, 0x02C36 }, // GLAGOLITIC CAPITAL LETTER ZHIVETE
  { 0x02C07, 0x02C37 }, // GLAGOLITIC CAPITAL LETTER DZELO
  { 0x02C08, 0x02C38 }, // GLAGOLITIC CAPITAL LETTER ZEMLJA
  { 0x02C09, 0x02C39 }, // GLAGOLITIC CAPITAL LETTER IZHE
  { 0x02C0A, 0x02C3A }, // GLAGOLITIC CAPITAL LETTER INITIAL IZHE
  { 0x02C0B, 0x02C3B }, // GLAGOLITIC CAPITAL LETTER I
  { 0x02C0C, 0x02C3C }, // GLAGOLITIC CAPITAL LETTER DJERVI
  { 0x02C0D, 0x02C3D }, // GLAGOLITIC CAPITAL LETTER KAKO
  { 0x02C0E, 0x02C3E }, // GLAGOLITIC CAPITAL LETTER LJUDIJE
  { 0x02C0F, 0x02C3F }, // GLAGOLITIC CAPITAL LETTER MYSLITE
  { 0x02C10, 0x02C40 }, // GLAGOLITIC CAPITAL LETTER NASHI
  { 0x02C11, 0x02C41 }, // GLAGOLITIC CAPITAL LETTER ONU
  { 0x02C12, 0x02C42 }, // GLAGOLITIC CAPITAL LETTER POKOJI
  { 0x02C13, 0x02C43 }, // GLAGOLITIC CAPITAL LETTER RITSI
  { 0x02C14, 0x02C44 }, // GLAGOLITIC CAPITAL LETTER SLOVO
  { 0x02C15, 0x02C45 }, // GLAGOLITIC CAPITAL LETTER TVRIDO
  { 0x02C16, 0x02C46 }, // GLAGOLITIC CAPITAL LETTER UKU
  { 0x02C17, 0x02C47 }, // GLAGOLITIC CAPITAL LETTER FRITU
  { 0x02C18, 0x02C48 }, // GLAGOLITIC CAPITAL LETTER HERU
  { 0x02C19, 0x02C49 }, // GLAGOLITIC CAPITAL LETTER OTU
  { 0x02C1A, 0x02C4A }, // GLAGOLITIC CAPITAL LETTER PE
  { 0x02C1B, 0x02C4B }, // GLAGOLITIC CAPITAL LETTER SHTA
  { 0x02C1C, 0x02C4C }, // GLAGOLITIC CAPITAL LETTER TSI
  { 0x02C1D, 0x02C4D }, // GLAGOLITIC CAPITAL LETTER CHRIVI
  { 0x02C1E, 0x02C4E }, // GLAGOLITIC CAPITAL LETTER SHA
  { 0x02C1F, 0x02C4F }, // GLAGOLITIC CAPITAL LETTER YERU
  { 0x02C20, 0x02C50 }, // GLAGOLITIC CAPITAL LETTER YERI
  { 0x02C21, 0x02C51 }, // GLAGOLITIC CAPITAL LETTER YATI
  { 0x02C22, 0x02C52 }, // GLAGOLITIC CAPITAL LETTER SPIDERY HA
  { 0x02C23, 0x02C53 }, // GLAGOLITIC CAPITAL LETTER YU
  { 0x02C24, 0x02C54 }, // GLAGOLITIC CAPITAL LETTER SMALL YUS
  { 0x02C25, 0x02C55 }, // GLAGOLITIC CAPITAL LETTER SMALL YUS WITH TAIL
  { 0x02C26, 0x02C56 }, // GLAGOLITIC CAPITAL LETTER YO
  { 0x02C27, 0x02C57 }, // GLAGOLITIC CAPITAL LETTER IOTATED SMALL YUS
  { 0x02C28, 0x02C58 }, // GLAGOLITIC CAPITAL LETTER BIG YUS
  { 0x02C29, 0x02C59 }, // GLAGOLITIC CAPITAL LETTER IOTATED BIG YUS
  { 0x02C2A, 0x02C5A }, // GLAGOLITIC CAPITAL LETTER FITA
  { 0x02C2B, 0x02C5B }, // GLAGOLITIC CAPITAL LETTER IZHITSA
  { 0x02C2C, 0x02C5C }, // GLAGOLITIC CAPITAL LETTER SHTAPIC
  { 0x02C2D, 0x02C5D }, // GLAGOLITIC CAPITAL LETTER TROKUTASTI A
  { 0x02C2E, 0x02C5E }, // GLAGOLITIC CAPITAL LETTER LATINATE MYSLITE
  { 0x02C60, 0x02C61 }, // LATIN CAPITAL LETTER L WITH DOUBLE BAR
  { 0x02C62, 0x0026B }, // LATIN CAPITAL LETTER L WITH MIDDLE TILDE
  { 0x02C63, 0x01D7D }, // LATIN CAPITAL LETTER P WITH STROKE
  { 0x02C64, 0x0027D }, // LATIN CAPITAL LETTER R WITH TAIL
  { 0x02C67, 0x02C68 }, // LATIN CAPITAL LETTER H WITH DESCENDER
  { 0x02C69, 0x02C6A }, // LATIN CAPITAL LETTER K WITH DESCENDER
  { 0x02C6B, 0x02C6C }, // LATIN CAPITAL LETTER Z WITH DESCENDER
  { 0x02C6D, 0x00251 }, // LATIN CAPITAL LETTER ALPHA
  { 0x02C6E, 0x00271 }, // LATIN CAPITAL LETTER M WITH HOOK
  { 0x02C6F, 0x00250 }, // LATIN CAPITAL LETTER TURNED A
  { 0x02C72, 0x02C73 }, // LATIN CAPITAL LETTER W WITH HOOK
  { 0x02C75, 0x02C76 }, // LATIN CAPITAL LETTER HALF H
  { 0x02C80, 0x02C81 }, // COPTIC CAPITAL LETTER ALFA
  { 0x02C82, 0x02C83 }, // COPTIC CAPITAL LETTER VIDA
  { 0x02C84, 0x02C85 }, // COPTIC CAPITAL LETTER GAMMA
  { 0x02C86, 0x02C87 }, // COPTIC CAPITAL LETTER DALDA
  { 0x02C88, 0x02C89 }, // COPTIC CAPITAL LETTER EIE
  { 0x02C8A, 0x02C8B }, // COPTIC CAPITAL LETTER SOU
  { 0x02C8C, 0x02C8D }, // COPTIC CAPITAL LETTER ZATA
  { 0x02C8E, 0x02C8F }, // COPTIC CAPITAL LETTER HATE
  { 0x02C90, 0x02C91 }, // COPTIC CAPITAL LETTER THETHE
  { 0x02C92, 0x02C93 }, // COPTIC CAPITAL LETTER IAUDA
  { 0x02C94, 0x02C95 }, // COPTIC CAPITAL LETTER KAPA
  { 0x02C96, 0x02C97 }, // COPTIC CAPITAL LETTER LAULA
  { 0x02C98, 0x02C99 }, // COPTIC CAPITAL LETTER MI
  { 0x02C9A, 0x02C9B }, // COPTIC CAPITAL LETTER NI
  { 0x02C9C, 0x02C9D }, // COPTIC CAPITAL LETTER KSI
  { 0x02C9E, 0x02C9F }, // COPTIC CAPITAL LETTER O
  { 0x02CA0, 0x02CA1 }, // COPTIC CAPITAL LETTER PI
  { 0x02CA2, 0x02CA3 }, // COPTIC CAPITAL LETTER RO
  { 0x02CA4, 0x02CA5 }, // COPTIC CAPITAL LETTER SIMA
  { 0x02CA6, 0x02CA7 }, // COPTIC CAPITAL LETTER TAU
  { 0x02CA8, 0x02CA9 }, // COPTIC CAPITAL LETTER UA
  { 0x02CAA, 0x02CAB }, // COPTIC CAPITAL LETTER FI
  { 0x02CAC, 0x02CAD }, // COPTIC CAPITAL LETTER KHI
  { 0x02CAE, 0x02CAF }, // COPTIC CAPITAL LETTER PSI
  { 0x02CB0, 0x02CB1 }, // COPTIC CAPITAL LETTER OOU
  { 0x02CB2, 0x02CB3 }, // COPTIC CAPITAL LETTER DIALECT-P ALEF
  { 0x02CB4, 0x02CB5 }, // COPTIC CAPITAL LETTER OLD COPTIC AIN
  { 0x02CB6, 0x02CB7 }, // COPTIC CAPITAL LETTER CRYPTOGRAMMIC EIE
  { 0x02CB8, 0x02CB9 }, // COPTIC CAPITAL LETTER DIALECT-P KAPA
  { 0x02CBA, 0x02CBB }, // COPTIC CAPITAL LETTER DIALECT-P NI
  { 0x02CBC, 0x02CBD }, // COPTIC CAPITAL LETTER CRYPTOGRAMMIC NI
  { 0x02CBE, 0x02CBF }, // COPTIC CAPITAL LETTER OLD COPTIC OOU
  { 0x02CC0, 0x02CC1 }, // COPTIC CAPITAL LETTER SAMPI
  { 0x02CC2, 0x02CC3 }, // COPTIC CAPITAL LETTER CROSSED SHEI
  { 0x02CC4, 0x02CC5 }, // COPTIC CAPITAL LETTER OLD COPTIC SHEI
  { 0x02CC6, 0x02CC7 }, // COPTIC CAPITAL LETTER OLD COPTIC ESH
  { 0x02CC8, 0x02CC9 }, // COPTIC CAPITAL LETTER AKHMIMIC KHEI
  { 0x02CCA, 0x02CCB }, // COPTIC CAPITAL LETTER DIALECT-P HORI
  { 0x02CCC, 0x02CCD }, // COPTIC CAPITAL LETTER OLD COPTIC HORI
  { 0x02CCE, 0x02CCF }, // COPTIC CAPITAL LETTER OLD COPTIC HA
  { 0x02CD0, 0x02CD1 }, // COPTIC CAPITAL LETTER L-SHAPED HA
  { 0x02CD2, 0x02CD3 }, // COPTIC CAPITAL LETTER OLD COPTIC HEI
  { 0x02CD4, 0x02CD5 }, // COPTIC CAPITAL LETTER OLD COPTIC HAT
  { 0x02CD6, 0x02CD7 }, // COPTIC CAPITAL LETTER OLD COPTIC GANGIA
  { 0x02CD8, 0x02CD9 }, // COPTIC CAPITAL LETTER OLD COPTIC DJA
  { 0x02CDA, 0x02CDB }, // COPTIC CAPITAL LETTER OLD COPTIC SHIMA
  { 0x02CDC, 0x02CDD }, // COPTIC CAPITAL LETTER OLD NUBIAN SHIMA
  { 0x02CDE, 0x02CDF }, // COPTIC CAPITAL LETTER OLD NUBIAN NGI
  { 0x02CE0, 0x02CE1 }, // COPTIC CAPITAL LETTER OLD NUBIAN NYI
  { 0x02CE2, 0x02CE3 }, // COPTIC CAPITAL LETTER OLD NUBIAN WAU
  { 0x0A640, 0x0A641 }, // CYRILLIC CAPITAL LETTER ZEMLYA
  { 0x0A642, 0x0A643 }, // CYRILLIC CAPITAL LETTER DZELO
  { 0x0A644, 0x0A645 }, // CYRILLIC CAPITAL LETTER REVERSED DZE
  { 0x0A646, 0x0A647 }, // CYRILLIC CAPITAL LETTER IOTA
  { 0x0A648, 0x0A649 }, // CYRILLIC CAPITAL LETTER DJERV
  { 0x0A64A, 0x0A64B }, // CYRILLIC CAPITAL LETTER MONOGRAPH UK
  { 0x0A64C, 0x0A64D }, // CYRILLIC CAPITAL LETTER BROAD OMEGA
  { 0x0A64E, 0x0A64F }, // CYRILLIC CAPITAL LETTER NEUTRAL YER
  { 0x0A650, 0x0A651 }, // CYRILLIC CAPITAL LETTER YERU WITH BACK YER
  { 0x0A652, 0x0A653 }, // CYRILLIC CAPITAL LETTER IOTIFIED YAT
  { 0x0A654, 0x0A655 }, // CYRILLIC CAPITAL LETTER REVERSED YU
  { 0x0A656, 0x0A657 }, // CYRILLIC CAPITAL LETTER IOTIFIED A
  { 0x0A658, 0x0A659 }, // CYRILLIC CAPITAL LETTER CLOSED LITTLE YUS
  { 0x0A65A, 0x0A65B }, // CYRILLIC CAPITAL LETTER BLENDED YUS
  { 0x0A65C, 0x0A65D }, // CYRILLIC CAPITAL LETTER IOTIFIED CLOSED LITTLE YUS
  { 0x0A65E, 0x0A65F }, // CYRILLIC CAPITAL LETTER YN
  { 0x0A662, 0x0A663 }, // CYRILLIC CAPITAL LETTER SOFT DE
  { 0x0A664, 0x0A665 }, // CYRILLIC CAPITAL LETTER SOFT EL
  { 0x0A666, 0x0A667 }, // CYRILLIC CAPITAL LETTER SOFT EM
  { 0x0A668, 0x0A669 }, // CYRILLIC CAPITAL LETTER MONOCULAR O
  { 0x0A66A, 0x0A66B }, // CYRILLIC CAPITAL LETTER BINOCULAR O
  { 0x0A66C, 0x0A66D }, // CYRILLIC CAPITAL LETTER DOUBLE MONOCULAR O
  { 0x0A680, 0x0A681 }, // CYRILLIC CAPITAL LETTER DWE
  { 0x0A682, 0x0A683 }, // CYRILLIC CAPITAL LETTER DZWE
  { 0x0A684, 0x0A685 }, // CYRILLIC CAPITAL LETTER ZHWE
  { 0x0A686, 0x0A687 }, // CYRILLIC CAPITAL LETTER CCHE
  { 0x0A688, 0x0A689 }, // CYRILLIC CAPITAL LETTER DZZE
  { 0x0A68A, 0x0A68B }, // CYRILLIC CAPITAL LETTER TE WITH MIDDLE HOOK
  { 0x0A68C, 0x0A68D }, // CYRILLIC CAPITAL LETTER TWE
  { 0x0A68E, 0x0A68F }, // CYRILLIC CAPITAL LETTER TSWE
  { 0x0A690, 0x0A691 }, // CYRILLIC CAPITAL LETTER TSSE
  { 0x0A692, 0x0A693 }, // CYRILLIC CAPITAL LETTER TCHE
  { 0x0A694, 0x0A695 }, // CYRILLIC CAPITAL LETTER HWE
  { 0x0A696, 0x0A697 }, // CYRILLIC CAPITAL LETTER SHWE
  { 0x0A722, 0x0A723 }, // LATIN CAPITAL LETTER EGYPTOLOGICAL ALEF
  { 0x0A724, 0x0A725 }, // LATIN CAPITAL LETTER EGYPTOLOGICAL AIN
  { 0x0A726, 0x0A727 }, // LATIN CAPITAL LETTER HENG
  { 0x0A728, 0x0A729 }, // LATIN CAPITAL LETTER TZ
  { 0x0A72A, 0x0A72B }, // LATIN CAPITAL LETTER TRESILLO
  { 0x0A72C, 0x0A72D }, // LATIN CAPITAL LETTER CUATRILLO
  { 0x0A72E, 0x0A72F }, // LATIN CAPITAL LETTER CUATRILLO WITH COMMA
  { 0x0A732, 0x0A733 }, // LATIN CAPITAL LETTER AA
  { 0x0A734, 0x0A735 }, // LATIN CAPITAL LETTER AO
  { 0x0A736, 0x0A737 }, // LATIN CAPITAL LETTER AU
  { 0x0A738, 0x0A739 }, // LATIN CAPITAL LETTER AV
  { 0x0A73A, 0x0A73B }, // LATIN CAPITAL LETTER AV WITH HORIZONTAL BAR
  { 0x0A73C, 0x0A73D }, // LATIN CAPITAL LETTER AY
  { 0x0A73E, 0x0A73F }, // LATIN CAPITAL LETTER REVERSED C WITH DOT
  { 0x0A740, 0x0A741 }, // LATIN CAPITAL LETTER K WITH STROKE
  { 0x0A742, 0x0A743 }, // LATIN CAPITAL LETTER K WITH DIAGONAL STROKE
  { 0x0A744, 0x0A745 }, // LATIN CAPITAL LETTER K WITH STROKE AND DIAGONAL STROKE
  { 0x0A746, 0x0A747 }, // LATIN CAPITAL LETTER BROKEN L
  { 0x0A748, 0x0A749 }, // LATIN CAPITAL LETTER L WITH HIGH STROKE
  { 0x0A74A, 0x0A74B }, // LATIN CAPITAL LETTER O WITH LONG STROKE OVERLAY
  { 0x0A74C, 0x0A74D }, // LATIN CAPITAL LETTER O WITH LOOP
  { 0x0A74E, 0x0A74F }, // LATIN CAPITAL LETTER OO
  { 0x0A750, 0x0A751 }, // LATIN CAPITAL LETTER P WITH STROKE THROUGH DESCENDER
  { 0x0A752, 0x0A753 }, // LATIN CAPITAL LETTER P WITH FLOURISH
  { 0x0A754, 0x0A755 }, // LATIN CAPITAL LETTER P WITH SQUIRREL TAIL
  { 0x0A756, 0x0A757 }, // LATIN CAPITAL LETTER Q WITH STROKE THROUGH DESCENDER
  { 0x0A758, 0x0A759 }, // LATIN CAPITAL LETTER Q WITH DIAGONAL STROKE
  { 0x0A75A, 0x0A75B }, // LATIN CAPITAL LETTER R ROTUNDA
  { 0x0A75C, 0x0A75D }, // LATIN CAPITAL LETTER RUM ROTUNDA
  { 0x0A75E, 0x0A75F }, // LATIN CAPITAL LETTER V WITH DIAGONAL STROKE
  { 0x0A760, 0x0A761 }, // LATIN CAPITAL LETTER VY
  { 0x0A762, 0x0A763 }, // LATIN CAPITAL LETTER VISIGOTHIC Z
  { 0x0A764, 0x0A765 }, // LATIN CAPITAL LETTER THORN WITH STROKE
  { 0x0A766, 0x0A767 }, // LATIN CAPITAL LETTER THORN WITH STROKE THROUGH DESCENDER
  { 0x0A768, 0x0A769 }, // LATIN CAPITAL LETTER VEND
  { 0x0A76A, 0x0A76B }, // LATIN CAPITAL LETTER ET
  { 0x0A76C, 0x0A76D }, // LATIN CAPITAL LETTER IS
  { 0x0A76E, 0x0A76F }, // LATIN CAPITAL LETTER CON
  { 0x0A779, 0x0A77A }, // LATIN CAPITAL LETTER INSULAR D
  { 0x0A77B, 0x0A77C }, // LATIN CAPITAL LETTER INSULAR F
  { 0x0A77D, 0x01D79 }, // LATIN CAPITAL LETTER INSULAR G
  { 0x0A77E, 0x0A77F }, // LATIN CAPITAL LETTER TURNED INSULAR G
  { 0x0A780, 0x0A781 }, // LATIN CAPITAL LETTER TURNED L
  { 0x0A782, 0x0A783 }, // LATIN CAPITAL LETTER INSULAR R
  { 0x0A784, 0x0A785 }, // LATIN CAPITAL LETTER INSULAR S
  { 0x0A786, 0x0A787 }, // LATIN CAPITAL LETTER INSULAR T
  { 0x0A78B, 0x0A78C }, // LATIN CAPITAL LETTER SALTILLO
  { 0x0FF21, 0x0FF41 }, // FULLWIDTH LATIN CAPITAL LETTER A
  { 0x0FF22, 0x0FF42 }, // FULLWIDTH LATIN CAPITAL LETTER B
  { 0x0FF23, 0x0FF43 }, // FULLWIDTH LATIN CAPITAL LETTER C
  { 0x0FF24, 0x0FF44 }, // FULLWIDTH LATIN CAPITAL LETTER D
  { 0x0FF25, 0x0FF45 }, // FULLWIDTH LATIN CAPITAL LETTER E
  { 0x0FF26, 0x0FF46 }, // FULLWIDTH LATIN CAPITAL LETTER F
  { 0x0FF27, 0x0FF47 }, // FULLWIDTH LATIN CAPITAL LETTER G
  { 0x0FF28, 0x0FF48 }, // FULLWIDTH LATIN CAPITAL LETTER H
  { 0x0FF29, 0x0FF49 }, // FULLWIDTH LATIN CAPITAL LETTER I
  { 0x0FF2A, 0x0FF4A }, // FULLWIDTH LATIN CAPITAL LETTER J
  { 0x0FF2B, 0x0FF4B }, // FULLWIDTH LATIN CAPITAL LETTER K
  { 0x0FF2C, 0x0FF4C }, // FULLWIDTH LATIN CAPITAL LETTER L
  { 0x0FF2D, 0x0FF4D }, // FULLWIDTH LATIN CAPITAL LETTER M
  { 0x0FF2E, 0x0FF4E }, // FULLWIDTH LATIN CAPITAL LETTER N
  { 0x0FF2F, 0x0FF4F }, // FULLWIDTH LATIN CAPITAL LETTER O
  { 0x0FF30, 0x0FF50 }, // FULLWIDTH LATIN CAPITAL LETTER P
  { 0x0FF31, 0x0FF51 }, // FULLWIDTH LATIN CAPITAL LETTER Q
  { 0x0FF32, 0x0FF52 }, // FULLWIDTH LATIN CAPITAL LETTER R
  { 0x0FF33, 0x0FF53 }, // FULLWIDTH LATIN CAPITAL LETTER S
  { 0x0FF34, 0x0FF54 }, // FULLWIDTH LATIN CAPITAL LETTER T
  { 0x0FF35, 0x0FF55 }, // FULLWIDTH LATIN CAPITAL LETTER U
  { 0x0FF36, 0x0FF56 }, // FULLWIDTH LATIN CAPITAL LETTER V
  { 0x0FF37, 0x0FF57 }, // FULLWIDTH LATIN CAPITAL LETTER W
  { 0x0FF38, 0x0FF58 }, // FULLWIDTH LATIN CAPITAL LETTER X
  { 0x0FF39, 0x0FF59 }, // FULLWIDTH LATIN CAPITAL LETTER Y
  { 0x0FF3A, 0x0FF5A }, // FULLWIDTH LATIN CAPITAL LETTER Z
  { 0x10400, 0x10428 }, // DESERET CAPITAL LETTER LONG I
  { 0x10401, 0x10429 }, // DESERET CAPITAL LETTER LONG E
  { 0x10402, 0x1042A }, // DESERET CAPITAL LETTER LONG A
  { 0x10403, 0x1042B }, // DESERET CAPITAL LETTER LONG AH
  { 0x10404, 0x1042C }, // DESERET CAPITAL LETTER LONG O
  { 0x10405, 0x1042D }, // DESERET CAPITAL LETTER LONG OO
  { 0x10406, 0x1042E }, // DESERET CAPITAL LETTER SHORT I
  { 0x10407, 0x1042F }, // DESERET CAPITAL LETTER SHORT E
  { 0x10408, 0x10430 }, // DESERET CAPITAL LETTER SHORT A
  { 0x10409, 0x10431 }, // DESERET CAPITAL LETTER SHORT AH
  { 0x1040A, 0x10432 }, // DESERET CAPITAL LETTER SHORT O
  { 0x1040B, 0x10433 }, // DESERET CAPITAL LETTER SHORT OO
  { 0x1040C, 0x10434 }, // DESERET CAPITAL LETTER AY
  { 0x1040D, 0x10435 }, // DESERET CAPITAL LETTER OW
  { 0x1040E, 0x10436 }, // DESERET CAPITAL LETTER WU
  { 0x1040F, 0x10437 }, // DESERET CAPITAL LETTER YEE
  { 0x10410, 0x10438 }, // DESERET CAPITAL LETTER H
  { 0x10411, 0x10439 }, // DESERET CAPITAL LETTER PEE
  { 0x10412, 0x1043A }, // DESERET CAPITAL LETTER BEE
  { 0x10413, 0x1043B }, // DESERET CAPITAL LETTER TEE
  { 0x10414, 0x1043C }, // DESERET CAPITAL LETTER DEE
  { 0x10415, 0x1043D }, // DESERET CAPITAL LETTER CHEE
  { 0x10416, 0x1043E }, // DESERET CAPITAL LETTER JEE
  { 0x10417, 0x1043F }, // DESERET CAPITAL LETTER KAY
  { 0x10418, 0x10440 }, // DESERET CAPITAL LETTER GAY
  { 0x10419, 0x10441 }, // DESERET CAPITAL LETTER EF
  { 0x1041A, 0x10442 }, // DESERET CAPITAL LETTER VEE
  { 0x1041B, 0x10443 }, // DESERET CAPITAL LETTER ETH
  { 0x1041C, 0x10444 }, // DESERET CAPITAL LETTER THEE
  { 0x1041D, 0x10445 }, // DESERET CAPITAL LETTER ES
  { 0x1041E, 0x10446 }, // DESERET CAPITAL LETTER ZEE
  { 0x1041F, 0x10447 }, // DESERET CAPITAL LETTER ESH
  { 0x10420, 0x10448 }, // DESERET CAPITAL LETTER ZHEE
  { 0x10421, 0x10449 }, // DESERET CAPITAL LETTER ER
  { 0x10422, 0x1044A }, // DESERET CAPITAL LETTER EL
  { 0x10423, 0x1044B }, // DESERET CAPITAL LETTER EM
  { 0x10424, 0x1044C }, // DESERET CAPITAL LETTER EN
  { 0x10425, 0x1044D }, // DESERET CAPITAL LETTER ENG
  { 0x10426, 0x1044E }, // DESERET CAPITAL LETTER OI
  { 0x10427, 0x1044F }, // DESERET CAPITAL LETTER EW
};

//
// This table is the same as the upper2lower table except (a) the columns are
// flipped in order to do binary-search look-up by lower-case letter and (b)
// duplicates in the left column have been deleted.
//
case_table_entry const lower2upper[] = {
  { 0x00061, 0x00041 }, // LATIN CAPITAL LETTER A
  { 0x00062, 0x00042 }, // LATIN CAPITAL LETTER B
  { 0x00063, 0x00043 }, // LATIN CAPITAL LETTER C
  { 0x00064, 0x00044 }, // LATIN CAPITAL LETTER D
  { 0x00065, 0x00045 }, // LATIN CAPITAL LETTER E
  { 0x00066, 0x00046 }, // LATIN CAPITAL LETTER F
  { 0x00067, 0x00047 }, // LATIN CAPITAL LETTER G
  { 0x00068, 0x00048 }, // LATIN CAPITAL LETTER H
  { 0x00069, 0x00049 }, // LATIN CAPITAL LETTER I
  { 0x0006A, 0x0004A }, // LATIN CAPITAL LETTER J
  { 0x0006B, 0x0004B }, // LATIN CAPITAL LETTER K
  { 0x0006C, 0x0004C }, // LATIN CAPITAL LETTER L
  { 0x0006D, 0x0004D }, // LATIN CAPITAL LETTER M
  { 0x0006E, 0x0004E }, // LATIN CAPITAL LETTER N
  { 0x0006F, 0x0004F }, // LATIN CAPITAL LETTER O
  { 0x00070, 0x00050 }, // LATIN CAPITAL LETTER P
  { 0x00071, 0x00051 }, // LATIN CAPITAL LETTER Q
  { 0x00072, 0x00052 }, // LATIN CAPITAL LETTER R
  { 0x00073, 0x00053 }, // LATIN CAPITAL LETTER S
  { 0x00074, 0x00054 }, // LATIN CAPITAL LETTER T
  { 0x00075, 0x00055 }, // LATIN CAPITAL LETTER U
  { 0x00076, 0x00056 }, // LATIN CAPITAL LETTER V
  { 0x00077, 0x00057 }, // LATIN CAPITAL LETTER W
  { 0x00078, 0x00058 }, // LATIN CAPITAL LETTER X
  { 0x00079, 0x00059 }, // LATIN CAPITAL LETTER Y
  { 0x0007A, 0x0005A }, // LATIN CAPITAL LETTER Z
  { 0x000E0, 0x000C0 }, // LATIN CAPITAL LETTER A WITH GRAVE
  { 0x000E1, 0x000C1 }, // LATIN CAPITAL LETTER A WITH ACUTE
  { 0x000E2, 0x000C2 }, // LATIN CAPITAL LETTER A WITH CIRCUMFLEX
  { 0x000E3, 0x000C3 }, // LATIN CAPITAL LETTER A WITH TILDE
  { 0x000E4, 0x000C4 }, // LATIN CAPITAL LETTER A WITH DIAERESIS
  { 0x000E5, 0x000C5 }, // LATIN CAPITAL LETTER A WITH RING ABOVE
  { 0x000E6, 0x000C6 }, // LATIN CAPITAL LETTER AE
  { 0x000E7, 0x000C7 }, // LATIN CAPITAL LETTER C WITH CEDILLA
  { 0x000E8, 0x000C8 }, // LATIN CAPITAL LETTER E WITH GRAVE
  { 0x000E9, 0x000C9 }, // LATIN CAPITAL LETTER E WITH ACUTE
  { 0x000EA, 0x000CA }, // LATIN CAPITAL LETTER E WITH CIRCUMFLEX
  { 0x000EB, 0x000CB }, // LATIN CAPITAL LETTER E WITH DIAERESIS
  { 0x000EC, 0x000CC }, // LATIN CAPITAL LETTER I WITH GRAVE
  { 0x000ED, 0x000CD }, // LATIN CAPITAL LETTER I WITH ACUTE
  { 0x000EE, 0x000CE }, // LATIN CAPITAL LETTER I WITH CIRCUMFLEX
  { 0x000EF, 0x000CF }, // LATIN CAPITAL LETTER I WITH DIAERESIS
  { 0x000F0, 0x000D0 }, // LATIN CAPITAL LETTER ETH
  { 0x000F1, 0x000D1 }, // LATIN CAPITAL LETTER N WITH TILDE
  { 0x000F2, 0x000D2 }, // LATIN CAPITAL LETTER O WITH GRAVE
  { 0x000F3, 0x000D3 }, // LATIN CAPITAL LETTER O WITH ACUTE
  { 0x000F4, 0x000D4 }, // LATIN CAPITAL LETTER O WITH CIRCUMFLEX
  { 0x000F5, 0x000D5 }, // LATIN CAPITAL LETTER O WITH TILDE
  { 0x000F6, 0x000D6 }, // LATIN CAPITAL LETTER O WITH DIAERESIS
  { 0x000F8, 0x000D8 }, // LATIN CAPITAL LETTER O WITH STROKE
  { 0x000F9, 0x000D9 }, // LATIN CAPITAL LETTER U WITH GRAVE
  { 0x000FA, 0x000DA }, // LATIN CAPITAL LETTER U WITH ACUTE
  { 0x000FB, 0x000DB }, // LATIN CAPITAL LETTER U WITH CIRCUMFLEX
  { 0x000FC, 0x000DC }, // LATIN CAPITAL LETTER U WITH DIAERESIS
  { 0x000FD, 0x000DD }, // LATIN CAPITAL LETTER Y WITH ACUTE
  { 0x000FE, 0x000DE }, // LATIN CAPITAL LETTER THORN
  { 0x000FF, 0x00178 }, // LATIN CAPITAL LETTER Y WITH DIAERESIS
  { 0x00101, 0x00100 }, // LATIN CAPITAL LETTER A WITH MACRON
  { 0x00103, 0x00102 }, // LATIN CAPITAL LETTER A WITH BREVE
  { 0x00105, 0x00104 }, // LATIN CAPITAL LETTER A WITH OGONEK
  { 0x00107, 0x00106 }, // LATIN CAPITAL LETTER C WITH ACUTE
  { 0x00109, 0x00108 }, // LATIN CAPITAL LETTER C WITH CIRCUMFLEX
  { 0x0010B, 0x0010A }, // LATIN CAPITAL LETTER C WITH DOT ABOVE
  { 0x0010D, 0x0010C }, // LATIN CAPITAL LETTER C WITH CARON
  { 0x0010F, 0x0010E }, // LATIN CAPITAL LETTER D WITH CARON
  { 0x00111, 0x00110 }, // LATIN CAPITAL LETTER D WITH STROKE
  { 0x00113, 0x00112 }, // LATIN CAPITAL LETTER E WITH MACRON
  { 0x00115, 0x00114 }, // LATIN CAPITAL LETTER E WITH BREVE
  { 0x00117, 0x00116 }, // LATIN CAPITAL LETTER E WITH DOT ABOVE
  { 0x00119, 0x00118 }, // LATIN CAPITAL LETTER E WITH OGONEK
  { 0x0011B, 0x0011A }, // LATIN CAPITAL LETTER E WITH CARON
  { 0x0011D, 0x0011C }, // LATIN CAPITAL LETTER G WITH CIRCUMFLEX
  { 0x0011F, 0x0011E }, // LATIN CAPITAL LETTER G WITH BREVE
  { 0x00121, 0x00120 }, // LATIN CAPITAL LETTER G WITH DOT ABOVE
  { 0x00123, 0x00122 }, // LATIN CAPITAL LETTER G WITH CEDILLA
  { 0x00125, 0x00124 }, // LATIN CAPITAL LETTER H WITH CIRCUMFLEX
  { 0x00127, 0x00126 }, // LATIN CAPITAL LETTER H WITH STROKE
  { 0x00129, 0x00128 }, // LATIN CAPITAL LETTER I WITH TILDE
  { 0x0012B, 0x0012A }, // LATIN CAPITAL LETTER I WITH MACRON
  { 0x0012D, 0x0012C }, // LATIN CAPITAL LETTER I WITH BREVE
  { 0x0012F, 0x0012E }, // LATIN CAPITAL LETTER I WITH OGONEK
  { 0x00133, 0x00132 }, // LATIN CAPITAL LIGATURE IJ
  { 0x00135, 0x00134 }, // LATIN CAPITAL LETTER J WITH CIRCUMFLEX
  { 0x00137, 0x00136 }, // LATIN CAPITAL LETTER K WITH CEDILLA
  { 0x0013A, 0x00139 }, // LATIN CAPITAL LETTER L WITH ACUTE
  { 0x0013C, 0x0013B }, // LATIN CAPITAL LETTER L WITH CEDILLA
  { 0x0013E, 0x0013D }, // LATIN CAPITAL LETTER L WITH CARON
  { 0x00140, 0x0013F }, // LATIN CAPITAL LETTER L WITH MIDDLE DOT
  { 0x00142, 0x00141 }, // LATIN CAPITAL LETTER L WITH STROKE
  { 0x00144, 0x00143 }, // LATIN CAPITAL LETTER N WITH ACUTE
  { 0x00146, 0x00145 }, // LATIN CAPITAL LETTER N WITH CEDILLA
  { 0x00148, 0x00147 }, // LATIN CAPITAL LETTER N WITH CARON
  { 0x0014B, 0x0014A }, // LATIN CAPITAL LETTER ENG
  { 0x0014D, 0x0014C }, // LATIN CAPITAL LETTER O WITH MACRON
  { 0x0014F, 0x0014E }, // LATIN CAPITAL LETTER O WITH BREVE
  { 0x00151, 0x00150 }, // LATIN CAPITAL LETTER O WITH DOUBLE ACUTE
  { 0x00153, 0x00152 }, // LATIN CAPITAL LIGATURE OE
  { 0x00155, 0x00154 }, // LATIN CAPITAL LETTER R WITH ACUTE
  { 0x00157, 0x00156 }, // LATIN CAPITAL LETTER R WITH CEDILLA
  { 0x00159, 0x00158 }, // LATIN CAPITAL LETTER R WITH CARON
  { 0x0015B, 0x0015A }, // LATIN CAPITAL LETTER S WITH ACUTE
  { 0x0015D, 0x0015C }, // LATIN CAPITAL LETTER S WITH CIRCUMFLEX
  { 0x0015F, 0x0015E }, // LATIN CAPITAL LETTER S WITH CEDILLA
  { 0x00161, 0x00160 }, // LATIN CAPITAL LETTER S WITH CARON
  { 0x00163, 0x00162 }, // LATIN CAPITAL LETTER T WITH CEDILLA
  { 0x00165, 0x00164 }, // LATIN CAPITAL LETTER T WITH CARON
  { 0x00167, 0x00166 }, // LATIN CAPITAL LETTER T WITH STROKE
  { 0x00169, 0x00168 }, // LATIN CAPITAL LETTER U WITH TILDE
  { 0x0016B, 0x0016A }, // LATIN CAPITAL LETTER U WITH MACRON
  { 0x0016D, 0x0016C }, // LATIN CAPITAL LETTER U WITH BREVE
  { 0x0016F, 0x0016E }, // LATIN CAPITAL LETTER U WITH RING ABOVE
  { 0x00171, 0x00170 }, // LATIN CAPITAL LETTER U WITH DOUBLE ACUTE
  { 0x00173, 0x00172 }, // LATIN CAPITAL LETTER U WITH OGONEK
  { 0x00175, 0x00174 }, // LATIN CAPITAL LETTER W WITH CIRCUMFLEX
  { 0x00177, 0x00176 }, // LATIN CAPITAL LETTER Y WITH CIRCUMFLEX
  { 0x0017A, 0x00179 }, // LATIN CAPITAL LETTER Z WITH ACUTE
  { 0x0017C, 0x0017B }, // LATIN CAPITAL LETTER Z WITH DOT ABOVE
  { 0x0017E, 0x0017D }, // LATIN CAPITAL LETTER Z WITH CARON
  { 0x00180, 0x00243 }, // LATIN CAPITAL LETTER B WITH STROKE
  { 0x00183, 0x00182 }, // LATIN CAPITAL LETTER B WITH TOPBAR
  { 0x00185, 0x00184 }, // LATIN CAPITAL LETTER TONE SIX
  { 0x00188, 0x00187 }, // LATIN CAPITAL LETTER C WITH HOOK
  { 0x0018C, 0x0018B }, // LATIN CAPITAL LETTER D WITH TOPBAR
  { 0x00192, 0x00191 }, // LATIN CAPITAL LETTER F WITH HOOK
  { 0x00195, 0x001F6 }, // LATIN CAPITAL LETTER HWAIR
  { 0x00199, 0x00198 }, // LATIN CAPITAL LETTER K WITH HOOK
  { 0x0019A, 0x0023D }, // LATIN CAPITAL LETTER L WITH BAR
  { 0x0019E, 0x00220 }, // LATIN CAPITAL LETTER N WITH LONG RIGHT LEG
  { 0x001A1, 0x001A0 }, // LATIN CAPITAL LETTER O WITH HORN
  { 0x001A3, 0x001A2 }, // LATIN CAPITAL LETTER OI
  { 0x001A5, 0x001A4 }, // LATIN CAPITAL LETTER P WITH HOOK
  { 0x001A8, 0x001A7 }, // LATIN CAPITAL LETTER TONE TWO
  { 0x001AD, 0x001AC }, // LATIN CAPITAL LETTER T WITH HOOK
  { 0x001B0, 0x001AF }, // LATIN CAPITAL LETTER U WITH HORN
  { 0x001B4, 0x001B3 }, // LATIN CAPITAL LETTER Y WITH HOOK
  { 0x001B6, 0x001B5 }, // LATIN CAPITAL LETTER Z WITH STROKE
  { 0x001B9, 0x001B8 }, // LATIN CAPITAL LETTER EZH REVERSED
  { 0x001BD, 0x001BC }, // LATIN CAPITAL LETTER TONE FIVE
  { 0x001BF, 0x001F7 }, // LATIN CAPITAL LETTER WYNN
  { 0x001C6, 0x001C4 }, // LATIN CAPITAL LETTER DZ WITH CARON
  { 0x001C9, 0x001C7 }, // LATIN CAPITAL LETTER LJ
  { 0x001CC, 0x001CA }, // LATIN CAPITAL LETTER NJ
  { 0x001CE, 0x001CD }, // LATIN CAPITAL LETTER A WITH CARON
  { 0x001D0, 0x001CF }, // LATIN CAPITAL LETTER I WITH CARON
  { 0x001D2, 0x001D1 }, // LATIN CAPITAL LETTER O WITH CARON
  { 0x001D4, 0x001D3 }, // LATIN CAPITAL LETTER U WITH CARON
  { 0x001D6, 0x001D5 }, // LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON
  { 0x001D8, 0x001D7 }, // LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE
  { 0x001DA, 0x001D9 }, // LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON
  { 0x001DC, 0x001DB }, // LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE
  { 0x001DD, 0x0018E }, // LATIN CAPITAL LETTER REVERSED E
  { 0x001DF, 0x001DE }, // LATIN CAPITAL LETTER A WITH DIAERESIS AND MACRON
  { 0x001E1, 0x001E0 }, // LATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRON
  { 0x001E3, 0x001E2 }, // LATIN CAPITAL LETTER AE WITH MACRON
  { 0x001E5, 0x001E4 }, // LATIN CAPITAL LETTER G WITH STROKE
  { 0x001E7, 0x001E6 }, // LATIN CAPITAL LETTER G WITH CARON
  { 0x001E9, 0x001E8 }, // LATIN CAPITAL LETTER K WITH CARON
  { 0x001EB, 0x001EA }, // LATIN CAPITAL LETTER O WITH OGONEK
  { 0x001ED, 0x001EC }, // LATIN CAPITAL LETTER O WITH OGONEK AND MACRON
  { 0x001EF, 0x001EE }, // LATIN CAPITAL LETTER EZH WITH CARON
  { 0x001F3, 0x001F1 }, // LATIN CAPITAL LETTER DZ
  { 0x001F5, 0x001F4 }, // LATIN CAPITAL LETTER G WITH ACUTE
  { 0x001F9, 0x001F8 }, // LATIN CAPITAL LETTER N WITH GRAVE
  { 0x001FB, 0x001FA }, // LATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTE
  { 0x001FD, 0x001FC }, // LATIN CAPITAL LETTER AE WITH ACUTE
  { 0x001FF, 0x001FE }, // LATIN CAPITAL LETTER O WITH STROKE AND ACUTE
  { 0x00201, 0x00200 }, // LATIN CAPITAL LETTER A WITH DOUBLE GRAVE
  { 0x00203, 0x00202 }, // LATIN CAPITAL LETTER A WITH INVERTED BREVE
  { 0x00205, 0x00204 }, // LATIN CAPITAL LETTER E WITH DOUBLE GRAVE
  { 0x00207, 0x00206 }, // LATIN CAPITAL LETTER E WITH INVERTED BREVE
  { 0x00209, 0x00208 }, // LATIN CAPITAL LETTER I WITH DOUBLE GRAVE
  { 0x0020B, 0x0020A }, // LATIN CAPITAL LETTER I WITH INVERTED BREVE
  { 0x0020D, 0x0020C }, // LATIN CAPITAL LETTER O WITH DOUBLE GRAVE
  { 0x0020F, 0x0020E }, // LATIN CAPITAL LETTER O WITH INVERTED BREVE
  { 0x00211, 0x00210 }, // LATIN CAPITAL LETTER R WITH DOUBLE GRAVE
  { 0x00213, 0x00212 }, // LATIN CAPITAL LETTER R WITH INVERTED BREVE
  { 0x00215, 0x00214 }, // LATIN CAPITAL LETTER U WITH DOUBLE GRAVE
  { 0x00217, 0x00216 }, // LATIN CAPITAL LETTER U WITH INVERTED BREVE
  { 0x00219, 0x00218 }, // LATIN CAPITAL LETTER S WITH COMMA BELOW
  { 0x0021B, 0x0021A }, // LATIN CAPITAL LETTER T WITH COMMA BELOW
  { 0x0021D, 0x0021C }, // LATIN CAPITAL LETTER YOGH
  { 0x0021F, 0x0021E }, // LATIN CAPITAL LETTER H WITH CARON
  { 0x00223, 0x00222 }, // LATIN CAPITAL LETTER OU
  { 0x00225, 0x00224 }, // LATIN CAPITAL LETTER Z WITH HOOK
  { 0x00227, 0x00226 }, // LATIN CAPITAL LETTER A WITH DOT ABOVE
  { 0x00229, 0x00228 }, // LATIN CAPITAL LETTER E WITH CEDILLA
  { 0x0022B, 0x0022A }, // LATIN CAPITAL LETTER O WITH DIAERESIS AND MACRON
  { 0x0022D, 0x0022C }, // LATIN CAPITAL LETTER O WITH TILDE AND MACRON
  { 0x0022F, 0x0022E }, // LATIN CAPITAL LETTER O WITH DOT ABOVE
  { 0x00231, 0x00230 }, // LATIN CAPITAL LETTER O WITH DOT ABOVE AND MACRON
  { 0x00233, 0x00232 }, // LATIN CAPITAL LETTER Y WITH MACRON
  { 0x0023C, 0x0023B }, // LATIN CAPITAL LETTER C WITH STROKE
  { 0x00242, 0x00241 }, // LATIN CAPITAL LETTER GLOTTAL STOP
  { 0x00247, 0x00246 }, // LATIN CAPITAL LETTER E WITH STROKE
  { 0x00249, 0x00248 }, // LATIN CAPITAL LETTER J WITH STROKE
  { 0x0024B, 0x0024A }, // LATIN CAPITAL LETTER SMALL Q WITH HOOK TAIL
  { 0x0024D, 0x0024C }, // LATIN CAPITAL LETTER R WITH STROKE
  { 0x0024F, 0x0024E }, // LATIN CAPITAL LETTER Y WITH STROKE
  { 0x00250, 0x02C6F }, // LATIN CAPITAL LETTER TURNED A
  { 0x00251, 0x02C6D }, // LATIN CAPITAL LETTER ALPHA
  { 0x00253, 0x00181 }, // LATIN CAPITAL LETTER B WITH HOOK
  { 0x00254, 0x00186 }, // LATIN CAPITAL LETTER OPEN O
  { 0x00256, 0x00189 }, // LATIN CAPITAL LETTER AFRICAN D
  { 0x00257, 0x0018A }, // LATIN CAPITAL LETTER D WITH HOOK
  { 0x00259, 0x0018F }, // LATIN CAPITAL LETTER SCHWA
  { 0x0025B, 0x00190 }, // LATIN CAPITAL LETTER OPEN E
  { 0x00260, 0x00193 }, // LATIN CAPITAL LETTER G WITH HOOK
  { 0x00263, 0x00194 }, // LATIN CAPITAL LETTER GAMMA
  { 0x00268, 0x00197 }, // LATIN CAPITAL LETTER I WITH STROKE
  { 0x00269, 0x00196 }, // LATIN CAPITAL LETTER IOTA
  { 0x0026B, 0x02C62 }, // LATIN CAPITAL LETTER L WITH MIDDLE TILDE
  { 0x0026F, 0x0019C }, // LATIN CAPITAL LETTER TURNED M
  { 0x00271, 0x02C6E }, // LATIN CAPITAL LETTER M WITH HOOK
  { 0x00272, 0x0019D }, // LATIN CAPITAL LETTER N WITH LEFT HOOK
  { 0x00275, 0x0019F }, // LATIN CAPITAL LETTER O WITH MIDDLE TILDE
  { 0x0027D, 0x02C64 }, // LATIN CAPITAL LETTER R WITH TAIL
  { 0x00280, 0x001A6 }, // LATIN LETTER YR
  { 0x00283, 0x001A9 }, // LATIN CAPITAL LETTER ESH
  { 0x00288, 0x001AE }, // LATIN CAPITAL LETTER T WITH RETROFLEX HOOK
  { 0x00289, 0x00244 }, // LATIN CAPITAL LETTER U BAR
  { 0x0028A, 0x001B1 }, // LATIN CAPITAL LETTER UPSILON
  { 0x0028B, 0x001B2 }, // LATIN CAPITAL LETTER V WITH HOOK
  { 0x0028C, 0x00245 }, // LATIN CAPITAL LETTER TURNED V
  { 0x00292, 0x001B7 }, // LATIN CAPITAL LETTER EZH
  { 0x00371, 0x00370 }, // GREEK CAPITAL LETTER HETA
  { 0x00373, 0x00372 }, // GREEK CAPITAL LETTER ARCHAIC SAMPI
  { 0x00377, 0x00376 }, // GREEK CAPITAL LETTER PAMPHYLIAN DIGAMMA
  { 0x0037B, 0x003FD }, // GREEK CAPITAL REVERSED LUNATE SIGMA SYMBOL
  { 0x0037C, 0x003FE }, // GREEK CAPITAL DOTTED LUNATE SIGMA SYMBOL
  { 0x0037D, 0x003FF }, // GREEK CAPITAL REVERSED DOTTED LUNATE SIGMA SYMBOL
  { 0x003AC, 0x00386 }, // GREEK CAPITAL LETTER ALPHA WITH TONOS
  { 0x003AD, 0x00388 }, // GREEK CAPITAL LETTER EPSILON WITH TONOS
  { 0x003AE, 0x00389 }, // GREEK CAPITAL LETTER ETA WITH TONOS
  { 0x003AF, 0x0038A }, // GREEK CAPITAL LETTER IOTA WITH TONOS
  { 0x003B1, 0x00391 }, // GREEK CAPITAL LETTER ALPHA
  { 0x003B2, 0x00392 }, // GREEK CAPITAL LETTER BETA
  { 0x003B3, 0x00393 }, // GREEK CAPITAL LETTER GAMMA
  { 0x003B4, 0x00394 }, // GREEK CAPITAL LETTER DELTA
  { 0x003B5, 0x00395 }, // GREEK CAPITAL LETTER EPSILON
  { 0x003B6, 0x00396 }, // GREEK CAPITAL LETTER ZETA
  { 0x003B7, 0x00397 }, // GREEK CAPITAL LETTER ETA
  { 0x003B8, 0x00398 }, // GREEK CAPITAL LETTER THETA
  { 0x003B9, 0x00399 }, // GREEK CAPITAL LETTER IOTA
  { 0x003BA, 0x0039A }, // GREEK CAPITAL LETTER KAPPA
  { 0x003BB, 0x0039B }, // GREEK CAPITAL LETTER LAMDA
  { 0x003BC, 0x0039C }, // GREEK CAPITAL LETTER MU
  { 0x003BD, 0x0039D }, // GREEK CAPITAL LETTER NU
  { 0x003BE, 0x0039E }, // GREEK CAPITAL LETTER XI
  { 0x003BF, 0x0039F }, // GREEK CAPITAL LETTER OMICRON
  { 0x003C0, 0x003A0 }, // GREEK CAPITAL LETTER PI
  { 0x003C1, 0x003A1 }, // GREEK CAPITAL LETTER RHO
  { 0x003C3, 0x003A3 }, // GREEK CAPITAL LETTER SIGMA
  { 0x003C4, 0x003A4 }, // GREEK CAPITAL LETTER TAU
  { 0x003C5, 0x003A5 }, // GREEK CAPITAL LETTER UPSILON
  { 0x003C6, 0x003A6 }, // GREEK CAPITAL LETTER PHI
  { 0x003C7, 0x003A7 }, // GREEK CAPITAL LETTER CHI
  { 0x003C8, 0x003A8 }, // GREEK CAPITAL LETTER PSI
  { 0x003C9, 0x003A9 }, // GREEK CAPITAL LETTER OMEGA
  { 0x003CA, 0x003AA }, // GREEK CAPITAL LETTER IOTA WITH DIALYTIKA
  { 0x003CB, 0x003AB }, // GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA
  { 0x003CC, 0x0038C }, // GREEK CAPITAL LETTER OMICRON WITH TONOS
  { 0x003CD, 0x0038E }, // GREEK CAPITAL LETTER UPSILON WITH TONOS
  { 0x003CE, 0x0038F }, // GREEK CAPITAL LETTER OMEGA WITH TONOS
  { 0x003D7, 0x003CF }, // GREEK CAPITAL KAI SYMBOL
  { 0x003D9, 0x003D8 }, // GREEK LETTER ARCHAIC KOPPA
  { 0x003DB, 0x003DA }, // GREEK LETTER STIGMA
  { 0x003DD, 0x003DC }, // GREEK LETTER DIGAMMA
  { 0x003DF, 0x003DE }, // GREEK LETTER KOPPA
  { 0x003E1, 0x003E0 }, // GREEK LETTER SAMPI
  { 0x003E3, 0x003E2 }, // COPTIC CAPITAL LETTER SHEI
  { 0x003E5, 0x003E4 }, // COPTIC CAPITAL LETTER FEI
  { 0x003E7, 0x003E6 }, // COPTIC CAPITAL LETTER KHEI
  { 0x003E9, 0x003E8 }, // COPTIC CAPITAL LETTER HORI
  { 0x003EB, 0x003EA }, // COPTIC CAPITAL LETTER GANGIA
  { 0x003ED, 0x003EC }, // COPTIC CAPITAL LETTER SHIMA
  { 0x003EF, 0x003EE }, // COPTIC CAPITAL LETTER DEI
  { 0x003F2, 0x003F9 }, // GREEK CAPITAL LUNATE SIGMA SYMBOL
  { 0x003F8, 0x003F7 }, // GREEK CAPITAL LETTER SHO
  { 0x003FB, 0x003FA }, // GREEK CAPITAL LETTER SAN
  { 0x00430, 0x00410 }, // CYRILLIC CAPITAL LETTER A
  { 0x00431, 0x00411 }, // CYRILLIC CAPITAL LETTER BE
  { 0x00432, 0x00412 }, // CYRILLIC CAPITAL LETTER VE
  { 0x00433, 0x00413 }, // CYRILLIC CAPITAL LETTER GHE
  { 0x00434, 0x00414 }, // CYRILLIC CAPITAL LETTER DE
  { 0x00435, 0x00415 }, // CYRILLIC CAPITAL LETTER IE
  { 0x00436, 0x00416 }, // CYRILLIC CAPITAL LETTER ZHE
  { 0x00437, 0x00417 }, // CYRILLIC CAPITAL LETTER ZE
  { 0x00438, 0x00418 }, // CYRILLIC CAPITAL LETTER I
  { 0x00439, 0x00419 }, // CYRILLIC CAPITAL LETTER SHORT I
  { 0x0043A, 0x0041A }, // CYRILLIC CAPITAL LETTER KA
  { 0x0043B, 0x0041B }, // CYRILLIC CAPITAL LETTER EL
  { 0x0043C, 0x0041C }, // CYRILLIC CAPITAL LETTER EM
  { 0x0043D, 0x0041D }, // CYRILLIC CAPITAL LETTER EN
  { 0x0043E, 0x0041E }, // CYRILLIC CAPITAL LETTER O
  { 0x0043F, 0x0041F }, // CYRILLIC CAPITAL LETTER PE
  { 0x00440, 0x00420 }, // CYRILLIC CAPITAL LETTER ER
  { 0x00441, 0x00421 }, // CYRILLIC CAPITAL LETTER ES
  { 0x00442, 0x00422 }, // CYRILLIC CAPITAL LETTER TE
  { 0x00443, 0x00423 }, // CYRILLIC CAPITAL LETTER U
  { 0x00444, 0x00424 }, // CYRILLIC CAPITAL LETTER EF
  { 0x00445, 0x00425 }, // CYRILLIC CAPITAL LETTER HA
  { 0x00446, 0x00426 }, // CYRILLIC CAPITAL LETTER TSE
  { 0x00447, 0x00427 }, // CYRILLIC CAPITAL LETTER CHE
  { 0x00448, 0x00428 }, // CYRILLIC CAPITAL LETTER SHA
  { 0x00449, 0x00429 }, // CYRILLIC CAPITAL LETTER SHCHA
  { 0x0044A, 0x0042A }, // CYRILLIC CAPITAL LETTER HARD SIGN
  { 0x0044B, 0x0042B }, // CYRILLIC CAPITAL LETTER YERU
  { 0x0044C, 0x0042C }, // CYRILLIC CAPITAL LETTER SOFT SIGN
  { 0x0044D, 0x0042D }, // CYRILLIC CAPITAL LETTER E
  { 0x0044E, 0x0042E }, // CYRILLIC CAPITAL LETTER YU
  { 0x0044F, 0x0042F }, // CYRILLIC CAPITAL LETTER YA
  { 0x00450, 0x00400 }, // CYRILLIC CAPITAL LETTER IE WITH GRAVE
  { 0x00451, 0x00401 }, // CYRILLIC CAPITAL LETTER IO
  { 0x00452, 0x00402 }, // CYRILLIC CAPITAL LETTER DJE
  { 0x00453, 0x00403 }, // CYRILLIC CAPITAL LETTER GJE
  { 0x00454, 0x00404 }, // CYRILLIC CAPITAL LETTER UKRAINIAN IE
  { 0x00455, 0x00405 }, // CYRILLIC CAPITAL LETTER DZE
  { 0x00456, 0x00406 }, // CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I
  { 0x00457, 0x00407 }, // CYRILLIC CAPITAL LETTER YI
  { 0x00458, 0x00408 }, // CYRILLIC CAPITAL LETTER JE
  { 0x00459, 0x00409 }, // CYRILLIC CAPITAL LETTER LJE
  { 0x0045A, 0x0040A }, // CYRILLIC CAPITAL LETTER NJE
  { 0x0045B, 0x0040B }, // CYRILLIC CAPITAL LETTER TSHE
  { 0x0045C, 0x0040C }, // CYRILLIC CAPITAL LETTER KJE
  { 0x0045D, 0x0040D }, // CYRILLIC CAPITAL LETTER I WITH GRAVE
  { 0x0045E, 0x0040E }, // CYRILLIC CAPITAL LETTER SHORT U
  { 0x0045F, 0x0040F }, // CYRILLIC CAPITAL LETTER DZHE
  { 0x00461, 0x00460 }, // CYRILLIC CAPITAL LETTER OMEGA
  { 0x00463, 0x00462 }, // CYRILLIC CAPITAL LETTER YAT
  { 0x00465, 0x00464 }, // CYRILLIC CAPITAL LETTER IOTIFIED E
  { 0x00467, 0x00466 }, // CYRILLIC CAPITAL LETTER LITTLE YUS
  { 0x00469, 0x00468 }, // CYRILLIC CAPITAL LETTER IOTIFIED LITTLE YUS
  { 0x0046B, 0x0046A }, // CYRILLIC CAPITAL LETTER BIG YUS
  { 0x0046D, 0x0046C }, // CYRILLIC CAPITAL LETTER IOTIFIED BIG YUS
  { 0x0046F, 0x0046E }, // CYRILLIC CAPITAL LETTER KSI
  { 0x00471, 0x00470 }, // CYRILLIC CAPITAL LETTER PSI
  { 0x00473, 0x00472 }, // CYRILLIC CAPITAL LETTER FITA
  { 0x00475, 0x00474 }, // CYRILLIC CAPITAL LETTER IZHITSA
  { 0x00477, 0x00476 }, // CYRILLIC CAPITAL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT
  { 0x00479, 0x00478 }, // CYRILLIC CAPITAL LETTER UK
  { 0x0047B, 0x0047A }, // CYRILLIC CAPITAL LETTER ROUND OMEGA
  { 0x0047D, 0x0047C }, // CYRILLIC CAPITAL LETTER OMEGA WITH TITLO
  { 0x0047F, 0x0047E }, // CYRILLIC CAPITAL LETTER OT
  { 0x00481, 0x00480 }, // CYRILLIC CAPITAL LETTER KOPPA
  { 0x0048B, 0x0048A }, // CYRILLIC CAPITAL LETTER SHORT I WITH TAIL
  { 0x0048D, 0x0048C }, // CYRILLIC CAPITAL LETTER SEMISOFT SIGN
  { 0x0048F, 0x0048E }, // CYRILLIC CAPITAL LETTER ER WITH TICK
  { 0x00491, 0x00490 }, // CYRILLIC CAPITAL LETTER GHE WITH UPTURN
  { 0x00493, 0x00492 }, // CYRILLIC CAPITAL LETTER GHE WITH STROKE
  { 0x00495, 0x00494 }, // CYRILLIC CAPITAL LETTER GHE WITH MIDDLE HOOK
  { 0x00497, 0x00496 }, // CYRILLIC CAPITAL LETTER ZHE WITH DESCENDER
  { 0x00499, 0x00498 }, // CYRILLIC CAPITAL LETTER ZE WITH DESCENDER
  { 0x0049B, 0x0049A }, // CYRILLIC CAPITAL LETTER KA WITH DESCENDER
  { 0x0049D, 0x0049C }, // CYRILLIC CAPITAL LETTER KA WITH VERTICAL STROKE
  { 0x0049F, 0x0049E }, // CYRILLIC CAPITAL LETTER KA WITH STROKE
  { 0x004A1, 0x004A0 }, // CYRILLIC CAPITAL LETTER BASHKIR KA
  { 0x004A3, 0x004A2 }, // CYRILLIC CAPITAL LETTER EN WITH DESCENDER
  { 0x004A5, 0x004A4 }, // CYRILLIC CAPITAL LIGATURE EN GHE
  { 0x004A7, 0x004A6 }, // CYRILLIC CAPITAL LETTER PE WITH MIDDLE HOOK
  { 0x004A9, 0x004A8 }, // CYRILLIC CAPITAL LETTER ABKHASIAN HA
  { 0x004AB, 0x004AA }, // CYRILLIC CAPITAL LETTER ES WITH DESCENDER
  { 0x004AD, 0x004AC }, // CYRILLIC CAPITAL LETTER TE WITH DESCENDER
  { 0x004AF, 0x004AE }, // CYRILLIC CAPITAL LETTER STRAIGHT U
  { 0x004B1, 0x004B0 }, // CYRILLIC CAPITAL LETTER STRAIGHT U WITH STROKE
  { 0x004B3, 0x004B2 }, // CYRILLIC CAPITAL LETTER HA WITH DESCENDER
  { 0x004B5, 0x004B4 }, // CYRILLIC CAPITAL LIGATURE TE TSE
  { 0x004B7, 0x004B6 }, // CYRILLIC CAPITAL LETTER CHE WITH DESCENDER
  { 0x004B9, 0x004B8 }, // CYRILLIC CAPITAL LETTER CHE WITH VERTICAL STROKE
  { 0x004BB, 0x004BA }, // CYRILLIC CAPITAL LETTER SHHA
  { 0x004BD, 0x004BC }, // CYRILLIC CAPITAL LETTER ABKHASIAN CHE
  { 0x004BF, 0x004BE }, // CYRILLIC CAPITAL LETTER ABKHASIAN CHE WITH DESCENDER
  { 0x004C2, 0x004C1 }, // CYRILLIC CAPITAL LETTER ZHE WITH BREVE
  { 0x004C4, 0x004C3 }, // CYRILLIC CAPITAL LETTER KA WITH HOOK
  { 0x004C6, 0x004C5 }, // CYRILLIC CAPITAL LETTER EL WITH TAIL
  { 0x004C8, 0x004C7 }, // CYRILLIC CAPITAL LETTER EN WITH HOOK
  { 0x004CA, 0x004C9 }, // CYRILLIC CAPITAL LETTER EN WITH TAIL
  { 0x004CC, 0x004CB }, // CYRILLIC CAPITAL LETTER KHAKASSIAN CHE
  { 0x004CE, 0x004CD }, // CYRILLIC CAPITAL LETTER EM WITH TAIL
  { 0x004CF, 0x004C0 }, // CYRILLIC LETTER PALOCHKA
  { 0x004D1, 0x004D0 }, // CYRILLIC CAPITAL LETTER A WITH BREVE
  { 0x004D3, 0x004D2 }, // CYRILLIC CAPITAL LETTER A WITH DIAERESIS
  { 0x004D5, 0x004D4 }, // CYRILLIC CAPITAL LIGATURE A IE
  { 0x004D7, 0x004D6 }, // CYRILLIC CAPITAL LETTER IE WITH BREVE
  { 0x004D9, 0x004D8 }, // CYRILLIC CAPITAL LETTER SCHWA
  { 0x004DB, 0x004DA }, // CYRILLIC CAPITAL LETTER SCHWA WITH DIAERESIS
  { 0x004DD, 0x004DC }, // CYRILLIC CAPITAL LETTER ZHE WITH DIAERESIS
  { 0x004DF, 0x004DE }, // CYRILLIC CAPITAL LETTER ZE WITH DIAERESIS
  { 0x004E1, 0x004E0 }, // CYRILLIC CAPITAL LETTER ABKHASIAN DZE
  { 0x004E3, 0x004E2 }, // CYRILLIC CAPITAL LETTER I WITH MACRON
  { 0x004E5, 0x004E4 }, // CYRILLIC CAPITAL LETTER I WITH DIAERESIS
  { 0x004E7, 0x004E6 }, // CYRILLIC CAPITAL LETTER O WITH DIAERESIS
  { 0x004E9, 0x004E8 }, // CYRILLIC CAPITAL LETTER BARRED O
  { 0x004EB, 0x004EA }, // CYRILLIC CAPITAL LETTER BARRED O WITH DIAERESIS
  { 0x004ED, 0x004EC }, // CYRILLIC CAPITAL LETTER E WITH DIAERESIS
  { 0x004EF, 0x004EE }, // CYRILLIC CAPITAL LETTER U WITH MACRON
  { 0x004F1, 0x004F0 }, // CYRILLIC CAPITAL LETTER U WITH DIAERESIS
  { 0x004F3, 0x004F2 }, // CYRILLIC CAPITAL LETTER U WITH DOUBLE ACUTE
  { 0x004F5, 0x004F4 }, // CYRILLIC CAPITAL LETTER CHE WITH DIAERESIS
  { 0x004F7, 0x004F6 }, // CYRILLIC CAPITAL LETTER GHE WITH DESCENDER
  { 0x004F9, 0x004F8 }, // CYRILLIC CAPITAL LETTER YERU WITH DIAERESIS
  { 0x004FB, 0x004FA }, // CYRILLIC CAPITAL LETTER GHE WITH STROKE AND HOOK
  { 0x004FD, 0x004FC }, // CYRILLIC CAPITAL LETTER HA WITH HOOK
  { 0x004FF, 0x004FE }, // CYRILLIC CAPITAL LETTER HA WITH STROKE
  { 0x00501, 0x00500 }, // CYRILLIC CAPITAL LETTER KOMI DE
  { 0x00503, 0x00502 }, // CYRILLIC CAPITAL LETTER KOMI DJE
  { 0x00505, 0x00504 }, // CYRILLIC CAPITAL LETTER KOMI ZJE
  { 0x00507, 0x00506 }, // CYRILLIC CAPITAL LETTER KOMI DZJE
  { 0x00509, 0x00508 }, // CYRILLIC CAPITAL LETTER KOMI LJE
  { 0x0050B, 0x0050A }, // CYRILLIC CAPITAL LETTER KOMI NJE
  { 0x0050D, 0x0050C }, // CYRILLIC CAPITAL LETTER KOMI SJE
  { 0x0050F, 0x0050E }, // CYRILLIC CAPITAL LETTER KOMI TJE
  { 0x00511, 0x00510 }, // CYRILLIC CAPITAL LETTER REVERSED ZE
  { 0x00513, 0x00512 }, // CYRILLIC CAPITAL LETTER EL WITH HOOK
  { 0x00515, 0x00514 }, // CYRILLIC CAPITAL LETTER LHA
  { 0x00517, 0x00516 }, // CYRILLIC CAPITAL LETTER RHA
  { 0x00519, 0x00518 }, // CYRILLIC CAPITAL LETTER YAE
  { 0x0051B, 0x0051A }, // CYRILLIC CAPITAL LETTER QA
  { 0x0051D, 0x0051C }, // CYRILLIC CAPITAL LETTER WE
  { 0x0051F, 0x0051E }, // CYRILLIC CAPITAL LETTER ALEUT KA
  { 0x00521, 0x00520 }, // CYRILLIC CAPITAL LETTER EL WITH MIDDLE HOOK
  { 0x00523, 0x00522 }, // CYRILLIC CAPITAL LETTER EN WITH MIDDLE HOOK
  { 0x00561, 0x00531 }, // ARMENIAN CAPITAL LETTER AYB
  { 0x00562, 0x00532 }, // ARMENIAN CAPITAL LETTER BEN
  { 0x00563, 0x00533 }, // ARMENIAN CAPITAL LETTER GIM
  { 0x00564, 0x00534 }, // ARMENIAN CAPITAL LETTER DA
  { 0x00565, 0x00535 }, // ARMENIAN CAPITAL LETTER ECH
  { 0x00566, 0x00536 }, // ARMENIAN CAPITAL LETTER ZA
  { 0x00567, 0x00537 }, // ARMENIAN CAPITAL LETTER EH
  { 0x00568, 0x00538 }, // ARMENIAN CAPITAL LETTER ET
  { 0x00569, 0x00539 }, // ARMENIAN CAPITAL LETTER TO
  { 0x0056A, 0x0053A }, // ARMENIAN CAPITAL LETTER ZHE
  { 0x0056B, 0x0053B }, // ARMENIAN CAPITAL LETTER INI
  { 0x0056C, 0x0053C }, // ARMENIAN CAPITAL LETTER LIWN
  { 0x0056D, 0x0053D }, // ARMENIAN CAPITAL LETTER XEH
  { 0x0056E, 0x0053E }, // ARMENIAN CAPITAL LETTER CA
  { 0x0056F, 0x0053F }, // ARMENIAN CAPITAL LETTER KEN
  { 0x00570, 0x00540 }, // ARMENIAN CAPITAL LETTER HO
  { 0x00571, 0x00541 }, // ARMENIAN CAPITAL LETTER JA
  { 0x00572, 0x00542 }, // ARMENIAN CAPITAL LETTER GHAD
  { 0x00573, 0x00543 }, // ARMENIAN CAPITAL LETTER CHEH
  { 0x00574, 0x00544 }, // ARMENIAN CAPITAL LETTER MEN
  { 0x00575, 0x00545 }, // ARMENIAN CAPITAL LETTER YI
  { 0x00576, 0x00546 }, // ARMENIAN CAPITAL LETTER NOW
  { 0x00577, 0x00547 }, // ARMENIAN CAPITAL LETTER SHA
  { 0x00578, 0x00548 }, // ARMENIAN CAPITAL LETTER VO
  { 0x00579, 0x00549 }, // ARMENIAN CAPITAL LETTER CHA
  { 0x0057A, 0x0054A }, // ARMENIAN CAPITAL LETTER PEH
  { 0x0057B, 0x0054B }, // ARMENIAN CAPITAL LETTER JHEH
  { 0x0057C, 0x0054C }, // ARMENIAN CAPITAL LETTER RA
  { 0x0057D, 0x0054D }, // ARMENIAN CAPITAL LETTER SEH
  { 0x0057E, 0x0054E }, // ARMENIAN CAPITAL LETTER VEW
  { 0x0057F, 0x0054F }, // ARMENIAN CAPITAL LETTER TIWN
  { 0x00580, 0x00550 }, // ARMENIAN CAPITAL LETTER REH
  { 0x00581, 0x00551 }, // ARMENIAN CAPITAL LETTER CO
  { 0x00582, 0x00552 }, // ARMENIAN CAPITAL LETTER YIWN
  { 0x00583, 0x00553 }, // ARMENIAN CAPITAL LETTER PIWR
  { 0x00584, 0x00554 }, // ARMENIAN CAPITAL LETTER KEH
  { 0x00585, 0x00555 }, // ARMENIAN CAPITAL LETTER OH
  { 0x00586, 0x00556 }, // ARMENIAN CAPITAL LETTER FEH
  { 0x01D79, 0x0A77D }, // LATIN CAPITAL LETTER INSULAR G
  { 0x01D7D, 0x02C63 }, // LATIN CAPITAL LETTER P WITH STROKE
  { 0x01E01, 0x01E00 }, // LATIN CAPITAL LETTER A WITH RING BELOW
  { 0x01E03, 0x01E02 }, // LATIN CAPITAL LETTER B WITH DOT ABOVE
  { 0x01E05, 0x01E04 }, // LATIN CAPITAL LETTER B WITH DOT BELOW
  { 0x01E07, 0x01E06 }, // LATIN CAPITAL LETTER B WITH LINE BELOW
  { 0x01E09, 0x01E08 }, // LATIN CAPITAL LETTER C WITH CEDILLA AND ACUTE
  { 0x01E0B, 0x01E0A }, // LATIN CAPITAL LETTER D WITH DOT ABOVE
  { 0x01E0D, 0x01E0C }, // LATIN CAPITAL LETTER D WITH DOT BELOW
  { 0x01E0F, 0x01E0E }, // LATIN CAPITAL LETTER D WITH LINE BELOW
  { 0x01E11, 0x01E10 }, // LATIN CAPITAL LETTER D WITH CEDILLA
  { 0x01E13, 0x01E12 }, // LATIN CAPITAL LETTER D WITH CIRCUMFLEX BELOW
  { 0x01E15, 0x01E14 }, // LATIN CAPITAL LETTER E WITH MACRON AND GRAVE
  { 0x01E17, 0x01E16 }, // LATIN CAPITAL LETTER E WITH MACRON AND ACUTE
  { 0x01E19, 0x01E18 }, // LATIN CAPITAL LETTER E WITH CIRCUMFLEX BELOW
  { 0x01E1B, 0x01E1A }, // LATIN CAPITAL LETTER E WITH TILDE BELOW
  { 0x01E1D, 0x01E1C }, // LATIN CAPITAL LETTER E WITH CEDILLA AND BREVE
  { 0x01E1F, 0x01E1E }, // LATIN CAPITAL LETTER F WITH DOT ABOVE
  { 0x01E21, 0x01E20 }, // LATIN CAPITAL LETTER G WITH MACRON
  { 0x01E23, 0x01E22 }, // LATIN CAPITAL LETTER H WITH DOT ABOVE
  { 0x01E25, 0x01E24 }, // LATIN CAPITAL LETTER H WITH DOT BELOW
  { 0x01E27, 0x01E26 }, // LATIN CAPITAL LETTER H WITH DIAERESIS
  { 0x01E29, 0x01E28 }, // LATIN CAPITAL LETTER H WITH CEDILLA
  { 0x01E2B, 0x01E2A }, // LATIN CAPITAL LETTER H WITH BREVE BELOW
  { 0x01E2D, 0x01E2C }, // LATIN CAPITAL LETTER I WITH TILDE BELOW
  { 0x01E2F, 0x01E2E }, // LATIN CAPITAL LETTER I WITH DIAERESIS AND ACUTE
  { 0x01E31, 0x01E30 }, // LATIN CAPITAL LETTER K WITH ACUTE
  { 0x01E33, 0x01E32 }, // LATIN CAPITAL LETTER K WITH DOT BELOW
  { 0x01E35, 0x01E34 }, // LATIN CAPITAL LETTER K WITH LINE BELOW
  { 0x01E37, 0x01E36 }, // LATIN CAPITAL LETTER L WITH DOT BELOW
  { 0x01E39, 0x01E38 }, // LATIN CAPITAL LETTER L WITH DOT BELOW AND MACRON
  { 0x01E3B, 0x01E3A }, // LATIN CAPITAL LETTER L WITH LINE BELOW
  { 0x01E3D, 0x01E3C }, // LATIN CAPITAL LETTER L WITH CIRCUMFLEX BELOW
  { 0x01E3F, 0x01E3E }, // LATIN CAPITAL LETTER M WITH ACUTE
  { 0x01E41, 0x01E40 }, // LATIN CAPITAL LETTER M WITH DOT ABOVE
  { 0x01E43, 0x01E42 }, // LATIN CAPITAL LETTER M WITH DOT BELOW
  { 0x01E45, 0x01E44 }, // LATIN CAPITAL LETTER N WITH DOT ABOVE
  { 0x01E47, 0x01E46 }, // LATIN CAPITAL LETTER N WITH DOT BELOW
  { 0x01E49, 0x01E48 }, // LATIN CAPITAL LETTER N WITH LINE BELOW
  { 0x01E4B, 0x01E4A }, // LATIN CAPITAL LETTER N WITH CIRCUMFLEX BELOW
  { 0x01E4D, 0x01E4C }, // LATIN CAPITAL LETTER O WITH TILDE AND ACUTE
  { 0x01E4F, 0x01E4E }, // LATIN CAPITAL LETTER O WITH TILDE AND DIAERESIS
  { 0x01E51, 0x01E50 }, // LATIN CAPITAL LETTER O WITH MACRON AND GRAVE
  { 0x01E53, 0x01E52 }, // LATIN CAPITAL LETTER O WITH MACRON AND ACUTE
  { 0x01E55, 0x01E54 }, // LATIN CAPITAL LETTER P WITH ACUTE
  { 0x01E57, 0x01E56 }, // LATIN CAPITAL LETTER P WITH DOT ABOVE
  { 0x01E59, 0x01E58 }, // LATIN CAPITAL LETTER R WITH DOT ABOVE
  { 0x01E5B, 0x01E5A }, // LATIN CAPITAL LETTER R WITH DOT BELOW
  { 0x01E5D, 0x01E5C }, // LATIN CAPITAL LETTER R WITH DOT BELOW AND MACRON
  { 0x01E5F, 0x01E5E }, // LATIN CAPITAL LETTER R WITH LINE BELOW
  { 0x01E61, 0x01E60 }, // LATIN CAPITAL LETTER S WITH DOT ABOVE
  { 0x01E63, 0x01E62 }, // LATIN CAPITAL LETTER S WITH DOT BELOW
  { 0x01E65, 0x01E64 }, // LATIN CAPITAL LETTER S WITH ACUTE AND DOT ABOVE
  { 0x01E67, 0x01E66 }, // LATIN CAPITAL LETTER S WITH CARON AND DOT ABOVE
  { 0x01E69, 0x01E68 }, // LATIN CAPITAL LETTER S WITH DOT BELOW AND DOT ABOVE
  { 0x01E6B, 0x01E6A }, // LATIN CAPITAL LETTER T WITH DOT ABOVE
  { 0x01E6D, 0x01E6C }, // LATIN CAPITAL LETTER T WITH DOT BELOW
  { 0x01E6F, 0x01E6E }, // LATIN CAPITAL LETTER T WITH LINE BELOW
  { 0x01E71, 0x01E70 }, // LATIN CAPITAL LETTER T WITH CIRCUMFLEX BELOW
  { 0x01E73, 0x01E72 }, // LATIN CAPITAL LETTER U WITH DIAERESIS BELOW
  { 0x01E75, 0x01E74 }, // LATIN CAPITAL LETTER U WITH TILDE BELOW
  { 0x01E77, 0x01E76 }, // LATIN CAPITAL LETTER U WITH CIRCUMFLEX BELOW
  { 0x01E79, 0x01E78 }, // LATIN CAPITAL LETTER U WITH TILDE AND ACUTE
  { 0x01E7B, 0x01E7A }, // LATIN CAPITAL LETTER U WITH MACRON AND DIAERESIS
  { 0x01E7D, 0x01E7C }, // LATIN CAPITAL LETTER V WITH TILDE
  { 0x01E7F, 0x01E7E }, // LATIN CAPITAL LETTER V WITH DOT BELOW
  { 0x01E81, 0x01E80 }, // LATIN CAPITAL LETTER W WITH GRAVE
  { 0x01E83, 0x01E82 }, // LATIN CAPITAL LETTER W WITH ACUTE
  { 0x01E85, 0x01E84 }, // LATIN CAPITAL LETTER W WITH DIAERESIS
  { 0x01E87, 0x01E86 }, // LATIN CAPITAL LETTER W WITH DOT ABOVE
  { 0x01E89, 0x01E88 }, // LATIN CAPITAL LETTER W WITH DOT BELOW
  { 0x01E8B, 0x01E8A }, // LATIN CAPITAL LETTER X WITH DOT ABOVE
  { 0x01E8D, 0x01E8C }, // LATIN CAPITAL LETTER X WITH DIAERESIS
  { 0x01E8F, 0x01E8E }, // LATIN CAPITAL LETTER Y WITH DOT ABOVE
  { 0x01E91, 0x01E90 }, // LATIN CAPITAL LETTER Z WITH CIRCUMFLEX
  { 0x01E93, 0x01E92 }, // LATIN CAPITAL LETTER Z WITH DOT BELOW
  { 0x01E95, 0x01E94 }, // LATIN CAPITAL LETTER Z WITH LINE BELOW
  { 0x01EA1, 0x01EA0 }, // LATIN CAPITAL LETTER A WITH DOT BELOW
  { 0x01EA3, 0x01EA2 }, // LATIN CAPITAL LETTER A WITH HOOK ABOVE
  { 0x01EA5, 0x01EA4 }, // LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND ACUTE
  { 0x01EA7, 0x01EA6 }, // LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND GRAVE
  { 0x01EA9, 0x01EA8 }, // LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE
  { 0x01EAB, 0x01EAA }, // LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND TILDE
  { 0x01EAD, 0x01EAC }, // LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND DOT BELOW
  { 0x01EAF, 0x01EAE }, // LATIN CAPITAL LETTER A WITH BREVE AND ACUTE
  { 0x01EB1, 0x01EB0 }, // LATIN CAPITAL LETTER A WITH BREVE AND GRAVE
  { 0x01EB3, 0x01EB2 }, // LATIN CAPITAL LETTER A WITH BREVE AND HOOK ABOVE
  { 0x01EB5, 0x01EB4 }, // LATIN CAPITAL LETTER A WITH BREVE AND TILDE
  { 0x01EB7, 0x01EB6 }, // LATIN CAPITAL LETTER A WITH BREVE AND DOT BELOW
  { 0x01EB9, 0x01EB8 }, // LATIN CAPITAL LETTER E WITH DOT BELOW
  { 0x01EBB, 0x01EBA }, // LATIN CAPITAL LETTER E WITH HOOK ABOVE
  { 0x01EBD, 0x01EBC }, // LATIN CAPITAL LETTER E WITH TILDE
  { 0x01EBF, 0x01EBE }, // LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE
  { 0x01EC1, 0x01EC0 }, // LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE
  { 0x01EC3, 0x01EC2 }, // LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
  { 0x01EC5, 0x01EC4 }, // LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND TILDE
  { 0x01EC7, 0x01EC6 }, // LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOW
  { 0x01EC9, 0x01EC8 }, // LATIN CAPITAL LETTER I WITH HOOK ABOVE
  { 0x01ECB, 0x01ECA }, // LATIN CAPITAL LETTER I WITH DOT BELOW
  { 0x01ECD, 0x01ECC }, // LATIN CAPITAL LETTER O WITH DOT BELOW
  { 0x01ECF, 0x01ECE }, // LATIN CAPITAL LETTER O WITH HOOK ABOVE
  { 0x01ED1, 0x01ED0 }, // LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND ACUTE
  { 0x01ED3, 0x01ED2 }, // LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND GRAVE
  { 0x01ED5, 0x01ED4 }, // LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE
  { 0x01ED7, 0x01ED6 }, // LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND TILDE
  { 0x01ED9, 0x01ED8 }, // LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND DOT BELOW
  { 0x01EDB, 0x01EDA }, // LATIN CAPITAL LETTER O WITH HORN AND ACUTE
  { 0x01EDD, 0x01EDC }, // LATIN CAPITAL LETTER O WITH HORN AND GRAVE
  { 0x01EDF, 0x01EDE }, // LATIN CAPITAL LETTER O WITH HORN AND HOOK ABOVE
  { 0x01EE1, 0x01EE0 }, // LATIN CAPITAL LETTER O WITH HORN AND TILDE
  { 0x01EE3, 0x01EE2 }, // LATIN CAPITAL LETTER O WITH HORN AND DOT BELOW
  { 0x01EE5, 0x01EE4 }, // LATIN CAPITAL LETTER U WITH DOT BELOW
  { 0x01EE7, 0x01EE6 }, // LATIN CAPITAL LETTER U WITH HOOK ABOVE
  { 0x01EE9, 0x01EE8 }, // LATIN CAPITAL LETTER U WITH HORN AND ACUTE
  { 0x01EEB, 0x01EEA }, // LATIN CAPITAL LETTER U WITH HORN AND GRAVE
  { 0x01EED, 0x01EEC }, // LATIN CAPITAL LETTER U WITH HORN AND HOOK ABOVE
  { 0x01EEF, 0x01EEE }, // LATIN CAPITAL LETTER U WITH HORN AND TILDE
  { 0x01EF1, 0x01EF0 }, // LATIN CAPITAL LETTER U WITH HORN AND DOT BELOW
  { 0x01EF3, 0x01EF2 }, // LATIN CAPITAL LETTER Y WITH GRAVE
  { 0x01EF5, 0x01EF4 }, // LATIN CAPITAL LETTER Y WITH DOT BELOW
  { 0x01EF7, 0x01EF6 }, // LATIN CAPITAL LETTER Y WITH HOOK ABOVE
  { 0x01EF9, 0x01EF8 }, // LATIN CAPITAL LETTER Y WITH TILDE
  { 0x01EFB, 0x01EFA }, // LATIN CAPITAL LETTER MIDDLE-WELSH LL
  { 0x01EFD, 0x01EFC }, // LATIN CAPITAL LETTER MIDDLE-WELSH V
  { 0x01EFF, 0x01EFE }, // LATIN CAPITAL LETTER Y WITH LOOP
  { 0x01F00, 0x01F08 }, // GREEK CAPITAL LETTER ALPHA WITH PSILI
  { 0x01F01, 0x01F09 }, // GREEK CAPITAL LETTER ALPHA WITH DASIA
  { 0x01F02, 0x01F0A }, // GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA
  { 0x01F03, 0x01F0B }, // GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA
  { 0x01F04, 0x01F0C }, // GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA
  { 0x01F05, 0x01F0D }, // GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA
  { 0x01F06, 0x01F0E }, // GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI
  { 0x01F07, 0x01F0F }, // GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI
  { 0x01F10, 0x01F18 }, // GREEK CAPITAL LETTER EPSILON WITH PSILI
  { 0x01F11, 0x01F19 }, // GREEK CAPITAL LETTER EPSILON WITH DASIA
  { 0x01F12, 0x01F1A }, // GREEK CAPITAL LETTER EPSILON WITH PSILI AND VARIA
  { 0x01F13, 0x01F1B }, // GREEK CAPITAL LETTER EPSILON WITH DASIA AND VARIA
  { 0x01F14, 0x01F1C }, // GREEK CAPITAL LETTER EPSILON WITH PSILI AND OXIA
  { 0x01F15, 0x01F1D }, // GREEK CAPITAL LETTER EPSILON WITH DASIA AND OXIA
  { 0x01F20, 0x01F28 }, // GREEK CAPITAL LETTER ETA WITH PSILI
  { 0x01F21, 0x01F29 }, // GREEK CAPITAL LETTER ETA WITH DASIA
  { 0x01F22, 0x01F2A }, // GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA
  { 0x01F23, 0x01F2B }, // GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA
  { 0x01F24, 0x01F2C }, // GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA
  { 0x01F25, 0x01F2D }, // GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA
  { 0x01F26, 0x01F2E }, // GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI
  { 0x01F27, 0x01F2F }, // GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI
  { 0x01F30, 0x01F38 }, // GREEK CAPITAL LETTER IOTA WITH PSILI
  { 0x01F31, 0x01F39 }, // GREEK CAPITAL LETTER IOTA WITH DASIA
  { 0x01F32, 0x01F3A }, // GREEK CAPITAL LETTER IOTA WITH PSILI AND VARIA
  { 0x01F33, 0x01F3B }, // GREEK CAPITAL LETTER IOTA WITH DASIA AND VARIA
  { 0x01F34, 0x01F3C }, // GREEK CAPITAL LETTER IOTA WITH PSILI AND OXIA
  { 0x01F35, 0x01F3D }, // GREEK CAPITAL LETTER IOTA WITH DASIA AND OXIA
  { 0x01F36, 0x01F3E }, // GREEK CAPITAL LETTER IOTA WITH PSILI AND PERISPOMENI
  { 0x01F37, 0x01F3F }, // GREEK CAPITAL LETTER IOTA WITH DASIA AND PERISPOMENI
  { 0x01F40, 0x01F48 }, // GREEK CAPITAL LETTER OMICRON WITH PSILI
  { 0x01F41, 0x01F49 }, // GREEK CAPITAL LETTER OMICRON WITH DASIA
  { 0x01F42, 0x01F4A }, // GREEK CAPITAL LETTER OMICRON WITH PSILI AND VARIA
  { 0x01F43, 0x01F4B }, // GREEK CAPITAL LETTER OMICRON WITH DASIA AND VARIA
  { 0x01F44, 0x01F4C }, // GREEK CAPITAL LETTER OMICRON WITH PSILI AND OXIA
  { 0x01F45, 0x01F4D }, // GREEK CAPITAL LETTER OMICRON WITH DASIA AND OXIA
  { 0x01F51, 0x01F59 }, // GREEK CAPITAL LETTER UPSILON WITH DASIA
  { 0x01F53, 0x01F5B }, // GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA
  { 0x01F55, 0x01F5D }, // GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA
  { 0x01F57, 0x01F5F }, // GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI
  { 0x01F60, 0x01F68 }, // GREEK CAPITAL LETTER OMEGA WITH PSILI
  { 0x01F61, 0x01F69 }, // GREEK CAPITAL LETTER OMEGA WITH DASIA
  { 0x01F62, 0x01F6A }, // GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA
  { 0x01F63, 0x01F6B }, // GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA
  { 0x01F64, 0x01F6C }, // GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA
  { 0x01F65, 0x01F6D }, // GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA
  { 0x01F66, 0x01F6E }, // GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI
  { 0x01F67, 0x01F6F }, // GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI
  { 0x01F70, 0x01FBA }, // GREEK CAPITAL LETTER ALPHA WITH VARIA
  { 0x01F71, 0x01FBB }, // GREEK CAPITAL LETTER ALPHA WITH OXIA
  { 0x01F72, 0x01FC8 }, // GREEK CAPITAL LETTER EPSILON WITH VARIA
  { 0x01F73, 0x01FC9 }, // GREEK CAPITAL LETTER EPSILON WITH OXIA
  { 0x01F74, 0x01FCA }, // GREEK CAPITAL LETTER ETA WITH VARIA
  { 0x01F75, 0x01FCB }, // GREEK CAPITAL LETTER ETA WITH OXIA
  { 0x01F76, 0x01FDA }, // GREEK CAPITAL LETTER IOTA WITH VARIA
  { 0x01F77, 0x01FDB }, // GREEK CAPITAL LETTER IOTA WITH OXIA
  { 0x01F78, 0x01FF8 }, // GREEK CAPITAL LETTER OMICRON WITH VARIA
  { 0x01F79, 0x01FF9 }, // GREEK CAPITAL LETTER OMICRON WITH OXIA
  { 0x01F7A, 0x01FEA }, // GREEK CAPITAL LETTER UPSILON WITH VARIA
  { 0x01F7B, 0x01FEB }, // GREEK CAPITAL LETTER UPSILON WITH OXIA
  { 0x01F7C, 0x01FFA }, // GREEK CAPITAL LETTER OMEGA WITH VARIA
  { 0x01F7D, 0x01FFB }, // GREEK CAPITAL LETTER OMEGA WITH OXIA
  { 0x01F80, 0x01F88 }, // GREEK CAPITAL LETTER ALPHA WITH PSILI AND PROSGEGRAMMENI
  { 0x01F81, 0x01F89 }, // GREEK CAPITAL LETTER ALPHA WITH DASIA AND PROSGEGRAMMENI
  { 0x01F82, 0x01F8A }, // GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA AND PROSGEGRAMMENI
  { 0x01F83, 0x01F8B }, // GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA AND PROSGEGRAMMENI
  { 0x01F84, 0x01F8C }, // GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA AND PROSGEGRAMMENI
  { 0x01F85, 0x01F8D }, // GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA AND PROSGEGRAMMENI
  { 0x01F86, 0x01F8E }, // GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI
  { 0x01F87, 0x01F8F }, // GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
  { 0x01F90, 0x01F98 }, // GREEK CAPITAL LETTER ETA WITH PSILI AND PROSGEGRAMMENI
  { 0x01F91, 0x01F99 }, // GREEK CAPITAL LETTER ETA WITH DASIA AND PROSGEGRAMMENI
  { 0x01F92, 0x01F9A }, // GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA AND PROSGEGRAMMENI
  { 0x01F93, 0x01F9B }, // GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA AND PROSGEGRAMMENI
  { 0x01F94, 0x01F9C }, // GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA AND PROSGEGRAMMENI
  { 0x01F95, 0x01F9D }, // GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA AND PROSGEGRAMMENI
  { 0x01F96, 0x01F9E }, // GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI
  { 0x01F97, 0x01F9F }, // GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
  { 0x01FA0, 0x01FA8 }, // GREEK CAPITAL LETTER OMEGA WITH PSILI AND PROSGEGRAMMENI
  { 0x01FA1, 0x01FA9 }, // GREEK CAPITAL LETTER OMEGA WITH DASIA AND PROSGEGRAMMENI
  { 0x01FA2, 0x01FAA }, // GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA AND PROSGEGRAMMENI
  { 0x01FA3, 0x01FAB }, // GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA AND PROSGEGRAMMENI
  { 0x01FA4, 0x01FAC }, // GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA AND PROSGEGRAMMENI
  { 0x01FA5, 0x01FAD }, // GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA AND PROSGEGRAMMENI
  { 0x01FA6, 0x01FAE }, // GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI
  { 0x01FA7, 0x01FAF }, // GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
  { 0x01FB0, 0x01FB8 }, // GREEK CAPITAL LETTER ALPHA WITH VRACHY
  { 0x01FB1, 0x01FB9 }, // GREEK CAPITAL LETTER ALPHA WITH MACRON
  { 0x01FB3, 0x01FBC }, // GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI
  { 0x01FC3, 0x01FCC }, // GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI
  { 0x01FD0, 0x01FD8 }, // GREEK CAPITAL LETTER IOTA WITH VRACHY
  { 0x01FD1, 0x01FD9 }, // GREEK CAPITAL LETTER IOTA WITH MACRON
  { 0x01FE0, 0x01FE8 }, // GREEK CAPITAL LETTER UPSILON WITH VRACHY
  { 0x01FE1, 0x01FE9 }, // GREEK CAPITAL LETTER UPSILON WITH MACRON
  { 0x01FE5, 0x01FEC }, // GREEK CAPITAL LETTER RHO WITH DASIA
  { 0x01FF3, 0x01FFC }, // GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI
  { 0x0214E, 0x02132 }, // TURNED CAPITAL F
  { 0x02170, 0x02160 }, // ROMAN NUMERAL ONE
  { 0x02171, 0x02161 }, // ROMAN NUMERAL TWO
  { 0x02172, 0x02162 }, // ROMAN NUMERAL THREE
  { 0x02173, 0x02163 }, // ROMAN NUMERAL FOUR
  { 0x02174, 0x02164 }, // ROMAN NUMERAL FIVE
  { 0x02175, 0x02165 }, // ROMAN NUMERAL SIX
  { 0x02176, 0x02166 }, // ROMAN NUMERAL SEVEN
  { 0x02177, 0x02167 }, // ROMAN NUMERAL EIGHT
  { 0x02178, 0x02168 }, // ROMAN NUMERAL NINE
  { 0x02179, 0x02169 }, // ROMAN NUMERAL TEN
  { 0x0217A, 0x0216A }, // ROMAN NUMERAL ELEVEN
  { 0x0217B, 0x0216B }, // ROMAN NUMERAL TWELVE
  { 0x0217C, 0x0216C }, // ROMAN NUMERAL FIFTY
  { 0x0217D, 0x0216D }, // ROMAN NUMERAL ONE HUNDRED
  { 0x0217E, 0x0216E }, // ROMAN NUMERAL FIVE HUNDRED
  { 0x0217F, 0x0216F }, // ROMAN NUMERAL ONE THOUSAND
  { 0x02184, 0x02183 }, // ROMAN NUMERAL REVERSED ONE HUNDRED
  { 0x024D0, 0x024B6 }, // CIRCLED LATIN CAPITAL LETTER A
  { 0x024D1, 0x024B7 }, // CIRCLED LATIN CAPITAL LETTER B
  { 0x024D2, 0x024B8 }, // CIRCLED LATIN CAPITAL LETTER C
  { 0x024D3, 0x024B9 }, // CIRCLED LATIN CAPITAL LETTER D
  { 0x024D4, 0x024BA }, // CIRCLED LATIN CAPITAL LETTER E
  { 0x024D5, 0x024BB }, // CIRCLED LATIN CAPITAL LETTER F
  { 0x024D6, 0x024BC }, // CIRCLED LATIN CAPITAL LETTER G
  { 0x024D7, 0x024BD }, // CIRCLED LATIN CAPITAL LETTER H
  { 0x024D8, 0x024BE }, // CIRCLED LATIN CAPITAL LETTER I
  { 0x024D9, 0x024BF }, // CIRCLED LATIN CAPITAL LETTER J
  { 0x024DA, 0x024C0 }, // CIRCLED LATIN CAPITAL LETTER K
  { 0x024DB, 0x024C1 }, // CIRCLED LATIN CAPITAL LETTER L
  { 0x024DC, 0x024C2 }, // CIRCLED LATIN CAPITAL LETTER M
  { 0x024DD, 0x024C3 }, // CIRCLED LATIN CAPITAL LETTER N
  { 0x024DE, 0x024C4 }, // CIRCLED LATIN CAPITAL LETTER O
  { 0x024DF, 0x024C5 }, // CIRCLED LATIN CAPITAL LETTER P
  { 0x024E0, 0x024C6 }, // CIRCLED LATIN CAPITAL LETTER Q
  { 0x024E1, 0x024C7 }, // CIRCLED LATIN CAPITAL LETTER R
  { 0x024E2, 0x024C8 }, // CIRCLED LATIN CAPITAL LETTER S
  { 0x024E3, 0x024C9 }, // CIRCLED LATIN CAPITAL LETTER T
  { 0x024E4, 0x024CA }, // CIRCLED LATIN CAPITAL LETTER U
  { 0x024E5, 0x024CB }, // CIRCLED LATIN CAPITAL LETTER V
  { 0x024E6, 0x024CC }, // CIRCLED LATIN CAPITAL LETTER W
  { 0x024E7, 0x024CD }, // CIRCLED LATIN CAPITAL LETTER X
  { 0x024E8, 0x024CE }, // CIRCLED LATIN CAPITAL LETTER Y
  { 0x024E9, 0x024CF }, // CIRCLED LATIN CAPITAL LETTER Z
  { 0x02C30, 0x02C00 }, // GLAGOLITIC CAPITAL LETTER AZU
  { 0x02C31, 0x02C01 }, // GLAGOLITIC CAPITAL LETTER BUKY
  { 0x02C32, 0x02C02 }, // GLAGOLITIC CAPITAL LETTER VEDE
  { 0x02C33, 0x02C03 }, // GLAGOLITIC CAPITAL LETTER GLAGOLI
  { 0x02C34, 0x02C04 }, // GLAGOLITIC CAPITAL LETTER DOBRO
  { 0x02C35, 0x02C05 }, // GLAGOLITIC CAPITAL LETTER YESTU
  { 0x02C36, 0x02C06 }, // GLAGOLITIC CAPITAL LETTER ZHIVETE
  { 0x02C37, 0x02C07 }, // GLAGOLITIC CAPITAL LETTER DZELO
  { 0x02C38, 0x02C08 }, // GLAGOLITIC CAPITAL LETTER ZEMLJA
  { 0x02C39, 0x02C09 }, // GLAGOLITIC CAPITAL LETTER IZHE
  { 0x02C3A, 0x02C0A }, // GLAGOLITIC CAPITAL LETTER INITIAL IZHE
  { 0x02C3B, 0x02C0B }, // GLAGOLITIC CAPITAL LETTER I
  { 0x02C3C, 0x02C0C }, // GLAGOLITIC CAPITAL LETTER DJERVI
  { 0x02C3D, 0x02C0D }, // GLAGOLITIC CAPITAL LETTER KAKO
  { 0x02C3E, 0x02C0E }, // GLAGOLITIC CAPITAL LETTER LJUDIJE
  { 0x02C3F, 0x02C0F }, // GLAGOLITIC CAPITAL LETTER MYSLITE
  { 0x02C40, 0x02C10 }, // GLAGOLITIC CAPITAL LETTER NASHI
  { 0x02C41, 0x02C11 }, // GLAGOLITIC CAPITAL LETTER ONU
  { 0x02C42, 0x02C12 }, // GLAGOLITIC CAPITAL LETTER POKOJI
  { 0x02C43, 0x02C13 }, // GLAGOLITIC CAPITAL LETTER RITSI
  { 0x02C44, 0x02C14 }, // GLAGOLITIC CAPITAL LETTER SLOVO
  { 0x02C45, 0x02C15 }, // GLAGOLITIC CAPITAL LETTER TVRIDO
  { 0x02C46, 0x02C16 }, // GLAGOLITIC CAPITAL LETTER UKU
  { 0x02C47, 0x02C17 }, // GLAGOLITIC CAPITAL LETTER FRITU
  { 0x02C48, 0x02C18 }, // GLAGOLITIC CAPITAL LETTER HERU
  { 0x02C49, 0x02C19 }, // GLAGOLITIC CAPITAL LETTER OTU
  { 0x02C4A, 0x02C1A }, // GLAGOLITIC CAPITAL LETTER PE
  { 0x02C4B, 0x02C1B }, // GLAGOLITIC CAPITAL LETTER SHTA
  { 0x02C4C, 0x02C1C }, // GLAGOLITIC CAPITAL LETTER TSI
  { 0x02C4D, 0x02C1D }, // GLAGOLITIC CAPITAL LETTER CHRIVI
  { 0x02C4E, 0x02C1E }, // GLAGOLITIC CAPITAL LETTER SHA
  { 0x02C4F, 0x02C1F }, // GLAGOLITIC CAPITAL LETTER YERU
  { 0x02C50, 0x02C20 }, // GLAGOLITIC CAPITAL LETTER YERI
  { 0x02C51, 0x02C21 }, // GLAGOLITIC CAPITAL LETTER YATI
  { 0x02C52, 0x02C22 }, // GLAGOLITIC CAPITAL LETTER SPIDERY HA
  { 0x02C53, 0x02C23 }, // GLAGOLITIC CAPITAL LETTER YU
  { 0x02C54, 0x02C24 }, // GLAGOLITIC CAPITAL LETTER SMALL YUS
  { 0x02C55, 0x02C25 }, // GLAGOLITIC CAPITAL LETTER SMALL YUS WITH TAIL
  { 0x02C56, 0x02C26 }, // GLAGOLITIC CAPITAL LETTER YO
  { 0x02C57, 0x02C27 }, // GLAGOLITIC CAPITAL LETTER IOTATED SMALL YUS
  { 0x02C58, 0x02C28 }, // GLAGOLITIC CAPITAL LETTER BIG YUS
  { 0x02C59, 0x02C29 }, // GLAGOLITIC CAPITAL LETTER IOTATED BIG YUS
  { 0x02C5A, 0x02C2A }, // GLAGOLITIC CAPITAL LETTER FITA
  { 0x02C5B, 0x02C2B }, // GLAGOLITIC CAPITAL LETTER IZHITSA
  { 0x02C5C, 0x02C2C }, // GLAGOLITIC CAPITAL LETTER SHTAPIC
  { 0x02C5D, 0x02C2D }, // GLAGOLITIC CAPITAL LETTER TROKUTASTI A
  { 0x02C5E, 0x02C2E }, // GLAGOLITIC CAPITAL LETTER LATINATE MYSLITE
  { 0x02C61, 0x02C60 }, // LATIN CAPITAL LETTER L WITH DOUBLE BAR
  { 0x02C65, 0x0023A }, // LATIN CAPITAL LETTER A WITH STROKE
  { 0x02C66, 0x0023E }, // LATIN CAPITAL LETTER T WITH DIAGONAL STROKE
  { 0x02C68, 0x02C67 }, // LATIN CAPITAL LETTER H WITH DESCENDER
  { 0x02C6A, 0x02C69 }, // LATIN CAPITAL LETTER K WITH DESCENDER
  { 0x02C6C, 0x02C6B }, // LATIN CAPITAL LETTER Z WITH DESCENDER
  { 0x02C73, 0x02C72 }, // LATIN CAPITAL LETTER W WITH HOOK
  { 0x02C76, 0x02C75 }, // LATIN CAPITAL LETTER HALF H
  { 0x02C81, 0x02C80 }, // COPTIC CAPITAL LETTER ALFA
  { 0x02C83, 0x02C82 }, // COPTIC CAPITAL LETTER VIDA
  { 0x02C85, 0x02C84 }, // COPTIC CAPITAL LETTER GAMMA
  { 0x02C87, 0x02C86 }, // COPTIC CAPITAL LETTER DALDA
  { 0x02C89, 0x02C88 }, // COPTIC CAPITAL LETTER EIE
  { 0x02C8B, 0x02C8A }, // COPTIC CAPITAL LETTER SOU
  { 0x02C8D, 0x02C8C }, // COPTIC CAPITAL LETTER ZATA
  { 0x02C8F, 0x02C8E }, // COPTIC CAPITAL LETTER HATE
  { 0x02C91, 0x02C90 }, // COPTIC CAPITAL LETTER THETHE
  { 0x02C93, 0x02C92 }, // COPTIC CAPITAL LETTER IAUDA
  { 0x02C95, 0x02C94 }, // COPTIC CAPITAL LETTER KAPA
  { 0x02C97, 0x02C96 }, // COPTIC CAPITAL LETTER LAULA
  { 0x02C99, 0x02C98 }, // COPTIC CAPITAL LETTER MI
  { 0x02C9B, 0x02C9A }, // COPTIC CAPITAL LETTER NI
  { 0x02C9D, 0x02C9C }, // COPTIC CAPITAL LETTER KSI
  { 0x02C9F, 0x02C9E }, // COPTIC CAPITAL LETTER O
  { 0x02CA1, 0x02CA0 }, // COPTIC CAPITAL LETTER PI
  { 0x02CA3, 0x02CA2 }, // COPTIC CAPITAL LETTER RO
  { 0x02CA5, 0x02CA4 }, // COPTIC CAPITAL LETTER SIMA
  { 0x02CA7, 0x02CA6 }, // COPTIC CAPITAL LETTER TAU
  { 0x02CA9, 0x02CA8 }, // COPTIC CAPITAL LETTER UA
  { 0x02CAB, 0x02CAA }, // COPTIC CAPITAL LETTER FI
  { 0x02CAD, 0x02CAC }, // COPTIC CAPITAL LETTER KHI
  { 0x02CAF, 0x02CAE }, // COPTIC CAPITAL LETTER PSI
  { 0x02CB1, 0x02CB0 }, // COPTIC CAPITAL LETTER OOU
  { 0x02CB3, 0x02CB2 }, // COPTIC CAPITAL LETTER DIALECT-P ALEF
  { 0x02CB5, 0x02CB4 }, // COPTIC CAPITAL LETTER OLD COPTIC AIN
  { 0x02CB7, 0x02CB6 }, // COPTIC CAPITAL LETTER CRYPTOGRAMMIC EIE
  { 0x02CB9, 0x02CB8 }, // COPTIC CAPITAL LETTER DIALECT-P KAPA
  { 0x02CBB, 0x02CBA }, // COPTIC CAPITAL LETTER DIALECT-P NI
  { 0x02CBD, 0x02CBC }, // COPTIC CAPITAL LETTER CRYPTOGRAMMIC NI
  { 0x02CBF, 0x02CBE }, // COPTIC CAPITAL LETTER OLD COPTIC OOU
  { 0x02CC1, 0x02CC0 }, // COPTIC CAPITAL LETTER SAMPI
  { 0x02CC3, 0x02CC2 }, // COPTIC CAPITAL LETTER CROSSED SHEI
  { 0x02CC5, 0x02CC4 }, // COPTIC CAPITAL LETTER OLD COPTIC SHEI
  { 0x02CC7, 0x02CC6 }, // COPTIC CAPITAL LETTER OLD COPTIC ESH
  { 0x02CC9, 0x02CC8 }, // COPTIC CAPITAL LETTER AKHMIMIC KHEI
  { 0x02CCB, 0x02CCA }, // COPTIC CAPITAL LETTER DIALECT-P HORI
  { 0x02CCD, 0x02CCC }, // COPTIC CAPITAL LETTER OLD COPTIC HORI
  { 0x02CCF, 0x02CCE }, // COPTIC CAPITAL LETTER OLD COPTIC HA
  { 0x02CD1, 0x02CD0 }, // COPTIC CAPITAL LETTER L-SHAPED HA
  { 0x02CD3, 0x02CD2 }, // COPTIC CAPITAL LETTER OLD COPTIC HEI
  { 0x02CD5, 0x02CD4 }, // COPTIC CAPITAL LETTER OLD COPTIC HAT
  { 0x02CD7, 0x02CD6 }, // COPTIC CAPITAL LETTER OLD COPTIC GANGIA
  { 0x02CD9, 0x02CD8 }, // COPTIC CAPITAL LETTER OLD COPTIC DJA
  { 0x02CDB, 0x02CDA }, // COPTIC CAPITAL LETTER OLD COPTIC SHIMA
  { 0x02CDD, 0x02CDC }, // COPTIC CAPITAL LETTER OLD NUBIAN SHIMA
  { 0x02CDF, 0x02CDE }, // COPTIC CAPITAL LETTER OLD NUBIAN NGI
  { 0x02CE1, 0x02CE0 }, // COPTIC CAPITAL LETTER OLD NUBIAN NYI
  { 0x02CE3, 0x02CE2 }, // COPTIC CAPITAL LETTER OLD NUBIAN WAU
  { 0x02D00, 0x010A0 }, // GEORGIAN CAPITAL LETTER AN
  { 0x02D01, 0x010A1 }, // GEORGIAN CAPITAL LETTER BAN
  { 0x02D02, 0x010A2 }, // GEORGIAN CAPITAL LETTER GAN
  { 0x02D03, 0x010A3 }, // GEORGIAN CAPITAL LETTER DON
  { 0x02D04, 0x010A4 }, // GEORGIAN CAPITAL LETTER EN
  { 0x02D05, 0x010A5 }, // GEORGIAN CAPITAL LETTER VIN
  { 0x02D06, 0x010A6 }, // GEORGIAN CAPITAL LETTER ZEN
  { 0x02D07, 0x010A7 }, // GEORGIAN CAPITAL LETTER TAN
  { 0x02D08, 0x010A8 }, // GEORGIAN CAPITAL LETTER IN
  { 0x02D09, 0x010A9 }, // GEORGIAN CAPITAL LETTER KAN
  { 0x02D0A, 0x010AA }, // GEORGIAN CAPITAL LETTER LAS
  { 0x02D0B, 0x010AB }, // GEORGIAN CAPITAL LETTER MAN
  { 0x02D0C, 0x010AC }, // GEORGIAN CAPITAL LETTER NAR
  { 0x02D0D, 0x010AD }, // GEORGIAN CAPITAL LETTER ON
  { 0x02D0E, 0x010AE }, // GEORGIAN CAPITAL LETTER PAR
  { 0x02D0F, 0x010AF }, // GEORGIAN CAPITAL LETTER ZHAR
  { 0x02D10, 0x010B0 }, // GEORGIAN CAPITAL LETTER RAE
  { 0x02D11, 0x010B1 }, // GEORGIAN CAPITAL LETTER SAN
  { 0x02D12, 0x010B2 }, // GEORGIAN CAPITAL LETTER TAR
  { 0x02D13, 0x010B3 }, // GEORGIAN CAPITAL LETTER UN
  { 0x02D14, 0x010B4 }, // GEORGIAN CAPITAL LETTER PHAR
  { 0x02D15, 0x010B5 }, // GEORGIAN CAPITAL LETTER KHAR
  { 0x02D16, 0x010B6 }, // GEORGIAN CAPITAL LETTER GHAN
  { 0x02D17, 0x010B7 }, // GEORGIAN CAPITAL LETTER QAR
  { 0x02D18, 0x010B8 }, // GEORGIAN CAPITAL LETTER SHIN
  { 0x02D19, 0x010B9 }, // GEORGIAN CAPITAL LETTER CHIN
  { 0x02D1A, 0x010BA }, // GEORGIAN CAPITAL LETTER CAN
  { 0x02D1B, 0x010BB }, // GEORGIAN CAPITAL LETTER JIL
  { 0x02D1C, 0x010BC }, // GEORGIAN CAPITAL LETTER CIL
  { 0x02D1D, 0x010BD }, // GEORGIAN CAPITAL LETTER CHAR
  { 0x02D1E, 0x010BE }, // GEORGIAN CAPITAL LETTER XAN
  { 0x02D1F, 0x010BF }, // GEORGIAN CAPITAL LETTER JHAN
  { 0x02D20, 0x010C0 }, // GEORGIAN CAPITAL LETTER HAE
  { 0x02D21, 0x010C1 }, // GEORGIAN CAPITAL LETTER HE
  { 0x02D22, 0x010C2 }, // GEORGIAN CAPITAL LETTER HIE
  { 0x02D23, 0x010C3 }, // GEORGIAN CAPITAL LETTER WE
  { 0x02D24, 0x010C4 }, // GEORGIAN CAPITAL LETTER HAR
  { 0x02D25, 0x010C5 }, // GEORGIAN CAPITAL LETTER HOE
  { 0x0A641, 0x0A640 }, // CYRILLIC CAPITAL LETTER ZEMLYA
  { 0x0A643, 0x0A642 }, // CYRILLIC CAPITAL LETTER DZELO
  { 0x0A645, 0x0A644 }, // CYRILLIC CAPITAL LETTER REVERSED DZE
  { 0x0A647, 0x0A646 }, // CYRILLIC CAPITAL LETTER IOTA
  { 0x0A649, 0x0A648 }, // CYRILLIC CAPITAL LETTER DJERV
  { 0x0A64B, 0x0A64A }, // CYRILLIC CAPITAL LETTER MONOGRAPH UK
  { 0x0A64D, 0x0A64C }, // CYRILLIC CAPITAL LETTER BROAD OMEGA
  { 0x0A64F, 0x0A64E }, // CYRILLIC CAPITAL LETTER NEUTRAL YER
  { 0x0A651, 0x0A650 }, // CYRILLIC CAPITAL LETTER YERU WITH BACK YER
  { 0x0A653, 0x0A652 }, // CYRILLIC CAPITAL LETTER IOTIFIED YAT
  { 0x0A655, 0x0A654 }, // CYRILLIC CAPITAL LETTER REVERSED YU
  { 0x0A657, 0x0A656 }, // CYRILLIC CAPITAL LETTER IOTIFIED A
  { 0x0A659, 0x0A658 }, // CYRILLIC CAPITAL LETTER CLOSED LITTLE YUS
  { 0x0A65B, 0x0A65A }, // CYRILLIC CAPITAL LETTER BLENDED YUS
  { 0x0A65D, 0x0A65C }, // CYRILLIC CAPITAL LETTER IOTIFIED CLOSED LITTLE YUS
  { 0x0A65F, 0x0A65E }, // CYRILLIC CAPITAL LETTER YN
  { 0x0A663, 0x0A662 }, // CYRILLIC CAPITAL LETTER SOFT DE
  { 0x0A665, 0x0A664 }, // CYRILLIC CAPITAL LETTER SOFT EL
  { 0x0A667, 0x0A666 }, // CYRILLIC CAPITAL LETTER SOFT EM
  { 0x0A669, 0x0A668 }, // CYRILLIC CAPITAL LETTER MONOCULAR O
  { 0x0A66B, 0x0A66A }, // CYRILLIC CAPITAL LETTER BINOCULAR O
  { 0x0A66D, 0x0A66C }, // CYRILLIC CAPITAL LETTER DOUBLE MONOCULAR O
  { 0x0A681, 0x0A680 }, // CYRILLIC CAPITAL LETTER DWE
  { 0x0A683, 0x0A682 }, // CYRILLIC CAPITAL LETTER DZWE
  { 0x0A685, 0x0A684 }, // CYRILLIC CAPITAL LETTER ZHWE
  { 0x0A687, 0x0A686 }, // CYRILLIC CAPITAL LETTER CCHE
  { 0x0A689, 0x0A688 }, // CYRILLIC CAPITAL LETTER DZZE
  { 0x0A68B, 0x0A68A }, // CYRILLIC CAPITAL LETTER TE WITH MIDDLE HOOK
  { 0x0A68D, 0x0A68C }, // CYRILLIC CAPITAL LETTER TWE
  { 0x0A68F, 0x0A68E }, // CYRILLIC CAPITAL LETTER TSWE
  { 0x0A691, 0x0A690 }, // CYRILLIC CAPITAL LETTER TSSE
  { 0x0A693, 0x0A692 }, // CYRILLIC CAPITAL LETTER TCHE
  { 0x0A695, 0x0A694 }, // CYRILLIC CAPITAL LETTER HWE
  { 0x0A697, 0x0A696 }, // CYRILLIC CAPITAL LETTER SHWE
  { 0x0A723, 0x0A722 }, // LATIN CAPITAL LETTER EGYPTOLOGICAL ALEF
  { 0x0A725, 0x0A724 }, // LATIN CAPITAL LETTER EGYPTOLOGICAL AIN
  { 0x0A727, 0x0A726 }, // LATIN CAPITAL LETTER HENG
  { 0x0A729, 0x0A728 }, // LATIN CAPITAL LETTER TZ
  { 0x0A72B, 0x0A72A }, // LATIN CAPITAL LETTER TRESILLO
  { 0x0A72D, 0x0A72C }, // LATIN CAPITAL LETTER CUATRILLO
  { 0x0A72F, 0x0A72E }, // LATIN CAPITAL LETTER CUATRILLO WITH COMMA
  { 0x0A733, 0x0A732 }, // LATIN CAPITAL LETTER AA
  { 0x0A735, 0x0A734 }, // LATIN CAPITAL LETTER AO
  { 0x0A737, 0x0A736 }, // LATIN CAPITAL LETTER AU
  { 0x0A739, 0x0A738 }, // LATIN CAPITAL LETTER AV
  { 0x0A73B, 0x0A73A }, // LATIN CAPITAL LETTER AV WITH HORIZONTAL BAR
  { 0x0A73D, 0x0A73C }, // LATIN CAPITAL LETTER AY
  { 0x0A73F, 0x0A73E }, // LATIN CAPITAL LETTER REVERSED C WITH DOT
  { 0x0A741, 0x0A740 }, // LATIN CAPITAL LETTER K WITH STROKE
  { 0x0A743, 0x0A742 }, // LATIN CAPITAL LETTER K WITH DIAGONAL STROKE
  { 0x0A745, 0x0A744 }, // LATIN CAPITAL LETTER K WITH STROKE AND DIAGONAL STROKE
  { 0x0A747, 0x0A746 }, // LATIN CAPITAL LETTER BROKEN L
  { 0x0A749, 0x0A748 }, // LATIN CAPITAL LETTER L WITH HIGH STROKE
  { 0x0A74B, 0x0A74A }, // LATIN CAPITAL LETTER O WITH LONG STROKE OVERLAY
  { 0x0A74D, 0x0A74C }, // LATIN CAPITAL LETTER O WITH LOOP
  { 0x0A74F, 0x0A74E }, // LATIN CAPITAL LETTER OO
  { 0x0A751, 0x0A750 }, // LATIN CAPITAL LETTER P WITH STROKE THROUGH DESCENDER
  { 0x0A753, 0x0A752 }, // LATIN CAPITAL LETTER P WITH FLOURISH
  { 0x0A755, 0x0A754 }, // LATIN CAPITAL LETTER P WITH SQUIRREL TAIL
  { 0x0A757, 0x0A756 }, // LATIN CAPITAL LETTER Q WITH STROKE THROUGH DESCENDER
  { 0x0A759, 0x0A758 }, // LATIN CAPITAL LETTER Q WITH DIAGONAL STROKE
  { 0x0A75B, 0x0A75A }, // LATIN CAPITAL LETTER R ROTUNDA
  { 0x0A75D, 0x0A75C }, // LATIN CAPITAL LETTER RUM ROTUNDA
  { 0x0A75F, 0x0A75E }, // LATIN CAPITAL LETTER V WITH DIAGONAL STROKE
  { 0x0A761, 0x0A760 }, // LATIN CAPITAL LETTER VY
  { 0x0A763, 0x0A762 }, // LATIN CAPITAL LETTER VISIGOTHIC Z
  { 0x0A765, 0x0A764 }, // LATIN CAPITAL LETTER THORN WITH STROKE
  { 0x0A767, 0x0A766 }, // LATIN CAPITAL LETTER THORN WITH STROKE THROUGH DESCENDER
  { 0x0A769, 0x0A768 }, // LATIN CAPITAL LETTER VEND
  { 0x0A76B, 0x0A76A }, // LATIN CAPITAL LETTER ET
  { 0x0A76D, 0x0A76C }, // LATIN CAPITAL LETTER IS
  { 0x0A76F, 0x0A76E }, // LATIN CAPITAL LETTER CON
  { 0x0A77A, 0x0A779 }, // LATIN CAPITAL LETTER INSULAR D
  { 0x0A77C, 0x0A77B }, // LATIN CAPITAL LETTER INSULAR F
  { 0x0A77F, 0x0A77E }, // LATIN CAPITAL LETTER TURNED INSULAR G
  { 0x0A781, 0x0A780 }, // LATIN CAPITAL LETTER TURNED L
  { 0x0A783, 0x0A782 }, // LATIN CAPITAL LETTER INSULAR R
  { 0x0A785, 0x0A784 }, // LATIN CAPITAL LETTER INSULAR S
  { 0x0A787, 0x0A786 }, // LATIN CAPITAL LETTER INSULAR T
  { 0x0A78C, 0x0A78B }, // LATIN CAPITAL LETTER SALTILLO
  { 0x0FF41, 0x0FF21 }, // FULLWIDTH LATIN CAPITAL LETTER A
  { 0x0FF42, 0x0FF22 }, // FULLWIDTH LATIN CAPITAL LETTER B
  { 0x0FF43, 0x0FF23 }, // FULLWIDTH LATIN CAPITAL LETTER C
  { 0x0FF44, 0x0FF24 }, // FULLWIDTH LATIN CAPITAL LETTER D
  { 0x0FF45, 0x0FF25 }, // FULLWIDTH LATIN CAPITAL LETTER E
  { 0x0FF46, 0x0FF26 }, // FULLWIDTH LATIN CAPITAL LETTER F
  { 0x0FF47, 0x0FF27 }, // FULLWIDTH LATIN CAPITAL LETTER G
  { 0x0FF48, 0x0FF28 }, // FULLWIDTH LATIN CAPITAL LETTER H
  { 0x0FF49, 0x0FF29 }, // FULLWIDTH LATIN CAPITAL LETTER I
  { 0x0FF4A, 0x0FF2A }, // FULLWIDTH LATIN CAPITAL LETTER J
  { 0x0FF4B, 0x0FF2B }, // FULLWIDTH LATIN CAPITAL LETTER K
  { 0x0FF4C, 0x0FF2C }, // FULLWIDTH LATIN CAPITAL LETTER L
  { 0x0FF4D, 0x0FF2D }, // FULLWIDTH LATIN CAPITAL LETTER M
  { 0x0FF4E, 0x0FF2E }, // FULLWIDTH LATIN CAPITAL LETTER N
  { 0x0FF4F, 0x0FF2F }, // FULLWIDTH LATIN CAPITAL LETTER O
  { 0x0FF50, 0x0FF30 }, // FULLWIDTH LATIN CAPITAL LETTER P
  { 0x0FF51, 0x0FF31 }, // FULLWIDTH LATIN CAPITAL LETTER Q
  { 0x0FF52, 0x0FF32 }, // FULLWIDTH LATIN CAPITAL LETTER R
  { 0x0FF53, 0x0FF33 }, // FULLWIDTH LATIN CAPITAL LETTER S
  { 0x0FF54, 0x0FF34 }, // FULLWIDTH LATIN CAPITAL LETTER T
  { 0x0FF55, 0x0FF35 }, // FULLWIDTH LATIN CAPITAL LETTER U
  { 0x0FF56, 0x0FF36 }, // FULLWIDTH LATIN CAPITAL LETTER V
  { 0x0FF57, 0x0FF37 }, // FULLWIDTH LATIN CAPITAL LETTER W
  { 0x0FF58, 0x0FF38 }, // FULLWIDTH LATIN CAPITAL LETTER X
  { 0x0FF59, 0x0FF39 }, // FULLWIDTH LATIN CAPITAL LETTER Y
  { 0x0FF5A, 0x0FF3A }, // FULLWIDTH LATIN CAPITAL LETTER Z
  { 0x10428, 0x10400 }, // DESERET CAPITAL LETTER LONG I
  { 0x10429, 0x10401 }, // DESERET CAPITAL LETTER LONG E
  { 0x1042A, 0x10402 }, // DESERET CAPITAL LETTER LONG A
  { 0x1042B, 0x10403 }, // DESERET CAPITAL LETTER LONG AH
  { 0x1042C, 0x10404 }, // DESERET CAPITAL LETTER LONG O
  { 0x1042D, 0x10405 }, // DESERET CAPITAL LETTER LONG OO
  { 0x1042E, 0x10406 }, // DESERET CAPITAL LETTER SHORT I
  { 0x1042F, 0x10407 }, // DESERET CAPITAL LETTER SHORT E
  { 0x10430, 0x10408 }, // DESERET CAPITAL LETTER SHORT A
  { 0x10431, 0x10409 }, // DESERET CAPITAL LETTER SHORT AH
  { 0x10432, 0x1040A }, // DESERET CAPITAL LETTER SHORT O
  { 0x10433, 0x1040B }, // DESERET CAPITAL LETTER SHORT OO
  { 0x10434, 0x1040C }, // DESERET CAPITAL LETTER AY
  { 0x10435, 0x1040D }, // DESERET CAPITAL LETTER OW
  { 0x10436, 0x1040E }, // DESERET CAPITAL LETTER WU
  { 0x10437, 0x1040F }, // DESERET CAPITAL LETTER YEE
  { 0x10438, 0x10410 }, // DESERET CAPITAL LETTER H
  { 0x10439, 0x10411 }, // DESERET CAPITAL LETTER PEE
  { 0x1043A, 0x10412 }, // DESERET CAPITAL LETTER BEE
  { 0x1043B, 0x10413 }, // DESERET CAPITAL LETTER TEE
  { 0x1043C, 0x10414 }, // DESERET CAPITAL LETTER DEE
  { 0x1043D, 0x10415 }, // DESERET CAPITAL LETTER CHEE
  { 0x1043E, 0x10416 }, // DESERET CAPITAL LETTER JEE
  { 0x1043F, 0x10417 }, // DESERET CAPITAL LETTER KAY
  { 0x10440, 0x10418 }, // DESERET CAPITAL LETTER GAY
  { 0x10441, 0x10419 }, // DESERET CAPITAL LETTER EF
  { 0x10442, 0x1041A }, // DESERET CAPITAL LETTER VEE
  { 0x10443, 0x1041B }, // DESERET CAPITAL LETTER ETH
  { 0x10444, 0x1041C }, // DESERET CAPITAL LETTER THEE
  { 0x10445, 0x1041D }, // DESERET CAPITAL LETTER ES
  { 0x10446, 0x1041E }, // DESERET CAPITAL LETTER ZEE
  { 0x10447, 0x1041F }, // DESERET CAPITAL LETTER ESH
  { 0x10448, 0x10420 }, // DESERET CAPITAL LETTER ZHEE
  { 0x10449, 0x10421 }, // DESERET CAPITAL LETTER ER
  { 0x1044A, 0x10422 }, // DESERET CAPITAL LETTER EL
  { 0x1044B, 0x10423 }, // DESERET CAPITAL LETTER EM
  { 0x1044C, 0x10424 }, // DESERET CAPITAL LETTER EN
  { 0x1044D, 0x10425 }, // DESERET CAPITAL LETTER ENG
  { 0x1044E, 0x10426 }, // DESERET CAPITAL LETTER OI
  { 0x1044F, 0x10427 }, // DESERET CAPITAL LETTER EW
};

/**
 * Each row contains the [begin,end) pointers for the respective table.
 */
case_table_entry const *const case_tables[][2] = {
  { upper2lower, upper2lower + sizeof( upper2lower ) / sizeof upper2lower[0] },
  { lower2upper, lower2upper + sizeof( lower2upper ) / sizeof lower2upper[0] },
};

enum case_type {
  upper, lower
};

struct less_case_table_entry :
  binary_function<case_table_entry const&,case_table_entry const&,bool>
{
  less_case_table_entry() { }
  result_type operator()( first_argument_type i, second_argument_type j ) {
    return i[0] < j[0];
  }
};

template<case_type Case>
bool is_case( code_point c ) {
  case_table_entry const *const begin = case_tables[ Case ][0];
  case_table_entry const *const end   = case_tables[ Case ][1];
  case_table_entry entry_to_find;
  entry_to_find[0] = c;
  return ::binary_search( begin, end, entry_to_find, less_case_table_entry() );
}

template<case_type Case>
code_point to_case( code_point c ) {
  typedef pair<case_table_entry const*, case_table_entry const*> range_type;

  case_table_entry const *const begin = case_tables[ !Case ][0];
  case_table_entry const *const end   = case_tables[ !Case ][1];
  case_table_entry entry_to_find;
  entry_to_find[0] = c;

  range_type const result =
    ::equal_range( begin, end, entry_to_find, less_case_table_entry() );
  return result.first == result.second ? c : (*result.first)[1];
}

} // anonymous namespace

///////////////////////////////////////////////////////////////////////////////

bool is_iprivate( code_point c ) {
  return  (0x00E000 <= c && c <= 0x00F8FF) ||
          (0x0F0000 <= c && c <= 0x0FFFFD) ||
          (0x100000 <= c && c <= 0x10FFFD) ;
}

bool is_invalid_in_iri( code_point c ) {
  return  c <= ' '  ||
          c == '"'  ||
          c == '<'  ||
          c == '>'  ||
          c == '\\' ||
          c == '^'  ||
          c == '`'  ||
          c == '{'  ||
          c == '|'  ||
          c == '}'  ||
          0x7E < c;
}

bool is_lower( code_point c ) {
  return is_case<lower>( c );
}

bool is_ucschar( code_point c ) {
  return  (0x000A0 <= c && c <= 0x0D7FF) ||
          (0x0F900 <= c && c <= 0x0FDCF) ||
          (0x0FDF0 <= c && c <= 0x0FFEF) ||
          (0x10000 <= c && c <= 0x1FFFD) ||
          (0x20000 <= c && c <= 0x2FFFD) ||
          (0x30000 <= c && c <= 0x3FFFD) ||
          (0x40000 <= c && c <= 0x4FFFD) ||
          (0x50000 <= c && c <= 0x5FFFD) ||
          (0x60000 <= c && c <= 0x6FFFD) ||
          (0x70000 <= c && c <= 0x7FFFD) ||
          (0x80000 <= c && c <= 0x8FFFD) ||
          (0x90000 <= c && c <= 0x9FFFD) ||
          (0xA0000 <= c && c <= 0xAFFFD) ||
          (0xB0000 <= c && c <= 0xBFFFD) ||
          (0xC0000 <= c && c <= 0xCFFFD) ||
          (0xD0000 <= c && c <= 0xDFFFD) ||
          (0xE0000 <= c && c <= 0xEFFFD) ;
}

bool is_upper( code_point c ) {
  return is_case<upper>( c );
}

ostream& printable_cp( ostream &o, code_point cp ) {
  if ( ascii::is_print( cp ) )
    o << static_cast<char>( cp );
  else
    switch ( cp ) {
      case '\n': o << "\\n"; break;
      case '\r': o << "\\r"; break;
      case '\t': o << "\\t"; break;
      default: {
        ios::fmtflags const old_flags = o.flags();
        o << "#x" << uppercase << hex << static_cast<uint32_t>( cp );
        o.flags( old_flags );
      }
    }
  return o;
}

code_point to_lower( code_point c ) {
  return to_case<lower>( c );
}

code_point to_upper( code_point c ) {
  return to_case<upper>( c );
}

#ifndef ZORBA_NO_ICU

bool normalize( string const &in, normalization::type n, string *out ) {
  UErrorCode status = U_ZERO_ERROR;
  UNormalizationMode icu_mode;
  switch ( n ) {
    case normalization::NFC : icu_mode = UNORM_NFC ; break;
    case normalization::NFD : icu_mode = UNORM_NFD ; break;
    case normalization::NFKC: icu_mode = UNORM_NFKC; break;
    case normalization::NFKD: icu_mode = UNORM_NFKD; break;
    default                 : icu_mode = UNORM_NONE; break;
  }
  Normalizer::normalize( in, icu_mode, 0, *out, status );
  return U_SUCCESS( status ) == TRUE;
}

bool strip_diacritics( string const &in, string *out ) {
  string in_normalized;
  if ( !normalize( in, normalization::NFKD, &in_normalized ) )
    return false;
  out->truncate( 0 );
  for ( size_type len = in_normalized.length(), i = 0; i < len; ++i ) {
    UChar32 const uc32 = in_normalized.char32At( i );
    if ( u_charType( uc32 ) != U_NON_SPACING_MARK )
      out->append( uc32 );
  }
  return true;
}

bool to_char( char const *in, char_type *out ) {
  try {
    UErrorCode status = U_ZERO_ERROR;
    u_strFromUTF8WithSub(
      out, 1, nullptr, in, utf8::char_length( *in ), SubChar, nullptr, &status
    );
    return U_SUCCESS( status ) == TRUE;
  }
  catch ( utf8::invalid_byte const& ) {
    return false;
  }
}

#endif /* ZORBA_NO_ICU */

bool to_string( char const *in, size_type in_len, char_type **out,
                size_type *out_len ) {
#ifndef ZORBA_NO_ICU
  size_type utf16_len;
  UErrorCode status = U_ZERO_ERROR;
  u_strFromUTF8WithSub(                 // pre-flight to get utf16_len
    nullptr, 0, &utf16_len, in, in_len, SubChar, nullptr, &status
  );
  // must not check "status" here since ICU always returns "buffer overflow"

  char_type *const utf16_buf = new char_type[ utf16_len ];
  status = U_ZERO_ERROR;
  u_strFromUTF8WithSub(
    utf16_buf, utf16_len, nullptr, in, in_len, SubChar, nullptr, &status
  );
  if ( U_FAILURE( status ) ) {
    delete[] utf16_buf;
    return false;
  }
  *out = utf16_buf;
  *out_len = utf16_len;
#else
  *out = new char_type[ in_len + 1 ];
  *out_len = in_len;
  ::strncpy( *out, in, *out_len );
#endif /* ZORBA_NO_ICU */
  return true;
}

#ifndef ZORBA_NO_ICU

bool to_string( char const *in, size_type in_len, string *out ) {
  char_type *const buf = out->getBuffer( in_len + 1 );
  size_type buf_len;
  UErrorCode status = U_ZERO_ERROR;
  u_strFromUTF8( buf, in_len + 1, &buf_len, in, in_len, &status );
  out->releaseBuffer( buf_len );
  return U_SUCCESS( status ) == TRUE;
}

bool to_string( wchar_t const *in, size_type in_len, string *out ) {
  char_type *const buf = out->getBuffer( in_len + 1 );
  UErrorCode status = U_ZERO_ERROR;
  size_type buf_len;
  u_strFromWCS( buf, in_len + 1, &buf_len, in, in_len, &status );
  out->releaseBuffer( buf_len );
  return U_SUCCESS( status ) == TRUE;
}

#endif /* ZORBA_NO_ICU */

///////////////////////////////////////////////////////////////////////////////

} // namespace unicode
} // namespace zorba
/* vim:set et sw=2 ts=2: */
