# SafeInt
SafeInt is a class library for C++ that manages integer overflows.

As of July, 2022, there is also a C library that checks casting, multiplication, division, addition and subtraction for all combinations of signed and unsigned 32-bit and 64-bit integers. The C library has been validated against the same test vectors as SafeInt. It consists of two files, safe_math.h, and safe_math_impl.h.

Now updated to keep the entire history of the class from the time it first was checked into CodePlex. 

March, 2018 - added support for constexpr, also enforcing a requirement that --std=c++11 or --std=c++14
has to be used for gcc or clang, minimum Visual Studio compiler version TBD.

Note - I do not accept pull requests for the core header, but may for test files, etc. The best thing to do is to give me a bit of sample code that allows me to repro the problem, and I'll fix it in the same style as the rest of the library. It's also critical that this library remain stable, so I will be conservative with changes.

My bug priority is as follows:

0) It either accepts invalid math, or throws with valid math. These have been very rare, but I try to turn these around in hours, not days.
1) There might be a way to make things more efficient - for example, a pending bug to use intrinsics is something I'll take.
1a) There's a cool new thing in the standard you'd like me to support, for example constexpr support was added most recently.
2) You are trying to use the library in an unsupported environment, and you'd like changes so it builds cleanly with your compiler settings. Depending on what this entails, I'll do my best to work with these.
3) The code could be tidier - while the goal is to use very clean, standard C++, it's nearly 7300 LOC, and it isn't perfect. I might take these if I happen to be making changes in that area. Or if you can show me that a change results in more efficient assembly, which makes it category (1).

Note - the large Archive directory tree has been moved to the archive branch, and deleted from master. It is only of dubious historical interest.