vcpkg_from_github(
    OUT_SOURCE_PATH SOURCE_PATH
    REPO Blosc/c-blosc
    REF "v${VERSION}"
    SHA512 01e6d80e1114d76c4bd1b413778c293d0455879ec38e1e1ec46e8e7eaf2997b47cc2de35bc52cdc4c2c70341b6f87d70626a9a9c24ffc8b7b170d760efa60c07
    HEAD_REF master
    PATCHES
      0001-fix-CMake-config.patch
)

string(COMPARE EQUAL "${VCPKG_LIBRARY_LINKAGE}" "static" BLOSC_STATIC)
string(COMPARE EQUAL "${VCPKG_LIBRARY_LINKAGE}" "dynamic" BLOSC_SHARED)

file(REMOVE_RECURSE "${SOURCE_PATH}/internal-complibs")

vcpkg_cmake_configure(
    SOURCE_PATH "${SOURCE_PATH}"
    DISABLE_PARALLEL_CONFIGURE
    OPTIONS
        -DPREFER_EXTERNAL_LZ4=ON
        -DPREFER_EXTERNAL_ZLIB=ON
        -DPREFER_EXTERNAL_ZSTD=ON
        -DBUILD_TESTS=OFF
        -DBUILD_FUZZERS=OFF
        -DBUILD_BENCHMARKS=OFF
        -DBUILD_STATIC=${BLOSC_STATIC}
        -DBUILD_SHARED=${BLOSC_SHARED}
)

vcpkg_cmake_install()
vcpkg_copy_pdbs()
vcpkg_cmake_config_fixup(CONFIG_PATH share/${PORT})

vcpkg_replace_string("${CURRENT_PACKAGES_DIR}/share/${PORT}/blosc-config.cmake"
    [[# Generated by CMake]]
    [[# Generated by CMake 
include(CMakeFindDependencyMacro)
find_dependency(lz4 CONFIG)
find_dependency(zstd CONFIG)
find_dependency(Snappy CONFIG)
find_dependency(ZLIB)
find_dependency(Threads)]]
)

# cleanup
file(REMOVE_RECURSE "${CURRENT_PACKAGES_DIR}/debug/include")
# Handle copyright
vcpkg_install_copyright(FILE_LIST "${SOURCE_PATH}/LICENSE.txt")

vcpkg_fixup_pkgconfig()
