/*

    WiRouter KeyRec - Salvatore Fresta

    Contact: salvatorefresta@gmail.com

    Copyright 2010-2011 Salvatore Fresta aka Drosophila

    This program is free software; you can redistribute it and/or
    modify it under the terms of  the  GNU General Public License
    as published by the  Free Software Foundation; either version
    2 of the License, or (at your option) any later version.

    This program  is  distributed  in the hope  that  it  will be
    useful, but WITHOUT ANY WARRANTY;  without  even the  implied
    warranty  of  MERCHANTABILITY  or  FITNESS  FOR  A PARTICULAR
    PURPOSE. See the GNU General Public License for more details.

    You should have  received a copy  of  the  GNU General Public
    License along  with  this program;  if not, write to the Free
    Software Foundation,Inc., 59 Temple Place, Suite 330, Boston,
    MA 02111-1307 USA

    http://www.gnu.org/licenses/gpl-2.0.txt

*/

#ifndef TELETU_H
#define TELETU_H

#define TELETU_DEFAULT_WEB_PAGE           "http://poc.salvatorefresta.net/teletu_config.lst"
#define TELETU_DEFAULT_CONFIG_FILE_DIR    "/etc/wirouterkeyrec/teletu_config.lst"
#define TELETU_DEFAULT_CONFIG_FILE        "teletu_config.lst" 

typedef struct teletu_net_conf {

    unsigned char wpa_key[15];
    unsigned char mac[18];
    unsigned int base;
    unsigned int sn;

    struct teletu_net_conf *next;

} Teletu_config;


int teletu_update_config_file(unsigned char *filename, unsigned char *host, int port, unsigned char *url, char *delone, char *deltwo, int debug);
Teletu_config *teletu_get_config(unsigned char *mac_in, unsigned char *error, unsigned char *config_file, int debug);
Teletu_config *teletu_config_free(Teletu_config *first);
Teletu_config *teletu_config_add(Teletu_config *first, unsigned char wpa_key[15], unsigned int base, unsigned int sn, unsigned char mac[18]);

#endif /* TELETU_H */