/* This file is automatically generated by sql_to_c.awk */

#include "sqlnode.h"
#include "sqlfn.h"
#include "sqltype.h"

/* oledb.sql */

static const char *proc0 = 
"#line 131 \"[executable]/oledb.sql\"\n"
"create procedure oledb_get_types (in type integer, in best_match_restrict integer)\n"
"{\n"
"declare TYPE_NAME NVARCHAR(32);\n"
"declare DATA_TYPE SMALLINT;\n"
"declare COLUMN_SIZE INTEGER;\n"
"declare LITERAL_PREFIX, LITERAL_SUFFIX NVARCHAR(5);\n"
"declare CREATE_PARAMS NVARCHAR(64);\n"
"declare IS_NULLABLE, CASE_SENSITIVE SMALLINT;\n"
"declare SEARCHABLE INTEGER;\n"
"declare UNSIGNED_ATTRIBUTE, FIXED_PREC_SCALE, AUTO_UNIQUE_VALUE SMALLINT;\n"
"declare LOCAL_TYPE_NAME NVARCHAR(32);\n"
"declare MINIMUM_SCALE, MAXIMUM_SCALE SMALLINT;\n"
"declare GUID, TYPELIB, VERSION NVARCHAR(32);\n"
"declare IS_LONG, BEST_MATCH, IS_FIXEDLENGTH SMALLINT;\n"
"\n"
"result_names (TYPE_NAME, DATA_TYPE, COLUMN_SIZE,\n"
"LITERAL_PREFIX, LITERAL_SUFFIX,\n"
"CREATE_PARAMS,\n"
"IS_NULLABLE, CASE_SENSITIVE, SEARCHABLE, UNSIGNED_ATTRIBUTE,\n"
"FIXED_PREC_SCALE, AUTO_UNIQUE_VALUE,\n"
"LOCAL_TYPE_NAME,\n"
"MINIMUM_SCALE, MAXIMUM_SCALE,\n"
"GUID, TYPELIB, VERSION,\n"
"IS_LONG, BEST_MATCH, IS_FIXEDLENGTH);\n"
"\n"
"if (type = 2 or type is null)\n"
"{\n"
"result (N\'smallint\', 2, 5, N\'\', N\'\', NULL, 1, 0, 3, 0, 1, 1, N\'smallint\', NULL, NULL, NULL, NULL, NULL, 0, 1, 1);\n"
"}\n"
"if (type = 3 or type is null)\n"
"{\n"
"result (N\'int\', 3, 10, N\'\', N\'\', NULL, 1, 0, 3, 0, 1, 1, N\'int\', NULL, NULL, NULL, NULL, NULL, 0, 1, 1);\n"
"}\n"
"if (type = 4 or type is null)\n"
"{\n"
"result (N\'real\', 4, 7, N\'\', N\'e0\', NULL, 1, 0, 3, 0, 0, 0, N\'real\', NULL, NULL, NULL, NULL, NULL, 0, 1, 1);\n"
"}\n"
"if (type = 5 or type is null)\n"
"{\n"
"result (N\'float\', 5, 15, N\'\', N\'e0\', NULL, 1, 0, 3, 0, 0, 0, N\'float\', NULL, NULL, NULL, NULL, NULL, 0, 1, 1);\n"
"}\n"
"if (type = 128 or type is null)\n"
"{\n"
"result (N\'varbinary\', 128, 2000, N\'0x\', N\'\', N\'max length\', 1, 0, 4, 0, 0, 0, N\'varbinary\', NULL, NULL, NULL, NULL, NULL, 0, 1, 0);\n"
"if (best_match_restrict is null or best_match_restrict = 0)\n"
"{\n"
"result (N\'long varbinary\', 128, 2147483647, N\'0x\', N\'\', NULL, 1, 0, 1, 0, 0, 0, N\'long varbinary\', NULL, NULL, NULL, NULL, NULL, 1, 0, 0);\n"
"result (N\'timestamp\', 128, 10, N\'0x\', N\'\', NULL, 0, 0, 3, 0, 0, 0, N\'timestamp\', NULL, NULL, NULL, NULL, NULL, 0, 0, 1);\n"
"}\n"
"}\n"
"if (type = 129 or type is null)\n"
"{\n"
"result (N\'varchar\', 129, 2000, N\'\'\'\', N\'\'\'\', N\'max length\', 1, 1, 4, 0, 0, 0, N\'varchar\', NULL, NULL, NULL, NULL, NULL, 0, 1, 0);\n"
"if (best_match_restrict is null or best_match_restrict = 0)\n"
"result (N\'long varchar\', 129, 2147483647, N\'\'\'\', N\'\'\'\', NULL, 1, 1, 1, 0, 0, 0, N\'long varchar\', NULL, NULL, NULL, NULL, NULL, 1, 0, 0);\n"
"}\n"
"if (type = 130 or type is null)\n"
"{\n"
"result (N\'nvarchar\', 130, 1000, N\'N\'\'\', N\'\'\'\', N\'length\', 1, 1, 4, 0, 0, 0, N\'nvarchar\', NULL, NULL, NULL, NULL, NULL, 0, 1, 0);\n"
"if (best_match_restrict is null or best_match_restrict = 0)\n"
"result (N\'long nvarchar\', 130, 1073741823, N\'N\'\'\', N\'\'\'\', NULL, 1, 1, 1, 0, 0, 0, N\'long nvarchar\', NULL, NULL, NULL, NULL, NULL, 1, 0, 0);\n"
"}\n"
"if (type = 131 or type is null)\n"
"{\n"
"result (N\'decimal\', 131, 40, N\'\', N\'\', N\'precision,scale\', 1, 0, 3, 0, 0, 0, N\'decimal\', 0, 15, NULL, NULL, NULL, 0, 1, 1);\n"
"if (best_match_restrict is null or best_match_restrict = 0)\n"
"result (N\'numeric\', 131, 40, N\'\', N\'\', N\'precision,scale\', 1, 0, 3, 0, 0, 0, N\'numeric\', 0, 15, NULL, NULL, NULL, 0, 0, 1);\n"
"}\n"
"if (type = 133 or type is null)\n"
"{\n"
"result (N\'date\', 133, 10, N\'{d \'\'\', N\'\'\'}\', NULL, 1, 0, 3, 0, 0, 0, N\'date\', NULL, NULL, NULL, NULL, NULL, 0, 1, 1);\n"
"}\n"
"if (type = 134 or type is null)\n"
"{\n"
"result (N\'time\', 134, 8, N\'{t \'\'\', N\'\'\'}\', NULL, 1, 0, 3, 0, 0, 0, N\'time\', NULL, NULL, NULL, NULL, NULL, 0, 1, 1);\n"
"}\n"
"if (type = 135 or type is null)\n"
"{\n"
"result (N\'datetime\', 135, 19, N\'{ts \'\'\', N\'\'\'}\', NULL, 1, 0, 3, 0, 0, 0, N\'datetime\', NULL, NULL, NULL, NULL, NULL, 0, 1, 1);\n"
"}\n"
"\n"
"\n"
"\n"
"return;\n"
"}\n"
"--src oledb.sql:129\n"
;

static const char *proc1 = 
"#line 218 \"[executable]/oledb.sql\"\n"
"create function oledb_dbtype(in dv integer) returns smallint\n"
"{\n"
"if (dv = __tag of smallint)\n"
"return 2;\n"
"\n"
"if (dv = __tag of integer)\n"
"return 3;\n"
"\n"
"if (dv = 190)\n"
"return 4;\n"
"\n"
"if (dv = 191)\n"
"return 5;\n"
"\n"
"if (dv = __tag of decimal)\n"
"return 131;\n"
"\n"
"if (dv = 181 or dv = __tag of varchar or dv = 238 or dv = 125)\n"
"return 129;\n"
"\n"
"if (dv = __tag of nvarchar or dv = 226 or dv = 132)\n"
"return 130;\n"
"\n"
"if (dv = 222 or dv = 131)\n"
"return 128;\n"
"\n"
"if (dv = 129)\n"
"return 133;\n"
"\n"
"if (dv = 210)\n"
"return 134;\n"
"\n"
"if (dv = 211)\n"
"return 135;\n"
"\n"
"if (dv = 128 or dv = 208)\n"
"return 128;\n"
"\n"
"\n"
"return 129;\n"
"}\n"
"--src oledb.sql:216\n"
;

static const char *proc2 = 
"#line 261 \"[executable]/oledb.sql\"\n"
"create function oledb_dbflags(in dv integer, in nullable integer) returns integer\n"
"{\n"
"declare flags integer;\n"
"\n"
"flags := 0;\n"
"if (dv = 128 or dv = 208)\n"
"{\n"
"flags := 16 + 512;\n"
"}\n"
"else\n"
"{\n"
"if (dv = __tag of smallint or dv = __tag of integer or dv = 190 or\n"
"dv = 191 or dv = __tag of decimal or dv = 129 or\n"
"dv = 210 or dv = 211)\n"
"flags := 16 + 4;\n"
"else if (dv = 125 or dv = 132 or dv = 131)\n"
"flags := 128 + 4;\n"
"else\n"
"flags := 4;\n"
"\n"
"if (nullable is null or nullable <> 1)\n"
"flags := flags + 32 + 64;\n"
"}\n"
"\n"
"return flags;\n"
"}\n"
"--src oledb.sql:259\n"
;

static const char *proc3 = 
"#line 289 \"[executable]/oledb.sql\"\n"
"create function oledb_char_max_len(in dv integer, in prec integer) returns integer\n"
"{\n"
"if (dv = __tag of smallint or dv = __tag of integer or dv = 190 or\n"
"dv = 191 or dv = __tag of decimal or dv = 129 or\n"
"dv = 210 or dv = 211)\n"
"return null;\n"
"if (dv = __tag of nvarchar or dv = 226 or dv = 132)\n"
"{\n"
"if (prec < 1073741823)\n"
"return prec;\n"
"return 1073741823;\n"
"}\n"
"return prec;\n"
"}\n"
"--src oledb.sql:287\n"
;

static const char *proc4 = 
"#line 305 \"[executable]/oledb.sql\"\n"
"create function oledb_char_oct_len(in dv integer, in prec integer) returns integer\n"
"{\n"
"if (dv = __tag of smallint or dv = __tag of integer or dv = 190 or\n"
"dv = 191 or dv = __tag of decimal or dv = 129 or\n"
"dv = 210 or dv = 211)\n"
"return null;\n"
"if (dv = __tag of nvarchar or dv = 226 or dv = 132)\n"
"{\n"
"if (prec < 1073741823)\n"
"return prec * 2;\n"
"return 2147483646;\n"
"}\n"
"return prec;\n"
"}\n"
"--src oledb.sql:303\n"
;

static const char *proc5 = 
"#line 321 \"[executable]/oledb.sql\"\n"
"create function oledb_num_prec(in dv integer, in prec integer) returns smallint\n"
"{\n"
"if (dv = __tag of smallint)\n"
"return 5;\n"
"if (dv = __tag of integer)\n"
"return 10;\n"
"if (dv = 190)\n"
"return 7;\n"
"if (dv = 191)\n"
"return 15;\n"
"if (dv = __tag of decimal)\n"
"{\n"
"if (prec < 40)\n"
"return prec;\n"
"return 39;\n"
"}\n"
"return null;\n"
"}\n"
"--src oledb.sql:319\n"
;

static const char *proc6 = 
"#line 341 \"[executable]/oledb.sql\"\n"
"create function oledb_num_scale(in dv integer, in scale integer) returns smallint\n"
"{\n"
"if (dv = __tag of decimal)\n"
"return scale;\n"
"return null;\n"
"}\n"
"--src oledb.sql:339\n"
;

static const char *proc7 = 
"#line 349 \"[executable]/oledb.sql\"\n"
"create function oledb_datetime_prec(in dv integer, in prec integer) returns smallint\n"
"{\n"
"if (dv = 211)\n"
"return 6;\n"
"return null;\n"
"}\n"
"--src oledb.sql:347\n"
;

static const char *proc8 = 
"#line 357 \"[executable]/oledb.sql\"\n"
"create procedure oledb_procedure_parameters(\n"
"in cat nvarchar, in sch nvarchar, in proc nvarchar, in param nvarchar\n"
")\n"
"{\n"
"declare PROCEDURE_CATALOG, PROCEDURE_SCHEMA, PROCEDURE_NAME, PARAMETER_NAME nvarchar(128);\n"
"declare ORDINAL_POSITION, PARAMETER_TYPE, PARAMETER_HASDEFAULT smallint;\n"
"declare PARAMETER_DEFAULT nvarchar;\n"
"declare IS_NULLABLE, DATA_TYPE smallint;\n"
"declare CHARACTER_MAXIMUM_LENGTH, CHARACTER_OCTET_LENGTH integer;\n"
"declare NUMERIC_PRECISION, NUMERIC_SCALE smallint;\n"
"declare DESCRIPTION nvarchar;\n"
"declare TYPE_NAME nvarchar(32);\n"
"declare LOCAL_TYPE_NAME nvarchar;\n"
"declare cols, elt any;\n"
"declare i, n integer;\n"
"\n"
"cat := upper(cat);\n"
"sch := upper(sch);\n"
"proc := upper(proc);\n"
"param := upper(param);\n"
"\n"
"result_names (PROCEDURE_CATALOG, PROCEDURE_SCHEMA, PROCEDURE_NAME, PARAMETER_NAME,\n"
"ORDINAL_POSITION, PARAMETER_TYPE, PARAMETER_HASDEFAULT, PARAMETER_DEFAULT,\n"
"IS_NULLABLE, DATA_TYPE, CHARACTER_MAXIMUM_LENGTH, CHARACTER_OCTET_LENGTH,\n"
"NUMERIC_PRECISION, NUMERIC_SCALE, DESCRIPTION, TYPE_NAME, LOCAL_TYPE_NAME);\n"
"\n"
"for\n"
"select P_NAME from DB.DBA.SYS_PROCEDURES where\n"
"(cat is null or upper(cast(name_part(P_NAME, 0) as NVARCHAR)) = cat) and\n"
"(sch is null or upper(cast(name_part(P_NAME, 1) as NVARCHAR)) = sch) and\n"
"(proc is null or upper(cast(name_part(P_NAME, 2) as NVARCHAR)) = proc) and\n"
"__proc_exists (P_NAME, 0) is null\n"
"order by P_NAME\n"
"do\n"
"{\n"
"cols := procedure_cols (P_NAME);\n"
"if (cols)\n"
"{\n"
"n := length (cols);\n"
"i := 0;\n"
"while (i < n)\n"
"{\n"
"elt := aref (cols, i);\n"
"\n"
"if ((param is null or upper(cast(aref(elt, 3) as NVARCHAR)) = param)\n"
"and aref(elt, 4) <> 3)\n"
"{\n"
"result (\n"
"aref(elt, 0),\n"
"aref(elt, 1),\n"
"aref(elt, 2),\n"
"aref(elt, 3),\n"
"aref(elt, 9),\n"
"case aref(elt, 4) when 2 then 2 when 4 then 3 when 5 then 4 else 1 end,\n"
"0,\n"
"NULL,\n"
"either(aref(elt, 8), -1, 0),\n"
"oledb_dbtype(aref(elt, 5)),\n"
"oledb_char_max_len(aref(elt, 5), aref(elt, 7)),\n"
"oledb_char_max_len(aref(elt, 5), aref(elt, 7)),\n"
"oledb_num_prec(aref(elt, 5), aref(elt, 7)),\n"
"oledb_num_scale(aref(elt, 5), aref(elt, 6)),\n"
"NULL,\n"
"dv_type_title(aref(elt, 5)),\n"
"NULL\n"
");\n"
"}\n"
"i := i + 1;\n"
"}\n"
"}\n"
"}\n"
"}\n"
"--src oledb.sql:355\n"
;

static const char *proc9 = 
"#line 431 \"[executable]/oledb.sql\"\n"
"create function oledb_procedure_definition(in name nvarchar) returns nvarchar\n"
"{\n"
"declare text varchar;\n"
"declare more long varchar;\n"
"if (__any_grants(\'DB.DBA.SYS_PROCEDURES\', 1, \'P_TEXT\'))\n"
"{\n"
"select P_TEXT, P_MORE into text, more from DB.DBA.SYS_PROCEDURES\n"
"where upper(cast(P_NAME as NVARCHAR)) = upper(cast(name as NVARCHAR));\n"
"if (text is null)\n"
"return cast(more as NVARCHAR);\n"
"return cast(text as NVARCHAR);\n"
"}\n"
"return NULL;\n"
"}\n"
"--src oledb.sql:429\n"
;

static const char *other0 = 
"grant execute on oledb_get_types to public\n";
static const char *other1 = 
"grant execute on oledb_dbtype to public\n";
static const char *other2 = 
"grant execute on oledb_dbflags to public\n";
static const char *other3 = 
"grant execute on oledb_char_max_len to public\n";
static const char *other4 = 
"grant execute on oledb_char_oct_len to public\n";
static const char *other5 = 
"grant execute on oledb_num_prec to public\n";
static const char *other6 = 
"grant execute on oledb_num_scale to public\n";
static const char *other7 = 
"grant execute on oledb_datetime_prec to public\n";
static const char *other8 = 
"grant execute on oledb_procedure_parameters to public\n";
static const char *other9 = 
"grant execute on oledb_procedure_definition to public\n";
/* information_schema.sql */

static const char *view0 = 
"create view INFORMATION_SCHEMA.TABLES as\n"
"select\n"
"name_part(KEY_TABLE,0) AS TABLE_CATALOG 	VARCHAR(128),\n"
"name_part(KEY_TABLE,1) AS TABLE_SCHEMA 	VARCHAR(128),\n"
"name_part(KEY_TABLE,2) AS TABLE_NAME 		VARCHAR(128),\n"
"case table_type (KEY_TABLE)\n"
"when \'TABLE\' then \'BASE TABLE\'\n"
"when \'VIEW\'  then \'VIEW\'\n"
"else NULL\n"
"end 			AS TABLE_TYPE 		VARCHAR(128),\n"
"KEY_TABLE		AS V_KEY_TABLE		VARCHAR,\n"
"KEY_NAME		AS V_KEY_NAME		VARCHAR,\n"
"KEY_ID			AS V_KEY_ID		INTEGER,\n"
"KEY_N_SIGNIFICANT	AS V_KEY_N_SIGNIFICANT	SMALLINT,\n"
"KEY_CLUSTER_ON_ID	AS V_KEY_CLUSTER_ON_ID	SMALLINT,\n"
"KEY_IS_MAIN		AS V_KEY_IS_MAIN	SMALLINT,\n"
"KEY_IS_OBJECT_ID	AS V_KEY_IS_OBJECT_ID	SMALLINT,\n"
"KEY_IS_UNIQUE		AS V_KEY_IS_UNIQUE	SMALLINT,\n"
"KEY_MIGRATE_TO		AS V_KEY_MIGRATE_TO	INTEGER,\n"
"KEY_SUPER_ID		AS V_KEY_SUPER_ID	INTEGER,\n"
"KEY_DECL_PARTS		AS V_KEY_DECL_PARTS	SMALLINT,\n"
"KEY_STORAGE		AS V_KEY_STORAGE	VARCHAR,\n"
"KEY_OPTIONS		AS V_KEY_OPTIONS	ANY\n"
"from DB.DBA.SYS_KEYS\n"
"where\n"
"__any_grants (KEY_TABLE)\n"
"and table_type (KEY_TABLE) = \'TABLE\'\n"
"and KEY_IS_MAIN = 1\n"
"and KEY_MIGRATE_TO is NULL\n";

static const char *other10 = 
"grant select on INFORMATION_SCHEMA.TABLES to public\n";
static const char *view1 = 
"create view INFORMATION_SCHEMA.COLUMNS as\n"
"select\n"
"k.TABLE_CATALOG		AS TABLE_CATALOG 		VARCHAR(128),\n"
"k.TABLE_SCHEMA			AS TABLE_SCHEMA 		VARCHAR(128),\n"
"k.TABLE_NAME			AS TABLE_NAME			VARCHAR(128),\n"
"c.\"COLUMN\"			AS COLUMN_NAME			VARCHAR(128),\n"
"\n"
"kp.KP_NTH + 1			AS ORDINAL_POSITION 		INTEGER,\n"
"\n"
"deserialize (c.COL_DEFAULT)	AS COLUMN_DEF 			VARCHAR,\n"
"\n"
"case c.COL_NULLABLE\n"
"when 0 then \'YES\'\n"
"when 1 then \'NO\'\n"
"else NULL\n"
"end 				AS NULLABLE 			VARCHAR (3),\n"
"\n"
"case\n"
"when (\n"
"c.COL_DTP in (125, 132) and\n"
"get_keyword (\'xml_col\', coalesce (c.COL_OPTIONS, vector ())) is not null)\n"
"then \'XMLType\'\n"
"\n"
"else dv_type_title(c.COL_DTP)\n"
"end 				AS DATA_TYPE			VARCHAR(128),\n"
"\n"
"\n"
"c.COL_PREC 			AS CHARACTER_MAXIMUM_LENGTH	INTEGER,\n"
"\n"
"c.COL_PREC 			AS CHARACTER_OCTET_LENGTH 	INTEGER,\n"
"\n"
"c.COL_PREC			AS NUMERIC_PRECISION		SMALLINT,\n"
"\n"
"2 				AS NUMERIC_PRECISION_RADIX	SMALLINT,\n"
"\n"
"c.COL_SCALE			AS NUMERIC_SCALE		SMALLINT,\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"case\n"
"when get_keyword (\'xml_col\', coalesce (c.COL_OPTIONS, vector ())) is not null\n"
"then \'DB\'\n"
"when get_keyword (\'sql_class\', coalesce (c.COL_OPTIONS, vector ())) is not null\n"
"then name_part (get_keyword (\'sql_class\', coalesce (c.COL_OPTIONS, vector ())), 0, dbname())\n"
"else NULL\n"
"end 				AS DOMAIN_CATALOG		VARCHAR(128),\n"
"\n"
"case\n"
"when get_keyword (\'xml_col\', coalesce (c.COL_OPTIONS, vector ())) is not null\n"
"then \'DBA\'\n"
"when get_keyword (\'sql_class\', coalesce (c.COL_OPTIONS, vector ())) is not null\n"
"then name_part (get_keyword (\'sql_class\', coalesce (c.COL_OPTIONS, vector ())), 1, USER)\n"
"else NULL\n"
"end				AS DOMAIN_SCHEMA		VARCHAR(128),\n"
"\n"
"case\n"
"when get_keyword (\'xml_col\', coalesce (c.COL_OPTIONS, vector ())) is not null\n"
"then \'XMLType\'\n"
"when get_keyword (\'sql_class\', coalesce (c.COL_OPTIONS, vector ())) is not null\n"
"then name_part (get_keyword (\'sql_class\', coalesce (c.COL_OPTIONS, vector ())), 2)\n"
"else NULL\n"
"end				AS DOMAIN_NAME			VARCHAR(128),\n"
"\n"
"case\n"
"when strchr (coalesce (COL_CHECK, \'\'), \'I\') is not null\n"
"then \'YES\'\n"
"else \'NO\'\n"
"end    			AS IS_IDENTITY			VARCHAR(3),\n"
"\n"
"case\n"
"when strchr (coalesce (COL_CHECK, \'\'), \'I\') is not null\n"
"then \'ALWAYS\'\n"
"else NULL\n"
"end				AS IDENTITY_GENERATION		VARCHAR(10),\n"
"\n"
"get_keyword (\n"
"\'identity_start\',\n"
"coalesce (c.COL_OPTIONS, vector ()))\n"
"AS IDENTITY_START		VARCHAR,\n"
"\n"
"get_keyword (\n"
"\'increment_by\',\n"
"coalesce (c.COL_OPTIONS, vector ()))\n"
"AS IDENTITY_INCREMENT		VARCHAR,\n"
"\n"
"\"TABLE\"			AS V_TABLE			VARCHAR,\n"
"\"COLUMN\"			AS V_COLUMN			VARCHAR,\n"
"COL_ID				AS V_COL_ID			INTEGER,\n"
"COL_DTP			AS V_COL_DTP			SMALLINT,\n"
"COL_PREC			AS V_COL_PREC			INTEGER,\n"
"COL_SCALE			AS V_COL_SCALE			SMALLINT,\n"
"COL_DEFAULT			AS V_COL_DEFAULT		VARCHAR,\n"
"COL_CHECK			AS V_COL_CHECK			VARCHAR,\n"
"COL_NULLABLE			AS V_COL_NULLABLE		SMALLINT,\n"
"COL_NTH			AS V_COL_NTH			SMALLINT,\n"
"COL_OPTIONS			AS V_COL_OPTIONS		ANY,\n"
"\n"
"KP_NTH				AS V_KP_NTH			SMALLINT\n"
"\n"
"from INFORMATION_SCHEMA.TABLES k, DB.DBA.SYS_KEY_PARTS kp, DB.DBA.SYS_COLS c\n"
"where\n"
"c.\"COLUMN\" <> \'_IDN\'\n"
"\n"
"and kp.KP_KEY_ID = k.V_KEY_ID\n"
"and COL_ID = KP_COL\n";

static const char *other11 = 
"grant select on INFORMATION_SCHEMA.COLUMNS to public\n";
static const char *view2 = 
"create view INFORMATION_SCHEMA.SCHEMATA as\n"
"select distinct\n"
"TABLE_CATALOG			AS CATALOG_NAME			VARCHAR(128),\n"
"TABLE_SCHEMA			AS SCHEMA_NAME			VARCHAR(128),\n"
"TABLE_SCHEMA			AS SCHEMA_OWNER			VARCHAR(128)\n"
"from INFORMATION_SCHEMA.TABLES\n";

static const char *other12 = 
"grant select on INFORMATION_SCHEMA.SCHEMATA to public\n";
static const char *view3 = 
"create view INFORMATION_SCHEMA.CHECK_CONSTRAINTS as\n"
"select\n"
"name_part (C_TABLE, 0)		AS CONSTRAINT_CATALOG		VARCHAR(128),\n"
"name_part (C_TABLE, 1)		AS CONSTRAINT_SCHEMA		VARCHAR(128),\n"
"C_TEXT				AS CONSTRAINT_NAME		VARCHAR(128),\n"
"sql_text (deserialize (blob_to_string (C_MODE)))\n"
"AS CHECK_CLAUSE			VARCHAR,\n"
"\n"
"C_TABLE			AS V_C_TABLE,\n"
"C_ID				AS V_C_ID,\n"
"C_TEXT				AS V_C_TEXT,\n"
"C_MODE				AS V_C_MODE\n"
"from DB.DBA.SYS_CONSTRAINTS, INFORMATION_SCHEMA.TABLES\n"
"where\n"
"V_KEY_TABLE = C_TABLE\n";

static const char *other13 = 
"grant select on INFORMATION_SCHEMA.CHECK_CONSTRAINTS to public\n";
static const char *view4 = 
"create view INFORMATION_SCHEMA.COLUMN_DOMAIN_USAGE as\n"
"select\n"
"DOMAIN_CATALOG			AS DOMAIN_CATALOG		VARCHAR(128),\n"
"DOMAIN_SCHEMA			AS DOMAIN_SCHEMA		VARCHAR(128),\n"
"DOMAIN_NAME			AS DOMAIN_NAME			VARCHAR(128),\n"
"TABLE_CATALOG			AS TABLE_CATALOG		VARCHAR(128),\n"
"TABLE_SCHEMA			AS TABLE_SCHEMA			VARCHAR(128),\n"
"TABLE_NAME			AS TABLE_NAME			VARCHAR(128),\n"
"COLUMN_NAME			AS COLUMN_NAME			VARCHAR(128)\n"
"from INFORMATION_SCHEMA.COLUMNS\n"
"where\n"
"DOMAIN_NAME is not NULL\n";

static const char *other14 = 
"grant select on INFORMATION_SCHEMA.COLUMN_DOMAIN_USAGE to public\n";
static const char *view5 = 
"create view INFORMATION_SCHEMA.COLUMN_PRIVILEGES as\n"
"select\n"
"case\n"
"when G_GRANTOR is not null\n"
"then __sec_uid_to_user (cast (G_GRANTOR as integer))\n"
"else  NULL\n"
"end 				AS GRANTOR			VARCHAR(128),\n"
"__sec_uid_to_user (G_USER)	AS GRANTEE			VARCHAR(128),\n"
"TABLE_CATALOG			AS TABLE_CATALOG		VARCHAR(128),\n"
"TABLE_SCHEMA			AS TABLE_SCHEMA			VARCHAR(128),\n"
"TABLE_NAME			AS TABLE_NAME			VARCHAR(128),\n"
"COLUMN_NAME			AS COLUMN_NAME			VARCHAR(128),\n"
"case bit_and (G_OP, 79)\n"
"when 1  then \'SELECT\'\n"
"when 2  then \'UPDATE\'\n"
"when 4  then \'INSERT\'\n"
"when 8  then \'DELETE\'\n"
"when 64 then \'REFERENCES\'\n"
"else NULL\n"
"end				AS PRIVILEGE_TYPE		VARCHAR(10),\n"
"case\n"
"when G_USER = 1\n"
"then \'NO\'\n"
"when bit_and (G_OP, 16) = 1\n"
"then \'YES\'\n"
"else \'NO\'\n"
"end				AS IS_GRANTABLE			VARCHAR (3),\n"
"\n"
"G_USER				AS V_G_USER			INTEGER,\n"
"G_OP				AS V_G_OP			INTEGER,\n"
"G_OBJECT			AS V_G_OBJECT			VARCHAR (386),\n"
"G_COL				AS V_G_COL			VARCHAR (386),\n"
"G_GRANTOR			AS V_G_GRANTOR			VARCHAR (128),\n"
"G_ADMIN_OPT    		AS V_G_ADMIN_OPT		VARCHAR (128)\n"
"\n"
"from\n"
"INFORMATION_SCHEMA.COLUMNS, DB.DBA.SYS_GRANTS g\n"
"where\n"
"V_TABLE = G_OBJECT\n"
"and COLUMN_NAME = G_COL\n";

static const char *other15 = 
"grant select on INFORMATION_SCHEMA.COLUMN_PRIVILEGES to public\n";
static const char *proc10 = 
"#line 281 \"[executable]/information_schema.sql\"\n"
" create procedure column_privileges (in TableQualifier varchar,\n"
"in TableOwner varchar,\n"
"in TableName varchar,\n"
"in ColumnName varchar)\n"
"{\n"
"declare priv_op_vec any;\n"
"declare gr cursor for\n"
"select\n"
"TABLE_CATALOG,\n"
"TABLE_SCHEMA,\n"
"TABLE_NAME,\n"
"COLUMN_NAME,\n"
"GRANTOR,\n"
"GRANTEE,\n"
"PRIVILEGE_TYPE,\n"
"IS_GRANTABLE\n"
"from\n"
"(\n"
"select\n"
"case\n"
"when G_GRANTOR is not null\n"
"then __sec_uid_to_user (cast (G_GRANTOR as integer))\n"
"else  NULL\n"
"end 				AS GRANTOR			VARCHAR(128),\n"
"__sec_uid_to_user (G_USER)	AS GRANTEE			VARCHAR(128),\n"
"name_part (c.\"TABLE\", 0)	AS TABLE_CATALOG		VARCHAR(128),\n"
"name_part (c.\"TABLE\", 1)	AS TABLE_SCHEMA			VARCHAR(128),\n"
"name_part (c.\"TABLE\", 2)	AS TABLE_NAME			VARCHAR(128),\n"
"\"COLUMN\"			AS COLUMN_NAME			VARCHAR(128),\n"
"case bit_and (G_OP, 79)\n"
"when 1  then \'SELECT\'\n"
"when 2  then \'UPDATE\'\n"
"when 4  then \'INSERT\'\n"
"when 8  then \'DELETE\'\n"
"when 64 then \'REFERENCES\'\n"
"else NULL\n"
"end				AS PRIVILEGE_TYPE		VARCHAR(10),\n"
"case\n"
"when G_USER = 1\n"
"then \'NO\'\n"
"when bit_and (G_OP, 16) = 1\n"
"then \'YES\'\n"
"else \'NO\'\n"
"end				AS IS_GRANTABLE			VARCHAR (3)\n"
"from\n"
"DB.DBA.SYS_GRANTS, DB.DBA.SYS_KEYS k, DB.DBA.SYS_KEY_PARTS kp, DB.DBA.SYS_COLS c\n"
"where\n"
"\"TABLE\" = G_OBJECT\n"
"and c.\"COLUMN\" = G_COL\n"
"\n"
"and c.\"COLUMN\" <> \'_IDN\'\n"
"and kp.KP_KEY_ID = k.KEY_ID\n"
"and COL_ID = KP_COL\n"
"\n"
"and __any_grants (k.KEY_TABLE)\n"
"and k.KEY_IS_MAIN = 1\n"
"and k.KEY_MIGRATE_TO is NULL\n"
"order by COLUMN_NAME, PRIVILEGE_TYPE\n"
") x\n"
"where TABLE_CATALOG like TableQualifier\n"
"and TABLE_SCHEMA like TableOwner\n"
"and TABLE_NAME like TableName\n"
"and COLUMN_NAME like ColumnName;\n"
"\n"
"whenever not found goto done;\n"
"declare privcount integer;\n"
"declare TABLE_CAT, TABLE_SCHEM, GRANTOR VARCHAR(128);\n"
"declare TABLE_NAME, COLUMN_NAME, GRANTEE, PRIVILEGE VARCHAR(128);\n"
"declare IS_GRANTABLE VARCHAR(3);\n"
"\n"
"result_names (TABLE_CAT, TABLE_SCHEM, TABLE_NAME,\n"
"COLUMN_NAME, GRANTOR, GRANTEE, PRIVILEGE, IS_GRANTABLE);\n"
"\n"
"privcount := 0;\n"
"open gr;\n"
"while (1)\n"
"{\n"
"fetch gr into TABLE_CAT, TABLE_SCHEM, TABLE_NAME,\n"
"COLUMN_NAME, GRANTOR, GRANTEE, PRIVILEGE, IS_GRANTABLE;\n"
"\n"
"result(TABLE_CAT, TABLE_SCHEM, TABLE_NAME,\n"
"COLUMN_NAME, GRANTOR, GRANTEE, PRIVILEGE, IS_GRANTABLE);\n"
"\n"
"if((\'dba\' = get_user()) or\n"
"(GRANTEE = get_user()) or (GRANTEE = \'public\'))\n"
"{ privcount := privcount+1; }\n"
"}\n"
"done:\n"
"return privcount;\n"
"}\n"
"--src information_schema.sql:279\n"
;

static const char *proc11 = 
"#line 374 \"[executable]/information_schema.sql\"\n"
" create procedure column_privileges_utf8 (in TableQualifier varchar,\n"
"in TableOwner varchar,\n"
"in TableName varchar,\n"
"in ColumnName varchar)\n"
"{\n"
"declare priv_op_vec any;\n"
"declare gr cursor for\n"
"select\n"
"charset_recode (TABLE_CATALOG, \'UTF-8\', \'_WIDE_\') as TABLE_CATALOG NVARCHAR(128),\n"
"charset_recode (TABLE_SCHEMA, \'UTF-8\', \'_WIDE_\') as TABLE_SCHEMA NVARCHAR(128),\n"
"charset_recode (TABLE_NAME, \'UTF-8\', \'_WIDE_\') as TABLE_NAME NVARCHAR(128),\n"
"charset_recode (COLUMN_NAME, \'UTF-8\', \'_WIDE_\') as COLUMN_NAME NVARCHAR(128),\n"
"charset_recode (GRANTOR, \'UTF-8\', \'_WIDE_\') as GRANTOR NVARCHAR(128),\n"
"charset_recode (GRANTEE, \'UTF-8\', \'_WIDE_\') as GRANTEE NVARCHAR(128),\n"
"charset_recode (PRIVILEGE_TYPE, \'UTF-8\', \'_WIDE_\') as PRIVILEGE_TYPE NVARCHAR(128),\n"
"charset_recode (IS_GRANTABLE, \'UTF-8\', \'_WIDE_\') as IS_GRANTABLE NVARCHAR(128)\n"
"from\n"
"(\n"
"select\n"
"case\n"
"when G_GRANTOR is not null\n"
"then __sec_uid_to_user (cast (G_GRANTOR as integer))\n"
"else  NULL\n"
"end 				AS GRANTOR			VARCHAR(128),\n"
"__sec_uid_to_user (G_USER)	AS GRANTEE			VARCHAR(128),\n"
"name_part (c.\"TABLE\", 0)	AS TABLE_CATALOG		VARCHAR(128),\n"
"name_part (c.\"TABLE\", 1)	AS TABLE_SCHEMA			VARCHAR(128),\n"
"name_part (c.\"TABLE\", 2)	AS TABLE_NAME			VARCHAR(128),\n"
"\"COLUMN\"			AS COLUMN_NAME			VARCHAR(128),\n"
"case bit_and (G_OP, 79)\n"
"when 1  then \'SELECT\'\n"
"when 2  then \'UPDATE\'\n"
"when 4  then \'INSERT\'\n"
"when 8  then \'DELETE\'\n"
"when 64 then \'REFERENCES\'\n"
"else NULL\n"
"end				AS PRIVILEGE_TYPE		VARCHAR(10),\n"
"case\n"
"when G_USER = 1\n"
"then \'NO\'\n"
"when bit_and (G_OP, 16) = 1\n"
"then \'YES\'\n"
"else \'NO\'\n"
"end				AS IS_GRANTABLE			VARCHAR (3)\n"
"from\n"
"DB.DBA.SYS_GRANTS, DB.DBA.SYS_KEYS k, DB.DBA.SYS_KEY_PARTS kp, DB.DBA.SYS_COLS c\n"
"where\n"
"\"TABLE\" = G_OBJECT\n"
"and (c.\"COLUMN\" = G_COL or G_COL = \'_all\')\n"
"\n"
"and c.\"COLUMN\" <> \'_IDN\'\n"
"and kp.KP_KEY_ID = k.KEY_ID\n"
"and COL_ID = KP_COL\n"
"\n"
"and __any_grants (k.KEY_TABLE)\n"
"and k.KEY_IS_MAIN = 1\n"
"and k.KEY_MIGRATE_TO is NULL\n"
") x\n"
"where TABLE_CATALOG like TableQualifier\n"
"and TABLE_SCHEMA like TableOwner\n"
"and TABLE_NAME like TableName\n"
"and COLUMN_NAME like ColumnName;\n"
"\n"
"whenever not found goto done;\n"
"declare privcount integer;\n"
"declare TABLE_CAT, TABLE_SCHEM, GRANTOR NVARCHAR(128);\n"
"declare TABLE_NAME, COLUMN_NAME, GRANTEE NVARCHAR(128);\n"
"declare IS_GRANTABLE, PRIVILEGE NVARCHAR(3);\n"
"\n"
"result_names (TABLE_CAT, TABLE_SCHEM, TABLE_NAME,\n"
"COLUMN_NAME, GRANTOR, GRANTEE, PRIVILEGE, IS_GRANTABLE);\n"
"\n"
"privcount := 0;\n"
"open gr;\n"
"while (1)\n"
"{\n"
"fetch gr into TABLE_CAT, TABLE_SCHEM, TABLE_NAME,\n"
"COLUMN_NAME, GRANTOR, GRANTEE, PRIVILEGE, IS_GRANTABLE;\n"
"\n"
"result(TABLE_CAT, TABLE_SCHEM, TABLE_NAME,\n"
"COLUMN_NAME, GRANTOR, GRANTEE, PRIVILEGE, IS_GRANTABLE);\n"
"\n"
"if((\'dba\' = get_user()) or\n"
"(GRANTEE = cast (charset_recode (get_user(), \'UTF-8\', \'_WIDE_\') as nvarchar)) or (GRANTEE = N\'public\'))\n"
"{ privcount := privcount+1; }\n"
"}\n"
"done:\n"
"return privcount;\n"
"}\n"
"--src information_schema.sql:372\n"
;

static const char *view6 = 
"create view INFORMATION_SCHEMA.KEY_COLUMN_USAGE as\n"
"select\n"
"name_part(KEY_NAME,0, name_part(KEY_TABLE,0))	AS CONSTRAINT_CATALOG 	VARCHAR(128),\n"
"name_part(KEY_NAME,1, name_part(KEY_TABLE,1))	AS CONSTRAINT_SCHEMA 	VARCHAR(128),\n"
"name_part(KEY_NAME,2, name_part(KEY_TABLE,2))	AS CONSTRAINT_NAME 	VARCHAR(128),\n"
"name_part(KEY_TABLE,0) 			AS TABLE_CATALOG	VARCHAR(128),\n"
"name_part(KEY_TABLE,1) 			AS TABLE_SCHEMA		VARCHAR(128),\n"
"name_part(KEY_TABLE,2) 			AS TABLE_NAME 		VARCHAR(128),\n"
"\"COLUMN\"					AS COLUMN_NAME		VARCHAR(128),\n"
"KP_NTH + 1					AS ORDINAL_POSITION	SMALLINT,\n"
"KEY_IS_MAIN					AS V_KEY_IS_MAIN	SMALLINT,\n"
"KEY_IS_UNIQUE					AS V_KEY_IS_UNIQUE	SMALLINT\n"
"from DB.DBA.SYS_KEYS k, DB.DBA.SYS_KEY_PARTS kp, DB.DBA.SYS_COLS c\n"
"where\n"
"__any_grants (KEY_TABLE)\n"
"and table_type (KEY_TABLE) = \'TABLE\'\n"
"and KEY_MIGRATE_TO is NULL\n"
"and kp.KP_KEY_ID = k.KEY_ID\n"
"and COL_ID = KP_COL\n"
"and k.KEY_DECL_PARTS > kp.KP_NTH\n"
"UNION ALL\n"
"select\n"
"name_part(FK_NAME,0, name_part(FK_TABLE,0))	AS CONSTRAINT_CATALOG   VARCHAR(128),\n"
"name_part(FK_NAME,1, name_part(FK_TABLE,1))	AS CONSTRAINT_SCHEMA    VARCHAR(128),\n"
"name_part(FK_NAME,2, name_part(FK_TABLE,2))	AS CONSTRAINT_NAME      VARCHAR(128),\n"
"name_part(FK_TABLE,0)				AS TABLE_CATALOG        VARCHAR(128),\n"
"name_part(FK_TABLE,1)				AS TABLE_SCHEMA         VARCHAR(128),\n"
"name_part(FK_TABLE,2)				AS TABLE_NAME           VARCHAR(128),\n"
"FKCOLUMN_NAME					AS COLUMN_NAME          VARCHAR(128),\n"
"KEY_SEQ + 1					AS ORDINAL_POSITION     SMALLINT,\n"
"null						AS V_KEY_IS_MAIN        SMALLINT,\n"
"null						AS V_KEY_IS_UNIQUE      SMALLINT\n"
"from DB.DBA.SYS_FOREIGN_KEYS\n"
"where\n"
"__any_grants (FK_TABLE)\n"
"and table_type (FK_TABLE) = \'TABLE\'\n"
"\n"
"\n"
"order by CONSTRAINT_CATALOG, CONSTRAINT_SCHEMA, CONSTRAINT_NAME, ORDINAL_POSITION\n";

static const char *other16 = 
"grant select on INFORMATION_SCHEMA.KEY_COLUMN_USAGE to public\n";
static const char *proc12 = 
"#line 509 \"[executable]/information_schema.sql\"\n"
"create procedure object_definition_or_null (in obj varchar, in text any)\n"
"{\n"
"declare owner varchar;\n"
"owner := name_part (obj, 1, NULL);\n"
"if (owner = user or user_is_dba (user))\n"
"return text;\n"
"return NULL;\n"
"}\n"
"--src information_schema.sql:507\n"
;

static const char *other17 = 
"grant execute on DB.DBA.object_definition_or_null to public\n";
static const char *view7 = 
"create view INFORMATION_SCHEMA.ROUTINES as\n"
"select\n"
"name_part(P_NAME,0)	AS SPECIFIC_CATALOG 		VARCHAR(128),\n"
"name_part(P_NAME,1)	AS SPECIFIC_SCHEMA 		VARCHAR(128),\n"
"name_part(P_NAME,2)	AS SPECIFIC_NAME 		VARCHAR(128),\n"
"name_part(P_NAME,0)	AS ROUTINE_CATALOG 		VARCHAR(128),\n"
"name_part(P_NAME,1)	AS ROUTINE_SCHEMA 		VARCHAR(128),\n"
"name_part(P_NAME,2)	AS ROUTINE_NAME 		VARCHAR(128),\n"
"NULL			AS MODULE_CATALOG 		VARCHAR(128),\n"
"NULL			AS MODULE_SCHEMA 		VARCHAR(128),\n"
"NULL			AS MODULE_NAME 			VARCHAR(128),\n"
"NULL			AS UDT_CATALOG 			VARCHAR(128),\n"
"NULL			AS UDT_SCHEMA 			VARCHAR(128),\n"
"NULL			AS UDT_NAME 			VARCHAR(128),\n"
"NULL			AS DATA_TYPE 			VARCHAR(128),\n"
"NULL			AS CHARACTER_MAXIMUM_LENGTH 	INTEGER,\n"
"NULL			AS CHARACTER_OCTET_LENGTH 	INTEGER,\n"
"NULL			AS COLLATION_CATALOG		VARCHAR(128),\n"
"NULL			AS COLLATION_SCHEMA		VARCHAR(128),\n"
"NULL			AS COLLATION_NAME		VARCHAR(128),\n"
"NULL			AS CHARACTER_SET_CATALOG	VARCHAR(128),\n"
"NULL			AS CHARACTER_SET_SCHEMA		VARCHAR(128),\n"
"NULL			AS CHARACTER_SET_NAME		VARCHAR(128),\n"
"NULL			AS NUMERIC_PRECISION		SMALLINT,\n"
"NULL			AS NUMERIC_PRECISION_RADIX	SMALLINT,\n"
"NULL			AS NUMERIC_SCALE		SMALLINT,\n"
"NULL			AS DATETIME_PRECISION		SMALLINT,\n"
"NULL			AS INTERVAL_TYPE		VARCHAR(128),\n"
"NULL			AS INTERVAL_PRECISION		SMALLINT,\n"
"NULL			AS TYPE_UDT_CATALOG		VARCHAR(128),\n"
"NULL			AS TYPE_UDT_SCHEMA		VARCHAR(128),\n"
"NULL			AS TYPE_UDT_NAME		VARCHAR(128),\n"
"NULL			AS SCOPE_CATALOG		VARCHAR(128),\n"
"NULL			AS SCOPE_SCHEMA			VARCHAR(128),\n"
"NULL			AS SCOPE_NAME			VARCHAR(128),\n"
"NULL			AS MAXIMUM_CARDINALITY		INTEGER,\n"
"NULL			AS DTD_IDENTIFIER		VARCHAR(128),\n"
"case P_TYPE\n"
"when 1 then \'EXTERNAL\'\n"
"else \'SQL\'\n"
"end			AS ROUTINE_BODY			VARCHAR(30),\n"
"DB.DBA.object_definition_or_null (P_NAME, coalesce (P_TEXT,\n"
"blob_to_string (\n"
"P_MORE))) 		AS ROUTINE_DEFINITION    	VARCHAR,\n"
"NULL			AS EXTERNAL_NAME 		VARCHAR(128),\n"
"NULL			AS EXTERNAL_LANGUAGE		VARCHAR(30),\n"
"NULL			AS PARAMETER_STYLE		VARCHAR(30),\n"
"\'NO\'			AS IS_DETERMINISTIC		VARCHAR(10),\n"
"\'MODIFIES\'		AS SQL_DATA_ACCESS		VARCHAR(30),\n"
"\'YES\'			AS IS_NULL_CALL			VARCHAR(10),\n"
"NULL			AS SQL_PATH			VARCHAR(128),\n"
"\'YES\'			AS SCHEMA_LEVEL_ROUTINE		VARCHAR(10),\n"
"NULL			AS MAX_DYNAMIC_RESULT_SETS	SMALLINT,\n"
"\'NO\'			AS IS_USER_DEFINED_CAST		VARCHAR(10),\n"
"\'NO\'			AS IS_IMPLICITLY_INVOCABLE	VARCHAR(10),\n"
"NULL			AS CREATED			DATETIME,\n"
"NULL			AS LAST_ALTERED			DATETIME\n"
"\n"
"from DB.DBA.SYS_PROCEDURES\n"
"where\n"
"__proc_exists (P_NAME, 1, 1) is not null\n";

static const char *other18 = 
"grant select on INFORMATION_SCHEMA.ROUTINES to public\n";
static const char *view8 = 
"create view INFORMATION_SCHEMA.PARAMETERS as\n"
"select\n"
"PROCEDURE_CAT		AS SPECIFIC_CATALOG		VARCHAR(128),\n"
"PROCEDURE_SCHEM	AS SPECIFIC_SCHEMA		VARCHAR(128),\n"
"PROCEDURE_NAME		AS SPECIFIC_NAME		VARCHAR(128),\n"
"ORDINAL_POSITION	AS ORDINAL_POSITION		INTEGER,\n"
"case COLUMN_TYPE\n"
"when 1 then \'IN\'\n"
"when 4 then \'OUT\'\n"
"when 2 then \'INOUT\'\n"
"else NULL\n"
"end			AS PARAMETER_MODE		VARCHAR(10),\n"
"case COLUMN_TYPE\n"
"when 5 then \'YES\'\n"
"else \'NO\'\n"
"end			AS IS_RESULT			VARCHAR(10),\n"
"\'NO\'			AS AS_LOCATOR			VARCHAR(10),\n"
"COLUMN_NAME		AS PARAMETER_NAME		VARCHAR(128),\n"
"TYPE_NAME		AS DATA_TYPE			VARCHAR(128),\n"
"COLUMN_SIZE		AS CHARACTER_MAXIMUM_LENGTH	INTEGER,\n"
"CHAR_OCTET_LENGTH	AS CHARACTER_OCTET_LENGTH	INTEGER,\n"
"NULL			AS COLLATION_CATALOG		VARCHAR(128),\n"
"NULL			AS COLLATION_SCHEMA		VARCHAR(128),\n"
"NULL			AS COLLATION_NAME		VARCHAR(128),\n"
"NULL			AS CHARACTER_SET_CATALOG	VARCHAR(128),\n"
"NULL			AS CHARACTER_SET_SCHEMA		VARCHAR(128),\n"
"NULL			AS CHARACTER_SET_NAME		VARCHAR(128),\n"
"DECIMAL_DIGITS		AS NUMERIC_PRECISION		SMALLINT,\n"
"NUM_PREC_RADIX		AS NUMERIC_PRECISION_RADIX	SMALLINT,\n"
"COLUMN_SIZE		AS NUMERIC_SCALE		SMALLINT,\n"
"NULL			AS DATETIME_PRECISION		SMALLINT,\n"
"NULL			AS INTERVAL_TYPE		VARCHAR(128),\n"
"NULL			AS INTERVAL_PRECISION		SMALLINT,\n"
"NULL			AS USER_DEFINED_TYPE_CATALOG	VARCHAR(128),\n"
"NULL			AS USER_DEFINED_TYPE_SCHEMA	VARCHAR(128),\n"
"NULL			AS USER_DEFINED_TYPE_NAME	VARCHAR(128),\n"
"NULL			AS SCOPE_CATALOG		VARCHAR(128),\n"
"NULL			AS SCOPE_SCHEMA			VARCHAR(128),\n"
"NULL			AS SCOPE_NAME			VARCHAR(128)\n"
"from DB.DBA.SQL_PROCEDURE_COLUMNS (qual,owner,name,col,casemode,is_odbc3) (\n"
"PROCEDURE_CAT		varchar,\n"
"PROCEDURE_SCHEM		varchar,\n"
"PROCEDURE_NAME		varchar,\n"
"COLUMN_NAME		varchar,\n"
"COLUMN_TYPE		smallint,\n"
"DATA_TYPE		smallint,\n"
"TYPE_NAME		varchar,\n"
"COLUMN_SIZE		integer,\n"
"BUFFER_LENGTH		integer,\n"
"DECIMAL_DIGITS		smallint,\n"
"NUM_PREC_RADIX		smallint,\n"
"NULLABLE		smallint,\n"
"REMARKS			varchar,\n"
"COLUMN_DEF		varchar,\n"
"SQL_DATA_TYPE		smallint,\n"
"SQL_DATETIME_SUB	smallint,\n"
"CHAR_OCTET_LENGTH	integer,\n"
"ORDINAL_POSITION	integer,\n"
"IS_NULLABLE		varchar) X\n"
"where\n"
"qual = NULL\n"
"and owner = NULL\n"
"and name = \'%\'\n"
"and col = \'%\'\n"
"and casemode = cast (sys_stat (\'st_case_mode\') as integer)\n"
"and is_odbc3 = 1\n"
"\n"
"and COLUMN_TYPE in (1,2,4,5)\n";

static const char *other19 = 
"grant select on INFORMATION_SCHEMA.PARAMETERS to public\n";
static const char *view9 = 
"create view INFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS as\n"
"select\n"
"name_part(FK_NAME,0,name_part(FK_TABLE,0))	AS CONSTRAINT_CATALOG 		VARCHAR(128),\n"
"name_part(FK_NAME,1,name_part(FK_TABLE,1))	AS CONSTRAINT_SCHEMA 		VARCHAR(128),\n"
"name_part(FK_NAME,2,name_part(FK_TABLE,2))	AS CONSTRAINT_NAME 		VARCHAR(128),\n"
"name_part(PK_TABLE,0)				AS UNIQUE_CONSTRAINT_CATALOG 	VARCHAR(128),\n"
"name_part(PK_TABLE,1)				AS UNIQUE_CONSTRAINT_SCHEMA 	VARCHAR(128),\n"
"name_part(PK_TABLE,2)				AS UNIQUE_CONSTRAINT_NAME 	VARCHAR(128),\n"
"\'NONE\'						AS MATCH_OPTION			VARCHAR(7),\n"
"case fk.UPDATE_RULE\n"
"when 1 then \'CASCADE\'\n"
"when 2 then \'SET NULL\'\n"
"when 3 then \'SET DEFAULT\'\n"
"else \'NO ACTION\'\n"
"end						AS UPDATE_RULE			VARCHAR(9),\n"
"case fk.DELETE_RULE\n"
"when 1 then \'CASCADE\'\n"
"when 2 then \'SET NULL\'\n"
"when 3 then \'SET DEFAULT\'\n"
"else \'NO ACTION\'\n"
"end						AS DELETE_RULE			VARCHAR(9),\n"
"FK_TABLE					AS V_FK_TABLE			VARCHAR(128)\n"
"\n"
"from DB.DBA.SYS_FOREIGN_KEYS fk\n"
"where\n"
"__any_grants (FK_TABLE)\n"
"and table_type (FK_TABLE) = \'TABLE\'\n"
"group by FK_TABLE, FK_NAME, PK_TABLE, fk.UPDATE_RULE, fk.DELETE_RULE\n";

static const char *other20 = 
"grant select on INFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS to public\n";
static const char *view10 = 
"create view INFORMATION_SCHEMA.TABLE_CONSTRAINTS as\n"
"select\n"
"CONSTRAINT_CATALOG,\n"
"CONSTRAINT_SCHEMA,\n"
"CONSTRAINT_NAME,\n"
"name_part (V_FK_TABLE, 0)			AS TABLE_CATALOG		VARCHAR(128),\n"
"name_part (V_FK_TABLE, 1)			AS TABLE_SCHEMA			VARCHAR(128),\n"
"name_part (V_FK_TABLE, 2)			AS TABLE_NAME			VARCHAR(128),\n"
"\'FOREIGN KEY\'					AS CONSTRAINT_TYPE		VARCHAR(11),\n"
"\'NO\'						AS IS_DEFERRABLE		VARCHAR(2),\n"
"\'NO\'						AS INITIALLY_DEFERRED		VARCHAR(2)\n"
"from INFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS\n"
"union all\n"
"select\n"
"CONSTRAINT_CATALOG,\n"
"CONSTRAINT_SCHEMA,\n"
"CONSTRAINT_NAME,\n"
"name_part (V_C_TABLE, 0),\n"
"name_part (V_C_TABLE, 1),\n"
"name_part (V_C_TABLE, 2),\n"
"\'CHECK\',\n"
"\'NO\',\n"
"\'NO\'\n"
"from INFORMATION_SCHEMA.CHECK_CONSTRAINTS\n"
"union all\n"
"select distinct\n"
"CONSTRAINT_CATALOG,\n"
"CONSTRAINT_SCHEMA,\n"
"CONSTRAINT_NAME,\n"
"TABLE_CATALOG,\n"
"TABLE_SCHEMA,\n"
"TABLE_NAME,\n"
"case V_KEY_IS_MAIN\n"
"when 1 then \'PRIMARY KEY\'\n"
"else \'UNIQUE\'\n"
"end,\n"
"\'NO\',\n"
"\'NO\'\n"
"from INFORMATION_SCHEMA.KEY_COLUMN_USAGE\n"
"where V_KEY_IS_UNIQUE = 1\n";

static const char *other21 = 
"grant select on INFORMATION_SCHEMA.TABLE_CONSTRAINTS to public\n";
static const char *view11 = 
"create view INFORMATION_SCHEMA.TABLE_PRIVILEGES as\n"
"select distinct\n"
"case\n"
"when G_GRANTOR is not null\n"
"then __sec_uid_to_user (cast (G_GRANTOR as integer))\n"
"else  NULL\n"
"end 				AS GRANTOR			VARCHAR(128),\n"
"__sec_uid_to_user (G_USER)	AS GRANTEE			VARCHAR(128),\n"
"TABLE_CATALOG			AS TABLE_CATALOG		VARCHAR(128),\n"
"TABLE_SCHEMA			AS TABLE_SCHEMA			VARCHAR(128),\n"
"TABLE_NAME			AS TABLE_NAME			VARCHAR(128),\n"
"case bit_and (G_OP, 79)\n"
"when 1  then \'SELECT\'\n"
"when 2  then \'UPDATE\'\n"
"when 4  then \'INSERT\'\n"
"when 8  then \'DELETE\'\n"
"when 64 then \'REFERENCES\'\n"
"else NULL\n"
"end				AS PRIVILEGE_TYPE		VARCHAR(10),\n"
"case\n"
"when G_USER = 1\n"
"then \'NO\'\n"
"when bit_and (G_OP, 16) = 1\n"
"then \'YES\'\n"
"else \'NO\'\n"
"end				AS IS_GRANTABLE			VARCHAR (3),\n"
"\n"
"G_USER				AS V_G_USER			INTEGER,\n"
"G_OP				AS V_G_OP			INTEGER,\n"
"G_OBJECT			AS V_G_OBJECT			VARCHAR (386),\n"
"G_GRANTOR			AS V_G_GRANTOR			VARCHAR (128)\n"
"from\n"
"INFORMATION_SCHEMA.TABLES, DB.DBA.SYS_GRANTS g\n"
"where\n"
"V_KEY_TABLE = G_OBJECT\n";

static const char *other22 = 
"grant select on INFORMATION_SCHEMA.TABLE_PRIVILEGES to public\n";
static const char *view12 = 
"create view INFORMATION_SCHEMA.VIEWS as\n"
"select\n"
"name_part(V_NAME,0) 	AS TABLE_CATALOG 	VARCHAR(128),\n"
"name_part(V_NAME,1) 	AS TABLE_SCHEMA 	VARCHAR(128),\n"
"name_part(V_NAME,2) 	AS TABLE_NAME 		VARCHAR(128),\n"
"DB.DBA.object_definition_or_null (V_NAME, coalesce (\n"
"V_TEXT,\n"
"blob_to_string (\n"
"V_EXT)))		AS VIEW_DEFINITION	VARCHAR,\n"
"NULL			AS CHECK_OPTION		VARCHAR(7),\n"
"case\n"
"when (exists (select 1 from DB.DBA.SYS_TRIGGERS where T_TABLE = V_NAME))\n"
"then \'YES\'\n"
"else \'NO\'\n"
"end			AS IS_UPDATABLE		VARCHAR(3)\n"
"from DB.DBA.SYS_VIEWS\n"
"where\n"
"__any_grants (V_NAME)\n";

static const char *other23 = 
"grant select on INFORMATION_SCHEMA.VIEWS to public\n";
static int
sch_proc_def_exists (client_connection_t *cli, const char *proc_name, const int report)
{
  query_t *proc = NULL;
  char *full_name = sch_full_proc_name (isp_schema(NULL), proc_name,
	cli->cli_qualifier, CLI_OWNER (cli));
  if (full_name)
    proc = sch_proc_def (isp_schema(NULL), full_name);
  if (report && proc != NULL)
     log_debug ("built-in procedure \"%s\" overruled by the RDBMS", proc_name);
  return (proc != NULL);
}

#define DEFINE_PROC(name, proc) \
   if (!sch_proc_def_exists (bootstrap_cli, (name), log_proc_overwrite)) \
     ddl_std_proc_1 (proc, 0x0, 1)


#define DEFINE_PUBLIC_PROC(name, proc) \
   if (!sch_proc_def_exists (bootstrap_cli, (name), log_proc_overwrite)) \
     ddl_std_proc_1 (proc, 0x1, 1)


#define DEFINE_OVERWRITE_PROC(name, proc) \
   ddl_std_proc_1 (proc, 0x1, 1)


#define EXEC_AND_LOG_TIME(fname, sno) \
  ddl_exec_init_stmt ("do this always", sno, #fname, #sno); 

void
sqls_define_1 (void)
{
  /* oledb.sql */

  DEFINE_PROC ("oledb_get_types", proc0);
  DEFINE_PROC ("oledb_dbtype", proc1);
  DEFINE_PROC ("oledb_dbflags", proc2);
  DEFINE_PROC ("oledb_char_max_len", proc3);
  DEFINE_PROC ("oledb_char_oct_len", proc4);
  DEFINE_PROC ("oledb_num_prec", proc5);
  DEFINE_PROC ("oledb_num_scale", proc6);
  DEFINE_PROC ("oledb_datetime_prec", proc7);
  DEFINE_PROC ("oledb_procedure_parameters", proc8);
  DEFINE_PROC ("oledb_procedure_definition", proc9);
  EXEC_AND_LOG_TIME(oledb.sql, other0);
  EXEC_AND_LOG_TIME(oledb.sql, other1);
  EXEC_AND_LOG_TIME(oledb.sql, other2);
  EXEC_AND_LOG_TIME(oledb.sql, other3);
  EXEC_AND_LOG_TIME(oledb.sql, other4);
  EXEC_AND_LOG_TIME(oledb.sql, other5);
  EXEC_AND_LOG_TIME(oledb.sql, other6);
  EXEC_AND_LOG_TIME(oledb.sql, other7);
  EXEC_AND_LOG_TIME(oledb.sql, other8);
  EXEC_AND_LOG_TIME(oledb.sql, other9);

  /* information_schema.sql */

  ddl_ensure_table ("INFORMATION_SCHEMA.TABLES", view0);
  EXEC_AND_LOG_TIME(information_schema.sql, other10);
  ddl_ensure_table ("INFORMATION_SCHEMA.COLUMNS", view1);
  EXEC_AND_LOG_TIME(information_schema.sql, other11);
  ddl_ensure_table ("INFORMATION_SCHEMA.SCHEMATA", view2);
  EXEC_AND_LOG_TIME(information_schema.sql, other12);
  ddl_ensure_table ("INFORMATION_SCHEMA.CHECK_CONSTRAINTS", view3);
  EXEC_AND_LOG_TIME(information_schema.sql, other13);
  ddl_ensure_table ("INFORMATION_SCHEMA.COLUMN_DOMAIN_USAGE", view4);
  EXEC_AND_LOG_TIME(information_schema.sql, other14);
  ddl_ensure_table ("INFORMATION_SCHEMA.COLUMN_PRIVILEGES", view5);
  EXEC_AND_LOG_TIME(information_schema.sql, other15); 
  DEFINE_PUBLIC_PROC ("column_privileges", proc10); 
  DEFINE_PUBLIC_PROC ("column_privileges_utf8", proc11);
  ddl_ensure_table ("INFORMATION_SCHEMA.KEY_COLUMN_USAGE", view6);
  EXEC_AND_LOG_TIME(information_schema.sql, other16);
  DEFINE_PROC ("object_definition_or_null", proc12);
  EXEC_AND_LOG_TIME(information_schema.sql, other17);
  ddl_ensure_table ("INFORMATION_SCHEMA.ROUTINES", view7);
  EXEC_AND_LOG_TIME(information_schema.sql, other18);
  ddl_ensure_table ("INFORMATION_SCHEMA.PARAMETERS", view8);
  EXEC_AND_LOG_TIME(information_schema.sql, other19);
  ddl_ensure_table ("INFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS", view9);
  EXEC_AND_LOG_TIME(information_schema.sql, other20);
  ddl_ensure_table ("INFORMATION_SCHEMA.TABLE_CONSTRAINTS", view10);
  EXEC_AND_LOG_TIME(information_schema.sql, other21);
  ddl_ensure_table ("INFORMATION_SCHEMA.TABLE_PRIVILEGES", view11);
  EXEC_AND_LOG_TIME(information_schema.sql, other22);
  ddl_ensure_table ("INFORMATION_SCHEMA.VIEWS", view12);
  EXEC_AND_LOG_TIME(information_schema.sql, other23);
}


void
sqls_arfw_define_1 (void)
{
}
