--
--  $Id: wsdl_suite.sql,v 1.5.10.1 2013/01/02 16:15:39 source Exp $
--
--  This file is part of the OpenLink Software Virtuoso Open-Source (VOS)
--  project.
--
--  Copyright (C) 1998-2023 OpenLink Software
--
--  This project is free software; you can redistribute it and/or modify it
--  under the terms of the GNU General Public License as published by the
--  Free Software Foundation; only version 2 of the License, dated June 1991.
--
--  This program is distributed in the hope that it will be useful, but
--  WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
--  General Public License for more details.
--
--  You should have received a copy of the GNU General Public License along
--  with this program; if not, write to the Free Software Foundation, Inc.,
--  51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
--
--
DROP TABLE WS.WS.WSDL_CACHE;
CREATE TABLE WS.WS.WSDL_CACHE(WC_URI VARCHAR(2048) NOT NULL,WC_XML LONG VARBINARY,PRIMARY KEY(WC_URI));
-- SELECT * FROM WS.WS.WSDL_CACHE
FOREACH HEXADECIMAL BLOB INSERT INTO WS.WS.WSDL_CACHE(WC_URI,WC_XML) VALUES('http://mssoapinterop.org/stkv3/wsdl/InteropTestDocLit.wsdl',?);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END
FOREACH HEXADECIMAL BLOB INSERT INTO WS.WS.WSDL_CACHE(WC_URI,WC_XML) VALUES('http://mssoapinterop.org/stkv3/wsdl/Interoptestrpcenc.wsdl',?);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END
FOREACH HEXADECIMAL BLOB INSERT INTO WS.WS.WSDL_CACHE(WC_URI,WC_XML) VALUES('http://mssoapinterop.org/stkv3/wsdl/compound1.wsdl',?);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END
FOREACH HEXADECIMAL BLOB INSERT INTO WS.WS.WSDL_CACHE(WC_URI,WC_XML) VALUES('http://mssoapinterop.org/stkv3/wsdl/compound2.wsdl',?);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END
FOREACH HEXADECIMAL BLOB INSERT INTO WS.WS.WSDL_CACHE(WC_URI,WC_XML) VALUES('http://mssoapinterop.org/stkv3/wsdl/emptysa.wsdl',?);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FOREACH HEXADECIMAL BLOB INSERT INTO WS.WS.WSDL_CACHE(WC_URI,WC_XML) VALUES('http://mssoapinterop.org/stkv3/wsdl/import1.wsdl',?);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END
FOREACH HEXADECIMAL BLOB INSERT INTO WS.WS.WSDL_CACHE(WC_URI,WC_XML) VALUES('http://mssoapinterop.org/stkv3/wsdl/import2.wsdl',?);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END
FOREACH HEXADECIMAL BLOB INSERT INTO WS.WS.WSDL_CACHE(WC_URI,WC_XML) VALUES('http://mssoapinterop.org/stkv3/wsdl/import3.wsdl',?);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END
FOREACH HEXADECIMAL BLOB INSERT INTO WS.WS.WSDL_CACHE(WC_URI,WC_XML) VALUES('http://mssoapinterop.org/stkv3/wsdl/imported/import1B.wsdl',?);
3C6E303A646566696E6974696F6E7320786D6C6E733A6E303D22687474703A2F
2F736368656D61732E786D6C736F61702E6F72672F7773646C2F2220206E616D
653D22536F6170496E7465726F7022207461726765744E616D6573706163653D
22687474703A2F2F736F6170696E7465726F702E6F72672F646566696E697469
6F6E732F223E0A093C6E303A7479706573202F3E0A093C6E303A6D6573736167
65206E616D653D226563686F537472696E6752657175657374223E0A09093C6E
303A70617274206E616D653D22782220747970653D22687474703A2F2F777777
2E77332E6F72672F323030312F584D4C536368656D613A737472696E6722202F
3E0A093C2F6E303A6D6573736167653E0A093C6E303A6D657373616765206E61
6D653D226563686F537472696E67526573706F6E7365223E0A09093C6E303A70
617274206E616D653D22526573756C742220747970653D22687474703A2F2F77
77772E77332E6F72672F323030312F584D4C536368656D613A737472696E6722
202F3E0A093C2F6E303A6D6573736167653E0A093C6E303A706F727454797065
206E616D653D22536F6170496E7465726F70496D706F727431506F7274547970
65223E0A09093C6E303A6F7065726174696F6E206E616D653D226563686F5374
72696E672220706172616D657465724F726465723D2278223E0A0909093C6E30
3A696E707574206D6573736167653D227773646C6E733A6563686F537472696E
675265717565737422202F3E0A0909093C6E303A6F7574707574206D65737361
67653D227773646C6E733A6563686F537472696E67526573706F6E736522202F
3E0A09093C2F6E303A6F7065726174696F6E3E0A093C2F6E303A706F72745479
70653E090A3C2F6E303A646566696E6974696F6E733E
END
FOREACH HEXADECIMAL BLOB INSERT INTO WS.WS.WSDL_CACHE(WC_URI,WC_XML) VALUES('http://mssoapinterop.org/stkv3/wsdl/imported/import2B.wsdl',?);
3C6E303A646566696E6974696F6E7320786D6C6E733A6E303D22687474703A2F
2F736368656D61732E786D6C736F61702E6F72672F7773646C2F2220206E616D
653D22536F6170496E7465726F7022207461726765744E616D6573706163653D
22687474703A2F2F736F6170696E7465726F702E6F72672F646566696E697469
6F6E732F223E0A093C6E303A696D706F7274206C6F636174696F6E3D22696D70
6F727432422E78736422206E616D6573706163653D22687474703A2F2F736F61
70696E7465726F702E6F72672F78736422202F3E0A093C6E303A6D6573736167
65206E616D653D225365727665722E6563686F537472756374223E0A20202020
09093C6E303A70617274206E616D653D22696E70757453747275637422207479
70653D22687474703A2F2F736F6170696E7465726F702E6F72672F7873643A53
4F415053747275637422202F3E0A2020093C2F6E303A6D6573736167653E0A20
20093C6E303A6D657373616765206E616D653D225365727665722E6563686F53
7472756374526573706F6E7365223E0A2020202009093C6E303A70617274206E
616D653D22526573756C742220747970653D22687474703A2F2F736F6170696E
7465726F702E6F72672F7873643A534F415053747275637422202F3E0A202009
3C2F6E303A6D6573736167653E0A0A093C6E303A706F727454797065206E616D
653D22536F6170496E7465726F70496D706F727432506F727454797065223E0A
09093C6E303A6F7065726174696F6E206E616D653D226563686F537472756374
2220706172616D657465724F726465723D22696E707574537472756374223E0A
2020202009090920203C6E303A696E707574206D6573736167653D227773646C
6E733A5365727665722E6563686F53747275637422202F3E0A20202020202009
090920203C6E303A6F7574707574206D6573736167653D227773646C6E733A53
65727665722E6563686F537472756374526573706F6E736522202F3E0A09093C
2F6E303A6F7065726174696F6E3E0A093C2F6E303A706F7274547970653E090A
3C2F6E303A646566696E6974696F6E733E
END
FOREACH HEXADECIMAL BLOB INSERT INTO WS.WS.WSDL_CACHE(WC_URI,WC_XML) VALUES('http://mssoapinterop.org/stkv3/wsdl/imported/import2B.xsd',?);
3C6E303A736368656D6120786D6C6E733A6E303D22687474703A2F2F7777772E
77332E6F72672F323030312F584D4C536368656D612220207461726765744E61
6D6573706163653D22687474703A2F2F736F6170696E7465726F702E6F72672F
7873642220656C656D656E74466F726D44656661756C743D22756E7175616C69
66696564223E0A2020202020203C6E303A636F6D706C657854797065206E616D
653D22534F4150537472756374223E0A20202020202020203C6E303A616C6C3E
0A202020202020202020203C6E303A656C656D656E74206E616D653D22766172
537472696E672220747970653D22737472696E6722202F3E0A20202020202020
2020203C6E303A656C656D656E74206E616D653D22766172496E742220747970
653D22696E7422202F3E200A202020202020202020203C6E303A656C656D656E
74206E616D653D22766172466C6F61742220747970653D22666C6F617422202F
3E200A20202020202020203C2F6E303A616C6C3E0A2020202020203C2F6E303A
636F6D706C6578547970653E0A3C2F6E303A736368656D613E
END
FOREACH HEXADECIMAL BLOB INSERT INTO WS.WS.WSDL_CACHE(WC_URI,WC_XML) VALUES('http://www.whitemesa.com/r3/EmptySA.wsdl',?);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FOREACH HEXADECIMAL BLOB INSERT INTO WS.WS.WSDL_CACHE(WC_URI,WC_XML) VALUES('http://www.whitemesa.com/r3/InteropTestDocLit.wsdl',?);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END
FOREACH HEXADECIMAL BLOB INSERT INTO WS.WS.WSDL_CACHE(WC_URI,WC_XML) VALUES('http://www.whitemesa.com/r3/Interoptestrpcenc.wsdl',?);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END
FOREACH HEXADECIMAL BLOB INSERT INTO WS.WS.WSDL_CACHE(WC_URI,WC_XML) VALUES('http://www.whitemesa.com/r3/compound1.wsdl',?);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END
FOREACH HEXADECIMAL BLOB INSERT INTO WS.WS.WSDL_CACHE(WC_URI,WC_XML) VALUES('http://www.whitemesa.com/r3/compound2.wsdl',?);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END
FOREACH HEXADECIMAL BLOB INSERT INTO WS.WS.WSDL_CACHE(WC_URI,WC_XML) VALUES('http://www.whitemesa.com/r3/import1.wsdl',?);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END
FOREACH HEXADECIMAL BLOB INSERT INTO WS.WS.WSDL_CACHE(WC_URI,WC_XML) VALUES('http://www.whitemesa.com/r3/import2.wsdl',?);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END
FOREACH HEXADECIMAL BLOB INSERT INTO WS.WS.WSDL_CACHE(WC_URI,WC_XML) VALUES('http://www.whitemesa.com/r3/import3.wsdl',?);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END
FOREACH HEXADECIMAL BLOB INSERT INTO WS.WS.WSDL_CACHE(WC_URI,WC_XML) VALUES('http://www.whitemesa.com/r3/imported/import1B.wsdl',?);
3C6E303A646566696E6974696F6E7320786D6C6E733A6E303D22687474703A2F
2F736368656D61732E786D6C736F61702E6F72672F7773646C2F2220206E616D
653D22536F6170496E7465726F7022207461726765744E616D6573706163653D
22687474703A2F2F736F6170696E7465726F702E6F72672F646566696E697469
6F6E732F223E0A093C6E303A7479706573202F3E0A093C6E303A6D6573736167
65206E616D653D226563686F537472696E6752657175657374223E0A09093C6E
303A70617274206E616D653D22782220747970653D22687474703A2F2F777777
2E77332E6F72672F323030312F584D4C536368656D613A737472696E6722202F
3E0A093C2F6E303A6D6573736167653E0A093C6E303A6D657373616765206E61
6D653D226563686F537472696E67526573706F6E7365223E0A09093C6E303A70
617274206E616D653D22526573756C742220747970653D22687474703A2F2F77
77772E77332E6F72672F323030312F584D4C536368656D613A737472696E6722
202F3E0A093C2F6E303A6D6573736167653E0A093C6E303A706F727454797065
206E616D653D22536F6170496E7465726F70496D706F727431506F7274547970
65223E0A09093C6E303A6F7065726174696F6E206E616D653D226563686F5374
72696E672220706172616D657465724F726465723D2278223E0A0909093C6E30
3A696E707574206D6573736167653D227773646C6E733A6563686F537472696E
675265717565737422202F3E0A0909093C6E303A6F7574707574206D65737361
67653D227773646C6E733A6563686F537472696E67526573706F6E736522202F
3E0A09093C2F6E303A6F7065726174696F6E3E0A093C2F6E303A706F72745479
70653E090A3C2F6E303A646566696E6974696F6E733E
END
FOREACH HEXADECIMAL BLOB INSERT INTO WS.WS.WSDL_CACHE(WC_URI,WC_XML) VALUES('http://www.whitemesa.com/r3/imported/import2B.wsdl',?);
3C6E303A646566696E6974696F6E7320786D6C6E733A6E303D22687474703A2F
2F736368656D61732E786D6C736F61702E6F72672F7773646C2F2220206E616D
653D22536F6170496E7465726F7022207461726765744E616D6573706163653D
22687474703A2F2F736F6170696E7465726F702E6F72672F646566696E697469
6F6E732F223E0A093C6E303A696D706F7274206C6F636174696F6E3D22696D70
6F727432422E78736422206E616D6573706163653D22687474703A2F2F736F61
70696E7465726F702E6F72672F78736422202F3E0A093C6E303A6D6573736167
65206E616D653D225365727665722E6563686F537472756374223E0A20202020
09093C6E303A70617274206E616D653D22696E70757453747275637422207479
70653D22687474703A2F2F736F6170696E7465726F702E6F72672F7873643A53
4F415053747275637422202F3E0A2020093C2F6E303A6D6573736167653E0A20
20093C6E303A6D657373616765206E616D653D225365727665722E6563686F53
7472756374526573706F6E7365223E0A2020202009093C6E303A70617274206E
616D653D22526573756C742220747970653D22687474703A2F2F736F6170696E
7465726F702E6F72672F7873643A534F415053747275637422202F3E0A202009
3C2F6E303A6D6573736167653E0A0A093C6E303A706F727454797065206E616D
653D22536F6170496E7465726F70496D706F727432506F727454797065223E0A
09093C6E303A6F7065726174696F6E206E616D653D226563686F537472756374
2220706172616D657465724F726465723D22696E707574537472756374223E0A
2020202009090920203C6E303A696E707574206D6573736167653D227773646C
6E733A5365727665722E6563686F53747275637422202F3E0A20202020202009
090920203C6E303A6F7574707574206D6573736167653D227773646C6E733A53
65727665722E6563686F537472756374526573706F6E736522202F3E0A09093C
2F6E303A6F7065726174696F6E3E0A093C2F6E303A706F7274547970653E090A
3C2F6E303A646566696E6974696F6E733E
END
FOREACH HEXADECIMAL BLOB INSERT INTO WS.WS.WSDL_CACHE(WC_URI,WC_XML) VALUES('http://www.whitemesa.com/r3/imported/import2B.xsd',?);
3C6E303A736368656D6120786D6C6E733A6E303D22687474703A2F2F7777772E
77332E6F72672F323030312F584D4C536368656D612220207461726765744E61
6D6573706163653D22687474703A2F2F736F6170696E7465726F702E6F72672F
7873642220656C656D656E74466F726D44656661756C743D22756E7175616C69
66696564223E0A2020202020203C6E303A636F6D706C657854797065206E616D
653D22534F4150537472756374223E0A20202020202020203C6E303A616C6C3E
0A202020202020202020203C6E303A656C656D656E74206E616D653D22766172
537472696E672220747970653D22737472696E6722202F3E0A20202020202020
2020203C6E303A656C656D656E74206E616D653D22766172496E742220747970
653D22696E7422202F3E200A202020202020202020203C6E303A656C656D656E
74206E616D653D22766172466C6F61742220747970653D22666C6F617422202F
3E200A20202020202020203C2F6E303A616C6C3E0A2020202020203C2F6E303A
636F6D706C6578547970653E0A3C2F6E303A736368656D613E
END
FOREACH HEXADECIMAL BLOB INSERT INTO WS.WS.WSDL_CACHE(WC_URI,WC_XML) VALUES('http://mssoapinterop.org/stkv3/wsdl/Interoptestdoclitparameters.wsdl',?);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END

select count(*) from "WS"."WS"."WSDL_CACHE";
ECHO BOTH $IF $EQU $LAST[1] 23 "PASSED" "***FAILED";
SET ARGV[$LIF] $+ $ARGV[$LIF] 1;
ECHO BOTH ": " $LAST[1] " WSDL_CACHE loaded\n";


create procedure WSDL_GET (in uri varchar, in _mode integer)
{
  declare _hdr, _in, _ret any;

  _mode := 1;

  if (exists (select 1 from  WS.WS.WSDL_CACHE where WC_URI = uri))
    {
       if (_mode)
	 {
            select WC_XML into _ret from WS.WS.WSDL_CACHE where WC_URI = uri;
            dbg_obj_print ('CACHED !!!', blob_to_string (_ret));
            return xml_tree_doc (blob_to_string (_ret));
	 }
       else
 	{
	   _ret := http_get (uri, _hdr);
	   _ret := xml_tree_doc (_ret);
--         dbg_obj_print ('UPDATED !!!');
	   update WS.WS.WSDL_CACHE set WC_XML = _ret where WC_URI = uri;
	   return NULL;
	   return _ret;
	}
    }
  else
    {
       _ret := http_get (uri, _hdr);
       _ret := xml_tree_doc (_ret);

       insert into WS.WS.WSDL_CACHE values (uri, _ret);
       dbg_obj_print ('ADD !!! ', uri);
--     return NULL;
       return _ret;
    }

  return NULL;
}
;

ECHO BOTH $IF $EQU $STATE OK  "PASSED" "***FAILED";
SET ARGV[$LIF] $+ $ARGV[$LIF] 1;
ECHO BOTH ": CREATE CACHE PROCEDURE : STATE=" $STATE " MESSAGE=" $MESSAGE "\n";

drop module EmptySA;
drop module Import1;
drop module Import2;
drop module Import3;
drop module Compound1;
drop module Compound2;
drop module WSDLInteropTestDocLitService;
drop module WSDLInteropTestRpcEncService;

select length (DB.DBA.SOAP_WSDL_IMPORT ('http://www.whitemesa.com/r3/EmptySA.wsdl', 0)) ;
ECHO BOTH $IF $EQU $LAST[1] 3 "PASSED" "***FAILED";
SET ARGV[$LIF] $+ $ARGV[$LIF] 1;
ECHO BOTH ": " $LAST[1] " Create client from http://www.whitemesa.com/r3/EmptySA.wsdl \n";

select length (DB.DBA.SOAP_WSDL_IMPORT ('http://www.whitemesa.com/r3/import1.wsdl', 0)) ;
ECHO BOTH $IF $EQU $LAST[1] 3 "PASSED" "***FAILED";
SET ARGV[$LIF] $+ $ARGV[$LIF] 1;
ECHO BOTH ": " $LAST[1] " Create client from http://www.whitemesa.com/r3/import1.wsdl \n";

select length (DB.DBA.SOAP_WSDL_IMPORT ('http://www.whitemesa.com/r3/import2.wsdl', 0)) ;
ECHO BOTH $IF $EQU $LAST[1] 3 "PASSED" "***FAILED";
SET ARGV[$LIF] $+ $ARGV[$LIF] 1;
ECHO BOTH ": " $LAST[1] " Create client from http://www.whitemesa.com/r3/import2.wsdl \n";

select length (DB.DBA.SOAP_WSDL_IMPORT ('http://www.whitemesa.com/r3/import3.wsdl', 0)) ;
ECHO BOTH $IF $EQU $LAST[1] 5 "PASSED" "***FAILED";
SET ARGV[$LIF] $+ $ARGV[$LIF] 1;
ECHO BOTH ": " $LAST[1] " Create client from http://www.whitemesa.com/r3/import3.wsdl \n";

select length (DB.DBA.SOAP_WSDL_IMPORT ('http://www.whitemesa.com/r3/compound1.wsdl', 0)) ;
ECHO BOTH $IF $EQU $LAST[1] 5 "PASSED" "***FAILED";
SET ARGV[$LIF] $+ $ARGV[$LIF] 1;
ECHO BOTH ": " $LAST[1] " Create client from http://www.whitemesa.com/r3/compound1.wsdl \n";

select length (DB.DBA.SOAP_WSDL_IMPORT ('http://www.whitemesa.com/r3/compound2.wsdl', 0)) ;
ECHO BOTH $IF $EQU $LAST[1] 3 "PASSED" "***FAILED";
SET ARGV[$LIF] $+ $ARGV[$LIF] 1;
ECHO BOTH ": " $LAST[1] " Create client from http://www.whitemesa.com/r3/compound2.wsdl \n";

select length (DB.DBA.SOAP_WSDL_IMPORT ('http://www.whitemesa.com/r3/InteropTestDocLit.wsdl', 0)) ;
ECHO BOTH $IF $EQU $LAST[1] 9 "PASSED" "***FAILED";
SET ARGV[$LIF] $+ $ARGV[$LIF] 1;
ECHO BOTH ": " $LAST[1] " Create client http://www.whitemesa.com/r3/InteropTestDocLit.wsdl \n";

select length (DB.DBA.SOAP_WSDL_IMPORT ('http://www.whitemesa.com/r3/Interoptestrpcenc.wsdl', 0)) ;
ECHO BOTH $IF $EQU $LAST[1] 9 "PASSED" "***FAILED";
SET ARGV[$LIF] $+ $ARGV[$LIF] 1;
ECHO BOTH ": " $LAST[1] " Create client from http://www.whitemesa.com/r3/Interoptestrpcenc.wsdl \n";


drop module EmptySA;
ECHO BOTH $IF $EQU $STATE OK  "PASSED" "***FAILED";
SET ARGV[$LIF] $+ $ARGV[$LIF] 1;
ECHO BOTH ": DROP MODULE WSDL.IMPORT.EmptySA : STATE=" $STATE " MESSAGE=" $MESSAGE "\n";

drop module Import1;
ECHO BOTH $IF $EQU $STATE OK  "PASSED" "***FAILED";
SET ARGV[$LIF] $+ $ARGV[$LIF] 1;
ECHO BOTH ": DROP MODULE WSDL.IMPORT.Import1 : STATE=" $STATE " MESSAGE=" $MESSAGE "\n";

drop module Import2;
ECHO BOTH $IF $EQU $STATE OK  "PASSED" "***FAILED";
SET ARGV[$LIF] $+ $ARGV[$LIF] 1;
ECHO BOTH ": DROP MODULE WSDL.IMPORT.Import2 : STATE=" $STATE " MESSAGE=" $MESSAGE "\n";

drop module Import3;
ECHO BOTH $IF $EQU $STATE OK  "PASSED" "***FAILED";
SET ARGV[$LIF] $+ $ARGV[$LIF] 1;
ECHO BOTH ": DROP MODULE WSDL.IMPORT.Import3 : STATE=" $STATE " MESSAGE=" $MESSAGE "\n";

drop module Compound1;
ECHO BOTH $IF $EQU $STATE OK  "PASSED" "***FAILED";
SET ARGV[$LIF] $+ $ARGV[$LIF] 1;
ECHO BOTH ": DROP MODULE WSDL.IMPORT.Compound1 : STATE=" $STATE " MESSAGE=" $MESSAGE "\n";

drop module Compound2;
ECHO BOTH $IF $EQU $STATE OK  "PASSED" "***FAILED";
SET ARGV[$LIF] $+ $ARGV[$LIF] 1;
ECHO BOTH ": DROP MODULE WSDL.IMPORT.Compound2 : STATE=" $STATE " MESSAGE=" $MESSAGE "\n";

drop module WSDLInteropTestDocLitService;
ECHO BOTH $IF $EQU $STATE OK  "PASSED" "***FAILED";
SET ARGV[$LIF] $+ $ARGV[$LIF] 1;
ECHO BOTH ": DROP MODULE WSDL.IMPORT.WSDLInteropTestDocLitService : STATE=" $STATE " MESSAGE=" $MESSAGE "\n";

drop module WSDLInteropTestRpcEncService;
ECHO BOTH $IF $EQU $STATE OK  "PASSED" "***FAILED";
SET ARGV[$LIF] $+ $ARGV[$LIF] 1;
ECHO BOTH ": DROP MODULE WSDL.IMPORT.WSDLInteropTestRpcEncService : STATE=" $STATE " MESSAGE=" $MESSAGE "\n";


select length (DB.DBA.SOAP_WSDL_IMPORT ('http://mssoapinterop.org/stkv3/wsdl/emptysa.wsdl', 1));
ECHO BOTH $IF $EQU $LAST[1] 3 "PASSED" "***FAILED";
SET ARGV[$LIF] $+ $ARGV[$LIF] 1;
ECHO BOTH ": " $LAST[1] " Create server from http://mssoapinterop.org/stkv3/wsdl/emptysa.wsdl \n";

select length (DB.DBA.SOAP_WSDL_IMPORT ('http://mssoapinterop.org/stkv3/wsdl/import1.wsdl', 1));
ECHO BOTH $IF $EQU $LAST[1] 3 "PASSED" "***FAILED";
SET ARGV[$LIF] $+ $ARGV[$LIF] 1;
ECHO BOTH ": " $LAST[1] " Create server from http://mssoapinterop.org/stkv3/wsdl/import1.wsdl \n";

select length (DB.DBA.SOAP_WSDL_IMPORT ('http://mssoapinterop.org/stkv3/wsdl/import2.wsdl', 1));
ECHO BOTH $IF $EQU $LAST[1] 3 "PASSED" "***FAILED";
SET ARGV[$LIF] $+ $ARGV[$LIF] 1;
ECHO BOTH ": " $LAST[1] " http://mssoapinterop.org/stkv3/wsdl/import2.wsdl \n";

select length (DB.DBA.SOAP_WSDL_IMPORT ('http://mssoapinterop.org/stkv3/wsdl/import3.wsdl', 1));
ECHO BOTH $IF $EQU $LAST[1] 5 "PASSED" "***FAILED";
SET ARGV[$LIF] $+ $ARGV[$LIF] 1;
ECHO BOTH ": " $LAST[1] " Create server from http://mssoapinterop.org/stkv3/wsdl/import3.wsdl \n";

select length (DB.DBA.SOAP_WSDL_IMPORT ('http://mssoapinterop.org/stkv3/wsdl/compound1.wsdl', 1));
ECHO BOTH $IF $EQU $LAST[1] 5 "PASSED" "***FAILED";
SET ARGV[$LIF] $+ $ARGV[$LIF] 1;
ECHO BOTH ": " $LAST[1] " Create server from http://mssoapinterop.org/stkv3/wsdl/compound1.wsdl \n";

select length (DB.DBA.SOAP_WSDL_IMPORT ('http://mssoapinterop.org/stkv3/wsdl/compound2.wsdl', 1));
ECHO BOTH $IF $EQU $LAST[1] 3 "PASSED" "***FAILED";
SET ARGV[$LIF] $+ $ARGV[$LIF] 1;
ECHO BOTH ": " $LAST[1] " Create server from http://mssoapinterop.org/stkv3/wsdl/compound2.wsdl \n";

--select dbg_obj_print (DB.DBA.SOAP_WSDL_IMPORT ('http://mssoapinterop.org/stkv3/wsdl/InteropTestDocLit.wsdl', 1));
--drop module DB.DBA.WSDLInteropTestDocLitService;
--select dbg_obj_print (DB.DBA.SOAP_WSDL_IMPORT ('http://mssoapinterop.org/stkv3/wsdl/Interoptestdoclitparameters.wsdl', 1));
select dbg_obj_print (DB.DBA.SOAP_WSDL_IMPORT ('http://mssoapinterop.org/stkv3/wsdl/Interoptestrpcenc.wsdl', 1));
ECHO BOTH $IF $EQU $LAST[1] 0 "PASSED" "***FAILED";
SET ARGV[$LIF] $+ $ARGV[$LIF] 1;
ECHO BOTH ": " $LAST[1] " Create server from http://mssoapinterop.org/stkv3/wsdl/Interoptestrpcenc.wsdl \n";


drop module EmptySA;
ECHO BOTH $IF $EQU $STATE OK  "PASSED" "***FAILED";
SET ARGV[$LIF] $+ $ARGV[$LIF] 1;
ECHO BOTH ": DROP MODULE WSDL.IMPORT.EmptySA : STATE=" $STATE " MESSAGE=" $MESSAGE "\n";

drop module Import1;
ECHO BOTH $IF $EQU $STATE OK  "PASSED" "***FAILED";
SET ARGV[$LIF] $+ $ARGV[$LIF] 1;
ECHO BOTH ": DROP MODULE WSDL.IMPORT.Import1 : STATE=" $STATE " MESSAGE=" $MESSAGE "\n";

drop module Import2;
ECHO BOTH $IF $EQU $STATE OK  "PASSED" "***FAILED";
SET ARGV[$LIF] $+ $ARGV[$LIF] 1;
ECHO BOTH ": DROP MODULE WSDL.IMPORT.Import2 : STATE=" $STATE " MESSAGE=" $MESSAGE "\n";

drop module Import3;
ECHO BOTH $IF $EQU $STATE OK  "PASSED" "***FAILED";
SET ARGV[$LIF] $+ $ARGV[$LIF] 1;
ECHO BOTH ": DROP MODULE WSDL.IMPORT.Import3 : STATE=" $STATE " MESSAGE=" $MESSAGE "\n";

drop module Compound1;
ECHO BOTH $IF $EQU $STATE OK  "PASSED" "***FAILED";
SET ARGV[$LIF] $+ $ARGV[$LIF] 1;
ECHO BOTH ": DROP MODULE WSDL.IMPORT.Compound1 : STATE=" $STATE " MESSAGE=" $MESSAGE "\n";

drop module Compound2;
ECHO BOTH $IF $EQU $STATE OK  "PASSED" "***FAILED";
SET ARGV[$LIF] $+ $ARGV[$LIF] 1;
ECHO BOTH ": DROP MODULE WSDL.IMPORT.Compound2 : STATE=" $STATE " MESSAGE=" $MESSAGE "\n";

--drop module WSDLInteropTestDocLitService;
--ECHO BOTH $IF $EQU $STATE OK  "PASSED" "***FAILED";
--SET ARGV[$LIF] $+ $ARGV[$LIF] 1;
--ECHO BOTH ": DROP MODULE WSDL.IMPORT.WSDLInteropTestDocLitService : STATE=" $STATE " MESSAGE=" $MESSAGE "\n";

drop module WSDLInteropTestRpcEncService;
ECHO BOTH $IF $EQU $STATE OK  "PASSED" "***FAILED";
SET ARGV[$LIF] $+ $ARGV[$LIF] 1;
ECHO BOTH ": DROP MODULE WSDL.IMPORT.WSDLInteropTestRpcEncService : STATE=" $STATE " MESSAGE=" $MESSAGE "\n";


select aref (DB.DBA.SOAP_WSDL_IMPORT ('http://mssoapinterop.org/stkv3/wsdl/emptysa.wsdl', 1), 0);
ECHO BOTH $IF $EQU $LAST[1] 'EmptySA' "PASSED" "***FAILED";
SET ARGV[$LIF] $+ $ARGV[$LIF] 1;
ECHO BOTH ": " $LAST[1] " Test return EmptySA \n";

drop module EmptySA;
select aref (DB.DBA.SOAP_WSDL_IMPORT ('http://mssoapinterop.org/stkv3/wsdl/emptysa.wsdl', 1), 1);
ECHO BOTH $IF $EQU $LAST[1] 'echoString' "PASSED" "***FAILED";
SET ARGV[$LIF] $+ $ARGV[$LIF] 1;
ECHO BOTH ": " $LAST[1] " Test return EmptySA type \n";

drop module EmptySA;
select aref (aref (DB.DBA.SOAP_WSDL_IMPORT ('http://mssoapinterop.org/stkv3/wsdl/emptysa.wsdl', 1), 2), 0);
ECHO BOTH $IF $EQU $LAST[1] '_a' "PASSED" "***FAILED";
SET ARGV[$LIF] $+ $ARGV[$LIF] 1;
ECHO BOTH ": " $LAST[1] " Test return EmptySA parameter \n";

drop module EmptySA;
select aref (aref (DB.DBA.SOAP_WSDL_IMPORT ('http://mssoapinterop.org/stkv3/wsdl/emptysa.wsdl', 1), 2), 1);
ECHO BOTH $IF $EQU $LAST[1] 'http://www.w3.org/2001/XMLSchema:string' "PASSED" "***FAILED";
SET ARGV[$LIF] $+ $ARGV[$LIF] 1;
ECHO BOTH ": " $LAST[1] " Test return EmptySA parameter type \n";
drop module EmptySA;

--
--  VIRTUOSO
--

   drop module DB_DBA_EmptySA;
   drop module DB_DBA_Import1;
   drop module DB_DBA_Import2;
   drop module DB_DBA_Import3;
   drop module DB_DBA_Compound1;
 --drop module DB_DBA_Compound2;
   drop module DB_DBA_WSDLInteropTestDocLitService;
   drop module DB_DBA_WSDLInteropTestRpcEncService;

--load '~/binsrc/vsp/r3.sql';
r3_upload ('../r3');

--select length (DB.DBA.SOAP_WSDL_IMPORT ('http://localhost:$U{HTTPPORT}/r3/emptysa.wsdl.vsp', 1));
--ECHO BOTH $IF $EQU $LAST[1] 3 "PASSED" "***FAILED";
--SET ARGV[$LIF] $+ $ARGV[$LIF] 1;
--ECHO BOTH ": " $LAST[1] " Create server from http://localhost/r3/emptysa.wsdl.vsp \n";

--select length (DB.DBA.SOAP_WSDL_IMPORT ('http://localhost:$U{HTTPPORT}/r3/import1-b.wsdl.vsp', 1));
--ECHO BOTH $IF $EQU $LAST[1] 9 "PASSED" "***FAILED";
--SET ARGV[$LIF] $+ $ARGV[$LIF] 1;
--ECHO BOTH ": " $LAST[1] " Create server from http://localhost/r3/import1-b.wsdl.vsp \n";

--select length (DB.DBA.SOAP_WSDL_IMPORT ('http://localhost:$U{HTTPPORT}/r3/import2-b.wsdl.vsp', 1));
--ECHO BOTH $IF $EQU $LAST[1] 9 "PASSED" "***FAILED";
--SET ARGV[$LIF] $+ $ARGV[$LIF] 1;
--ECHO BOTH ": " $LAST[1] " Create server from http://localhost/r3/import2-b.wsdl.vsp \n";

--select length (DB.DBA.SOAP_WSDL_IMPORT ('http://localhost:$U{HTTPPORT}/r3/import3-b.wsdl.vsp', 1));
--ECHO BOTH $IF $EQU $LAST[1] 9 "PASSED" "***FAILED";
--SET ARGV[$LIF] $+ $ARGV[$LIF] 1;
--ECHO BOTH ": " $LAST[1] " Create server from http://localhost/r3/import3-b.wsdl.vsp \n";

--select length (DB.DBA.SOAP_WSDL_IMPORT ('http://localhost:$U{HTTPPORT}/r3/compound1.wsdl.vsp', 1));
--ECHO BOTH $IF $EQU $LAST[1] 5 "PASSED" "***FAILED";
--SET ARGV[$LIF] $+ $ARGV[$LIF] 1;
--ECHO BOTH ": " $LAST[1] " Create server from http://localhost/r3/compound1.wsdl.vsp \n";

--select dbg_obj_print (DB.DBA.SOAP_WSDL_IMPORT ('http://localhost:6666/r3/compound2.wsdl.vsp', 1));

--select length (DB.DBA.SOAP_WSDL_IMPORT ('http://localhost:6666/r3/interoptestdoclit.wsdl.vsp', 1));
--ECHO BOTH $IF $EQU $LAST[1] 9 "PASSED" "***FAILED";
--SET ARGV[$LIF] $+ $ARGV[$LIF] 1;
--ECHO BOTH ": " $LAST[1] " Create server from http://localhost/r3/interoptestdoclit.wsdl.vsp \n";


--drop module VirtuosoDB_DBA_EmptySA;
--ECHO BOTH $IF $EQU $STATE OK  "PASSED" "***FAILED";
--SET ARGV[$LIF] $+ $ARGV[$LIF] 1;
--ECHO BOTH ": DROP MODULE WSDL.IMPORT.VirtuosoDB_DBA_EmptySA : STATE=" $STATE " MESSAGE=" $MESSAGE "\n";

--drop module VirtuosoDB_DBA_Import1;
--ECHO BOTH $IF $EQU $STATE OK  "PASSED" "***FAILED";
--SET ARGV[$LIF] $+ $ARGV[$LIF] 1;
--ECHO BOTH ": DROP MODULE WSDL.IMPORT.VirtuosoDB_DBA_Import1 : STATE=" $STATE " MESSAGE=" $MESSAGE "\n";

--drop module VirtuosoDB_DBA_Import2;
--ECHO BOTH $IF $EQU $STATE OK  "PASSED" "***FAILED";
--SET ARGV[$LIF] $+ $ARGV[$LIF] 1;
--ECHO BOTH ": DROP MODULE WSDL.IMPORT.VirtuosoDB_DBA_Import2 : STATE=" $STATE " MESSAGE=" $MESSAGE "\n";

--drop module VirtuosoDB_DBA_Import3;
--ECHO BOTH $IF $EQU $STATE OK  "PASSED" "***FAILED";
--SET ARGV[$LIF] $+ $ARGV[$LIF] 1;
--ECHO BOTH ": DROP MODULE WSDL.IMPORT.VirtuosoDB_DBA_Import3 : STATE=" $STATE " MESSAGE=" $MESSAGE "\n";

--drop module VirtuosoDB_DBA_Compound1;
--ECHO BOTH $IF $EQU $STATE OK  "PASSED" "***FAILED";
--SET ARGV[$LIF] $+ $ARGV[$LIF] 1;
--ECHO BOTH ": DROP MODULE WSDL.IMPORT.VirtuosoDB_DBA_Compound1 : STATE=" $STATE " MESSAGE=" $MESSAGE "\n";

 --drop module VirtuosoDB_DBA_Compound2;
--drop module VirtuosoDB_DBA_WSDLInteropTestDocLitService;
--ECHO BOTH $IF $EQU $STATE OK  "PASSED" "***FAILED";
--SET ARGV[$LIF] $+ $ARGV[$LIF] 1;
--ECHO BOTH ": DROP MODULE WSDL.IMPORT.VirtuosoDB_DBA_WSDLInteropTestDocLitService : STATE=" $STATE " MESSAGE=" $MESSAGE "\n";

--drop module VirtuosoDB_DBA_WSDLInteropTestRpcEncService;
--ECHO BOTH $IF $EQU $STATE OK  "PASSED" "***FAILED";
--SET ARGV[$LIF] $+ $ARGV[$LIF] 1;
--ECHO BOTH ": DROP MODULE WSDL.IMPORT.VirtuosoDB_DBA_WSDLInteropTestRpcEncService : STATE=" $STATE " MESSAGE=" $MESSAGE "\n";

