/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.rdf4j.driver.config;

import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.config.RepositoryConfigException;
import org.eclipse.rdf4j.repository.config.RepositoryFactory;
import org.eclipse.rdf4j.repository.config.RepositoryImplConfig;
import virtuoso.rdf4j.driver.VirtuosoRepository;
import virtuoso.rdf4j.driver.config.VirtuosoRepositoryConfig;

public class VirtuosoRepositoryFactory
implements RepositoryFactory {
    public static final String REPOSITORY_TYPE = "openrdf:VirtuosoRepository";

    public String getRepositoryType() {
        return REPOSITORY_TYPE;
    }

    public RepositoryImplConfig getConfig() {
        return new VirtuosoRepositoryConfig();
    }

    public Repository getRepository(RepositoryImplConfig config) throws RepositoryConfigException {
        VirtuosoRepository result = null;
        if (!(config instanceof VirtuosoRepositoryConfig)) {
            throw new RepositoryConfigException("Invalid configuration class: " + config.getClass());
        }
        VirtuosoRepositoryConfig vConfig = (VirtuosoRepositoryConfig)config;
        result = new VirtuosoRepository(vConfig.getHostList(), vConfig.getUsername(), vConfig.getPassword(), vConfig.getDefGraph(), vConfig.getUseLazyAdd());
        result.setFetchSize(vConfig.getFetchSize());
        result.setRoundrobin(vConfig.getRoundRobin());
        result.setFetchSize(vConfig.getFetchSize());
        result.setRuleSet(vConfig.getRuleSet());
        result.setBatchSize(vConfig.getBatchSize());
        result.setInsertBNodeAsVirtuosoIRI(vConfig.getInsertBNodeAsVirtuosoIRI());
        result.setMacroLib(vConfig.getMacroLib());
        result.setConcurrencyMode(vConfig.getConcurrencyMode());
        result.setUseDefGraphForQueries(vConfig.getUseDefGraphForQueries());
        return result;
    }
}

