/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.sesame4.driver;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.CloseableIteratorIteration;
import info.aduna.iteration.Iteration;
import info.aduna.iteration.Iterations;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.openrdf.IsolationLevel;
import org.openrdf.IsolationLevels;
import org.openrdf.OpenRDFUtil;
import org.openrdf.model.BNode;
import org.openrdf.model.IRI;
import org.openrdf.model.Literal;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.SimpleNamespace;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.BindingSet;
import org.openrdf.query.BooleanQuery;
import org.openrdf.query.Dataset;
import org.openrdf.query.GraphQuery;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.Query;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.query.UnsupportedQueryLanguageException;
import org.openrdf.query.Update;
import org.openrdf.query.UpdateExecutionException;
import org.openrdf.query.algebra.evaluation.QueryBindingSet;
import org.openrdf.query.impl.IteratingGraphQueryResult;
import org.openrdf.query.impl.IteratingTupleQueryResult;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.repository.UnknownTransactionStateException;
import org.openrdf.rio.ParseErrorListener;
import org.openrdf.rio.ParserConfig;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.Rio;
import org.openrdf.rio.helpers.AbstractRDFHandler;
import org.openrdf.rio.helpers.ParseErrorLogger;
import virtuoso.jdbc4.Driver;
import virtuoso.jdbc4.VirtuosoDate;
import virtuoso.jdbc4.VirtuosoTime;
import virtuoso.jdbc4.VirtuosoTimestamp;
import virtuoso.sesame4.driver.VirtuosoBooleanQuery;
import virtuoso.sesame4.driver.VirtuosoGraphQuery;
import virtuoso.sesame4.driver.VirtuosoQuery;
import virtuoso.sesame4.driver.VirtuosoRepository;
import virtuoso.sesame4.driver.VirtuosoTupleQuery;
import virtuoso.sesame4.driver.VirtuosoUpdate;
import virtuoso.sql.ExtendedString;
import virtuoso.sql.RdfBox;

public class VirtuosoRepositoryConnection
implements RepositoryConnection {
    private Resource nilContext;
    private Connection quadStoreConnection;
    protected VirtuosoRepository repository;
    static final String S_DELETE = "sparql delete from graph iri(??) {`iri(??)` `iri(??)` `bif:__rdf_long_from_batch_params(??,??,??)`}";
    static final String S_BATCH_INSERT = "DB.DBA.rdf_insert_triple_c (?,?,?,?,?,?)";
    static final String S_CLEAR_GRAPH = "DB.DBA.rdf_clear_graphs_c (?)";
    static final String S_TTLP_INSERT = "DB.DBA.TTLP_MT (?, '', ?, 255, 2, 3, ?)";
    static final int MAX_CMD_SIZE = 36000;
    private int BATCH_SIZE = 5000;
    private PreparedStatement psInsert;
    private PreparedStatement psInsert_BNode;
    private int psInsertCount = 0;
    private int psInsertBNodeCount = 0;
    private boolean useLazyAdd = false;
    private int prefetchSize = 100;
    private boolean useReprepare = true;
    private boolean insertBNodeAsVirtuosoIRI = false;
    private ValueFactory valueFactory = null;
    private boolean insertStringLiteralAsSimple = false;
    private int queryTimeout = 0;
    private String ruleSet;
    private String macroLib;
    private String defGraph;
    private boolean useDefGraphForQueries;
    private volatile ParserConfig parserConfig = new ParserConfig();
    private IsolationLevel isolationLevel;
    private int concurencyMode;
    private int trn_concurrencyMode;

    public VirtuosoRepositoryConnection(VirtuosoRepository repository, Connection connection) throws RepositoryException {
        this.quadStoreConnection = connection;
        this.repository = repository;
        this.useLazyAdd = repository.useLazyAdd;
        this.prefetchSize = repository.prefetchSize;
        this.BATCH_SIZE = repository.batchSize;
        this.insertBNodeAsVirtuosoIRI = repository.insertBNodeAsVirtuosoIRI;
        this.insertStringLiteralAsSimple = repository.insertStringLiteralAsSimple;
        this.valueFactory = repository.getValueFactory();
        this.queryTimeout = repository.getQueryTimeout();
        this.ruleSet = repository.getRuleSet();
        this.macroLib = repository.getMacroLib();
        this.defGraph = repository.defGraph;
        this.useDefGraphForQueries = repository.useDefGraphForQueries;
        this.trn_concurrencyMode = this.concurencyMode = repository.concurencyMode;
        this.nilContext = this.valueFactory.createIRI(repository.defGraph);
        this.repository.initialize();
        try {
            Driver drv = new Driver();
            if (drv.getMajorVersion() >= 3 && drv.getMinorVersion() >= 72) {
                this.useReprepare = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Repository getRepository() {
        return this.repository;
    }

    public void setParserConfig(ParserConfig parserConfig) {
        this.parserConfig = parserConfig;
    }

    public ParserConfig getParserConfig() {
        return this.parserConfig;
    }

    public ValueFactory getValueFactory() {
        return this.valueFactory;
    }

    public boolean isOpen() throws RepositoryException {
        try {
            return !this.getQuadStoreConnection().isClosed();
        }
        catch (SQLException e) {
            throw new RepositoryException("Problem inspecting connection", (Throwable)e);
        }
    }

    public void close() throws RepositoryException {
        try {
            if (!this.getQuadStoreConnection().isClosed()) {
                this.getQuadStoreConnection().close();
            }
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public Query prepareQuery(QueryLanguage ql, String query) throws RepositoryException, MalformedQueryException {
        return this.prepareQuery(ql, query, null);
    }

    public Query prepareQuery(QueryLanguage ql, String query, String baseURI) throws RepositoryException, MalformedQueryException {
        if (ql != QueryLanguage.SPARQL) {
            throw new UnsupportedQueryLanguageException(" : Only SPARQL queries are supported");
        }
        StringTokenizer st = new StringTokenizer(query);
        String type = null;
        while (!(!st.hasMoreTokens() || (type = st.nextToken().toLowerCase()).equals("select") || type.equals("construct") || type.equals("describe") || type.equals("ask"))) {
        }
        this.flushDelayAdd();
        if (type == null || type.equals("select")) {
            return this.prepareTupleQuery(ql, query, baseURI);
        }
        if (type.equals("construct") || type.equals("describe")) {
            return this.prepareGraphQuery(ql, query, baseURI);
        }
        if (type.equals("ask")) {
            return this.prepareBooleanQuery(ql, query, baseURI);
        }
        return new VirtuosoQuery();
    }

    public TupleQuery prepareTupleQuery(QueryLanguage ql, String query) throws RepositoryException, MalformedQueryException {
        return this.prepareTupleQuery(ql, query, null);
    }

    public TupleQuery prepareTupleQuery(QueryLanguage ql, final String query, final String baseURI) throws RepositoryException, MalformedQueryException {
        if (ql != QueryLanguage.SPARQL) {
            throw new UnsupportedQueryLanguageException(" : Only SPARQL queries are supported");
        }
        return new VirtuosoTupleQuery(){

            @Override
            public TupleQueryResult evaluate() throws QueryEvaluationException {
                return VirtuosoRepositoryConnection.this.executeSPARQLForTupleResult(baseURI, query, this.getDataset(), this.getIncludeInferred(), this.getBindings(), this.getMaxExecutionTime());
            }

            @Override
            public void evaluate(TupleQueryResultHandler handler) throws QueryEvaluationException, TupleQueryResultHandlerException {
                VirtuosoRepositoryConnection.this.executeSPARQLForHandler(baseURI, handler, query, this.getDataset(), this.getIncludeInferred(), this.getBindings(), this.getMaxExecutionTime());
            }
        };
    }

    public GraphQuery prepareGraphQuery(QueryLanguage ql, String query) throws RepositoryException, MalformedQueryException {
        return this.prepareGraphQuery(ql, query, null);
    }

    public GraphQuery prepareGraphQuery(QueryLanguage ql, final String query, final String baseURI) throws RepositoryException, MalformedQueryException {
        if (ql != QueryLanguage.SPARQL) {
            throw new UnsupportedQueryLanguageException(" : Only SPARQL queries are supported");
        }
        return new VirtuosoGraphQuery(){

            @Override
            public GraphQueryResult evaluate() throws QueryEvaluationException {
                return VirtuosoRepositoryConnection.this.executeSPARQLForGraphResult(baseURI, query, this.getDataset(), this.getIncludeInferred(), this.getBindings(), this.getMaxExecutionTime());
            }

            @Override
            public void evaluate(RDFHandler handler) throws QueryEvaluationException, RDFHandlerException {
                VirtuosoRepositoryConnection.this.executeSPARQLForHandler(baseURI, handler, query, this.getDataset(), this.getIncludeInferred(), this.getBindings(), this.getMaxExecutionTime());
            }
        };
    }

    public BooleanQuery prepareBooleanQuery(QueryLanguage ql, String query) throws RepositoryException, MalformedQueryException {
        return this.prepareBooleanQuery(ql, query, null);
    }

    public BooleanQuery prepareBooleanQuery(QueryLanguage ql, final String query, final String baseURI) throws RepositoryException, MalformedQueryException {
        if (ql != QueryLanguage.SPARQL) {
            throw new UnsupportedQueryLanguageException(" : Only SPARQL queries are supported");
        }
        return new VirtuosoBooleanQuery(){

            @Override
            public boolean evaluate() throws QueryEvaluationException {
                return VirtuosoRepositoryConnection.this.executeSPARQLForBooleanResult(baseURI, query, this.getDataset(), this.getIncludeInferred(), this.getBindings(), this.getMaxExecutionTime());
            }
        };
    }

    public Update prepareUpdate(QueryLanguage ql, String query) throws RepositoryException, MalformedQueryException {
        return this.prepareUpdate(ql, query, null);
    }

    public Update prepareUpdate(QueryLanguage ql, final String query, final String baseURI) throws RepositoryException, MalformedQueryException {
        if (ql != QueryLanguage.SPARQL) {
            throw new UnsupportedQueryLanguageException(" : Only SPARQL queries are supported");
        }
        return new VirtuosoUpdate(){

            @Override
            public void execute() throws UpdateExecutionException {
                VirtuosoRepositoryConnection.this.executeSPARUL(baseURI, query, this.getDataset(), this.getIncludeInferred(), this.getBindings(), -1);
            }
        };
    }

    public RepositoryResult<Resource> getContextIDs() throws RepositoryException {
        this.verifyIsOpen();
        this.flushDelayAdd();
        Vector<Resource> v = new Vector<Resource>();
        String query = "DB.DBA.SPARQL_SELECT_KNOWN_GRAPHS()";
        try {
            java.sql.Statement stmt = this.createStatement(-1, false);
            ResultSet rs = stmt.executeQuery(query);
            while (rs.next()) {
                Object obj = rs.getObject(1);
                try {
                    Value graphId = this.castValue(obj);
                    v.add((Resource)graphId);
                }
                catch (IllegalArgumentException iiaex) {
                    throw new RepositoryException("VirtuosoRepositoryConnection.getContextIDs() Non-URI context encountered: " + obj);
                }
            }
            rs.close();
            stmt.close();
        }
        catch (Exception e) {
            throw new RepositoryException(": SPARQL execute failed.\n" + query, (Throwable)e);
        }
        return this.createRepositoryResult(v);
    }

    public RepositoryResult<Statement> getStatements(Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) throws RepositoryException {
        contexts = this.checkContext(contexts);
        return new RepositoryResult(this.selectFromQuadStore(subj, pred, obj, includeInferred, false, contexts));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasStatement(Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) throws RepositoryException {
        contexts = this.checkContext(contexts);
        try (CloseableIteration<Statement, RepositoryException> it = this.selectFromQuadStore(subj, pred, obj, includeInferred, true, contexts);){
            boolean bl = it.hasNext();
            return bl;
        }
    }

    public boolean hasStatement(Statement st, boolean includeInferred, Resource ... contexts) throws RepositoryException {
        return this.hasStatement(st.getSubject(), st.getPredicate(), st.getObject(), includeInferred, contexts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportStatements(Resource subj, IRI pred, Value obj, boolean includeInferred, RDFHandler handler, Resource ... contexts) throws RepositoryException, RDFHandlerException {
        contexts = this.checkContext(contexts);
        handler.startRDF();
        try (RepositoryResult<Namespace> nsIt = this.getNamespaces();){
            while (nsIt.hasNext()) {
                Namespace ns = (Namespace)nsIt.next();
                handler.handleNamespace(ns.getPrefix(), ns.getName());
            }
        }
        try (CloseableIteration<Statement, RepositoryException> it = this.selectFromQuadStore(subj, pred, obj, includeInferred, false, contexts);){
            while (it.hasNext()) {
                handler.handleStatement((Statement)it.next());
            }
        }
        handler.endRDF();
    }

    private Resource[] checkDMLContext(Resource ... contexts) throws RepositoryException {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        if (contexts.length == 1 && contexts[0] == null) {
            contexts = new Resource[]{this.nilContext};
        } else if (contexts.length == 0) {
            contexts = new Resource[]{this.nilContext};
        }
        return contexts;
    }

    private Resource[] checkContext(Resource ... contexts) throws RepositoryException {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        if (contexts.length == 1 && contexts[0] == null) {
            contexts = new Resource[]{this.nilContext};
        } else if (contexts.length == 0) {
            contexts = new Resource[]{};
        }
        return contexts;
    }

    public void export(RDFHandler handler, Resource ... contexts) throws RepositoryException, RDFHandlerException {
        this.exportStatements(null, null, null, false, handler, contexts);
    }

    public long size(Resource ... contexts) throws RepositoryException {
        long ret = 0L;
        this.verifyIsOpen();
        this.flushDelayAdd();
        contexts = this.checkContext(contexts);
        StringBuilder query = new StringBuilder("select count(*) from (sparql define input:storage \"\" select * ");
        for (Resource context : contexts) {
            query.append("from named <");
            query.append(context.toString());
            query.append("> ");
        }
        query.append("where { graph ?g {?s ?p ?o }})f");
        try {
            java.sql.Statement st = this.createStatement(-1, false);
            ResultSet rs = st.executeQuery(query.toString());
            if (rs.next()) {
                ret = rs.getLong(1);
            }
            rs.close();
            st.close();
        }
        catch (Exception e) {
            throw new RepositoryException(": SPARQL execute failed:[" + query + "] \n Exception:" + e);
        }
        return ret;
    }

    public boolean isEmpty() throws RepositoryException {
        this.verifyIsOpen();
        this.flushDelayAdd();
        String query = "sparql define input:storage \"\" select * where {?s ?o ?p} limit 1";
        try {
            java.sql.Statement stmt = this.createStatement(-1, false);
            ResultSet rs = stmt.executeQuery(query);
            boolean result = !rs.next();
            rs.close();
            stmt.close();
            return result;
        }
        catch (Exception e) {
            throw new RepositoryException(": SPARQL execute failed:[" + query + "] \n Exception:" + e);
        }
    }

    public void setAutoCommit(boolean autoCommit) throws RepositoryException {
        this.verifyIsOpen();
        this.flushDelayAdd();
        try {
            this.getQuadStoreConnection().setAutoCommit(autoCommit);
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public boolean isAutoCommit() throws RepositoryException {
        this.verifyIsOpen();
        try {
            return this.getQuadStoreConnection().getAutoCommit();
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public boolean isActive() throws RepositoryException {
        this.verifyIsOpen();
        try {
            return !this.getQuadStoreConnection().getAutoCommit();
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void setIsolationLevel(IsolationLevel level) throws IllegalStateException {
        try {
            if (this.isActive()) {
                throw new IllegalStateException("Transaction isolation level can not be modified while transaction is active");
            }
            this.isolationLevel = level;
        }
        catch (UnknownTransactionStateException e) {
            throw new IllegalStateException("Transaction isolation level can not be modified while transaction state is unknown", e);
        }
        catch (RepositoryException e) {
            throw new IllegalStateException("Transaction isolation level can not be modified due to repository error", e);
        }
    }

    public IsolationLevel getIsolationLevel() {
        return this.isolationLevel;
    }

    public void begin() throws RepositoryException {
        this.verifyIsOpen();
        this.flushDelayAdd();
        this.verifyNotTxnActive("Connection already has an active transaction");
        try {
            Connection conn = this.getQuadStoreConnection();
            conn.setAutoCommit(false);
            if (this.isolationLevel == IsolationLevels.READ_UNCOMMITTED) {
                conn.setTransactionIsolation(1);
            } else if (this.isolationLevel == IsolationLevels.READ_COMMITTED) {
                conn.setTransactionIsolation(2);
            } else if (this.isolationLevel == IsolationLevels.SNAPSHOT_READ) {
                conn.setTransactionIsolation(2);
            } else if (this.isolationLevel == IsolationLevels.SNAPSHOT) {
                conn.setTransactionIsolation(2);
            } else if (this.isolationLevel == IsolationLevels.SERIALIZABLE) {
                conn.setTransactionIsolation(8);
            }
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void begin(IsolationLevel level) throws RepositoryException {
        this.setIsolationLevel(level);
        this.begin();
    }

    public void commit() throws RepositoryException {
        this.verifyIsOpen();
        this.flushDelayAdd();
        try {
            this.getQuadStoreConnection().commit();
            this.getQuadStoreConnection().setAutoCommit(true);
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void rollback() throws RepositoryException {
        this.verifyIsOpen();
        this.dropDelayAdd();
        try {
            this.getQuadStoreConnection().rollback();
            this.getQuadStoreConnection().setAutoCommit(true);
        }
        catch (SQLException e) {
            throw new RepositoryException("Problem with rollback", (Throwable)e);
        }
    }

    public void add(InputStream in, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        InputStreamReader reader = new InputStreamReader(in);
        this.add(reader, baseURI, dataFormat, contexts);
    }

    public synchronized void add(Reader reader, String baseURI, RDFFormat dataFormat, final Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        this.verifyIsOpen();
        this.flushDelayAdd();
        final boolean useStatementContext = contexts != null && contexts.length == 0;
        try {
            RDFParser parser = Rio.createParser((RDFFormat)dataFormat, (ValueFactory)this.getValueFactory());
            parser.setParserConfig(this.getParserConfig());
            parser.setParseErrorListener((ParseErrorListener)new ParseErrorLogger());
            parser.setRDFHandler((RDFHandler)new AbstractRDFHandler(){
                int count = 0;
                PreparedStatement ps = null;
                java.sql.Statement st_cmd = null;
                Resource[] _contexts = VirtuosoRepositoryConnection.access$000(VirtuosoRepositoryConnection.this, contexts);

                public void startRDF() throws RDFHandlerException {
                    if (!VirtuosoRepositoryConnection.this.insertBNodeAsVirtuosoIRI) {
                        try {
                            this.st_cmd = VirtuosoRepositoryConnection.this.createStatement(-1, false);
                            this.st_cmd.executeUpdate("connection_set ('RDF_INSERT_TRIPLE_C_BNODES', dict_new(1000))");
                        }
                        catch (SQLException e) {
                            throw new RDFHandlerException("Problem with creation of BNode cache: ", (Throwable)e);
                        }
                    }
                }

                public void endRDF() throws RDFHandlerException {
                    try {
                        if (this.count > 0) {
                            this.ps = VirtuosoRepositoryConnection.this.flushDelayAdd_batch(this.ps, this.count);
                        }
                    }
                    catch (RepositoryException e) {
                        throw new RDFHandlerException("Problem executing query: ", (Throwable)e);
                    }
                    try {
                        if (this.st_cmd != null) {
                            this.st_cmd.executeUpdate("connection_set ('RDF_INSERT_TRIPLE_C_BNODES', NULL)");
                        }
                    }
                    catch (SQLException e) {
                        throw new RDFHandlerException("Problem with clearing of BNode cache: ", (Throwable)e);
                    }
                    if (this.ps != null) {
                        try {
                            this.ps.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (this.st_cmd != null) {
                        try {
                            this.st_cmd.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.ps = null;
                    this.st_cmd = null;
                    this.count = 0;
                }

                public void handleNamespace(String prefix, String name) throws RDFHandlerException {
                    String query = "DB.DBA.XML_SET_NS_DECL(?, ?, 1)";
                    try {
                        PreparedStatement psn = VirtuosoRepositoryConnection.this.prepareStatement(query, false);
                        psn.setString(1, prefix);
                        psn.setString(2, name);
                        psn.execute();
                        psn.close();
                    }
                    catch (SQLException e) {
                        throw new RDFHandlerException("Problem executing query: " + query, (Throwable)e);
                    }
                }

                public void handleStatement(Statement st) throws RDFHandlerException {
                    try {
                        Resource[] hcontexts = st.getContext() != null && useStatementContext ? new Resource[]{st.getContext()} : this._contexts;
                        this.ps = VirtuosoRepositoryConnection.this.addToQuadStore_batch(this.ps, st.getSubject(), st.getPredicate(), st.getObject(), hcontexts);
                        this.count += hcontexts.length;
                        if (this.count > VirtuosoRepositoryConnection.this.BATCH_SIZE) {
                            this.ps = VirtuosoRepositoryConnection.this.flushDelayAdd_batch(this.ps, this.count);
                            this.count = 0;
                        }
                    }
                    catch (Exception e) {
                        throw new RDFHandlerException((Throwable)e);
                    }
                }
            });
            parser.parse(reader, baseURI);
        }
        catch (Exception e) {
            throw new RepositoryException("Problem parsing triples", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(URL url, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        if (baseURI == null) {
            baseURI = url.toExternalForm();
        }
        try (InputStreamReader reader = new InputStreamReader(url.openStream());){
            this.add(reader, baseURI, dataFormat, contexts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(File file, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        if (baseURI == null) {
            baseURI = file.toURI().toString();
        }
        try (FileInputStream reader = new FileInputStream(file);){
            this.add(reader, baseURI, dataFormat, contexts);
        }
    }

    public void add(Resource subject, IRI predicate, Value object, Resource ... contexts) throws RepositoryException {
        contexts = this.checkDMLContext(contexts);
        this.addToQuadStore(subject, predicate, object, contexts);
    }

    public void addQuad(Resource subject, IRI predicate, Value object, Resource context) throws RepositoryException {
        this.addToQuadStore(subject, predicate, object, context);
    }

    public void add(Statement statement, Resource ... contexts) throws RepositoryException {
        if (contexts != null && contexts.length == 0 && statement.getContext() != null) {
            contexts = new Resource[]{statement.getContext()};
        }
        this.add(statement.getSubject(), statement.getPredicate(), statement.getObject(), contexts);
    }

    public synchronized void add(Iterable<? extends Statement> statements, Resource ... contexts) throws RepositoryException {
        this.verifyIsOpen();
        this.flushDelayAdd();
        Iterator<? extends Statement> it = statements.iterator();
        boolean useStatementContext = contexts != null && contexts.length == 0;
        Resource[] _contexts = this.checkDMLContext(contexts);
        int count = 0;
        java.sql.Statement ps = null;
        java.sql.Statement st_cmd = null;
        try {
            if (!this.insertBNodeAsVirtuosoIRI) {
                st_cmd = this.createStatement(-1, false);
                st_cmd.executeUpdate("connection_set ('RDF_INSERT_TRIPLE_C_BNODES', dict_new(1000))");
            }
            while (it.hasNext()) {
                Statement st = it.next();
                contexts = st.getContext() != null && useStatementContext ? new Resource[]{st.getContext()} : _contexts;
                ps = this.addToQuadStore_batch((PreparedStatement)ps, st.getSubject(), st.getPredicate(), st.getObject(), contexts);
                if ((count += contexts.length) <= this.BATCH_SIZE) continue;
                ps = this.flushDelayAdd_batch((PreparedStatement)ps, count);
                count = 0;
            }
            if (count > 0) {
                ps = this.flushDelayAdd_batch((PreparedStatement)ps, count);
            }
            if (st_cmd != null) {
                st_cmd.executeUpdate("connection_set ('RDF_INSERT_TRIPLE_C_BNODES', NULL)");
            }
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Exception exception) {}
            }
            if (st_cmd != null) {
                try {
                    st_cmd.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public synchronized <E extends Exception> void add(Iteration<? extends Statement, E> statements, Resource ... contexts) throws RepositoryException, E {
        this.verifyIsOpen();
        this.flushDelayAdd();
        boolean useStatementContext = contexts != null && contexts.length == 0;
        Resource[] _contexts = this.checkDMLContext(contexts);
        int count = 0;
        java.sql.Statement ps = null;
        java.sql.Statement st_cmd = null;
        try {
            if (!this.insertBNodeAsVirtuosoIRI) {
                st_cmd = this.createStatement(-1, false);
                st_cmd.executeUpdate("connection_set ('RDF_INSERT_TRIPLE_C_BNODES', dict_new(1000))");
            }
            while (statements.hasNext()) {
                Statement st = (Statement)statements.next();
                contexts = st.getContext() != null && useStatementContext ? new Resource[]{st.getContext()} : _contexts;
                ps = this.addToQuadStore_batch((PreparedStatement)ps, st.getSubject(), st.getPredicate(), st.getObject(), contexts);
                if ((count += contexts.length) <= this.BATCH_SIZE) continue;
                ps = this.flushDelayAdd_batch((PreparedStatement)ps, count);
                count = 0;
            }
            if (count > 0) {
                ps = this.flushDelayAdd_batch((PreparedStatement)ps, count);
            }
            if (st_cmd != null) {
                st_cmd.executeUpdate("connection_set ('RDF_INSERT_TRIPLE_C_BNODES', NULL)");
            }
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Exception exception) {}
            }
            if (st_cmd != null) {
                try {
                    st_cmd.close();
                }
                catch (Exception exception) {}
            }
            Iterations.closeCloseable(statements);
        }
    }

    public void remove(Resource subject, IRI predicate, Value object, Resource ... contexts) throws RepositoryException {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        this.verifyIsOpen();
        this.flushDelayAdd();
        for (Resource context : contexts = this.checkDMLContext(contexts)) {
            this.removeContext(subject, predicate, object, context);
        }
    }

    public void remove(Statement statement, Resource ... contexts) throws RepositoryException {
        if (contexts != null && contexts.length == 0 && statement.getContext() != null) {
            contexts = new Resource[]{statement.getContext()};
        }
        this.remove(statement.getSubject(), statement.getPredicate(), statement.getObject(), contexts);
    }

    public void remove(Iterable<? extends Statement> statements, Resource ... contexts) throws RepositoryException {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        this.verifyIsOpen();
        this.flushDelayAdd();
        Iterator<? extends Statement> it = statements.iterator();
        int count = 0;
        HashMap<String, StringBuilder> map = new HashMap<String, StringBuilder>();
        while (it.hasNext()) {
            Statement st = it.next();
            Resource[] _contexts = contexts.length == 0 && st.getContext() != null ? new Resource[]{st.getContext()} : contexts;
            for (Resource _context : _contexts = this.checkDMLContext(_contexts)) {
                String ctx = _context.toString();
                StringBuilder row = new StringBuilder(256);
                this.append(st.getSubject(), row, true);
                row.append(' ');
                this.append(st.getPredicate(), row, true);
                row.append(' ');
                this.append(st.getObject(), row, true);
                row.append(" .\n");
                StringBuilder data = map.get(ctx);
                if (count > 0 && data != null && data.length() + row.length() > 36000) {
                    this.removeData(map);
                    map.clear();
                    count = 0;
                    data = null;
                }
                if (data == null) {
                    data = new StringBuilder(256);
                }
                data.append((CharSequence)row);
                map.put(ctx, data);
                ++count;
            }
        }
        if (count > 0) {
            this.removeData(map);
        }
        map.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends Exception> void remove(Iteration<? extends Statement, E> statements, Resource ... contexts) throws RepositoryException, E {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        this.verifyIsOpen();
        this.flushDelayAdd();
        int count = 0;
        HashMap<String, StringBuilder> map = new HashMap<String, StringBuilder>();
        try {
            while (statements.hasNext()) {
                Statement st = (Statement)statements.next();
                Resource[] _contexts = contexts.length == 0 && st.getContext() != null ? new Resource[]{st.getContext()} : contexts;
                for (Resource _context : _contexts = this.checkDMLContext(_contexts)) {
                    String ctx = _context.toString();
                    StringBuilder row = new StringBuilder(256);
                    this.append(st.getSubject(), row, true);
                    row.append(' ');
                    this.append(st.getPredicate(), row, true);
                    row.append(' ');
                    this.append(st.getObject(), row, true);
                    row.append(" .\n");
                    StringBuilder data = map.get(ctx);
                    if (count > 0 && data != null && data.length() + row.length() > 36000) {
                        this.removeData(map);
                        map.clear();
                        count = 0;
                        data = null;
                    }
                    if (data == null) {
                        data = new StringBuilder(256);
                    }
                    data.append((CharSequence)row);
                    map.put(ctx, data);
                    ++count;
                }
            }
            if (count > 0) {
                this.removeData(map);
            }
            map.clear();
        }
        finally {
            Iterations.closeCloseable(statements);
        }
    }

    public void clear(Resource ... contexts) throws RepositoryException {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        this.verifyIsOpen();
        this.flushDelayAdd();
        contexts = this.checkDMLContext(contexts);
        this.clearQuadStore(contexts);
    }

    public RepositoryResult<Namespace> getNamespaces() throws RepositoryException {
        this.verifyIsOpen();
        this.flushDelayAdd();
        ArrayList<SimpleNamespace> namespaceList = new ArrayList<SimpleNamespace>();
        String query = "DB.DBA.XML_SELECT_ALL_NS_DECLS (3)";
        try {
            java.sql.Statement stmt = this.createStatement(-1, false);
            ResultSet rs = stmt.executeQuery(query);
            while (rs.next()) {
                String prefix = rs.getString(1);
                String name = rs.getString(2);
                if (name == null || prefix == null) continue;
                SimpleNamespace ns = new SimpleNamespace(prefix, name);
                namespaceList.add(ns);
            }
            rs.close();
            stmt.close();
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
        return this.createRepositoryResult(namespaceList);
    }

    public String getNamespace(String prefix) throws RepositoryException {
        this.verifyIsOpen();
        this.flushDelayAdd();
        String retVal = null;
        String query = "SELECT __xml_get_ns_uri (?, 3)";
        try {
            PreparedStatement ps = this.prepareStatement(query, false);
            ps.setString(1, prefix);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                retVal = rs.getString(1);
            }
            ps.close();
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
        return retVal;
    }

    public void setNamespace(String prefix, String name) throws RepositoryException {
        this.verifyIsOpen();
        this.flushDelayAdd();
        String query = "DB.DBA.XML_SET_NS_DECL(?, ?, 1)";
        try {
            PreparedStatement ps = this.prepareStatement(query, false);
            ps.setString(1, prefix);
            ps.setString(2, name);
            ps.execute();
            ps.close();
        }
        catch (SQLException e) {
            throw new RepositoryException("Problem executing query: " + query, (Throwable)e);
        }
    }

    public void removeNamespace(String prefix) throws RepositoryException {
        this.verifyIsOpen();
        this.flushDelayAdd();
        String query = "DB.DBA.XML_REMOVE_NS_BY_PREFIX(?, 1)";
        try {
            PreparedStatement ps = this.prepareStatement(query, false);
            ps.setString(1, prefix);
            ps.execute();
            ps.close();
        }
        catch (SQLException e) {
            throw new RepositoryException("Problem executing query: " + query, (Throwable)e);
        }
    }

    public void clearNamespaces() throws RepositoryException {
        this.verifyIsOpen();
        this.flushDelayAdd();
        String query = "DB.DBA.XML_CLEAR_ALL_NS_DECLS()";
        try {
            java.sql.Statement stmt = this.createStatement(-1, true);
            stmt.execute(query);
            stmt.close();
        }
        catch (SQLException e) {
            throw new RepositoryException("Problem executing query: " + query, (Throwable)e);
        }
    }

    protected TupleQueryResult executeSPARQLForTupleResult(String baseURI, String query, Dataset dataset, boolean includeInferred, BindingSet bindings, int maxQueryTime) throws QueryEvaluationException {
        ArrayList<String> names = new ArrayList<String>();
        try {
            PreparedStatement stmt = this.executeSPARQL(baseURI, query, dataset, includeInferred, bindings, maxQueryTime, false);
            ResultSet rs = stmt.executeQuery();
            ResultSetMetaData rsmd = rs.getMetaData();
            for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                String col = rsmd.getColumnName(i);
                if (names.indexOf(col) >= 0) continue;
                names.add(col);
            }
            return new IteratingTupleQueryResult(names, (CloseableIteration)new CloseableIterationBindingSet(stmt, rs));
        }
        catch (Exception e) {
            throw new QueryEvaluationException(": SPARQL execute failed:[" + query + "] \n Exception:" + e);
        }
    }

    protected GraphQueryResult executeSPARQLForGraphResult(String baseURI, String query, Dataset dataset, boolean includeInferred, BindingSet bindings, int maxQueryTime) throws QueryEvaluationException {
        try {
            PreparedStatement stmt = this.executeSPARQL(baseURI, query, dataset, includeInferred, bindings, maxQueryTime, false);
            ResultSet rs = stmt.executeQuery();
            return new IteratingGraphQueryResult(new HashMap(), (CloseableIteration)new CloseableIterationGraphResult(stmt, rs));
        }
        catch (Exception e) {
            throw new QueryEvaluationException(": SPARQL execute failed:[" + query + "] \n Exception:" + e);
        }
    }

    protected boolean executeSPARQLForBooleanResult(String baseURI, String query, Dataset dataset, boolean includeInferred, BindingSet bindings, int maxQueryTime) throws QueryEvaluationException {
        boolean result = false;
        try {
            PreparedStatement stmt = this.executeSPARQL(baseURI, query, dataset, includeInferred, bindings, maxQueryTime, false);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                if (rs.getInt(1) != 1) continue;
                result = true;
            }
            stmt.close();
            return result;
        }
        catch (Exception e) {
            throw new QueryEvaluationException(": SPARQL execute failed:[" + query + "] \n Exception:" + e);
        }
    }

    protected void executeSPARQLForHandler(String baseURI, TupleQueryResultHandler tqrh, String query, Dataset dataset, boolean includeInferred, BindingSet bindings, int maxQueryTime) throws QueryEvaluationException, TupleQueryResultHandlerException {
        LinkedList<String> names = new LinkedList<String>();
        try {
            PreparedStatement stmt = this.executeSPARQL(baseURI, query, dataset, includeInferred, bindings, maxQueryTime, false);
            ResultSet rs = stmt.executeQuery();
            ResultSetMetaData rsmd = rs.getMetaData();
            for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                names.add(rsmd.getColumnName(i));
            }
            tqrh.startQueryResult(names);
            while (rs.next()) {
                QueryBindingSet qbs = new QueryBindingSet();
                for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                    String col = rsmd.getColumnName(i);
                    Object val = rs.getObject(i);
                    if (val == null) continue;
                    Value v = this.castValue(val);
                    qbs.addBinding(col, v);
                }
                tqrh.handleSolution((BindingSet)qbs);
            }
            tqrh.endQueryResult();
            stmt.close();
        }
        catch (Exception e) {
            throw new QueryEvaluationException(": SPARQL execute failed:[" + query + "] \n Exception:" + e);
        }
    }

    protected void executeSPARQLForHandler(String baseURI, RDFHandler tqrh, String query, Dataset dataset, boolean includeInferred, BindingSet bindings, int maxQueryTime) throws QueryEvaluationException, RDFHandlerException {
        try {
            PreparedStatement stmt = this.executeSPARQL(baseURI, query, dataset, includeInferred, bindings, maxQueryTime, false);
            ResultSet rs = stmt.executeQuery();
            ResultSetMetaData rsmd = rs.getMetaData();
            int col_g = -1;
            int col_s = -1;
            int col_p = -1;
            int col_o = -1;
            for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                String label = rsmd.getColumnName(i);
                if (label.equalsIgnoreCase("g")) {
                    col_g = i;
                    continue;
                }
                if (label.equalsIgnoreCase("s")) {
                    col_s = i;
                    continue;
                }
                if (label.equalsIgnoreCase("p")) {
                    col_p = i;
                    continue;
                }
                if (!label.equalsIgnoreCase("o")) continue;
                col_o = i;
            }
            tqrh.startRDF();
            while (rs.next()) {
                Resource sval = null;
                IRI pval = null;
                Value oval = null;
                Resource gval = null;
                if (col_s != -1) {
                    sval = (Resource)this.castValue(rs.getObject(col_s));
                }
                if (col_p != -1) {
                    pval = (IRI)this.castValue(rs.getObject(col_p));
                }
                if (col_o != -1) {
                    oval = this.castValue(rs.getObject(col_o));
                }
                if (col_g != -1) {
                    gval = (Resource)this.castValue(rs.getObject(col_g));
                }
                Statement st = this.valueFactory.createStatement(sval, pval, oval, gval);
                tqrh.handleStatement(st);
            }
            tqrh.endRDF();
            stmt.close();
        }
        catch (Exception e) {
            throw new QueryEvaluationException(": SPARQL execute failed:[" + query + "] \n Exception:" + e);
        }
    }

    private PreparedStatement executeSPARQL(String baseURI, String query, Dataset dataset, boolean includeInferred, BindingSet bindings, int maxQueryTime, boolean isIUD) throws RepositoryException, SQLException {
        this.verifyIsOpen();
        this.flushDelayAdd();
        ArrayList<Value> pstmtParams = new ArrayList<Value>();
        String fixedQuery = this.fixQuery(false, query, dataset, includeInferred, bindings, pstmtParams, baseURI);
        PreparedStatement stmt = this.prepareStatement(fixedQuery, maxQueryTime, isIUD);
        this.setQueryParams(stmt, pstmtParams);
        return stmt;
    }

    protected void executeSPARUL(String baseURI, String query, Dataset dataset, boolean includeInferred, BindingSet bindings, int maxQueryTime) throws UpdateExecutionException {
        try {
            PreparedStatement stmt = this.executeSPARQL(baseURI, query, dataset, includeInferred, bindings, maxQueryTime, true);
            stmt.execute();
            stmt.close();
        }
        catch (Exception e) {
            throw new UpdateExecutionException(": SPARQL execute failed:[" + query + "] \n Exception:" + e);
        }
    }

    public int executeSPARUL(String query) throws RepositoryException {
        java.sql.Statement stmt = null;
        try {
            this.verifyIsOpen();
            this.flushDelayAdd();
            stmt = this.createStatement(-1, true);
            stmt.execute("sparql\n " + query);
            int n = stmt.getUpdateCount();
            return n;
        }
        catch (SQLException e) {
            throw new RepositoryException(": SPARQL execute failed:[" + query + "] \n Exception:" + e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public Connection getQuadStoreConnection() {
        return this.quadStoreConnection;
    }

    public void setQuadStoreConnection(Connection quadStoreConnection) {
        this.quadStoreConnection = quadStoreConnection;
    }

    private int getJdbcConcurrency(boolean isIUD) {
        if (isIUD) {
            switch (this.concurencyMode) {
                case 1: {
                    return 1008;
                }
                case 2: {
                    return 1009;
                }
            }
            return 1007;
        }
        return 1007;
    }

    private java.sql.Statement createStatement(int maxQueryTime, boolean isIUD) throws SQLException {
        java.sql.Statement stmt = this.quadStoreConnection.createStatement(1003, this.getJdbcConcurrency(isIUD));
        int timeout = this.queryTimeout;
        if (timeout > 0) {
            stmt.setQueryTimeout(timeout);
        }
        if (maxQueryTime > 0) {
            stmt.setQueryTimeout(timeout);
        }
        stmt.setFetchSize(this.prefetchSize);
        return stmt;
    }

    private PreparedStatement prepareStatement(String sql, boolean isIUD) throws SQLException {
        PreparedStatement stmt = this.quadStoreConnection.prepareStatement(sql, 1003, this.getJdbcConcurrency(isIUD));
        int timeout = this.queryTimeout;
        if (timeout > 0) {
            stmt.setQueryTimeout(timeout);
        }
        stmt.setFetchSize(this.prefetchSize);
        return stmt;
    }

    private PreparedStatement prepareStatement(String sql, int maxQueryTime, boolean isIUD) throws SQLException {
        PreparedStatement stmt = this.quadStoreConnection.prepareStatement(sql, 1003, this.getJdbcConcurrency(isIUD));
        int timeout = this.queryTimeout;
        if (timeout > 0) {
            stmt.setQueryTimeout(timeout);
        }
        if (maxQueryTime > 0) {
            stmt.setQueryTimeout(timeout);
        }
        stmt.setFetchSize(this.prefetchSize);
        return stmt;
    }

    private void setQueryParams(PreparedStatement stmt, List<Value> params) throws RepositoryException {
        int i = 0;
        for (Value value : params) {
            try {
                if (value instanceof Resource) {
                    this.bindResource(stmt, ++i, (Resource)value);
                    continue;
                }
                this.bindValue(stmt, ++i, value);
            }
            catch (SQLException e) {
                throw new RepositoryException("Failed to bind parameter " + value.toString() + " to the query.", (Throwable)e);
            }
        }
    }

    private String substBindings(String query, BindingSet bindings, List<Value> pstmtParams, boolean isSPARUL) throws RepositoryException {
        boolean use_setParams = !this.insertBNodeAsVirtuosoIRI;
        StringBuilder tok = new StringBuilder();
        StringBuilder buf = new StringBuilder();
        String delim = " \t\n\r\f,)(;.}{";
        int inCurly = 0;
        int i = 0;
        boolean afterFROM = false;
        int qlen = query.length();
        block0: while (i < qlen) {
            char ch;
            if ((ch = query.charAt(i++)) == '\\') {
                buf.append(ch);
                tok.append(ch);
                if (i >= qlen) continue;
                ch = query.charAt(i++);
                buf.append(ch);
                tok.append(ch);
                continue;
            }
            if (ch == '\"' || ch == '\'') {
                tok.setLength(0);
                char end = ch;
                buf.append(ch);
                while (i < qlen) {
                    ch = query.charAt(i++);
                    buf.append(ch);
                    if (ch != end) continue;
                    continue block0;
                }
                continue;
            }
            if (ch == '{') {
                ++inCurly;
                buf.append(ch);
                tok.setLength(0);
                continue;
            }
            if (ch == '{') {
                --inCurly;
                buf.append(ch);
                tok.setLength(0);
                continue;
            }
            if (ch == '?') {
                int j;
                tok.setLength(0);
                String varData = null;
                for (j = i; j < qlen && delim.indexOf(query.charAt(j)) < 0; ++j) {
                }
                if (j != i) {
                    boolean useBackSlash = isSPARUL || inCurly > 0;
                    String varName = query.substring(i, j);
                    Value val = bindings.getValue(varName);
                    if (val != null) {
                        if (use_setParams) {
                            if (inCurly > 0) {
                                pstmtParams.add(val);
                                varData = val instanceof Resource ? "`iri(??)`" : "`bif:__rdf_long_from_batch_params(??,??,??)`";
                            } else {
                                varData = isSPARUL || afterFROM ? this.stringForValue(val, useBackSlash) : this.stringForValue(val, useBackSlash) + " AS ?" + varName;
                            }
                        } else {
                            varData = inCurly == 0 && !isSPARUL && !afterFROM ? this.stringForValue(val, useBackSlash) + " AS ?" + varName : this.stringForValue(val, useBackSlash);
                        }
                        i = j;
                    }
                }
                if (varData != null) {
                    buf.append(varData);
                    continue;
                }
                buf.append(ch);
                continue;
            }
            buf.append(ch);
            if (delim.indexOf(ch) < 0) {
                tok.append(ch);
                continue;
            }
            if (tok.length() == 4 && (tok.charAt(0) == 'F' || tok.charAt(0) == 'f') && tok.toString().equalsIgnoreCase("FROM")) {
                afterFROM = true;
            }
            tok.setLength(0);
        }
        return buf.toString();
    }

    private String fixQuery(boolean isSPARUL, String query, Dataset dataset, boolean includeInferred, BindingSet bindings, List<Value> pstmtParams, String baseURI) throws RepositoryException {
        Set list;
        boolean added_def_graph = false;
        String removeGraph = null;
        String insertGraph = null;
        if (dataset != null) {
            IRI g;
            list = dataset.getDefaultRemoveGraphs();
            if (list != null) {
                if (list.size() > 1) {
                    throw new RepositoryException("Only ONE DefaultRemoveGraph is supported");
                }
                Iterator it = list.iterator();
                if (it.hasNext()) {
                    removeGraph = " <" + ((IRI)it.next()).toString() + "> ";
                }
            }
            if ((g = dataset.getDefaultInsertGraph()) != null) {
                insertGraph = " <" + g.toString() + "> ";
            }
        }
        query = this.SubstGraphs(query, insertGraph, removeGraph);
        StringBuilder ret = new StringBuilder("sparql\n");
        if (includeInferred && this.ruleSet != null && this.ruleSet.length() > 0) {
            ret.append("define input:inference '" + this.ruleSet + "'\n ");
        }
        if (includeInferred && this.macroLib != null && this.macroLib.length() > 0) {
            ret.append("define input:macro-lib <" + this.macroLib + ">\n ");
        }
        if (dataset != null) {
            list = dataset.getDefaultGraphs();
            if (list != null) {
                for (IRI v : list) {
                    ret.append(" define input:default-graph-uri <" + v.toString() + "> \n");
                    added_def_graph = true;
                }
            }
            if ((list = dataset.getNamedGraphs()) != null) {
                for (IRI v : list) {
                    ret.append(" define input:named-graph-uri <" + v.toString() + "> \n");
                }
            }
        }
        if (!added_def_graph && this.useDefGraphForQueries) {
            ret.append(" define input:default-graph-uri <" + this.defGraph + "> \n");
        }
        if (baseURI != null && baseURI.length() > 0) {
            ret.append(" BASE <" + baseURI + "> \n");
        }
        ret.append(this.substBindings(query, bindings, pstmtParams, isSPARUL));
        return ret.toString();
    }

    private String SubstGraphs(String query, String gInsert, String gDelete) {
        ArrayList<String> lst = new ArrayList<String>(16);
        StringBuilder buf = new StringBuilder();
        String delim = "{} \t\n\r\f";
        int i = 0;
        int qlen = query.length();
        block0: while (i < qlen) {
            char ch;
            if (delim.indexOf(ch = query.charAt(i++)) >= 0) {
                if (buf.length() > 0) {
                    lst.add(buf.toString());
                    buf.setLength(0);
                }
                lst.add("" + ch);
                continue;
            }
            if (ch == '\\') {
                buf.append(ch);
                if (i >= qlen) continue;
                buf.append(query.charAt(i++));
                continue;
            }
            if (ch == '\"' || ch == '\'') {
                char end = ch;
                buf.append(ch);
                while (i < qlen) {
                    ch = query.charAt(i++);
                    buf.append(ch);
                    if (ch != end) continue;
                    continue block0;
                }
                continue;
            }
            buf.append(ch);
        }
        if (buf.length() > 0) {
            lst.add(buf.toString());
        }
        if (gInsert != null) {
            this.fixTermOp(lst, "INSERT", "INTO", gInsert);
        }
        if (gDelete != null) {
            this.fixTermOp(lst, "DELETE", "FROM", gDelete);
        }
        buf.setLength(0);
        for (i = 0; i < lst.size(); ++i) {
            buf.append(lst.get(i));
        }
        return buf.toString();
    }

    private void fixTermOp(ArrayList<String> lst, String term, String subTerm, String addTerm) {
        boolean WITH_used = false;
        boolean subTerm_used = false;
        boolean GRAPH_used = false;
        int in_term = -1;
        int term_cb_start = -1;
        for (int i = 0; i < lst.size(); ++i) {
            String t = lst.get(i);
            if (t.equalsIgnoreCase("WITH") && in_term == -1) {
                WITH_used = true;
                continue;
            }
            if (t.equalsIgnoreCase(term)) {
                in_term = 0;
                continue;
            }
            if (t.equalsIgnoreCase(subTerm) && in_term == 0) {
                subTerm_used = true;
                continue;
            }
            if (t.equals("{")) {
                if (in_term >= 0) {
                    ++in_term;
                }
                if (in_term != 1) continue;
                term_cb_start = i;
                continue;
            }
            if (t.equals("}")) {
                if (in_term == 1) {
                    in_term = -1;
                    continue;
                }
                --in_term;
                continue;
            }
            if (!t.equalsIgnoreCase("GRAPH") || in_term != 1) continue;
            GRAPH_used = true;
        }
        if (!(addTerm == null || WITH_used || subTerm_used || GRAPH_used || term_cb_start == -1)) {
            lst.add(term_cb_start, " " + subTerm + addTerm);
        }
    }

    private synchronized void addToQuadStore(Resource subject, IRI predicate, Value object, Resource ... contexts) throws RepositoryException {
        if (contexts.length == 0) {
            return;
        }
        try {
            boolean isAutoCommit = this.getQuadStoreConnection().getAutoCommit();
            if (this.psInsert == null) {
                this.psInsert = this.prepareStatement(S_BATCH_INSERT, true);
            }
            if (!this.insertBNodeAsVirtuosoIRI) {
                if (this.psInsert_BNode == null) {
                    this.psInsert_BNode = this.prepareStatement(S_TTLP_INSERT, true);
                }
                Object bn_s = null;
                Object bn_o = null;
                if (subject instanceof BNode) {
                    bn_s = "_:" + ((BNode)subject).getID().replace(':', '_').replace('-', 'z').replace('/', 'y');
                }
                if (object instanceof BNode) {
                    bn_o = "_:" + ((BNode)object).getID().replace(':', '_').replace('-', 'z').replace('/', 'y');
                }
                if (bn_s != null || bn_o != null) {
                    this.addToQuadStore_BNode(bn_s != null ? bn_s : subject, predicate, bn_o != null ? bn_o : object, contexts);
                    this.psInsertBNodeCount += contexts.length;
                } else {
                    this.addToQuadStore_asURI(subject, predicate, object, contexts);
                    this.psInsertCount += contexts.length;
                }
            } else {
                this.addToQuadStore_asURI(subject, predicate, object, contexts);
                this.psInsertCount += contexts.length;
            }
            if (!isAutoCommit && this.useLazyAdd) {
                if (this.psInsertCount >= this.BATCH_SIZE || this.psInsertBNodeCount >= this.BATCH_SIZE) {
                    this.flushDelayAdd();
                }
            } else {
                this.flushDelayAdd();
            }
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    private synchronized void addToQuadStore_BNode(Object subject, IRI predicate, Object object, Resource ... contexts) throws RepositoryException {
        if (contexts.length == 0) {
            return;
        }
        this.verifyIsOpen();
        try {
            int transactional = this.quadStoreConnection.getAutoCommit() ? 0 : 1;
            for (Resource context : contexts) {
                String ctx = context.stringValue();
                StringBuilder sb = new StringBuilder(256);
                this.append(subject, sb, true);
                sb.append(' ');
                this.append(predicate, sb, true);
                sb.append(' ');
                this.append(object, sb, true);
                sb.append(" .\n");
                this.psInsert_BNode.setString(1, sb.toString());
                this.psInsert_BNode.setString(2, ctx);
                this.psInsert_BNode.setInt(3, transactional);
                this.psInsert_BNode.addBatch();
            }
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    private synchronized void addToQuadStore_asURI(Resource subject, IRI predicate, Value object, Resource ... contexts) throws RepositoryException {
        this.verifyIsOpen();
        try {
            for (Resource context : contexts) {
                this.bindParams(this.psInsert, subject, predicate, object, context);
                this.psInsert.addBatch();
            }
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    private void bindParams(PreparedStatement ps, Resource subject, IRI predicate, Value object, Resource context) throws SQLException, RepositoryException {
        int flags = 0;
        if (!this.insertBNodeAsVirtuosoIRI && object instanceof BNode) {
            flags = 15;
        }
        ps.setString(1, subject.toString());
        ps.setString(2, predicate.toString());
        if (object instanceof Resource) {
            ps.setString(3, object.toString());
            ps.setNull(4, 12);
            ps.setInt(5, flags);
        } else if (object instanceof Literal) {
            Literal lit = (Literal)object;
            Optional lang = lit.getLanguage();
            ps.setString(3, lit.getLabel());
            if (lang.isPresent()) {
                ps.setString(4, (String)lang.get());
                ps.setInt(5, 2);
            } else if (lit.getDatatype() != null) {
                IRI ltype = lit.getDatatype();
                if (!this.insertStringLiteralAsSimple || !ltype.equals((Object)XMLSchema.STRING)) {
                    ps.setString(4, ltype.toString());
                    ps.setInt(5, 3);
                } else {
                    ps.setNull(4, 12);
                    ps.setInt(5, 1);
                }
            } else {
                ps.setNull(4, 12);
                ps.setInt(5, 1);
            }
        } else {
            throw new RepositoryException("Unknown value type: " + object.getClass());
        }
        ps.setString(6, context.toString());
    }

    private synchronized PreparedStatement addToQuadStore_batch(PreparedStatement ps, Resource subject, IRI predicate, Value object, Resource ... contexts) throws RepositoryException {
        this.verifyIsOpen();
        try {
            if (ps == null) {
                ps = this.prepareStatement(S_BATCH_INSERT, true);
            }
            for (Resource context : contexts) {
                this.bindParams(ps, subject, predicate, object, context);
                ps.addBatch();
            }
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
        return ps;
    }

    private synchronized PreparedStatement flushDelayAdd_batch(PreparedStatement ps, int psCount) throws RepositoryException {
        block4: {
            try {
                if (psCount <= 0 || ps == null) break block4;
                ps.executeBatch();
                ps.clearBatch();
                if (!this.useReprepare) break block4;
                try {
                    ps.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ps = null;
            }
            catch (Exception e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        return ps;
    }

    private synchronized PreparedStatement dropDelayAdd_batch(PreparedStatement ps, int psCount) throws RepositoryException {
        block4: {
            try {
                if (psCount <= 0 || ps == null) break block4;
                ps.clearBatch();
                if (!this.useReprepare) break block4;
                try {
                    ps.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ps = null;
            }
            catch (Exception e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        return ps;
    }

    private synchronized void flushDelayAdd() throws RepositoryException {
        this.psInsert = this.flushDelayAdd_batch(this.psInsert, this.psInsertCount);
        this.psInsertCount = 0;
        if (this.psInsert_BNode != null && this.psInsertBNodeCount > 0) {
            try {
                this.psInsert_BNode.executeBatch();
                this.psInsert_BNode.clearBatch();
            }
            catch (Exception e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        this.psInsertBNodeCount = 0;
    }

    private synchronized void dropDelayAdd() throws RepositoryException {
        this.psInsert = this.dropDelayAdd_batch(this.psInsert, this.psInsertCount);
        this.psInsertCount = 0;
        if (this.psInsertBNodeCount > 0 && this.psInsert_BNode != null) {
            try {
                this.psInsert_BNode.clearBatch();
            }
            catch (Exception e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        this.psInsertBNodeCount = 0;
    }

    private void append(Object value, StringBuilder sb, boolean inTriplePattern) throws RepositoryException {
        if (value instanceof Resource) {
            this.append((Resource)value, sb, inTriplePattern);
        } else if (value instanceof Literal) {
            this.append((Literal)value, sb, inTriplePattern);
        } else if (value instanceof String) {
            sb.append((String)value);
        } else {
            throw new RepositoryException("Unknown value type: " + value.getClass());
        }
    }

    private void append(Resource resource, StringBuilder sb, boolean inTriplePattern) throws RepositoryException {
        if (resource instanceof IRI) {
            this.append((IRI)resource, sb, inTriplePattern);
        } else if (resource instanceof BNode) {
            this.append((BNode)resource, sb, inTriplePattern);
        } else {
            throw new RepositoryException("Unknown resource type: " + resource.getClass());
        }
    }

    private void append(IRI uri, StringBuilder sb, boolean inTriplePattern) throws RepositoryException {
        sb.append("<");
        this.escapeString(uri.toString(), sb);
        sb.append(">");
    }

    private void append(BNode bNode, StringBuilder sb, boolean inTriplePattern) throws RepositoryException {
        String bid = bNode.getID();
        if (bid.startsWith("nodeID://")) {
            if (inTriplePattern) {
                sb.append("`");
            }
            sb.append("iri('");
            sb.append(bid);
            sb.append("')");
            if (inTriplePattern) {
                sb.append("`");
            }
        } else if (this.insertBNodeAsVirtuosoIRI) {
            sb.append("<");
            sb.append(bNode.toString());
            sb.append(">");
        } else {
            sb.append(bNode.toString());
        }
    }

    private void append(Literal lit, StringBuilder sb, boolean inTriplePattern) throws RepositoryException {
        sb.append("\"");
        this.escapeString(lit.getLabel(), sb);
        sb.append("\"");
        if (lit.getDatatype() != null) {
            IRI ltype = lit.getDatatype();
            if (!this.insertStringLiteralAsSimple || !ltype.equals((Object)XMLSchema.STRING)) {
                sb.append("^^");
                this.append(ltype, sb, inTriplePattern);
            }
        } else if (lit.getLanguage() != null) {
            sb.append("@");
            sb.append(lit.getLanguage());
        }
    }

    private String BNode2String(BNode bNode) {
        String bid = bNode.getID();
        if (bid.startsWith("nodeID://")) {
            return bid;
        }
        return bNode.toString();
    }

    private void escapeString(String label, StringBuilder sb) throws RepositoryException {
        int labelLength = label.length();
        for (int i = 0; i < labelLength; ++i) {
            char c;
            char cInt = c = label.charAt(i);
            if (c == '\\') {
                sb.append("\\\\");
                continue;
            }
            if (c == '\"') {
                sb.append("\\\"");
                continue;
            }
            if (c == '\n') {
                sb.append("\\n");
                continue;
            }
            if (c == '\r') {
                sb.append("\\r");
                continue;
            }
            if (c == '\t') {
                sb.append("\\t");
                continue;
            }
            if (cInt >= '\u0000' && cInt <= '\b' || cInt == '\u000b' || cInt == '\f' || cInt >= '\u000e' && cInt <= '\u001f' || cInt >= '\u007f' && cInt <= '\uffff') {
                sb.append("\\u");
                sb.append(this.toHexString(cInt, 4));
                continue;
            }
            if (cInt >= '\u10000' && cInt <= '\u10ffff') {
                sb.append("\\U");
                sb.append(this.toHexString(cInt, 8));
                continue;
            }
            sb.append(c);
        }
    }

    private String toHexString(int decimal, int stringLength) {
        StringBuilder sb = new StringBuilder(stringLength);
        String hexVal = Integer.toHexString(decimal).toUpperCase();
        int nofZeros = stringLength - hexVal.length();
        for (int i = 0; i < nofZeros; ++i) {
            sb.append('0');
        }
        sb.append(hexVal);
        return sb.toString();
    }

    private void clearQuadStore(Resource[] contexts) throws RepositoryException {
        if (contexts != null && contexts.length > 0) {
            try {
                Object[] graphs = new String[contexts.length];
                PreparedStatement ps = this.prepareStatement(S_CLEAR_GRAPH, true);
                for (int i = 0; i < contexts.length; ++i) {
                    graphs[i] = contexts[i].stringValue();
                }
                Array gArray = this.quadStoreConnection.createArrayOf("VARCHAR", graphs);
                ps.setArray(1, gArray);
                ps.executeUpdate();
                ps.close();
                gArray.free();
            }
            catch (Exception e) {
                throw new RepositoryException((Throwable)e);
            }
        }
    }

    private CloseableIteration<Statement, RepositoryException> selectFromQuadStore(Resource subject, IRI predicate, Value object, boolean includeInferred, boolean hasOnly, Resource ... contexts) throws RepositoryException {
        PreparedStatement ps;
        this.verifyIsOpen();
        this.flushDelayAdd();
        ResultSet rs = null;
        StringBuilder query = new StringBuilder("sparql ");
        if (includeInferred && this.ruleSet != null && this.ruleSet.length() > 0) {
            query.append("define input:inference '" + this.ruleSet + "' ");
        }
        if (includeInferred && this.macroLib != null && this.macroLib.length() > 0) {
            query.append("define input:macro-lib <" + this.macroLib + ">\n ");
        }
        query.append("select * ");
        for (Resource context : contexts) {
            query.append("from named <");
            query.append(context.toString());
            query.append("> ");
        }
        query.append("where { graph ?g {");
        query.append(' ');
        if (subject != null) {
            query.append("`iri(??)`");
        } else {
            query.append("?s");
        }
        query.append(' ');
        if (predicate != null) {
            query.append("`iri(??)`");
        } else {
            query.append("?p");
        }
        query.append(' ');
        if (object != null) {
            query.append("`bif:__rdf_long_from_batch_params(??,??,??)`");
        } else {
            query.append("?o");
        }
        query.append(" }}");
        if (hasOnly) {
            query.append(" LIMIT 1");
        }
        try {
            ps = this.prepareStatement(query.toString(), false);
            int col = 1;
            if (subject != null) {
                this.bindResource(ps, col++, subject);
            }
            if (predicate != null) {
                this.bindURI(ps, col++, predicate);
            }
            if (object != null) {
                this.bindValue(ps, col, object);
            }
            rs = ps.executeQuery();
        }
        catch (Exception e) {
            throw new RepositoryException(this.getClass().getCanonicalName() + ": SPARQL execute failed." + "\n" + query.toString() + "[" + e + "]", (Throwable)e);
        }
        return new CloseableIterationStmt(ps, rs, subject, predicate, object);
    }

    private void removeData(Map<String, StringBuilder> data) throws RepositoryException {
        java.sql.Statement stmt = null;
        try {
            stmt = this.createStatement(-1, true);
            for (Map.Entry<String, StringBuilder> e : data.entrySet()) {
                StringBuilder sb = new StringBuilder(256);
                sb.append("sparql define output:format '_JAVA_' DELETE FROM <");
                sb.append(e.getKey());
                sb.append("> { ");
                sb.append(e.getValue().toString());
                sb.append(" }");
                stmt.execute(sb.toString());
            }
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private void removeContext(Resource subject, IRI predicate, Value object, Resource context) throws RepositoryException {
        try {
            if (subject == null && predicate == null && object == null && context != null) {
                String query = "sparql clear graph iri(??)";
                PreparedStatement ps = this.prepareStatement(query, true);
                ps.setString(1, context.toString());
                ps.execute();
                ps.close();
            } else if (subject != null && predicate != null && object != null && context != null) {
                PreparedStatement ps = this.prepareStatement(S_DELETE, true);
                ps.setString(1, context.toString());
                this.bindResource(ps, 2, subject);
                this.bindURI(ps, 3, predicate);
                this.bindValue(ps, 4, object);
                ps.execute();
                ps.close();
            } else {
                if (context == null) {
                    throw new RepositoryException("Context can't be NULL");
                }
                StringBuilder stm = new StringBuilder();
                stm.append(' ');
                if (subject != null) {
                    stm.append("`iri(??)`");
                } else {
                    stm.append("?s");
                }
                stm.append(' ');
                if (predicate != null) {
                    stm.append("`iri(??)`");
                } else {
                    stm.append("?p");
                }
                stm.append(' ');
                if (object != null) {
                    stm.append("`bif:__rdf_long_from_batch_params(??,??,??)`");
                } else {
                    stm.append("?o");
                }
                String query = "sparql delete from <" + context + "> { " + stm.toString() + " } where { " + stm.toString() + " }";
                PreparedStatement ps = this.prepareStatement(query, true);
                int col = 1;
                if (subject != null) {
                    this.bindResource(ps, col++, subject);
                }
                if (predicate != null) {
                    this.bindURI(ps, col++, predicate);
                }
                if (object != null) {
                    this.bindValue(ps, col, object);
                    col += 3;
                }
                if (subject != null) {
                    this.bindResource(ps, col++, subject);
                }
                if (predicate != null) {
                    this.bindURI(ps, col++, predicate);
                }
                if (object != null) {
                    this.bindValue(ps, col, object);
                }
                ps.execute();
                ps.close();
            }
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    private void bindResource(PreparedStatement ps, int col, Resource n) throws SQLException {
        if (n == null) {
            return;
        }
        if (n instanceof BNode) {
            ps.setString(col, this.BNode2String((BNode)n));
        } else {
            ps.setString(col, n.toString());
        }
    }

    private void bindURI(PreparedStatement ps, int col, IRI n) throws SQLException {
        if (n == null) {
            return;
        }
        ps.setString(col, n.toString());
    }

    private void bindValue(PreparedStatement ps, int col, Value n) throws SQLException {
        if (n == null) {
            return;
        }
        if (n instanceof IRI) {
            ps.setInt(col, 1);
            ps.setString(col + 1, n.toString());
            ps.setNull(col + 2, 12);
        } else if (n instanceof BNode) {
            ps.setInt(col, 1);
            ps.setString(col + 1, this.BNode2String((BNode)n));
            ps.setNull(col + 2, 12);
        } else if (n instanceof Literal) {
            Literal lit = (Literal)n;
            Optional lang = lit.getLanguage();
            if (lang.isPresent()) {
                ps.setInt(col, 5);
                ps.setString(col + 1, lit.getLabel());
                ps.setString(col + 2, (String)lang.get());
            } else if (lit.getDatatype() != null) {
                IRI ltype = lit.getDatatype();
                if (!this.insertStringLiteralAsSimple || !ltype.equals((Object)XMLSchema.STRING)) {
                    ps.setInt(col, 4);
                    ps.setString(col + 1, lit.getLabel());
                    ps.setString(col + 2, ltype.toString());
                } else {
                    ps.setInt(col, 3);
                    ps.setString(col + 1, lit.getLabel());
                    ps.setNull(col + 2, 12);
                }
            } else {
                ps.setInt(col, 3);
                ps.setString(col + 1, lit.getLabel());
                ps.setNull(col + 2, 12);
            }
        } else {
            ps.setInt(col, 3);
            ps.setString(col + 1, n.toString());
            ps.setNull(col + 2, 12);
        }
    }

    private String stringForValue(Value n, boolean inTriplePattern) throws RepositoryException {
        StringBuilder sb = new StringBuilder(256);
        this.append(n, sb, inTriplePattern);
        return sb.toString();
    }

    private Value castValue(Object val) throws RepositoryException {
        if (val == null) {
            return null;
        }
        if (val instanceof ExtendedString) {
            ExtendedString ves = (ExtendedString)val;
            String valueString = ves.toString();
            if (ves.getIriType() == 1 && (ves.getStrType() & 1) == 1) {
                if (valueString.startsWith("_:")) {
                    valueString = valueString.substring(2);
                    return this.valueFactory.createBNode(valueString);
                }
                try {
                    if (valueString.indexOf(58) < 0) {
                        return this.valueFactory.createIRI(":" + valueString);
                    }
                    return this.valueFactory.createIRI(valueString);
                }
                catch (IllegalArgumentException iaex) {
                    throw new RepositoryException("VirtuosoRepositoryConnection().castValue() Invalid value from Virtuoso: \"" + valueString + "\"", (Throwable)iaex);
                }
            }
            if (ves.getIriType() == 2) {
                try {
                    return this.valueFactory.createBNode(valueString);
                }
                catch (IllegalArgumentException iaex) {
                    throw new RepositoryException("VirtuosoRepositoryConnection().castValue() Invalid value from Virtuoso: \"" + valueString + "\"", (Throwable)iaex);
                }
            }
            try {
                return this.valueFactory.createLiteral(valueString);
            }
            catch (IllegalArgumentException iaex) {
                throw new RepositoryException("VirtuosoRepositoryConnection().castValue() Invalid value from Virtuoso: \"" + valueString + "\", STRTYPE = " + ves.getIriType(), (Throwable)iaex);
            }
        }
        if (val instanceof RdfBox) {
            RdfBox rb = (RdfBox)val;
            String rb_val = rb.toString();
            if (rb.getLang() != null) {
                return this.valueFactory.createLiteral(rb_val, rb.getLang());
            }
            if (rb.getType() != null) {
                String rb_type = rb.getType();
                if (rb_val.length() == 1 && (rb_val.charAt(0) == '1' || rb_val.charAt(0) == '0') && rb_type.equals("http://www.w3.org/2001/XMLSchema#boolean")) {
                    return this.valueFactory.createLiteral(rb_val.charAt(0) == '1' ? "true" : "false");
                }
                return this.valueFactory.createLiteral(rb_val, this.valueFactory.createIRI(rb_type));
            }
            return this.getRepository().getValueFactory().createLiteral(rb_val);
        }
        if (val instanceof Long) {
            return this.valueFactory.createLiteral(((Long)val).longValue());
        }
        if (val instanceof Integer) {
            return this.valueFactory.createLiteral(((Integer)val).intValue());
        }
        if (val instanceof Short) {
            return this.valueFactory.createLiteral(((Short)val).intValue());
        }
        if (val instanceof Float) {
            return this.valueFactory.createLiteral(((Float)val).floatValue());
        }
        if (val instanceof Double) {
            return this.valueFactory.createLiteral(((Double)val).doubleValue());
        }
        if (val instanceof BigDecimal) {
            IRI type = this.valueFactory.createIRI("http://www.w3.org/2001/XMLSchema#decimal");
            return this.valueFactory.createLiteral(val.toString(), type);
        }
        if (val instanceof Blob) {
            IRI type = this.valueFactory.createIRI("http://www.w3.org/2001/XMLSchema#hexBinary");
            return this.valueFactory.createLiteral(val.toString(), type);
        }
        if (val instanceof VirtuosoDate) {
            IRI type = this.valueFactory.createIRI("http://www.w3.org/2001/XMLSchema#date");
            return this.valueFactory.createLiteral(((VirtuosoDate)val).toXSD_String(), type);
        }
        if (val instanceof VirtuosoTimestamp) {
            IRI type = this.valueFactory.createIRI("http://www.w3.org/2001/XMLSchema#dateTime");
            return this.valueFactory.createLiteral(((VirtuosoTimestamp)val).toXSD_String(), type);
        }
        if (val instanceof VirtuosoTime) {
            IRI type = this.valueFactory.createIRI("http://www.w3.org/2001/XMLSchema#time");
            return this.valueFactory.createLiteral(((VirtuosoTime)val).toXSD_String(), type);
        }
        if (val instanceof Date) {
            IRI type = this.valueFactory.createIRI("http://www.w3.org/2001/XMLSchema#date");
            return this.valueFactory.createLiteral(val.toString(), type);
        }
        if (val instanceof Timestamp) {
            IRI type = this.valueFactory.createIRI("http://www.w3.org/2001/XMLSchema#dateTime");
            return this.valueFactory.createLiteral(this.Timestamp2String((Timestamp)val), type);
        }
        if (val instanceof Time) {
            IRI type = this.valueFactory.createIRI("http://www.w3.org/2001/XMLSchema#time");
            return this.valueFactory.createLiteral(val.toString(), type);
        }
        try {
            return this.getRepository().getValueFactory().createLiteral(val.toString());
        }
        catch (IllegalArgumentException iaex2) {
            throw new RepositoryException("VirtuosoRepositoryConnection().castValue() Could not parse resource: " + val, (Throwable)iaex2);
        }
    }

    protected <E> RepositoryResult<E> createRepositoryResult(Iterable<? extends E> elements) {
        return new RepositoryResult((CloseableIteration)new CloseableIteratorIteration(elements.iterator()));
    }

    private void verifyIsOpen() throws RepositoryException {
        try {
            if (this.getQuadStoreConnection().isClosed()) {
                throw new IllegalStateException("Connection has been closed");
            }
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    protected void verifyNotTxnActive(String msg) throws RepositoryException {
        if (!this.isAutoCommit()) {
            throw new RepositoryException(msg);
        }
    }

    private String Timestamp2String(Timestamp v) {
        String nanosString;
        GregorianCalendar cal = new GregorianCalendar();
        int timezone = cal.get(15) / 60000;
        StringBuilder sb = new StringBuilder();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        Object timeZoneString = null;
        String zeros = "000000000";
        int nanos = v.getNanos();
        sb.append(formatter.format(v));
        if (nanos == 0) {
            nanosString = "";
        } else {
            nanosString = Integer.toString(nanos);
            nanosString = zeros.substring(0, 9 - nanosString.length()) + nanosString;
            char[] nanosChar = new char[nanosString.length()];
            nanosString.getChars(0, nanosString.length(), nanosChar, 0);
            int truncIndex = 8;
            while (nanosChar[truncIndex] == '0') {
                --truncIndex;
            }
            nanosString = new String(nanosChar, 0, truncIndex + 1);
        }
        if (nanosString.length() > 0) {
            sb.append(".");
            sb.append(nanosString);
        }
        sb.append(timezone > 0 ? (char)'+' : '-');
        int tz = Math.abs(timezone);
        int tzh = tz / 60;
        int tzm = tz % 60;
        if (tzh < 10) {
            sb.append('0');
        }
        sb.append(tzh);
        sb.append(':');
        if (tzm < 10) {
            sb.append('0');
        }
        sb.append(tzm);
        return sb.toString();
    }

    static /* synthetic */ Resource[] access$000(VirtuosoRepositoryConnection x0, Resource[] x1) throws RepositoryException {
        return x0.checkDMLContext(x1);
    }

    public class CloseableIterationGraphResult
    extends CloseableIterationBase<Statement, QueryEvaluationException> {
        int col_g;
        int col_s;
        int col_p;
        int col_o;

        public CloseableIterationGraphResult(java.sql.Statement stmt, ResultSet rs) throws QueryEvaluationException {
            super(stmt, rs, null, null, null);
            this.col_g = -1;
            this.col_s = -1;
            this.col_p = -1;
            this.col_o = -1;
            try {
                ResultSetMetaData rsmd = rs.getMetaData();
                for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                    String label = rsmd.getColumnName(i);
                    if (label.equalsIgnoreCase("G")) {
                        this.col_g = i;
                        continue;
                    }
                    if (label.equalsIgnoreCase("S")) {
                        this.col_s = i;
                        continue;
                    }
                    if (label.equalsIgnoreCase("P")) {
                        this.col_p = i;
                        continue;
                    }
                    if (!label.equalsIgnoreCase("O")) continue;
                    this.col_o = i;
                }
            }
            catch (Exception e) {
                throw this.createException(e);
            }
        }

        @Override
        protected QueryEvaluationException createException(Exception e) {
            return new QueryEvaluationException((Throwable)e);
        }

        @Override
        protected void extractRow() throws Exception {
            Resource sval = null;
            IRI pval = null;
            Value oval = null;
            Resource gval = null;
            if (this.col_s != -1) {
                sval = (Resource)VirtuosoRepositoryConnection.this.castValue(this.v_rs.getObject(this.col_s));
            }
            if (this.col_p != -1) {
                pval = (IRI)VirtuosoRepositoryConnection.this.castValue(this.v_rs.getObject(this.col_p));
            }
            if (this.col_o != -1) {
                oval = VirtuosoRepositoryConnection.this.castValue(this.v_rs.getObject(this.col_o));
            }
            if (this.col_g != -1) {
                gval = (Resource)VirtuosoRepositoryConnection.this.castValue(this.v_rs.getObject(this.col_g));
            }
            this.v_row = VirtuosoRepositoryConnection.this.valueFactory.createStatement(sval, pval, oval, gval);
        }
    }

    public class CloseableIterationBindingSet
    extends CloseableIterationBase<BindingSet, QueryEvaluationException> {
        ResultSetMetaData rsmd;

        public CloseableIterationBindingSet(java.sql.Statement stmt, ResultSet rs) throws QueryEvaluationException {
            super(stmt, rs, null, null, null);
            try {
                this.rsmd = rs.getMetaData();
            }
            catch (Exception e) {
                throw this.createException(e);
            }
        }

        @Override
        protected QueryEvaluationException createException(Exception e) {
            return new QueryEvaluationException((Throwable)e);
        }

        @Override
        protected void extractRow() throws Exception {
            this.v_row = new QueryBindingSet();
            for (int i = 1; i <= this.rsmd.getColumnCount(); ++i) {
                String col = this.rsmd.getColumnName(i);
                Object val = this.v_rs.getObject(i);
                if (val == null) continue;
                Value v = VirtuosoRepositoryConnection.this.castValue(val);
                ((QueryBindingSet)this.v_row).setBinding(col, v);
            }
        }
    }

    public class CloseableIterationStmt
    extends CloseableIterationBase<Statement, RepositoryException> {
        int col_g;
        int col_s;
        int col_p;
        int col_o;

        public CloseableIterationStmt(java.sql.Statement stmt, ResultSet rs, Resource subject, IRI predicate, Value object) throws RepositoryException {
            super(stmt, rs, subject, predicate, object);
            this.col_g = -1;
            this.col_s = -1;
            this.col_p = -1;
            this.col_o = -1;
            try {
                ResultSetMetaData rsmd = rs.getMetaData();
                for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                    String label = rsmd.getColumnName(i);
                    if (label.equalsIgnoreCase("g")) {
                        this.col_g = i;
                        continue;
                    }
                    if (label.equalsIgnoreCase("s")) {
                        this.col_s = i;
                        continue;
                    }
                    if (label.equalsIgnoreCase("p")) {
                        this.col_p = i;
                        continue;
                    }
                    if (!label.equalsIgnoreCase("o")) continue;
                    this.col_o = i;
                }
            }
            catch (Exception e) {
                throw this.createException(e);
            }
        }

        @Override
        protected RepositoryException createException(Exception e) {
            return new RepositoryException((Throwable)e);
        }

        @Override
        protected void extractRow() throws Exception {
            Resource _graph = null;
            Resource _subject = this.subject;
            IRI _predicate = this.predicate;
            Value _object = this.object;
            Object val = null;
            try {
                if (this.col_g != -1) {
                    val = this.v_rs.getObject(this.col_g);
                    _graph = (Resource)VirtuosoRepositoryConnection.this.castValue(val);
                }
            }
            catch (ClassCastException ccex) {
                throw new RepositoryException("Unexpected resource type encountered. Was expecting Resource: " + val, (Throwable)ccex);
            }
            if (_subject == null && this.col_s != -1) {
                try {
                    val = this.v_rs.getObject(this.col_s);
                    _subject = (Resource)VirtuosoRepositoryConnection.this.castValue(val);
                }
                catch (ClassCastException ccex) {
                    throw new RepositoryException("Unexpected resource type encountered. Was expecting Resource: " + val, (Throwable)ccex);
                }
            }
            if (_predicate == null && this.col_p != -1) {
                try {
                    val = this.v_rs.getObject(this.col_p);
                    _predicate = (IRI)VirtuosoRepositoryConnection.this.castValue(val);
                }
                catch (ClassCastException ccex) {
                    throw new RepositoryException("Unexpected resource type encountered. Was expecting URI: " + val, (Throwable)ccex);
                }
            }
            if (_object == null && this.col_o != -1) {
                _object = VirtuosoRepositoryConnection.this.castValue(this.v_rs.getObject(this.col_o));
            }
            this.v_row = VirtuosoRepositoryConnection.this.valueFactory.createStatement(_subject, _predicate, _object, _graph);
        }
    }

    public abstract class CloseableIterationBase<E, X extends Exception>
    implements CloseableIteration<E, X> {
        E v_row;
        boolean v_finished = false;
        boolean v_prefetched = false;
        Resource subject;
        IRI predicate;
        Value object;
        ResultSet v_rs;
        java.sql.Statement v_stmt;

        public CloseableIterationBase(java.sql.Statement stmt, ResultSet rs, Resource subject, IRI predicate, Value object) {
            this.v_stmt = stmt;
            this.v_rs = rs;
            this.subject = subject;
            this.predicate = predicate;
            this.object = object;
        }

        protected abstract X createException(Exception var1);

        public boolean hasNext() throws X {
            if (!this.v_finished && !this.v_prefetched) {
                this.moveForward();
            }
            return !this.v_finished;
        }

        public E next() throws X {
            if (!this.v_finished && !this.v_prefetched) {
                this.moveForward();
            }
            this.v_prefetched = false;
            if (this.v_finished) {
                throw new NoSuchElementException();
            }
            return this.v_row;
        }

        public void remove() throws X {
            throw new UnsupportedOperationException();
        }

        public void close() throws X {
            if (!this.v_finished) {
                try {
                    this.v_rs.close();
                    this.v_stmt.close();
                }
                catch (SQLException e) {
                    throw this.createException(e);
                }
            }
            this.v_finished = true;
        }

        protected void finalize() throws Throwable {
            super.finalize();
            if (!this.v_finished) {
                try {
                    this.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        protected void moveForward() throws X {
            try {
                if (!this.v_finished && this.v_rs.next()) {
                    this.extractRow();
                    this.v_prefetched = true;
                } else {
                    this.close();
                }
            }
            catch (Exception e) {
                throw this.createException(e);
            }
        }

        protected abstract void extractRow() throws Exception;
    }
}

