/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc4;

public class VirtuosoPoolStatistic
implements Cloneable {
    protected String name;
    protected volatile int conn_unUsed;
    protected volatile int connIn_Use;
    protected volatile int cacheSize = 0;
    protected volatile int _hits = 0;
    protected volatile int _misses = 0;
    protected volatile long _max_wtime = 0L;
    protected volatile long _min_wtime = 0L;
    protected volatile long _cum_wtime = 0L;

    protected VirtuosoPoolStatistic() {
    }

    protected void setCacheParam(String _name, int _cacheSize, int _conn_unUsed, int _connIn_Use) {
        this.name = _name;
        this.cacheSize = _cacheSize;
        this.conn_unUsed = _conn_unUsed;
        this.connIn_Use = _connIn_Use;
    }

    protected void setWaitingTime(long tm) {
        if (this._min_wtime == 0L || tm < this._min_wtime) {
            this._min_wtime = tm;
        }
        if (tm > this._max_wtime) {
            this._max_wtime = tm;
        }
        this._cum_wtime += tm;
    }

    protected synchronized Object clone() {
        try {
            VirtuosoPoolStatistic v = (VirtuosoPoolStatistic)super.clone();
            v._hits = this._hits;
            v._misses = this._misses;
            v._max_wtime = this._max_wtime;
            v._min_wtime = this._min_wtime;
            v._cum_wtime = this._cum_wtime;
            return v;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public int getHits() {
        return this._hits;
    }

    public int getMisses() {
        return this._misses;
    }

    public long getMaxWaitTime() {
        return this._max_wtime;
    }

    public long getMinWaitTime() {
        return this._min_wtime;
    }

    public long getCumWaitTime() {
        return this._cum_wtime;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public int getConnsInUse() {
        return this.connIn_Use;
    }

    public int getConnsUnUsed() {
        return this.conn_unUsed;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(128);
        buf.append("--------------------------------------\n");
        buf.append("  ** Cache Statistics for the [" + this.name + "] **\n");
        buf.append("--------------------------------------\n");
        buf.append(" connection's cacheSize= ");
        buf.append(this.cacheSize);
        buf.append('\n');
        buf.append("      used connections = ");
        buf.append(this.connIn_Use);
        buf.append('\n');
        buf.append("    unused connections = ");
        buf.append(this.conn_unUsed);
        buf.append('\n');
        buf.append("      total cache hits = ");
        buf.append(this._hits);
        buf.append('\n');
        buf.append("    total cache misses = ");
        buf.append(this._misses);
        buf.append('\n');
        buf.append(" min waiting time (millisec)= ");
        buf.append(this._min_wtime);
        buf.append('\n');
        buf.append(" max waiting time (millisec)= ");
        buf.append(this._max_wtime);
        buf.append('\n');
        buf.append(" avg waiting time (millisec)= ");
        buf.append(this._misses == 0 ? 0L : this._cum_wtime / (long)this._misses);
        buf.append('\n');
        return buf.toString();
    }
}

