/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jena.driver;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.update.UpdateException;
import org.apache.jena.util.FileUtils;
import virtuoso.jena.driver.VirtDataset;
import virtuoso.jena.driver.VirtGraph;
import virtuoso.jena.driver.VirtuosoUpdateRequest;

public class VirtuosoUpdateFactory {
    private VirtuosoUpdateFactory() {
    }

    public static VirtuosoUpdateRequest create(String query, VirtGraph graph) {
        return new VirtuosoUpdateRequest(query, graph);
    }

    public static VirtuosoUpdateRequest create(String query, Dataset dataset) {
        VirtuosoUpdateFactory.checkNotNull(dataset, "dataset is a null pointer");
        VirtuosoUpdateFactory.checkNotNull(query, "query string is null");
        if (dataset instanceof VirtDataset) {
            return new VirtuosoUpdateRequest(query, (VirtGraph)dataset);
        }
        throw new UpdateException("Only VirtDataset is supported");
    }

    public static VirtuosoUpdateRequest create(String queryStr, Model model) {
        VirtuosoUpdateFactory.checkNotNull(model, "model is a null pointer");
        VirtuosoUpdateFactory.checkNotNull(queryStr, "query string is null");
        if (model.getGraph() instanceof VirtGraph) {
            return new VirtuosoUpdateRequest(queryStr, (VirtGraph)model.getGraph());
        }
        throw new UpdateException("Only VirtModel is supported");
    }

    public static VirtuosoUpdateRequest read(String fileName, VirtGraph graph) {
        InputStream in = null;
        if (fileName.equals("-")) {
            in = System.in;
        } else {
            try {
                in = new FileInputStream(fileName);
            }
            catch (FileNotFoundException ex) {
                throw new UpdateException("File nout found: " + fileName);
            }
        }
        return VirtuosoUpdateFactory.read(in, graph);
    }

    public static VirtuosoUpdateRequest read(InputStream in, VirtGraph graph) {
        BufferedReader r = FileUtils.asBufferedUTF8((InputStream)in);
        StringBuffer b = new StringBuffer();
        try {
            char ch;
            while ((ch = (char)((Reader)r).read()) != '\uffffffff') {
                b.append(ch);
            }
        }
        catch (Exception e) {
            throw new UpdateException((Throwable)e);
        }
        return new VirtuosoUpdateRequest(b.toString(), graph);
    }

    private static void checkNotNull(Object obj, String msg) {
        if (obj == null) {
            throw new IllegalArgumentException(msg);
        }
    }
}

