/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jena.driver;

import com.hp.hpl.jena.graph.impl.TransactionHandlerBase;
import com.hp.hpl.jena.shared.JenaException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import virtuoso.jena.driver.VirtGraph;

public class VirtTransactionHandler
extends TransactionHandlerBase
implements XAResource {
    private VirtGraph graph = null;
    private Boolean m_transactionsSupported = null;

    public VirtTransactionHandler(VirtGraph _graph) {
        this.graph = _graph;
    }

    public boolean transactionsSupported() {
        if (this.m_transactionsSupported != null) {
            return this.m_transactionsSupported;
        }
        try {
            Connection c = this.graph.getConnection();
            if (c != null) {
                this.m_transactionsSupported = new Boolean(c.getMetaData().supportsMultipleTransactions());
                return this.m_transactionsSupported;
            }
        }
        catch (Exception e) {
            throw new JenaException((Throwable)e);
        }
        return false;
    }

    private XAResource checkXA() {
        if (!this.graph.isXA) {
            throw new JenaException("XA Transaction is supported only for XAConnections");
        }
        return this.graph.getXAResource();
    }

    private void checkNotXA(String cmd) {
        if (this.graph.isXA) {
            throw new JenaException("Method '" + cmd + "' doesn't work with XAConnection");
        }
    }

    public boolean transactionsXASupported() {
        return this.graph.isXA;
    }

    @Override
    public void start(Xid xid, int i) throws XAException {
        XAResource xa = this.checkXA();
        xa.start(xid, i);
    }

    @Override
    public void commit(Xid xid, boolean flag) throws XAException {
        XAResource xa = this.checkXA();
        xa.commit(xid, flag);
        if (this.graph.resetBNodesDictAfterCommit) {
            this.graph.dropBNodesDict();
        }
    }

    @Override
    public void end(Xid xid, int i) throws XAException {
        XAResource xa = this.checkXA();
        xa.end(xid, i);
        if (this.graph.resetBNodesDictAfterCommit) {
            this.graph.dropBNodesDict();
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        XAResource xa = this.checkXA();
        xa.forget(xid);
        if (this.graph.resetBNodesDictAfterCommit) {
            this.graph.dropBNodesDict();
        }
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        XAResource xa = this.checkXA();
        return xa.prepare(xid);
    }

    @Override
    public Xid[] recover(int i) throws XAException {
        XAResource xa = this.checkXA();
        return xa.recover(i);
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        XAResource xa = this.checkXA();
        xa.rollback(xid);
        if (this.graph.resetBNodesDictAfterCommit) {
            this.graph.dropBNodesDict();
        }
    }

    @Override
    public boolean setTransactionTimeout(int i) throws XAException {
        XAResource xa = this.checkXA();
        return xa.setTransactionTimeout(i);
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        XAResource xa = this.checkXA();
        return xa.getTransactionTimeout();
    }

    @Override
    public boolean isSameRM(XAResource tr) throws XAException {
        XAResource xa = this.checkXA();
        if (tr instanceof VirtTransactionHandler) {
            return xa.isSameRM(((VirtTransactionHandler)tr).checkXA());
        }
        return xa.isSameRM(tr);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void begin() {
        this.checkNotXA("begin");
        if (this.transactionsSupported()) {
            try {
                Connection c = this.graph.getConnection();
                if (c.getTransactionIsolation() != 2) {
                    c.setTransactionIsolation(2);
                }
                if (!c.getAutoCommit()) return;
                c.setAutoCommit(false);
                return;
            }
            catch (SQLException e) {
                throw new JenaException("Transaction begin failed: ", (Throwable)e);
            }
        } else {
            this.notSupported("begin transaction");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void abort() {
        this.checkNotXA("abort");
        if (this.transactionsSupported()) {
            try {
                Connection c = this.graph.getConnection();
                c.rollback();
                c.setAutoCommit(true);
                if (!this.graph.resetBNodesDictAfterCommit) return;
                this.graph.dropBNodesDict();
                return;
            }
            catch (SQLException e) {
                throw new JenaException("Transaction rollback failed: ", (Throwable)e);
            }
        } else {
            this.notSupported("abort transaction");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void commit() {
        this.checkNotXA("commit");
        if (this.transactionsSupported()) {
            try {
                Connection c = this.graph.getConnection();
                c.commit();
                c.setAutoCommit(true);
                if (!this.graph.resetBNodesDictAfterCommit) return;
                this.graph.dropBNodesDict();
                return;
            }
            catch (SQLException e) {
                throw new JenaException("Transaction commit failed: ", (Throwable)e);
            }
        } else {
            this.notSupported("commit transaction");
        }
    }

    private void notSupported(String opName) {
        throw new UnsupportedOperationException(opName);
    }
}

