/* arm.v4a-linux.elf-so_fold.h
   created from arm.v4a-linux.elf-so_fold.bin, 26593 (0x67e1) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2023 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2023 Laszlo Molnar
   Copyright (C) 2000-2023 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */

/* clang-format off */

#define STUB_ARM_V4A_LINUX_ELF_SO_FOLD_SIZE    26593
#define STUB_ARM_V4A_LINUX_ELF_SO_FOLD_ADLER32 0x933c1b26
#define STUB_ARM_V4A_LINUX_ELF_SO_FOLD_CRC32   0x06e48264

unsigned char stub_arm_v4a_linux_elf_so_fold[26593] = {
/* 0x0000 */ 127, 69, 76, 70,  1,  1,  1, 97,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   1,  0, 40,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */  64, 29,  0,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,  0,
/* 0x0030 */  27,  0, 24,  0,  2,220, 77,226, 13, 32,160,225,254,255,255,235,
/* 0x0040 */   2,220,141,226,  0,224,160,225,  3,  0,189,232, 91,112,160,227,
/* 0x0050 */  14,240,160,225, 15,  0,160,225, 14,240,160,225,  0,112,160,227,
/* 0x0060 */   0,192,160,227,  4,240, 18,229,240,  1,240,231, 14,240,160,225,
/* 0x0070 */   1,  0,144,239,  3,  0,144,239, 14,240,160,225,  4,  0,144,239,
/* 0x0080 */  14,240,160,225, 19,  0,144,239, 14,240,160,225,  5,  0,144,239,
/* 0x0090 */  14,240,160,225,  6,  0,144,239, 14,240,160,225, 10,  0,144,239,
/* 0x00a0 */  14,240,160,225, 20,  0,144,239, 14,240,160,225, 45,  0,144,239,
/* 0x00b0 */  14,240,160,225, 85,  0,144,239, 14,240,160,225, 93,  0,144,239,
/* 0x00c0 */  14,240,160,225,129,  1,144,239, 14,240,160,225,  2, 64, 64,  0,
/* 0x00d0 */ 192,  1,  0,  0, 47,100,101,118, 47,115,104,109,  0,  0,  0,  0,
/* 0x00e0 */  28,  0, 79,226,  6,  0,176,232,  5,  0,144,239, 14,240,160,225,
/* 0x00f0 */  96,192,159,229,  0,192, 12,224, 12,  0, 64,224, 12, 16,129,224,
/* 0x0100 */ 125,  0,144,239, 14,240,160,225, 72,192,159,229,  0,192, 12,224,
/* 0x0110 */  12,  0, 64,224, 12, 16,129,224, 48, 64, 45,233, 16, 80,157,229,
/* 0x0120 */  12, 64,157,229, 37, 86,160,225, 40,192,159,229,  0,192, 12,224,
/* 0x0130 */  12,  0, 64,224, 12, 16,129,224,192,  0,144,239, 48,128,189,232,
/* 0x0140 */  16,192,159,229,  0,192, 12,224, 12,  0, 64,224, 12, 16,129,224,
/* 0x0150 */  91,  0,144,239, 14,240,160,225,255, 15,  0,  0,  0, 32,160,227,
/* 0x0160 */   2,  0,159,239, 14,240,160,225, 32,  0, 31,229, 14,240,160,225,
/* 0x0170 */  48, 64, 45,233, 34, 64,160,227,  0, 80,160,227,  4, 48,131,225,
/* 0x0180 */   0, 64,224,227, 49,  0,  0,234,  2,  0, 18,225, 14,240,160,  1,
/* 0x0190 */   2,192,160,225,  3,  0, 16,227, 84,  0,  0, 10,  1,192,130,224,
/* 0x01a0 */   1, 48,209,228, 12,  0, 81,225,  1, 48,192,228, 79,  0,  0, 26,
/* 0x01b0 */  14,240,160,225,  3,  0, 17,227,104,  0,  0, 10,  3, 48,210,227,
/* 0x01c0 */   3,192,129,224, 78,  0,  0, 10,  4, 32, 45,229,  1, 32,209,228,
/* 0x01d0 */   1, 48,209,228,  3, 36,130,225,  1, 48,209,228,  3, 40,130,225,
/* 0x01e0 */   1, 48,209,228,  3, 44,130,225,  4, 32,128,228, 12,  0, 81,225,
/* 0x01f0 */  90,  0,  0, 26,  4, 32,157,228,  3, 32, 18,226, 78,  0,  0, 26,
/* 0x0200 */  14,240,160,225, 15, 48,210,227,  3,192,129,224,117,  0,  0, 26,
/* 0x0210 */   3, 48,210,227,  3,192,129,224, 78,  0,  0, 10,  4, 48,145,228,
/* 0x0220 */   4, 48,128,228, 12,  0, 81,225,110,  0,  0, 26,  3, 32, 18,226,
/* 0x0230 */  78,  0,  0, 26, 14,240,160,225,240,  0, 45,233,240,  0,177,232,
/* 0x0240 */ 240,  0,160,232, 12,  0, 81,225,118,  0,  0, 26,240,  0,189,232,
/* 0x0250 */  15, 32, 18,226,107,  0,  0, 26, 14,240,160,225,255, 64, 45,233,
/* 0x0260 */ 240,  0,189,232, 13,  0,160,225,  6, 48, 77,224,  7,208,195,227,
/* 0x0270 */   4,  0, 45,229,  4,  0,141,226,254,255,255,235,  5,  0,160,225,
/* 0x0280 */   4, 16,160,225,  3, 32,160,227,  1,  0, 23,227,  4, 32,130, 19,
/* 0x0290 */  16, 48,160,227,254,255,255,235,  4, 16,141,226,  6, 32,160,225,
/* 0x02a0 */ 254,255,255,235,  0,208,157,229,240,128,189,232,  2,  0, 18,225,
/* 0x02b0 */  14,240,160,  1,  1, 16,192,228,  1, 32, 82,226,254,255,255,202,
/* 0x02c0 */  14,240,160,225,  0,  0, 77,224,  7,  0,192,227,  0,208,160,225,
/* 0x02d0 */  14,240,160,225,  0,192,160,225,  1, 16, 65,224,  0, 32,160,225,
/* 0x02e0 */ 128,  1,144,224,129, 17,161,224,162, 30,129,224,  0, 32,160,225,
/* 0x02f0 */   0,  2,144,224,  1, 18,161,224, 34, 30,129,224,  0, 32,160,225,
/* 0x0300 */   0,  4,144,224,  1, 20,161,224, 34, 28,129,224,  0, 32,160,225,
/* 0x0310 */   0,  8,144,224,  1, 24,161,224, 34, 24,129,224,140, 15, 80,224,
/* 0x0320 */ 172, 16,193,224, 12,  0,144,224,  0,  0,161,226, 14,240,160,225,
/* 0x0330 */   4,224, 45,229,  3,  0,  0,235, 64,  4,  2,  6,  1,  5,  3,  7,
/* 0x0340 */   0,  0,  0,  0, 14, 48,160,225, 24, 32,144,229,  7, 32,  2,226,
/* 0x0350 */   2,  0,211,231,  7,  0,  0,226,  4,240,157,228,  4,224, 45,229,
/* 0x0360 */ 254,255,255,235,127,  0,160,227,254,255,255,235,240, 64, 45,233,
/* 0x0370 */   0, 80,160,225,  1,112,160,225,  2, 96,160,225, 24,  0,144,232,
/* 0x0380 */   2,  0, 83,225,  8,  0,160, 51,  9,  0,  0, 59,  1, 48, 70,226,
/* 0x0390 */   1,  0,115,227, 32,  0,  0, 10,  7, 16,160,225,  0, 32,160,227,
/* 0x03a0 */   1,  0,131,226,  4, 48,210,231,  1, 48,193,228,  1, 32,130,226,
/* 0x03b0 */   0,  0, 82,225, 27,  0,  0, 26,  4, 48,149,229,  6, 48,131,224,
/* 0x03c0 */   4, 48,133,229,  0, 48,149,229,  3, 48,102,224,  0, 48,133,229,
/* 0x03d0 */ 240,128,189,232, 48, 64, 45,233, 16,208, 77,226,  0, 80,160,225,
/* 0x03e0 */   1, 64,160,225,  0, 48,145,229,  0,  0, 83,227,114,  0,  0, 10,
/* 0x03f0 */   5,  0,160,225, 13, 16,160,225, 12, 32,160,227, 13,  0,  0,235,
/* 0x0400 */   0, 48,157,229,  0,  0, 83,227, 64,  0,  0, 26,  4, 32,157,229,
/* 0x0410 */ 240, 48,159,229,  3,  0, 82,225,  2,  0,160, 19,  9,  0,  0, 27,
/* 0x0420 */   0, 48,149,229,  0,  0, 83,227,114,  0,  0, 10,  3,  0,160,227,
/* 0x0430 */   9,  0,  0,235,114,  0,  0,234,  4, 48,157,229,  0,  0, 83,227,
/* 0x0440 */   4,  0,160,  3,  9,  0,  0, 11, 12,  0,157,232,  2,  0, 83,225,
/* 0x0450 */  74,  0,  0,138,  0, 48,148,229,  3,  0, 82,225, 76,  0,  0,154,
/* 0x0460 */   5,  0,160,227,  9,  0,  0,235,  4, 32,157,229,  0, 48,157,229,
/* 0x0470 */   3,  0, 82,225,102,  0,  0, 42, 16, 32,141,226,  4, 48, 34,229,
/* 0x0480 */   4,  0,149,229, 12,  0, 64,226,  4, 16,148,229,254,255,255,235,
/* 0x0490 */   0,  0, 80,227, 92,  0,  0, 26,  0, 32,157,229, 12, 48,157,229,
/* 0x04a0 */   3,  0, 82,225, 94,  0,  0, 10,  7,  0,160,227,  9,  0,  0,235,
/* 0x04b0 */   4, 48,149,229,  4, 32,157,229,  2, 48,131,224,  4, 48,133,229,
/* 0x04c0 */   0, 48,149,229,  3, 48, 98,224,  0, 48,133,229,105,  0,  0,234,
/* 0x04d0 */   5,  0,160,225,  4, 16,148,229, 13,  0,  0,235,  4, 48,148,229,
/* 0x04e0 */   0, 32,157,229,  2, 48,131,224,  4, 48,132,229,  0, 48,148,229,
/* 0x04f0 */   3, 48, 98,224,  0, 48,132,229,  0,  0, 83,227, 46,  0,  0, 26,
/* 0x0500 */  16,208,141,226, 48,128,189,232, 85, 80, 88, 33,112, 64, 45,233,
/* 0x0510 */   5,221, 77,226,124,  0,  0,235, 47,112,114,111, 99, 47,115,101,
/* 0x0520 */ 108,102, 47, 97,117,120,118,  0, 14,  0,160,225,  0, 16,160,227,
/* 0x0530 */   1, 32,160,225,254,255,255,235,  0, 96, 80,226,155,  0,  0,186,
/* 0x0540 */  13, 80,160,225, 13, 16,160,225,  5, 45,160,227,254,255,255,235,
/* 0x0550 */   7,  0,192,227,  0, 64,141,224,  6,  0,160,225,254,255,255,235,
/* 0x0560 */   4,  0, 93,225,155,  0,  0, 42,  0, 48,157,229,  6,  0, 83,227,
/* 0x0570 */  13, 16,160,  1,148,  0,  0, 10,151,  0,  0,234,  0, 48,145,229,
/* 0x0580 */   6,  0, 83,227,152,  0,  0, 26,  4, 48,145,229,  0,  0, 99,226,
/* 0x0590 */ 157,  0,  0,234, 13, 16,160,225,  8, 16,129,226,  1,  0, 84,225,
/* 0x05a0 */ 145,  0,  0,138,  2, 49,160,227,195,  9,160,225,  5,221,141,226,
/* 0x05b0 */ 112,128,189,232,240, 79, 45,233,108,208, 77,226,  0, 64,160,225,
/* 0x05c0 */  12, 16,141,229,  2,128,160,225,254,255,255,235, 16,  0,141,229,
/* 0x05d0 */   0, 48,148,229,  4,144, 99,224, 92,192,141,226, 15,  0,148,232,
/* 0x05e0 */  15,  0,140,232,  3, 80,137,224,  4, 64,101,224, 32, 64,141,229,
/* 0x05f0 */  20, 16,141,229,  0, 48,224,227,  0, 48,141,229,  0,  0,160,227,
/* 0x0600 */   4,  0,141,229,  4, 16,160,225,  3, 32,160,227, 35, 48,131,226,
/* 0x0610 */ 254,255,255,235,  0,176,160,225,  5, 16,160,225, 32, 32,157,229,
/* 0x0620 */ 254,255,255,235, 24,112,139,226, 24, 48,155,229, 84, 48,141,229,
/* 0x0630 */  88,128,141,229,  4, 48,151,229, 12, 48,131,226, 76, 48,141,229,
/* 0x0640 */  80,112,141,229, 76,  0,141,226, 84, 16,141,226, 39,  0,  0,235,
/* 0x0650 */  52, 96,136,226,188, 50,216,225,131,162,134,224, 52, 48,152,229,
/* 0x0660 */   1,  0, 83,227,209,  0,  0, 10,  6,  0,160,225, 32, 48,176,229,
/* 0x0670 */   1,  0, 83,227,205,  0,  0, 26,  0, 96,160,225,  8, 48,150,229,
/* 0x0680 */   9, 48, 99,224, 36, 48,141,229, 24, 48,150,229,  1,  0, 19,227,
/* 0x0690 */ 242,  0,  0, 10,254,255,255,235,  0, 80,160,225, 16, 16,157,229,
/* 0x06a0 */   0, 64, 97,226,  8, 16,160,225,  0, 32,151,229,254,255,255,235,
/* 0x06b0 */   0, 32,151,229,  5,  0,160,225,  2, 16,137,224,  4, 32, 98,224,
/* 0x06c0 */ 254,255,255,235,  9,  0,160,225,  4, 16,160,225,254,255,255,235,
/* 0x06d0 */   6,  0,160,225,254,255,255,235,  0, 32,160,225,  0, 80,141,229,
/* 0x06e0 */   0, 48,160,227,  4, 48,141,229,  9,  0,160,225,  4, 16,160,225,
/* 0x06f0 */  18, 48,131,226,254,255,255,235,  5,  0,160,225,254,255,255,235,
/* 0x0700 */   6,  0, 90,225,  0, 32,160,147, 40, 32,141,149,193,  1,  0,154,
/* 0x0710 */   0, 48,160,227, 40, 48,141,229, 16,192,157,229, 12,192,224,225,
/* 0x0720 */   8,192,141,229,  6, 80,160,225,  0, 48,150,229,  1,  0, 83,227,
/* 0x0730 */ 190,  1,  0, 26, 24, 48,150,229,  2, 16, 19,226,190,  1,  0, 26,
/* 0x0740 */   4, 64,150,229,100, 32,157,229, 16, 48,150,229,  3, 48,132,224,
/* 0x0750 */   2,  0, 83,225,190,  1,  0,154,  2,  0, 84,225, 44, 16,141,133,
/* 0x0760 */   2, 32,100,144, 44, 32,141,149, 12, 32,160,227, 76, 32,141,229,
/* 0x0770 */  76,  0,141,226, 64, 16,141,226, 13,  0,  0,235, 80, 48,157,229,
/* 0x0780 */  12, 48, 67,226, 80, 48,141,229,  8, 32,150,229, 36,  0,157,229,
/* 0x0790 */   2, 32,128,224, 44, 16,157,229,  2, 32,129,224, 88, 32,141,229,
/* 0x07a0 */  20, 16,150,229, 44, 48,157,229,  1, 16, 99,224, 84, 16,141,229,
/* 0x07b0 */   8,192,157,229, 24,192,141,229,  8, 48,150,229, 44,  0,157,229,
/* 0x07c0 */   3, 48,128,224, 12,128,  3,224, 28,128,141,229,  2, 32,104,224,
/* 0x07d0 */  88, 32,141,229,  1,  0,136,224, 84,  0,141,229, 24, 48,150,229,
/* 0x07e0 */   1,  0, 19,227, 78,  1,  0, 10,254,255,255,235,  0,112,160,225,
/* 0x07f0 */  84, 64,157,229,  0,  0, 84,227, 57,  1,  0, 10,  7,  0,160,225,
/* 0x0800 */  88, 16,157,229,  4, 32,160,225,254,255,255,235,  0,  0, 80,227,
/* 0x0810 */  57,  1,  0,186,  0, 64, 84,224, 49,  1,  0, 26,  7,  0,160,225,
/* 0x0820 */   0, 16,160,227,  1, 32,160,225,254,255,255,235,  7,  0,160,225,
/* 0x0830 */  88, 16,157,229,  8, 32,160,225,254,255,255,235, 88,  0,157,229,
/* 0x0840 */  84, 16,157,229,254,255,255,235,  0,112,141,229,  0, 16,160,227,
/* 0x0850 */   4, 16,141,229, 88,  0,157,229, 84, 16,157,229,  3, 32,160,227,
/* 0x0860 */  17, 48,160,227,254,255,255,235, 48,  0,141,229, 83,  1,  0,234,
/* 0x0870 */  88, 16,157,229,  8, 32,160,225,254,255,255,235,  0,112,160,227,
/* 0x0880 */  48,112,141,229, 88, 48,157,229, 28, 32,157,229,  2, 48,131,224,
/* 0x0890 */  88, 48,141,229, 64, 48,157,229, 84, 48,141,229, 68, 48,157,229,
/* 0x08a0 */  12, 48,131,226, 76, 48,141,229, 76,  0,141,226, 84, 16,141,226,
/* 0x08b0 */  39,  0,  0,235, 40, 48,157,229,  0,  0, 83,227,155,  1,  0, 26,
/* 0x08c0 */  24, 48,149,229,  1,  0, 19,227,180,  1,  0, 10, 88, 64,157,229,
/* 0x08d0 */ 254,255,255,235, 56,  0,141,229, 93, 53,224,227,159, 59, 67,226,
/* 0x08e0 */   3, 60, 67,226, 60, 48,141,229,  0, 48,149,229,  1,  0, 83,227,
/* 0x08f0 */ 151,  1,  0, 26, 24, 48,149,229,  1,  0, 19,227,151,  1,  0, 10,
/* 0x0900 */  20,192,133,226,  8, 16, 28,232,  3, 48, 76,224,  3, 32,132,224,
/* 0x0910 */   0, 48, 98,226, 24, 16,157,229,  3, 48,  1,224,  7,  0, 83,227,
/* 0x0920 */ 134,  1,  0,154,  3, 48,130,226,  3, 48,195,227, 52, 48,141,229,
/* 0x0930 */   0,  0,131,229, 60, 48,157,229, 52, 32,157,229,  4, 48,130,229,
/* 0x0940 */  52,  0,157,229,  8, 16,130,226,254,255,255,235,153,  1,  0,234,
/* 0x0950 */ 254,255,255,235,  0, 64,160,225, 56, 16,141,226,  8, 32,160,227,
/* 0x0960 */ 254,255,255,235,  0, 64,141,229,  0, 48,160,227,  4, 48,141,229,
/* 0x0970 */   3,  0,160,225,  8, 16,160,227,  5, 32,160,227,  2, 48,131,226,
/* 0x0980 */ 254,255,255,235, 52,  0,141,229,  4,  0,160,225,254,255,255,235,
/* 0x0990 */ 153,  1,  0,234,  0,192,160,227, 52,192,141,229, 52,  0,157,229,
/* 0x09a0 */  40,  0,141,229, 24, 48,149,229,  1,  0, 19,227,180,  1,  0, 10,
/* 0x09b0 */  48,  0,157,229, 64, 16,157,229,  1, 16,136,224,254,255,255,235,
/* 0x09c0 */   8, 64,149,229, 36, 16,157,229,  4, 64,129,224, 44, 32,157,229,
/* 0x09d0 */   4, 64,130,224,  6,  0,160,225,254,255,255,235,  0, 32,160,225,
/* 0x09e0 */   0,112,141,229,  0, 48,160,227,  4, 48,141,229,  4,  0,160,225,
/* 0x09f0 */  64, 16,157,229, 18, 48,131,226,254,255,255,235,  7,  0,160,225,
/* 0x0a00 */ 254,255,255,235,190,  1,  0,234,  8, 64,149,229, 36,192,157,229,
/* 0x0a10 */   4, 64,140,224, 20, 80,149,229,  6,  0,160,225,254,255,255,235,
/* 0x0a20 */   0, 32,160,225,  4,  0,160,225,  5, 16,160,225,254,255,255,235,
/* 0x0a30 */  32, 96,134,226,  6,  0, 90,225,251,  0,  0,138, 11,  0,160,225,
/* 0x0a40 */  32, 16,157,229,254,255,255,235, 20,  0,157,229,  0, 48,137,224,
/* 0x0a50 */  12, 16,157,229,  3,  0,145,232, 12,192,157,229,  8, 32,156,229,
/* 0x0a60 */  15,224,160,225, 19,255, 47,225, 40,  0,157,229,108,208,141,226,
/* 0x0a70 */ 240,143,189,232,255, 48,  3,226, 80,  0, 83,227, 14,240,160, 17,
/* 0x0a80 */  33, 17,176,225,  0,  0, 80, 19, 14,240,160,  1,  1, 16, 65,226,
/* 0x0a90 */   1, 33,144,231, 15, 52,  2,226, 11,  4, 83,227, 14,  0,  0, 26,
/* 0x0aa0 */ 255, 52,  2,226,  1, 32, 66,224,255, 36,194,227,  3, 32,130,225,
/* 0x0ab0 */   1, 33,128,231,  0,  0, 81,227,  4,  0,  0, 26, 14,240,160,225,
/* 0x0ac0 */   0, 16,160,225,  1,  0,209,228,  1, 32,209,228,  2,  4,128,225,
/* 0x0ad0 */   1, 32,209,228,  2,  8,128,225,  1, 32,209,228,  2, 12,128,225,
/* 0x0ae0 */  14,240,160,225,255, 64, 45,233,  8, 64,208,229,  0, 80,160,225,
/* 0x0af0 */   8, 48,157,229,  4,  0,133,226, 17,  0,  0,235,  0, 16,160,225,
/* 0x0b00 */   4, 32,157,229, 12,  0,133,226, 53,  0,  0,235,  0, 48,157,229,
/* 0x0b10 */  10, 32,211,229,  9, 48,211,229,  3,  0, 19,225, 45,  0,  0, 10,
/* 0x0b20 */   4,  0,157,229,  8, 16,157,229,  0, 16,145,229,254,255,255,235,
/* 0x0b30 */   8, 16,157,229,  4,  0,157,229,  0, 16,145,229,  0, 16,129,224,
/* 0x0b40 */ 254,255,255,235,  0,  0,160,227,  0,  0,141,229,255,128,189,232,
/* 0x0b50 */   8,  0,189,232,  0,  0,160,225,  3,  0, 64,224,  8,  0,189,232,
/* 0x0b60 */   2,  0,189,232,  3, 32, 66,224,  8,  0,189,232,  0, 32,131,229,
/* 0x0b70 */  14,240,160,225,252, 64, 45,233,  0,112,129,224,  0, 80,224,227,
/* 0x0b80 */   2, 65,160,227, 14,  0,  0,234, 24,  0,189,232,  7,  0, 64,224,
/* 0x0b90 */   3, 32, 66,224,  0, 32,132,229,240,128,189,232,  1, 64,208,228,
/* 0x0ba0 */   4, 64,164,224,  4, 76,176,225, 14,240,160,225,  1, 48,208,228,
/* 0x0bb0 */   1, 48,194,228,  4, 64,148,224,  8,  0,  0, 11, 12,  0,  0, 42,
/* 0x0bc0 */   1, 16,160,227, 23,  0,  0,234,  1, 16, 65,226,  4, 64,148,224,
/* 0x0bd0 */   8,  0,  0, 11,  1, 16,161,224,  4, 64,148,224,  8,  0,  0, 11,
/* 0x0be0 */   1, 16,161,224,  4, 64,148,224,  8,  0,  0, 11, 19,  0,  0, 58,
/* 0x0bf0 */   3, 48, 81,226,  0, 16,160,227, 39,  0,  0, 58,  1, 80,208,228,
/* 0x0c00 */   3, 84,133,225,  5, 80,240,225,  3,  0,  0, 10,197, 80,176,225,
/* 0x0c10 */  54,  0,  0, 42, 42,  0,  0,234,  4, 64,148,224,  8,  0,  0, 11,
/* 0x0c20 */  54,  0,  0, 42,  1, 16,160,227,  4, 64,148,224,  8,  0,  0, 11,
/* 0x0c30 */  54,  0,  0, 42,  4, 64,148,224,  8,  0,  0, 11,  1, 16,161,224,
/* 0x0c40 */   4, 64,148,224,  8,  0,  0, 11, 46,  0,  0, 58,  4, 16,129,226,
/* 0x0c50 */  58,  0,  0,234,  4, 64,148,224,  8,  0,  0, 11,  1, 16,161,224,
/* 0x0c60 */   2, 16,129,226,  5, 12,117,227,  1, 16,129, 50,  1, 48,130,224,
/* 0x0c70 */   1, 48, 83,229,  5, 48,210,231,  1, 48,194,228,  1, 16, 81,226,
/* 0x0c80 */  62,  0,  0, 26, 14,  0,  0,234,252, 64, 45,233,  0,112,129,224,
/* 0x0c90 */   0, 80,224,227,  2, 65,160,227, 14,  0,  0,234, 24,  0,189,232,
/* 0x0ca0 */   7,  0, 64,224,  3, 32, 66,224,  0, 32,132,229,240,128,189,232,
/* 0x0cb0 */   1, 64,208,228,  4, 64,164,224,  4, 76,176,225, 14,240,160,225,
/* 0x0cc0 */   1, 48,208,228,  1, 48,194,228,  4, 64,148,224,  8,  0,  0, 11,
/* 0x0cd0 */  12,  0,  0, 42,  1, 16,160,227, 23,  0,  0,234,  1, 16, 65,226,
/* 0x0ce0 */   4, 64,148,224,  8,  0,  0, 11,  1, 16,177,224,  4, 64,148,224,
/* 0x0cf0 */   8,  0,  0, 11,  1, 16,177,224,  4, 64,148,224,  8,  0,  0, 11,
/* 0x0d00 */  19,  0,  0, 58,  3, 48, 81,226,  0, 16,160,227, 38,  0,  0, 58,
/* 0x0d10 */   1, 80,208,228,  3, 84,133,225,  5, 80,240,225,  3,  0,  0, 10,
/* 0x0d20 */ 197, 80,176,225, 40,  0,  0,234,  4, 64,148,224,  8,  0,  0, 11,
/* 0x0d30 */   1, 16,177,224,  4, 64,148,224,  8,  0,  0, 11,  1, 16,177,224,
/* 0x0d40 */  53,  0,  0, 26,  1, 16,160,227,  4, 64,148,224,  8,  0,  0, 11,
/* 0x0d50 */   1, 16,177,224,  4, 64,148,224,  8,  0,  0, 11, 46,  0,  0, 58,
/* 0x0d60 */   2, 16,129,226,  1, 16,129,226,  5, 12,117,227,  1, 16,129, 50,
/* 0x0d70 */   0, 48,210,229,  5, 48,210,231,  1, 48,194,228,  1, 16, 81,226,
/* 0x0d80 */  57,  0,  0, 26, 14,  0,  0,234,  0, 16,129,224, 62, 64, 45,233,
/* 0x0d90 */   0, 80,224,227,  2, 65,160,227, 23,  0,  0,234, 26,  0,189,232,
/* 0x0da0 */   1,  0, 64,224,  3, 32, 66,224,  0, 32,132,229, 48,128,189,232,
/* 0x0db0 */   4, 64,148,224, 14,240,160, 17,  1, 64,208,228,  4, 64,164,224,
/* 0x0dc0 */   4, 76,176,225, 14,240,160,225,  1, 16,160,227, 14,192,160,225,
/* 0x0dd0 */   8,  0,  0,235,  1, 16,177,224,  8,  0,  0,235, 16,  0,  0, 58,
/* 0x0de0 */  12,240,160,225,  1, 48,208,228,  1, 48,194,228,  8,  0,  0,235,
/* 0x0df0 */  21,  0,  0, 42, 14,  0,  0,235,  3, 48, 81,226,  0, 16,160,227,
/* 0x0e00 */  33,  0,  0, 58,  1, 80,208,228,  3, 84,133,225,  5, 80,240,225,
/* 0x0e10 */   3,  0,  0, 10,  8,  0,  0,235,  1, 16,177,224,  8,  0,  0,235,
/* 0x0e20 */   1, 16,177,224, 40,  0,  0, 26, 14,  0,  0,235,  2, 16,129,226,
/* 0x0e30 */  13, 12,117,227,  1, 16,129, 50,  5, 48,210,231,  1, 16, 81,226,
/* 0x0e40 */   1, 48,194,228, 42,  0,  0, 42, 23,  0,  0,234,  0,192,157,229,
/* 0x0e50 */  14,  0, 92,227, 33,  0,  0, 26,  0, 72, 45,233,  0,176,208,229,
/* 0x0e60 */   6,204,160,227,171,177,160,225, 28,203,160,225, 13,176,160,225,
/* 0x0e70 */  58,205,140,226, 12,208, 77,224,  0,192,147,229,  8, 48,141,229,
/* 0x0e80 */   4,192,141,229,  0, 32,141,229, 12, 48,141,226,  0,192,160,227,
/* 0x0e90 */   4,192,131,228, 11,  0, 83,225, 15,  0,  0, 26, 12, 48,141,226,
/* 0x0ea0 */   2, 32, 65,226,  0, 16,160,225,  1,192,209,228,  7,192, 12,226,
/* 0x0eb0 */  18,192,205,229,  1,192,209,228, 44,  2,160,225, 17,  0,205,229,
/* 0x0ec0 */  15,192, 12,226, 16,192,205,229, 16,  0,141,226, 34,  0,  0,235,
/* 0x0ed0 */  11,208,160,225,  0,136,189,232, 33,  0,  0,234,240, 79, 45,233,
/* 0x0ee0 */  48,208, 77,226,  0, 48,141,229,  0, 48,208,229,  2, 80,208,229,
/* 0x0ef0 */   1,224,208,229,  0,192,157,229, 20, 48,141,229, 92, 48,157,229,
/* 0x0f00 */   0, 64,160,227,  0, 64,140,229,  0, 64,131,229, 20,192,157,229,
/* 0x0f10 */   1, 48,208,229,  3, 48,140,224,  3,204,160,227, 28,195,160,225,
/* 0x0f20 */   1, 48,160,227, 19,238,160,225, 19, 53,160,225,115,206,140,226,
/* 0x0f30 */   1, 48, 67,226,  1,224, 78,226,  4,  0,128,226,  6,192,140,226,
/* 0x0f40 */   4, 16,141,229, 12, 48,141,229, 16,224,141,229,  8,  0,141,229,
/* 0x0f50 */  31,  0,  0,234,  8,  0,157,229,  1, 27,160,227,176, 16,131,225,
/* 0x0f60 */  12,  0, 84,225,132, 48,160,225,  1, 64,132,226, 28,  0,  0, 26,
/* 0x0f70 */   4, 48,157,229,  0, 96,160,227,  2,144,131,224,  3,224,160,225,
/* 0x0f80 */   6, 32,160,225,  4, 80,157,229,  9, 48,101,224,  3,  0, 82,225,
/* 0x0f90 */   1,224,142,226, 73,  2,  0, 10,  5, 48,210,231,  1, 32,130,226,
/* 0x0fa0 */   5,  0, 82,227,  6,100,131,225, 40,  0,  0, 26,  0,176,160,227,
/* 0x0fb0 */   1,192,160,227, 11,112,160,225,  0,  0,224,227, 44,192,141,229,
/* 0x0fc0 */  24,176,141,229, 28,192,141,229, 32,192,141,229, 36,192,141,229,
/* 0x0fd0 */  57,  2,  0,234,255,132,224,227,  8,  0, 80,225, 68,  0,  0,138,
/* 0x0fe0 */   9,  0, 94,225, 73,  2,  0, 10,  1, 48,222,228,  0,  4,160,225,
/* 0x0ff0 */   6,100,131,225, 12, 16,157,229, 24, 32,157,229,  1,160, 11,224,
/* 0x1000 */   2, 18,160,225,  1, 48,138,224,131, 80,160,225,  8, 48,157,229,
/* 0x1010 */ 181,192,147,225,160, 53,160,225,156,  3,  4,224,  4,  0, 86,225,
/* 0x1020 */ 185,  0,  0, 42, 20,  0,157,229,  8, 48, 96,226, 87, 51,160,225,
/* 0x1030 */  16, 16,157,229,  1, 32, 11,224, 18, 48,131,224,  8,  0,157,229,
/* 0x1040 */   6, 44,160,227,147,  2, 34,224, 24, 16,157,229,  2, 59,108,226,
/* 0x1050 */   6,  0, 81,227,195, 50,140,224,230,142,130,226,181, 48,128,225,
/* 0x1060 */  12,128,136,226,  4,  0,160,209,  1, 16,160,211,164,  0,  0,218,
/* 0x1070 */  44, 32,157,229, 84, 80,157,229, 11, 48, 98,224,  3,112,213,231,
/* 0x1080 */   4,  0,160,225,  1, 16,160,227,135,112,160,225,  1, 92,  7,226,
/* 0x1090 */ 129,160,160,225,133, 48,136,224, 10, 48,131,224,  1,  4, 80,227,
/* 0x10a0 */   2, 76,131,226,  1,192,129,226,119,  0,  0, 42,  9,  0, 94,225,
/* 0x10b0 */   0,  4,160,225, 73,  2,  0, 10,  1, 48,222,228,  6,100,131,225,
/* 0x10c0 */ 176, 48,212,225,160, 37,160,225, 12, 16,129,224,147,  2, 12,224,
/* 0x10d0 */   2, 43, 99,226, 12,  0, 86,225,194, 34,131,224,163, 50, 67,224,
/* 0x10e0 */ 135,  0,  0, 42,  0,  0, 85,227, 12,  0,160,225,176, 32,196,225,
/* 0x10f0 */  10, 16,160,225,140,  0,  0, 10, 12,  0,160,225,164,  0,  0,234,
/* 0x1100 */   0,  0, 85,227,176, 48,196,225,  6, 96,108,224,  0,  0,108,224,
/* 0x1110 */ 164,  0,  0, 10,255,  0, 81,227,168,  0,  0,202,105,  0,  0,234,
/* 0x1120 */   1,  4, 80,227,  3, 16,129,224,151,  0,  0, 42,  9,  0, 94,225,
/* 0x1130 */   0,  4,160,225, 73,  2,  0, 10,  1, 48,222,228,  6,100,131,225,
/* 0x1140 */ 180, 48,152,225,160, 37,160,225,147,  2, 12,224,  2, 43, 99,226,
/* 0x1150 */  12,  0, 86,225,163, 82, 67,224,194, 50,131,224,180, 48,136, 49,
/* 0x1160 */ 180, 80,136, 33,  0,  0,108,224,  4, 16,160, 49, 12,  0,160, 49,
/* 0x1170 */   6, 96,108, 32,255,  0, 81,227,129, 64,160,225,  1, 48,129,226,
/* 0x1180 */ 143,  0,  0,218, 24,192,157,229,255,112,  1,226,  3,  0, 92,227,
/* 0x1190 */  84, 16,157,229,  0, 32,160,211, 11,112,193,231,  1,176,139,226,
/* 0x11a0 */  24, 32,141,213, 57,  2,  0,218, 24, 48,157,229,  9,  0, 83,227,
/* 0x11b0 */  24, 80,157,197,  3, 48, 67,210,  6, 80, 69,194, 24, 48,141,213,
/* 0x11c0 */  24, 80,141,197, 57,  2,  0,234,172, 50, 76,224,  0, 32,100,224,
/* 0x11d0 */   8,192,157,229,  8,  0, 82,225,181, 48,140,225,  6, 96,100,224,
/* 0x11e0 */ 197,  0,  0,138,  9,  0, 94,225, 73,  2,  0, 10,  1, 48,222,228,
/* 0x11f0 */   2, 36,160,225,  6,100,131,225,  8,  0,157,229, 24, 48,157,229,
/* 0x1200 */ 131,112,128,224,  6, 13,135,226,176,192,208,225,162, 53,160,225,
/* 0x1210 */ 156,  3,  4,224,  4,  0, 86,225,225,  0,  0, 42, 24, 32,157,229,
/* 0x1220 */   8, 80,157,229,  6,  0, 82,227,  2, 59,108,226,102, 30,133,226,
/* 0x1230 */   3, 32,160,195, 32, 80,157,229,  0, 32,160,211,195, 50,140,224,
/* 0x1240 */  24, 32,141,229, 28,192,157,229, 44, 32,157,229, 36, 80,141,229,
/* 0x1250 */   4, 16,129,226,  4, 80,160,225, 32,192,141,229, 28, 32,141,229,
/* 0x1260 */ 176, 48,192,225, 98,  1,  0,234,  2, 32,100,224,172, 50, 76,224,
/* 0x1270 */   8,  0, 82,225,176, 48,192,225,  6, 96,100,224,236,  0,  0,138,
/* 0x1280 */   9,  0, 94,225, 73,  2,  0, 10,  1, 48,222,228,  2, 36,160,225,
/* 0x1290 */   6,100,131,225,102, 95,135,226,176,192,213,225,162, 53,160,225,
/* 0x12a0 */ 156,  3,  4,224,  4,  0, 86,225, 26,  1,  0, 42,  2, 59,108,226,
/* 0x12b0 */ 195, 50,140,224,  8,  0, 84,225,176, 48,197,225,252,  0,  0,138,
/* 0x12c0 */   9,  0, 94,225, 73,  2,  0, 10,  1, 48,222,228,  4, 68,160,225,
/* 0x12d0 */   6,100,131,225,  8, 80,157,229,129, 48,133,224,138, 48,131,224,
/* 0x12e0 */  30, 30,131,226,176,192,209,225,164, 53,160,225,156,  3,  2,224,
/* 0x12f0 */   2,  0, 86,225,  6, 96, 98, 32,172, 50, 76, 32,  4, 80, 98, 32,
/* 0x1300 */  50,  1,  0, 42,  2, 59,108,226,195, 50,140,224,  0,  0, 91,227,
/* 0x1310 */ 176, 48,193,225, 73,  2,  0, 10, 44,192,157,229, 24, 16,157,229,
/* 0x1320 */  84,  0,157,229, 11, 48,108,224,  3,112,208,231,  6,  0, 81,227,
/* 0x1330 */  11, 16,160,195,  9, 16,160,211, 24, 16,141,229, 11,112,192,231,
/* 0x1340 */   2,  0,160,225,  1,176,139,226, 57,  2,  0,234,  2, 32,100,224,
/* 0x1350 */ 172, 50, 76,224,  8,  0, 82,225,176, 48,197,225,  6, 96,100,224,
/* 0x1360 */  37,  1,  0,138,  9,  0, 94,225, 73,  2,  0, 10,  1, 48,222,228,
/* 0x1370 */   2, 36,160,225,  6,100,131,225, 27, 30,135,226,176,192,209,225,
/* 0x1380 */ 162, 53,160,225,156,  3,  4,224,  4,  0, 86,225, 52,  1,  0, 42,
/* 0x1390 */  44, 80,157,229,  2, 59,108,226, 28, 32,157,229,195, 50,140,224,
/* 0x13a0 */  28, 80,141,229,  4, 80,160,225, 44, 32,141,229,176, 48,193,225,
/* 0x13b0 */  90,  1,  0,234,  2, 32,100,224,172, 50, 76,224,  8,  0, 82,225,
/* 0x13c0 */ 176, 48,193,225,  6, 96,100,224, 63,  1,  0,138,  9,  0, 94,225,
/* 0x13d0 */  73,  2,  0, 10,  1, 48,222,228,  2, 36,160,225,  6,100,131,225,
/* 0x13e0 */ 114, 31,135,226,176,192,209,225,162, 53,160,225,156,  3,  4,224,
/* 0x13f0 */   4,  0, 86,225, 78,  1,  0, 42,  2, 59,108,226, 32, 32,157,229,
/* 0x1400 */ 195, 50,140,224, 44,  0,157,229, 28,192,157,229,  4, 80,160,225,
/* 0x1410 */  32,192,141,229, 28,  0,141,229, 49,  1,  0,234,172, 50, 76,224,
/* 0x1420 */ 176, 48,193,225, 44,192,157,229, 32, 16,141,226, 10,  0,145,232,
/* 0x1430 */   2, 80,100,224, 28, 32,157,229, 36, 16,141,229, 32, 32,141,229,
/* 0x1440 */  28,192,141,229, 44, 48,141,229,  6, 96,100,224, 24, 32,157,229,
/* 0x1450 */   8,  0,157,229,  6,  0, 82,227, 11, 32,160,195,  8, 32,160,211,
/* 0x1460 */ 166, 30,128,226, 24, 32,141,229,  8, 16,129,226,255,116,224,227,
/* 0x1470 */   7,  0, 85,225,106,  1,  0,138,  9,  0, 94,225, 73,  2,  0, 10,
/* 0x1480 */   1, 48,222,228,  5, 84,160,225,  6,100,131,225,176,192,209,225,
/* 0x1490 */ 165, 53,160,225,156,  3,  4,224,  4,  0, 86,225,120,  1,  0, 42,
/* 0x14a0 */  10, 34,129,224,  2, 59,108,226,195, 50,140,224,  4, 80,130,226,
/* 0x14b0 */   4,  0,160,225,  3,160,160,227,  0,128,160,227,176, 48,193,225,
/* 0x14c0 */ 152,  1,  0,234,  5, 32,100,224,172, 50, 76,224,  7,  0, 82,225,
/* 0x14d0 */   6, 96,100,224,176, 48,193,225,131,  1,  0,138,  9,  0, 94,225,
/* 0x14e0 */  73,  2,  0, 10,  1, 48,222,228,  2, 36,160,225,  6,100,131,225,
/* 0x14f0 */ 178,192,209,225,162, 53,160,225,156,  3,  4,224,  4,  0, 86,225,
/* 0x1500 */ 145,  1,  0, 42, 10, 34,129,224,  2, 59,108,226,195, 50,140,224,
/* 0x1510 */  65, 95,130,226,  4,  0,160,225,  3,160,160,227,  8,128,160,227,
/* 0x1520 */ 178, 48,193,225,152,  1,  0,234,172, 50, 76,224,178, 48,193,225,
/* 0x1530 */   6, 96,100,224,  2,  0,100,224,129, 95,129,226,  8,160,160,227,
/* 0x1540 */  16,128,160,227, 10,112,160,225,  1, 16,160,227,  1, 48,129,226,
/* 0x1550 */   1,  4, 80,227,129, 64,160,225,  3, 16,129,224,164,  1,  0, 42,
/* 0x1560 */   9,  0, 94,225,  0,  4,160,225, 73,  2,  0, 10,  1, 48,222,228,
/* 0x1570 */   6,100,131,225,180, 48,149,225,160, 37,160,225,147,  2, 12,224,
/* 0x1580 */   2, 43, 99,226, 12,  0, 86,225,194, 34,131,224,163, 50, 67,224,
/* 0x1590 */   0,  0,108,224,  4, 16,160, 49, 12,  0,160, 49,180, 32,133, 49,
/* 0x15a0 */   6, 96,108, 32,180, 48,133, 33,  1,112, 87,226,154,  1,  0, 26,
/* 0x15b0 */   1, 32,160,227, 18, 58, 65,224, 24, 80,157,229,  8, 48,131,224,
/* 0x15c0 */   3,  0, 85,227, 40, 48,141,229, 36,  2,  0,202,  8,192,157,229,
/* 0x15d0 */   3,  0, 83,227,  3, 48,160,163,131, 51,140,224, 54, 94,131,226,
/* 0x15e0 */   2,112,160,225,  6,128,160,227,  1, 48,135,226,  1,  4, 80,227,
/* 0x15f0 */ 135, 64,160,225,  3,112,135,224,203,  1,  0, 42,  9,  0, 94,225,
/* 0x1600 */   0,  4,160,225, 73,  2,  0, 10,  1, 48,222,228,  6,100,131,225,
/* 0x1610 */ 180, 48,149,225,160, 37,160,225,147,  2, 12,224,  2, 43, 99,226,
/* 0x1620 */  12,  0, 86,225,194, 34,131,224,163, 50, 67,224,  0,  0,108,224,
/* 0x1630 */   4,112,160, 49, 12,  0,160, 49,180, 32,133, 49,  6, 96,108, 32,
/* 0x1640 */ 180, 48,133, 33,  1,128, 88,226,193,  1,  0, 26, 64, 32, 71,226,
/* 0x1650 */   3,  0, 82,227,  2, 80,160,209, 30,  2,  0,218,194, 64,160,225,
/* 0x1660 */  13,  0, 82,227,  1, 48,  2,226,  1,112, 68,226,  2,192,131,227,
/* 0x1670 */   5, 64, 68,194,  8, 32,160,193,237,  1,  0,202, 28, 87,160,225,
/* 0x1680 */   8, 16,157,229,133, 48,129,224,130, 48, 67,224, 85, 78,131,226,
/* 0x1690 */  14, 64,132,226,  1,  2,  0,234,  1,  4, 80,227,  1, 32,130,226,
/* 0x16a0 */ 245,  1,  0, 42,  9,  0, 94,225,  0,  4,160,225, 73,  2,  0, 10,
/* 0x16b0 */   1, 48,222,228,  6,100,131,225,160,  0,160,225,  0,  0, 86,225,
/* 0x16c0 */ 140,192,160,225,  6, 96, 96, 32,  1,192,140, 35,  4,  0, 82,225,
/* 0x16d0 */ 237,  1,  0, 26,  8, 32,157,229, 25, 77,130,226,  4, 64,132,226,
/* 0x16e0 */  12, 82,160,225,  4,112,160,227,  1,160,160,227, 10,128,160,225,
/* 0x16f0 */   1,  4, 80,227,136, 16,160,225,  1,192,136,226, 12,  2,  0, 42,
/* 0x1700 */   9,  0, 94,225,  0,  4,160,225, 73,  2,  0, 10,  1, 48,222,228,
/* 0x1710 */   6,100,131,225,177, 48,148,225,160, 37,160,225, 12,128,136,224,
/* 0x1720 */ 147,  2, 12,224,  2, 43, 99,226, 12,  0, 86,225,194, 34,131,224,
/* 0x1730 */ 163, 50, 67,224, 10, 80,133, 33,  1,128,160, 49, 12,  0,160, 49,
/* 0x1740 */ 177, 32,132, 49,177, 48,132, 33,  6, 96,108, 32,  0,  0,108, 32,
/* 0x1750 */   1,112, 87,226,138,160,160,225,  3,  2,  0, 26,  1, 80,149,226,
/* 0x1760 */  44, 80,141,229, 60,  2,  0, 10, 24, 48,157,229,  7, 48,131,226,
/* 0x1770 */  24, 48,141,229, 44, 80,157,229, 11,  0, 85,225, 73,  2,  0,138,
/* 0x1780 */  40,192,157,229, 84, 16,157,229, 11, 48,101,224,  2, 32,140,226,
/* 0x1790 */   3, 64,129,224, 11,192,129,224,  1, 32, 82,226, 88, 80,157,229,
/* 0x17a0 */   0, 48,160,  3,  1, 48,160, 19,  1,176,139,226,  5,  0, 91,225,
/* 0x17b0 */   0, 48,160, 35,  1, 48,  3, 50,  1,112,212,228,  0,  0, 83,227,
/* 0x17c0 */   1,112,204,228, 45,  2,  0, 26, 88,192,157,229, 12,  0, 91,225,
/* 0x17d0 */  60,  0,  0, 58,  1,  4, 80,227, 65,  2,  0, 42,  9,  0, 94,225,
/* 0x17e0 */  73,  2,  0, 10,  1,224,142,226,  4,  0,157,229,  0, 16,157,229,
/* 0x17f0 */  92, 32,157,229, 14, 48, 96,224,  0,  0,160,227,  0, 48,129,229,
/* 0x1800 */   0,176,130,229, 74,  2,  0,234,  1,  0,160,227, 48,208,141,226,
/* 0x1810 */ 240,143,189,232,248, 79, 45,233,  1,192,130,224, 40,144,157,229,
/* 0x1820 */  44,112,157,229,  1,128,160,225,  9,160,135,224,  4,176,128,226,
/* 0x1830 */   0, 96,208,229,  1, 80,208,229,  2, 64,208,229,  6,224,133,224,
/* 0x1840 */   0,112,224,227, 23, 85,224,225, 23, 68,224,225,  1, 48,160,227,
/* 0x1850 */   1, 32,160,227,  1, 16,160,227,  1,  0,160,227,255, 95, 45,233,
/* 0x1860 */   0, 96,160,227, 28, 96,141,229,  3, 44,160,227, 18, 46,160,225,
/* 0x1870 */  54, 32,130,226,  7, 44,130,226, 11, 16,160,225,  1, 11,160,227,
/* 0x1880 */   1,  3,128,227,  4,  0,129,228,  2, 32, 82,226, 26,  0,  0,202,
/* 0x1890 */   5,  0,136,226,  5,  1,  0,235,  8,  0, 80,225, 30,  0,  0, 26,
/* 0x18a0 */  36, 48,157,229, 16, 32,157,229,  3, 64, 73,224,  2,  0,  4,224,
/* 0x18b0 */  44,  0,141,229,  6,  2,128,224,  0, 16,139,226,  9,  1,  0,235,
/* 0x18c0 */  80,  0,  0, 26, 20, 48,157,229, 24, 32,157,229,  4, 48,  3,224,
/* 0x18d0 */  28,  0,221,229, 19, 50,160,225,  8, 32, 98,226, 48, 50,131,224,
/* 0x18e0 */ 108,160,139,226,131, 48,131,224, 14,172,138,226,  1,  0,160,227,
/* 0x18f0 */ 131,164,138,224,  7,  0, 86,227, 69,  0,  0, 58,  0, 16,157,229,
/* 0x1900 */   1, 80, 89,231,133, 80,160,225,  2, 28,138,226,  1, 76,  5,226,
/* 0x1910 */ 132, 16,129,224, 11,  1,  0,235,  1, 48,  0,226, 36,  4, 83,225,
/* 0x1920 */  71,  0,  0, 26,  1, 12, 80,227, 58,  0,  0, 58, 73,  0,  0,234,
/* 0x1930 */  10, 16,160,225, 11,  1,  0,235,  1, 12, 80,227, 69,  0,  0, 58,
/* 0x1940 */   6, 48,160,227, 10,  0, 86,227,  3, 48,160, 51,  4,  0, 86,227,
/* 0x1950 */   6, 48,160, 49,  3, 96, 70,224,112,  0,  0,234,  6, 29,139,226,
/* 0x1960 */   8,  1,  0,235, 95,  0,  0, 26,  8, 48,157,229,  4, 32,157,229,
/* 0x1970 */   0, 16,157,229, 12, 48,141,229,  8, 32,141,229,  4, 16,141,229,
/* 0x1980 */   7,  0, 86,227,  3, 96,160,227,  0, 96,160, 51,100,160,139,226,
/* 0x1990 */   6,172,138,226,135,  0,  0,234,102, 31,139,226,  8,  1,  0,235,
/* 0x19a0 */ 114,  0,  0, 26, 44, 48,157,229, 30, 30,139,226,  6,  2,131,224,
/* 0x19b0 */   9,  1,  0,235,130,  0,  0, 26,  7,  0, 86,227, 11, 96,160,227,
/* 0x19c0 */   9, 96,160, 51, 36, 48,157,229,  0, 16,157,229,  3, 64, 73,224,
/* 0x19d0 */   1,  0, 84,225,253,  0,  0, 58,  1,  0, 89,231,  1,  0,201,228,
/* 0x19e0 */ 237,  0,  0,234, 27, 30,139,226,  8,  1,  0,235,  4, 64,157,229,
/* 0x19f0 */ 127,  0,  0, 10,114, 31,139,226,  8,  1,  0,235,  8, 64,157,229,
/* 0x1a00 */ 125,  0,  0, 10,  8, 48,157,229, 12, 64,157,229, 12, 48,141,229,
/* 0x1a10 */   4, 48,157,229,  8, 48,141,229,  0, 16,157,229,  0, 64,141,229,
/* 0x1a20 */   4, 16,141,229,  7,  0, 86,227, 11, 96,160,227,  8, 96,160, 51,
/* 0x1a30 */ 104,160,139,226, 10,172,138,226,  0, 16,138,226, 10,  1,  0,235,
/* 0x1a40 */ 144,  0,  0, 26, 44, 48,157,229,  4, 80,138,226,  0, 32,160,227,
/* 0x1a50 */   3, 82,133,224,  8, 64,160,227,156,  0,  0,234,  2, 16,138,226,
/* 0x1a60 */  10,  1,  0,235,153,  0,  0, 26, 44, 48,157,229, 65, 95,138,226,
/* 0x1a70 */   8, 32,160,227,  3, 82,133,224,  8, 64,160,227,156,  0,  0,234,
/* 0x1a80 */ 129, 95,138,226, 16, 32,160,227,  1, 76,160,227, 52, 32,141,229,
/* 0x1a90 */   1,  0,160,227,  5, 16,160,225, 11,  1,  0,235,  4, 48, 80,224,
/* 0x1aa0 */ 158,  0,  0, 58, 52, 80,157,229,  3, 80,133,224, 52, 80,141,229,
/* 0x1ab0 */   0, 16,157,229,  4,  0, 86,227,225,  0,  0, 42,  7, 96,134,226,
/* 0x1ac0 */   4,  0, 85,227,  3, 80,160, 35,133, 83,139,224, 54, 94,133,226,
/* 0x1ad0 */   1,  0,160,227, 64, 64,160,227,  5, 16,160,225, 11,  1,  0,235,
/* 0x1ae0 */   4, 48, 80,224,175,  0,  0, 58, 44, 48,141,229,  4,  0, 83,227,
/* 0x1af0 */ 221,  0,  0, 58,163, 64,160,225,  1, 64, 68,226,  1, 16,  3,226,
/* 0x1b00 */   2, 16,129,227, 14,  0, 83,227,194,  0,  0, 42, 17, 20,160,225,
/* 0x1b10 */  94,160,139,226,  3, 48, 65,224,  5,172,138,226,131,160,138,224,
/* 0x1b20 */ 206,  0,  0,234,  4, 64, 68,226,255,  0,  0,235,167,112,160,225,
/* 0x1b30 */   7,  0, 92,225,  7,192, 76, 32,  1, 16,161,224,  1, 64, 84,226,
/* 0x1b40 */ 195,  0,  0, 26, 68,160,139,226,  6,172,138,226,  1, 18,160,225,
/* 0x1b50 */   4, 64,160,227,  0, 16,141,229,  1, 80,160,227,  1,  0,160,227,
/* 0x1b60 */  10, 16,160,225, 11,  1,  0,235,  1,  0, 16,227,216,  0,  0, 10,
/* 0x1b70 */   0, 16,157,229,  5, 16,129,225,  0, 16,141,229,133, 80,160,225,
/* 0x1b80 */   1, 64, 84,226,209,  0,  0, 26,  0, 16,157,229,222,  0,  0,234,
/* 0x1b90 */  44, 16,157,229,  1, 16,145,226,  0, 16,141,229, 52, 80,157,229,
/* 0x1ba0 */  36, 48,157,229,  2, 80,133,226,  3, 48, 73,224,  3,  0, 81,225,
/* 0x1bb0 */ 253,  0,  0,138, 40, 32,157,229,  1,  0, 89,231,  1,  0,201,228,
/* 0x1bc0 */   2,  0, 89,225,241,  0,  0, 42,  1, 80, 85,226,231,  0,  0, 26,
/* 0x1bd0 */  28,  0,205,229, 40, 32,157,229,  2,  0, 89,225, 33,  0,  0, 58,
/* 0x1be0 */ 255,  0,  0,235,  0,  0,160,227, 32, 32,157,229,  2, 48, 72,224,
/* 0x1bf0 */  56, 32,157,229,  0, 48,130,229, 36, 32,157,229,  2, 48, 73,224,
/* 0x1c00 */ 104, 32,157,229,  0, 48,130,229, 60,208,141,226,240,143,189,232,
/* 0x1c10 */   1,  0,160,227,243,  0,  0,234,  1,  4, 87,227, 14,240,160, 33,
/* 0x1c20 */  48, 48,157,229,  7,116,160,225,  8,  0, 83,225,253,  0,  0, 10,
/* 0x1c30 */   1, 48,216,228, 12,196,131,225, 14,240,160,225,  6,  0,160,225,
/* 0x1c40 */ 128, 16,129,224,  0,  0,160,227,128, 16,129,224,  1,  4, 87,227,
/* 0x1c50 */  14, 32,160,225,  1,  1,  0, 59,176, 48,209,225,167,229,160,225,
/* 0x1c60 */ 147, 14, 14,224, 14,  0, 92,225, 14,112,160, 49, 14,112, 71, 32,
/* 0x1c70 */   2,235, 99, 50, 14,192, 76, 32,174, 50,131, 48,163, 50, 67, 32,
/* 0x1c80 */   0,  0,176,224,176, 48,193,225,  2,240,160,225,  0, 46,115,121,
/* 0x1c90 */ 109,116, 97, 98,  0, 46,115,116,114,116, 97, 98,  0, 46,115,104,
/* 0x1ca0 */ 115,116,114,116, 97, 98,  0, 46,114,101,108, 83, 79, 95, 72, 69,
/* 0x1cb0 */  65, 68,  0,112,116,114, 95, 78, 69, 88, 84,  0, 46,114,101,108,
/* 0x1cc0 */  83, 79, 95, 84, 65, 73, 76,  0, 46,114,101,108, 83, 79, 95, 77,
/* 0x1cd0 */  65, 73, 78,  0, 46,114,101,108, 69, 88, 80, 95, 72, 69, 65, 68,
/* 0x1ce0 */   0, 69, 88, 80, 95, 84, 65, 73, 76,  0, 46,114,101,108, 78, 82,
/* 0x1cf0 */  86, 50, 69,  0, 46,114,101,108, 78, 82, 86, 50, 68,  0, 46,114,
/* 0x1d00 */ 101,108, 78, 82, 86, 50, 66,  0, 46,114,101,108, 76, 90, 77, 65,
/* 0x1d10 */  95, 69, 76, 70, 48, 48,  0, 46,114,101,108, 76, 90, 77, 65, 95,
/* 0x1d20 */  68, 69, 67, 50, 48,  0, 46,114,101,108, 76, 90, 77, 65, 95, 68,
/* 0x1d30 */  69, 67, 49, 48,  0, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48,  0,
/* 0x1d40 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1d50 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1d60 */   0,  0,  0,  0,  0,  0,  0,  0, 31,  0,  0,  0,  1,  0,  0,  0,
/* 0x1d70 */   6,  0,  0,  0,  0,  0,  0,  0, 52,  0,  0,  0, 32,  0,  0,  0,
/* 0x1d80 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x1d90 */  27,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1da0 */  88, 38,  0,  0,  8,  0,  0,  0, 25,  0,  0,  0,  1,  0,  0,  0,
/* 0x1db0 */   4,  0,  0,  0,  8,  0,  0,  0, 39,  0,  0,  0,  1,  0,  0,  0,
/* 0x1dc0 */   6,  0,  0,  0,  0,  0,  0,  0, 84,  0,  0,  0,  8,  0,  0,  0,
/* 0x1dd0 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x1de0 */  52,  0,  0,  0,  1,  0,  0,  0,  6,  0,  0,  0,  0,  0,  0,  0,
/* 0x1df0 */  92,  0,  0,  0,212,  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1e00 */   4,  0,  0,  0,  0,  0,  0,  0, 48,  0,  0,  0,  9,  0,  0,  0,
/* 0x1e10 */   0,  0,  0,  0,  0,  0,  0,  0, 96, 38,  0,  0,136,  0,  0,  0,
/* 0x1e20 */  25,  0,  0,  0,  4,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0,
/* 0x1e30 */  64,  0,  0,  0,  1,  0,  0,  0,  6,  0,  0,  0,  0,  0,  0,  0,
/* 0x1e40 */  48,  3,  0,  0, 68,  7,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1e50 */   4,  0,  0,  0,  0,  0,  0,  0, 60,  0,  0,  0,  9,  0,  0,  0,
/* 0x1e60 */   0,  0,  0,  0,  0,  0,  0,  0,232, 38,  0,  0,216,  2,  0,  0,
/* 0x1e70 */  25,  0,  0,  0,  6,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0,
/* 0x1e80 */  76,  0,  0,  0,  1,  0,  0,  0,  6,  0,  0,  0,  0,  0,  0,  0,
/* 0x1e90 */ 116, 10,  0,  0,220,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1ea0 */   1,  0,  0,  0,  0,  0,  0,  0, 72,  0,  0,  0,  9,  0,  0,  0,
/* 0x1eb0 */   0,  0,  0,  0,  0,  0,  0,  0,192, 41,  0,  0, 56,  0,  0,  0,
/* 0x1ec0 */  25,  0,  0,  0,  8,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0,
/* 0x1ed0 */  85,  0,  0,  0,  1,  0,  0,  0,  6,  0,  0,  0,  0,  0,  0,  0,
/* 0x1ee0 */  80, 11,  0,  0, 36,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1ef0 */   1,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,  1,  0,  0,  0,
/* 0x1f00 */   6,  0,  0,  0,  0,  0,  0,  0,116, 11,  0,  0, 20,  1,  0,  0,
/* 0x1f10 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x1f20 */  94,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1f30 */ 248, 41,  0,  0,184,  0,  0,  0, 25,  0,  0,  0, 11,  0,  0,  0,
/* 0x1f40 */   4,  0,  0,  0,  8,  0,  0,  0,108,  0,  0,  0,  1,  0,  0,  0,
/* 0x1f50 */   6,  0,  0,  0,  0,  0,  0,  0,136, 12,  0,  0,  0,  1,  0,  0,
/* 0x1f60 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x1f70 */ 104,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1f80 */ 176, 42,  0,  0,152,  0,  0,  0, 25,  0,  0,  0, 13,  0,  0,  0,
/* 0x1f90 */   4,  0,  0,  0,  8,  0,  0,  0,118,  0,  0,  0,  1,  0,  0,  0,
/* 0x1fa0 */   6,  0,  0,  0,  0,  0,  0,  0,136, 13,  0,  0,196,  0,  0,  0,
/* 0x1fb0 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x1fc0 */ 114,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1fd0 */  72, 43,  0,  0,120,  0,  0,  0, 25,  0,  0,  0, 15,  0,  0,  0,
/* 0x1fe0 */   4,  0,  0,  0,  8,  0,  0,  0,128,  0,  0,  0,  1,  0,  0,  0,
/* 0x1ff0 */   0,  0,  0,  0,  0,  0,  0,  0, 76, 14,  0,  0,144,  0,  0,  0,
/* 0x2000 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x2010 */ 124,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2020 */ 192, 43,  0,  0, 32,  0,  0,  0, 25,  0,  0,  0, 17,  0,  0,  0,
/* 0x2030 */   4,  0,  0,  0,  8,  0,  0,  0,143,  0,  0,  0,  1,  0,  0,  0,
/* 0x2040 */   0,  0,  0,  0,  0,  0,  0,  0,220, 14,  0,  0, 56,  9,  0,  0,
/* 0x2050 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x2060 */ 139,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2070 */ 224, 43,  0,  0, 72,  2,  0,  0, 25,  0,  0,  0, 19,  0,  0,  0,
/* 0x2080 */   4,  0,  0,  0,  8,  0,  0,  0,158,  0,  0,  0,  1,  0,  0,  0,
/* 0x2090 */   0,  0,  0,  0,  0,  0,  0,  0, 20, 24,  0,  0,120,  4,  0,  0,
/* 0x20a0 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x20b0 */ 154,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x20c0 */  40, 46,  0,  0,176,  1,  0,  0, 25,  0,  0,  0, 21,  0,  0,  0,
/* 0x20d0 */   4,  0,  0,  0,  8,  0,  0,  0,169,  0,  0,  0,  1,  0,  0,  0,
/* 0x20e0 */   0,  0,  0,  0,  0,  0,  0,  0,140, 28,  0,  0,  0,  0,  0,  0,
/* 0x20f0 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x2100 */  17,  0,  0,  0,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2110 */ 140, 28,  0,  0,180,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2120 */   1,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  2,  0,  0,  0,
/* 0x2130 */   0,  0,  0,  0,  0,  0,  0,  0,120, 33,  0,  0, 96,  3,  0,  0,
/* 0x2140 */  26,  0,  0,  0, 14,  0,  0,  0,  4,  0,  0,  0, 16,  0,  0,  0,
/* 0x2150 */   9,  0,  0,  0,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2160 */ 216, 36,  0,  0,125,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2170 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2180 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2190 */   0,  0,  0,  0,  3,  0,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x21a0 */   0,  0,  0,  0,  3,  0,  6,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x21b0 */   0,  0,  0,  0,  3,  0,  8,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x21c0 */   0,  0,  0,  0,  3,  0, 11,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x21d0 */   0,  0,  0,  0,  3,  0, 13,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x21e0 */   0,  0,  0,  0,  3,  0, 15,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x21f0 */   0,  0,  0,  0,  3,  0, 17,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2200 */   0,  0,  0,  0,  3,  0, 19,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2210 */   0,  0,  0,  0,  3,  0, 21,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2220 */   0,  0,  0,  0,  3,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2230 */   0,  0,  0,  0,  3,  0,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2240 */   0,  0,  0,  0,  3,  0, 10,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2250 */   0,  0,  0,  0,  3,  0, 23,  0,  1,  0,  0,  0,172,  0,  0,  0,
/* 0x2260 */   0,  0,  0,  0, 16,  0,  4,  0,  6,  0,  0,  0,112,  0,  0,  0,
/* 0x2270 */   0,  0,  0,  0, 16,  0,  8,  0, 15,  0,  0,  0,244,  0,  0,  0,
/* 0x2280 */   0,  0,  0,  0, 16,  0,  4,  0, 22,  0,  0,  0, 12,  1,  0,  0,
/* 0x2290 */   0,  0,  0,  0, 16,  0,  4,  0, 37,  0,  0,  0, 72,  0,  0,  0,
/* 0x22a0 */   0,  0,  0,  0, 16,  0,  4,  0, 44,  0,  0,  0, 44,  1,  0,  0,
/* 0x22b0 */   0,  0,  0,  0, 16,  0,  4,  0, 51,  0,  0,  0, 88,  0,  0,  0,
/* 0x22c0 */   0,  0,  0,  0, 16,  0,  4,  0, 60,  0,  0,  0,120,  2,  0,  0,
/* 0x22d0 */   0,  0,  0,  0, 16,  0,  4,  0, 70,  0,  0,  0, 96,  0,  0,  0,
/* 0x22e0 */   0,  0,  0,  0, 16,  0,  4,  0, 80,  0,  0,  0, 40,  0,  0,  0,
/* 0x22f0 */   0,  0,  0,  0, 16,  0,  4,  0, 86,  0,  0,  0,188,  0,  0,  0,
/* 0x2300 */   0,  0,  0,  0, 16,  0,  4,  0, 91,  0,  0,  0,  0,  1,  0,  0,
/* 0x2310 */   0,  0,  0,  0, 16,  0,  4,  0,105,  0,  0,  0,  0,  0,  0,  0,
/* 0x2320 */   0,  0,  0,  0, 18,  0, 10,  0,109,  0,  0,  0, 20,  1,  0,  0,
/* 0x2330 */   0,  0,  0,  0, 16,  0,  4,  0,123,  0,  0,  0, 32,  0,  0,  0,
/* 0x2340 */   0,  0,  0,  0, 16,  0,  4,  0,129,  0,  0,  0,  0,  0,  0,  0,
/* 0x2350 */  44,  0,  0,  0, 18,  0,  6,  0,140,  0,  0,  0,  0,  0,  0,  0,
/* 0x2360 */   0,  1,  0,  0, 18,  0, 13,  0,163,  0,  0,  0,  0,  0,  0,  0,
/* 0x2370 */   0,  0,  0,  0, 16,  0,  1,  0,168,  0,  0,  0,104,  0,  0,  0,
/* 0x2380 */   0,  0,  0,  0, 16,  0,  4,  0,181,  0,  0,  0, 24,  0,  0,  0,
/* 0x2390 */   0,  0,  0,  0, 16,  0,  4,  0,186,  0,  0,  0, 64,  0,  0,  0,
/* 0x23a0 */   0,  0,  0,  0, 16,  0,  4,  0,193,  0,  0,  0,  0,  2,  0,  0,
/* 0x23b0 */   0,  0,  0,  0, 16,  0,  4,  0,202,  0,  0,  0, 80,  2,  0,  0,
/* 0x23c0 */   0,  0,  0,  0, 16,  0,  4,  0,209,  0,  0,  0,  0,  0,  0,  0,
/* 0x23d0 */ 196,  0,  0,  0, 18,  0, 15,  0,232,  0,  0,  0,220,  1,  0,  0,
/* 0x23e0 */ 168,  0,  0,  0, 18,  0,  6,  0,246,  0,  0,  0,132,  0,  0,  0,
/* 0x23f0 */   0,  0,  0,  0, 16,  0,  4,  0,  3,  1,  0,  0,104,  2,  0,  0,
/* 0x2400 */   0,  0,  0,  0, 16,  0,  4,  0, 13,  1,  0,  0, 12,  0,  0,  0,
/* 0x2410 */   0,  0,  0,  0, 16,  0,  4,  0, 21,  1,  0,  0,148,  0,  0,  0,
/* 0x2420 */   0,  0,  0,  0, 16,  0,  4,  0, 30,  1,  0,  0,  0,  0,  0,  0,
/* 0x2430 */  20,  1,  0,  0, 18,  0, 11,  0, 53,  1,  0,  0, 32,  0,  0,  0,
/* 0x2440 */   0,  0,  0,  0, 16,  0,  4,  0, 60,  1,  0,  0,228,  0,  0,  0,
/* 0x2450 */   0,  0,  0,  0, 16,  0,  4,  0, 67,  1,  0,  0, 20,  0,  0,  0,
/* 0x2460 */   0,  0,  0,  0, 16,  0,  4,  0, 72,  1,  0,  0,  0,  0,  0,  0,
/* 0x2470 */   0,  0,  0,  0, 16,  0, 21,  0, 83,  1,  0,  0, 80,  0,  0,  0,
/* 0x2480 */   0,  0,  0,  0, 16,  0,  4,  0, 87,  1,  0,  0, 48,  0,  0,  0,
/* 0x2490 */   0,  0,  0,  0, 16,  0,  4,  0, 92,  1,  0,  0,120,  2,  0,  0,
/* 0x24a0 */   0,  0,  0,  0, 16,  0,  4,  0, 98,  1,  0,  0,164,  0,  0,  0,
/* 0x24b0 */   0,  0,  0,  0, 16,  0,  4,  0,107,  1,  0,  0, 56,  0,  0,  0,
/* 0x24c0 */   0,  0,  0,  0, 16,  0,  4,  0,113,  1,  0,  0,132,  2,  0,  0,
/* 0x24d0 */ 192,  4,  0,  0, 18,  0,  6,  0,  0, 80,109, 97,112,  0,102, 95,
/* 0x24e0 */ 101,120,112, 97,110,100,  0,109,117,110,109, 97,112,  0,103,101,
/* 0x24f0 */ 116, 95,115,121,115, 95,109,117,110,109, 97,112,  0,103,101,116,
/* 0x2500 */ 112,105,100,  0,109,101,109, 99,112,121,  0,114,101, 97,100,108,
/* 0x2510 */ 105,110,107,  0, 95, 95,117,100,105,118,115,105, 51,  0,102,116,
/* 0x2520 */ 114,117,110, 99, 97,116,101,  0,108,115,101,101,107,  0,109,109,
/* 0x2530 */  97,112,  0, 95, 95, 99,108,101, 97,114, 95, 99, 97, 99,104,101,
/* 0x2540 */   0,101,111,102,  0,109,109, 97,112, 95,112,114,105,118, 97,110,
/* 0x2550 */ 111,110,  0,119,114,105,116,101,  0, 80, 70, 95,116,111, 95, 80,
/* 0x2560 */  82, 79, 84,  0,117, 99,108, 95,110,114,118, 50,100, 95,100,101,
/* 0x2570 */  99,111,109,112,114,101,115,115, 95, 56,  0,102,111,108,100,  0,
/* 0x2580 */ 109,101,109,102,100, 95, 99,114,101, 97,116,101,  0,114,101, 97,
/* 0x2590 */ 100,  0,117,110,108,105,110,107,  0,117,110,100,101,114,108, 97,
/* 0x25a0 */ 121,  0,109,101,109,115,101,116,  0,117, 99,108, 95,110,114,118,
/* 0x25b0 */  50, 98, 95,100,101, 99,111,109,112,114,101,115,115, 95, 56,  0,
/* 0x25c0 */ 103,101,116, 95, 80, 65, 71, 69, 95, 77, 65, 83, 75,  0,117,112,
/* 0x25d0 */ 120,102,100, 95, 99,114,101, 97,116,101,  0,109,121, 95, 97,108,
/* 0x25e0 */ 108,111, 99, 97,  0,109,121, 95, 98,107,112,116,  0, 80,112,114,
/* 0x25f0 */ 111,116,101, 99,116,  0,117, 99,108, 95,110,114,118, 50,101, 95,
/* 0x2600 */ 100,101, 99,111,109,112,114,101,115,115, 95, 56,  0, 80,119,114,
/* 0x2610 */ 105,116,101,  0, 80,117,110,109, 97,112,  0,101,120,105,116,  0,
/* 0x2620 */  76,122,109, 97, 68,101, 99,111,100,101,  0, 98,114,107,  0,111,
/* 0x2630 */ 112,101,110,  0,100,105,118, 49, 48,  0,109,112,114,111,116,101,
/* 0x2640 */  99,116,  0, 99,108,111,115,101,  0,117,112,120, 95,115,111, 95,
/* 0x2650 */ 109, 97,105,110,  0,  0,  0,  0,  8,  0,  0,  0,  1, 53,  0,  0,
/* 0x2660 */  40,  1,  0,  0,  1,  1,  0,  0, 60,  1,  0,  0,  1,  1,  0,  0,
/* 0x2670 */  80,  1,  0,  0,  1,  1,  0,  0, 92,  1,  0,  0,  1,  1,  0,  0,
/* 0x2680 */ 104,  1,  0,  0,  1,  1,  0,  0,148,  1,  0,  0,  1,  1,  0,  0,
/* 0x2690 */ 160,  1,  0,  0,  1,  1,  0,  0,176,  1,  0,  0,  1,  1,  0,  0,
/* 0x26a0 */ 188,  1,  0,  0,  1,  1,  0,  0,204,  1,  0,  0,  1,  1,  0,  0,
/* 0x26b0 */ 212,  1,  0,  0,  1,  1,  0,  0,236,  1,  0,  0,  1,  1,  0,  0,
/* 0x26c0 */ 248,  1,  0,  0,  1,  1,  0,  0, 28,  2,  0,  0,  1, 19,  0,  0,
/* 0x26d0 */  56,  2,  0,  0,  1, 27,  0,  0, 68,  2,  0,  0,  1, 19,  0,  0,
/* 0x26e0 */  96,  2,  0,  0,  1, 36,  0,  0,  4,  0,  0,  0,  1,  2,  0,  0,
/* 0x26f0 */  48,  0,  0,  0,  1, 41,  0,  0, 56,  0,  0,  0,  1, 46,  0,  0,
/* 0x2700 */  88,  0,  0,  0,  1,  2,  0,  0,100,  0,  0,  0,  1,  2,  0,  0,
/* 0x2710 */ 132,  0,  0,  0,  1,  2,  0,  0,188,  0,  0,  0,  1,  2,  0,  0,
/* 0x2720 */ 204,  0,  0,  0,  1,  2,  0,  0,216,  0,  0,  0,  1,  2,  0,  0,
/* 0x2730 */ 236,  0,  0,  0,  1,  2,  0,  0,248,  0,  0,  0,  1,  2,  0,  0,
/* 0x2740 */   0,  1,  0,  0,  1,  2,  0,  0,  4,  1,  0,  0,  1,  2,  0,  0,
/* 0x2750 */  20,  1,  0,  0,  1,  2,  0,  0, 32,  1,  0,  0,  1,  2,  0,  0,
/* 0x2760 */  44,  1,  0,  0,  1,  2,  0,  0, 52,  1,  0,  0,  1,  2,  0,  0,
/* 0x2770 */  68,  1,  0,  0,  1,  2,  0,  0, 92,  1,  0,  0,  1, 15,  0,  0,
/* 0x2780 */ 100,  1,  0,  0,  1,  2,  0,  0,116,  1,  0,  0,  1,  2,  0,  0,
/* 0x2790 */ 124,  1,  0,  0,  1,  2,  0,  0,156,  1,  0,  0,  1,  2,  0,  0,
/* 0x27a0 */ 168,  1,  0,  0,  1,  2,  0,  0,204,  1,  0,  0,  1,  2,  0,  0,
/* 0x27b0 */ 228,  1,  0,  0,  1,  2,  0,  0,  4,  2,  0,  0,  1, 49,  0,  0,
/* 0x27c0 */  12,  2,  0,  0,  1,  2,  0,  0, 28,  2,  0,  0,  1, 33,  0,  0,
/* 0x27d0 */  44,  2,  0,  0,  1, 52,  0,  0, 52,  2,  0,  0,  1,  2,  0,  0,
/* 0x27e0 */  68,  2,  0,  0,  1,  2,  0,  0, 72,  2,  0,  0,  1,  2,  0,  0,
/* 0x27f0 */  84,  2,  0,  0,  1,  2,  0,  0, 96,  2,  0,  0,  1,  2,  0,  0,
/* 0x2800 */ 112,  2,  0,  0,  1,  2,  0,  0,152,  2,  0,  0,  1, 38,  0,  0,
/* 0x2810 */ 224,  2,  0,  0,  1, 24,  0,  0,240,  2,  0,  0,  1, 19,  0,  0,
/* 0x2820 */  28,  3,  0,  0,  1,  2,  0,  0, 52,  3,  0,  0,  1,  2,  0,  0,
/* 0x2830 */  68,  3,  0,  0,  1,  2,  0,  0, 96,  3,  0,  0,  1,  2,  0,  0,
/* 0x2840 */ 100,  3,  0,  0,  1, 39,  0,  0,124,  3,  0,  0,  1, 44,  0,  0,
/* 0x2850 */ 144,  3,  0,  0,  1, 44,  0,  0,156,  3,  0,  0,  1, 45,  0,  0,
/* 0x2860 */ 164,  3,  0,  0,  1, 29,  0,  0,196,  3,  0,  0,  1, 14,  0,  0,
/* 0x2870 */ 204,  3,  0,  0,  1, 52,  0,  0,220,  3,  0,  0,  1,  2,  0,  0,
/* 0x2880 */   0,  4,  0,  0,  1,  2,  0,  0, 12,  4,  0,  0,  1,  2,  0,  0,
/* 0x2890 */  36,  4,  0,  0,  1,  2,  0,  0, 72,  4,  0,  0,  1,  2,  0,  0,
/* 0x28a0 */ 180,  4,  0,  0,  1,  2,  0,  0,184,  4,  0,  0,  1, 39,  0,  0,
/* 0x28b0 */ 200,  4,  0,  0,  1,  2,  0,  0,216,  4,  0,  0,  1, 44,  0,  0,
/* 0x28c0 */ 224,  4,  0,  0,  1,  2,  0,  0,232,  4,  0,  0,  1,  2,  0,  0,
/* 0x28d0 */ 248,  4,  0,  0,  1, 23,  0,  0,  8,  5,  0,  0,  1, 44,  0,  0,
/* 0x28e0 */  20,  5,  0,  0,  1, 45,  0,  0, 52,  5,  0,  0,  1, 14,  0,  0,
/* 0x28f0 */  60,  5,  0,  0,  1,  2,  0,  0, 72,  5,  0,  0,  1, 35,  0,  0,
/* 0x2900 */ 128,  5,  0,  0,  1,  2,  0,  0,140,  5,  0,  0,  1,  2,  0,  0,
/* 0x2910 */ 152,  5,  0,  0,  1,  2,  0,  0,160,  5,  0,  0,  1, 17,  0,  0,
/* 0x2920 */ 192,  5,  0,  0,  1,  2,  0,  0,204,  5,  0,  0,  1,  2,  0,  0,
/* 0x2930 */ 240,  5,  0,  0,  1,  2,  0,  0, 24,  6,  0,  0,  1, 25,  0,  0,
/* 0x2940 */  28,  6,  0,  0,  1,  2,  0,  0, 32,  6,  0,  0,  1, 39,  0,  0,
/* 0x2950 */  48,  6,  0,  0,  1, 28,  0,  0, 80,  6,  0,  0,  1, 14,  0,  0,
/* 0x2960 */  92,  6,  0,  0,  1, 52,  0,  0, 96,  6,  0,  0,  1,  2,  0,  0,
/* 0x2970 */ 124,  6,  0,  0,  1,  2,  0,  0,140,  6,  0,  0,  1, 45,  0,  0,
/* 0x2980 */ 168,  6,  0,  0,  1, 29,  0,  0,200,  6,  0,  0,  1, 14,  0,  0,
/* 0x2990 */ 208,  6,  0,  0,  1, 52,  0,  0,212,  6,  0,  0,  1,  2,  0,  0,
/* 0x29a0 */ 236,  6,  0,  0,  1, 29,  0,  0,252,  6,  0,  0,  1, 42,  0,  0,
/* 0x29b0 */   8,  7,  0,  0,  1,  2,  0,  0, 20,  7,  0,  0,  1, 45,  0,  0,
/* 0x29c0 */  40,  0,  0,  0,  1,  3,  0,  0, 68,  0,  0,  0,  1,  3,  0,  0,
/* 0x29d0 */ 132,  0,  0,  0,  1,  3,  0,  0,148,  0,  0,  0,  1,  3,  0,  0,
/* 0x29e0 */ 168,  0,  0,  0,  1,  3,  0,  0,184,  0,  0,  0,  1,  3,  0,  0,
/* 0x29f0 */ 204,  0,  0,  0,  1, 25,  0,  0, 16,  0,  0,  0,  1,  4,  0,  0,
/* 0x2a00 */  68,  0,  0,  0,  1,  4,  0,  0, 72,  0,  0,  0,  1,  4,  0,  0,
/* 0x2a10 */  80,  0,  0,  0,  1,  4,  0,  0, 92,  0,  0,  0,  1,  4,  0,  0,
/* 0x2a20 */ 104,  0,  0,  0,  1,  4,  0,  0,116,  0,  0,  0,  1,  4,  0,  0,
/* 0x2a30 */ 120,  0,  0,  0,  1,  4,  0,  0,132,  0,  0,  0,  1,  4,  0,  0,
/* 0x2a40 */ 148,  0,  0,  0,  1,  4,  0,  0,156,  0,  0,  0,  1,  4,  0,  0,
/* 0x2a50 */ 160,  0,  0,  0,  1,  4,  0,  0,168,  0,  0,  0,  1,  4,  0,  0,
/* 0x2a60 */ 172,  0,  0,  0,  1,  4,  0,  0,184,  0,  0,  0,  1,  4,  0,  0,
/* 0x2a70 */ 188,  0,  0,  0,  1,  4,  0,  0,196,  0,  0,  0,  1,  4,  0,  0,
/* 0x2a80 */ 208,  0,  0,  0,  1,  4,  0,  0,212,  0,  0,  0,  1,  4,  0,  0,
/* 0x2a90 */ 220,  0,  0,  0,  1,  4,  0,  0,228,  0,  0,  0,  1,  4,  0,  0,
/* 0x2aa0 */  12,  1,  0,  0,  1,  4,  0,  0, 16,  1,  0,  0,  1,  4,  0,  0,
/* 0x2ab0 */  16,  0,  0,  0,  1,  5,  0,  0, 68,  0,  0,  0,  1,  5,  0,  0,
/* 0x2ac0 */  72,  0,  0,  0,  1,  5,  0,  0, 80,  0,  0,  0,  1,  5,  0,  0,
/* 0x2ad0 */  92,  0,  0,  0,  1,  5,  0,  0,104,  0,  0,  0,  1,  5,  0,  0,
/* 0x2ae0 */ 116,  0,  0,  0,  1,  5,  0,  0,120,  0,  0,  0,  1,  5,  0,  0,
/* 0x2af0 */ 132,  0,  0,  0,  1,  5,  0,  0,148,  0,  0,  0,  1,  5,  0,  0,
/* 0x2b00 */ 156,  0,  0,  0,  1,  5,  0,  0,164,  0,  0,  0,  1,  5,  0,  0,
/* 0x2b10 */ 176,  0,  0,  0,  1,  5,  0,  0,184,  0,  0,  0,  1,  5,  0,  0,
/* 0x2b20 */ 196,  0,  0,  0,  1,  5,  0,  0,208,  0,  0,  0,  1,  5,  0,  0,
/* 0x2b30 */ 212,  0,  0,  0,  1,  5,  0,  0,248,  0,  0,  0,  1,  5,  0,  0,
/* 0x2b40 */ 252,  0,  0,  0,  1,  5,  0,  0, 16,  0,  0,  0,  1,  6,  0,  0,
/* 0x2b50 */  72,  0,  0,  0,  1,  6,  0,  0, 80,  0,  0,  0,  1,  6,  0,  0,
/* 0x2b60 */  84,  0,  0,  0,  1,  6,  0,  0,100,  0,  0,  0,  1,  6,  0,  0,
/* 0x2b70 */ 104,  0,  0,  0,  1,  6,  0,  0,108,  0,  0,  0,  1,  6,  0,  0,
/* 0x2b80 */ 120,  0,  0,  0,  1,  6,  0,  0,136,  0,  0,  0,  1,  6,  0,  0,
/* 0x2b90 */ 140,  0,  0,  0,  1,  6,  0,  0,148,  0,  0,  0,  1,  6,  0,  0,
/* 0x2ba0 */ 156,  0,  0,  0,  1,  6,  0,  0,160,  0,  0,  0,  1,  6,  0,  0,
/* 0x2bb0 */ 188,  0,  0,  0,  1,  6,  0,  0,192,  0,  0,  0,  1,  6,  0,  0,
/* 0x2bc0 */   8,  0,  0,  0,  1,  7,  0,  0, 76,  0,  0,  0,  1,  7,  0,  0,
/* 0x2bd0 */ 128,  0,  0,  0,  1,  7,  0,  0,140,  0,  0,  0,  1,  7,  0,  0,
/* 0x2be0 */ 116,  0,  0,  0,  1,  8,  0,  0,144,  0,  0,  0,  1,  8,  0,  0,
/* 0x2bf0 */ 184,  0,  0,  0,  1,  8,  0,  0,204,  0,  0,  0,  1,  8,  0,  0,
/* 0x2c00 */ 244,  0,  0,  0,  1,  8,  0,  0,  0,  1,  0,  0,  1,  8,  0,  0,
/* 0x2c10 */   8,  1,  0,  0,  1,  8,  0,  0, 68,  1,  0,  0,  1,  8,  0,  0,
/* 0x2c20 */ 144,  1,  0,  0,  1,  8,  0,  0,204,  1,  0,  0,  1,  8,  0,  0,
/* 0x2c30 */ 216,  1,  0,  0,  1,  8,  0,  0,  4,  2,  0,  0,  1,  8,  0,  0,
/* 0x2c40 */  24,  2,  0,  0,  1,  8,  0,  0, 32,  2,  0,  0,  1,  8,  0,  0,
/* 0x2c50 */  52,  2,  0,  0,  1,  8,  0,  0, 60,  2,  0,  0,  1,  8,  0,  0,
/* 0x2c60 */  64,  2,  0,  0,  1,  8,  0,  0, 76,  2,  0,  0,  1,  8,  0,  0,
/* 0x2c70 */  88,  2,  0,  0,  1,  8,  0,  0,164,  2,  0,  0,  1,  8,  0,  0,
/* 0x2c80 */ 200,  2,  0,  0,  1,  8,  0,  0,232,  2,  0,  0,  1,  8,  0,  0,
/* 0x2c90 */   4,  3,  0,  0,  1,  8,  0,  0, 12,  3,  0,  0,  1,  8,  0,  0,
/* 0x2ca0 */  60,  3,  0,  0,  1,  8,  0,  0,136,  3,  0,  0,  1,  8,  0,  0,
/* 0x2cb0 */ 160,  3,  0,  0,  1,  8,  0,  0,168,  3,  0,  0,  1,  8,  0,  0,
/* 0x2cc0 */ 204,  3,  0,  0,  1,  8,  0,  0,224,  3,  0,  0,  1,  8,  0,  0,
/* 0x2cd0 */ 232,  3,  0,  0,  1,  8,  0,  0, 36,  4,  0,  0,  1,  8,  0,  0,
/* 0x2ce0 */  56,  4,  0,  0,  1,  8,  0,  0,108,  4,  0,  0,  1,  8,  0,  0,
/* 0x2cf0 */ 132,  4,  0,  0,  1,  8,  0,  0,140,  4,  0,  0,  1,  8,  0,  0,
/* 0x2d00 */ 176,  4,  0,  0,  1,  8,  0,  0,212,  4,  0,  0,  1,  8,  0,  0,
/* 0x2d10 */ 236,  4,  0,  0,  1,  8,  0,  0,244,  4,  0,  0,  1,  8,  0,  0,
/* 0x2d20 */  24,  5,  0,  0,  1,  8,  0,  0, 60,  5,  0,  0,  1,  8,  0,  0,
/* 0x2d30 */ 152,  5,  0,  0,  1,  8,  0,  0,160,  5,  0,  0,  1,  8,  0,  0,
/* 0x2d40 */ 192,  5,  0,  0,  1,  8,  0,  0,228,  5,  0,  0,  1,  8,  0,  0,
/* 0x2d50 */ 252,  5,  0,  0,  1,  8,  0,  0,  4,  6,  0,  0,  1,  8,  0,  0,
/* 0x2d60 */  36,  6,  0,  0,  1,  8,  0,  0, 72,  6,  0,  0,  1,  8,  0,  0,
/* 0x2d70 */ 128,  6,  0,  0,  1,  8,  0,  0,140,  6,  0,  0,  1,  8,  0,  0,
/* 0x2d80 */ 208,  6,  0,  0,  1,  8,  0,  0,236,  6,  0,  0,  1,  8,  0,  0,
/* 0x2d90 */  28,  7,  0,  0,  1,  8,  0,  0, 40,  7,  0,  0,  1,  8,  0,  0,
/* 0x2da0 */ 108,  7,  0,  0,  1,  8,  0,  0,124,  7,  0,  0,  1,  8,  0,  0,
/* 0x2db0 */ 156,  7,  0,  0,  1,  8,  0,  0,184,  7,  0,  0,  1,  8,  0,  0,
/* 0x2dc0 */ 196,  7,  0,  0,  1,  8,  0,  0,208,  7,  0,  0,  1,  8,  0,  0,
/* 0x2dd0 */ 244,  7,  0,  0,  1,  8,  0,  0, 32,  8,  0,  0,  1,  8,  0,  0,
/* 0x2de0 */  44,  8,  0,  0,  1,  8,  0,  0,124,  8,  0,  0,  1,  8,  0,  0,
/* 0x2df0 */ 136,  8,  0,  0,  1,  8,  0,  0,160,  8,  0,  0,  1,  8,  0,  0,
/* 0x2e00 */ 232,  8,  0,  0,  1,  8,  0,  0,244,  8,  0,  0,  1,  8,  0,  0,
/* 0x2e10 */ 252,  8,  0,  0,  1,  8,  0,  0,  4,  9,  0,  0,  1,  8,  0,  0,
/* 0x2e20 */  40,  9,  0,  0,  1,  8,  0,  0,120,  0,  0,  0,  1,  9,  0,  0,
/* 0x2e30 */ 128,  0,  0,  0,  1,  9,  0,  0,136,  0,  0,  0,  1,  9,  0,  0,
/* 0x2e40 */ 168,  0,  0,  0,  1,  9,  0,  0,172,  0,  0,  0,  1,  9,  0,  0,
/* 0x2e50 */ 228,  0,  0,  0,  1,  9,  0,  0,  0,  1,  0,  0,  1,  9,  0,  0,
/* 0x2e60 */  12,  1,  0,  0,  1,  9,  0,  0, 20,  1,  0,  0,  1,  9,  0,  0,
/* 0x2e70 */  24,  1,  0,  0,  1,  9,  0,  0, 32,  1,  0,  0,  1,  9,  0,  0,
/* 0x2e80 */  40,  1,  0,  0,  1,  9,  0,  0, 68,  1,  0,  0,  1,  9,  0,  0,
/* 0x2e90 */  76,  1,  0,  0,  1,  9,  0,  0, 80,  1,  0,  0,  1,  9,  0,  0,
/* 0x2ea0 */ 128,  1,  0,  0,  1,  9,  0,  0,136,  1,  0,  0,  1,  9,  0,  0,
/* 0x2eb0 */ 140,  1,  0,  0,  1,  9,  0,  0,156,  1,  0,  0,  1,  9,  0,  0,
/* 0x2ec0 */ 160,  1,  0,  0,  1,  9,  0,  0,192,  1,  0,  0,  1,  9,  0,  0,
/* 0x2ed0 */ 204,  1,  0,  0,  1,  9,  0,  0,212,  1,  0,  0,  1,  9,  0,  0,
/* 0x2ee0 */ 220,  1,  0,  0,  1,  9,  0,  0,228,  1,  0,  0,  1,  9,  0,  0,
/* 0x2ef0 */ 236,  1,  0,  0,  1,  9,  0,  0, 40,  2,  0,  0,  1,  9,  0,  0,
/* 0x2f00 */  44,  2,  0,  0,  1,  9,  0,  0, 68,  2,  0,  0,  1,  9,  0,  0,
/* 0x2f10 */  76,  2,  0,  0,  1,  9,  0,  0, 80,  2,  0,  0,  1,  9,  0,  0,
/* 0x2f20 */ 104,  2,  0,  0,  1,  9,  0,  0,132,  2,  0,  0,  1,  9,  0,  0,
/* 0x2f30 */ 140,  2,  0,  0,  1,  9,  0,  0,164,  2,  0,  0,  1,  9,  0,  0,
/* 0x2f40 */ 200,  2,  0,  0,  1,  9,  0,  0,208,  2,  0,  0,  1,  9,  0,  0,
/* 0x2f50 */ 220,  2,  0,  0,  1,  9,  0,  0,244,  2,  0,  0,  1,  9,  0,  0,
/* 0x2f60 */  12,  3,  0,  0,  1,  9,  0,  0, 20,  3,  0,  0,  1,  9,  0,  0,
/* 0x2f70 */  44,  3,  0,  0,  1,  9,  0,  0, 80,  3,  0,  0,  1,  9,  0,  0,
/* 0x2f80 */  88,  3,  0,  0,  1,  9,  0,  0,112,  3,  0,  0,  1,  9,  0,  0,
/* 0x2f90 */ 120,  3,  0,  0,  1,  9,  0,  0,156,  3,  0,  0,  1,  9,  0,  0,
/* 0x2fa0 */ 176,  3,  0,  0,  1,  9,  0,  0,184,  3,  0,  0,  1,  9,  0,  0,
/* 0x2fb0 */ 200,  3,  0,  0,  1,  9,  0,  0,204,  3,  0,  0,  1,  9,  0,  0,
/* 0x2fc0 */   0,  4,  0,  0,  1,  9,  0,  0, 24,  4,  0,  0,  1,  9,  0,  0,
/* 0x2fd0 */  64,  4,  0,  0,  1,  9,  0,  0,102,105,108,101, 32,102,111,114,
/* 0x2fe0 */ 109, 97,116, 32,101,108,102, 51, 50, 45,108,105,116,116,108,101,
/* 0x2ff0 */  97,114,109, 10, 10, 83,101, 99,116,105,111,110,115, 58, 10, 73,
/* 0x3000 */ 100,120, 32, 78, 97,109,101, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3010 */  32, 83,105,122,101, 32, 32, 32, 32, 32, 32, 86, 77, 65, 32, 32,
/* 0x3020 */  32, 32, 32, 32, 32, 76, 77, 65, 32, 32, 32, 32, 32, 32, 32, 70,
/* 0x3030 */ 105,108,101, 32,111,102,102, 32, 32, 65,108,103,110, 32, 32, 70,
/* 0x3040 */ 108, 97,103,115, 10, 32, 32, 48, 32, 83, 79, 95, 72, 69, 65, 68,
/* 0x3050 */  32, 32, 32, 32, 32, 32, 32, 48, 50, 48, 32, 32, 48, 32, 32, 48,
/* 0x3060 */  32, 32, 48, 51, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x3070 */  84, 69, 78, 84, 83, 10, 32, 32, 49, 32,112,116,114, 95, 78, 69,
/* 0x3080 */  88, 84, 32, 32, 32, 32, 32, 32, 48, 56, 32, 32, 48, 32, 32, 48,
/* 0x3090 */  32, 32, 48, 53, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x30a0 */  84, 69, 78, 84, 83, 10, 32, 32, 50, 32, 83, 79, 95, 84, 65, 73,
/* 0x30b0 */  76, 32, 32, 32, 32, 32, 32, 32, 48, 50,100, 52, 32, 32, 48, 32,
/* 0x30c0 */  32, 48, 32, 32, 48, 53, 99, 32, 32, 50, 42, 42, 50, 32, 32, 67,
/* 0x30d0 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 51, 32, 83, 79, 95, 77,
/* 0x30e0 */  65, 73, 78, 32, 32, 32, 32, 32, 32, 32, 48, 55, 52, 52, 32, 32,
/* 0x30f0 */  48, 32, 32, 48, 32, 32, 48, 51, 51, 48, 32, 32, 50, 42, 42, 50,
/* 0x3100 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 52, 32, 69,
/* 0x3110 */  88, 80, 95, 72, 69, 65, 68, 32, 32, 32, 32, 32, 32, 48,100, 99,
/* 0x3120 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 97, 55, 52, 32, 32, 50, 42,
/* 0x3130 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 53,
/* 0x3140 */  32, 69, 88, 80, 95, 84, 65, 73, 76, 32, 32, 32, 32, 32, 32, 48,
/* 0x3150 */  50, 52, 32, 32, 48, 32, 32, 48, 32, 32, 48, 98, 53, 48, 32, 32,
/* 0x3160 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x3170 */  32, 54, 32, 78, 82, 86, 50, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3180 */  32, 48, 49, 49, 52, 32, 32, 48, 32, 32, 48, 32, 32, 48, 98, 55,
/* 0x3190 */  52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x31a0 */  83, 10, 32, 32, 55, 32, 78, 82, 86, 50, 68, 32, 32, 32, 32, 32,
/* 0x31b0 */  32, 32, 32, 32, 48, 49, 48, 48, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x31c0 */  48, 99, 56, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x31d0 */  69, 78, 84, 83, 10, 32, 32, 56, 32, 78, 82, 86, 50, 66, 32, 32,
/* 0x31e0 */  32, 32, 32, 32, 32, 32, 32, 48, 99, 52, 32, 32, 48, 32, 32, 48,
/* 0x31f0 */  32, 32, 48,100, 56, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x3200 */  78, 84, 69, 78, 84, 83, 10, 32, 32, 57, 32, 76, 90, 77, 65, 95,
/* 0x3210 */  69, 76, 70, 48, 48, 32, 32, 32, 32, 48, 57, 48, 32, 32, 48, 32,
/* 0x3220 */  32, 48, 32, 32, 48,101, 52, 99, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x3230 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 48, 32, 76, 90, 77,
/* 0x3240 */  65, 95, 68, 69, 67, 50, 48, 32, 32, 32, 32, 48, 57, 51, 56, 32,
/* 0x3250 */  32, 48, 32, 32, 48, 32, 32, 48,101,100, 99, 32, 32, 50, 42, 42,
/* 0x3260 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 49, 32,
/* 0x3270 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 32, 32, 32, 32, 48, 52,
/* 0x3280 */  55, 56, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 56, 49, 52, 32,
/* 0x3290 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x32a0 */  32, 49, 50, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 32, 32,
/* 0x32b0 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 99, 56, 99,
/* 0x32c0 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x32d0 */  10, 83, 89, 77, 66, 79, 76, 32, 84, 65, 66, 76, 69, 58, 10, 48,
/* 0x32e0 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x32f0 */  83, 79, 95, 84, 65, 73, 76, 32, 48, 32, 83, 79, 95, 84, 65, 73,
/* 0x3300 */  76, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x3310 */ 100, 32, 32, 83, 79, 95, 77, 65, 73, 78, 32, 48, 32, 83, 79, 95,
/* 0x3320 */  77, 65, 73, 78, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x3330 */  32, 32, 32,100, 32, 32, 69, 88, 80, 95, 72, 69, 65, 68, 32, 48,
/* 0x3340 */  32, 69, 88, 80, 95, 72, 69, 65, 68, 10, 48, 48, 48, 48, 48, 48,
/* 0x3350 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 69,
/* 0x3360 */  32, 48, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3370 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 68, 32,
/* 0x3380 */  48, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3390 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 66, 32, 48,
/* 0x33a0 */  32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x33b0 */ 108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 69, 76, 70,
/* 0x33c0 */  48, 48, 32, 48, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 10,
/* 0x33d0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x33e0 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 32, 48, 32, 76, 90,
/* 0x33f0 */  77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3400 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x3410 */  69, 67, 49, 48, 32, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,
/* 0x3420 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x3430 */ 100, 32, 32, 83, 79, 95, 72, 69, 65, 68, 32, 48, 32, 83, 79, 95,
/* 0x3440 */  72, 69, 65, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x3450 */  32, 32, 32,100, 32, 32,112,116,114, 95, 78, 69, 88, 84, 32, 48,
/* 0x3460 */  32,112,116,114, 95, 78, 69, 88, 84, 10, 48, 48, 48, 48, 48, 48,
/* 0x3470 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 69, 88, 80, 95, 84,
/* 0x3480 */  65, 73, 76, 32, 48, 32, 69, 88, 80, 95, 84, 65, 73, 76, 10, 48,
/* 0x3490 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x34a0 */  76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 32, 48, 32, 76, 90, 77,
/* 0x34b0 */  65, 95, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 97, 99,
/* 0x34c0 */  32,103, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73, 76,
/* 0x34d0 */  32, 48, 32, 80,109, 97,112, 10, 48, 48, 48, 48, 48, 48, 55, 48,
/* 0x34e0 */  32,103, 32, 32, 32, 32, 32, 32, 32, 69, 88, 80, 95, 72, 69, 65,
/* 0x34f0 */  68, 32, 48, 32,102, 95,101,120,112, 97,110,100, 10, 48, 48, 48,
/* 0x3500 */  48, 48, 48,102, 52, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 79,
/* 0x3510 */  95, 84, 65, 73, 76, 32, 48, 32,109,117,110,109, 97,112, 10, 48,
/* 0x3520 */  48, 48, 48, 48, 49, 48, 99, 32,103, 32, 32, 32, 32, 32, 32, 32,
/* 0x3530 */  83, 79, 95, 84, 65, 73, 76, 32, 48, 32,103,101,116, 95,115,121,
/* 0x3540 */ 115, 95,109,117,110,109, 97,112, 10, 48, 48, 48, 48, 48, 48, 52,
/* 0x3550 */  56, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73,
/* 0x3560 */  76, 32, 48, 32,103,101,116,112,105,100, 10, 48, 48, 48, 48, 48,
/* 0x3570 */  49, 50, 99, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84,
/* 0x3580 */  65, 73, 76, 32, 48, 32,109,101,109, 99,112,121, 10, 48, 48, 48,
/* 0x3590 */  48, 48, 48, 53, 56, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 79,
/* 0x35a0 */  95, 84, 65, 73, 76, 32, 48, 32,114,101, 97,100,108,105,110,107,
/* 0x35b0 */  10, 48, 48, 48, 48, 48, 50, 55, 56, 32,103, 32, 32, 32, 32, 32,
/* 0x35c0 */  32, 32, 83, 79, 95, 84, 65, 73, 76, 32, 48, 32, 95, 95,117,100,
/* 0x35d0 */ 105,118,115,105, 51, 10, 48, 48, 48, 48, 48, 48, 54, 48, 32,103,
/* 0x35e0 */  32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 32, 48,
/* 0x35f0 */  32,102,116,114,117,110, 99, 97,116,101, 10, 48, 48, 48, 48, 48,
/* 0x3600 */  48, 50, 56, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84,
/* 0x3610 */  65, 73, 76, 32, 48, 32,108,115,101,101,107, 10, 48, 48, 48, 48,
/* 0x3620 */  48, 48, 98, 99, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95,
/* 0x3630 */  84, 65, 73, 76, 32, 48, 32,109,109, 97,112, 10, 48, 48, 48, 48,
/* 0x3640 */  48, 49, 48, 48, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95,
/* 0x3650 */  84, 65, 73, 76, 32, 48, 32, 95, 95, 99,108,101, 97,114, 95, 99,
/* 0x3660 */  97, 99,104,101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,103, 32,
/* 0x3670 */  32, 32, 32, 32, 70, 32, 69, 88, 80, 95, 84, 65, 73, 76, 32, 48,
/* 0x3680 */  32,101,111,102, 10, 48, 48, 48, 48, 48, 49, 49, 52, 32,103, 32,
/* 0x3690 */  32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 32, 48, 32,
/* 0x36a0 */ 109,109, 97,112, 95,112,114,105,118, 97,110,111,110, 10, 48, 48,
/* 0x36b0 */  48, 48, 48, 48, 50, 48, 32,103, 32, 32, 32, 32, 32, 32, 32, 83,
/* 0x36c0 */  79, 95, 84, 65, 73, 76, 32, 48, 32,119,114,105,116,101, 10, 48,
/* 0x36d0 */  48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32, 70, 32,
/* 0x36e0 */  83, 79, 95, 77, 65, 73, 78, 32, 48, 50, 99, 32, 80, 70, 95,116,
/* 0x36f0 */ 111, 95, 80, 82, 79, 84, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3700 */ 103, 32, 32, 32, 32, 32, 70, 32, 78, 82, 86, 50, 68, 32, 48, 49,
/* 0x3710 */  48, 48, 32,117, 99,108, 95,110,114,118, 50,100, 95,100,101, 99,
/* 0x3720 */ 111,109,112,114,101,115,115, 95, 56, 10, 48, 48, 48, 48, 48, 48,
/* 0x3730 */  48, 48, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 72, 69,
/* 0x3740 */  65, 68, 32, 48, 32,102,111,108,100, 10, 48, 48, 48, 48, 48, 48,
/* 0x3750 */  54, 56, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65,
/* 0x3760 */  73, 76, 32, 48, 32,109,101,109,102,100, 95, 99,114,101, 97,116,
/* 0x3770 */ 101, 10, 48, 48, 48, 48, 48, 48, 49, 56, 32,103, 32, 32, 32, 32,
/* 0x3780 */  32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 32, 48, 32,114,101, 97,
/* 0x3790 */ 100, 10, 48, 48, 48, 48, 48, 48, 52, 48, 32,103, 32, 32, 32, 32,
/* 0x37a0 */  32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 32, 48, 32,117,110,108,
/* 0x37b0 */ 105,110,107, 10, 48, 48, 48, 48, 48, 50, 48, 48, 32,103, 32, 32,
/* 0x37c0 */  32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 32, 48, 32,117,
/* 0x37d0 */ 110,100,101,114,108, 97,121, 10, 48, 48, 48, 48, 48, 50, 53, 48,
/* 0x37e0 */  32,103, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73, 76,
/* 0x37f0 */  32, 48, 32,109,101,109,115,101,116, 10, 48, 48, 48, 48, 48, 48,
/* 0x3800 */  48, 48, 32,103, 32, 32, 32, 32, 32, 70, 32, 78, 82, 86, 50, 66,
/* 0x3810 */  32, 48, 99, 52, 32,117, 99,108, 95,110,114,118, 50, 98, 95,100,
/* 0x3820 */ 101, 99,111,109,112,114,101,115,115, 95, 56, 10, 48, 48, 48, 48,
/* 0x3830 */  48, 49,100, 99, 32,103, 32, 32, 32, 32, 32, 70, 32, 83, 79, 95,
/* 0x3840 */  77, 65, 73, 78, 32, 48, 97, 56, 32,103,101,116, 95, 80, 65, 71,
/* 0x3850 */  69, 95, 77, 65, 83, 75, 10, 48, 48, 48, 48, 48, 48, 56, 52, 32,
/* 0x3860 */ 103, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 32,
/* 0x3870 */  48, 32,117,112,120,102,100, 95, 99,114,101, 97,116,101, 10, 48,
/* 0x3880 */  48, 48, 48, 48, 50, 54, 56, 32,103, 32, 32, 32, 32, 32, 32, 32,
/* 0x3890 */  83, 79, 95, 84, 65, 73, 76, 32, 48, 32,109,121, 95, 97,108,108,
/* 0x38a0 */ 111, 99, 97, 10, 48, 48, 48, 48, 48, 48, 48, 99, 32,103, 32, 32,
/* 0x38b0 */  32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 32, 48, 32,109,
/* 0x38c0 */ 121, 95, 98,107,112,116, 10, 48, 48, 48, 48, 48, 48, 57, 52, 32,
/* 0x38d0 */ 103, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 32,
/* 0x38e0 */  48, 32, 80,112,114,111,116,101, 99,116, 10, 48, 48, 48, 48, 48,
/* 0x38f0 */  48, 48, 48, 32,103, 32, 32, 32, 32, 32, 70, 32, 78, 82, 86, 50,
/* 0x3900 */  69, 32, 48, 49, 49, 52, 32,117, 99,108, 95,110,114,118, 50,101,
/* 0x3910 */  95,100,101, 99,111,109,112,114,101,115,115, 95, 56, 10, 48, 48,
/* 0x3920 */  48, 48, 48, 48, 50, 48, 32,103, 32, 32, 32, 32, 32, 32, 32, 83,
/* 0x3930 */  79, 95, 84, 65, 73, 76, 32, 48, 32, 80,119,114,105,116,101, 10,
/* 0x3940 */  48, 48, 48, 48, 48, 48,101, 52, 32,103, 32, 32, 32, 32, 32, 32,
/* 0x3950 */  32, 83, 79, 95, 84, 65, 73, 76, 32, 48, 32, 80,117,110,109, 97,
/* 0x3960 */ 112, 10, 48, 48, 48, 48, 48, 48, 49, 52, 32,103, 32, 32, 32, 32,
/* 0x3970 */  32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 32, 48, 32,101,120,105,
/* 0x3980 */ 116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32, 32,
/* 0x3990 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 32, 48, 32,
/* 0x39a0 */  76,122,109, 97, 68,101, 99,111,100,101, 10, 48, 48, 48, 48, 48,
/* 0x39b0 */  48, 53, 48, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84,
/* 0x39c0 */  65, 73, 76, 32, 48, 32, 98,114,107, 10, 48, 48, 48, 48, 48, 48,
/* 0x39d0 */  51, 48, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65,
/* 0x39e0 */  73, 76, 32, 48, 32,111,112,101,110, 10, 48, 48, 48, 48, 48, 50,
/* 0x39f0 */  55, 56, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65,
/* 0x3a00 */  73, 76, 32, 48, 32,100,105,118, 49, 48, 10, 48, 48, 48, 48, 48,
/* 0x3a10 */  48, 97, 52, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84,
/* 0x3a20 */  65, 73, 76, 32, 48, 32,109,112,114,111,116,101, 99,116, 10, 48,
/* 0x3a30 */  48, 48, 48, 48, 48, 51, 56, 32,103, 32, 32, 32, 32, 32, 32, 32,
/* 0x3a40 */  83, 79, 95, 84, 65, 73, 76, 32, 48, 32, 99,108,111,115,101, 10,
/* 0x3a50 */  48, 48, 48, 48, 48, 50, 56, 52, 32,103, 32, 32, 32, 32, 32, 70,
/* 0x3a60 */  32, 83, 79, 95, 77, 65, 73, 78, 32, 48, 52, 99, 48, 32,117,112,
/* 0x3a70 */ 120, 95,115,111, 95,109, 97,105,110, 10, 10, 82, 69, 76, 79, 67,
/* 0x3a80 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x3a90 */  82, 32, 91, 83, 79, 95, 72, 69, 65, 68, 93, 58, 10, 79, 70, 70,
/* 0x3aa0 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x3ab0 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x3ac0 */  48, 48, 48, 48, 48, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x3ad0 */  52, 32, 32, 32, 32, 32, 32, 32, 32,117,112,120, 95,115,111, 95,
/* 0x3ae0 */ 109, 97,105,110, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x3af0 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 83, 79,
/* 0x3b00 */  95, 84, 65, 73, 76, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x3b10 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3b20 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 49, 50,
/* 0x3b30 */  56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x3b40 */  32, 32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 10, 48, 48, 48, 48,
/* 0x3b50 */  48, 49, 51, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x3b60 */  32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 10, 48,
/* 0x3b70 */  48, 48, 48, 48, 49, 53, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x3b80 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73,
/* 0x3b90 */  76, 10, 48, 48, 48, 48, 48, 49, 53, 99, 32, 82, 95, 65, 82, 77,
/* 0x3ba0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95,
/* 0x3bb0 */  84, 65, 73, 76, 10, 48, 48, 48, 48, 48, 49, 54, 56, 32, 82, 95,
/* 0x3bc0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3bd0 */  83, 79, 95, 84, 65, 73, 76, 10, 48, 48, 48, 48, 48, 49, 57, 52,
/* 0x3be0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x3bf0 */  32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 10, 48, 48, 48, 48, 48,
/* 0x3c00 */  49, 97, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x3c10 */  32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 10, 48, 48,
/* 0x3c20 */  48, 48, 48, 49, 98, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x3c30 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73, 76,
/* 0x3c40 */  10, 48, 48, 48, 48, 48, 49, 98, 99, 32, 82, 95, 65, 82, 77, 95,
/* 0x3c50 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84,
/* 0x3c60 */  65, 73, 76, 10, 48, 48, 48, 48, 48, 49, 99, 99, 32, 82, 95, 65,
/* 0x3c70 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 83,
/* 0x3c80 */  79, 95, 84, 65, 73, 76, 10, 48, 48, 48, 48, 48, 49,100, 52, 32,
/* 0x3c90 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x3ca0 */  32, 32, 83, 79, 95, 84, 65, 73, 76, 10, 48, 48, 48, 48, 48, 49,
/* 0x3cb0 */ 101, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x3cc0 */  32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 10, 48, 48, 48,
/* 0x3cd0 */  48, 48, 49,102, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x3ce0 */  32, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 10,
/* 0x3cf0 */  48, 48, 48, 48, 48, 50, 49, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x3d00 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,109,101,109, 99,112,
/* 0x3d10 */ 121, 10, 48, 48, 48, 48, 48, 50, 51, 56, 32, 82, 95, 65, 82, 77,
/* 0x3d20 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,109,109, 97,
/* 0x3d30 */ 112, 95,112,114,105,118, 97,110,111,110, 10, 48, 48, 48, 48, 48,
/* 0x3d40 */  50, 52, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x3d50 */  32, 32, 32, 32, 32, 32,109,101,109, 99,112,121, 10, 48, 48, 48,
/* 0x3d60 */  48, 48, 50, 54, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x3d70 */  32, 32, 32, 32, 32, 32, 32, 32,109,101,109,115,101,116, 10, 10,
/* 0x3d80 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x3d90 */  68, 83, 32, 70, 79, 82, 32, 91, 83, 79, 95, 77, 65, 73, 78, 93,
/* 0x3da0 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x3db0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x3dc0 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 65, 82,
/* 0x3dd0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 83, 79,
/* 0x3de0 */  95, 77, 65, 73, 78, 10, 48, 48, 48, 48, 48, 48, 51, 48, 32, 82,
/* 0x3df0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x3e00 */  32,109,121, 95, 98,107,112,116, 10, 48, 48, 48, 48, 48, 48, 51,
/* 0x3e10 */  56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x3e20 */  32, 32, 32, 32,101,120,105,116, 10, 48, 48, 48, 48, 48, 48, 53,
/* 0x3e30 */  56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x3e40 */  32, 32, 32, 32, 83, 79, 95, 77, 65, 73, 78, 10, 48, 48, 48, 48,
/* 0x3e50 */  48, 48, 54, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x3e60 */  32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 77, 65, 73, 78, 10, 48,
/* 0x3e70 */  48, 48, 48, 48, 48, 56, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x3e80 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 77, 65, 73,
/* 0x3e90 */  78, 10, 48, 48, 48, 48, 48, 48, 98, 99, 32, 82, 95, 65, 82, 77,
/* 0x3ea0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95,
/* 0x3eb0 */  77, 65, 73, 78, 10, 48, 48, 48, 48, 48, 48, 99, 99, 32, 82, 95,
/* 0x3ec0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3ed0 */  83, 79, 95, 77, 65, 73, 78, 10, 48, 48, 48, 48, 48, 48,100, 56,
/* 0x3ee0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x3ef0 */  32, 32, 32, 83, 79, 95, 77, 65, 73, 78, 10, 48, 48, 48, 48, 48,
/* 0x3f00 */  48,101, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x3f10 */  32, 32, 32, 32, 32, 32, 83, 79, 95, 77, 65, 73, 78, 10, 48, 48,
/* 0x3f20 */  48, 48, 48, 48,102, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x3f30 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 77, 65, 73, 78,
/* 0x3f40 */  10, 48, 48, 48, 48, 48, 49, 48, 48, 32, 82, 95, 65, 82, 77, 95,
/* 0x3f50 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 77,
/* 0x3f60 */  65, 73, 78, 10, 48, 48, 48, 48, 48, 49, 48, 52, 32, 82, 95, 65,
/* 0x3f70 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 83,
/* 0x3f80 */  79, 95, 77, 65, 73, 78, 10, 48, 48, 48, 48, 48, 49, 49, 52, 32,
/* 0x3f90 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x3fa0 */  32, 32, 83, 79, 95, 77, 65, 73, 78, 10, 48, 48, 48, 48, 48, 49,
/* 0x3fb0 */  50, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x3fc0 */  32, 32, 32, 32, 32, 83, 79, 95, 77, 65, 73, 78, 10, 48, 48, 48,
/* 0x3fd0 */  48, 48, 49, 50, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x3fe0 */  32, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 77, 65, 73, 78, 10,
/* 0x3ff0 */  48, 48, 48, 48, 48, 49, 51, 52, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x4000 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 77, 65,
/* 0x4010 */  73, 78, 10, 48, 48, 48, 48, 48, 49, 52, 52, 32, 82, 95, 65, 82,
/* 0x4020 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 83, 79,
/* 0x4030 */  95, 77, 65, 73, 78, 10, 48, 48, 48, 48, 48, 49, 53, 99, 32, 82,
/* 0x4040 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x4050 */  32,102, 95,101,120,112, 97,110,100, 10, 48, 48, 48, 48, 48, 49,
/* 0x4060 */  54, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x4070 */  32, 32, 32, 32, 32, 83, 79, 95, 77, 65, 73, 78, 10, 48, 48, 48,
/* 0x4080 */  48, 48, 49, 55, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x4090 */  32, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 77, 65, 73, 78, 10,
/* 0x40a0 */  48, 48, 48, 48, 48, 49, 55, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x40b0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 77, 65,
/* 0x40c0 */  73, 78, 10, 48, 48, 48, 48, 48, 49, 57, 99, 32, 82, 95, 65, 82,
/* 0x40d0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 83, 79,
/* 0x40e0 */  95, 77, 65, 73, 78, 10, 48, 48, 48, 48, 48, 49, 97, 56, 32, 82,
/* 0x40f0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x4100 */  32, 83, 79, 95, 77, 65, 73, 78, 10, 48, 48, 48, 48, 48, 49, 99,
/* 0x4110 */  99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x4120 */  32, 32, 32, 32, 83, 79, 95, 77, 65, 73, 78, 10, 48, 48, 48, 48,
/* 0x4130 */  48, 49,101, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x4140 */  32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 77, 65, 73, 78, 10, 48,
/* 0x4150 */  48, 48, 48, 48, 50, 48, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x4160 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32,111,112,101,110, 10, 48,
/* 0x4170 */  48, 48, 48, 48, 50, 48, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x4180 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 77, 65, 73,
/* 0x4190 */  78, 10, 48, 48, 48, 48, 48, 50, 49, 99, 32, 82, 95, 65, 82, 77,
/* 0x41a0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,114,101, 97,
/* 0x41b0 */ 100, 10, 48, 48, 48, 48, 48, 50, 50, 99, 32, 82, 95, 65, 82, 77,
/* 0x41c0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 99,108,111,
/* 0x41d0 */ 115,101, 10, 48, 48, 48, 48, 48, 50, 51, 52, 32, 82, 95, 65, 82,
/* 0x41e0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 83, 79,
/* 0x41f0 */  95, 77, 65, 73, 78, 10, 48, 48, 48, 48, 48, 50, 52, 52, 32, 82,
/* 0x4200 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x4210 */  32, 83, 79, 95, 77, 65, 73, 78, 10, 48, 48, 48, 48, 48, 50, 52,
/* 0x4220 */  56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x4230 */  32, 32, 32, 32, 83, 79, 95, 77, 65, 73, 78, 10, 48, 48, 48, 48,
/* 0x4240 */  48, 50, 53, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x4250 */  32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 77, 65, 73, 78, 10, 48,
/* 0x4260 */  48, 48, 48, 48, 50, 54, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x4270 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 77, 65, 73,
/* 0x4280 */  78, 10, 48, 48, 48, 48, 48, 50, 55, 48, 32, 82, 95, 65, 82, 77,
/* 0x4290 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95,
/* 0x42a0 */  77, 65, 73, 78, 10, 48, 48, 48, 48, 48, 50, 57, 56, 32, 82, 95,
/* 0x42b0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x42c0 */ 103,101,116, 95, 80, 65, 71, 69, 95, 77, 65, 83, 75, 10, 48, 48,
/* 0x42d0 */  48, 48, 48, 50,101, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x42e0 */  52, 32, 32, 32, 32, 32, 32, 32, 32,109,109, 97,112, 10, 48, 48,
/* 0x42f0 */  48, 48, 48, 50,102, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x4300 */  52, 32, 32, 32, 32, 32, 32, 32, 32,109,101,109, 99,112,121, 10,
/* 0x4310 */  48, 48, 48, 48, 48, 51, 49, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x4320 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 77, 65,
/* 0x4330 */  73, 78, 10, 48, 48, 48, 48, 48, 51, 51, 52, 32, 82, 95, 65, 82,
/* 0x4340 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 83, 79,
/* 0x4350 */  95, 77, 65, 73, 78, 10, 48, 48, 48, 48, 48, 51, 52, 52, 32, 82,
/* 0x4360 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x4370 */  32, 83, 79, 95, 77, 65, 73, 78, 10, 48, 48, 48, 48, 48, 51, 54,
/* 0x4380 */  48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x4390 */  32, 32, 32, 32, 83, 79, 95, 77, 65, 73, 78, 10, 48, 48, 48, 48,
/* 0x43a0 */  48, 51, 54, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x43b0 */  32, 32, 32, 32, 32, 32, 32,117,112,120,102,100, 95, 99,114,101,
/* 0x43c0 */  97,116,101, 10, 48, 48, 48, 48, 48, 51, 55, 99, 32, 82, 95, 65,
/* 0x43d0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 80,
/* 0x43e0 */ 119,114,105,116,101, 10, 48, 48, 48, 48, 48, 51, 57, 48, 32, 82,
/* 0x43f0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x4400 */  32, 80,119,114,105,116,101, 10, 48, 48, 48, 48, 48, 51, 57, 99,
/* 0x4410 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x4420 */  32, 32, 32, 80,117,110,109, 97,112, 10, 48, 48, 48, 48, 48, 51,
/* 0x4430 */  97, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x4440 */  32, 32, 32, 32, 32, 80, 70, 95,116,111, 95, 80, 82, 79, 84, 10,
/* 0x4450 */  48, 48, 48, 48, 48, 51, 99, 52, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x4460 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 80,109, 97,112, 10,
/* 0x4470 */  48, 48, 48, 48, 48, 51, 99, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x4480 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 99,108,111,115,101,
/* 0x4490 */  10, 48, 48, 48, 48, 48, 51,100, 99, 32, 82, 95, 65, 82, 77, 95,
/* 0x44a0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 77,
/* 0x44b0 */  65, 73, 78, 10, 48, 48, 48, 48, 48, 52, 48, 48, 32, 82, 95, 65,
/* 0x44c0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 83,
/* 0x44d0 */  79, 95, 77, 65, 73, 78, 10, 48, 48, 48, 48, 48, 52, 48, 99, 32,
/* 0x44e0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x44f0 */  32, 32, 83, 79, 95, 77, 65, 73, 78, 10, 48, 48, 48, 48, 48, 52,
/* 0x4500 */  50, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x4510 */  32, 32, 32, 32, 32, 83, 79, 95, 77, 65, 73, 78, 10, 48, 48, 48,
/* 0x4520 */  48, 48, 52, 52, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x4530 */  32, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 77, 65, 73, 78, 10,
/* 0x4540 */  48, 48, 48, 48, 48, 52, 98, 52, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x4550 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 77, 65,
/* 0x4560 */  73, 78, 10, 48, 48, 48, 48, 48, 52, 98, 56, 32, 82, 95, 65, 82,
/* 0x4570 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,117,112,
/* 0x4580 */ 120,102,100, 95, 99,114,101, 97,116,101, 10, 48, 48, 48, 48, 48,
/* 0x4590 */  52, 99, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x45a0 */  32, 32, 32, 32, 32, 32, 83, 79, 95, 77, 65, 73, 78, 10, 48, 48,
/* 0x45b0 */  48, 48, 48, 52,100, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x45c0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 80,119,114,105,116,101, 10,
/* 0x45d0 */  48, 48, 48, 48, 48, 52,101, 48, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x45e0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 77, 65,
/* 0x45f0 */  73, 78, 10, 48, 48, 48, 48, 48, 52,101, 56, 32, 82, 95, 65, 82,
/* 0x4600 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 83, 79,
/* 0x4610 */  95, 77, 65, 73, 78, 10, 48, 48, 48, 48, 48, 52,102, 56, 32, 82,
/* 0x4620 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x4630 */  32,108,115,101,101,107, 10, 48, 48, 48, 48, 48, 53, 48, 56, 32,
/* 0x4640 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x4650 */  32, 32, 80,119,114,105,116,101, 10, 48, 48, 48, 48, 48, 53, 49,
/* 0x4660 */  52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x4670 */  32, 32, 32, 32, 80,117,110,109, 97,112, 10, 48, 48, 48, 48, 48,
/* 0x4680 */  53, 51, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x4690 */  32, 32, 32, 32, 32, 32, 80,109, 97,112, 10, 48, 48, 48, 48, 48,
/* 0x46a0 */  53, 51, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x46b0 */  32, 32, 32, 32, 32, 32, 83, 79, 95, 77, 65, 73, 78, 10, 48, 48,
/* 0x46c0 */  48, 48, 48, 53, 52, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x46d0 */  52, 32, 32, 32, 32, 32, 32, 32, 32,117,110,100,101,114,108, 97,
/* 0x46e0 */ 121, 10, 48, 48, 48, 48, 48, 53, 56, 48, 32, 82, 95, 65, 82, 77,
/* 0x46f0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95,
/* 0x4700 */  77, 65, 73, 78, 10, 48, 48, 48, 48, 48, 53, 56, 99, 32, 82, 95,
/* 0x4710 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4720 */  83, 79, 95, 77, 65, 73, 78, 10, 48, 48, 48, 48, 48, 53, 57, 56,
/* 0x4730 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x4740 */  32, 32, 32, 83, 79, 95, 77, 65, 73, 78, 10, 48, 48, 48, 48, 48,
/* 0x4750 */  53, 97, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x4760 */  32, 32, 32, 32, 32, 32,103,101,116, 95,115,121,115, 95,109,117,
/* 0x4770 */ 110,109, 97,112, 10, 48, 48, 48, 48, 48, 53, 99, 48, 32, 82, 95,
/* 0x4780 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4790 */  83, 79, 95, 77, 65, 73, 78, 10, 48, 48, 48, 48, 48, 53, 99, 99,
/* 0x47a0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x47b0 */  32, 32, 32, 83, 79, 95, 77, 65, 73, 78, 10, 48, 48, 48, 48, 48,
/* 0x47c0 */  53,102, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x47d0 */  32, 32, 32, 32, 32, 32, 83, 79, 95, 77, 65, 73, 78, 10, 48, 48,
/* 0x47e0 */  48, 48, 48, 54, 49, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x47f0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 95, 95, 99,108,101, 97,114,
/* 0x4800 */  95, 99, 97, 99,104,101, 10, 48, 48, 48, 48, 48, 54, 49, 99, 32,
/* 0x4810 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x4820 */  32, 32, 83, 79, 95, 77, 65, 73, 78, 10, 48, 48, 48, 48, 48, 54,
/* 0x4830 */  50, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x4840 */  32, 32, 32, 32, 32,117,112,120,102,100, 95, 99,114,101, 97,116,
/* 0x4850 */ 101, 10, 48, 48, 48, 48, 48, 54, 51, 48, 32, 82, 95, 65, 82, 77,
/* 0x4860 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,119,114,105,
/* 0x4870 */ 116,101, 10, 48, 48, 48, 48, 48, 54, 53, 48, 32, 82, 95, 65, 82,
/* 0x4880 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 80,109,
/* 0x4890 */  97,112, 10, 48, 48, 48, 48, 48, 54, 53, 99, 32, 82, 95, 65, 82,
/* 0x48a0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 99,108,
/* 0x48b0 */ 111,115,101, 10, 48, 48, 48, 48, 48, 54, 54, 48, 32, 82, 95, 65,
/* 0x48c0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 83,
/* 0x48d0 */  79, 95, 77, 65, 73, 78, 10, 48, 48, 48, 48, 48, 54, 55, 99, 32,
/* 0x48e0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x48f0 */  32, 32, 83, 79, 95, 77, 65, 73, 78, 10, 48, 48, 48, 48, 48, 54,
/* 0x4900 */  56, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x4910 */  32, 32, 32, 32, 32, 80,117,110,109, 97,112, 10, 48, 48, 48, 48,
/* 0x4920 */  48, 54, 97, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x4930 */  32, 32, 32, 32, 32, 32, 32, 80, 70, 95,116,111, 95, 80, 82, 79,
/* 0x4940 */  84, 10, 48, 48, 48, 48, 48, 54, 99, 56, 32, 82, 95, 65, 82, 77,
/* 0x4950 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 80,109, 97,
/* 0x4960 */ 112, 10, 48, 48, 48, 48, 48, 54,100, 48, 32, 82, 95, 65, 82, 77,
/* 0x4970 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 99,108,111,
/* 0x4980 */ 115,101, 10, 48, 48, 48, 48, 48, 54,100, 52, 32, 82, 95, 65, 82,
/* 0x4990 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 83, 79,
/* 0x49a0 */  95, 77, 65, 73, 78, 10, 48, 48, 48, 48, 48, 54,101, 99, 32, 82,
/* 0x49b0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x49c0 */  32, 80, 70, 95,116,111, 95, 80, 82, 79, 84, 10, 48, 48, 48, 48,
/* 0x49d0 */  48, 54,102, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x49e0 */  32, 32, 32, 32, 32, 32, 32, 80,112,114,111,116,101, 99,116, 10,
/* 0x49f0 */  48, 48, 48, 48, 48, 55, 48, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x4a00 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 77, 65,
/* 0x4a10 */  73, 78, 10, 48, 48, 48, 48, 48, 55, 49, 52, 32, 82, 95, 65, 82,
/* 0x4a20 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 80,117,
/* 0x4a30 */ 110,109, 97,112, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x4a40 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 69, 88,
/* 0x4a50 */  80, 95, 72, 69, 65, 68, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x4a60 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4a70 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x4a80 */  50, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x4a90 */  32, 32, 32, 32, 32, 69, 88, 80, 95, 72, 69, 65, 68, 10, 48, 48,
/* 0x4aa0 */  48, 48, 48, 48, 52, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x4ab0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 88, 80, 95, 72, 69, 65,
/* 0x4ac0 */  68, 10, 48, 48, 48, 48, 48, 48, 56, 52, 32, 82, 95, 65, 82, 77,
/* 0x4ad0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 88, 80,
/* 0x4ae0 */  95, 72, 69, 65, 68, 10, 48, 48, 48, 48, 48, 48, 57, 52, 32, 82,
/* 0x4af0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x4b00 */  32, 69, 88, 80, 95, 72, 69, 65, 68, 10, 48, 48, 48, 48, 48, 48,
/* 0x4b10 */  97, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x4b20 */  32, 32, 32, 32, 32, 69, 88, 80, 95, 72, 69, 65, 68, 10, 48, 48,
/* 0x4b30 */  48, 48, 48, 48, 98, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x4b40 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 88, 80, 95, 72, 69, 65,
/* 0x4b50 */  68, 10, 48, 48, 48, 48, 48, 48, 99, 99, 32, 82, 95, 65, 82, 77,
/* 0x4b60 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 95, 95, 99,
/* 0x4b70 */ 108,101, 97,114, 95, 99, 97, 99,104,101, 10, 10, 82, 69, 76, 79,
/* 0x4b80 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x4b90 */  79, 82, 32, 91, 78, 82, 86, 50, 69, 93, 58, 10, 79, 70, 70, 83,
/* 0x4ba0 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x4bb0 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x4bc0 */  48, 48, 48, 49, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x4bd0 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48,
/* 0x4be0 */  48, 48, 48, 48, 52, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x4bf0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48,
/* 0x4c00 */  48, 48, 48, 48, 48, 52, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x4c10 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10,
/* 0x4c20 */  48, 48, 48, 48, 48, 48, 53, 48, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x4c30 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69,
/* 0x4c40 */  10, 48, 48, 48, 48, 48, 48, 53, 99, 32, 82, 95, 65, 82, 77, 95,
/* 0x4c50 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50,
/* 0x4c60 */  69, 10, 48, 48, 48, 48, 48, 48, 54, 56, 32, 82, 95, 65, 82, 77,
/* 0x4c70 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86,
/* 0x4c80 */  50, 69, 10, 48, 48, 48, 48, 48, 48, 55, 52, 32, 82, 95, 65, 82,
/* 0x4c90 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,
/* 0x4ca0 */  86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 55, 56, 32, 82, 95, 65,
/* 0x4cb0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x4cc0 */  82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 56, 52, 32, 82, 95,
/* 0x4cd0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4ce0 */  78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 57, 52, 32, 82,
/* 0x4cf0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x4d00 */  32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 57, 99, 32,
/* 0x4d10 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x4d20 */  32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 97, 48,
/* 0x4d30 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x4d40 */  32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 97,
/* 0x4d50 */  56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x4d60 */  32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x4d70 */  97, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x4d80 */  32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48,
/* 0x4d90 */  48, 98, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x4da0 */  32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48,
/* 0x4db0 */  48, 48, 98, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x4dc0 */  32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48,
/* 0x4dd0 */  48, 48, 48, 99, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x4de0 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48,
/* 0x4df0 */  48, 48, 48, 48,100, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x4e00 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48,
/* 0x4e10 */  48, 48, 48, 48, 48,100, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x4e20 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10,
/* 0x4e30 */  48, 48, 48, 48, 48, 48,100, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x4e40 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69,
/* 0x4e50 */  10, 48, 48, 48, 48, 48, 48,101, 52, 32, 82, 95, 65, 82, 77, 95,
/* 0x4e60 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50,
/* 0x4e70 */  69, 10, 48, 48, 48, 48, 48, 49, 48, 99, 32, 82, 95, 65, 82, 77,
/* 0x4e80 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86,
/* 0x4e90 */  50, 69, 10, 48, 48, 48, 48, 48, 49, 49, 48, 32, 82, 95, 65, 82,
/* 0x4ea0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,
/* 0x4eb0 */  86, 50, 69, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x4ec0 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86,
/* 0x4ed0 */  50, 68, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x4ee0 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4ef0 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 49, 48, 32, 82,
/* 0x4f00 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x4f10 */  32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 52, 52, 32,
/* 0x4f20 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x4f30 */  32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 52, 56,
/* 0x4f40 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x4f50 */  32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 53,
/* 0x4f60 */  48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x4f70 */  32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48,
/* 0x4f80 */  53, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x4f90 */  32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48,
/* 0x4fa0 */  48, 54, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x4fb0 */  32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48,
/* 0x4fc0 */  48, 48, 55, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x4fd0 */  32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48,
/* 0x4fe0 */  48, 48, 48, 55, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x4ff0 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48,
/* 0x5000 */  48, 48, 48, 48, 56, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x5010 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48,
/* 0x5020 */  48, 48, 48, 48, 48, 57, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x5030 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10,
/* 0x5040 */  48, 48, 48, 48, 48, 48, 57, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x5050 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68,
/* 0x5060 */  10, 48, 48, 48, 48, 48, 48, 97, 52, 32, 82, 95, 65, 82, 77, 95,
/* 0x5070 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50,
/* 0x5080 */  68, 10, 48, 48, 48, 48, 48, 48, 98, 48, 32, 82, 95, 65, 82, 77,
/* 0x5090 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86,
/* 0x50a0 */  50, 68, 10, 48, 48, 48, 48, 48, 48, 98, 56, 32, 82, 95, 65, 82,
/* 0x50b0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,
/* 0x50c0 */  86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 99, 52, 32, 82, 95, 65,
/* 0x50d0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x50e0 */  82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48,100, 48, 32, 82, 95,
/* 0x50f0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5100 */  78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48,100, 52, 32, 82,
/* 0x5110 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x5120 */  32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48,102, 56, 32,
/* 0x5130 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x5140 */  32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48,102, 99,
/* 0x5150 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x5160 */  32, 32, 32, 78, 82, 86, 50, 68, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x5170 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x5180 */  32, 91, 78, 82, 86, 50, 66, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x5190 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x51a0 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x51b0 */  48, 49, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x51c0 */  32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48,
/* 0x51d0 */  48, 48, 52, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x51e0 */  32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48,
/* 0x51f0 */  48, 48, 48, 53, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x5200 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48,
/* 0x5210 */  48, 48, 48, 48, 53, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x5220 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48,
/* 0x5230 */  48, 48, 48, 48, 48, 54, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x5240 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10,
/* 0x5250 */  48, 48, 48, 48, 48, 48, 54, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x5260 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66,
/* 0x5270 */  10, 48, 48, 48, 48, 48, 48, 54, 99, 32, 82, 95, 65, 82, 77, 95,
/* 0x5280 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50,
/* 0x5290 */  66, 10, 48, 48, 48, 48, 48, 48, 55, 56, 32, 82, 95, 65, 82, 77,
/* 0x52a0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86,
/* 0x52b0 */  50, 66, 10, 48, 48, 48, 48, 48, 48, 56, 56, 32, 82, 95, 65, 82,
/* 0x52c0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,
/* 0x52d0 */  86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 56, 99, 32, 82, 95, 65,
/* 0x52e0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x52f0 */  82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 57, 52, 32, 82, 95,
/* 0x5300 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5310 */  78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 57, 99, 32, 82,
/* 0x5320 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x5330 */  32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 97, 48, 32,
/* 0x5340 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x5350 */  32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 98, 99,
/* 0x5360 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x5370 */  32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 99,
/* 0x5380 */  48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x5390 */  32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 10, 82, 69, 76, 79, 67,
/* 0x53a0 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x53b0 */  82, 32, 91, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 93, 58, 10,
/* 0x53c0 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x53d0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x53e0 */  10, 48, 48, 48, 48, 48, 48, 48, 56, 32, 82, 95, 65, 82, 77, 95,
/* 0x53f0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x5400 */  95, 69, 76, 70, 48, 48, 10, 48, 48, 48, 48, 48, 48, 52, 99, 32,
/* 0x5410 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x5420 */  32, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 10, 48, 48, 48,
/* 0x5430 */  48, 48, 48, 56, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x5440 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 69, 76, 70,
/* 0x5450 */  48, 48, 10, 48, 48, 48, 48, 48, 48, 56, 99, 32, 82, 95, 65, 82,
/* 0x5460 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x5470 */  77, 65, 95, 69, 76, 70, 48, 48, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x5480 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x5490 */  32, 91, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 93, 58, 10, 79,
/* 0x54a0 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x54b0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x54c0 */  48, 48, 48, 48, 48, 48, 55, 52, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x54d0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x54e0 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 57, 48, 32, 82,
/* 0x54f0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x5500 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x5510 */  48, 48, 98, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x5520 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x5530 */  48, 10, 48, 48, 48, 48, 48, 48, 99, 99, 32, 82, 95, 65, 82, 77,
/* 0x5540 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x5550 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48,102, 52,
/* 0x5560 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x5570 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x5580 */  48, 48, 48, 49, 48, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x5590 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x55a0 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 49, 48, 56, 32, 82, 95, 65,
/* 0x55b0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x55c0 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 49,
/* 0x55d0 */  52, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x55e0 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x55f0 */  48, 48, 48, 48, 48, 49, 57, 48, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x5600 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x5610 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 49, 99, 99, 32, 82,
/* 0x5620 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x5630 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x5640 */  48, 49,100, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x5650 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x5660 */  48, 10, 48, 48, 48, 48, 48, 50, 48, 52, 32, 82, 95, 65, 82, 77,
/* 0x5670 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x5680 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 50, 49, 56,
/* 0x5690 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x56a0 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x56b0 */  48, 48, 48, 50, 50, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x56c0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x56d0 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 50, 51, 52, 32, 82, 95, 65,
/* 0x56e0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x56f0 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 50,
/* 0x5700 */  51, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x5710 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x5720 */  48, 48, 48, 48, 48, 50, 52, 48, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x5730 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x5740 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 50, 52, 99, 32, 82,
/* 0x5750 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x5760 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x5770 */  48, 50, 53, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x5780 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x5790 */  48, 10, 48, 48, 48, 48, 48, 50, 97, 52, 32, 82, 95, 65, 82, 77,
/* 0x57a0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x57b0 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 50, 99, 56,
/* 0x57c0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x57d0 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x57e0 */  48, 48, 48, 50,101, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x57f0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x5800 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 51, 48, 52, 32, 82, 95, 65,
/* 0x5810 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x5820 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 51,
/* 0x5830 */  48, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x5840 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x5850 */  48, 48, 48, 48, 48, 51, 51, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x5860 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x5870 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 51, 56, 56, 32, 82,
/* 0x5880 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x5890 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x58a0 */  48, 51, 97, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x58b0 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x58c0 */  48, 10, 48, 48, 48, 48, 48, 51, 97, 56, 32, 82, 95, 65, 82, 77,
/* 0x58d0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x58e0 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 51, 99, 99,
/* 0x58f0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x5900 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x5910 */  48, 48, 48, 51,101, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x5920 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x5930 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 51,101, 56, 32, 82, 95, 65,
/* 0x5940 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x5950 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 52,
/* 0x5960 */  50, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x5970 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x5980 */  48, 48, 48, 48, 48, 52, 51, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x5990 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x59a0 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 52, 54, 99, 32, 82,
/* 0x59b0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x59c0 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x59d0 */  48, 52, 56, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x59e0 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x59f0 */  48, 10, 48, 48, 48, 48, 48, 52, 56, 99, 32, 82, 95, 65, 82, 77,
/* 0x5a00 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x5a10 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 52, 98, 48,
/* 0x5a20 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x5a30 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x5a40 */  48, 48, 48, 52,100, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x5a50 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x5a60 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 52,101, 99, 32, 82, 95, 65,
/* 0x5a70 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x5a80 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 52,
/* 0x5a90 */ 102, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x5aa0 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x5ab0 */  48, 48, 48, 48, 48, 53, 49, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x5ac0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x5ad0 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 53, 51, 99, 32, 82,
/* 0x5ae0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x5af0 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x5b00 */  48, 53, 57, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x5b10 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x5b20 */  48, 10, 48, 48, 48, 48, 48, 53, 97, 48, 32, 82, 95, 65, 82, 77,
/* 0x5b30 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x5b40 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 53, 99, 48,
/* 0x5b50 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x5b60 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x5b70 */  48, 48, 48, 53,101, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x5b80 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x5b90 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 53,102, 99, 32, 82, 95, 65,
/* 0x5ba0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x5bb0 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 54,
/* 0x5bc0 */  48, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x5bd0 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x5be0 */  48, 48, 48, 48, 48, 54, 50, 52, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x5bf0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x5c00 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 54, 52, 56, 32, 82,
/* 0x5c10 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x5c20 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x5c30 */  48, 54, 56, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x5c40 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x5c50 */  48, 10, 48, 48, 48, 48, 48, 54, 56, 99, 32, 82, 95, 65, 82, 77,
/* 0x5c60 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x5c70 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 54,100, 48,
/* 0x5c80 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x5c90 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x5ca0 */  48, 48, 48, 54,101, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x5cb0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x5cc0 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 55, 49, 99, 32, 82, 95, 65,
/* 0x5cd0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x5ce0 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 55,
/* 0x5cf0 */  50, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x5d00 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x5d10 */  48, 48, 48, 48, 48, 55, 54, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x5d20 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x5d30 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 55, 55, 99, 32, 82,
/* 0x5d40 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x5d50 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x5d60 */  48, 55, 57, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x5d70 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x5d80 */  48, 10, 48, 48, 48, 48, 48, 55, 98, 56, 32, 82, 95, 65, 82, 77,
/* 0x5d90 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x5da0 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 55, 99, 52,
/* 0x5db0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x5dc0 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x5dd0 */  48, 48, 48, 55,100, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x5de0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x5df0 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 55,102, 52, 32, 82, 95, 65,
/* 0x5e00 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x5e10 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 56,
/* 0x5e20 */  50, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x5e30 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x5e40 */  48, 48, 48, 48, 48, 56, 50, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x5e50 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x5e60 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 56, 55, 99, 32, 82,
/* 0x5e70 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x5e80 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x5e90 */  48, 56, 56, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x5ea0 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x5eb0 */  48, 10, 48, 48, 48, 48, 48, 56, 97, 48, 32, 82, 95, 65, 82, 77,
/* 0x5ec0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x5ed0 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 56,101, 56,
/* 0x5ee0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x5ef0 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x5f00 */  48, 48, 48, 56,102, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x5f10 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x5f20 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 56,102, 99, 32, 82, 95, 65,
/* 0x5f30 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x5f40 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 57,
/* 0x5f50 */  48, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x5f60 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x5f70 */  48, 48, 48, 48, 48, 57, 50, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x5f80 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x5f90 */  68, 69, 67, 50, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x5fa0 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76,
/* 0x5fb0 */  90, 77, 65, 95, 68, 69, 67, 49, 48, 93, 58, 10, 79, 70, 70, 83,
/* 0x5fc0 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x5fd0 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x5fe0 */  48, 48, 48, 55, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x5ff0 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x6000 */  49, 48, 10, 48, 48, 48, 48, 48, 48, 56, 48, 32, 82, 95, 65, 82,
/* 0x6010 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x6020 */  77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 56,
/* 0x6030 */  56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x6040 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,
/* 0x6050 */  48, 48, 48, 48, 48, 97, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x6060 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x6070 */  69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 97, 99, 32, 82, 95,
/* 0x6080 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6090 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,
/* 0x60a0 */  48,101, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x60b0 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x60c0 */  10, 48, 48, 48, 48, 48, 49, 48, 48, 32, 82, 95, 65, 82, 77, 95,
/* 0x60d0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x60e0 */  95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 48, 99, 32,
/* 0x60f0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x6100 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,
/* 0x6110 */  48, 48, 49, 49, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x6120 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x6130 */  49, 48, 10, 48, 48, 48, 48, 48, 49, 49, 56, 32, 82, 95, 65, 82,
/* 0x6140 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x6150 */  77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 50,
/* 0x6160 */  48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x6170 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,
/* 0x6180 */  48, 48, 48, 48, 49, 50, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x6190 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x61a0 */  69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 52, 52, 32, 82, 95,
/* 0x61b0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x61c0 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,
/* 0x61d0 */  49, 52, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x61e0 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x61f0 */  10, 48, 48, 48, 48, 48, 49, 53, 48, 32, 82, 95, 65, 82, 77, 95,
/* 0x6200 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x6210 */  95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 56, 48, 32,
/* 0x6220 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x6230 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,
/* 0x6240 */  48, 48, 49, 56, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x6250 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x6260 */  49, 48, 10, 48, 48, 48, 48, 48, 49, 56, 99, 32, 82, 95, 65, 82,
/* 0x6270 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x6280 */  77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 57,
/* 0x6290 */  99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x62a0 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,
/* 0x62b0 */  48, 48, 48, 48, 49, 97, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x62c0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x62d0 */  69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 99, 48, 32, 82, 95,
/* 0x62e0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x62f0 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,
/* 0x6300 */  49, 99, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x6310 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x6320 */  10, 48, 48, 48, 48, 48, 49,100, 52, 32, 82, 95, 65, 82, 77, 95,
/* 0x6330 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x6340 */  95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49,100, 99, 32,
/* 0x6350 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x6360 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,
/* 0x6370 */  48, 48, 49,101, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x6380 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x6390 */  49, 48, 10, 48, 48, 48, 48, 48, 49,101, 99, 32, 82, 95, 65, 82,
/* 0x63a0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x63b0 */  77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50, 50,
/* 0x63c0 */  56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x63d0 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,
/* 0x63e0 */  48, 48, 48, 48, 50, 50, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x63f0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x6400 */  69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50, 52, 52, 32, 82, 95,
/* 0x6410 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6420 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,
/* 0x6430 */  50, 52, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x6440 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x6450 */  10, 48, 48, 48, 48, 48, 50, 53, 48, 32, 82, 95, 65, 82, 77, 95,
/* 0x6460 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x6470 */  95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50, 54, 56, 32,
/* 0x6480 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x6490 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,
/* 0x64a0 */  48, 48, 50, 56, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x64b0 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x64c0 */  49, 48, 10, 48, 48, 48, 48, 48, 50, 56, 99, 32, 82, 95, 65, 82,
/* 0x64d0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x64e0 */  77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50, 97,
/* 0x64f0 */  52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x6500 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,
/* 0x6510 */  48, 48, 48, 48, 50, 99, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x6520 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x6530 */  69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50,100, 48, 32, 82, 95,
/* 0x6540 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6550 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,
/* 0x6560 */  50,100, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x6570 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x6580 */  10, 48, 48, 48, 48, 48, 50,102, 52, 32, 82, 95, 65, 82, 77, 95,
/* 0x6590 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x65a0 */  95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51, 48, 99, 32,
/* 0x65b0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x65c0 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,
/* 0x65d0 */  48, 48, 51, 49, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x65e0 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x65f0 */  49, 48, 10, 48, 48, 48, 48, 48, 51, 50, 99, 32, 82, 95, 65, 82,
/* 0x6600 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x6610 */  77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51, 53,
/* 0x6620 */  48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x6630 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,
/* 0x6640 */  48, 48, 48, 48, 51, 53, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x6650 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x6660 */  69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51, 55, 48, 32, 82, 95,
/* 0x6670 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6680 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,
/* 0x6690 */  51, 55, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x66a0 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x66b0 */  10, 48, 48, 48, 48, 48, 51, 57, 99, 32, 82, 95, 65, 82, 77, 95,
/* 0x66c0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x66d0 */  95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51, 98, 48, 32,
/* 0x66e0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x66f0 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,
/* 0x6700 */  48, 48, 51, 98, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x6710 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x6720 */  49, 48, 10, 48, 48, 48, 48, 48, 51, 99, 56, 32, 82, 95, 65, 82,
/* 0x6730 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x6740 */  77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51, 99,
/* 0x6750 */  99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x6760 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,
/* 0x6770 */  48, 48, 48, 48, 52, 48, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x6780 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x6790 */  69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 52, 49, 56, 32, 82, 95,
/* 0x67a0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x67b0 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,
/* 0x67c0 */  52, 52, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x67d0 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x67e0 */  10
};
