/* --------------------------------------------------------------------------------------------
 * Copyright (c) TypeFox and others. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for license information.
 * ------------------------------------------------------------------------------------------ */
'use strict';
import * as lsp from 'vscode-languageserver';
/**
 * A request to resolve all calls at a given text document position of a symbol definition or a call the same.
 * The request's parameter is of type [CallsParams](#CallsParams), the response is of type [CallsResult](#CallsResult) or a
 * Thenable that resolves to such.
 */
export var CallsRequest;
(function (CallsRequest) {
    CallsRequest.type = new lsp.RequestType('textDocument/calls');
})(CallsRequest = CallsRequest || (CallsRequest = {}));
/**
 * Enum of call direction kinds
 */
export var CallDirection;
(function (CallDirection) {
    /**
     * Incoming calls aka. callers
     */
    CallDirection["Incoming"] = "incoming";
    /**
     * Outgoing calls aka. callees
     */
    CallDirection["Outgoing"] = "outgoing";
})(CallDirection = CallDirection || (CallDirection = {}));
export var DefinitionSymbol;
(function (DefinitionSymbol) {
    function create(uri, symbol) {
        const { name, detail, kind, range, selectionRange } = symbol;
        const location = { uri, range };
        return { name, detail, kind, location, selectionRange };
    }
    DefinitionSymbol.create = create;
})(DefinitionSymbol = DefinitionSymbol || (DefinitionSymbol = {}));
//# sourceMappingURL=lsp-protocol.calls.proposed.js.map