"/*  tccdefs.h\n"
"\n"
"    Nothing is defined before this file except target machine, target os\n"
"    and the few things related to option settings in tccpp.c:tcc_predefs().\n"
"\n"
"    This file is either included at runtime as is, or converted and\n"
"    included as C-strings at compile-time (depending on CONFIG_TCC_PREDEFS).\n"
"\n"
"    Note that line indent matters:\n"
"\n"
"    - in lines starting at column 1, platform macros are replaced by\n"
"      corresponding TCC target compile-time macros.  See conftest.c for\n"
"      the list of platform macros supported in lines starting at column 1.\n"
"\n"
"    - only lines indented >= 4 are actually included into the executable,\n"
"      check tccdefs_.h.\n"
"*/\n"
"\n"
"#if __SIZEOF_POINTER__ == 4\n"
"    /* 32bit systems. */\n"
"#if defined TARGETOS_OpenBSD\n"
"    #define __SIZE_TYPE__ unsigned long\n"
"    #define __PTRDIFF_TYPE__ long\n"
"#else\n"
"    #define __SIZE_TYPE__ unsigned int\n"
"    #define __PTRDIFF_TYPE__ int\n"
"#endif\n"
"    #define __ILP32__ 1\n"
"    #define __INT64_TYPE__ long long\n"
"#elif __SIZEOF_LONG__ == 4\n"
"    /* 64bit Windows. */\n"
"    #define __SIZE_TYPE__ unsigned long long\n"
"    #define __PTRDIFF_TYPE__ long long\n"
"    #define __LLP64__ 1\n"
"    #define __INT64_TYPE__ long long\n"
"#else\n"
"    /* Other 64bit systems. */\n"
"    #define __SIZE_TYPE__ unsigned long\n"
"    #define __PTRDIFF_TYPE__ long\n"
"    #define __LP64__ 1\n"
"# if defined __linux__\n"
"    #define __INT64_TYPE__ long\n"
"# else /* APPLE, BSD */\n"
"    #define __INT64_TYPE__ long long\n"
"# endif\n"
"#endif\n"
"    #define __SIZEOF_INT__ 4\n"
"    #define __INT_MAX__ 0x7fffffff\n"
"#if __SIZEOF_LONG__ == 4\n"
"    #define __LONG_MAX__ 0x7fffffffL\n"
"#else\n"
"    #define __LONG_MAX__ 0x7fffffffffffffffL\n"
"#endif\n"
"    #define __SIZEOF_LONG_LONG__ 8\n"
"    #define __LONG_LONG_MAX__ 0x7fffffffffffffffLL\n"
"    #define __CHAR_BIT__ 8\n"
"    #define __ORDER_LITTLE_ENDIAN__ 1234\n"
"    #define __ORDER_BIG_ENDIAN__ 4321\n"
"    #define __BYTE_ORDER__ __ORDER_LITTLE_ENDIAN__\n"
"#if defined _WIN32\n"
"    #define __WCHAR_TYPE__ unsigned short\n"
"    #define __WINT_TYPE__ unsigned short\n"
"#elif defined __linux__\n"
"    #define __WCHAR_TYPE__ int\n"
"    #define __WINT_TYPE__ unsigned int\n"
"#else\n"
"    #define __WCHAR_TYPE__ int\n"
"    #define __WINT_TYPE__ int\n"
"#endif\n"
"\n"
"    #if __STDC_VERSION__ == 201112L\n"
"    # define __STDC_NO_ATOMICS__ 1\n"
"    # define __STDC_NO_COMPLEX__ 1\n"
"    # define __STDC_NO_THREADS__ 1\n"
"#if !defined _WIN32\n"
"    # define __STDC_UTF_16__ 1\n"
"    # define __STDC_UTF_32__ 1\n"
"#endif\n"
"    #endif\n"
"\n"
"#if defined _WIN32\n"
"    #define __declspec(x) __attribute__((x))\n"
"    #define __cdecl\n"
"\n"
"#elif defined __FreeBSD__\n"
"    #define __GNUC__ 9\n"
"    #define __GNUC_MINOR__ 3\n"
"    #define __GNUC_PATCHLEVEL__ 0\n"
"    #define __GNUC_STDC_INLINE__ 1\n"
"    #define __NO_TLS 1\n"
"    #define __RUNETYPE_INTERNAL 1\n"
"# if __SIZEOF_POINTER__ == 8\n"
"    /* FIXME, __int128_t is used by setjump */\n"
"    #define __int128_t struct { unsigned char _dummy[16] __attribute((aligned(16))); }\n"
"    #define __SIZEOF_SIZE_T__ 8\n"
"    #define __SIZEOF_PTRDIFF_T__ 8\n"
"#else\n"
"    #define __SIZEOF_SIZE_T__ 4\n"
"    #define __SIZEOF_PTRDIFF_T__ 4\n"
"# endif\n"
"\n"
"#elif defined __FreeBSD_kernel__\n"
"\n"
"#elif defined __NetBSD__\n"
"    #define __GNUC__ 4\n"
"    #define __GNUC_MINOR__ 1\n"
"    #define __GNUC_PATCHLEVEL__ 0\n"
"    #define _Pragma(x)\n"
"    #define __ELF__ 1\n"
"#if defined __aarch64__\n"
"    #define _LOCORE /* avoids usage of __asm */\n"
"#endif\n"
"\n"
"#elif defined __OpenBSD__\n"
"    #define __GNUC__ 4\n"
"    #define _ANSI_LIBRARY 1\n"
"\n"
"#elif defined __APPLE__\n"
"    /* emulate APPLE-GCC to make libc's headerfiles compile: */\n"
"    #define __GNUC__ 4   /* darwin emits warning on GCC<4 */\n"
"    #define __APPLE_CC__ 1 /* for <TargetConditionals.h> */\n"
"    #define __LITTLE_ENDIAN__ 1\n"
"    #define _DONT_USE_CTYPE_INLINE_ 1\n"
"    /* avoids usage of GCC/clang specific builtins in libc-headerfiles: */\n"
"    #define __FINITE_MATH_ONLY__ 1\n"
"    #define _FORTIFY_SOURCE 0\n"
"\n"
"#else\n"
"    /* Linux */\n"
"\n"
"#endif\n"
"    /* Some derived integer types needed to get stdint.h to compile correctly on some platforms */\n"
"#ifndef __NetBSD__\n"
"    #define __UINTPTR_TYPE__ unsigned __PTRDIFF_TYPE__\n"
"    #define __INTPTR_TYPE__ __PTRDIFF_TYPE__\n"
"#endif\n"
"    #define __INT32_TYPE__ int\n"
"\n"
"#if !defined _WIN32\n"
"    /* glibc defines */\n"
"    #define __REDIRECT(name, proto, alias) name proto __asm__ (#alias)\n"
"    #define __REDIRECT_NTH(name, proto, alias) name proto __asm__ (#alias) __THROW\n"
"#endif\n"
"\n"
"    /* skip __builtin... with -E */\n"
"    #ifndef __TCC_PP__\n"
"\n"
"    #define __builtin_offsetof(type, field) ((__SIZE_TYPE__)&((type*)0)->field)\n"
"    #define __builtin_extract_return_addr(x) x\n"
"#if !defined __linux__ && !defined _WIN32\n"
"    /* used by math.h */\n"
"    #define __builtin_huge_val() 1e500\n"
"    #define __builtin_huge_valf() 1e50f\n"
"    #define __builtin_huge_vall() 1e5000L\n"
"# if defined __APPLE__\n"
"    #define __builtin_nanf(ignored_string) __nan()\n"
"    /* used by floats.h to implement FLT_ROUNDS C99 macro. 1 == to nearest */\n"
"    #define __builtin_flt_rounds() 1\n"
"    /* used by _fd_def.h */\n"
"    #define __builtin_bzero(p, ignored_size) bzero(p, sizeof(*(p)))\n"
"# else\n"
"    #define __builtin_nanf(ignored_string) (0.0F/0.0F)\n"
"# endif\n"
"#endif\n"
"\n"
"    /* __builtin_va_list */\n"
"#if defined __x86_64__\n"
"#if !defined _WIN32\n"
"    /* GCC compatible definition of va_list. */\n"
"    /* This should be in sync with the declaration in our lib/libtcc1.c */\n"
"    typedef struct {\n"
"        unsigned gp_offset, fp_offset;\n"
"        union {\n"
"            unsigned overflow_offset;\n"
"            char *overflow_arg_area;\n"
"        };\n"
"        char *reg_save_area;\n"
"    } __builtin_va_list[1];\n"
"\n"
"    void *__va_arg(__builtin_va_list ap, int arg_type, int size, int align);\n"
"    #define __builtin_va_start(ap, last) \\\n"
"       (*(ap) = *(__builtin_va_list)((char*)__builtin_frame_address(0) - 24))\n"
"    #define __builtin_va_arg(ap, t)   \\\n"
"       (*(t *)(__va_arg(ap, __builtin_va_arg_types(t), sizeof(t), __alignof__(t))))\n"
"    #define __builtin_va_copy(dest, src) (*(dest) = *(src))\n"
"\n"
"#else /* _WIN64 */\n"
"    typedef char *__builtin_va_list;\n"
"    #define __builtin_va_arg(ap, t) ((sizeof(t) > 8 || (sizeof(t) & (sizeof(t) - 1))) \\\n"
"        ? **(t **)((ap += 8) - 8) : *(t  *)((ap += 8) - 8))\n"
"#endif\n"
"\n"
"#elif defined __arm__\n"
"    typedef char *__builtin_va_list;\n"
"    #define _tcc_alignof(type) ((int)&((struct {char c;type x;} *)0)->x)\n"
"    #define _tcc_align(addr,type) (((unsigned)addr + _tcc_alignof(type) - 1) \\\n"
"                                  & ~(_tcc_alignof(type) - 1))\n"
"    #define __builtin_va_start(ap,last) (ap = ((char *)&(last)) + ((sizeof(last)+3)&~3))\n"
"    #define __builtin_va_arg(ap,type) (ap = (void *) ((_tcc_align(ap,type)+sizeof(type)+3) \\\n"
"                           &~3), *(type *)(ap - ((sizeof(type)+3)&~3)))\n"
"\n"
"#elif defined __aarch64__\n"
"    typedef struct {\n"
"        void *__stack, *__gr_top, *__vr_top;\n"
"        int   __gr_offs, __vr_offs;\n"
"    } __builtin_va_list;\n"
"\n"
"#elif defined __riscv\n"
"    typedef char *__builtin_va_list;\n"
"    #define __va_reg_size (__riscv_xlen >> 3)\n"
"    #define _tcc_align(addr,type) (((unsigned long)addr + __alignof__(type) - 1) \\\n"
"                                  & -(__alignof__(type)))\n"
"    #define __builtin_va_arg(ap,type) (*(sizeof(type) > (2*__va_reg_size) ? *(type **)((ap += __va_reg_size) - __va_reg_size) : (ap = (va_list)(_tcc_align(ap,type) + (sizeof(type)+__va_reg_size - 1)& -__va_reg_size), (type *)(ap - ((sizeof(type)+ __va_reg_size - 1)& -__va_reg_size)))))\n"
"\n"
"#else /* __i386__ */\n"
"    typedef char *__builtin_va_list;\n"
"    #define __builtin_va_start(ap,last) (ap = ((char *)&(last)) + ((sizeof(last)+3)&~3))\n"
"    #define __builtin_va_arg(ap,t) (*(t*)((ap+=(sizeof(t)+3)&~3)-((sizeof(t)+3)&~3)))\n"
"\n"
"#endif\n"
"    #define __builtin_va_end(ap) (void)(ap)\n"
"    #ifndef __builtin_va_copy\n"
"    # define __builtin_va_copy(dest, src) (dest) = (src)\n"
"    #endif\n"
"\n"
"    /* TCC BBUILTIN AND BOUNDS ALIASES */\n"
"    #ifdef __leading_underscore\n"
"    # define __RENAME(X) __asm__(\"_\"X)\n"
"    #else\n"
"    # define __RENAME(X) __asm__(X)\n"
"    #endif\n"
"\n"
"    #ifdef __BOUNDS_CHECKING_ON\n"
"    # define __BUILTINBC(ret,name,params) ret __builtin_##name params __RENAME(\"__bound_\"#name);\n"
"    # define __BOUND(ret,name,params) ret name params __RENAME(\"__bound_\"#name);\n"
"    #else\n"
"    # define __BUILTINBC(ret,name,params) ret __builtin_##name params __RENAME(#name);\n"
"    # define __BOUND(ret,name,params)\n"
"    #endif\n"
"#ifdef _WIN32\n"
"    #define __BOTH __BOUND\n"
"    #define __BUILTIN(ret,name,params)\n"
"#else\n"
"    #define __BOTH(ret,name,params) __BUILTINBC(ret,name,params)__BOUND(ret,name,params)\n"
"    #define __BUILTIN(ret,name,params) ret __builtin_##name params __RENAME(#name);\n"
"#endif\n"
"\n"
"    __BOTH(void*, memcpy, (void *, const void*, __SIZE_TYPE__))\n"
"    __BOTH(void*, memmove, (void *, const void*, __SIZE_TYPE__))\n"
"    __BOTH(void*, memset, (void *, int, __SIZE_TYPE__))\n"
"    __BOTH(int, memcmp, (const void *, const void*, __SIZE_TYPE__))\n"
"    __BOTH(__SIZE_TYPE__, strlen, (const char *))\n"
"    __BOTH(char*, strcpy, (char *, const char *))\n"
"    __BOTH(char*, strncpy, (char *, const char*, __SIZE_TYPE__))\n"
"    __BOTH(int, strcmp, (const char*, const char*))\n"
"    __BOTH(int, strncmp, (const char*, const char*, __SIZE_TYPE__))\n"
"    __BOTH(char*, strcat, (char*, const char*))\n"
"    __BOTH(char*, strchr, (const char*, int))\n"
"    __BOTH(char*, strdup, (const char*))\n"
"#if defined __ARM_EABI__\n"
"    __BOUND(void*,__aeabi_memcpy,(void*,const void*,__SIZE_TYPE__))\n"
"    __BOUND(void*,__aeabi_memmove,(void*,const void*,__SIZE_TYPE__))\n"
"    __BOUND(void*,__aeabi_memmove4,(void*,const void*,__SIZE_TYPE__))\n"
"    __BOUND(void*,__aeabi_memmove8,(void*,const void*,__SIZE_TYPE__))\n"
"    __BOUND(void*,__aeabi_memset,(void*,int,__SIZE_TYPE__))\n"
"#endif\n"
"\n"
"#if defined __linux__ || defined __APPLE__ // HAVE MALLOC_REDIR\n"
"    #define __MAYBE_REDIR __BUILTIN\n"
"#else\n"
"    #define __MAYBE_REDIR __BOTH\n"
"#endif\n"
"    __MAYBE_REDIR(void*, malloc, (__SIZE_TYPE__))\n"
"    __MAYBE_REDIR(void*, realloc, (void *, __SIZE_TYPE__))\n"
"    __MAYBE_REDIR(void*, calloc, (__SIZE_TYPE__, __SIZE_TYPE__))\n"
"    __MAYBE_REDIR(void*, memalign, (__SIZE_TYPE__, __SIZE_TYPE__))\n"
"    __MAYBE_REDIR(void, free, (void*))\n"
"#if defined __i386__ || defined __x86_64__\n"
"    __BOTH(void*, alloca, (__SIZE_TYPE__))\n"
"#else\n"
"    __BUILTIN(void*, alloca, (__SIZE_TYPE__))\n"
"#endif\n"
"    __BUILTIN(void, abort, (void))\n"
"    __BOUND(void, longjmp, ())\n"
"#if !defined _WIN32\n"
"    __BOUND(void*, mmap, ())\n"
"    __BOUND(int, munmap, ())\n"
"#endif\n"
"    #undef __BUILTINBC\n"
"    #undef __BUILTIN\n"
"    #undef __BOUND\n"
"    #undef __BOTH\n"
"    #undef __MAYBE_REDIR\n"
"    #undef __RENAME\n"
"\n"
"    #endif /* ndef __TCC_PP__ */\n"
""