# lsof

> يعرض قائمة الملفات المفتوحة والعمليات المرتبطة بها.
> ملاحظة: تتطلب بعض الأوامر صلاحيات الجذر (أو sudo) لعرض الملفات المفتوحة من قبل الآخرين.
> لمزيد من التفاصيل: <https://manned.org/lsof>.

- العثور على العمليات التي فتحت ملفًا معينًا:

`lsof {{path/to/file}}`

- العثور على العملية التي فتحت منفذ إنترنت محدد:

`lsof -i :{{port}}`

- عرض معرف العملية (PID) فقط:

`lsof -t {{path/to/file}}`

- عرض الملفات المفتوحة بواسطة مستخدم معين:

`lsof -u {{username}}`

- عرض الملفات المفتوحة بواسطة أمر أو عملية معينة:

`lsof -c {{process_or_command_name}}`

- عرض الملفات المفتوحة بواسطة عملية معينة باستخدام PID:

`lsof -p {{PID}}`

- عرض الملفات المفتوحة داخل مُجَلَّد معين:

`lsof +D {{path/to/directory}}`

- العثور على العملية التي تستمع على منفذ TCP محلي عبر IPv6 دون تحويل أرقام الشبكة أو المنافذ:

`lsof -i6TCP:{{port}} -sTCP:LISTEN -n -P`
