/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.bib;

import com.dickimawbooks.texparserlib.TeXObject;

public class Contributor {
    private String forenames;
    private String surname;
    private String von;
    private String suffix;
    private TeXObject forenamesObject = null;
    private TeXObject surnameObject = null;
    private TeXObject vonObject = null;
    private TeXObject suffixObject = null;

    public Contributor() {
    }

    public Contributor(String string, String string2) {
        this(string, null, string2, null);
    }

    public Contributor(String string, String string2, String string3, String string4) {
        this.forenames = string;
        this.von = string2;
        this.surname = string3;
        this.suffix = string4;
    }

    public Contributor(TeXObject teXObject, TeXObject teXObject2, TeXObject teXObject3, TeXObject teXObject4) {
        this.forenamesObject = teXObject;
        this.vonObject = teXObject2;
        this.surnameObject = teXObject3;
        this.suffixObject = teXObject4;
        if (teXObject != null) {
            this.forenames = teXObject.format();
        }
        if (teXObject2 != null) {
            this.von = teXObject2.format();
        }
        if (teXObject3 != null) {
            this.surname = teXObject3.format();
        }
        if (teXObject4 != null) {
            this.suffix = teXObject4.format();
        }
    }

    public String getForenames() {
        return this.forenames;
    }

    public TeXObject getForenamesObject() {
        return this.forenamesObject;
    }

    public String getSurname() {
        return this.surname;
    }

    public TeXObject getSurnameObject() {
        return this.surnameObject;
    }

    public String getVonPart() {
        return this.von;
    }

    public TeXObject getVonPartObject() {
        return this.vonObject;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public TeXObject getSuffixObject() {
        return this.suffixObject;
    }

    public String format() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.von != null && !this.von.isEmpty()) {
            stringBuilder.append(this.von + " ");
        }
        if (this.surname != null) {
            stringBuilder.append(this.surname);
        }
        if (this.suffix != null && !this.suffix.isEmpty()) {
            if (this.surname != null) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.suffix);
        }
        if (this.forenames != null && !this.forenames.isEmpty()) {
            if (this.surname != null || this.suffix != null) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.forenames);
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return String.format("%s[forenames=\"%s\",von=\"%s\",surname=\"%s\",suffix=\"%s\"]", this.getClass().getSimpleName(), this.forenames, this.von, this.surname, this.suffix);
    }

    public void setForenames(String string) {
        this.forenames = string;
    }

    public void setForenames(String string, TeXObject teXObject) {
        this.forenames = string;
        this.forenamesObject = teXObject;
    }

    public void setSurname(String string) {
        this.surname = string;
    }

    public void setSurname(String string, TeXObject teXObject) {
        this.surname = string;
        this.surnameObject = teXObject;
    }

    public void setVonPart(String string) {
        this.von = string;
    }

    public void setVonPart(String string, TeXObject teXObject) {
        this.von = string;
        this.vonObject = teXObject;
    }

    public void setSuffix(String string) {
        this.suffix = string;
    }

    public void setSuffix(String string, TeXObject teXObject) {
        this.suffix = string;
        this.suffixObject = teXObject;
    }
}

