/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ArraySet<E>
extends AbstractSet<E>
implements Serializable {
    private final List<E> backer;
    private static final long serialVersionUID = 1L;

    public ArraySet() {
        this(10);
    }

    public ArraySet(List<E> source) {
        this.backer = source;
    }

    public ArraySet(int initialSize) {
        this.backer = new ArrayList(initialSize);
    }

    @SafeVarargs
    public ArraySet(E ... elements) {
        this(elements.length);
        for (E element : elements) {
            this.add(element);
        }
    }

    @Override
    public Iterator<E> iterator() {
        return this.backer.iterator();
    }

    @Override
    public boolean add(E e) {
        if (this.backer.contains(e)) {
            return false;
        }
        return this.backer.add(e);
    }

    @Override
    public int size() {
        return this.backer.size();
    }
}

