/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.tagger.maxent.Dictionary;
import edu.stanford.nlp.tagger.maxent.Extractor;
import edu.stanford.nlp.tagger.maxent.ExtractorCapDistLC;
import edu.stanford.nlp.tagger.maxent.History;
import edu.stanford.nlp.tagger.maxent.MaxentTagger;
import edu.stanford.nlp.tagger.maxent.PairsHolder;
import edu.stanford.nlp.tagger.maxent.RareExtractor;

class ExtractorCapLCSeen
extends RareExtractor {
    final String tag;
    private int cutoff = 1;
    private final Extractor cCapDist = new ExtractorCapDistLC();
    private transient Dictionary dict;
    private static final long serialVersionUID = 35L;

    ExtractorCapLCSeen(String tag) {
        this.tag = tag;
    }

    @Override
    protected void setGlobalHolder(MaxentTagger tagger) {
        this.dict = tagger.dict;
    }

    @Override
    public boolean precondition(String tag1) {
        return this.tag.equals(tag1);
    }

    @Override
    String extract(History h, PairsHolder pH) {
        String res = this.cCapDist.extract(h, pH);
        if (res.equals("0")) {
            return res;
        }
        String word = pH.getWord(h, 0);
        if (this.dict.getCount(word, this.tag) > this.cutoff) {
            return res + this.tag;
        }
        return "0";
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public boolean isDynamic() {
        return false;
    }
}

