/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.command.shell;

import jline.console.completer.ArgumentCompleter;

class EscapeAwareWhiteSpaceArgumentDelimiter
extends ArgumentCompleter.WhitespaceArgumentDelimiter {
    EscapeAwareWhiteSpaceArgumentDelimiter() {
    }

    public boolean isEscaped(CharSequence buffer, int pos) {
        return this.isEscapeChar(buffer, pos - 1);
    }

    private boolean isEscapeChar(CharSequence buffer, int pos) {
        if (pos >= 0) {
            for (char c : this.getEscapeChars()) {
                if (buffer.charAt(pos) != c) continue;
                return !this.isEscapeChar(buffer, pos - 1);
            }
        }
        return false;
    }

    public boolean isQuoted(CharSequence buffer, int pos) {
        int closingQuote = this.searchBackwards(buffer, pos - 1, this.getQuoteChars());
        if (closingQuote == -1) {
            return false;
        }
        int openingQuote = this.searchBackwards(buffer, closingQuote - 1, new char[]{buffer.charAt(closingQuote)});
        if (openingQuote == -1) {
            return true;
        }
        return this.isQuoted(buffer, openingQuote - 1);
    }

    private int searchBackwards(CharSequence buffer, int pos, char ... chars) {
        while (pos >= 0) {
            for (char c : chars) {
                if (buffer.charAt(pos) != c || this.isEscaped(buffer, pos)) continue;
                return pos;
            }
            --pos;
        }
        return -1;
    }

    String[] parseArguments(String line) {
        ArgumentCompleter.ArgumentList delimit = this.delimit((CharSequence)line, 0);
        return this.cleanArguments(delimit.getArguments());
    }

    private String[] cleanArguments(String[] arguments) {
        String[] cleanArguments = new String[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            cleanArguments[i] = this.cleanArgument(arguments[i]);
        }
        return cleanArguments;
    }

    private String cleanArgument(String argument) {
        for (char c : this.getQuoteChars()) {
            String quote = String.valueOf(c);
            if (!argument.startsWith(quote) || !argument.endsWith(quote)) continue;
            return this.replaceEscapes(argument.substring(1, argument.length() - 1));
        }
        return this.replaceEscapes(argument);
    }

    private String replaceEscapes(String string) {
        string = string.replace("\\ ", " ");
        string = string.replace("\\\\", "\\");
        string = string.replace("\\t", "\t");
        string = string.replace("\\\"", "\"");
        string = string.replace("\\'", "'");
        return string;
    }
}

