# flake8: noqa: E501

# This file is part of Scapy
# See http://www.secdev.org/projects/scapy for more information
# Copyright (C) Nils Weiss <nils@we155.de>
# This program is published under a GPLv2 license

# scapy.contrib.description = Daimler specific definitions for UDS
# scapy.contrib.status = loads


from scapy.contrib.automotive.uds import UDS_RDBI

UDS_RDBI.dataIdentifiers[0x0000] = "Read all stored UID from Kleer-Module"
UDS_RDBI.dataIdentifiers[0x0002] = "Freeze Frame Diagnostic Trouble Code"
UDS_RDBI.dataIdentifiers[0x0003] = "Kalibrierung"
UDS_RDBI.dataIdentifiers[0x0004] = "Calculated Load Value"
UDS_RDBI.dataIdentifiers[0x0005] = "Engine Coolant Temperature"
UDS_RDBI.dataIdentifiers[0x0006] = "Status FIN-Verriegelung"
UDS_RDBI.dataIdentifiers[0x0007] = "Service Sensorjustage Fortschrittsanzeige"  	 # or Zustand ELV Fahrt Verriegelung 1 ELV Verrieglung
UDS_RDBI.dataIdentifiers[0x0008] = "Status Sensor Justage "
UDS_RDBI.dataIdentifiers[0x0009] = "EOL Sensorjustage Fortschrittsanzeige"  	 # or Kraftstoffdruck Sollwert Sollwert Aktuell, Kraftstoffdruck Sollwert
UDS_RDBI.dataIdentifiers[0x000a] = "AD Werte Batteriespannung"
UDS_RDBI.dataIdentifiers[0x000b] = "EKP Motorspannung PRES Spannung"  	 # or Batteriespannung PRES Spannung, Temperatursensor PRES Temperatur, Batteriespannung, KSD Sensor Signal PRES Kraftstoffdruck
UDS_RDBI.dataIdentifiers[0x000c] = "Engine Speed"  	 # or Status Werte EKP Lauf, Status Werte, Status Werte EC Motor Stop Reason, Status Werte Kl 15 PRES aus ein 1Bit, Status Werte EKP Lauf PRES aus ein 1Bit
UDS_RDBI.dataIdentifiers[0x000d] = "Connected devices"
UDS_RDBI.dataIdentifiers[0x000f] = "IntakeAirTemperature"
UDS_RDBI.dataIdentifiers[0x0010] = "Keypad test"
UDS_RDBI.dataIdentifiers[0x0011] = "Present DVD Region Code"
UDS_RDBI.dataIdentifiers[0x0012] = "DVD Remaining Changes"  	 # or manufacturing data container data container
UDS_RDBI.dataIdentifiers[0x0015] = "Status Drehfalle Fahrertuer Fahrertuer"
UDS_RDBI.dataIdentifiers[0x0016] = "Keypad test"
UDS_RDBI.dataIdentifiers[0x001a] = "DPM"
UDS_RDBI.dataIdentifiers[0x001c] = "Status Werte Entwicklung EC Motor Stop Reason"  	 # or Status Werte Entwicklung EKP Lauf
UDS_RDBI.dataIdentifiers[0x0020] = "Lernwerte Eigenlenkgradient"
UDS_RDBI.dataIdentifiers[0x0021] = "Distance With Malfunction Indicator Lamp On"
UDS_RDBI.dataIdentifiers[0x0024] = "02 global variant coding"  	
UDS_RDBI.dataIdentifiers[0x0025] = "DCX Engineering Traceability"  	 # or Motortyp Motortyp, Motortyp Lesen, @36076
UDS_RDBI.dataIdentifiers[0x0026] = "Buswachhalterereignisse Anzahl Buswachhalter"  	 # or Buswachhalterereignisse Lesen
UDS_RDBI.dataIdentifiers[0x0027] = "02 global variant coding 2"  	
UDS_RDBI.dataIdentifiers[0x0028] = "Versorgungsspannung Ubat"
UDS_RDBI.dataIdentifiers[0x0029] = "Versorgungsspannung Notbatterie Ubat"
UDS_RDBI.dataIdentifiers[0x0030] = "Warm-Up Cycles Since Code Clear"
UDS_RDBI.dataIdentifiers[0x0031] = "Distance Since Code Clear"
UDS_RDBI.dataIdentifiers[0x0033] = "Barometric Pressure"
UDS_RDBI.dataIdentifiers[0x0034] = "Zentralverriegelung Zentralverriegelung"
UDS_RDBI.dataIdentifiers[0x0040] = "Lernwerte Veigen"
UDS_RDBI.dataIdentifiers[0x0042] = "Control Module Voltage"
UDS_RDBI.dataIdentifiers[0x0043] = "DC-Block"
UDS_RDBI.dataIdentifiers[0x0046] = "Ambient Air Temperature"
UDS_RDBI.dataIdentifiers[0x0049] = "Accelarator Pedal Position"
UDS_RDBI.dataIdentifiers[0x0051] = "Read firmware from Kleer-Module"
UDS_RDBI.dataIdentifiers[0x0080] = "DC Block DC Block"
UDS_RDBI.dataIdentifiers[0x0081] = "Letzte Nachricht zur ELV Daten zur ELV"
UDS_RDBI.dataIdentifiers[0x0082] = "Letzte Nachricht von der ELV Daten der ELV"
UDS_RDBI.dataIdentifiers[0x008b] = "Konfiguration Buswachhaltermonitoring Abblendlicht Status beruecksichtigen"
UDS_RDBI.dataIdentifiers[0x008c] = "Buswachhalter Ereignisse"
UDS_RDBI.dataIdentifiers[0x00a0] = "MEC Manufacturers Enable"
UDS_RDBI.dataIdentifiers[0x00b4] = "Manufacturing Traceability Character"
UDS_RDBI.dataIdentifiers[0x00d1] = "Environment Data"
UDS_RDBI.dataIdentifiers[0x00e0] = "Musterstand"
UDS_RDBI.dataIdentifiers[0x0100] = "Reprogramming Attempt Counter"
UDS_RDBI.dataIdentifiers[0x0101] = "ECU Logging Data"  	 # or Zugriff Fehlerspeicher DTC Lese Zaehler, Copy of Historical Interrogation Record DTC Read Counter
UDS_RDBI.dataIdentifiers[0x0102] = "Diagnostic Trace Memory Data Byte"  	
UDS_RDBI.dataIdentifiers[0x0103] = "VIN Odometer Counter Schreiben"  	
UDS_RDBI.dataIdentifiers[0x0104] = "VIN Odometer Counter Limit Schreiben"  	
UDS_RDBI.dataIdentifiers[0x0105] = "Usage Histogram"  	
UDS_RDBI.dataIdentifiers[0x0106] = "Common Event Ring Memory"
UDS_RDBI.dataIdentifiers[0x0107] = "Response on Event light activation state"  	
UDS_RDBI.dataIdentifiers[0x0108] = "Verbauliste"
UDS_RDBI.dataIdentifiers[0x010a] = "Vehicle Odometer in Low Resolution"
UDS_RDBI.dataIdentifiers[0x010b] = "Adjust ISO 15765 2 Block Size and STmin Parameter Block Size Value as defined in ISO 15765"  	
UDS_RDBI.dataIdentifiers[0x010c] = "Read Odometer value from Bus"
UDS_RDBI.dataIdentifiers[0x010d] = "Read Used EVC Config 460 VEHICLES FOR CANADA ADDITIONAL PARTS"
UDS_RDBI.dataIdentifiers[0x010f] = "Read LIN Slope"  	
UDS_RDBI.dataIdentifiers[0x0110] = "Dezentrales Power Management - Chassis CAN Infos"  	
UDS_RDBI.dataIdentifiers[0x0111] = "Dezentrales Power Management - Powertrain CAN Infos"
UDS_RDBI.dataIdentifiers[0x0112] = "Dezentrales Power Management - PT Sensor CAN Infos"
UDS_RDBI.dataIdentifiers[0x0115] = "EEProm lesen"
UDS_RDBI.dataIdentifiers[0x011d] = "Kalibrierung IMotOffset"  	
UDS_RDBI.dataIdentifiers[0x011e] = "EOL Pruefstempel EOL Pruefbyte"
UDS_RDBI.dataIdentifiers[0x011f] = "ICT Pruefstempel Hardware Version"
UDS_RDBI.dataIdentifiers[0x0120] = "Reprogramming Resume Information"
UDS_RDBI.dataIdentifiers[0x012d] = "Engine Style"
UDS_RDBI.dataIdentifiers[0x0130] = "Activate Partial Networking"
UDS_RDBI.dataIdentifiers[0x0131] = "Plausibilisierung Kraftstoffdrucksensor Referenzdaten Data locked"
UDS_RDBI.dataIdentifiers[0x0132] = "Operating Time of Last Ignition Cycle"  	
UDS_RDBI.dataIdentifiers[0x0133] = "Operating Time"
UDS_RDBI.dataIdentifiers[0x0134] = "SAR Trigger Counter"
UDS_RDBI.dataIdentifiers[0x0135] = "Number of SAR Write Cycles"
UDS_RDBI.dataIdentifiers[0x0136] = "Configure SAR Trigger Events"
UDS_RDBI.dataIdentifiers[0x0137] = "Enable SAR Memory Overwrite"
UDS_RDBI.dataIdentifiers[0x0138] = "Customer Settings"
UDS_RDBI.dataIdentifiers[0x0141] = "Zaehler Sychronisierungsverlust Odo"  	
UDS_RDBI.dataIdentifiers[0x0142] = "Availability Data"
UDS_RDBI.dataIdentifiers[0x0160] = "Ethernet Link Quality"  	
UDS_RDBI.dataIdentifiers[0x0161] = "Ethernet Switch Counters"
UDS_RDBI.dataIdentifiers[0x0162] = "Ethernet Drop Counters"  	
UDS_RDBI.dataIdentifiers[0x0163] = "Ethernet MIB Counters"  	
UDS_RDBI.dataIdentifiers[0x0164] = "Ethernet Link Statistics"  	
UDS_RDBI.dataIdentifiers[0x0165] = "Ethernet Link"
UDS_RDBI.dataIdentifiers[0x0166] = "Ethernet Port"
UDS_RDBI.dataIdentifiers[0x0167] = "Ethernet Wake up Line"
UDS_RDBI.dataIdentifiers[0x0168] = "Ethernet Wake up Line Activation"
UDS_RDBI.dataIdentifiers[0x0169] = "Ethernet Wake up Line Pulse Counter"
UDS_RDBI.dataIdentifiers[0x016a] = "Ethernet Transceiver Identification"
UDS_RDBI.dataIdentifiers[0x016b] = "Ethernet Switch Identification"
UDS_RDBI.dataIdentifiers[0x016c] = "Write Ethernet Port Mirroring Configuration"
UDS_RDBI.dataIdentifiers[0x016d] = "Read Ethernet Port Mirroring Configuration"
UDS_RDBI.dataIdentifiers[0x016e] = "Ethernet Port Mirroring"
UDS_RDBI.dataIdentifiers[0x016f] = "Ethernet MAC and IP Addresses"
UDS_RDBI.dataIdentifiers[0x0170] = "Ethernet Switch Address Table"
UDS_RDBI.dataIdentifiers[0x0171] = "Ethernet Hardware Configuration"  	
UDS_RDBI.dataIdentifiers[0x0173] = "Ethernet Switch Configuration"
UDS_RDBI.dataIdentifiers[0x0174] = "Ethernet Link Training Duration"
UDS_RDBI.dataIdentifiers[0x0175] = "Ethernet ENV Data"
UDS_RDBI.dataIdentifiers[0x0180] = "Root CA Certificate"
UDS_RDBI.dataIdentifiers[0x0181] = "Backend CA Certificate"
UDS_RDBI.dataIdentifiers[0x0182] = "Backend CA Certificate Identification"
UDS_RDBI.dataIdentifiers[0x0183] = "ECU Certificate"
UDS_RDBI.dataIdentifiers[0x0184] = "Diagnostic Authentication Certificate Identification"
UDS_RDBI.dataIdentifiers[0x0185] = "Access Control List Version"
UDS_RDBI.dataIdentifiers[0x0186] = "Secured System Date and Time"
UDS_RDBI.dataIdentifiers[0x0187] = "Security Event Log"
UDS_RDBI.dataIdentifiers[0x0188] = "SecOC PDU Data IDs and Key Checksum"
UDS_RDBI.dataIdentifiers[0x0189] = "SecOC Vehicle Shared Secret Hash"
UDS_RDBI.dataIdentifiers[0x018a] = "SecOC Local TickCount"
UDS_RDBI.dataIdentifiers[0x018b] = "SecOc ENV Data"
UDS_RDBI.dataIdentifiers[0x018c] = "Ladezustand"
UDS_RDBI.dataIdentifiers[0x0190] = "Security Event Log Current Counter Values"
UDS_RDBI.dataIdentifiers[0x01fa] = "Status Spiegelabklappung"
UDS_RDBI.dataIdentifiers[0x0202] = "Currents"  	 # or DependencyInformation, BDMS Mode Write Entwicklung, WS input voltage, Drehfalle Fahrertuer
UDS_RDBI.dataIdentifiers[0x0203] = "Engine"  	 # or Hardware Terminals, Keyless Go, HW terminals, Keyless Go KG vorhanden, Kl 50 input voltage
UDS_RDBI.dataIdentifiers[0x0204] = "Gearbox"  	 # or PN48 Battery Switch State, Kl 30Z voltage
UDS_RDBI.dataIdentifiers[0x0205] = "Config"  	 # or ST voltage
UDS_RDBI.dataIdentifiers[0x0206] = "Kombi"
UDS_RDBI.dataIdentifiers[0x0207] = "DataStatus"  	 # or Torque
UDS_RDBI.dataIdentifiers[0x0208] = "Blinker"
UDS_RDBI.dataIdentifiers[0x0209] = "CAN ECU State"  	 # or Status EOL Sensorjustag"  	
UDS_RDBI.dataIdentifiers[0x020a] = "ErrorBytes"  	 # or Entry Conditions RUN, Access Conditions RUN, Drehfallen
UDS_RDBI.dataIdentifiers[0x020b] = "Fail Conditions Position Sensor Offset Learning"  	 # or Fail Conditions ROL, BsdData
UDS_RDBI.dataIdentifiers[0x020c] = "Zentralverriegelung Letzte Aussenentriegelungsursache"  	 # or SensorPos, CVN calculation, Predriver Shutdownpathtest Isolation Information
UDS_RDBI.dataIdentifiers[0x020d] = "SMA"
UDS_RDBI.dataIdentifiers[0x020e] = "Status Transportmodus Status Transportmodus"
UDS_RDBI.dataIdentifiers[0x0210] = "Letzte Nachricht von der ELV Read SSP Daten"  	 # or Lernwerte Drehrate, 0210 Amplifier Supply Voltage Signal Error
UDS_RDBI.dataIdentifiers[0x0211] = "Regelparameter"
UDS_RDBI.dataIdentifiers[0x0212] = "Konfiguration Produktion"  	 # or Klemmenstatus Read Klemme 15, ASIC Type
UDS_RDBI.dataIdentifiers[0x0213] = "Filterparameter des Algorithmus"  	 # or Asic AssemblyLotID SYSSER0
UDS_RDBI.dataIdentifiers[0x0215] = "Thermoschutzparameter des Algorithmus Zaehler"
UDS_RDBI.dataIdentifiers[0x0217] = "Funktionsstatus Hexdumps NV"
UDS_RDBI.dataIdentifiers[0x0218] = "Thermoschutzparameter des Algorithmus Erhoehungswerte"
UDS_RDBI.dataIdentifiers[0x0219] = "DidAt Konfigurationskennung"
UDS_RDBI.dataIdentifiers[0x0220] = "0220 Central Components Supply Voltage Signal Error"  	 # or Transmitter IDs
UDS_RDBI.dataIdentifiers[0x0221] = "LeftFront Tx Id"
UDS_RDBI.dataIdentifiers[0x0222] = "RightFront Tx Id"
UDS_RDBI.dataIdentifiers[0x0223] = "Tuerzusatzsicherung Zustand Tuerzusatzsicherung"  	 # or Rightrear Tx Id
UDS_RDBI.dataIdentifiers[0x0224] = "LeftRear Tx Id"
UDS_RDBI.dataIdentifiers[0x0225] = "Fahrzeuginformationen"
UDS_RDBI.dataIdentifiers[0x0226] = "Defaultwerte I/O Control"
UDS_RDBI.dataIdentifiers[0x0228] = "EOL-Tester Informationen Antrieb"
UDS_RDBI.dataIdentifiers[0x022c] = "Drehsperre"
UDS_RDBI.dataIdentifiers[0x0230] = "0230 External 5V Supply Voltage Signal Error"  	 # or Lernwerte Lenkwinkel
UDS_RDBI.dataIdentifiers[0x0231] = "PM Status H0 Schalter"
UDS_RDBI.dataIdentifiers[0x0232] = "Fahrzeugausstattung "
UDS_RDBI.dataIdentifiers[0x0233] = "Globale Variantencodierung auslesen Baureihe"
UDS_RDBI.dataIdentifiers[0x023a] = "Eigendiagnose Eintraege global ED EEPROM Code"  	 # or Eigendiagnose Eintraege global loeschen
UDS_RDBI.dataIdentifiers[0x0240] = "PlatformThresholds CurrentlyInUse"  	 # or 0240 Audio Codec Supply Voltage Signal Error
UDS_RDBI.dataIdentifiers[0x0241] = "PlatformThresholds Programmed"  	 # or Internal Power Supplies
UDS_RDBI.dataIdentifiers[0x0242] = "Axle Nominal Isochores"
UDS_RDBI.dataIdentifiers[0x0243] = "Filling Detection Compare Values"
UDS_RDBI.dataIdentifiers[0x0245] = "Read Message Memory"
UDS_RDBI.dataIdentifiers[0x0247] = "Read Activation Memory"
UDS_RDBI.dataIdentifiers[0x0249] = "PlatformThresholds MinimumReferencePressure"
UDS_RDBI.dataIdentifiers[0x024a] = "PlatformThresholds LogicalData"
UDS_RDBI.dataIdentifiers[0x0255] = "WAL failure Statistics"
UDS_RDBI.dataIdentifiers[0x0256] = "Axle/Side Location"
UDS_RDBI.dataIdentifiers[0x0258] = "Get WAL monitoring counters"
UDS_RDBI.dataIdentifiers[0x025a] = "Autolocation Overide Switch"
UDS_RDBI.dataIdentifiers[0x025b] = "WAL RSSI Monitor"
UDS_RDBI.dataIdentifiers[0x0260] = "Status EOL Funktionstest"
UDS_RDBI.dataIdentifiers[0x0261] = "RF Statistics Right Front"
UDS_RDBI.dataIdentifiers[0x0262] = "RF Statistics Right Rear"
UDS_RDBI.dataIdentifiers[0x0263] = "RF Statistics Left Rear"
UDS_RDBI.dataIdentifiers[0x0265] = "LastReceivedTelegram LF"
UDS_RDBI.dataIdentifiers[0x0266] = "LastReceivedTelegram RF"
UDS_RDBI.dataIdentifiers[0x0267] = "LastReceivedTelegram RR"
UDS_RDBI.dataIdentifiers[0x0268] = "LastReceivedTelegram LR"
UDS_RDBI.dataIdentifiers[0x0271] = "CoastMode Control"
UDS_RDBI.dataIdentifiers[0x0273] = "Last Reset Type Counters"
UDS_RDBI.dataIdentifiers[0x0283] = "Local Battery Voltage"
UDS_RDBI.dataIdentifiers[0x0287] = "Low Battery Data"
UDS_RDBI.dataIdentifiers[0x0290] = "Low Battery Data Left Front"
UDS_RDBI.dataIdentifiers[0x0291] = "Low Battery Data Right Front"
UDS_RDBI.dataIdentifiers[0x0292] = "Low Battery Data Right Rear"
UDS_RDBI.dataIdentifiers[0x0293] = "Low Battery Data Left Rear"
UDS_RDBI.dataIdentifiers[0x0298] = "SEL Statistical data"
UDS_RDBI.dataIdentifiers[0x029c] = "RF Gain Mode CurrentlyInUse"
UDS_RDBI.dataIdentifiers[0x029d] = "RF Gain Mode Programmed"
UDS_RDBI.dataIdentifiers[0x02a0] = "Pressure values for model BR221"
UDS_RDBI.dataIdentifiers[0x02a1] = "Pressure values for model BR216"
UDS_RDBI.dataIdentifiers[0x02a2] = "Pressure values for model BR212"
UDS_RDBI.dataIdentifiers[0x02a3] = "Pressure values for model BR197/BR164"
UDS_RDBI.dataIdentifiers[0x02a4] = "Pressure values for model BR166"
UDS_RDBI.dataIdentifiers[0x02a5] = "Pressure values for model BR172/BR251"
UDS_RDBI.dataIdentifiers[0x02a6] = "Pressure values for model BR218"
UDS_RDBI.dataIdentifiers[0x02a7] = "Pressure values for model BR207"
UDS_RDBI.dataIdentifiers[0x02a8] = "Pressure values for model BR204"
UDS_RDBI.dataIdentifiers[0x02af] = "Gelernte HFS/ARWT Normierparameter NV"
UDS_RDBI.dataIdentifiers[0x02b1] = "Variant Coding"
UDS_RDBI.dataIdentifiers[0x02b3] = "Read RF"
UDS_RDBI.dataIdentifiers[0x02d7] = "Warntongeber"
UDS_RDBI.dataIdentifiers[0x02dd] = "Diagnosedaten Service Diagnosedaten"
UDS_RDBI.dataIdentifiers[0x02e4] = "MB Teilenummer Teilenummer Ersatzteil"
UDS_RDBI.dataIdentifiers[0x0300] = "Flanken Erkennung Fahrertuer"
UDS_RDBI.dataIdentifiers[0x0301] = "SynchronizationLost Data"  	 # or 08 Parameter Not Acknowledge Time Schreiben, SynchronizationLost Counter, DidA Rahmenwiederholungen DidA Rahmenwiederholungen, 08 Parameter Not Acknowledge Time Lesen
UDS_RDBI.dataIdentifiers[0x0302] = "SynchronizationLost Odo0 bis 7"  	 # or 09 Parameter Diag Active Time Lesen, 09 Parameter Diag Active Time Schreiben, Reservebaureihen und Reservekarosserievarianten Baureihe BR
UDS_RDBI.dataIdentifiers[0x0303] = "Daten Antennenmodul"  	 # or Daten Antennenmodul Read Frequenzvariante, Daten Antennenmodul Read Pmin, Daten Antennenmodul EEPROM Patch Level, Daten Antennenmodul Read KG Pmax, Daten Antennenmodul Frequenzvariante, Daten Antennenmodul Read KG Pmin
UDS_RDBI.dataIdentifiers[0x0304] = "HF Konfig"  	 # or LifeCycle, HF Konfig Dida, HF Konfig Sendeleistung KG
UDS_RDBI.dataIdentifiers[0x0305] = "FBS mobil Tuergriff"
UDS_RDBI.dataIdentifiers[0x0306] = "ZV Konfiguration Write"  	 # or ZV Konfiguration Read, Sensor Offset
UDS_RDBI.dataIdentifiers[0x0307] = "Position Sensor Offset"
UDS_RDBI.dataIdentifiers[0x0308] = "Status VIN Verriegelung"  	 # or Predicted Fuel Pressure Offset
UDS_RDBI.dataIdentifiers[0x0309] = "Compile Time"
UDS_RDBI.dataIdentifiers[0x030a] = "ZGW Verbaute Steuergeraete Soll Engine"
UDS_RDBI.dataIdentifiers[0x030b] = "Number of cold start interruptted by voltage out of range"
UDS_RDBI.dataIdentifiers[0x030c] = "Number of rv close 100ms"
UDS_RDBI.dataIdentifiers[0x030d] = "verbaute Steuergeraete Soll Bus 4"
UDS_RDBI.dataIdentifiers[0x030e] = "verbaute Steuergeraete Soll Bus 5"
UDS_RDBI.dataIdentifiers[0x030f] = "verbaute Steuergeraete Soll Bus 6"
UDS_RDBI.dataIdentifiers[0x0310] = "verbaute Steuergeraete Soll BodyRaw ECU Vektor Soll"  	
UDS_RDBI.dataIdentifiers[0x0311] = "verbaute Steuergeraete Soll Chassis1 Raw ECU Vektor Soll"
UDS_RDBI.dataIdentifiers[0x0312] = "verbaute Steuergeraete Soll Chassis2 Raw ECU Vektor Soll"
UDS_RDBI.dataIdentifiers[0x0313] = "verbaute Steuergeraete Soll Diagnostic CGW"
UDS_RDBI.dataIdentifiers[0x0314] = "07 Fahrzeugspezifische Daten Lesen"  	
UDS_RDBI.dataIdentifiers[0x0315] = "External failure"
UDS_RDBI.dataIdentifiers[0x0316] = "Kontrollschalter Eigendiagnose"
UDS_RDBI.dataIdentifiers[0x0317] = "voltage kl30z st cold auto rv close"
UDS_RDBI.dataIdentifiers[0x0318] = "number of PN swith close due to current flow pass diodes"
UDS_RDBI.dataIdentifiers[0x0319] = "switch failure"
UDS_RDBI.dataIdentifiers[0x031a] = "ZGW Konfiguration D CAN"  	 # or KL50 time out
UDS_RDBI.dataIdentifiers[0x031b] = "KL50 0 and WS 0 timeout or WS signal 2 5V 6V"
UDS_RDBI.dataIdentifiers[0x031c] = "other HW failure"
UDS_RDBI.dataIdentifiers[0x0320] = "reset all fault history memory"
UDS_RDBI.dataIdentifiers[0x0321] = "Informationen BINAER 1 Authentisch benutzt"
UDS_RDBI.dataIdentifiers[0x0322] = "EZS erweiterter Status KeylessGo"
UDS_RDBI.dataIdentifiers[0x0324] = "ZV Letzte Bedienungen"
UDS_RDBI.dataIdentifiers[0x0325] = "ZV Letzte Bedienungen Ringpuffer"
UDS_RDBI.dataIdentifiers[0x0326] = "ZV Letzte Schluessel Aktion"
UDS_RDBI.dataIdentifiers[0x0327] = "PRE Lock Ereignisspeicher"
UDS_RDBI.dataIdentifiers[0x0328] = "Status Thatcham SE Fangbereich Rechenschritte Auth"
UDS_RDBI.dataIdentifiers[0x0329] = "Letzter FC DSM Letzter Funktionscode vom DSM"
UDS_RDBI.dataIdentifiers[0x032a] = "verbaute Steuergeraete Ist Bus"
UDS_RDBI.dataIdentifiers[0x032b] = "verbaute Steuergeraete Ist Bus"
UDS_RDBI.dataIdentifiers[0x032c] = "verbaute Steuergeraete Ist Bus"
UDS_RDBI.dataIdentifiers[0x032d] = "verbaute Steuergeraete Ist Bus 4"
UDS_RDBI.dataIdentifiers[0x032e] = "verbaute Steuergeraete Ist Bus 5"
UDS_RDBI.dataIdentifiers[0x032f] = "verbaute Steuergeraete Ist Bus 6"
UDS_RDBI.dataIdentifiers[0x0330] = "Letzter FC MSG Letzter Funktionscode vom MSG"
UDS_RDBI.dataIdentifiers[0x0331] = "Letzter FC Getriebe Letzter Funktionscode vom Getriebe"
UDS_RDBI.dataIdentifiers[0x0332] = "Letzter FC Hybrid SG Letzter Funktionscode vom Hybrid SG"
UDS_RDBI.dataIdentifiers[0x0333] = "Letzter FC ELV Letzter Funktionscode von der ELV"
UDS_RDBI.dataIdentifiers[0x0334] = "Letzter FC Schluessel Letzter Funktionscode vom Schluessel"
UDS_RDBI.dataIdentifiers[0x0335] = "Status Konfigurationsbyte EZS verriegeln Status Konfigurationsbyte"
UDS_RDBI.dataIdentifiers[0x0336] = "Letzter FC DSM"
UDS_RDBI.dataIdentifiers[0x0337] = "Status Thatcham SE Fangbereich"
UDS_RDBI.dataIdentifiers[0x0338] = "Konfiguration Schluessel im EZS"  	
UDS_RDBI.dataIdentifiers[0x033a] = "Eigendiagnose Eintraege global"  	
UDS_RDBI.dataIdentifiers[0x033b] = "Eigendiagnose Eintraege identifiziert Anzahl erkannter Fehler"
UDS_RDBI.dataIdentifiers[0x033c] = "Eigendiagnose Zaehler global"
UDS_RDBI.dataIdentifiers[0x033d] = "Eigendiagnose Zaehler indiziert"
UDS_RDBI.dataIdentifiers[0x033e] = "Eigendiagnose FSP Eintrag AS AGC LOCK in FSP uebernehmen"
UDS_RDBI.dataIdentifiers[0x0340] = "Eindrahtschnittstelle Info Funkempfaenger vorhanden"
UDS_RDBI.dataIdentifiers[0x0341] = "Funkempfaenger Laendervariante Laendervariante"
UDS_RDBI.dataIdentifiers[0x0342] = "HF Empfangsdaten AUTH ZB"
UDS_RDBI.dataIdentifiers[0x0350] = "Konfiguration ELV VCD"
UDS_RDBI.dataIdentifiers[0x0351] = "ELV Verriegelungsablaufdaten"
UDS_RDBI.dataIdentifiers[0x0352] = "Signale zur Klemmengenerierung"
UDS_RDBI.dataIdentifiers[0x0360] = "Konfiguration Polling"  	
UDS_RDBI.dataIdentifiers[0x0361] = "Konfiguration FBS4 Write"
UDS_RDBI.dataIdentifiers[0x0380] = "SST Konfiguration"
UDS_RDBI.dataIdentifiers[0x0382] = "BTS Konfiguration VCD"
UDS_RDBI.dataIdentifiers[0x0385] = "Konfiguration IGN ON"
UDS_RDBI.dataIdentifiers[0x0386] = "Konfiguration Klemmen VAN"
UDS_RDBI.dataIdentifiers[0x0390] = "RTC Datum Uhrzeit"
UDS_RDBI.dataIdentifiers[0x0391] = "RTC Konfiguration"
UDS_RDBI.dataIdentifiers[0x0392] = "RTC Tagesumschlagzaehler"
UDS_RDBI.dataIdentifiers[0x03a0] = "Konfiguration fuer Produktion VC"
UDS_RDBI.dataIdentifiers[0x03a1] = "TAG Konfiguration"
UDS_RDBI.dataIdentifiers[0x03a2] = "TAG Position Tuergriff"
UDS_RDBI.dataIdentifiers[0x03ff] = "Lieferumfangsnummer"
UDS_RDBI.dataIdentifiers[0x0400] = "0400 Signal engine rpm last correct value"
UDS_RDBI.dataIdentifiers[0x0401] = "KG231 Konfiguration"  	 # or Max operating voltage
UDS_RDBI.dataIdentifiers[0x0402] = "single RV mos 2ms ocp"
UDS_RDBI.dataIdentifiers[0x0403] = "KeylessGo Kodierung"
UDS_RDBI.dataIdentifiers[0x0404] = "single RV mos 10ms ocp"
UDS_RDBI.dataIdentifiers[0x0405] = "Schalterspeicher Heckklappentaster"
UDS_RDBI.dataIdentifiers[0x0406] = "single RV MOS continual min start current"
UDS_RDBI.dataIdentifiers[0x0407] = "single bypass MOS switch min start current"
UDS_RDBI.dataIdentifiers[0x0408] = "Cold start KL50 ST RV switch close delay"
UDS_RDBI.dataIdentifiers[0x0409] = "CfgVAN DTSTO Read"
UDS_RDBI.dataIdentifiers[0x040a] = "warm start KL50 ST RV switch close delay"
UDS_RDBI.dataIdentifiers[0x040b] = "warm start to pre charging KL50 ST by pass switch open delay"
UDS_RDBI.dataIdentifiers[0x040c] = "pre charging to charging WS PN switch close delay"
UDS_RDBI.dataIdentifiers[0x040d] = "charging to pre auto warm start WS PN switch open delay"
UDS_RDBI.dataIdentifiers[0x040e] = "ST bypass close delay after RV close max"
UDS_RDBI.dataIdentifiers[0x040f] = "ST bypass close delay after RV close min"
UDS_RDBI.dataIdentifiers[0x0410] = "Kommunikation ELV"  	
UDS_RDBI.dataIdentifiers[0x0411] = "Kommunikation MSG Letzter Funktionscode vom MSG"
UDS_RDBI.dataIdentifiers[0x0412] = "Kommunikation Getriebe Letzter Funktionscode vom Getriebe"
UDS_RDBI.dataIdentifiers[0x0413] = "Kommunikation DSM Letzter Funktionscode vom DSM"
UDS_RDBI.dataIdentifiers[0x0414] = "Kommunikation Hybrid SG Letzter Funktionscode vom Hybrid SG"
UDS_RDBI.dataIdentifiers[0x0415] = "Kommunikation Schluessel Letzter Funktionscode vom Schluessel"
UDS_RDBI.dataIdentifiers[0x0416] = "rv over heat threshold"
UDS_RDBI.dataIdentifiers[0x0417] = "starter open kl30z st threshold"
UDS_RDBI.dataIdentifiers[0x0420] = "0420 Signal vehicle speed last correct value"
UDS_RDBI.dataIdentifiers[0x0421] = "Informationen EZS Aktiviert"
UDS_RDBI.dataIdentifiers[0x0422] = "EZS erweiterter Status Authentikations Anforderungsart"
UDS_RDBI.dataIdentifiers[0x0425] = "Letzte ZV Bedienungen"
UDS_RDBI.dataIdentifiers[0x0430] = "0430 Signal ignition limit violation"
UDS_RDBI.dataIdentifiers[0x0440] = "0440 Signal drive program last correct value"
UDS_RDBI.dataIdentifiers[0x0470] = "ELV zyklische Pruefung"
UDS_RDBI.dataIdentifiers[0x0471] = "ELV Kommunikationsparameter"
UDS_RDBI.dataIdentifiers[0x0472] = "ELV Verriegelung"
UDS_RDBI.dataIdentifiers[0x0480] = "Motorweiterlaufschaltung"
UDS_RDBI.dataIdentifiers[0x0481] = "Remote Start Engine"  	
UDS_RDBI.dataIdentifiers[0x0490] = "ZV Nachlaufzeit Vorraste"  	
UDS_RDBI.dataIdentifiers[0x04a0] = "EZS Variantenkodierung Schluessel"
UDS_RDBI.dataIdentifiers[0x04a1] = "KM Stand Speicher CRC"
UDS_RDBI.dataIdentifiers[0x04d3] = "Schwellen taktile Leisten"
UDS_RDBI.dataIdentifiers[0x04f3] = "Variante"
UDS_RDBI.dataIdentifiers[0x04f4] = "Variantenstatus"
UDS_RDBI.dataIdentifiers[0x0501] = "Version Applikationsmodell NV"
UDS_RDBI.dataIdentifiers[0x0502] = "Version FuMo Interface NV"
UDS_RDBI.dataIdentifiers[0x0503] = "Eingangssignale"
UDS_RDBI.dataIdentifiers[0x0504] = "Spiegelabklappung"
UDS_RDBI.dataIdentifiers[0x0505] = "FZV Zaehler"
UDS_RDBI.dataIdentifiers[0x0506] = "ZV Status aktuell"  	
UDS_RDBI.dataIdentifiers[0x0507] = "SwcDidaC TransportDp3Offset"
UDS_RDBI.dataIdentifiers[0x0509] = "FBS mobil Tuergriff Daten"
UDS_RDBI.dataIdentifiers[0x050a] = "SwcDidaC TransportCOM ActiveState Read"  	
UDS_RDBI.dataIdentifiers[0x050d] = "Read Stored EVC Configuration"
UDS_RDBI.dataIdentifiers[0x0510] = "Verzoegerungzeit Verriegelung ELV Verzoegerungzeit Verriegelung ELV"
UDS_RDBI.dataIdentifiers[0x0511] = "Keyless Data Set KDS"
UDS_RDBI.dataIdentifiers[0x0513] = "FBS mobil Tuergriff Konfiguration"
UDS_RDBI.dataIdentifiers[0x0514] = "UWB HF Konfiguration"
UDS_RDBI.dataIdentifiers[0x0520] = "LF Parameter Exterior Scan LI Write"  	
UDS_RDBI.dataIdentifiers[0x0521] = "LF Parameter Exterior Scan RE Read"  	
UDS_RDBI.dataIdentifiers[0x0522] = "LF Parameter Exterior Scan REAR Write"  	
UDS_RDBI.dataIdentifiers[0x0523] = "LF Parameter INTERIOR Scan 1 Read"  	
UDS_RDBI.dataIdentifiers[0x0524] = "LF Parameter INTERIOR Scan 2 Write"  	
UDS_RDBI.dataIdentifiers[0x0525] = "LF Parameter Reserve 1"
UDS_RDBI.dataIdentifiers[0x0526] = "LF Parameter Reserve 2"
UDS_RDBI.dataIdentifiers[0x0527] = "LF Parameter Reserve 3"
UDS_RDBI.dataIdentifiers[0x0528] = "LF Parameter Reserve 1"
UDS_RDBI.dataIdentifiers[0x0529] = "LF Parameter Reserve 5"
UDS_RDBI.dataIdentifiers[0x0530] = "0530 Audio Codec Status AD not powered up"
UDS_RDBI.dataIdentifiers[0x0531] = "Feldauswertung 1 FieldEvalHistFound 2"
UDS_RDBI.dataIdentifiers[0x0532] = "Feldauswertung 1 FieldEvalHistFound 3"
UDS_RDBI.dataIdentifiers[0x0533] = "DidAc DP1 Part4 1"
UDS_RDBI.dataIdentifiers[0x0534] = "Feldauswertung 1 FieldEvalHistFound 5"
UDS_RDBI.dataIdentifiers[0x0535] = "Feldauswertung 1 FieldEvalHistFound 6"
UDS_RDBI.dataIdentifiers[0x0536] = "Feldauswertung 1 FieldEvalHistFound 7"
UDS_RDBI.dataIdentifiers[0x0537] = "Feldauswertung 1 FieldEvalHistFound 8"
UDS_RDBI.dataIdentifiers[0x0538] = "Feldauswertung 1 FieldEvalHistFound 9"
UDS_RDBI.dataIdentifiers[0x0539] = "Feldauswertung 1 FieldEvalHistFound 10"
UDS_RDBI.dataIdentifiers[0x0540] = "Feldauswertung 2"
UDS_RDBI.dataIdentifiers[0x0541] = "Feldauswertung 2 2"
UDS_RDBI.dataIdentifiers[0x0542] = "Feldauswertung 2 3"
UDS_RDBI.dataIdentifiers[0x0543] = "Feldauswertung 2 4"
UDS_RDBI.dataIdentifiers[0x0544] = "Feldauswertung 2 5"
UDS_RDBI.dataIdentifiers[0x0545] = "Feldauswertung 2 6"
UDS_RDBI.dataIdentifiers[0x0546] = "Feldauswertung 2 7"
UDS_RDBI.dataIdentifiers[0x0547] = "Feldauswertung 2 8"
UDS_RDBI.dataIdentifiers[0x0548] = "Feldauswertung 2 9"
UDS_RDBI.dataIdentifiers[0x0549] = "Feldauswertung 2 10"
UDS_RDBI.dataIdentifiers[0x0550] = "Antennenmodul Daten"
UDS_RDBI.dataIdentifiers[0x0551] = "Softwarestand"
UDS_RDBI.dataIdentifiers[0x0560] = "Wiederholungen ueber Funk"
UDS_RDBI.dataIdentifiers[0x0561] = "Klassifizierung fuer KG Wiederholungen"
UDS_RDBI.dataIdentifiers[0x0562] = "Erstellung von Tuergriffprofilen"
UDS_RDBI.dataIdentifiers[0x0563] = "Anzahl Initialisierungen Funkempfaengers"
UDS_RDBI.dataIdentifiers[0x0564] = "Spielschutz"
UDS_RDBI.dataIdentifiers[0x0565] = "HFA Ausloesungen ohne ID Geber"
UDS_RDBI.dataIdentifiers[0x0566] = "Kombimeldung Schluesselbatterie wechseln"
UDS_RDBI.dataIdentifiers[0x0567] = "Resetcounter"  	 # or Program Flow Monitoring
UDS_RDBI.dataIdentifiers[0x0568] = "Daten des ID Gebers"
UDS_RDBI.dataIdentifiers[0x0569] = "SCN CfgByteList 01"
UDS_RDBI.dataIdentifiers[0x056f] = "SCN Parameter 2"
UDS_RDBI.dataIdentifiers[0x0570] = "LIN Modus Umschaltung"
UDS_RDBI.dataIdentifiers[0x0571] = "SCN Parameter 3"
UDS_RDBI.dataIdentifiers[0x0572] = "SCN Parameter 4"
UDS_RDBI.dataIdentifiers[0x0580] = "Datenblock EDS2 Bluetooth"
UDS_RDBI.dataIdentifiers[0x05f0] = "EOL VU2 WAKE STATI"
UDS_RDBI.dataIdentifiers[0x05f1] = "EOL VU2 Ausgabe ADC Werte"
UDS_RDBI.dataIdentifiers[0x0600] = "EZS Variantenkodierung Schluessel Dida"
UDS_RDBI.dataIdentifiers[0x0601] = "Ringpuffer Kommunikation KeylessGo"
UDS_RDBI.dataIdentifiers[0x0602] = "Ringpuffer Kommunikation ELV"
UDS_RDBI.dataIdentifiers[0x0603] = "Ringpuffer Kommunikation WMI"
UDS_RDBI.dataIdentifiers[0x0605] = "ECU Konfiguration II ELV"
UDS_RDBI.dataIdentifiers[0x0609] = "SwcDidaC TesterPresentHistory"
UDS_RDBI.dataIdentifiers[0x0650] = "BWM V2 Konfiguration VCD"
UDS_RDBI.dataIdentifiers[0x0651] = "BWM V2 Ereignisse Teil 1 Read Ereignisspeicher Teil"
UDS_RDBI.dataIdentifiers[0x0652] = "BWM V2 Ereignisse Teil 2 Read Ereignisspeicher Teil"
UDS_RDBI.dataIdentifiers[0x0653] = "BWM V2 Ereignisse Teil 3 Read Ereignisspeicher Teil"
UDS_RDBI.dataIdentifiers[0x0654] = "BWM V2 Ereignisse Teil 4 Read Ereignisspeicher Teil 4"
UDS_RDBI.dataIdentifiers[0x0655] = "BWM V2 Ueberwachungsphase"
UDS_RDBI.dataIdentifiers[0x0656] = "BWM V2 Fehlerdatenspeicher"
UDS_RDBI.dataIdentifiers[0x0657] = "BWM V2 Zaehler"
UDS_RDBI.dataIdentifiers[0x0700] = "RSE Konfiguration"
UDS_RDBI.dataIdentifiers[0x0701] = "Voltage Information Read"  	
UDS_RDBI.dataIdentifiers[0x0702] = "EKP Lauf"
UDS_RDBI.dataIdentifiers[0x0703] = "Sensor Information Read"  	
UDS_RDBI.dataIdentifiers[0x0704] = "SBC"
UDS_RDBI.dataIdentifiers[0x0706] = "Temperature Counter"
UDS_RDBI.dataIdentifiers[0x0707] = "Batteriespannung Read Response Parameters Batteriespannung"
UDS_RDBI.dataIdentifiers[0x0708] = "Zuendschluesselposition Read Response Parameters Zuendschluesselposition"  	
UDS_RDBI.dataIdentifiers[0x0709] = "Klemme 15 HW Read Response Parameters Klemme 15"
UDS_RDBI.dataIdentifiers[0x0710] = "FuelLowPress Sys Rq"
UDS_RDBI.dataIdentifiers[0x0711] = "EKP RUN Status Read Response Parameters EKP RUN"  	
UDS_RDBI.dataIdentifiers[0x0712] = "OFC Stat PT"
UDS_RDBI.dataIdentifiers[0x0713] = "Hebelgeber Widerstand primaer sekundaer"
UDS_RDBI.dataIdentifiers[0x0714] = "Kraftstofffuellstand Reserve"  	
UDS_RDBI.dataIdentifiers[0x0715] = "Kraftstoffmenge ungedaempft gesamt primaer sekundaer"
UDS_RDBI.dataIdentifiers[0x0716] = "Kraftstoffmenge gedaempft gesamt primaer sekundaer"
UDS_RDBI.dataIdentifiers[0x0717] = "Krafstoffmenge komplett gedaempft Read Krafstoffmenge komplett gedaempft"
UDS_RDBI.dataIdentifiers[0x0718] = "FuelLevel Stuck Status Read Response Parameters FuelLevel Stuck Status Secondary"  	
UDS_RDBI.dataIdentifiers[0x0719] = "Kraftstoffdruck Read Kraftstoffdruck"  	
UDS_RDBI.dataIdentifiers[0x0720] = "Kraftstoffdruck berechnet"
UDS_RDBI.dataIdentifiers[0x0721] = "Kraftstoffdruckvorgabe"
UDS_RDBI.dataIdentifiers[0x0722] = "Volumenstrom Vorgabe"
UDS_RDBI.dataIdentifiers[0x0723] = "Volumenstrom Kraftstoffpumpe berechnet"
UDS_RDBI.dataIdentifiers[0x0724] = "Volumenstrom Saugstrahlpumpe berechnet"
UDS_RDBI.dataIdentifiers[0x0725] = "Kraftstoffpumpendrehzahl Read Response Parameters Kraftstoffpumpendrehzahl"  	
UDS_RDBI.dataIdentifiers[0x0726] = "Kraftstoffpumpenspannung Read Response Parameters Kraftstoffpumpenspannung"  	
UDS_RDBI.dataIdentifiers[0x0727] = "Kraftstoffpumpenstrom effektiv"
UDS_RDBI.dataIdentifiers[0x0728] = "Kraftstoffpumpenstrom PhaseMax"
UDS_RDBI.dataIdentifiers[0x0729] = "Kraftstoffpumpendutycycle Read Response Parameters Kraftstoffpumpendutycycle"  	
UDS_RDBI.dataIdentifiers[0x0730] = "Kraftstoffethanolgehalt"
UDS_RDBI.dataIdentifiers[0x0731] = "Kraftstofftemperatur vom Drucksensor digital Read Kraftstofftemperatur vom Drucksensor digital"  	
UDS_RDBI.dataIdentifiers[0x0732] = "Steuergeraetetemperatur"  	
UDS_RDBI.dataIdentifiers[0x0733] = "SSP Failure Counter"
UDS_RDBI.dataIdentifiers[0x0734] = "Volume Lifetime Read Response Parameters Fuel Volume Lifetime"
UDS_RDBI.dataIdentifiers[0x0735] = "StDiagVolumeLastStuckConfirmedPrimary"
UDS_RDBI.dataIdentifiers[0x0736] = "StDiagVolumeLastStuckConfirmedSecondary"
UDS_RDBI.dataIdentifiers[0x0737] = "Tank Level Max and Active characteristic Read Response Parameters Tank Level Max"
UDS_RDBI.dataIdentifiers[0x0738] = "CAN FuelPress In"
UDS_RDBI.dataIdentifiers[0x0739] = "FD PredFuelPressAdaptedSignal"
UDS_RDBI.dataIdentifiers[0x0750] = "SPA Parameter"
UDS_RDBI.dataIdentifiers[0x0770] = "MCC Konfiguration"
UDS_RDBI.dataIdentifiers[0x0780] = "SCAS Konfiguration"
UDS_RDBI.dataIdentifiers[0x0781] = "Wake up puls configuration"
UDS_RDBI.dataIdentifiers[0x0782] = "Autonegotiation configuration"
UDS_RDBI.dataIdentifiers[0x0800] = "Actual E Stand"  	 # or Secure Odometer Zustaende, Release Version TCU Core PRES E Stand ASCII type 20Byte, Release Version TCU Core
UDS_RDBI.dataIdentifiers[0x0801] = "Secure Odometer"
UDS_RDBI.dataIdentifiers[0x0802] = "Secure Odometer Kilometerstand"
UDS_RDBI.dataIdentifiers[0x0900] = "VTA HW Eingaenge"
UDS_RDBI.dataIdentifiers[0x0901] = "VTA Schalterzustand"
UDS_RDBI.dataIdentifiers[0x0902] = "VTA Schalterspeicher"
UDS_RDBI.dataIdentifiers[0x0903] = "VTA Schaltermodell"
UDS_RDBI.dataIdentifiers[0x0904] = "VTA Type Parameter"
UDS_RDBI.dataIdentifiers[0x0905] = "VTA Alarmhistorie"
UDS_RDBI.dataIdentifiers[0x0906] = "VTA Ueberwachungszustand"
UDS_RDBI.dataIdentifiers[0x0907] = "VTA Zaehlerstand Alarmrecycling"
UDS_RDBI.dataIdentifiers[0x0908] = "VTA Alarmtzustand"
UDS_RDBI.dataIdentifiers[0x0909] = "VTA Zustandsgroessen"
UDS_RDBI.dataIdentifiers[0x090a] = "VTA Country Parameter"
UDS_RDBI.dataIdentifiers[0x090b] = "VTA Schalterfreigabe"
UDS_RDBI.dataIdentifiers[0x090c] = "VTA Vehicle Type"
UDS_RDBI.dataIdentifiers[0x0a20] = "High Resolution DisCharge"
UDS_RDBI.dataIdentifiers[0x0a21] = "High Resolution Charge"
UDS_RDBI.dataIdentifiers[0x0e63] = "Fensterhochlaufbewertung"
UDS_RDBI.dataIdentifiers[0x0e70] = "Fensterreversierer Trace"
UDS_RDBI.dataIdentifiers[0x0e71] = "Fensterreversierer Trace"
UDS_RDBI.dataIdentifiers[0x0e72] = "Fensterreversierer Trace"
UDS_RDBI.dataIdentifiers[0x0e73] = "Fensterreversierer Trace 4"
UDS_RDBI.dataIdentifiers[0x0e74] = "Fensterreversierer Trace 5"
UDS_RDBI.dataIdentifiers[0x0e75] = "Fensterreversierer Trace 6"
UDS_RDBI.dataIdentifiers[0x0e76] = "Fensterreversierer Trace 7"
UDS_RDBI.dataIdentifiers[0x0e77] = "Fensterreversierer Trace 8"
UDS_RDBI.dataIdentifiers[0x1002] = "Batteriesensor"  	 # or Erase all Production data, Learned drive positions
UDS_RDBI.dataIdentifiers[0x1003] = "Spannungs und Stromwerte"  	 # or Geschwindigkeitsprofil Oeffnen
UDS_RDBI.dataIdentifiers[0x1004] = "CVN Berechnung"  	 # or CVN Berechnung fertig, Stopp Start, PRND Movement Counter / P in emergency counter
UDS_RDBI.dataIdentifiers[0x1005] = "Restladestrombewertung"  	 # or FIN Neuschreiben ist verriegelt, Regelparameter Oeffnen P-Anteil, Betriebszeit
UDS_RDBI.dataIdentifiers[0x1006] = "Module limits and position factors"  	 # or Vernetzungsvariante, VIN Schreiben verriegelt
UDS_RDBI.dataIdentifiers[0x1007] = "Regelparameter Oeffnen I-Anteil"  	 # or Kommunikationsvariante, 12V Systemabbild
UDS_RDBI.dataIdentifiers[0x1008] = "12V Li Systemabbild"  	 # or Regelparameter Schliessen P-Anteil
UDS_RDBI.dataIdentifiers[0x1009] = "Regelparameter Schliessen I-Anteil"
UDS_RDBI.dataIdentifiers[0x100a] = "Darkzones"  	 # or Model Version
UDS_RDBI.dataIdentifiers[0x100b] = "Blockiertoleranzen"
UDS_RDBI.dataIdentifiers[0x100c] = "Normierparameter VC"
UDS_RDBI.dataIdentifiers[0x100d] = "Allgemeine Funktionsparameter VC"
UDS_RDBI.dataIdentifiers[0x100e] = "Seriennummer MFT Test"
UDS_RDBI.dataIdentifiers[0x100f] = "Kontrollschalter 1 VC"
UDS_RDBI.dataIdentifiers[0x1010] = "Regelparameter Ausgangsumrechnung"
UDS_RDBI.dataIdentifiers[0x1011] = "Allgemeine Zustandsinformationen"
UDS_RDBI.dataIdentifiers[0x1012] = "AMS Sensor Diagnose Data"
UDS_RDBI.dataIdentifiers[0x1013] = "Kontrollschalter 4 VC"
UDS_RDBI.dataIdentifiers[0x1014] = "Stillstandserkennung"
UDS_RDBI.dataIdentifiers[0x1020] = "CALID OBCH"
UDS_RDBI.dataIdentifiers[0x1021] = "CALID HVAC"
UDS_RDBI.dataIdentifiers[0x1022] = "CALID DCDC48"
UDS_RDBI.dataIdentifiers[0x1023] = "CALID LISB48"
UDS_RDBI.dataIdentifiers[0x1024] = "CALID DCB READ"
UDS_RDBI.dataIdentifiers[0x102d] = "Warntongeber"
UDS_RDBI.dataIdentifiers[0x102e] = "Kontrollschalter"
UDS_RDBI.dataIdentifiers[0x102f] = "Kontrollschalter"
UDS_RDBI.dataIdentifiers[0x1030] = "CVN OBCH"
UDS_RDBI.dataIdentifiers[0x1031] = "CVN HVAC"
UDS_RDBI.dataIdentifiers[0x1032] = "CVN DCDC48"
UDS_RDBI.dataIdentifiers[0x1033] = "CVN LISB48"
UDS_RDBI.dataIdentifiers[0x1034] = "CVN DCB READ"
UDS_RDBI.dataIdentifiers[0x1050] = "PNDS Counter"
UDS_RDBI.dataIdentifiers[0x1051] = "IOD CurrRead"
UDS_RDBI.dataIdentifiers[0x1052] = "BatChangeRead"
UDS_RDBI.dataIdentifiers[0x1053] = "BSBFltRead"
UDS_RDBI.dataIdentifiers[0x1054] = "ChargeBalance"
UDS_RDBI.dataIdentifiers[0x1055] = "DDP"
UDS_RDBI.dataIdentifiers[0x1056] = "Prod TraMode State"
UDS_RDBI.dataIdentifiers[0x1058] = "CurrentTrace"
UDS_RDBI.dataIdentifiers[0x1059] = "CycleLog"
UDS_RDBI.dataIdentifiers[0x105a] = "CycleLog Additional"
UDS_RDBI.dataIdentifiers[0x105b] = "PNDS WarmData"
UDS_RDBI.dataIdentifiers[0x105c] = "PNDS ColdData"
UDS_RDBI.dataIdentifiers[0x1080] = "OMC Parameters"
UDS_RDBI.dataIdentifiers[0x1081] = "BCM Parameters"
UDS_RDBI.dataIdentifiers[0x1082] = "BCD Parameters"
UDS_RDBI.dataIdentifiers[0x1083] = "BSI Parameters"
UDS_RDBI.dataIdentifiers[0x1084] = "BSB Parameters"
UDS_RDBI.dataIdentifiers[0x1085] = "ICC Parameters"
UDS_RDBI.dataIdentifiers[0x1086] = "SSM Parameters"
UDS_RDBI.dataIdentifiers[0x1087] = "DDP Parameters"
UDS_RDBI.dataIdentifiers[0x1088] = "FOTA Parameters"
UDS_RDBI.dataIdentifiers[0x1089] = "DLM Parameters"
UDS_RDBI.dataIdentifiers[0x108a] = "Prod and Service Parameters"
UDS_RDBI.dataIdentifiers[0x108b] = "PNDS Parameters"
UDS_RDBI.dataIdentifiers[0x108c] = "ISP Parameters"
UDS_RDBI.dataIdentifiers[0x108d] = "OSP Parameters"
UDS_RDBI.dataIdentifiers[0x108e] = "HW Parameters"
UDS_RDBI.dataIdentifiers[0x1100] = "Progammstandskennung Build"
UDS_RDBI.dataIdentifiers[0x1101] = "uBN TrackingRegister BE Block"
UDS_RDBI.dataIdentifiers[0x1102] = "uBN TrackingRegister BE Block"
UDS_RDBI.dataIdentifiers[0x1103] = "uBN TrackingRegister BE Block 4"
UDS_RDBI.dataIdentifiers[0x1104] = "uBN TrackingRegister BE Block 5"
UDS_RDBI.dataIdentifiers[0x1110] = "uBN TrackingRegister MonPhase"
UDS_RDBI.dataIdentifiers[0x1120] = "uBN Error Data Register"
UDS_RDBI.dataIdentifiers[0x1122] = "HV Bus Open Fault Enabler"
UDS_RDBI.dataIdentifiers[0x1123] = "Manufacturing Boost Mode Enable Command DCX"
UDS_RDBI.dataIdentifiers[0x1124] = "Boost Mode Enable Failure History DCX"  	 # or Hybrid Battery Pump Control Enable"
UDS_RDBI.dataIdentifiers[0x1125] = "Operation Mode DCX"
UDS_RDBI.dataIdentifiers[0x1130] = "uBN Konfiguration VCD"
UDS_RDBI.dataIdentifiers[0x1131] = "uBN Zaehler"
UDS_RDBI.dataIdentifiers[0x1141] = "Run/Crank Voltage"
UDS_RDBI.dataIdentifiers[0x11a1] = "Engine Run Time"
UDS_RDBI.dataIdentifiers[0x1200] = "Oeldatensatz Grunddaten"
UDS_RDBI.dataIdentifiers[0x1201] = "Oeldatensatz Grunddaten 2"
UDS_RDBI.dataIdentifiers[0x1202] = "Oeldatensatz Warnung"
UDS_RDBI.dataIdentifiers[0x1203] = "Oeldatensatz Warnung 2"
UDS_RDBI.dataIdentifiers[0x1204] = "Oeldatensatz Oelstandsabfrage"
UDS_RDBI.dataIdentifiers[0x1205] = "Oeldatensatz Nachfuellerkennung"
UDS_RDBI.dataIdentifiers[0x1206] = "Oeldatensatz variabel"
UDS_RDBI.dataIdentifiers[0x1232] = "Emissions Warm-Up Counter"
UDS_RDBI.dataIdentifiers[0x1233] = "Non Emissions Warm-Up Counter"
UDS_RDBI.dataIdentifiers[0x1234] = "Mileage Distance Since Code Clear 2Byte"
UDS_RDBI.dataIdentifiers[0x12de] = "Main Processor Reset Source"
UDS_RDBI.dataIdentifiers[0x12e7] = "Main Processor Running Reset Source Address"
UDS_RDBI.dataIdentifiers[0x1940] = "Transmission Oil Temperature"
UDS_RDBI.dataIdentifiers[0x1942] = "Transmission Output Speed"
UDS_RDBI.dataIdentifiers[0x194f] = "Transmission PRND Range"
UDS_RDBI.dataIdentifiers[0x1951] = "Transmission Range Input"
UDS_RDBI.dataIdentifiers[0x195d] = "Transfer Case Ratio"
UDS_RDBI.dataIdentifiers[0x197e] = "Transmission Tap Up/Down"
UDS_RDBI.dataIdentifiers[0x19a1] = "Transmission Gear Ratio"
UDS_RDBI.dataIdentifiers[0x1a22] = "Cumulative Charge AmpHours"
UDS_RDBI.dataIdentifiers[0x1a23] = "Cumulative DisCharge AmpHours"
UDS_RDBI.dataIdentifiers[0x1a2d] = "Engine Actual Steady State Torque"
UDS_RDBI.dataIdentifiers[0x1a31] = "LifeTime Number Of Opens"
UDS_RDBI.dataIdentifiers[0x1a32] = "LifeTime Number Of Closes"
UDS_RDBI.dataIdentifiers[0x1a33] = "LifeTime Number Of Opens Under Load"
UDS_RDBI.dataIdentifiers[0x1a34] = "LifeTime Number Of Impending Opens"
UDS_RDBI.dataIdentifiers[0x1a35] = "LifeTime Number Of Open Requests"
UDS_RDBI.dataIdentifiers[0x1a36] = "LifeTime Number of loss 12V"
UDS_RDBI.dataIdentifiers[0x1a37] = "LifeTime Number of PreCharge"
UDS_RDBI.dataIdentifiers[0x1a9c] = "Engineering Software number"
UDS_RDBI.dataIdentifiers[0x1a9d] = "Vehicle Kilometers"
UDS_RDBI.dataIdentifiers[0x1a9f] = "Shipped Packs"
UDS_RDBI.dataIdentifiers[0x1b01] = "HV SOC History"
UDS_RDBI.dataIdentifiers[0x1b02] = "HV SOC History"
UDS_RDBI.dataIdentifiers[0x1b03] = "HV SOC History"
UDS_RDBI.dataIdentifiers[0x1b04] = "HV SOC History 4"
UDS_RDBI.dataIdentifiers[0x1b05] = "HV SOC History 5"
UDS_RDBI.dataIdentifiers[0x1b06] = "HV SOC Time Stats"
UDS_RDBI.dataIdentifiers[0x1b07] = "HV Voltage Time Stats"
UDS_RDBI.dataIdentifiers[0x1b08] = "HV Temperature Time Stats"
UDS_RDBI.dataIdentifiers[0x1b09] = "HV Battery Voltage Exceeded"
UDS_RDBI.dataIdentifiers[0x1b11] = "HV Module Volt Differentials Time Stats"
UDS_RDBI.dataIdentifiers[0x1b12] = "HV Module Temperature Differentials Time Stats"
UDS_RDBI.dataIdentifiers[0x1b14] = "HV SOC History 0"
UDS_RDBI.dataIdentifiers[0x1b15] = "HV Coolant Temperature Differentials Time Stats"
UDS_RDBI.dataIdentifiers[0x1b16] = "HV Current Time Stats"
UDS_RDBI.dataIdentifiers[0x1b17] = "Resistance Histogram"
UDS_RDBI.dataIdentifiers[0x1c20] = "Low Voltage Circuit Temperature"
UDS_RDBI.dataIdentifiers[0x1c23] = "APM Heat Plate Temperature"
UDS_RDBI.dataIdentifiers[0x1c24] = "HCP High Voltage Circuit Voltage"
UDS_RDBI.dataIdentifiers[0x1c25] = "APM High Voltage Circuit Current"
UDS_RDBI.dataIdentifiers[0x1c26] = "MCPA IGBT Module Temperature"
UDS_RDBI.dataIdentifiers[0x1c27] = "MCPB IGBT Module Temperature"
UDS_RDBI.dataIdentifiers[0x1c28] = "MCPA IGBT Module Temperature"
UDS_RDBI.dataIdentifiers[0x1c29] = "MCPB IGBT Module Temperature"
UDS_RDBI.dataIdentifiers[0x1c2a] = "MCPA IGBT Module Temperature"
UDS_RDBI.dataIdentifiers[0x1c2b] = "MCPB IGBT Module Temperature"
UDS_RDBI.dataIdentifiers[0x1c2c] = "Low Voltage Circuit"
UDS_RDBI.dataIdentifiers[0x1c2e] = "High Voltage"
UDS_RDBI.dataIdentifiers[0x1c2f] = "Maximum Hybrid Battery Module Voltage"
UDS_RDBI.dataIdentifiers[0x1c30] = "Minimum Hybrid Battery Module Voltage"
UDS_RDBI.dataIdentifiers[0x1c31] = "APM Power Loss"
UDS_RDBI.dataIdentifiers[0x1c32] = "Contactor Commanded PWM"
UDS_RDBI.dataIdentifiers[0x1c36] = "Low Voltage Circuit Current"
UDS_RDBI.dataIdentifiers[0x1c37] = "Low Voltage Circuit Voltage"
UDS_RDBI.dataIdentifiers[0x1c38] = "Voltage Output Set Point Duty Cycle Command"
UDS_RDBI.dataIdentifiers[0x1c39] = "Accessory Power Module Functional"
UDS_RDBI.dataIdentifiers[0x1c45] = "Motor A Mid-Pack Voltage"
UDS_RDBI.dataIdentifiers[0x1c46] = "Motor B Mid-Pack Voltage"  	
UDS_RDBI.dataIdentifiers[0x1ce0] = "Rate Limiter Configuration"
UDS_RDBI.dataIdentifiers[0x1f01] = "Mesurement ID Control"
UDS_RDBI.dataIdentifiers[0x1f02] = "Enable/Disable ALS"
UDS_RDBI.dataIdentifiers[0x1f04] = "Variant coding - actual status"
UDS_RDBI.dataIdentifiers[0x1f08] = "Variant coding - Compatible variants"
UDS_RDBI.dataIdentifiers[0x1fb1] = "KG Versorgungsspannung Ist Wert Versorgungsspannung"  	
UDS_RDBI.dataIdentifiers[0x1fc0] = "KG Geraeteparameter"  	
UDS_RDBI.dataIdentifiers[0x1fc1] = "Status Tuer"  	
UDS_RDBI.dataIdentifiers[0x1fc2] = "KG Diagnosespannung HF Ausgang Spannung Diagnoseeingang HF"
UDS_RDBI.dataIdentifiers[0x1fd0] = "Eingangssignale Read"  	
UDS_RDBI.dataIdentifiers[0x1fd1] = "Tuergrifftelegramme"  	
UDS_RDBI.dataIdentifiers[0x1fd2] = "KG aktuelle LF Parameter lesen Ortungsfeld hinten"  	 # or KG FZV Zaehler Zaehler, FZV Zaehler Read Response Parameters Zaehler
UDS_RDBI.dataIdentifiers[0x1fd3] = "Batteriespannung Schluessel Read Batteriespannung Schluessel"
UDS_RDBI.dataIdentifiers[0x2000] = "Motordrehzahl Eng Spd"  	
UDS_RDBI.dataIdentifiers[0x2001] = "Read Stored Switch States"
UDS_RDBI.dataIdentifiers[0x2002] = "Read Actual Switch States"  	 # or Kraftstoffmenge rechts, Registration Status Registration Error
UDS_RDBI.dataIdentifiers[0x2003] = "Vehicle speed"  	 # or Vehicle speed Read Vehicle speed, Kraftstoffmenge links
UDS_RDBI.dataIdentifiers[0x2004] = "Certificate Status Certificate"  	 # or Compatibility, Estimated effective engine torque
UDS_RDBI.dataIdentifiers[0x2005] = "voltage Read Battery voltage"  	 # or Geber Nockenwelle Signal Einlass, Signal Strength BT WiFi BT Signal Strength
UDS_RDBI.dataIdentifiers[0x2006] = "Klopfsensor"  	 # or Klemme87 Rueckmeldeleitung, BT Address BT Adress, Klopfsensor - Klopfen erkannt
UDS_RDBI.dataIdentifiers[0x2007] = "Oil temperature engine Read Oil temperature engine"  	 # or Oil temperature engine, Massentrom aus HFM
UDS_RDBI.dataIdentifiers[0x2008] = "temperature"  	 # or temperature Read Fuel temperature, Spannung O2-Regelsonde Bank 2 Rohwert, TCU Inputs Battery Voltage
UDS_RDBI.dataIdentifiers[0x2009] = "TCU Output ECall LED"  	 # or Atmospheric pressure, Spannung O2-Regelsonde Bank 1 Rohwert
UDS_RDBI.dataIdentifiers[0x200b] = "Accelerator pedal voltage track"
UDS_RDBI.dataIdentifiers[0x200c] = "Cellular Network Signal Information Cell ID"
UDS_RDBI.dataIdentifiers[0x200d] = "TCU Environmental Information Ignition State"  	 # or Pedalwertgeber Versorgungsspannung gesamt, Freon pressure sensor voltage
UDS_RDBI.dataIdentifiers[0x200e] = "WiFi MAC Address Address"  	 # or Key state Read Key state, Pedalwertgeber 1 Sent Counts, Key state
UDS_RDBI.dataIdentifiers[0x200f] = "Pedalwertgeber 2 Sent Counts"  	 # or HU Connectivity Status BT Connection, Brake pedal switches consolidation state
UDS_RDBI.dataIdentifiers[0x2010] = "Engine status Read Engine status"  	 # or Spannung O2-Diagnosesonde Bank 2 Rohwert, SIM Profile Active Profile, Engine status
UDS_RDBI.dataIdentifiers[0x2011] = "BT Address HU"  	 # or Kuehlmitteltemperatur korrigiert, BT Address HU BT Adress
UDS_RDBI.dataIdentifiers[0x2012] = "Pedalwertgeber Versorgungsspannung"  	 # or Spannung O2-Diagnosesonde Bank 1 Rohwert, Sonde Rechts Nach KAT ROH, Atmospheric pressure sensor voltage
UDS_RDBI.dataIdentifiers[0x2013] = "Pedalwertgeber"
UDS_RDBI.dataIdentifiers[0x2014] = "Gangsensor SG Horizontal ROH"  	 # or Camshaft crankshaft synchronization state, Ansauglufttemperatur in HFM bzw. vor DK, Ansauglufttemperatur
UDS_RDBI.dataIdentifiers[0x2015] = "Gangsensor SG Horizontal"
UDS_RDBI.dataIdentifiers[0x2016] = "Gangsensor SG Vertikal"  	 # or Crankshaft synchronization state, Cellular Antenna Switch Status, Cellular Antenna Switch Status Antenna Active
UDS_RDBI.dataIdentifiers[0x2017] = "PremAirkuehlertemperatur"  	 # or Gangsensor SG Fahrstufe
UDS_RDBI.dataIdentifiers[0x2018] = "Cellular Network Numbers MSISDN MDN PRES MSISDN type ASCII 15 byte"  	 # or Cellular Network Numbers EUICC PRES EUICC type ASCII32Byte, Cellular Network Numbers IMSI MIN PRES IMSI type ASCII 15byte, Cellular Network Numbers EUICC, Cellular Network Numbers ICCID PRES ICCID type ASCII22Byte, Cellular Network Numbers IMEI MEID PRES IMEI type ASCII 16Byte
UDS_RDBI.dataIdentifiers[0x2019] = "Tankdruckdifferenz"  	 # or Kupplungspedalsensor
UDS_RDBI.dataIdentifiers[0x201a] = "Kupplungspedalsensor Weg"  	 # or Batteriespannung BATZ, Operating Mode, Operating Mode Operating
UDS_RDBI.dataIdentifiers[0x201b] = "Panic Alarm Configuration PAN MIN INTERMESSAGE TIME"
UDS_RDBI.dataIdentifiers[0x201c] = "Monitool Supervisor status"  	 # or Power Mode Timers DNO Intended Reset, Power Mode Timers, Ansauglufttemperatur im Saugrohr
UDS_RDBI.dataIdentifiers[0x201d] = "Thermoplungers command state"  	 # or Ansauglufttemperatur im Saugrohr Roh, GNSS Position Data DR DateYear
UDS_RDBI.dataIdentifiers[0x201e] = "Air conditioning state"  	 # or Remote Update Setting maxSWDLLmaxIgnitionOffDuration, Tankdruckdifferenz bei DMTL, Remote Update Setting
UDS_RDBI.dataIdentifiers[0x201f] = "Ansauglufttemperatur korrigiert"  	 # or Speed Alert, Speed Alert Notification Interval
UDS_RDBI.dataIdentifiers[0x2020] = "VTA Mature Time atnAlarmThreshold"  	 # or VTA Mature Time, 2021 2040
UDS_RDBI.dataIdentifiers[0x2021] = "Ansauglufttemperatur in HFM bzw. vor DK Rohwert"
UDS_RDBI.dataIdentifiers[0x2022] = "Batteriespannung ROH ADC Value"  	 # or Read Time of Last Reconcilliation Date of Last Reconciliation day
UDS_RDBI.dataIdentifiers[0x2023] = "Kuehlmitteltemperatur ROH"  	 # or Service Provider Reconciliation, Service Provider Reconciliation Date of Last Reconciliation day
UDS_RDBI.dataIdentifiers[0x2024] = "Idle engine speed setpoint"  	 # or Service Provisioning Authorization State Adapt Authorization, Chiller Temperatur ROH, Service Provisioning Authorization State
UDS_RDBI.dataIdentifiers[0x2025] = "GNSS Time Epoch"  	 # or Brake pedal close active switch state, GNSS Time Epoch Value, Chiller Temperatur, Pedalwertgeber Potentiometer 1 Rohwert
UDS_RDBI.dataIdentifiers[0x2026] = "Brake pedal open active switch state"  	 # or Kuehlmitteltemperatur NT2 Batterie Plugin Hybrid ROH, Cellular Network Current Provider Name Name, Pedalwertgeber Potentiometer 2 Rohwert
UDS_RDBI.dataIdentifiers[0x2027] = "Clutch pedal minimum travel switch state CAN"  	 # or Kuehlmitteltemperatur NT2 Batterie Plugin Hybrid, Saugrohrdruck Rohwert, Saugrohrdruck ROH, Cellular Network Home Provider Name Name
UDS_RDBI.dataIdentifiers[0x2028] = "Tankdruckdifferenz Rohwert"  	 # or Tankdruckdifferenz ROH, Kuehlertemperatur PremAir, MIL lamp request state, LU Part Number Part Number
UDS_RDBI.dataIdentifiers[0x2029] = "Chiller Druck ROH"  	 # or Cellular Network Visible Neighbor Cell Stations Mobile Country Code Nr, Pedalwertgeberstellung
UDS_RDBI.dataIdentifiers[0x202a] = "Chiller Druck"  	 # or Regenerierleitung Druck ROH
UDS_RDBI.dataIdentifiers[0x202b] = "Kuehlertemperatur PremAir SignalQualifier"  	 # or Regenerierleitung Druck
UDS_RDBI.dataIdentifiers[0x202c] = "Chiller Druck ungefiltert"
UDS_RDBI.dataIdentifiers[0x202d] = "Protected state"
UDS_RDBI.dataIdentifiers[0x202e] = "Accelerator pedal position"
UDS_RDBI.dataIdentifiers[0x2030] = "Intake camshaft phaser position setpoint"  	 # or Kuehlmittellevel Niedertemperatur Kreislauf ROH, TCU Internal SW Versions Application NAD
UDS_RDBI.dataIdentifiers[0x2031] = "Kraftstofftemperatur im Tank Rohwert"  	 # or Intake camshaft phaser position
UDS_RDBI.dataIdentifiers[0x2032] = "Secure Mode Debug Interface"  	 # or Intake camshaft phaser position bank, Kraftstofftemperatur im Tank, Tanktemperatur
UDS_RDBI.dataIdentifiers[0x2033] = "Main Processor NVM Fault"  	 # or Intake camshaft phaser PWM command, Secure Mode Get ID Identification Data
UDS_RDBI.dataIdentifiers[0x2034] = "Main Processor RAM Fault Source Address"  	 # or Intake camshaft phaser PWM command bank, Set Secure Mode
UDS_RDBI.dataIdentifiers[0x2035] = "Force Network Generation"  	 # or Force Network Generation Used Network, CCSL Cruise control speed setpoint, Processor ROM Fault Source Address
UDS_RDBI.dataIdentifiers[0x2036] = "Sonde Innenwiderstand Rechts Vor Kat"  	 # or Counter of inconsistencies between accelerator pedal and brake, Innenwiderstand Lambdasonde Bank 1 vor Kat
UDS_RDBI.dataIdentifiers[0x2037] = "Steuergeraete Innentemperatur Rohwert"  	 # or Engine torque without gearbox request
UDS_RDBI.dataIdentifiers[0x2038] = "Steuergeraete Innentemperatur"
UDS_RDBI.dataIdentifiers[0x2039] = "Umgebungsdruck Rohwert"  	 # or CCSL Steering wheel push buttons voltage
UDS_RDBI.dataIdentifiers[0x203a] = "Configuration Cruise control option"
UDS_RDBI.dataIdentifiers[0x203b] = "Configuration Cruise control On Off button"
UDS_RDBI.dataIdentifiers[0x203c] = "Cruise control On Off button state"
UDS_RDBI.dataIdentifiers[0x203d] = "Configuration Speed limiter option"
UDS_RDBI.dataIdentifiers[0x203e] = "Configuration Speed limiter On Off button"
UDS_RDBI.dataIdentifiers[0x203f] = "Speed limiter On Off button state"
UDS_RDBI.dataIdentifiers[0x2040] = "2041 2060"
UDS_RDBI.dataIdentifiers[0x2041] = "Pedalwertgeber 50% der Versorgungsspannung"  	 # or Pedalwertgeber halbe Versorgungsspannung, Spannungsversorgung Sensorik, Configuration CCSL steering wheel push buttons
UDS_RDBI.dataIdentifiers[0x2042] = "Configuration Air conditioning control unit"  	 # or Abgasklappe Temperatur
UDS_RDBI.dataIdentifiers[0x2043] = "Ladelufttemperatur"  	 # or Configuration Freon pressure sensor
UDS_RDBI.dataIdentifiers[0x2044] = "Ladeluft Solltemperatur"  	 # or Periodendauer Korrektursignal HFM, Powertrain setpoint
UDS_RDBI.dataIdentifiers[0x2045] = "Offset-Spannung Drucksensor Saugrohr"  	 # or Kuelkreislauf HV Temperatur NT2, Clutch pedal maximum travel switch state
UDS_RDBI.dataIdentifiers[0x2046] = "Sonde Vor Kat Lambda"  	 # or Kuehlkreislauf2 Niedertemperatur BMS ROH
UDS_RDBI.dataIdentifiers[0x2047] = "Chiller Temperatur Gradient"
UDS_RDBI.dataIdentifiers[0x2048] = "Cranking autorisation status"  	 # or Temperatur Median Kaltstart
UDS_RDBI.dataIdentifiers[0x2049] = "ADC-Spannung Lambdasonde hinter Kat rechte"  	 # or Sonde ADC Spannung Rechts Nach Kat
UDS_RDBI.dataIdentifiers[0x204a] = "Motor fans requests"  	 # or Main Processor Total Running Resets
UDS_RDBI.dataIdentifiers[0x204b] = "CCSL Steering wheel push buttons state"  	 # or Main Processor Maximum Running Resets Between Power-up Resets
UDS_RDBI.dataIdentifiers[0x204c] = "Sonde Nach Kat Innenwiderstand"  	 # or CCSL
UDS_RDBI.dataIdentifiers[0x204d] = "CCSL State of the failures which cause irreversible CC safety failure"
UDS_RDBI.dataIdentifiers[0x204e] = "CCSL State of the reversible failures not due to CCSL which cause CCSL failure"  	 # or Sonde Vor Kat Heizungsspannung
UDS_RDBI.dataIdentifiers[0x204f] = "CCSL State of the reversible failures not due to CC which cause CC failure"
UDS_RDBI.dataIdentifiers[0x2050] = "Displayed vehicle speed received on the CAN network"
UDS_RDBI.dataIdentifiers[0x2051] = "Displayed vehicle speed unit"
UDS_RDBI.dataIdentifiers[0x2053] = "ADC-Spannung Ansauglufttemperatur"
UDS_RDBI.dataIdentifiers[0x2057] = "Alternator power Read Alternator power"
UDS_RDBI.dataIdentifiers[0x2059] = "Clutch pedal minimum travel switch state wire"
UDS_RDBI.dataIdentifiers[0x205a] = "Idle engine speed regulation status"
UDS_RDBI.dataIdentifiers[0x205b] = "Limp home activation state"
UDS_RDBI.dataIdentifiers[0x205c] = "OBD readiness codes status"
UDS_RDBI.dataIdentifiers[0x205d] = "No driver request state pedal CCSL"
UDS_RDBI.dataIdentifiers[0x205f] = "Requested idle speed setpoint for LCV s accessories"
UDS_RDBI.dataIdentifiers[0x2060] = "2061 2080"
UDS_RDBI.dataIdentifiers[0x2061] = "Effective engine torque target requested by real pedal and virtual ACC CC SL drivers"  	 # or Temperatursensor Niedertemperatur Kreislauf Rohwert
UDS_RDBI.dataIdentifiers[0x2062] = "ADC-Spannung Lambdasonde hinter Kat linke"  	 # or Effective engine torque setpoint requested by real pedal and virtual ACC CC SL drivers
UDS_RDBI.dataIdentifiers[0x2063] = "Minimum engine torque"  	 # or Temperatursensor Niedertemperatur Kreislauf
UDS_RDBI.dataIdentifiers[0x2064] = "Maximum engine torque"
UDS_RDBI.dataIdentifiers[0x2065] = "Maximum engine torque with dynamic limitations"
UDS_RDBI.dataIdentifiers[0x2066] = "Engine torque losses"
UDS_RDBI.dataIdentifiers[0x2067] = "Final indicated torque raw"
UDS_RDBI.dataIdentifiers[0x2068] = "Final indicated torque target"
UDS_RDBI.dataIdentifiers[0x2069] = "Final indicated torque setpoint"
UDS_RDBI.dataIdentifiers[0x206a] = "Brake pedal duration of the close active switch blocked"
UDS_RDBI.dataIdentifiers[0x206b] = "Brake pedal duration of the open active switch blocked"
UDS_RDBI.dataIdentifiers[0x206d] = "Configuration Clutch pedal minimum travel switch"
UDS_RDBI.dataIdentifiers[0x206e] = "Configuration Brake pedal open active switch"
UDS_RDBI.dataIdentifiers[0x206f] = "Synthesis of engine stop requests"
UDS_RDBI.dataIdentifiers[0x2070] = "Immobilizer diagnosis availability"
UDS_RDBI.dataIdentifiers[0x2071] = "Immobilizer Byte 1 used to allow diagnosis"
UDS_RDBI.dataIdentifiers[0x2072] = "Immobilizer Byte 2 used to allow diagnosis"
UDS_RDBI.dataIdentifiers[0x2073] = "Immobilizer Byte 3 used to allow diagnosis"  	 # or Kraftstofftemperatur Niederdruck
UDS_RDBI.dataIdentifiers[0x2074] = "Immobilizer engine not running due to ECM"
UDS_RDBI.dataIdentifiers[0x2075] = "Immobilizer engine not running due to BCM in secure mode"
UDS_RDBI.dataIdentifiers[0x2076] = "Ladedruck ROH"  	 # or Immobilizer engine not running due to no BCM authorization
UDS_RDBI.dataIdentifiers[0x2077] = "Ladedruck"  	 # or Immobilizer engine not running due to a CAN network problem with the BCM
UDS_RDBI.dataIdentifiers[0x2078] = "CCSL State of the causes for normal CCSL deactivation"
UDS_RDBI.dataIdentifiers[0x2079] = "CCSL State of the system causes for normal CCSL deactivation"
UDS_RDBI.dataIdentifiers[0x207a] = "Ladedruck korrigiert"  	 # or Maximum duration of resume button pressed
UDS_RDBI.dataIdentifiers[0x207b] = "Maximum duration of set button pressed"
UDS_RDBI.dataIdentifiers[0x207c] = "Maximum duration of set button pressed"
UDS_RDBI.dataIdentifiers[0x207d] = "Maximum duration of suspend button pressed"
UDS_RDBI.dataIdentifiers[0x207e] = "Maximum value of blocked button detection counter"
UDS_RDBI.dataIdentifiers[0x207f] = "Starter fault"
UDS_RDBI.dataIdentifiers[0x2080] = "2081 20A0"
UDS_RDBI.dataIdentifiers[0x2081] = "Configuration AGB automatic gearbox"
UDS_RDBI.dataIdentifiers[0x2082] = "Sondenheizung Nach Kat angesteuert"
UDS_RDBI.dataIdentifiers[0x2083] = "Configuration SDL speed and distance limiter"
UDS_RDBI.dataIdentifiers[0x2084] = "Configuration USM underhood switching module"  	 # or Sonde Nach KAT Lambda
UDS_RDBI.dataIdentifiers[0x2085] = "Configuration BCM body control module"
UDS_RDBI.dataIdentifiers[0x2086] = "Configuration GCU gas control unit"  	 # or Sonde Nach Kat Bereitschaft
UDS_RDBI.dataIdentifiers[0x2087] = "Configuration Cluster control unit"
UDS_RDBI.dataIdentifiers[0x2088] = "Configuration ABS ESP"
UDS_RDBI.dataIdentifiers[0x2089] = "Configuration SWA steering wheel angle"
UDS_RDBI.dataIdentifiers[0x208a] = "Configuration DDCM driver door control module"
UDS_RDBI.dataIdentifiers[0x208c] = "Maximum duration of ASCD button press"
UDS_RDBI.dataIdentifiers[0x208d] = "Detection of option presence enabled"
UDS_RDBI.dataIdentifiers[0x208e] = "gear engaged 01"
UDS_RDBI.dataIdentifiers[0x208f] = "Anticipated gear engaged"
UDS_RDBI.dataIdentifiers[0x2090] = "Sonde Nach Kat Taupunkt Erreicht"  	 # or Coherent airbag crash frame detection
UDS_RDBI.dataIdentifiers[0x2091] = "Coherent airbag crash frame memorization"
UDS_RDBI.dataIdentifiers[0x2092] = "Air conditioning request"
UDS_RDBI.dataIdentifiers[0x2093] = "Test under pressure of the climatisation circuit"
UDS_RDBI.dataIdentifiers[0x2094] = "Combination of all vehicle air conditioning compressor inhibitions"
UDS_RDBI.dataIdentifiers[0x2095] = "Combination of all engine air conditioning compressor inhibitions"
UDS_RDBI.dataIdentifiers[0x2096] = "Automatic gearbox cranking authorization"
UDS_RDBI.dataIdentifiers[0x2097] = "Automatic gearbox cranking authorization via ECM"
UDS_RDBI.dataIdentifiers[0x2098] = "Accelerated idle speed requested by air conditioning"
UDS_RDBI.dataIdentifiers[0x2099] = "Alternator load"
UDS_RDBI.dataIdentifiers[0x209a] = "Adaptative correction of the idle engine speed regulator"
UDS_RDBI.dataIdentifiers[0x209b] = "Configuration Accessories idle engine speed strategy"
UDS_RDBI.dataIdentifiers[0x209d] = "Electric balance counter"
UDS_RDBI.dataIdentifiers[0x20a0] = "20A1 20C0"
UDS_RDBI.dataIdentifiers[0x20a3] = "Brake pedal states received on the CAN"
UDS_RDBI.dataIdentifiers[0x20a4] = "Sensors power supply 4 voltage raw acquisition"
UDS_RDBI.dataIdentifiers[0x20a5] = "Travelled distance in road and highway from the last oil drain"
UDS_RDBI.dataIdentifiers[0x20a6] = "Travelled distance in depollution zone from the last oil drain"
UDS_RDBI.dataIdentifiers[0x20a8] = "Oil soot rate max model"
UDS_RDBI.dataIdentifiers[0x20a9] = "Total time in richness 1 mode"
UDS_RDBI.dataIdentifiers[0x20aa] = "Mastervac vacuum pressure by sensor"
UDS_RDBI.dataIdentifiers[0x20ab] = "Brake vacuum status received on the CAN"
UDS_RDBI.dataIdentifiers[0x20ac] = "Mastervac vacuum pressure by sensor validity status"
UDS_RDBI.dataIdentifiers[0x20ad] = "Activation request of mastervac diagnosis sequence vacuum pump and analog sensor"
UDS_RDBI.dataIdentifiers[0x20b3] = "StopAuto forbidden by HV network"
UDS_RDBI.dataIdentifiers[0x20b4] = "DCDC activation required by Electrical Energy Management"
UDS_RDBI.dataIdentifiers[0x20b5] = "DCDC Input Current taken on high voltage network send by CAN"
UDS_RDBI.dataIdentifiers[0x20b6] = "DCDC Voltage on High Voltage Network send by CAN"
UDS_RDBI.dataIdentifiers[0x20b7] = "Low voltage power supply current supply by DCDC send by CAN"
UDS_RDBI.dataIdentifiers[0x20b8] = "Maximum current available by system on low voltage power supply send by CAN"
UDS_RDBI.dataIdentifiers[0x20b9] = "DCDC Fault type from CAN"
UDS_RDBI.dataIdentifiers[0x20ba] = "DCDC state send by CAN network"
UDS_RDBI.dataIdentifiers[0x20bc] = "Stop auto forbidden"
UDS_RDBI.dataIdentifiers[0x20bd] = "Electrical Energy Management Stop and Start type"
UDS_RDBI.dataIdentifiers[0x20c0] = "20C1 20E0"
UDS_RDBI.dataIdentifiers[0x20c3] = "Request of update concerning Vxx eng last cge km Vehicle distance at last engine change following a change of engine "
UDS_RDBI.dataIdentifiers[0x20c4] = "Raw boost pressure from sensor"
UDS_RDBI.dataIdentifiers[0x20c6] = "Raw acquisition of the boost pressure"
UDS_RDBI.dataIdentifiers[0x20c8] = "Gas pressure Manifold level"
UDS_RDBI.dataIdentifiers[0x20c9] = "Injected LPG mass setpoint disrigarding sylinder wall wetting to be added"
UDS_RDBI.dataIdentifiers[0x20ca] = "Bench mode to apply default on upstream O2 sensor richness signal for OBD needs"
UDS_RDBI.dataIdentifiers[0x20cb] = "Variable memorized in EEPROM to configure the THP scheduler activation"
UDS_RDBI.dataIdentifiers[0x20cc] = "4 of the 5 zones engine learned 01"
UDS_RDBI.dataIdentifiers[0x20cd] = "Boolean indicating than offset correction is currently on learning"
UDS_RDBI.dataIdentifiers[0x20ce] = "Mean adaptation factor on injection time for binary sensor"
UDS_RDBI.dataIdentifiers[0x20cf] = "Mean adaptation offset on injection time for binary sensor"
UDS_RDBI.dataIdentifiers[0x20d0] = "Raw adaptation factor on injection time with proportionnal upstream O2 sensor"
UDS_RDBI.dataIdentifiers[0x20d1] = "Adaptation raw offset on injection time with proportionnal upstream O2 sensor Bosch calculation value"
UDS_RDBI.dataIdentifiers[0x20d3] = "Factor to correct UEGO signal aging shifting"
UDS_RDBI.dataIdentifiers[0x20d4] = "Indicator of UEGO sensor signal first gain correction achieved when sensor is changed"
UDS_RDBI.dataIdentifiers[0x20d5] = "Downstream lambda sensor bench mode required for homologation"
UDS_RDBI.dataIdentifiers[0x20dc] = "Air flap configuration boolean"
UDS_RDBI.dataIdentifiers[0x20dd] = "Variable for presence of oil heater vapours conf choice"
UDS_RDBI.dataIdentifiers[0x20de] = "Ambient temperature"
UDS_RDBI.dataIdentifiers[0x20e0] = "20E1 2100"
UDS_RDBI.dataIdentifiers[0x20e1] = "Next gear position by shift pattern"
UDS_RDBI.dataIdentifiers[0x20e8] = "Maintenance mode status Roller bench mode information"
UDS_RDBI.dataIdentifiers[0x20f1] = "Position setpoint of the inlet throttle sent by the monitoring system"
UDS_RDBI.dataIdentifiers[0x20f4] = "Distance vehicle non resetable calculated by the ECM in decameter"
UDS_RDBI.dataIdentifiers[0x20f5] = "Ice powertrain setpoint elaborated from RAW"
UDS_RDBI.dataIdentifiers[0x20f8] = "Final position setpoint for multiways valve value"
UDS_RDBI.dataIdentifiers[0x20f9] = "Multiways valve position sensor"
UDS_RDBI.dataIdentifiers[0x20fa] = "Supervisor for thermo management"
UDS_RDBI.dataIdentifiers[0x20fb] = "Heater valve flow command value"
UDS_RDBI.dataIdentifiers[0x20ff] = "Relay electrical failure feedback"
UDS_RDBI.dataIdentifiers[0x2100] = "2101 2020"
UDS_RDBI.dataIdentifiers[0x2101] = "Kraftstoffdruck Sensorspannung"  	 # or 4 last stored values of the oil drain type
UDS_RDBI.dataIdentifiers[0x2102] = "Hebelgeber 1 Signalspannung"
UDS_RDBI.dataIdentifiers[0x2103] = "Hebelgeber 2 Signalspannung"
UDS_RDBI.dataIdentifiers[0x2104] = "Kraftstoffqualitaetssensor Signalfrequenz"
UDS_RDBI.dataIdentifiers[0x2105] = "Kraftstoffqualitaetssensor DutyCycle"
UDS_RDBI.dataIdentifiers[0x2106] = "NVLD Switch Spannung Low"  	 # or Actual geographic zone
UDS_RDBI.dataIdentifiers[0x2107] = "NVLD Switch Spannung High"
UDS_RDBI.dataIdentifiers[0x2108] = "Total vehicle distance stored at the last pre alert"
UDS_RDBI.dataIdentifiers[0x2109] = "First number of vehicle kilometers for the remaining potential calculation"
UDS_RDBI.dataIdentifiers[0x210a] = "vehicle kilometers for the remaining potential calculation"
UDS_RDBI.dataIdentifiers[0x210b] = "First oil wear for the remaining potential calculation"
UDS_RDBI.dataIdentifiers[0x210c] = "oil wear for the remaining potential calculation"
UDS_RDBI.dataIdentifiers[0x210d] = "Number of remaining vehicle kilometers at the last key off"
UDS_RDBI.dataIdentifiers[0x210e] = "Number of engine revolutions since the last oil drain"
UDS_RDBI.dataIdentifiers[0x210f] = "Internal number of the last oil drain"
UDS_RDBI.dataIdentifiers[0x2110] = "Total vehicle distance at the last oil drain"
UDS_RDBI.dataIdentifiers[0x2111] = "Last oil drain type"
UDS_RDBI.dataIdentifiers[0x2112] = "Boolean to initialise strategies in case of after sales oil drain"
UDS_RDBI.dataIdentifiers[0x2113] = "Oil temperature for oil wear estimation on previous engine off"
UDS_RDBI.dataIdentifiers[0x2114] = "Boolean set if the first oil dilution threshold is passed"  	 # or Kupplungspedalsensor ROH
UDS_RDBI.dataIdentifiers[0x2115] = "Boolean set if the second oil dilution threshold is passed"  	 # or Kupplungspedalsensor
UDS_RDBI.dataIdentifiers[0x211a] = "Interpolation raw factor"
UDS_RDBI.dataIdentifiers[0x211b] = "oil dilution rate for oil wear estimation"
UDS_RDBI.dataIdentifiers[0x211c] = "Rounded oil dilution potential meters"
UDS_RDBI.dataIdentifiers[0x211d] = "Vehicle kilometers memorisation trigger before rising edge"
UDS_RDBI.dataIdentifiers[0x211e] = "Oil drain requested by the strategy"
UDS_RDBI.dataIdentifiers[0x211f] = "Oil soot rate"
UDS_RDBI.dataIdentifiers[0x2120] = "2121 2140"
UDS_RDBI.dataIdentifiers[0x2121] = "Ansauglufttemperatur im Saugrohr im Kaltstart"
UDS_RDBI.dataIdentifiers[0x2122] = "Ansauglufttemperatur im Kaltstart"
UDS_RDBI.dataIdentifiers[0x2127] = "Sekundaerluft Druck ROH"
UDS_RDBI.dataIdentifiers[0x2128] = "Sekundaerluft Druck"
UDS_RDBI.dataIdentifiers[0x2129] = "Klimaanlagen Druck ROH"
UDS_RDBI.dataIdentifiers[0x212a] = "Klimaanlagen Druck"
UDS_RDBI.dataIdentifiers[0x2130] = "Sonde Vor Kat Waermemenge IST fuer TPE"
UDS_RDBI.dataIdentifiers[0x2132] = "Sonde Vor Kat Waermemenge SOLL fuer TPE"
UDS_RDBI.dataIdentifiers[0x2134] = "Sonde Nach Kat Waermemenge IST fuer TPE"
UDS_RDBI.dataIdentifiers[0x2136] = "Sonde Nach Kat Waermemenge SOLL fuer TPE"
UDS_RDBI.dataIdentifiers[0x2140] = "2141 2160"
UDS_RDBI.dataIdentifiers[0x2141] = "TRZ Value of the coeficient beta corrected by adaptative strategy during half turn of cyl 1 and 4 for torque computat"
UDS_RDBI.dataIdentifiers[0x2142] = "TRZ the learning trz beta correction is validated"
UDS_RDBI.dataIdentifiers[0x2143] = "TRZ Value of the coeficient beta corrected by adaptative strategy during half turn of cyl 2 and 3 for torque computat"
UDS_RDBI.dataIdentifiers[0x2144] = "TRZ Learning crankshaft defaults half turn counter"
UDS_RDBI.dataIdentifiers[0x2145] = "TRZ TRZ adaptive correction for torque calculation when cyl 1 and 4 are in combustion filtered beta value for cylind"
UDS_RDBI.dataIdentifiers[0x2146] = "TRZ TRZ adaptive correction for torque calculation when cyl 2 and 3 are in combustion filtered beta value for cylind"
UDS_RDBI.dataIdentifiers[0x2147] = "TLZ Status of target adaptive process"
UDS_RDBI.dataIdentifiers[0x2157] = "TLZ Maximum engine speed for misfiring detection strategy"
UDS_RDBI.dataIdentifiers[0x215a] = "TLZ Learning counter for realized half turn default"
UDS_RDBI.dataIdentifiers[0x215b] = "TLZ Learning half turn default state"
UDS_RDBI.dataIdentifiers[0x215c] = "TLZ learning filtered value"
UDS_RDBI.dataIdentifiers[0x215d] = "TLZ TLZ adaptive correction"
UDS_RDBI.dataIdentifiers[0x215e] = "Distance driven since torque meter init"
UDS_RDBI.dataIdentifiers[0x215f] = "Consolidated intake camshaft level"
UDS_RDBI.dataIdentifiers[0x2160] = "2161 2180"
UDS_RDBI.dataIdentifiers[0x2161] = "Crankshaft signal"
UDS_RDBI.dataIdentifiers[0x2162] = "Counter of loose of crankshaft synchronization"
UDS_RDBI.dataIdentifiers[0x2163] = "Angular position of engine"
UDS_RDBI.dataIdentifiers[0x2164] = "Long engine start request"
UDS_RDBI.dataIdentifiers[0x2165] = "TLZ High speed and fast adaptative crank shaft learning strategy finished"
UDS_RDBI.dataIdentifiers[0x2166] = "External controls safety authorization flag"
UDS_RDBI.dataIdentifiers[0x2167] = "Oil pump monitored command"
UDS_RDBI.dataIdentifiers[0x2168] = "Cumulative number of engine starts"
UDS_RDBI.dataIdentifiers[0x2169] = "Number of engine first starts or number of trips done by the vehicle"
UDS_RDBI.dataIdentifiers[0x216a] = "Cumulative number of engine starts non resettable"
UDS_RDBI.dataIdentifiers[0x216b] = "Number of engine first starts or number of trips done by the vehicle non resettable"
UDS_RDBI.dataIdentifiers[0x216c] = "Distance vehicle non resetable calculated by the ECM"
UDS_RDBI.dataIdentifiers[0x216d] = "Vehicle speed autoconfiguration"
UDS_RDBI.dataIdentifiers[0x216e] = "Autoconfiguration variable for air conditionning"
UDS_RDBI.dataIdentifiers[0x216f] = "State of EMCU Control Unit for CAN failure detection"
UDS_RDBI.dataIdentifiers[0x2170] = "CCSL State of the system causes for normal CCSL deactivation 2nd byte"
UDS_RDBI.dataIdentifiers[0x2172] = "Reference software calbration number used by tunning team VMAP"
UDS_RDBI.dataIdentifiers[0x2174] = "ACC Force request confirmed from CAN"
UDS_RDBI.dataIdentifiers[0x2175] = "ACC status from CAN"
UDS_RDBI.dataIdentifiers[0x2176] = "Vehicle acceleration state form CAN"
UDS_RDBI.dataIdentifiers[0x2177] = "Pressure Request status from ACC"
UDS_RDBI.dataIdentifiers[0x2178] = "Force request from ACC"
UDS_RDBI.dataIdentifiers[0x2179] = "Driver force setpoint"
UDS_RDBI.dataIdentifiers[0x217a] = "Confirmed failure corresponding to the checks on ACC"
UDS_RDBI.dataIdentifiers[0x217b] = "ACC steering wheel switches connection detection Stored in EEPROM"
UDS_RDBI.dataIdentifiers[0x217c] = "Detect ACC option with security on configuration detection Stored in EEPROM"
UDS_RDBI.dataIdentifiers[0x217d] = "Maximum duration of DISTANCE button press"
UDS_RDBI.dataIdentifiers[0x2180] = "2181 21A0"
UDS_RDBI.dataIdentifiers[0x2181] = "Mileage recording"
UDS_RDBI.dataIdentifiers[0x2184] = "Requested speed setpoint for FSL function"
UDS_RDBI.dataIdentifiers[0x2186] = "Idle speed for LCV accessories activation requested by BCM"
UDS_RDBI.dataIdentifiers[0x2187] = "State of the CTP cutoff"
UDS_RDBI.dataIdentifiers[0x2188] = "State of the CTP unicing"
UDS_RDBI.dataIdentifiers[0x218d] = "Final PTC level"
UDS_RDBI.dataIdentifiers[0x218e] = "PTC freeze request"
UDS_RDBI.dataIdentifiers[0x218f] = "PTC cut off request"
UDS_RDBI.dataIdentifiers[0x2190] = "Torque safety monitoring status flags for snapshot data"
UDS_RDBI.dataIdentifiers[0x2191] = "Power consumed by PTC"
UDS_RDBI.dataIdentifiers[0x2192] = "PTC cabin fan state"
UDS_RDBI.dataIdentifiers[0x2193] = "PTC Cabin fan request detection"
UDS_RDBI.dataIdentifiers[0x2195] = "PTC engine idle speed increase request"
UDS_RDBI.dataIdentifiers[0x219b] = "Maximum vehicle speed to authorize commercial vehicle accessories accelerated idle speed"
UDS_RDBI.dataIdentifiers[0x219c] = "Detection of a failure that causes commercial vehicle accessories accelerated idle speed deactivation"
UDS_RDBI.dataIdentifiers[0x21a0] = "21A1 21C0"
UDS_RDBI.dataIdentifiers[0x21a1] = "TDC decrementing counter for HBN fast adaptive process used on the first value of the main TDC counter"
UDS_RDBI.dataIdentifiers[0x21a2] = "Slow adaptive process finished"
UDS_RDBI.dataIdentifiers[0x21a3] = "Validity of the learned default value"
UDS_RDBI.dataIdentifiers[0x21a4] = "Filtered adaptive value for the first value of the TDC counter during slow adaptive process"
UDS_RDBI.dataIdentifiers[0x21a5] = "Filtered adaptive value for the first value of the TDC counter in the first speed range"
UDS_RDBI.dataIdentifiers[0x21a6] = "Filtered adaptive value for the first value of the TDC counter in the second speed range"
UDS_RDBI.dataIdentifiers[0x21a7] = "Filtered adaptive value for the first value of the TDC counter in the third speed range"
UDS_RDBI.dataIdentifiers[0x21a8] = "Filtered adaptive value for the first value of the TDC counter in the 4th speed range"
UDS_RDBI.dataIdentifiers[0x21a9] = "Filtered adaptive value for the first value of the TDC counter in the 5th speed range"
UDS_RDBI.dataIdentifiers[0x21aa] = "Filtered adaptive value for the first value of the TDC counter in the 6th speed range"
UDS_RDBI.dataIdentifiers[0x21ab] = "TDC decrementing counter for HBN fast adaptive process used on the second value of the main TDC counter"
UDS_RDBI.dataIdentifiers[0x21ac] = "Filtered adaptive value for the second value of the TDC counter during slow adaptive process"
UDS_RDBI.dataIdentifiers[0x21ad] = "Filtered adaptive value for the second value of the TDC counter in the first speed range"
UDS_RDBI.dataIdentifiers[0x21ae] = "Filtered adaptive value for the second value of the TDC counter in the second speed range"
UDS_RDBI.dataIdentifiers[0x21af] = "Filtered adaptive value for the second value of the TDC counter in the third speed range"
UDS_RDBI.dataIdentifiers[0x21b0] = "Filtered adaptive value for the second value of the TDC counter in the 4th speed range"
UDS_RDBI.dataIdentifiers[0x21b1] = "Filtered adaptive value for the second value of the TDC counter in the 5th speed range"
UDS_RDBI.dataIdentifiers[0x21b2] = "Filtered adaptive value for the second value of the TDC counter in the 6th speed range"
UDS_RDBI.dataIdentifiers[0x21b3] = "TDC decrementing counter for HBN fast adaptive process used on the third value of the main TDC counter"
UDS_RDBI.dataIdentifiers[0x21b4] = "Filtered adaptive value for the third value of the TDC counter during slow adaptive process"
UDS_RDBI.dataIdentifiers[0x21b5] = "Filtered adaptive value for the third value of the TDC counter in the first speed range"
UDS_RDBI.dataIdentifiers[0x21b6] = "Filtered adaptive value for the third value of the TDC counter in the second speed range"
UDS_RDBI.dataIdentifiers[0x21b7] = "Filtered adaptive value for the third value of the TDC counter in the third speed range"
UDS_RDBI.dataIdentifiers[0x21b8] = "Filtered adaptive value for the third value of the TDC counter in the 4th speed range"
UDS_RDBI.dataIdentifiers[0x21b9] = "Filtered adaptive value for the third value of the TDC counter in the 5th speed range"
UDS_RDBI.dataIdentifiers[0x21ba] = "Filtered adaptive value for the third value of the TDC counter in the 6th speed range"
UDS_RDBI.dataIdentifiers[0x21bb] = "Status of target adaptive process"
UDS_RDBI.dataIdentifiers[0x21bc] = "Last achieved adaptive value"
UDS_RDBI.dataIdentifiers[0x21bd] = "Default learning counter on the first value of the main TDC counter"
UDS_RDBI.dataIdentifiers[0x21be] = "Default learning counter on the second value of the main TDC counter"
UDS_RDBI.dataIdentifiers[0x21bf] = "Default learning counter on the third value of the main TDC counter"
UDS_RDBI.dataIdentifiers[0x21c0] = "21C1 21E0"
UDS_RDBI.dataIdentifiers[0x21c1] = "Learned filtered value on the first value of the main TDC counter"
UDS_RDBI.dataIdentifiers[0x21c2] = "Learned filtered value on the 2nd value of the main TDC counter"
UDS_RDBI.dataIdentifiers[0x21c3] = "Learned filtered value on the third value of the main TDC counter"
UDS_RDBI.dataIdentifiers[0x21c4] = "HBN adaptive correction"
UDS_RDBI.dataIdentifiers[0x21c5] = "Distance driven since torque meter init Write 2"
UDS_RDBI.dataIdentifiers[0x21c6] = "Maximum engine speed for misfiring detection strategy"
UDS_RDBI.dataIdentifiers[0x21c7] = "Vehicle distance at last succesfull detection test Fuel level or Vehicle distance"
UDS_RDBI.dataIdentifiers[0x21c8] = "HBN adaptive correction 01"
UDS_RDBI.dataIdentifiers[0x21cd] = "User SOC"
UDS_RDBI.dataIdentifiers[0x21ce] = "Electrical Energy Management DCDC status"
UDS_RDBI.dataIdentifiers[0x21d2] = "State of DCDC Unit for CAN failure detection"
UDS_RDBI.dataIdentifiers[0x21dd] = "Management System 2 ECU state"
UDS_RDBI.dataIdentifiers[0x21df] = "Low voltage power supply current supply by DCDC"
UDS_RDBI.dataIdentifiers[0x21e0] = "21E1 21FF"
UDS_RDBI.dataIdentifiers[0x21e6] = "Accumulated failure time for ivld management"
UDS_RDBI.dataIdentifiers[0x21e7] = "Accumulated mileage buffer in highway conditions"
UDS_RDBI.dataIdentifiers[0x21e8] = "Number of significant cases of highway conditions"
UDS_RDBI.dataIdentifiers[0x21e9] = "Average mileage between two significant cases of highway condition"
UDS_RDBI.dataIdentifiers[0x21ea] = "Cumulated mileage in highway conditions"
UDS_RDBI.dataIdentifiers[0x21eb] = "Mileage rate of highway conditions"
UDS_RDBI.dataIdentifiers[0x21ec] = "Accumulated mileage buffer in road conditions"
UDS_RDBI.dataIdentifiers[0x21ed] = "Cumulated mileage in road conditions"
UDS_RDBI.dataIdentifiers[0x21ee] = "Mileage rate of road conditions"
UDS_RDBI.dataIdentifiers[0x21ef] = "Accumulated mileage buffer in urban conditions"
UDS_RDBI.dataIdentifiers[0x21f0] = "Cumulated mileage in urban conditions"
UDS_RDBI.dataIdentifiers[0x21f1] = "Mileage rate of urban conditions"
UDS_RDBI.dataIdentifiers[0x2200] = "2201 2220"
UDS_RDBI.dataIdentifiers[0x2201] = "Kraftstoffdruck Sensorspannung ROH"
UDS_RDBI.dataIdentifiers[0x2202] = "Hebelgeber 1 Spannung ROH"
UDS_RDBI.dataIdentifiers[0x2203] = "Hebelgeber 2 Spannung ROH"
UDS_RDBI.dataIdentifiers[0x2206] = "NVLD Switch Spannung Low ROH"
UDS_RDBI.dataIdentifiers[0x2207] = "NVLD Switch Spannung High ROH"  	 # or Motor fan failure status on the CAN
UDS_RDBI.dataIdentifiers[0x220a] = "State of Inverter Unit for CAN failure detection"
UDS_RDBI.dataIdentifiers[0x2218] = "Environmental temperature"
UDS_RDBI.dataIdentifiers[0x221a] = "State of BMS Unit for CAN failure detection"
UDS_RDBI.dataIdentifiers[0x221e] = "Emergency engine stop request"
UDS_RDBI.dataIdentifiers[0x2220] = "2221 2240"
UDS_RDBI.dataIdentifiers[0x2221] = "Brake pedal states validity indicator is in the limp home data status"
UDS_RDBI.dataIdentifiers[0x2222] = "Filtered unavailable clutch pedal status information"
UDS_RDBI.dataIdentifiers[0x2223] = "Engine control request for cruise control abnormal deactivation"
UDS_RDBI.dataIdentifiers[0x2224] = "Engine control request for cruise control system deactivation"
UDS_RDBI.dataIdentifiers[0x2225] = "Vehicle speed received on the CAN network not available after a filtering time"
UDS_RDBI.dataIdentifiers[0x2226] = "Displayed vehicle speed received on the CAN network not available after a filtering time"
UDS_RDBI.dataIdentifiers[0x2227] = "Engine control request for speed limiter abnormal deactivation"
UDS_RDBI.dataIdentifiers[0x2228] = "Engine control request for speed limiter system deactivation"
UDS_RDBI.dataIdentifiers[0x2229] = "Air conditioning request detection"
UDS_RDBI.dataIdentifiers[0x222a] = "Relative air conditioning pressure"
UDS_RDBI.dataIdentifiers[0x222b] = "Automatic or manual parking brake detected"
UDS_RDBI.dataIdentifiers[0x222c] = "Begin stroke clutch pedal switch for cruise control safety"
UDS_RDBI.dataIdentifiers[0x222d] = "Begin stroke clutch pedal switch for cruise control"
UDS_RDBI.dataIdentifiers[0x222e] = "Neutral engaged switch for manual gearbox"
UDS_RDBI.dataIdentifiers[0x222f] = "Authorization to connect cruise control and speed limiter options"
UDS_RDBI.dataIdentifiers[0x2230] = "Boolean to allow increment of Vxx clu stal ctr"
UDS_RDBI.dataIdentifiers[0x2231] = "Counter of stalling of type clutch failed starting up due to the software lock"
UDS_RDBI.dataIdentifiers[0x2232] = "Counter of success of cylinder recognition in idle speed regulation"
UDS_RDBI.dataIdentifiers[0x2233] = "Counter of confirmation of phase in using cylinder recognition running vehicule"
UDS_RDBI.dataIdentifiers[0x2234] = "Failure counter for cylinder recognition"
UDS_RDBI.dataIdentifiers[0x2235] = "Cylinder recognition counter"
UDS_RDBI.dataIdentifiers[0x2236] = "Cylinder recognition counter in idle speed regulation"
UDS_RDBI.dataIdentifiers[0x2237] = "Failure counter for idle speed speed regulation not confirmed by cylinder recognition for running vehicle"
UDS_RDBI.dataIdentifiers[0x2238] = "Counter of success od cylinder recognition in idle speed regulation"
UDS_RDBI.dataIdentifiers[0x2239] = "Counter of no decision of cylinder recognition"
UDS_RDBI.dataIdentifiers[0x223a] = "Counter of no decision of cylinder recognition in RR mode"
UDS_RDBI.dataIdentifiers[0x223b] = "Rephasing counter after cylinder recognition in running vehicle"
UDS_RDBI.dataIdentifiers[0x223e] = "Consolidated braking pressure"
UDS_RDBI.dataIdentifiers[0x2240] = "2241 2260"
UDS_RDBI.dataIdentifiers[0x2241] = "Allow comparison between measured angular positions of the camshaft wheel active edges and values stored in EEPROM Rea"
UDS_RDBI.dataIdentifiers[0x2242] = "Angular position stored in EEPROM for the active edge n 0 camshatf wheel"
UDS_RDBI.dataIdentifiers[0x2243] = "Angular position stored in EEPROM for the active edge n 1 camshatf wheel"
UDS_RDBI.dataIdentifiers[0x2244] = "Angular position stored in EEPROM for the active edge n 2 camshatf wheel"
UDS_RDBI.dataIdentifiers[0x2245] = "Angular position stored in EEPROM for the active edge n 3 camshatf wheel"
UDS_RDBI.dataIdentifiers[0x2246] = "Integral torque correction Idle Speed regulator"
UDS_RDBI.dataIdentifiers[0x2247] = "Oscillation detected failure local counter for inlet throttle"
UDS_RDBI.dataIdentifiers[0x2248] = "Immobilizer 2 Failure of coded line"
UDS_RDBI.dataIdentifiers[0x2249] = "Immobilizer 2 ECM is locked"
UDS_RDBI.dataIdentifiers[0x224a] = "Immobilizer 2 ECM is protected"
UDS_RDBI.dataIdentifiers[0x224b] = "Immobilizer 2 Failure of EEPROM area"
UDS_RDBI.dataIdentifiers[0x224c] = "Immobilizer 2 Secret key learnt"
UDS_RDBI.dataIdentifiers[0x224d] = "PWM control applied to the driver of the exhaust VVTC solenoid valve"
UDS_RDBI.dataIdentifiers[0x224e] = "Angular position of the exhaust VVTC system"
UDS_RDBI.dataIdentifiers[0x224f] = "Angular position setpoint of the exhaust VVTC system"
UDS_RDBI.dataIdentifiers[0x2255] = "Filtered angular position of the exhaust VVTC system"
UDS_RDBI.dataIdentifiers[0x2260] = "2261 2280"
UDS_RDBI.dataIdentifiers[0x2261] = "Power steering manostat activation"
UDS_RDBI.dataIdentifiers[0x2262] = "Activation request solenoid valve of additional fuel tank"
UDS_RDBI.dataIdentifiers[0x2263] = "Activation request pump of additional fuel tank"
UDS_RDBI.dataIdentifiers[0x2264] = "Flow water valve command of water system"
UDS_RDBI.dataIdentifiers[0x2280] = "2281 22A0"
UDS_RDBI.dataIdentifiers[0x2281] = "oil soot rate for oil wear estimation"
UDS_RDBI.dataIdentifiers[0x2282] = "Interpolation raw factor from oil dilution to oil soot"
UDS_RDBI.dataIdentifiers[0x2287] = "Rounded oil soot potential meters"
UDS_RDBI.dataIdentifiers[0x228c] = "Vehicle kilometer when the alert appears"
UDS_RDBI.dataIdentifiers[0x228d] = "Total vehicle distance when the oil soot becomes to high stored on EEPROM"
UDS_RDBI.dataIdentifiers[0x228e] = "Oil potential kilometers during one by one km decrementation"
UDS_RDBI.dataIdentifiers[0x228f] = "Type of initialisation when the state of the counter is 0"
UDS_RDBI.dataIdentifiers[0x2290] = "Type of initialisation when the state of the counter is"
UDS_RDBI.dataIdentifiers[0x2291] = "Type of initialisation when the state of the counter is 2"
UDS_RDBI.dataIdentifiers[0x2292] = "Type of initialisation when the state of the counter is 3"
UDS_RDBI.dataIdentifiers[0x2293] = "normal mode oil dilution rate"
UDS_RDBI.dataIdentifiers[0x2294] = "raw oil dilution rate"
UDS_RDBI.dataIdentifiers[0x2295] = "Interval time in full load mode"
UDS_RDBI.dataIdentifiers[0x2296] = "Interval time between two regenerations"
UDS_RDBI.dataIdentifiers[0x2298] = "Oil potential kilometers calculated"
UDS_RDBI.dataIdentifiers[0x2299] = "Calculated oil potential in kilometers can be negative"
UDS_RDBI.dataIdentifiers[0x22a0] = "22A1 22C0"
UDS_RDBI.dataIdentifiers[0x22a9] = "SCR Control Unit DCU counter for validated CAN failure detection"
UDS_RDBI.dataIdentifiers[0x22aa] = "Cumulative number of engine starts for starter reliability"
UDS_RDBI.dataIdentifiers[0x22ac] = "Cause of the failsafe reaction triggered by level 2 monitoring"
UDS_RDBI.dataIdentifiers[0x22ad] = "First context data for level 2 monitoring function failure"
UDS_RDBI.dataIdentifiers[0x22ae] = "Second context data for level 2 monitoring function failure"
UDS_RDBI.dataIdentifiers[0x22af] = "Third context data for level 2 monitoring function failure"
UDS_RDBI.dataIdentifiers[0x22b0] = "Fourth context data for level 2 monitoring function failure"
UDS_RDBI.dataIdentifiers[0x22b6] = "Wire begin clutch contactor state"
UDS_RDBI.dataIdentifiers[0x22b8] = "Anticipated coupler state"
UDS_RDBI.dataIdentifiers[0x22bc] = "Dynamic mode request received on the CAN"
UDS_RDBI.dataIdentifiers[0x22bd] = "Eco mode request received on the CAN"
UDS_RDBI.dataIdentifiers[0x22be] = "Drive mode received on the CAN"
UDS_RDBI.dataIdentifiers[0x22bf] = "Power supply voltage raw acquisition of cylinder pressure sensor"
UDS_RDBI.dataIdentifiers[0x2400] = "2401 2420"
UDS_RDBI.dataIdentifiers[0x2401] = "Boost pressure"
UDS_RDBI.dataIdentifiers[0x2402] = "Boost pressure setpoint"
UDS_RDBI.dataIdentifiers[0x2406] = "Inlet throttle PWM command"
UDS_RDBI.dataIdentifiers[0x240b] = "Intake manifold pressure"
UDS_RDBI.dataIdentifiers[0x240d] = "Intake air temperature"
UDS_RDBI.dataIdentifiers[0x2411] = "State Of Charge"
UDS_RDBI.dataIdentifiers[0x2414] = "Throttle valve position setpoint"
UDS_RDBI.dataIdentifiers[0x2415] = "Throttle valve position track"
UDS_RDBI.dataIdentifiers[0x2416] = "Maximum Hybrid Battery Module Temperature"
UDS_RDBI.dataIdentifiers[0x2417] = "Minimum Hybrid Battery Module Temperature"
UDS_RDBI.dataIdentifiers[0x2418] = "Throttle valve position sensor voltage track"
UDS_RDBI.dataIdentifiers[0x2419] = "Throttle valve position sensor voltage track"
UDS_RDBI.dataIdentifiers[0x2420] = "2421 2440"
UDS_RDBI.dataIdentifiers[0x2422] = "Amount of air pumped into cylinder"
UDS_RDBI.dataIdentifiers[0x2426] = "Regenerative Braking Axle Torque Request"
UDS_RDBI.dataIdentifiers[0x2427] = "Engine Torque Actual"
UDS_RDBI.dataIdentifiers[0x2428] = "Commanded Axle Torque Predicted"
UDS_RDBI.dataIdentifiers[0x2429] = "Axle Torque Actual"
UDS_RDBI.dataIdentifiers[0x242a] = "Strong Hybrid Limp-Home"
UDS_RDBI.dataIdentifiers[0x242b] = "Estimated Regenerative Braking Axle Torque"
UDS_RDBI.dataIdentifiers[0x242c] = "Driver Intended Total Brake Torque"
UDS_RDBI.dataIdentifiers[0x242d] = "Commanded Axle Torque Immediate"
UDS_RDBI.dataIdentifiers[0x242e] = "Internal Combustion Engine"
UDS_RDBI.dataIdentifiers[0x242f] = "MCPA Motor B Current Offset Phase A"  	 # or MCPB Motor A Current Offset Phase "  	 # or Throttle valve position
UDS_RDBI.dataIdentifiers[0x2430] = "MCPB Motor A Current Offset Phase B"  	 # or MCPA Motor B Current Offset Phase "
UDS_RDBI.dataIdentifiers[0x2431] = "MCPB Motor A Current Offset Phase C"  	 # or MCPA Motor B Current Offset Phase "
UDS_RDBI.dataIdentifiers[0x2432] = "Engine Crank Speed Commanded"
UDS_RDBI.dataIdentifiers[0x2433] = "Internal Combustion Engine Cranking"
UDS_RDBI.dataIdentifiers[0x2434] = "Driver Intended Axle Torque"
UDS_RDBI.dataIdentifiers[0x2435] = "BSE x EE NV Data.EE OldEE09"
UDS_RDBI.dataIdentifiers[0x2436] = "kWhr Round Trip"
UDS_RDBI.dataIdentifiers[0x2437] = "Commanded Predicted Engine Torque"
UDS_RDBI.dataIdentifiers[0x2438] = "Commanded Immediate Engine Torque"
UDS_RDBI.dataIdentifiers[0x2439] = "BSE x EE NV Data.EE OldEE07"
UDS_RDBI.dataIdentifiers[0x243f] = "Intake manifold temperature"
UDS_RDBI.dataIdentifiers[0x2440] = "2441 2460"  	 # or VeBSEC k BSEinitState
UDS_RDBI.dataIdentifiers[0x2441] = "Ahr Charge"
UDS_RDBI.dataIdentifiers[0x2442] = "Ahr DisCharge"
UDS_RDBI.dataIdentifiers[0x2443] = "VeAPIC Output1"
UDS_RDBI.dataIdentifiers[0x2445] = "VeAPIC Output12"
UDS_RDBI.dataIdentifiers[0x2446] = "VeAPIC Output4 "
UDS_RDBI.dataIdentifiers[0x2447] = "VeAPIC Output5"
UDS_RDBI.dataIdentifiers[0x2448] = "VeAPIC Output6 "  	 # or Pressure before turbine
UDS_RDBI.dataIdentifiers[0x2449] = "VeAPIC Output13"  	 # or Catalyst exhaust gas upstream oxygen sensor voltage
UDS_RDBI.dataIdentifiers[0x244a] = "Catalyst exhaust gas downstream oxygen sensor voltage"
UDS_RDBI.dataIdentifiers[0x244b] = "Catalyst exhaust gas upstream oxygen resistance heater PWM command"
UDS_RDBI.dataIdentifiers[0x244c] = "Catalyst exhaust gas downstream oxygen resistance heater PWM command"
UDS_RDBI.dataIdentifiers[0x244d] = "Inlet throttle upstream temperature"
UDS_RDBI.dataIdentifiers[0x2450] = "VeAPIC Output9"
UDS_RDBI.dataIdentifiers[0x2451] = "b contactor command"
UDS_RDBI.dataIdentifiers[0x2452] = "b HS Comm"
UDS_RDBI.dataIdentifiers[0x2453] = "b Proper Shutdown"
UDS_RDBI.dataIdentifiers[0x2454] = "BSE x EE NV Data.EE OldEE01"
UDS_RDBI.dataIdentifiers[0x2455] = "BSE x EE NV Data.EE OldEE02"
UDS_RDBI.dataIdentifiers[0x2456] = "BSE x EE NV Data.EE OldEE03"
UDS_RDBI.dataIdentifiers[0x2457] = "BSE x EE NV Data.EE OldEE04"
UDS_RDBI.dataIdentifiers[0x2458] = "BSE x EE NV Data.EE OldEE05"  	 # or Throttle valve offset min position track 2
UDS_RDBI.dataIdentifiers[0x2459] = "BSE x EE NV Data.EE OldEE06"
UDS_RDBI.dataIdentifiers[0x245a] = "Throttle valve offset limp home position track 2"
UDS_RDBI.dataIdentifiers[0x245b] = "Throttle valve offset max position track"
UDS_RDBI.dataIdentifiers[0x245c] = "Throttle valve offset max position track 2"
UDS_RDBI.dataIdentifiers[0x245d] = "Throttle valve offset first learnings successfully done"
UDS_RDBI.dataIdentifiers[0x245e] = "Engine air load"
UDS_RDBI.dataIdentifiers[0x2460] = "BSE x EE NV Data.EE Pct OldPackSOC"  	 # or 2461 2480
UDS_RDBI.dataIdentifiers[0x2461] = "BSE x EE NV Data.EE Pct OldSOCAcc"
UDS_RDBI.dataIdentifiers[0x2462] = "BSE x EE NV Data.EE Pct SOH"
UDS_RDBI.dataIdentifiers[0x2463] = "EE BatODO"
UDS_RDBI.dataIdentifiers[0x2464] = "VeAPIC Output10 "
UDS_RDBI.dataIdentifiers[0x2465] = "BSE x EE NV Data.EE T TOld "
UDS_RDBI.dataIdentifiers[0x2466] = "BSE x EE NV Data.EE U OldVo"
UDS_RDBI.dataIdentifiers[0x2467] = "CntCtrStat"
UDS_RDBI.dataIdentifiers[0x2468] = "I Current "
UDS_RDBI.dataIdentifiers[0x2469] = "init OCV"
UDS_RDBI.dataIdentifiers[0x246f] = "Throttle valve voltage command"
UDS_RDBI.dataIdentifiers[0x2470] = "init pack current"
UDS_RDBI.dataIdentifiers[0x2471] = "NumOfModules"
UDS_RDBI.dataIdentifiers[0x2472] = "T Temperature"
UDS_RDBI.dataIdentifiers[0x2473] = "U MaxModVoltage"
UDS_RDBI.dataIdentifiers[0x2474] = "U MinModVoltage"
UDS_RDBI.dataIdentifiers[0x2475] = "U Voltage"
UDS_RDBI.dataIdentifiers[0x2476] = "VeAPIC b SOCreset anz"
UDS_RDBI.dataIdentifiers[0x2477] = "VeAPIC Output14"
UDS_RDBI.dataIdentifiers[0x2478] = "VeAPIC Output15"
UDS_RDBI.dataIdentifiers[0x2479] = "VeAPIC Output20"
UDS_RDBI.dataIdentifiers[0x2480] = "2481 24A0"  	 # or VeAPIC Output16
UDS_RDBI.dataIdentifiers[0x2481] = "VeAPIC Output17"
UDS_RDBI.dataIdentifiers[0x2482] = "VeAPIC Output18"
UDS_RDBI.dataIdentifiers[0x2483] = "VeAPIC Output19"
UDS_RDBI.dataIdentifiers[0x2484] = "VeAPIC Output7"
UDS_RDBI.dataIdentifiers[0x2485] = "VeAPIC Output8"
UDS_RDBI.dataIdentifiers[0x2489] = "Oil dilution rate"
UDS_RDBI.dataIdentifiers[0x2491] = "VeAPIC Pct HB SOCahr"
UDS_RDBI.dataIdentifiers[0x2492] = "VeAPIC Pct HB SOCvolt"
UDS_RDBI.dataIdentifiers[0x2493] = "VeAPIC t BSEofftime"  	 # or Result of the catalyst diagnostic after sales routine
UDS_RDBI.dataIdentifiers[0x2494] = "VeAPIC b BSEofftimeVld"  	 # or Result of the catalyst exhaust gas upstream oxygen sensor diagnostic after sales routine
UDS_RDBI.dataIdentifiers[0x2495] = "MAZ neu"
UDS_RDBI.dataIdentifiers[0x2496] = "MAZ neuVld"
UDS_RDBI.dataIdentifiers[0x2497] = "Timestamp"
UDS_RDBI.dataIdentifiers[0x2498] = "Timestamp valid"
UDS_RDBI.dataIdentifiers[0x24a0] = "24A0 24C0"
UDS_RDBI.dataIdentifiers[0x24bf] = "Turbo water cooling pump command"
UDS_RDBI.dataIdentifiers[0x24c0] = "24C1 24E0"
UDS_RDBI.dataIdentifiers[0x24c1] = "Time expected to switch on the heating of the downstream sensor"
UDS_RDBI.dataIdentifiers[0x24c3] = "Slow adaptative term of the wastegate control"
UDS_RDBI.dataIdentifiers[0x24c4] = "Time expected to switch on the heating of the upstream sensor"
UDS_RDBI.dataIdentifiers[0x24c5] = "Variable table for throttle area curve"
UDS_RDBI.dataIdentifiers[0x24c9] = "Limp home position of the inlet throttle"
UDS_RDBI.dataIdentifiers[0x24d7] = "Manifold pressure value from model"
UDS_RDBI.dataIdentifiers[0x24dd] = "Variable table for throttle area curve 01"
UDS_RDBI.dataIdentifiers[0x24e0] = "24E1 24FF"
UDS_RDBI.dataIdentifiers[0x24e1] = "Manifold pressure from sensor"
UDS_RDBI.dataIdentifiers[0x24e5] = "Boost pressure PWM command gasoline"
UDS_RDBI.dataIdentifiers[0x2500] = "2501 2520"
UDS_RDBI.dataIdentifiers[0x2501] = "End of the first learning phase after first key on"
UDS_RDBI.dataIdentifiers[0x2502] = "Offset Deviation detected failure local counter"
UDS_RDBI.dataIdentifiers[0x2503] = "Request to relearn on next power latch phase"
UDS_RDBI.dataIdentifiers[0x2504] = "Springs check detected failure local counter"
UDS_RDBI.dataIdentifiers[0x2505] = "First Offset detected failure local counter"
UDS_RDBI.dataIdentifiers[0x2506] = "Progress in the heater strategy"
UDS_RDBI.dataIdentifiers[0x2507] = "Heater strategy indicator"
UDS_RDBI.dataIdentifiers[0x2514] = "PWM value for the sensor heater"
UDS_RDBI.dataIdentifiers[0x2515] = "Sensor internal temperature"
UDS_RDBI.dataIdentifiers[0x2516] = "Counter of correction application since beginning engine life or since after sale resetting"
UDS_RDBI.dataIdentifiers[0x2517] = "Correction curve for computing PCtl corrected by ATOL"
UDS_RDBI.dataIdentifiers[0x2518] = "Vector counter of learning points indexed by RCO"
UDS_RDBI.dataIdentifiers[0x2519] = "Exhaust gaz oxygen concentration"
UDS_RDBI.dataIdentifiers[0x251a] = "Upstream lambda sensor is heated"
UDS_RDBI.dataIdentifiers[0x251b] = "Mean value of internal upstream proportional sensor temperature in a window"
UDS_RDBI.dataIdentifiers[0x251d] = "Internal sensor temperature"
UDS_RDBI.dataIdentifiers[0x251e] = "Raw UEGO Air Fuel ratio measurement"
UDS_RDBI.dataIdentifiers[0x251f] = "Vehicle speed threshold detected"
UDS_RDBI.dataIdentifiers[0x2520] = "2540 2560"
UDS_RDBI.dataIdentifiers[0x2524] = "Pwm command for inlet throttle"
UDS_RDBI.dataIdentifiers[0x2529] = "Positive deviation diagnostic criteria"
UDS_RDBI.dataIdentifiers[0x252a] = "Negative deviation diagnostic criteria"
UDS_RDBI.dataIdentifiers[0x252d] = "Flag indicating a frozen signal from the exhaust manifold pressure sensor"
UDS_RDBI.dataIdentifiers[0x252f] = "Logic indicating if offset learning has done at least once"
UDS_RDBI.dataIdentifiers[0x2532] = "Turbocharger Compressor ByPass Valve command status"
UDS_RDBI.dataIdentifiers[0x2533] = "Command of manifold pressure calculated by the torque structure"
UDS_RDBI.dataIdentifiers[0x2536] = "First value of closed thrust position of the inlet throttle"
UDS_RDBI.dataIdentifiers[0x253d] = "Corrected tyre circumference"
UDS_RDBI.dataIdentifiers[0x253e] = "Displayed vehicle speed factor"
UDS_RDBI.dataIdentifiers[0x253f] = "Displayed vehicle speed offset"
UDS_RDBI.dataIdentifiers[0x2540] = "2521 2540"
UDS_RDBI.dataIdentifiers[0x2550] = "Radiator Valve"
UDS_RDBI.dataIdentifiers[0x2551] = "Chiller Valve"
UDS_RDBI.dataIdentifiers[0x2560] = "2561 2580"
UDS_RDBI.dataIdentifiers[0x2573] = "Double loop offset"
UDS_RDBI.dataIdentifiers[0x2580] = "2581 25A0"
UDS_RDBI.dataIdentifiers[0x25a0] = "25A1 25C0"
UDS_RDBI.dataIdentifiers[0x25b1] = "Absolute time since the first ignition"
UDS_RDBI.dataIdentifiers[0x25b2] = "Drive mode switch status detection"
UDS_RDBI.dataIdentifiers[0x25b9] = "Oil pressure mesured"
UDS_RDBI.dataIdentifiers[0x25bc] = "Max blow by counter value of last start"
UDS_RDBI.dataIdentifiers[0x25bd] = "Road slope value"
UDS_RDBI.dataIdentifiers[0x25c0] = "25C1 25E0"
UDS_RDBI.dataIdentifiers[0x25c1] = "Voltage setpoint given to the H bridge"
UDS_RDBI.dataIdentifiers[0x25c2] = "Voltage supplied to the Electro motorized Wastegate sensor"
UDS_RDBI.dataIdentifiers[0x25c3] = "PWM command asked to the Hbridge"
UDS_RDBI.dataIdentifiers[0x25c4] = "Absolute position setpoint really given to the RST controller"
UDS_RDBI.dataIdentifiers[0x25c5] = "Position setpoint used by the monitoring system"
UDS_RDBI.dataIdentifiers[0x25c6] = "Electrical wastegate position relative to the closed thrust"
UDS_RDBI.dataIdentifiers[0x25c7] = "value of the last open thrust position learnt"
UDS_RDBI.dataIdentifiers[0x25c8] = "value of the first open thrust position learnt"
UDS_RDBI.dataIdentifiers[0x25c9] = "value of the open thrust position used by the regulation system"
UDS_RDBI.dataIdentifiers[0x25ca] = "value of the last closed thrust position learnt"
UDS_RDBI.dataIdentifiers[0x25cb] = "value of the first closed thrust position learnt"
UDS_RDBI.dataIdentifiers[0x25cc] = "value of the closed thrust position used by the regulation system"
UDS_RDBI.dataIdentifiers[0x25cd] = "Last measured analogic value of the Electro motorized Wastegate position"
UDS_RDBI.dataIdentifiers[0x25ce] = "Electro motorized Wastegate absolute position in percent of the sensor supply voltage"
UDS_RDBI.dataIdentifiers[0x25cf] = "Number of first offset learning failures noticed on successive driving cycles open thrust Stored in EEPROM"
UDS_RDBI.dataIdentifiers[0x25d0] = "Number of first offset learning failures noticed on successive driving cycles closed thrust Stored in EEPROM"
UDS_RDBI.dataIdentifiers[0x25d1] = "Number of dirty closed thrust failures noticed on successive driving cycles Stored in EEPROM"
UDS_RDBI.dataIdentifiers[0x25d2] = "Indicates that the first learning of the open pos has been done If 1 learning is done"
UDS_RDBI.dataIdentifiers[0x25d3] = "Indicates that the first learning of the closed pos has been done If 1 learning is done"
UDS_RDBI.dataIdentifiers[0x25d4] = "Air flap set point"
UDS_RDBI.dataIdentifiers[0x25d5] = "Catalyst diagnosis criteria"
UDS_RDBI.dataIdentifiers[0x25d6] = "Circulation request of the coolant for engine"
UDS_RDBI.dataIdentifiers[0x25d8] = "By pass activation for Air flaps command"
UDS_RDBI.dataIdentifiers[0x25d9] = "Air flaps command value"
UDS_RDBI.dataIdentifiers[0x25e0] = "25E1 2600"
UDS_RDBI.dataIdentifiers[0x2600] = "K T BattPackHighTemp Cal"  	 # or 2601 2620
UDS_RDBI.dataIdentifiers[0x2601] = "K T BattPackHighTempHys Cal"
UDS_RDBI.dataIdentifiers[0x2602] = "K T BattFanHighDeltaTemp Cal"
UDS_RDBI.dataIdentifiers[0x2603] = "K T BattFanHighDeltaTempHys Cal"
UDS_RDBI.dataIdentifiers[0x2620] = "2621 2640"
UDS_RDBI.dataIdentifiers[0x2800] = "EGFP Raw EGFP Raw"  	 # or EgfAgSnsr1Volt volt, 2801 2820
UDS_RDBI.dataIdentifiers[0x2801] = "EgfPosnCtl percSp"  	 # or EGFP SetVal
UDS_RDBI.dataIdentifiers[0x2802] = "SCRT SCRT"
UDS_RDBI.dataIdentifiers[0x2803] = "LEGRT Raw LEGRT Raw"
UDS_RDBI.dataIdentifiers[0x2804] = "EGT"  	 # or Transmission High Side Driver 1 Control Circuit, EGT EGT, Main injection period
UDS_RDBI.dataIdentifiers[0x2805] = "DT LEGRT LEGRT"  	 # or Transmission High Side Driver 2 Control Circuit, LEGRT
UDS_RDBI.dataIdentifiers[0x2806] = "LEGRT OBD LEGRT OBD"
UDS_RDBI.dataIdentifiers[0x2807] = "DPFLR PDiff Raw"  	 # or Ignition advance, LEGR PDiff Raw LEGR PDiff Raw
UDS_RDBI.dataIdentifiers[0x2808] = "Main injection advance"  	 # or LEGR Pdiff LEGR PDiff, DPFLR Pdiff
UDS_RDBI.dataIdentifiers[0x2809] = "LEGR PDiff OBD LEGR PDiff OBD"  	 # or Main injection quantity, DPFLR PDiff OBD
UDS_RDBI.dataIdentifiers[0x280a] = "Pre injection 1 quantity"  	 # or ECT, ECT ECT
UDS_RDBI.dataIdentifiers[0x280b] = "AAP"  	 # or Pre injection 2 quantity, AAP AAP
UDS_RDBI.dataIdentifiers[0x280c] = "EGP"  	 # or EGP EGP, After injection quantity
UDS_RDBI.dataIdentifiers[0x280d] = "EGFP Trnsp EGFP Trnsp"  	 # or Post injection quantity, EgfPosnCtl percSpDtm, Transmission Control Module Substrate Temperature
UDS_RDBI.dataIdentifiers[0x280e] = "EGFC LrndLoPosn EGFC LrndLoPosn"  	 # or Late post injection quantity
UDS_RDBI.dataIdentifiers[0x280f] = "EGFC LrndUpPosn EGFC LrndUpPosn"
UDS_RDBI.dataIdentifiers[0x2810] = "Pre injection 1 desired time"  	 # or Eng Trq Eng Trq, Eng Trq
UDS_RDBI.dataIdentifiers[0x2811] = "Exhaust gas flap Out"  	 # or Pre injection 2 desired time, Pressure Control Solenoid 1 Output, EGFC Out
UDS_RDBI.dataIdentifiers[0x2812] = "TSPC Med TSPC Med"  	 # or After injection desired time, TSPC Med, Pressure Control Solenoid 2 Output
UDS_RDBI.dataIdentifiers[0x2813] = "TSPC EngStart"  	 # or Pressure Control Solenoid 3 Output, TSPC EngStart Mode TSPC EngStart, Post injection angle
UDS_RDBI.dataIdentifiers[0x2814] = "LEGRFP Raw LEGRFP Raw"  	 # or Pressure Control Solenoid 4 Output, EgrfAgSnsr1Volt volt
UDS_RDBI.dataIdentifiers[0x2815] = "Klemme87 Ruckmeldeleitung Read Klemme87 Ruckmeldeleitung"  	 # or Pressure Control Solenoid 5 Output
UDS_RDBI.dataIdentifiers[0x2817] = "Pressure Control Solenoid 1 Commanded Pressure"
UDS_RDBI.dataIdentifiers[0x2818] = "Pressure Control Solenoid 2 Commanded Pressure"
UDS_RDBI.dataIdentifiers[0x2819] = "Pressure Control Solenoid 3 Commanded Pressure"
UDS_RDBI.dataIdentifiers[0x281a] = "Pressure Control Solenoid 4 Commanded Pressure"
UDS_RDBI.dataIdentifiers[0x281b] = "Pressure Control Solenoid 5 Commanded Pressure"  	 # or low level
UDS_RDBI.dataIdentifiers[0x281c] = "Gas pump command state"
UDS_RDBI.dataIdentifiers[0x281d] = "Transmission Pressure Switch"
UDS_RDBI.dataIdentifiers[0x281e] = "X-Valve Solenoid"
UDS_RDBI.dataIdentifiers[0x281f] = "Y-Valve Solenoid"
UDS_RDBI.dataIdentifiers[0x2820] = "2821 2840"
UDS_RDBI.dataIdentifiers[0x2822] = "TISS/TOSS Regulated Voltage Supply"  	 # or Canister drain valve command
UDS_RDBI.dataIdentifiers[0x2824] = "Transmission Cleaning Procedure"
UDS_RDBI.dataIdentifiers[0x2826] = "Transmission Control Module Restart Sensor Temperature"
UDS_RDBI.dataIdentifiers[0x2827] = "MCPA Motor B Temperature"
UDS_RDBI.dataIdentifiers[0x2828] = "MCPB Motor A Temperature"
UDS_RDBI.dataIdentifiers[0x2829] = "MCPA Motor B Current Commanded"
UDS_RDBI.dataIdentifiers[0x282a] = "MCPB Motor A Current Commanded"
UDS_RDBI.dataIdentifiers[0x282b] = "Motor A Current Actual"
UDS_RDBI.dataIdentifiers[0x282c] = "Motor B Current Actual"
UDS_RDBI.dataIdentifiers[0x2831] = "MCPA Motor B Phase A Current"
UDS_RDBI.dataIdentifiers[0x2832] = "MCPB Motor A Phase A Current"
UDS_RDBI.dataIdentifiers[0x2835] = "MCPA Motor B Phase B Current"
UDS_RDBI.dataIdentifiers[0x2836] = "MCPB Motor A Phase B Current"
UDS_RDBI.dataIdentifiers[0x2839] = "MCPA Motor B Phase C Current"
UDS_RDBI.dataIdentifiers[0x283a] = "MCPB Motor A Phase C Current"
UDS_RDBI.dataIdentifiers[0x283f] = "MCPA Motor B Temperature Sensor A/D"  	 # or System diagnosis criterion global deviation of richness closed loop control
UDS_RDBI.dataIdentifiers[0x2840] = "MCPB Motor A Temperature Sensor A/D"  	 # or 2841 2860
UDS_RDBI.dataIdentifiers[0x2841] = "MCPA Motor B Torque Commanded"
UDS_RDBI.dataIdentifiers[0x2842] = "MCPB Motor A Torque Commanded"  	 # or Misfire counter cylinder 2
UDS_RDBI.dataIdentifiers[0x2843] = "Misfire counter cylinder 3"  	 # or MCPA Motor B Torque Actual
UDS_RDBI.dataIdentifiers[0x2844] = "MCPB Motor A Torque Actual"
UDS_RDBI.dataIdentifiers[0x2847] = "System Mode Commanded"
UDS_RDBI.dataIdentifiers[0x2848] = "Knock counter detection cylinder 2"  	 # or System Mode Actual
UDS_RDBI.dataIdentifiers[0x2849] = "Knock counter detection cylinder 3"
UDS_RDBI.dataIdentifiers[0x284a] = "Transmission"
UDS_RDBI.dataIdentifiers[0x284b] = "MCPA Motor B Speed Actual"
UDS_RDBI.dataIdentifiers[0x284c] = "MCPB Motor A Speed Actual"
UDS_RDBI.dataIdentifiers[0x284d] = "Mean knock noise"  	 # or MCPA Motor B Angle - Resolver Absolute Position
UDS_RDBI.dataIdentifiers[0x284e] = "MCPB Motor A Angle - Resolver Absolute Position"  	 # or Richness regulation status
UDS_RDBI.dataIdentifiers[0x284f] = "MCPA Motor B Speed Sensor Position Offset"  	 # or Richness regulation status bank
UDS_RDBI.dataIdentifiers[0x2850] = "Richness regulation correction"  	 # or MCPB Motor A Speed Sensor Position Offset
UDS_RDBI.dataIdentifiers[0x2851] = "Transmission C1 Clutch Slip"
UDS_RDBI.dataIdentifiers[0x2852] = "Transmission C2 Clutch Slip"
UDS_RDBI.dataIdentifiers[0x2853] = "Transmission C3 Clutch Slip"
UDS_RDBI.dataIdentifiers[0x2854] = "Transmission C4 Clutch Slip"  	 # or Injection time cylinder 1 1st injection
UDS_RDBI.dataIdentifiers[0x2855] = "Injection time cylinder 2 1st injection"  	 # or Transmission Clutch
UDS_RDBI.dataIdentifiers[0x2856] = "Injection time cylinder 3 1st injection"
UDS_RDBI.dataIdentifiers[0x2857] = "Injection time cylinder 4 1st injection"
UDS_RDBI.dataIdentifiers[0x2858] = "Motor Control"
UDS_RDBI.dataIdentifiers[0x2859] = "Pressure Control Solenoid 6 Output"
UDS_RDBI.dataIdentifiers[0x285a] = "Opening angle cylinder 1 1st injection"  	 # or Pressure Control Solenoid 6 Commanded Pressure
UDS_RDBI.dataIdentifiers[0x285b] = "Opening angle cylinder 2 1st injection"
UDS_RDBI.dataIdentifiers[0x285c] = "Opening angle cylinder 3 1st injection"
UDS_RDBI.dataIdentifiers[0x285d] = "Opening angle cylinder 4 1st injection"
UDS_RDBI.dataIdentifiers[0x285e] = "Maximum ignition timing correction of the slow loop for all the cylinders"
UDS_RDBI.dataIdentifiers[0x285f] = "Adaptation offset on injection time"
UDS_RDBI.dataIdentifiers[0x2860] = "2861 2880"
UDS_RDBI.dataIdentifiers[0x2861] = "Gas pump priming state"
UDS_RDBI.dataIdentifiers[0x2862] = "Gas pump priming done"
UDS_RDBI.dataIdentifiers[0x2863] = "Minimum gap compared to the initial linear"
UDS_RDBI.dataIdentifiers[0x2864] = "Maximum gap compared to the initial linear"
UDS_RDBI.dataIdentifiers[0x2865] = "Boolean for information at least one learning in the zone"
UDS_RDBI.dataIdentifiers[0x2866] = "4 of the 5 zones engine learned"
UDS_RDBI.dataIdentifiers[0x2867] = "Learning counter to adaptive least square method"
UDS_RDBI.dataIdentifiers[0x2869] = "Injection time cylinder 1 2nd injection"
UDS_RDBI.dataIdentifiers[0x286a] = "Injection time cylinder 2 2nd injection"
UDS_RDBI.dataIdentifiers[0x286b] = "Injection time cylinder 3 2nd injection"
UDS_RDBI.dataIdentifiers[0x286c] = "Injection time cylinder 4 2nd injection"
UDS_RDBI.dataIdentifiers[0x286d] = "Opening angle cylinder 1 2nd injection"
UDS_RDBI.dataIdentifiers[0x286e] = "Opening angle cylinder 2 2nd injection"
UDS_RDBI.dataIdentifiers[0x286f] = "Opening angle cylinder 3 2nd injection"
UDS_RDBI.dataIdentifiers[0x2870] = "Opening angle cylinder 4 2nd injection"
UDS_RDBI.dataIdentifiers[0x2871] = "Piloted thermostat PWM command"
UDS_RDBI.dataIdentifiers[0x2872] = "Corrective factor depending on exotic fuel quantity For injection time"
UDS_RDBI.dataIdentifiers[0x2873] = "Corrected average ALFACL for memorized fuel system diagnostic"
UDS_RDBI.dataIdentifiers[0x2874] = "Misfire counter"
UDS_RDBI.dataIdentifiers[0x2875] = "External controls denial status flag"
UDS_RDBI.dataIdentifiers[0x2876] = "4 first column of the pre control working matrix stored in EEPROM"
UDS_RDBI.dataIdentifiers[0x2877] = "4 last column of the pre control working matrix stored in EEPROM"
UDS_RDBI.dataIdentifiers[0x287b] = "Final alcohol adaptive"
UDS_RDBI.dataIdentifiers[0x287c] = "value of the counter of slow alcohol adaptive computing phases"
UDS_RDBI.dataIdentifiers[0x287d] = "Low limit of the adaptive"
UDS_RDBI.dataIdentifiers[0x287e] = "High limit of the adaptive"
UDS_RDBI.dataIdentifiers[0x287f] = "Memorized variable of the fuel level"
UDS_RDBI.dataIdentifiers[0x2880] = "2881 28A0"
UDS_RDBI.dataIdentifiers[0x2881] = "Alcohol rate for the after sell"
UDS_RDBI.dataIdentifiers[0x2884] = "Minimum level of the additional fuel tank detected"
UDS_RDBI.dataIdentifiers[0x2887] = "PWM of fuel pump actuator"
UDS_RDBI.dataIdentifiers[0x2888] = "PCU pwm feedback"
UDS_RDBI.dataIdentifiers[0x288d] = "Minimum gap compared to the initial linear Write 2"
UDS_RDBI.dataIdentifiers[0x288e] = "Maximum gap compared to the initial linear Write 2"
UDS_RDBI.dataIdentifiers[0x288f] = "Activation request of mastervac factory diagnostic sequence at first power supply of ECU"
UDS_RDBI.dataIdentifiers[0x2890] = "Mastervac pressure switch state"
UDS_RDBI.dataIdentifiers[0x2891] = "Mastervac vacuum pump activation request"
UDS_RDBI.dataIdentifiers[0x2892] = "Cumulative run time for mastervac vacuum pump"
UDS_RDBI.dataIdentifiers[0x2893] = "Mastervac pressure received on CAN"
UDS_RDBI.dataIdentifiers[0x2897] = "Turbo water pump configuration boolean"
UDS_RDBI.dataIdentifiers[0x28a0] = "28A1 28C0"
UDS_RDBI.dataIdentifiers[0x28a1] = "Cloture advance of split injection"
UDS_RDBI.dataIdentifiers[0x28a2] = "Cloture advance of main injection in regulation mode"
UDS_RDBI.dataIdentifiers[0x28a3] = "Mass to be injected on cylinder 1 on pulse 1 of injection"
UDS_RDBI.dataIdentifiers[0x28a4] = "Mass to be injected on cylinder 1 on pulse 2 of injection"
UDS_RDBI.dataIdentifiers[0x28a5] = "Mass to be injected on cylinder 2 on pulse 1 of injection"
UDS_RDBI.dataIdentifiers[0x28a6] = "Mass to be injected on cylinder 2 on pulse 2 of injection"
UDS_RDBI.dataIdentifiers[0x28a7] = "Mass to be injected on cylinder 3 on pulse 1 of injection"
UDS_RDBI.dataIdentifiers[0x28a8] = "Mass to be injected on cylinder 3 on pulse 2 of injection"
UDS_RDBI.dataIdentifiers[0x28a9] = "Mass to be injected on cylinder 4 on pulse 1 of injection"
UDS_RDBI.dataIdentifiers[0x28aa] = "Mass to be injected on cylinder 4 on pulse 2 of injection"
UDS_RDBI.dataIdentifiers[0x28ab] = "Gasoline to LPG transition"
UDS_RDBI.dataIdentifiers[0x28ac] = "Gasoline mode"
UDS_RDBI.dataIdentifiers[0x28ad] = "LPG to Gasoline transition"
UDS_RDBI.dataIdentifiers[0x28ae] = "LPG mode"
UDS_RDBI.dataIdentifiers[0x28af] = "LPG Fuel low level"
UDS_RDBI.dataIdentifiers[0x28b0] = "LPG Switch Position"
UDS_RDBI.dataIdentifiers[0x28b1] = "Gas temperature manifold level"
UDS_RDBI.dataIdentifiers[0x28b2] = "Boolean for setting to zero the two fuel mass corrections"
UDS_RDBI.dataIdentifiers[0x28b3] = "Boolean to reset to calibrated values the learned map and the learning counter"
UDS_RDBI.dataIdentifiers[0x28b4] = "First vector of open loop map for fuel injected mass correction"
UDS_RDBI.dataIdentifiers[0x28b5] = "Second vector of open loop map for fuel injected mass correction"
UDS_RDBI.dataIdentifiers[0x28b6] = "Third vector of open loop map for fuel injected mass correction"
UDS_RDBI.dataIdentifiers[0x28b7] = "Fourth vector of open loop map for fuel injected mass correction"
UDS_RDBI.dataIdentifiers[0x28b8] = "Fifth vector of open loop map for fuel injected mass correction"
UDS_RDBI.dataIdentifiers[0x28b9] = "Sixth vector of open loop map for fuel injected mass correction"
UDS_RDBI.dataIdentifiers[0x28ba] = "Seventh vector of open loop map for fuel injected mass correction"
UDS_RDBI.dataIdentifiers[0x28bb] = "Eighth vector of open loop map for fuel injected mass correction"
UDS_RDBI.dataIdentifiers[0x28bc] = "Counter of fuel injected mass correction learning events"
UDS_RDBI.dataIdentifiers[0x28bd] = "GDI Fuel Rail Pressure"
UDS_RDBI.dataIdentifiers[0x28be] = "Rail pressure setpoint"
UDS_RDBI.dataIdentifiers[0x28bf] = "Long Term Fuel Trim Bank"
UDS_RDBI.dataIdentifiers[0x28c0] = "28C1 28E0"
UDS_RDBI.dataIdentifiers[0x28c1] = "Indicator relative to vehicle acceleration for economical scoring"
UDS_RDBI.dataIdentifiers[0x28c2] = "Indicator relative to anticipation for economical scoring"
UDS_RDBI.dataIdentifiers[0x28c3] = "Indicator relative to GSI respect for economical scoring"
UDS_RDBI.dataIdentifiers[0x28c4] = "Indicator of economical monitoring"
UDS_RDBI.dataIdentifiers[0x28c5] = "A F Ratio"
UDS_RDBI.dataIdentifiers[0x28c6] = "Global injected fuel mass request"
UDS_RDBI.dataIdentifiers[0x28c7] = "air flaps PWM command Read air flaps PWM command"
UDS_RDBI.dataIdentifiers[0x28d2] = "Mux Network configuration detection EMCU Control Unit status"
UDS_RDBI.dataIdentifiers[0x28d3] = "Air flaps initialization sequence activation"
UDS_RDBI.dataIdentifiers[0x28d4] = "DMS order Normal sport"
UDS_RDBI.dataIdentifiers[0x28d6] = "RS mode request Normal sport or Race"
UDS_RDBI.dataIdentifiers[0x28d7] = "Commercial engine power display"
UDS_RDBI.dataIdentifiers[0x28d8] = "Begin high stroke sensor is activated"
UDS_RDBI.dataIdentifiers[0x28d9] = "State of the begin high of the clutch pedal 0 pedal released 1 pedal pressed"
UDS_RDBI.dataIdentifiers[0x28da] = "Wire begin high clutch contactor state"
UDS_RDBI.dataIdentifiers[0x28dd] = "After sale alternator voltage set point"
UDS_RDBI.dataIdentifiers[0x28df] = "Filtered alternator rotor current"
UDS_RDBI.dataIdentifiers[0x28e0] = "28E1 2900"
UDS_RDBI.dataIdentifiers[0x28e1] = "Alternator load"
UDS_RDBI.dataIdentifiers[0x28fc] = "Command of the drain cut valve for the EVAP diagnosis"
UDS_RDBI.dataIdentifiers[0x2900] = "2901 2920"
UDS_RDBI.dataIdentifiers[0x291b] = "Water pump water charge command state"
UDS_RDBI.dataIdentifiers[0x291c] = "ADOC configuration"
UDS_RDBI.dataIdentifiers[0x291d] = "ignition advance state"
UDS_RDBI.dataIdentifiers[0x291e] = "State counter value for each RON level"
UDS_RDBI.dataIdentifiers[0x2920] = "2921 2940"
UDS_RDBI.dataIdentifiers[0x2921] = "FAN 1 activation"
UDS_RDBI.dataIdentifiers[0x2922] = "FAN 2 activation"
UDS_RDBI.dataIdentifiers[0x2923] = "Mux Network configuration detection AIRBAG status"
UDS_RDBI.dataIdentifiers[0x2924] = "Airbag crash status"
UDS_RDBI.dataIdentifiers[0x2925] = "State of rear motor fan thermic activation request"
UDS_RDBI.dataIdentifiers[0x2926] = "Controlled rear motor fan applied command"
UDS_RDBI.dataIdentifiers[0x2927] = "Motor driven fan setpoint"
UDS_RDBI.dataIdentifiers[0x2928] = "Functionnal state of the vehicle with Stop and Start system"
UDS_RDBI.dataIdentifiers[0x2929] = "Functionnal state of the vehicle with Stop and Start system 01"
UDS_RDBI.dataIdentifiers[0x292c] = "Starter status 01"
UDS_RDBI.dataIdentifiers[0x2932] = "Median of pressures whose sensors are liable to rationality diagnosis"
UDS_RDBI.dataIdentifiers[0x2933] = "median of temperatures whose sensors are liable to rationality diagnosis"
UDS_RDBI.dataIdentifiers[0x2934] = "Boolean indicating that upstream lambda heater close loop control is enabled"
UDS_RDBI.dataIdentifiers[0x2939] = "The alcohol rate jump learning is activated"
UDS_RDBI.dataIdentifiers[0x293a] = "Total vehicle distance when the last learning process finished"
UDS_RDBI.dataIdentifiers[0x293b] = "Alcohol rate of the new fuel put into the tank"
UDS_RDBI.dataIdentifiers[0x293c] = "Percentage of the new fuel in the tank"
UDS_RDBI.dataIdentifiers[0x293d] = "Quantity of fuel consumed since last alcohol rate learning process"
UDS_RDBI.dataIdentifiers[0x293e] = "Quantity of fuel consumed since last tank fill up"
UDS_RDBI.dataIdentifiers[0x293f] = "Value of the alcohol adaptive before the tank filling"
UDS_RDBI.dataIdentifiers[0x2940] = "2941 2960"
UDS_RDBI.dataIdentifiers[0x2941] = "Boolean to indicate that there is a possible change of fuel in course"
UDS_RDBI.dataIdentifiers[0x2945] = "Drive door state"
UDS_RDBI.dataIdentifiers[0x2946] = "Drive seat state"
UDS_RDBI.dataIdentifiers[0x2947] = "Engine hood state"
UDS_RDBI.dataIdentifiers[0x2948] = "Drive seat belt reminder"
UDS_RDBI.dataIdentifiers[0x2949] = "Stop and Start status parameters"
UDS_RDBI.dataIdentifiers[0x294d] = "Warning automatic stop engine"
UDS_RDBI.dataIdentifiers[0x294e] = "Technical start request"
UDS_RDBI.dataIdentifiers[0x294f] = "Vehicle will not moving"
UDS_RDBI.dataIdentifiers[0x2951] = "Stop auto exit"
UDS_RDBI.dataIdentifiers[0x2953] = "Inhibition of Stop Start by a diag tool request"
UDS_RDBI.dataIdentifiers[0x2954] = "Vehicle whit key or keyless vehicle"
UDS_RDBI.dataIdentifiers[0x2955] = "Stop auto inhibition via automatic air conditioner"
UDS_RDBI.dataIdentifiers[0x2956] = "Begin stroke clutch pedal switch"
UDS_RDBI.dataIdentifiers[0x2958] = "state of charge"
UDS_RDBI.dataIdentifiers[0x2959] = "Automatic Start requested by driver"
UDS_RDBI.dataIdentifiers[0x2960] = "2961 2980"
UDS_RDBI.dataIdentifiers[0x2980] = "2981 29A0"
UDS_RDBI.dataIdentifiers[0x298f] = "Displaying of Stop and Start request 01"
UDS_RDBI.dataIdentifiers[0x2990] = "Maximum duration the engine can stay automatically stopped"
UDS_RDBI.dataIdentifiers[0x2991] = "Ambiant pressure high threshold below which auto stop is forbidden"
UDS_RDBI.dataIdentifiers[0x2992] = "Ambiant pressure low threshold below which auto stop is forbidden"
UDS_RDBI.dataIdentifiers[0x2993] = "Minimum speed threshold to go to StopAuto after a deactivation of 4WD function"
UDS_RDBI.dataIdentifiers[0x2994] = "Maximum delay to confirm a StopAuto request by the driver by braking pressure"
UDS_RDBI.dataIdentifiers[0x2995] = "Delay before prompting auto stop MMI"
UDS_RDBI.dataIdentifiers[0x2996] = "Maximun number of start for the high pressure pump to inhibite Stop and start"
UDS_RDBI.dataIdentifiers[0x2997] = "Maximum slope value to authorize StopAuto negative value"
UDS_RDBI.dataIdentifiers[0x2998] = "Maximum slope value to authorize StopAuto positive value"
UDS_RDBI.dataIdentifiers[0x2999] = "Delay to detect rear gear engaged"
UDS_RDBI.dataIdentifiers[0x299a] = "Maximun number of activation of starter to inhibite Stop and start"
UDS_RDBI.dataIdentifiers[0x299b] = "Maximal environment temperature inhibiting the StopAuto"
UDS_RDBI.dataIdentifiers[0x299c] = "Maximal environment temperature authorising the StopAuto"
UDS_RDBI.dataIdentifiers[0x299d] = "Minimal environment temperature inhibiting the StopAuto"
UDS_RDBI.dataIdentifiers[0x299e] = "Minimal environment temperature authorising the StopAuto"
UDS_RDBI.dataIdentifiers[0x299f] = "Maximum vehicle speed to keep the engine automatically stopped"
UDS_RDBI.dataIdentifiers[0x29a0] = "29A1 29C0"
UDS_RDBI.dataIdentifiers[0x29a1] = "Delay to confirm that the vehicle is stoped consolidation of slope value"
UDS_RDBI.dataIdentifiers[0x29a2] = "Vehicle speed threshold to validate the minimum travel conditions"
UDS_RDBI.dataIdentifiers[0x29a3] = "Vehicle speed threshold to validate the minimum travel conditions in rear detected"
UDS_RDBI.dataIdentifiers[0x29a4] = "Vehicle speed threshold to authorize automatic stop"
UDS_RDBI.dataIdentifiers[0x29a7] = "StopAuto status StopAutoPhase"
UDS_RDBI.dataIdentifiers[0x29a9] = "Gear lever position received on the CAN"
UDS_RDBI.dataIdentifiers[0x29b0] = "CC strategy requested by the driver for Daimler type"
UDS_RDBI.dataIdentifiers[0x29b1] = "CC Main Switch Coherence detected failure for Daimler type"
UDS_RDBI.dataIdentifiers[0x29c0] = "29C1 29E0"
UDS_RDBI.dataIdentifiers[0x29e0] = "29E1 2A00"
UDS_RDBI.dataIdentifiers[0x29e1] = "Distance driven since HBN initialization"
UDS_RDBI.dataIdentifiers[0x29e2] = "Misfire bench mode activation boolean"
UDS_RDBI.dataIdentifiers[0x29e3] = "Rate of Misfire bench mode"
UDS_RDBI.dataIdentifiers[0x29e5] = "Bench value to adapt richness on all cylinders"
UDS_RDBI.dataIdentifiers[0x29e6] = "Delay before authorizing richness closed loop after start bench mode required for homologation"
UDS_RDBI.dataIdentifiers[0x29e7] = "Boolean enabling the canister purge fault bench mode"
UDS_RDBI.dataIdentifiers[0x29e8] = "Mastervac vacuum relative pressure by analog sensor"
UDS_RDBI.dataIdentifiers[0x29e9] = "The weighted average voltage of master vacuum absolute pressure sensor"
UDS_RDBI.dataIdentifiers[0x2c00] = "2C01 2C20"
UDS_RDBI.dataIdentifiers[0x2c03] = "Targetted gear engaged"
UDS_RDBI.dataIdentifiers[0x2c04] = "Auxiliary Transmission Pump Speed Commanded"  	 # or gear engaged
UDS_RDBI.dataIdentifiers[0x2c05] = "Auxiliary Transmission Pump Speed Actual"
UDS_RDBI.dataIdentifiers[0x2c06] = "Auxiliary Transmission Pump Fault"
UDS_RDBI.dataIdentifiers[0x2c20] = "2C21 2C40"
UDS_RDBI.dataIdentifiers[0x2c2c] = "Kick down state"
UDS_RDBI.dataIdentifiers[0x2c40] = "2C41 2C60"
UDS_RDBI.dataIdentifiers[0x2c4f] = "ACC steering wheel commands validity transmitted to ACC ECU"
UDS_RDBI.dataIdentifiers[0x2c50] = "ACC steering wheel commands transmitted to ACC ECU"
UDS_RDBI.dataIdentifiers[0x2c51] = "ACC speed limiter main switch position transmitted to ACC ECU"
UDS_RDBI.dataIdentifiers[0x2c57] = "Driving gear on active shaft"
UDS_RDBI.dataIdentifiers[0x2c58] = "Clutch torque"
UDS_RDBI.dataIdentifiers[0x2c59] = "State of active clutch"
UDS_RDBI.dataIdentifiers[0x2c5b] = "Request to authorize the cranking according to the gear lever position and internal diagnosis of the ATCU"
UDS_RDBI.dataIdentifiers[0x2c5c] = "Automatic transmission range output for display"
UDS_RDBI.dataIdentifiers[0x2c5d] = "Target gear for active shaft"
UDS_RDBI.dataIdentifiers[0x2c60] = "2C61 2C80"
UDS_RDBI.dataIdentifiers[0x2c80] = "2C81 2CA0"
UDS_RDBI.dataIdentifiers[0x2c9b] = "Automatic Transmission output shaft revolution speed"
UDS_RDBI.dataIdentifiers[0x2d00] = "2D01 2D20"
UDS_RDBI.dataIdentifiers[0x2d40] = "2D41 2D60"
UDS_RDBI.dataIdentifiers[0x2d80] = "2D81 2DA0"
UDS_RDBI.dataIdentifiers[0x2e00] = "2E01 2E20"
UDS_RDBI.dataIdentifiers[0x2e01] = "IOC TCU Outputs ECall LED"
UDS_RDBI.dataIdentifiers[0x2e02] = "IOC TCU Antennas Active Phone Antenna"
UDS_RDBI.dataIdentifiers[0x2f01] = "OMA DM Server URL"
UDS_RDBI.dataIdentifiers[0x2f02] = "Vehicle Configuration"
UDS_RDBI.dataIdentifiers[0x2f03] = "ATP Base URL"
UDS_RDBI.dataIdentifiers[0x2f04] = "SMS Destinations"
UDS_RDBI.dataIdentifiers[0x2f05] = "Call Numbers"
UDS_RDBI.dataIdentifiers[0x2f06] = "Service Call Provider"
UDS_RDBI.dataIdentifiers[0x2f07] = "HU Connectiivity WCC settings"
UDS_RDBI.dataIdentifiers[0x2f08] = "ATP RCS URL"
UDS_RDBI.dataIdentifiers[0x2f09] = "APN URLs"
UDS_RDBI.dataIdentifiers[0x2f0a] = "MTU Size"
UDS_RDBI.dataIdentifiers[0x2f0b] = "Internet Connectivity Settings"
UDS_RDBI.dataIdentifiers[0x2f0c] = "Independent car heating settings"
UDS_RDBI.dataIdentifiers[0x2f0d] = "APN settings"
UDS_RDBI.dataIdentifiers[0x2fc1] = "freigegebene Schluessellinien"
UDS_RDBI.dataIdentifiers[0x2fd1] = "Schluessel Set Identification SSID"
UDS_RDBI.dataIdentifiers[0x2fe1] = "Zentralverriegelung Status gespeicherter Status Kofferraum"
UDS_RDBI.dataIdentifiers[0x2ff1] = "Pattern fuer HF Patternvergleich Testpattern Block1"
UDS_RDBI.dataIdentifiers[0x3000] = "Thatcham Einschalten Ausschalten Anfrage THATCHAM"
UDS_RDBI.dataIdentifiers[0x3001] = "Thatcham passive Linien Linie"
UDS_RDBI.dataIdentifiers[0x3004] = "Digitale Schalterleisten \"High\" erkannt Leiste"
UDS_RDBI.dataIdentifiers[0x3005] = "HU Connectivity USB Status State"
UDS_RDBI.dataIdentifiers[0x3006] = "NVLD Switch"  	 # or Digitale Schalterleisten \"Low\" erkannt Leiste
UDS_RDBI.dataIdentifiers[0x3008] = "IP Addresses IP Address Type Data Radio Bearer"  	 # or Zuendung Klemme15 Read Response Parameters Zuendung Klemme15
UDS_RDBI.dataIdentifiers[0x3009] = "Zuendung Klemme15 plausibilisiert"
UDS_RDBI.dataIdentifiers[0x300f] = "APN Users"
UDS_RDBI.dataIdentifiers[0x3010] = "Gangsensor SG Vertikal 1 ROH"  	 # or APN Passwords, Motoroelschalter
UDS_RDBI.dataIdentifiers[0x3011] = "Kraftstoffanforderung HW"  	 # or Kickdownschalter / -erkennung, Gangsensor SG Vertikal 2 ROH, System Time, System Time UTC Unix Time Stamp Format
UDS_RDBI.dataIdentifiers[0x3012] = "Bremsschalter"  	 # or Gangsensor SG Neutrallage
UDS_RDBI.dataIdentifiers[0x3013] = "Bremslichtschalter"
UDS_RDBI.dataIdentifiers[0x3014] = "Kupplungsschalter"
UDS_RDBI.dataIdentifiers[0x3015] = "Crashsignal Ueber HW LTG Flag"
UDS_RDBI.dataIdentifiers[0x3016] = "Zuendung Klemme 15 Read Zuendung Klemme15"  	 # or Zuendung Klemme15 P L Ignition switch, Zuendung Klemme15 PRES Nein Ja
UDS_RDBI.dataIdentifiers[0x3017] = "Motoroelfuellstandschalter"
UDS_RDBI.dataIdentifiers[0x3018] = "Kickdownschalter"
UDS_RDBI.dataIdentifiers[0x3019] = "EV Delay Timer"  	 # or Klemme50 Starter, Kupplungsschalter oben (Ein, EV Delay Timer CpcSyncDelayTimer
UDS_RDBI.dataIdentifiers[0x301c] = "CEP Server URL"
UDS_RDBI.dataIdentifiers[0x301d] = "NTP URL Pool"
UDS_RDBI.dataIdentifiers[0x301e] = "RTMATPbaseURL"
UDS_RDBI.dataIdentifiers[0x3020] = "Waehlhebel Fahrstufe Motorfernstart"
UDS_RDBI.dataIdentifiers[0x3021] = "Waehlhebel Fahrstufe"
UDS_RDBI.dataIdentifiers[0x3022] = "Maintenance Management Weighting Factors divisor weighting factor"  	 # or Tumbleklappenschalter 1 Spannung, Maintenance Management Weighting Factors
UDS_RDBI.dataIdentifiers[0x3023] = "Tumbleklappenschalter 2 Spannung"
UDS_RDBI.dataIdentifiers[0x3024] = "Schutzeinrichtung Motorhabenkontaktschalter"  	 # or E Call Parameter AUTOMATIC KEYLOCK TIMER, E Call Parameter
UDS_RDBI.dataIdentifiers[0x3025] = "VIN Mapping"  	 # or VIN Mapping Entry, Getriebetyp Automatik
UDS_RDBI.dataIdentifiers[0x3030] = "Abgasklappe Endstufe Spannung"
UDS_RDBI.dataIdentifiers[0x3031] = "Abgasklappe Winkelsensor Spannung"
UDS_RDBI.dataIdentifiers[0x3032] = "Klimaanlagen Schalter"  	 # or Sensor Versorgungsspannung
UDS_RDBI.dataIdentifiers[0x3034] = "Tempomat"
UDS_RDBI.dataIdentifiers[0x3035] = "Tempomat Fehlerstatus"
UDS_RDBI.dataIdentifiers[0x3400] = "3401 3420"
UDS_RDBI.dataIdentifiers[0x3401] = "IUPR 3 voices catalyst dignostic Number of times the system enters in each diagnosis conditions"
UDS_RDBI.dataIdentifiers[0x3402] = "IUPR Oxygene sensor diagnostic Number of times the system enters in each diagnosis conditions"
UDS_RDBI.dataIdentifiers[0x3403] = "IUPR 3 voices catalyst dignostic Number of criteria calculated by resolution"
UDS_RDBI.dataIdentifiers[0x3404] = "IUPR Oxygene sensor diagnostic Number of criteria calculated by resolution"
UDS_RDBI.dataIdentifiers[0x3405] = "IUPR 3 voices catalyst dignostic Number of times the system quits each diagnosis conditions"
UDS_RDBI.dataIdentifiers[0x3406] = "IUPR Oxygene sensor diagnostic Number of times the system quits each diagnosis conditions"
UDS_RDBI.dataIdentifiers[0x3407] = "IUPR Number of driving cycle with 3 voices cata diagnosis aborted"
UDS_RDBI.dataIdentifiers[0x3408] = "IUPR Number of driving cycle with lbup diagnosis aborted"
UDS_RDBI.dataIdentifiers[0x3409] = "IUPR 3 voices catalyst dignostic Average of the maximum durations in diagnosis conditions without diagnosis done"
UDS_RDBI.dataIdentifiers[0x340a] = "IUPR Oxygene sensor diagnostic Average of the maximum durations in diagnosis conditions without diagnosis done"
UDS_RDBI.dataIdentifiers[0x340b] = "IUPR Number of times the system enters in each doc diagnosis conditions"
UDS_RDBI.dataIdentifiers[0x340c] = "IUPR Number of times the system enters in each pft diagnosis conditions"
UDS_RDBI.dataIdentifiers[0x340d] = "IUPR Number of criteria calculated by resolution for the doc diagnosis"
UDS_RDBI.dataIdentifiers[0x340e] = "IUPR Number of criteria calculated by resolution in area 1 for the pft diagnosis"
UDS_RDBI.dataIdentifiers[0x340f] = "IUPR Number of criteria calculated by resolution in area 2 for the pft diagnosis"
UDS_RDBI.dataIdentifiers[0x3410] = "IUPR Number of criteria calculated by resolution in area 3 for the pft diagnosis"
UDS_RDBI.dataIdentifiers[0x3411] = "IUPR Number of criteria calculated by resolution in area 4 for the pft diagnosis"
UDS_RDBI.dataIdentifiers[0x3412] = "IUPR Number of times the system quits each doc diagnosis conditions"
UDS_RDBI.dataIdentifiers[0x3413] = "IUPR Number of times the system quits each pft diagnosis conditions"
UDS_RDBI.dataIdentifiers[0x3414] = "IUPR 1st part of table of diagnosis EGR enabling condtions"
UDS_RDBI.dataIdentifiers[0x3415] = "IUPR 2nd part of table of diagnosis EGR enabling condtions"
UDS_RDBI.dataIdentifiers[0x3416] = "IUPR 3rd part of table of diagnosis EGR enabling condtions"
UDS_RDBI.dataIdentifiers[0x3417] = "IUPR 4th part of table of diagnosis EGR enabling condtions"
UDS_RDBI.dataIdentifiers[0x3418] = "IUPR 5th part of table of diagnosis EGR enabling condtions"
UDS_RDBI.dataIdentifiers[0x3419] = "IUPR 6th part of table of diagnosis EGR enabling condtions"
UDS_RDBI.dataIdentifiers[0x341a] = "IUPR 1st part of table of diagnosis EGR disabling condtions"
UDS_RDBI.dataIdentifiers[0x341b] = "IUPR 2nd part of table of diagnosis EGR disabling condtions"
UDS_RDBI.dataIdentifiers[0x341c] = "IUPR 3rd part of table of diagnosis EGR disabling condtions"
UDS_RDBI.dataIdentifiers[0x341d] = "IUPR 4th part of table of diagnosis EGR disabling condtions"
UDS_RDBI.dataIdentifiers[0x3420] = "3421 3440"
UDS_RDBI.dataIdentifiers[0x3421] = "2 last element of operating point when a misfire occurs for OBD Recorder"
UDS_RDBI.dataIdentifiers[0x3424] = "1st part of Number of criteria calculated by resolution for mass soot integer pft diagnosis"
UDS_RDBI.dataIdentifiers[0x3425] = "2nd part of Number of criteria calculated by resolution for mass soot integer pft diagnosis"
UDS_RDBI.dataIdentifiers[0x3426] = "3rd part of Number of criteria calculated by resolution for mass soot integer pft diagnosis"
UDS_RDBI.dataIdentifiers[0x3427] = "4th part of Number of criteria calculated by resolution for mass soot integer pft diagnosis"
UDS_RDBI.dataIdentifiers[0x3428] = "5th part of Number of criteria calculated by resolution for mass soot integer pft diagnosis"
UDS_RDBI.dataIdentifiers[0x3429] = "6th part of Number of criteria calculated by resolution for mass soot integer pft diagnosis"
UDS_RDBI.dataIdentifiers[0x342a] = "7th part of Number of criteria calculated by resolution for mass soot integer pft diagnosis"
UDS_RDBI.dataIdentifiers[0x342b] = "IUPR 5th part of table of diagnosis EGR disabling condtions"
UDS_RDBI.dataIdentifiers[0x342c] = "IUPR 6th part of table of diagnosis EGR disabling condtions"
UDS_RDBI.dataIdentifiers[0x342d] = "Total vehicle distance at the last oil drain"
UDS_RDBI.dataIdentifiers[0x342e] = "Number of engine revolutions since the last oil drain"
UDS_RDBI.dataIdentifiers[0x342f] = "Vehicle kilometer when the alert appears"
UDS_RDBI.dataIdentifiers[0x3430] = "Total vehicle distance stored at the last pre alert"
UDS_RDBI.dataIdentifiers[0x3431] = "4th part of the table for rear O2 sensor heater efficiency diagnosis criteria distribution for OBD recorder"
UDS_RDBI.dataIdentifiers[0x3432] = "1st part of the table for upstream O2 sensor heater efficiency diagnosis criteria distribution for OBD recorder"
UDS_RDBI.dataIdentifiers[0x3433] = "2nd part of the table for upstream O2 sensor heater efficiency diagnosis criteria distribution for OBD recorder"
UDS_RDBI.dataIdentifiers[0x3434] = "3rd part of the table for upstream O2 sensor heater efficiency diagnosis criteria distribution for OBD recorder"
UDS_RDBI.dataIdentifiers[0x3435] = "4th part of the table for upstream O2 sensor heater efficiency diagnosis criteria distribution for OBD recorder"
UDS_RDBI.dataIdentifiers[0x3436] = "IUPR Oxydation Catalyst diagnostic Average of the highest durations in diagnosis conditions without diagnosis done Re"
UDS_RDBI.dataIdentifiers[0x3440] = "3441 3460"
UDS_RDBI.dataIdentifiers[0x3441] = "1st and 2nd part of table of diagnosis boost pressure enabling condtions"
UDS_RDBI.dataIdentifiers[0x3442] = "3rd and 4th part of table of diagnosis boost pressure enabling condtions"
UDS_RDBI.dataIdentifiers[0x3443] = "table of diagnosis EGR criteria"
UDS_RDBI.dataIdentifiers[0x3444] = "1st part table of diagnosis boost pressure criteria condtions"
UDS_RDBI.dataIdentifiers[0x3445] = "2nd part of table of diagnosis boost pressure criteria condtions"
UDS_RDBI.dataIdentifiers[0x3446] = "3rd part of table of diagnosis boost pressure criteria condtions"
UDS_RDBI.dataIdentifiers[0x3447] = "4th part of table of diagnosis boost pressure criteria condtions"
UDS_RDBI.dataIdentifiers[0x344a] = "2 first bytes of the cumulative number of engine starts"
UDS_RDBI.dataIdentifiers[0x344b] = "2 first bytes of the number of engine first starts or number of trips done by the vehicle"
UDS_RDBI.dataIdentifiers[0x344c] = "2 first bytes of the cumulative number of engine starts non resettable"
UDS_RDBI.dataIdentifiers[0x344d] = "2 first bytes of the number of engine first starts or number of trips done by the vehicle non resettable"
UDS_RDBI.dataIdentifiers[0x3456] = "3rd byte of the cumulative number of engine starts"
UDS_RDBI.dataIdentifiers[0x3457] = "3rd byte of the number of engine first starts or number of trips done by the vehicle"
UDS_RDBI.dataIdentifiers[0x3458] = "3rd byte of the cumulative number of engine starts non resettable"
UDS_RDBI.dataIdentifiers[0x3459] = "3rd byte of the number of engine first starts or number of trips done by the vehicle non resettable"
UDS_RDBI.dataIdentifiers[0x345a] = "3rd byte of the number of engine first starts or number of trips done by the vehicle non resettable"
UDS_RDBI.dataIdentifiers[0x345e] = "Ratio IUPR classe pool"
UDS_RDBI.dataIdentifiers[0x345f] = "Numerateur et denominateur des IUPR pour les classes private"
UDS_RDBI.dataIdentifiers[0x3b01] = "open cable detection test result"
UDS_RDBI.dataIdentifiers[0x3b02] = "open cable detection circuit check result"
UDS_RDBI.dataIdentifiers[0x3b03] = "Disabler for isolation detection"
UDS_RDBI.dataIdentifiers[0x3b04] = "Disabler for open cable detection"
UDS_RDBI.dataIdentifiers[0x3b05] = "Disabler for weld check and active discharge functionality"
UDS_RDBI.dataIdentifiers[0x3b06] = "Disabler for open cable detection circuit check"
UDS_RDBI.dataIdentifiers[0x3b07] = "Disabler for contactor closure after failed weld check"
UDS_RDBI.dataIdentifiers[0x3f00] = "Reset Zaehler Batteriefehler Reset Zaehler"  	 # or WD Reset Counter Read Watchdog Reset Zaehler
UDS_RDBI.dataIdentifiers[0x3f01] = "WD Reset Counter Reset"
UDS_RDBI.dataIdentifiers[0x3f02] = "FBS mobil Tuergriff Lieferant"
UDS_RDBI.dataIdentifiers[0x3f03] = "Service Call Settings"
UDS_RDBI.dataIdentifiers[0x3f04] = "E Call Settings"
UDS_RDBI.dataIdentifiers[0x3f05] = "ERA Test Mode Numbers"
UDS_RDBI.dataIdentifiers[0x3f06] = "ERA 54620 Appendix A Parameter"
UDS_RDBI.dataIdentifiers[0x3f07] = "RTM settings"
UDS_RDBI.dataIdentifiers[0x3f08] = "Fastpath settings"
UDS_RDBI.dataIdentifiers[0x3f09] = "FastpathTopicTree"
UDS_RDBI.dataIdentifiers[0x3f12] = "High Voltage Battery Charge"
UDS_RDBI.dataIdentifiers[0x3f15] = "Impact Event"
UDS_RDBI.dataIdentifiers[0x3f17] = "Regenerative Braking"
UDS_RDBI.dataIdentifiers[0x3f18] = "System State"
UDS_RDBI.dataIdentifiers[0x3f20] = "Start-Stop Enable"
UDS_RDBI.dataIdentifiers[0x3f21] = "Jump Assist State"
UDS_RDBI.dataIdentifiers[0x3f22] = "Transmission Range Transistion State"
UDS_RDBI.dataIdentifiers[0x3f23] = "X/Y Valves Current State"
UDS_RDBI.dataIdentifiers[0x3f24] = "X/Y Valves Commanded State"
UDS_RDBI.dataIdentifiers[0x3f25] = "X/Y Valves Transition State"
UDS_RDBI.dataIdentifiers[0x3f26] = "Estimated Line Pressure"
UDS_RDBI.dataIdentifiers[0x3f27] = "Motor A Inverter"
UDS_RDBI.dataIdentifiers[0x3f28] = "Motor B Inverter"
UDS_RDBI.dataIdentifiers[0x3f29] = "Vehicle total distance"
UDS_RDBI.dataIdentifiers[0x3f30] = "BMW Car Group Active Diagnostic Information"
UDS_RDBI.dataIdentifiers[0x3f32] = "BMW Car Group Reprogramming Attempt Counter"
UDS_RDBI.dataIdentifiers[0x3f34] = "BMW Car Group Read Fingerprint"
UDS_RDBI.dataIdentifiers[0x3f36] = "BMW Car Group Hardware Version Information"
UDS_RDBI.dataIdentifiers[0x3f38] = "BMW Car Group Software Version Information"
UDS_RDBI.dataIdentifiers[0x3f3a] = "BMW Car Group Boot Software Version Information"
UDS_RDBI.dataIdentifiers[0x3f3c] = "BMW Car Group Hardware Supplier Identification"
UDS_RDBI.dataIdentifiers[0x3f3e] = "BMW Car Group Software Supplier Identification"
UDS_RDBI.dataIdentifiers[0x3f41] = "BMW Car Group Hardware Part Number"
UDS_RDBI.dataIdentifiers[0x3f51] = "BMW Car Group Software Part Number"
UDS_RDBI.dataIdentifiers[0x3f61] = "BMW Car Group ECU Assembly Number"
UDS_RDBI.dataIdentifiers[0x3f80] = "BMW Car Group Assembly Number"
UDS_RDBI.dataIdentifiers[0x3f90] = "ZIF Lesen"
UDS_RDBI.dataIdentifiers[0x4000] = "Kraftstoffpumpenspannung"
UDS_RDBI.dataIdentifiers[0x4001] = "Full Diagnostic Availability Check"  	 # or Jump Assist added Charge
UDS_RDBI.dataIdentifiers[0x4002] = "HV Current Channel A"  	 # or RDiag Transmission Statistics Day, Drosselklappe Poti1
UDS_RDBI.dataIdentifiers[0x4003] = "HV Current Channel B "  	 # or Drosselklappe Poti2
UDS_RDBI.dataIdentifiers[0x4004] = "MCPB Motor A Active Control State"  	 # or MCPA Motor B Active Control Stat"  	 # or Kraftstoffpumpenphasenstrom
UDS_RDBI.dataIdentifiers[0x4005] = "Operation"
UDS_RDBI.dataIdentifiers[0x4006] = "PCB Temperature"  	 # or RDiag RDA Initial Summary Block Datablock, Drosselklappe Lernvorgang Beendet
UDS_RDBI.dataIdentifiers[0x4007] = "Hood State"  	 # or Drosselklappe Erfolgreich Gelernt, RDiag oVCI ECU List incl dynamic content HexDump ECUList including dynamic content
UDS_RDBI.dataIdentifiers[0x4008] = "LV Bus Current"
UDS_RDBI.dataIdentifiers[0x4009] = "Nockenwellenadaption Einlass"  	 # or EMPI
UDS_RDBI.dataIdentifiers[0x400a] = "Inhibit Input-Output History"
UDS_RDBI.dataIdentifiers[0x400b] = "EMPI Speed Commanded"
UDS_RDBI.dataIdentifiers[0x400c] = "EMPI Speed Actual"
UDS_RDBI.dataIdentifiers[0x400d] = "Time since Propulsion System Active"
UDS_RDBI.dataIdentifiers[0x400e] = "Sensed Engine Torque"
UDS_RDBI.dataIdentifiers[0x400f] = "Achieved DSM Position"
UDS_RDBI.dataIdentifiers[0x4010] = "Abgasklappen"  	 # or Park Verification Switch
UDS_RDBI.dataIdentifiers[0x4011] = "Luefternachlauf angefordert"  	 # or Transmission PRND Range
UDS_RDBI.dataIdentifiers[0x4012] = "Nachlauf Anforderung AGK"  	 # or HV Fuse, Nockenwellenwinkel Einlass
UDS_RDBI.dataIdentifiers[0x4013] = "Luefter PWM Fehlerstatus"  	 # or HV Fuse Information
UDS_RDBI.dataIdentifiers[0x4014] = "Aktuelles Ist-Tastverhaeltnis Tankentlueftungsventil"  	 # or Bugschuerzenjalouse LIN Sollwert, Tankentlueftung Aktuelles Tastverhaeltnis
UDS_RDBI.dataIdentifiers[0x4015] = "Bugschuerzenjalouse LIN Referenzfahrt"  	 # or Drosselklappe Poti1 Unterer Anschlag, Spannung DK-Poti 1 am unteren Anschlag
UDS_RDBI.dataIdentifiers[0x4016] = "Bugschuerzenjalouse LIN Fehlerstatus"  	 # or Spannung DK-Poti 2 am unteren Anschlag, Drosselklappe Poti2 Unterer Anschlag
UDS_RDBI.dataIdentifiers[0x4017] = "Drosselklappe Winkel Notluftposition"  	 # or DK-Winkel der Notluftposition, Kuehlaggregat Chillerventil CO2 Initialisierungsstatus
UDS_RDBI.dataIdentifiers[0x4018] = "Drosselklappe Verstaerkung1"
UDS_RDBI.dataIdentifiers[0x4019] = "Drosselklappe Verstaerkung1 Spannungsoffset"
UDS_RDBI.dataIdentifiers[0x401b] = "Drosselklappe Referenzablage erfolgreich"
UDS_RDBI.dataIdentifiers[0x4020] = "Kuehlmittel Drehschieberventil LIN Sollwert"
UDS_RDBI.dataIdentifiers[0x4021] = "Verstaerkte Spannung DK-Poti"  	 # or Kuehlmittel Drehschieberventil BMS Sollwert, Drosselklappe Poti1 verstaerkt
UDS_RDBI.dataIdentifiers[0x4022] = "Chiller Sollwert"
UDS_RDBI.dataIdentifiers[0x4023] = "Kaeltemittelkreislauf HV Batterie Ventil Sollwert"
UDS_RDBI.dataIdentifiers[0x4024] = "Kaeltemittelkreislauf Chiller Sollwert"
UDS_RDBI.dataIdentifiers[0x4025] = "Wasserpumpe LIN Sollwert"
UDS_RDBI.dataIdentifiers[0x4026] = "Kuehlmittelpumpe Ladeluft Sollwert"
UDS_RDBI.dataIdentifiers[0x4027] = "Kuehlmittelpumpe BMS Sollwert"
UDS_RDBI.dataIdentifiers[0x4028] = "Kuehlerjalousie LIN Referenzfahrt Fehler"
UDS_RDBI.dataIdentifiers[0x4033] = "Drosselklappe Winkel Bezogen auf Unteren Anschlag"  	 # or DK-Winkel unterer Anschlag
UDS_RDBI.dataIdentifiers[0x4040] = "SG intern gemessener Ausgangsstrom zur DMTL Pumpe"  	 # or DMTL Pumpenstrom
UDS_RDBI.dataIdentifiers[0x4041] = "Motordrehzahlbegrenzung Aktiv"  	 # or Motordrehzahlbegrenzung ist aktiv
UDS_RDBI.dataIdentifiers[0x4042] = "Fuelrailentlueftungsfunktion Freigabe Laueft"
UDS_RDBI.dataIdentifiers[0x4046] = "Fuelrailentlueftungsfunktion NachStart"
UDS_RDBI.dataIdentifiers[0x4060] = "Nockenwellenreferenzadaption Zustand Einlass"
UDS_RDBI.dataIdentifiers[0x4061] = "Nockenwellenreferenzadaption Zustand Auslass"
UDS_RDBI.dataIdentifiers[0x4062] = "Nockenwellenreferenzadaption Zustand Einlass Links"
UDS_RDBI.dataIdentifiers[0x4063] = "Nockenwellenreferenzadaption Zustand Auslass Links"
UDS_RDBI.dataIdentifiers[0x4064] = "Nockenwellenreferenzadaption Winkeldifferenz Einlass"
UDS_RDBI.dataIdentifiers[0x4065] = "Nockenwellenreferenzadaption Winkeldifferenz Auslass"
UDS_RDBI.dataIdentifiers[0x4066] = "Nockenwellenreferenzadaption Winkeldifferenz Einlass Links"
UDS_RDBI.dataIdentifiers[0x4067] = "Nockenwellenreferenzadaption Winkeldifferenz Auslass Links"
UDS_RDBI.dataIdentifiers[0x4070] = "Niedertemperatur Pumpenlaufzeit"
UDS_RDBI.dataIdentifiers[0x4086] = "Wastegate Position ROH"
UDS_RDBI.dataIdentifiers[0x4087] = "Wastegate Position"
UDS_RDBI.dataIdentifiers[0x4088] = "Wastegate Adaption laeuft"
UDS_RDBI.dataIdentifiers[0x408a] = "Wastegate Adaption Ergebnis"
UDS_RDBI.dataIdentifiers[0x408b] = "Wastegate Adaption Abbruch"
UDS_RDBI.dataIdentifiers[0x40d0] = "DC Voltage Sensor"
UDS_RDBI.dataIdentifiers[0x40d2] = "Sensor"
UDS_RDBI.dataIdentifiers[0x40d6] = "Sensor Voltage"
UDS_RDBI.dataIdentifiers[0x40d7] = "Module Temp Sensor"
UDS_RDBI.dataIdentifiers[0x40d8] = "Module Temp Sensor 1 Voltage"
UDS_RDBI.dataIdentifiers[0x40d9] = "Module Temp Sensor"
UDS_RDBI.dataIdentifiers[0x40da] = "Module Temp Sensor 2 Voltage"
UDS_RDBI.dataIdentifiers[0x40db] = "Module Temp Sensor"
UDS_RDBI.dataIdentifiers[0x40dc] = "Module Temp Sensor 3 Voltage"
UDS_RDBI.dataIdentifiers[0x40dd] = "Module Temp Sensor 4"
UDS_RDBI.dataIdentifiers[0x40de] = "Module Temp Sensor 4 Voltage"
UDS_RDBI.dataIdentifiers[0x40e4] = "Module 1 Voltage Sensor"
UDS_RDBI.dataIdentifiers[0x40e5] = "Module 2 Voltage Sensor"
UDS_RDBI.dataIdentifiers[0x40e6] = "Module 3 Voltage Sensor"
UDS_RDBI.dataIdentifiers[0x40e7] = "Fan Speed"
UDS_RDBI.dataIdentifiers[0x40e8] = "Fan Commanded PWM"
UDS_RDBI.dataIdentifiers[0x40e9] = "High Voltage Battery Resistance"
UDS_RDBI.dataIdentifiers[0x40eb] = "Maximum Module Voltage"
UDS_RDBI.dataIdentifiers[0x40ec] = "Minimum Module Voltage"
UDS_RDBI.dataIdentifiers[0x40ee] = "DisCharge Power Available Short Term"
UDS_RDBI.dataIdentifiers[0x40ef] = "Charge Power Available Short Term"
UDS_RDBI.dataIdentifiers[0x40f0] = "Module 7 Voltage Sensor"
UDS_RDBI.dataIdentifiers[0x40f1] = "Module 8 Voltage Sensor"
UDS_RDBI.dataIdentifiers[0x40f2] = "Module 9 Voltage Sensor"
UDS_RDBI.dataIdentifiers[0x40f3] = "Module 10 Voltage Sensor"
UDS_RDBI.dataIdentifiers[0x40f4] = "Module 11Voltage Sensor"
UDS_RDBI.dataIdentifiers[0x40f5] = "Module 12 Voltage Sensor"
UDS_RDBI.dataIdentifiers[0x40f6] = "Module 13 Voltage Sensor"
UDS_RDBI.dataIdentifiers[0x40f7] = "Module 14 Voltage Sensor"
UDS_RDBI.dataIdentifiers[0x40f8] = "Module 15 Voltage Sensor"
UDS_RDBI.dataIdentifiers[0x40f9] = "Module 16 Voltage Sensor"
UDS_RDBI.dataIdentifiers[0x40fa] = "Module 17 Voltage Sensor"
UDS_RDBI.dataIdentifiers[0x40fb] = "Module 18 Voltage Sensor"
UDS_RDBI.dataIdentifiers[0x40fc] = "Module 19 Voltage Sensor"
UDS_RDBI.dataIdentifiers[0x40fd] = "Module 20 Voltage Sensor"
UDS_RDBI.dataIdentifiers[0x40fe] = "Voltage Calculated"
UDS_RDBI.dataIdentifiers[0x40ff] = "AC Isolation Resistance"
UDS_RDBI.dataIdentifiers[0x4100] = "HVIL Source Current"
UDS_RDBI.dataIdentifiers[0x4101] = "HVIL Return Current"
UDS_RDBI.dataIdentifiers[0x4102] = "Contactor Stat"
UDS_RDBI.dataIdentifiers[0x4103] = "Contactor Open"
UDS_RDBI.dataIdentifiers[0x4104] = "Contactor Weld Check Stat"
UDS_RDBI.dataIdentifiers[0x4105] = "battery Contactor Commanded PWM "
UDS_RDBI.dataIdentifiers[0x4106] = "High Battery Contactor Command Stat"
UDS_RDBI.dataIdentifiers[0x4107] = "Inlet Air Temp Sensor"
UDS_RDBI.dataIdentifiers[0x4108] = "Inlet Air Temp Sensor Voltage"
UDS_RDBI.dataIdentifiers[0x4109] = "Outlet Air Temp Sensor"
UDS_RDBI.dataIdentifiers[0x410a] = "Outlet Air Temp Sensor Voltage"
UDS_RDBI.dataIdentifiers[0x410b] = "Module 4 Voltage Sensor"
UDS_RDBI.dataIdentifiers[0x410c] = "Module 5 Voltage Sensor"
UDS_RDBI.dataIdentifiers[0x410d] = "Module 6 Voltage Sensor"
UDS_RDBI.dataIdentifiers[0x4110] = "BPCM Observed Positive Rail Welded Contactor"
UDS_RDBI.dataIdentifiers[0x4111] = "BPCM Observed Negative Rail Welded Contactor"
UDS_RDBI.dataIdentifiers[0x4112] = "BPCM Observed Both Rails Welded Contactor"
UDS_RDBI.dataIdentifiers[0x4113] = "Benzin Betrieb Verbot wegen Crash"
UDS_RDBI.dataIdentifiers[0x4114] = "Bremskreis Unterdruckpumpe Betriebszeit"
UDS_RDBI.dataIdentifiers[0x4115] = "Bremskreis Unterdruckpumpe Anzahl Aktivierung"  	 # or Isolation measurement with closed contactors and positive rail
UDS_RDBI.dataIdentifiers[0x4116] = "Isolation measurement with closed contactors and negative rail"
UDS_RDBI.dataIdentifiers[0x4117] = "Isolation measurement combined with open contactors "
UDS_RDBI.dataIdentifiers[0x4118] = "Isolation test fully performed"
UDS_RDBI.dataIdentifiers[0x4149] = "HV Isolation"
UDS_RDBI.dataIdentifiers[0x41ee] = "DisCharge Power Available Long Term"
UDS_RDBI.dataIdentifiers[0x41ef] = "Charge Power Available Long Term"
UDS_RDBI.dataIdentifiers[0x4200] = "Kuehlerjalousie LIN Sollwert"
UDS_RDBI.dataIdentifiers[0x4201] = "Kuehlerjalousie LIN Referenzfahrt"
UDS_RDBI.dataIdentifiers[0x4202] = "Kuehlerjalousie LIN Fehlerstatus"
UDS_RDBI.dataIdentifiers[0x4203] = "Kuehlmittel Drehschieberventil LIN Sollwert"
UDS_RDBI.dataIdentifiers[0x4204] = "Kuehlmittel Drehschieberventil LIN Referenzfahrt"
UDS_RDBI.dataIdentifiers[0x4205] = "Kuehlmittel Drehschieberventil LIN Referenzfahrt Fehler"
UDS_RDBI.dataIdentifiers[0x4206] = "Kuehlmittel Drehschieberventil LIN Fehlerstatus"
UDS_RDBI.dataIdentifiers[0x4207] = "Kuehlmittel Drehschieberventil BMS LIN Sollwert"
UDS_RDBI.dataIdentifiers[0x4208] = "Kuehlmittel Drehschieberventil BMS LIN Referenzfahrt"
UDS_RDBI.dataIdentifiers[0x4209] = "Kuehlmittel Drehschieberventil BMS LIN Referenzfahrt Fehler"
UDS_RDBI.dataIdentifiers[0x420a] = "Kuehlmittel Drehschieberventil BMS LIN Fehlerstatus"
UDS_RDBI.dataIdentifiers[0x4210] = "Kuehlermaskenjalousie LIN Sollwert"
UDS_RDBI.dataIdentifiers[0x4211] = "Kuehlermaskenjalousie LIN Referenzfahrt"
UDS_RDBI.dataIdentifiers[0x4212] = "Kuehlermaskenjalousie LIN Fehlerstatus"
UDS_RDBI.dataIdentifiers[0x4213] = "Kuehlmittelpumpe Getriebeoel Sollwert Read Kuehlmittelpumpe Getriebeoel Sollwert"
UDS_RDBI.dataIdentifiers[0x4214] = "Kuehlmittelpumpe Plugin Hybrid Sollwert"
UDS_RDBI.dataIdentifiers[0x4215] = "Kuehlaggregat Expansionsventil Sollwert"
UDS_RDBI.dataIdentifiers[0x4216] = "Kuehlmittelpumpe NT2 15W BMS Sollwert"
UDS_RDBI.dataIdentifiers[0x4217] = "PTC Zuheizer Plugin Hybrid Sollwert"
UDS_RDBI.dataIdentifiers[0x4800] = "Exhaust flap control state EGFC State"  	 # or Exhaust gas flap State
UDS_RDBI.dataIdentifiers[0x4f01] = "RDiag oVCI Firewall Black List"
UDS_RDBI.dataIdentifiers[0x4f02] = "RDiag oVCI Configuration"
UDS_RDBI.dataIdentifiers[0x4f03] = "RDiag oVCI Default CommParam"
UDS_RDBI.dataIdentifiers[0x4f04] = "RDiag oVCI ECU List"
UDS_RDBI.dataIdentifiers[0x4f05] = "RDiag oVCI Firewall White List"
UDS_RDBI.dataIdentifiers[0x4f06] = "RDiag RDA Configuration"
UDS_RDBI.dataIdentifiers[0x4f07] = "RDiag RDA Trigger Configuration LogicalBlock 2"
UDS_RDBI.dataIdentifiers[0x4f08] = "RDiag RDA Trigger Configuration LogicalBlock 3"
UDS_RDBI.dataIdentifiers[0x4f09] = "RDiag RDA Trigger Configuration LogicalBlock 4"
UDS_RDBI.dataIdentifiers[0x4f0a] = "RDiag RDA Trigger Configuration LogicalBlock 5"
UDS_RDBI.dataIdentifiers[0x4f0b] = "RDiag RDA Trigger Configuration LogicalBlock 6"
UDS_RDBI.dataIdentifiers[0x4f0c] = "RDiag RDA Trigger Configuration LogicalBlock 7"
UDS_RDBI.dataIdentifiers[0x4f0d] = "RDiag RDA Trigger Configuration LogicalBlock 8"
UDS_RDBI.dataIdentifiers[0x4f0e] = "RDiag RDA Trigger Configuration LogicalBlock 9"
UDS_RDBI.dataIdentifiers[0x4f0f] = "RDiag RDA Trigger Configuration LogicalBlock 10"
UDS_RDBI.dataIdentifiers[0x4f10] = "RDiag RDA Trigger Configuration LogicalBlock 11"
UDS_RDBI.dataIdentifiers[0x5000] = "Generatorkennung"  	 # or Motordrehzahl Read Response Parameters Motordrehzahl
UDS_RDBI.dataIdentifiers[0x5001] = "Eingestellter Erregerstrom"
UDS_RDBI.dataIdentifiers[0x5002] = "Auslastungsgrad"  	 # or Motordrehzahl gefiltert
UDS_RDBI.dataIdentifiers[0x5003] = "Generator Funktionsfehler Detail Vorgemerkt"
UDS_RDBI.dataIdentifiers[0x5004] = "Messwert berechnetes Generatormoment Generator"
UDS_RDBI.dataIdentifiers[0x5005] = "Berechneter Generatorstrom"
UDS_RDBI.dataIdentifiers[0x5006] = "Generatorfehler Kommunikationsfehler"
UDS_RDBI.dataIdentifiers[0x5007] = "Generatorfehler elektrisch"
UDS_RDBI.dataIdentifiers[0x5008] = "Generatorfehler mechanisch"
UDS_RDBI.dataIdentifiers[0x5009] = "Generatorfehler Timeout"
UDS_RDBI.dataIdentifiers[0x5010] = "Klemme 15 CAN"  	 # or Klemme 15 CAN Read Klemme 15 CAN, Aussenlufttemperatur ROH
UDS_RDBI.dataIdentifiers[0x5011] = "Generator Funktionsfehler Vorgemerkt Max Dauer"
UDS_RDBI.dataIdentifiers[0x5012] = "Schubbetrieb"
UDS_RDBI.dataIdentifiers[0x5013] = "Stoppmode"
UDS_RDBI.dataIdentifiers[0x5014] = "Gasbetrieb"
UDS_RDBI.dataIdentifiers[0x5015] = "Generator Kommunikationsfehler Vorgemerkt Max Dauer"
UDS_RDBI.dataIdentifiers[0x5016] = "Volumenstrom Vorgabe CAN"  	 # or Generator Kommunikationsfehler Detail Vorgemerkt
UDS_RDBI.dataIdentifiers[0x5017] = "Generator Kommunikationsfehler Vorgemerkt"
UDS_RDBI.dataIdentifiers[0x5018] = "Generatorfehler Hochtemperatur von aktivem Generator"
UDS_RDBI.dataIdentifiers[0x501a] = "Generatorvorgaben Information"
UDS_RDBI.dataIdentifiers[0x501b] = "Generatorvorgaben Information"
UDS_RDBI.dataIdentifiers[0x501c] = "Generatorfehler Umgebungsdaten Information"
UDS_RDBI.dataIdentifiers[0x501d] = "Generatorfehler Umgebungsdaten Information"
UDS_RDBI.dataIdentifiers[0x5020] = "Fahrstufe"  	 # or aktuelle(r) Gang / Fahrstufe, Zuendung Klemme15 CAN
UDS_RDBI.dataIdentifiers[0x5021] = "Getriebe Oeltemperatur"  	 # or Geschwindigkeit der Hinterachse
UDS_RDBI.dataIdentifiers[0x5022] = "DCDC Kuelmitteltemperatur"  	 # or Geschwindigkeit Vorderachse, Geschwindigkeit der Vorderachse
UDS_RDBI.dataIdentifiers[0x5023] = "Elektromaschine Inverter K hlwassertemperatur"
UDS_RDBI.dataIdentifiers[0x5024] = "Hochvolt Batterie Temperatur"
UDS_RDBI.dataIdentifiers[0x5025] = "Allrad Low Range aus AGK"  	 # or OnBoard Lader Temperatur
UDS_RDBI.dataIdentifiers[0x5027] = "Klimaanforderung Vorne"
UDS_RDBI.dataIdentifiers[0x5028] = "Luefter Klimaanforderung"
UDS_RDBI.dataIdentifiers[0x5029] = "Luefter Kuehlanforderung"
UDS_RDBI.dataIdentifiers[0x5030] = "Aussenlufttemperatur tumg"
UDS_RDBI.dataIdentifiers[0x5031] = "Aussenlufttemperatur CAN (Kombi)"
UDS_RDBI.dataIdentifiers[0x5032] = "Extern modelierte Aussenlufttemperatur von CAN Kombi"
UDS_RDBI.dataIdentifiers[0x5033] = "Getriebefreigabe Automatgetriebe"
UDS_RDBI.dataIdentifiers[0x5034] = "Klemme 50 Startanforderung EZS"  	 # or Klemme50 Startanforderung EZS
UDS_RDBI.dataIdentifiers[0x5035] = "PremAir Nachricht erkannt"
UDS_RDBI.dataIdentifiers[0x5040] = "Bremskreis Unterdruck"
UDS_RDBI.dataIdentifiers[0x5041] = "Bremskreis Unterdruckwert gueltig"
UDS_RDBI.dataIdentifiers[0x5042] = "Kickdownschalter"
UDS_RDBI.dataIdentifiers[0x504a] = "Clutch 1 Pressure learned characteristics"
UDS_RDBI.dataIdentifiers[0x504b] = "Clutch 2 Pressure learned characteristics"
UDS_RDBI.dataIdentifiers[0x504c] = "Clutch 3 Pressure learned characteristics"
UDS_RDBI.dataIdentifiers[0x504d] = "Clutch 4 Pressure learned characteristics"
UDS_RDBI.dataIdentifiers[0x505f] = "Transmission Oil Remaining Life"
UDS_RDBI.dataIdentifiers[0x5075] = "First Time Power Up Value"
UDS_RDBI.dataIdentifiers[0x50a0] = "MEC Manufacturers Enable"
UDS_RDBI.dataIdentifiers[0x50b2] = "HCP Status Register"  	 # or TCM Status Registe"
UDS_RDBI.dataIdentifiers[0x50b4] = "Manufacturing Traceability Character"
UDS_RDBI.dataIdentifiers[0x50dd] = "Transmission Adaptives"
UDS_RDBI.dataIdentifiers[0x50de] = "Rate Based Monitoring"
UDS_RDBI.dataIdentifiers[0x5102] = "Kraftstoffmenge"
UDS_RDBI.dataIdentifiers[0x5103] = "Kraftstofffuellstand"
UDS_RDBI.dataIdentifiers[0x5105] = "Wert der aktuellen Hochspannung"
UDS_RDBI.dataIdentifiers[0x5116] = "Kilometerstand von CAN-Bus"
UDS_RDBI.dataIdentifiers[0x5200] = "AGR Niederdruck NT2 BMS Temperatur"
UDS_RDBI.dataIdentifiers[0x6000] = "Motordrehmoment"
UDS_RDBI.dataIdentifiers[0x6001] = "Adaption Kraftstoffdrucksensor"
UDS_RDBI.dataIdentifiers[0x6002] = "Motorzustand Schubabschaltung"
UDS_RDBI.dataIdentifiers[0x6003] = "Sychronisierungsverlust"  	 # or SynchronizationLost, Leerlauferkennung, Systemlaufzeit, Motorzustand Leerlauferkennung
UDS_RDBI.dataIdentifiers[0x6004] = "Motorzustand Leerlaufregelung Aktiv"
UDS_RDBI.dataIdentifiers[0x6005] = "Motorzustand Vollasterkennung"
UDS_RDBI.dataIdentifiers[0x6006] = "Getriebeschutz"
UDS_RDBI.dataIdentifiers[0x6008] = "Nachstart aktiv"  	 # or Motorzustand Nachstartanreicherung Abgeschaltet
UDS_RDBI.dataIdentifiers[0x600a] = "Motorzustand Start Aktiv"  	 # or Start ist aktiv
UDS_RDBI.dataIdentifiers[0x6010] = "Energmanag HVBatterie Ladezustand"  	 # or Gangsensor SG Adaption
UDS_RDBI.dataIdentifiers[0x6011] = "Energmanag HVBatterie Kapazitaet Stromintegral"  	 # or Aussetzerzaehler HWZyl1, Gangsensor SG Adaption Fehler
UDS_RDBI.dataIdentifiers[0x6012] = "Kupplungspedalsensor Adaption"  	 # or Energmanag HVBatterie Kapazitaet aktuell, Aussetzerzaehler HWZyl2
UDS_RDBI.dataIdentifiers[0x6013] = "Aussetzerzaehler HWZyl3"  	 # or Energmanag HVBatterie Strom, Kupplungspedalsensor Adaptionswert Pedal losgelassen
UDS_RDBI.dataIdentifiers[0x6014] = "HVBatterie Ladezustand nach Spg Tabelle"  	 # or Energmanag HVBatterie Ladezustand nach Spg Tabelle, Kupplungspedalsensor Adaptionswert Pedal gedrueckt
UDS_RDBI.dataIdentifiers[0x6015] = "Kupplungspedalsensor Adaption Fehler"  	 # or ESOC OCV Arr21 10mV 0
UDS_RDBI.dataIdentifiers[0x6016] = "Kupplungspedalsensor Adaptionswert Pedal losgelassen gueltig"
UDS_RDBI.dataIdentifiers[0x6017] = "Energmanag HVBatterie Innenwiderstand Korr Laden"  	 # or Kupplungspedalsensor Adaptionswert Pedal gedrueckt gueltig
UDS_RDBI.dataIdentifiers[0x6018] = "Gangsensor SG Nulllagenadaptionswert gueltig"  	 # or Energmanag HVBatterie Innenwiderstand Korr Entladen
UDS_RDBI.dataIdentifiers[0x6019] = "HVBatterie"  	 # or EDIAG Batt Volt StepDelta 0, Gangsensor SG Rueckwaertsgang Adaptionswert gueltig
UDS_RDBI.dataIdentifiers[0x601a] = "Gangsensor SG Gang6Adaptionswert gueltig"
UDS_RDBI.dataIdentifiers[0x601e] = "Luftansaugung Klappe links Fehler Referenzfahrt"
UDS_RDBI.dataIdentifiers[0x601f] = "Luftansaugung Klappe rechts Fehler Referenzfahrt"
UDS_RDBI.dataIdentifiers[0x6020] = "Abgasklappe Adaption laeuft"  	 # or Energmanag HVSchuetze Zuendungszaehler Fahrzeugwerk, Kompressionspruefungsstatus
UDS_RDBI.dataIdentifiers[0x6021] = "Abgasklappe Adaption fertig"  	 # or Energmanag HVSystem spannungsfrei
UDS_RDBI.dataIdentifiers[0x6022] = "Abgasklappe Adaption erfolgreich"
UDS_RDBI.dataIdentifiers[0x6023] = "Abgasklappe Adaption Abbruch"
UDS_RDBI.dataIdentifiers[0x6024] = "Abgasklappe Adaption Fehler"  	 # or Kompressionszeit Zylinder 4
UDS_RDBI.dataIdentifiers[0x6025] = "Kompressionszeit Zylinder 5"  	 # or Abgasklappe Diagnosemodus
UDS_RDBI.dataIdentifiers[0x6026] = "Kompressionszeit Zylinder 6"  	 # or Abgasklappe Hardware
UDS_RDBI.dataIdentifiers[0x6027] = "Abgasklappe Endstufenspannung"
UDS_RDBI.dataIdentifiers[0x6029] = "Abgasklappe Positionssensor Fehler"
UDS_RDBI.dataIdentifiers[0x6030] = "Laufruhe HWZyl1"  	 # or Abgasklappe Regelfehler
UDS_RDBI.dataIdentifiers[0x6031] = "Laufruhe HWZyl2"
UDS_RDBI.dataIdentifiers[0x6032] = "Laufruhe HWZyl3"
UDS_RDBI.dataIdentifiers[0x6033] = "Abgasklappe Regelung"  	 # or Laufruhe Zylinder 4
UDS_RDBI.dataIdentifiers[0x6034] = "Abgasklappe Zaehler Freibrechereignisse"  	 # or Laufruhe Zylinder 5
UDS_RDBI.dataIdentifiers[0x6035] = "Abgasklappe Zustand Aktiv"  	 # or Laufruhe Zylinder 6
UDS_RDBI.dataIdentifiers[0x6036] = "Abgasklappe Zustand Fehler"
UDS_RDBI.dataIdentifiers[0x6037] = "Abgasklappe Zustand Standby"
UDS_RDBI.dataIdentifiers[0x6038] = "Abgasklappe Zustand Wartung"
UDS_RDBI.dataIdentifiers[0x603b] = "Abgasklappe Federrueckstellzeit"
UDS_RDBI.dataIdentifiers[0x6040] = "Produktionsmodus Fahrzyklen"  	 # or Zuendwinkelspaetverstellung Mittelwert
UDS_RDBI.dataIdentifiers[0x6041] = "Zuendwinkelspaetverstellung HWZyl1"  	 # or TD Counter
UDS_RDBI.dataIdentifiers[0x6042] = "Zuendwinkelspaetverstellung HWZyl2"  	 # or TD km Stand erstes
UDS_RDBI.dataIdentifiers[0x6043] = "TD km Stand letztes"  	 # or Zuendwinkelspaetverstellung HWZyl3
UDS_RDBI.dataIdentifiers[0x6044] = "TD km Stand Reset"
UDS_RDBI.dataIdentifiers[0x6045] = "HVBatterie Energieinhalt Korrekturfaktor"
UDS_RDBI.dataIdentifiers[0x6049] = "HVBatterie Ladezustand berechnet"
UDS_RDBI.dataIdentifiers[0x6050] = "HVBatterie Ladezustand"
UDS_RDBI.dataIdentifiers[0x6051] = "HVBatterie Kapazitaet Stromintegral"
UDS_RDBI.dataIdentifiers[0x6052] = "HVBatterie Kapazitaet aktuell"
UDS_RDBI.dataIdentifiers[0x6053] = "HVBatterie Strom"
UDS_RDBI.dataIdentifiers[0x6055] = "HVBatterie OCV Kennlinie"
UDS_RDBI.dataIdentifiers[0x6056] = "HVBatterie Innenwiderstand Korr Laden"
UDS_RDBI.dataIdentifiers[0x6057] = "HVBatterie Innenwiderstand Korr Entladen"
UDS_RDBI.dataIdentifiers[0x6058] = "HVBatterie Test"
UDS_RDBI.dataIdentifiers[0x6059] = "HVBatterie Testerg Kapazitaet"
UDS_RDBI.dataIdentifiers[0x6060] = "HVBatterie Testerg Startspannung"  	 # or BedingungFuelOnAdaptionGestoppt
UDS_RDBI.dataIdentifiers[0x6061] = "On Adaption Reset Durchfuehren"  	 # or HVBatterie Testerg Spannungs Schrittweite, AnforderungFuelOnAdaptionResetDurchfuehren
UDS_RDBI.dataIdentifiers[0x6062] = "On Adaption Reset Durchgefuehrt"  	 # or HVBatterie Testerg Kapazitaets Schrittweite
UDS_RDBI.dataIdentifiers[0x6063] = "FuelOnAdaptionFertigDominanterBereich"  	 # or HVBatterie Testerg Widerstandsabgleich bei Ladung
UDS_RDBI.dataIdentifiers[0x6064] = "FuelOnAdaptionAngehalten"  	 # or HVBatterie Testerg Widerstandsabgleich bei Entladung
UDS_RDBI.dataIdentifiers[0x6065] = "FuelOnAdaptionGestoppt"  	 # or On Adaption Gestoppt, HVBatterie Testerg max Zellenspg bei R Messung
UDS_RDBI.dataIdentifiers[0x6066] = "FuelOnAdaptionReset"  	 # or On Adaption Reset, HVBatterie Testerg max Zellenspg bei Kap Messung
UDS_RDBI.dataIdentifiers[0x6067] = "On Adaption Bedingung Gestoppt"  	 # or HVBatterie Testerg Umgebungsinfo Widerstandsmessung, FuelOnAdaption
UDS_RDBI.dataIdentifiers[0x6068] = "FuelOnAdaptionAktuellerBereich"
UDS_RDBI.dataIdentifiers[0x6069] = "FuelOnAdaptionStatus"
UDS_RDBI.dataIdentifiers[0x606a] = "HVBatterie Energieinhalt Widerstandskorrekturfaktor"
UDS_RDBI.dataIdentifiers[0x606b] = "Geberradadaption angehalten wg. Aussetzer"  	 # or Off On Adaption Angehalten Aussetzer, HVBatterie Energiezustand
UDS_RDBI.dataIdentifiers[0x606c] = "Energieverbrauch Lebenszeit"  	 # or Off On Adaption Laufunruhe zu gross
UDS_RDBI.dataIdentifiers[0x606d] = "Energieverbrauch Kwh Stunde"
UDS_RDBI.dataIdentifiers[0x606e] = "klassifizierung Fehlerstromsumme"
UDS_RDBI.dataIdentifiers[0x606f] = "Off Adaption Freigabe DMDFOF3"  	 # or HV Schuetze geschlossen
UDS_RDBI.dataIdentifiers[0x6070] = "On Adaption Fertig"  	 # or FuelOnBedingungAdaptionAktuell ReadyFertig, DCDC Vorgabe Niederspannung
UDS_RDBI.dataIdentifiers[0x6071] = "Fuel-Off Adaption Fertig Bereich1"  	 # or DCDC Vorgabe Hochspannung, Off Adaption Fertig Bereich1
UDS_RDBI.dataIdentifiers[0x6072] = "Fuel-Off Adaption Freigabe"  	 # or DCDC Vorgabe Strom auf Niederspannungsseite, Off Adaption Freigabe
UDS_RDBI.dataIdentifiers[0x6073] = "Off Adaption Laeuft"  	 # or FuelOffAdaptionLaeuft, DCDC Vorgabe Strom auf Hochspannungsseite
UDS_RDBI.dataIdentifiers[0x6074] = "DCDC Vorgabestatus"
UDS_RDBI.dataIdentifiers[0x6075] = "DCDC Hochspannung"
UDS_RDBI.dataIdentifiers[0x6076] = "Ergebnis der Geberradadaption Segment"
UDS_RDBI.dataIdentifiers[0x6077] = "Ergebnis der Geberradadaption Segment"
UDS_RDBI.dataIdentifiers[0x6078] = "Reset Fuel On Adaption Durchgefuehrt Hybrid"
UDS_RDBI.dataIdentifiers[0x6079] = "On Adaption Status HYBRID"
UDS_RDBI.dataIdentifiers[0x607a] = "Fuel-Off Adaption Fertig Bereich1 Hybrid"
UDS_RDBI.dataIdentifiers[0x607b] = "FuelOffAdaptionLaeuft Hybrid"
UDS_RDBI.dataIdentifiers[0x607c] = "Filterwert Fuel Off Geberradadaption"
UDS_RDBI.dataIdentifiers[0x607d] = "Off Adaption Ergebniswert DMDFOF3"
UDS_RDBI.dataIdentifiers[0x607e] = "Off Adaption KatheizSegment aktiv"
UDS_RDBI.dataIdentifiers[0x607f] = "Off Adaption Fertig KatheizSegment"
UDS_RDBI.dataIdentifiers[0x6080] = "Gemischadaption Multiplikativ"  	 # or Multiplikative Gemischadaption aktiv, Reiserechner Kraftstoffmenge erfolgreich geschrieben
UDS_RDBI.dataIdentifiers[0x6081] = "Gemischadaption Additiv"  	 # or Additive Gemischadaption aktiv
UDS_RDBI.dataIdentifiers[0x6082] = "Gemischadaption"  	 # or Kraftstoffverbrauch Lebenszeit, Gemischadaptionsphase aktiv
UDS_RDBI.dataIdentifiers[0x6083] = "Kraftstoffverbrauch Gesamtstrecke Lebenszeit"  	 # or Gemischadaption Additiver Bereich
UDS_RDBI.dataIdentifiers[0x6084] = "Kraftstoffvolumen Lebenszeit Anzeige"
UDS_RDBI.dataIdentifiers[0x6085] = "Gemischadaption Additiv Integrator Stabil"
UDS_RDBI.dataIdentifiers[0x6086] = "Gemischadaption Additiv Integrator Stabil"
UDS_RDBI.dataIdentifiers[0x6087] = "Gemischadaption Additiv Lernwert"  	 # or Additive Gemischkorrektur Bank 1 (Leerlauf)
UDS_RDBI.dataIdentifiers[0x6088] = "Additive Gemischkorrektur"
UDS_RDBI.dataIdentifiers[0x6089] = "Gemischadaption Additiv HFM"  	 # or Additive Gemischkorrektur Bank 1 HFM
UDS_RDBI.dataIdentifiers[0x6090] = "Additive Gemischkorrektur Bank 2 HFM"
UDS_RDBI.dataIdentifiers[0x6091] = "Gemischadaption Additiv Drucksensor"  	 # or Additive Gemischkorrektur Bank 1 (P-System)
UDS_RDBI.dataIdentifiers[0x6092] = "Additive Gemischkorrektur Bank 2 (P-System)"
UDS_RDBI.dataIdentifiers[0x6093] = "Grundadaption Bank 1 tra-Integrator"
UDS_RDBI.dataIdentifiers[0x6094] = "Grundadaption Bank 2 tra-Integrator"
UDS_RDBI.dataIdentifiers[0x6095] = "Integrator fra Bank 1 unten"  	 # or Gemischadaption Integrator unten Lernwert
UDS_RDBI.dataIdentifiers[0x6096] = "Integrator fra Bank 2 unten"
UDS_RDBI.dataIdentifiers[0x6097] = "Integrator tra"
UDS_RDBI.dataIdentifiers[0x6098] = "Integrator tra"
UDS_RDBI.dataIdentifiers[0x6099] = "Grundadaption Bank 1 fra-Integrator"  	 # or Gemischadaption Grundadaption Integrator
UDS_RDBI.dataIdentifiers[0x6100] = "Grundadaption Bank 2 fra-Integrator"
UDS_RDBI.dataIdentifiers[0x6101] = "Gemischadaption Multiplikativer Bereich"  	 # or Berechneter Kraftstoffdruck
UDS_RDBI.dataIdentifiers[0x6102] = "Hebelgeber rechts Widerstand"
UDS_RDBI.dataIdentifiers[0x6103] = "Gemischadaptionswert Multiplikativ Rechts Unten"  	 # or Multiplikative Gemischkorrektur Bank 1 unten (Teillast), Hebelgeber links Widerstand
UDS_RDBI.dataIdentifiers[0x6104] = "Multiplikative Gemischkorrektur Bank 2 unten"
UDS_RDBI.dataIdentifiers[0x6105] = "Gemischadaptionswert Multiplikativ"  	 # or Multiplikativer Gemischadaptionsfaktor Bank 1 (Teillast)
UDS_RDBI.dataIdentifiers[0x6106] = "Volumenstrom berechnet"  	 # or Multiplikativer Gemischadaptionsfaktor
UDS_RDBI.dataIdentifiers[0x6107] = "Gemischadaption Multiplikativ Gemischkorrektur"
UDS_RDBI.dataIdentifiers[0x6108] = "Multiplikative Gemischkorrektur"
UDS_RDBI.dataIdentifiers[0x6109] = "Typ 6letztes"
UDS_RDBI.dataIdentifiers[0x610a] = "Typ 5letztes"
UDS_RDBI.dataIdentifiers[0x610b] = "Typ 4letztes"
UDS_RDBI.dataIdentifiers[0x610c] = "Typ 3letztes"
UDS_RDBI.dataIdentifiers[0x610d] = "Typ vorletztes"
UDS_RDBI.dataIdentifiers[0x610e] = "Typ letztmaliges"
UDS_RDBI.dataIdentifiers[0x6110] = "erstmaliges"
UDS_RDBI.dataIdentifiers[0x6111] = "9letztes"  	 # or Gemischadaption Kurztest Ergebnis
UDS_RDBI.dataIdentifiers[0x6112] = "8letztes"  	 # or Gemischadaption Kurztest Ergebnis
UDS_RDBI.dataIdentifiers[0x6113] = "Gemischadaption Kurztest Errorflag"  	 # or 7letztes
UDS_RDBI.dataIdentifiers[0x6114] = "Gemischadaption Kurztest Errorflag"  	 # or 6letztes
UDS_RDBI.dataIdentifiers[0x6115] = "Gemischadaption Kurztest Zyklusflag"  	 # or 5letztes
UDS_RDBI.dataIdentifiers[0x6116] = "4letztes"  	 # or Gemischadaption Kurztest Zyklusflag
UDS_RDBI.dataIdentifiers[0x6117] = "Gemischadaption Kurztest Lambdareglerabweichung"
UDS_RDBI.dataIdentifiers[0x6118] = "Kurztest Signalfehler"
UDS_RDBI.dataIdentifiers[0x6119] = "letztes"  	 # or Gemischadaption Kurztest Ergebnis Unplausibel
UDS_RDBI.dataIdentifiers[0x6120] = "Gemischadaption Kurztest Ergebnis Unplausibel"
UDS_RDBI.dataIdentifiers[0x6121] = "Gemischadaption Additiv Fertig"
UDS_RDBI.dataIdentifiers[0x6122] = "Gemischadaption Multiplikativ Unten Fertig"
UDS_RDBI.dataIdentifiers[0x6124] = "Geschwindigkeit erstmaliges"
UDS_RDBI.dataIdentifiers[0x6125] = "Geschwindigkeit 9letztes"
UDS_RDBI.dataIdentifiers[0x6126] = "Geschwindigkeit 8letztes"
UDS_RDBI.dataIdentifiers[0x6127] = "Gemischadaption Nach Reset Fertig"
UDS_RDBI.dataIdentifiers[0x6128] = "Geschwindigkeit 6letztes"
UDS_RDBI.dataIdentifiers[0x6129] = "Geschwindigkeit 5letztes"
UDS_RDBI.dataIdentifiers[0x612a] = "Geschwindigkeit 4letztes"
UDS_RDBI.dataIdentifiers[0x612b] = "Geschwindigkeit 3letztes"
UDS_RDBI.dataIdentifiers[0x612c] = "Geschwindigkeit vorletztes"
UDS_RDBI.dataIdentifiers[0x612d] = "Geschwindigkeit letztes"
UDS_RDBI.dataIdentifiers[0x6130] = "Drehzahl erstmaliges"  	 # or Lambdaregelwert
UDS_RDBI.dataIdentifiers[0x6131] = "Lambdaregelwert"  	 # or Drehzahl 9letztes
UDS_RDBI.dataIdentifiers[0x6132] = "Lambdaregelfaktor Mittelwert"
UDS_RDBI.dataIdentifiers[0x6133] = "Schneller Mittelwert Lambdaregelfaktors"
UDS_RDBI.dataIdentifiers[0x6134] = "Mittelwert vom Produkt Abweichung Lambdaregler-Lambda"  	 # or Lambdaregler Abweichung Mittelwert
UDS_RDBI.dataIdentifiers[0x6135] = "Sondenbereitschaft Rechts Vor KAT"  	 # or O2Regelsonde Bank 1 bereit
UDS_RDBI.dataIdentifiers[0x6136] = "O2Regelsonde Bank 2 bereit"
UDS_RDBI.dataIdentifiers[0x6137] = "O2Diagnosesonde Bank 1 bereit"  	 # or Sondenbereitschaft Rechts Nach KAT
UDS_RDBI.dataIdentifiers[0x6138] = "O2Diagnosesonde Bank 2 bereit"
UDS_RDBI.dataIdentifiers[0x6139] = "Drehzahl letztes"
UDS_RDBI.dataIdentifiers[0x613a] = "Oeltemperatur erstmaliges"
UDS_RDBI.dataIdentifiers[0x613b] = "Oeltemperatur 9letztes"
UDS_RDBI.dataIdentifiers[0x613c] = "Oeltemperatur 8letztes"
UDS_RDBI.dataIdentifiers[0x613d] = "Oeltemperatur 7letztes"
UDS_RDBI.dataIdentifiers[0x613e] = "Oeltemperatur 6letztes"
UDS_RDBI.dataIdentifiers[0x613f] = "Oeltemperatur 5letztes"
UDS_RDBI.dataIdentifiers[0x6140] = "Oeltemperatur 4letztes"
UDS_RDBI.dataIdentifiers[0x6141] = "Oeltemperatur 3letztes"
UDS_RDBI.dataIdentifiers[0x6142] = "Oeltemperatur vorletztes"
UDS_RDBI.dataIdentifiers[0x6143] = "Lambda Sollwert"  	 # or Oeltemperatur letztes
UDS_RDBI.dataIdentifiers[0x6144] = "Lambda Sollwert"  	 # or rel Motorlast erstmaliges
UDS_RDBI.dataIdentifiers[0x6145] = "Sonde Anzahl Dynamikmessungen LSU"  	 # or Anzahl der Dynamikmessungen LSU rechte
UDS_RDBI.dataIdentifiers[0x6146] = "Anzahl der Dynamikmessungen LSU linke"
UDS_RDBI.dataIdentifiers[0x6147] = "Lambdaregelung I Anteil hinter Kat rechte Bank (DE"
UDS_RDBI.dataIdentifiers[0x6148] = "Lambdaregelung I Anteil hinter Kat linke Bank (DE"
UDS_RDBI.dataIdentifiers[0x6149] = "Sonde Dynamikwert Der LSU"  	 # or Dynamikwert der LSU rechte
UDS_RDBI.dataIdentifiers[0x614a] = "rel Motorlast 4letztes"
UDS_RDBI.dataIdentifiers[0x614b] = "rel Motorlast 3letztes"
UDS_RDBI.dataIdentifiers[0x614c] = "rel Motorlast vorletztes"
UDS_RDBI.dataIdentifiers[0x614d] = "rel Motorlast letztes"
UDS_RDBI.dataIdentifiers[0x614e] = "Zaehler Sensorfehler"
UDS_RDBI.dataIdentifiers[0x614f] = "Servicestatus aktuell"
UDS_RDBI.dataIdentifiers[0x6150] = "Dynamikwert der LSU linke"
UDS_RDBI.dataIdentifiers[0x6151] = "Kat Diagnose Sauerstoffspeichervermoegen gefiltert"
UDS_RDBI.dataIdentifiers[0x6152] = "Restlaufstrecke Anzeige"
UDS_RDBI.dataIdentifiers[0x6153] = "Startlaufstrecke"
UDS_RDBI.dataIdentifiers[0x6154] = "Restlaufstrecke Intern"
UDS_RDBI.dataIdentifiers[0x6155] = "Restlaufstrecke AdBlue"
UDS_RDBI.dataIdentifiers[0x6156] = "Restlaufstrecke Extern"
UDS_RDBI.dataIdentifiers[0x6157] = "Restlaufstrecke Kraftstoff"
UDS_RDBI.dataIdentifiers[0x6158] = "Restlaufstrecke Russ"
UDS_RDBI.dataIdentifiers[0x6159] = "Restlaufstrecke Viskositaet"
UDS_RDBI.dataIdentifiers[0x6160] = "Motorzustand Verbrennungsmotor laeuft"
UDS_RDBI.dataIdentifiers[0x6161] = "Leerlaufdrehzahlanhebung Abbruchgrund"  	 # or Bitleiste zur Anzeige von Abbruchgruenden bei der Erhoehung der Leerlaufdrehzahl als Steller
UDS_RDBI.dataIdentifiers[0x6162] = "Gefahrene km Verbrennungsmotor"
UDS_RDBI.dataIdentifiers[0x6163] = "Gefahrene km E-Motor"
UDS_RDBI.dataIdentifiers[0x6164] = "Katalysatordiagnose freigegeben"
UDS_RDBI.dataIdentifiers[0x6165] = "Normiertes Sauerstoffspeichervermoegen des Katalysators, rechte"  	 # or Kat Diagnose Sauerstoffspeichervermoegen normiert
UDS_RDBI.dataIdentifiers[0x6166] = "Normiertes Sauerstoffspeichervermoegen des Katalysators, linke"  	 # or Oelstand
UDS_RDBI.dataIdentifiers[0x6167] = "Kat Diagnose Sauerstoffspeichervermoegen"  	 # or Oelstand Prozent
UDS_RDBI.dataIdentifiers[0x6168] = "Oelstand VolumenGespeichert"
UDS_RDBI.dataIdentifiers[0x6169] = "Kat Diagnose Laeuft"  	 # or Oelstand VolumenGespeichertGefiltert, Katalysatordiagnose laeuft
UDS_RDBI.dataIdentifiers[0x616a] = "Katalysatordiagnose laeuft Links"
UDS_RDBI.dataIdentifiers[0x6170] = "Oelstand KilometertstandLetzteSpeicherung"
UDS_RDBI.dataIdentifiers[0x6171] = "Oelstand StatusErkennung"  	 # or Testerverstellzyklus Nockenwelle Auslass Bank 1 beendet
UDS_RDBI.dataIdentifiers[0x6172] = "Testerverstellzyklus Nockenwelle Auslass Bank 2 beendet"  	 # or Oelstand Oelvolumen
UDS_RDBI.dataIdentifiers[0x6173] = "Testerverstellzyklus Nockenwelle Einlass Bank 1 beendet"  	 # or Oelstand Oelverbrauch, Nockenwelle Einlass Testerverstellzyklus Rechts Beendet
UDS_RDBI.dataIdentifiers[0x6174] = "Oelstand ModellwertOelverduennung"  	 # or Testerverstellzyklus Nockenwelle Einlass Bank 2 beendet
UDS_RDBI.dataIdentifiers[0x6175] = "Oelstand AnzahlSpeicherungen"  	 # or Nockenwellenzustand Auslass
UDS_RDBI.dataIdentifiers[0x6176] = "Nockenwelle Einlass Zustand"  	 # or Nockenwellenzustand Einlass
UDS_RDBI.dataIdentifiers[0x6177] = "Restlaufstrecke Motoroel"
UDS_RDBI.dataIdentifiers[0x6178] = "Restlaufstrecke Min Motoroel"
UDS_RDBI.dataIdentifiers[0x6179] = "Restlaufstrecke Max Motoroel"  	 # or Nockenwelle Auslass Grob Feinadaption Beendet
UDS_RDBI.dataIdentifiers[0x6180] = "Tageszaehler erstmaliges"
UDS_RDBI.dataIdentifiers[0x6181] = "Tageszaehler 9letztes"
UDS_RDBI.dataIdentifiers[0x6182] = "Tageszaehler 8letztes"
UDS_RDBI.dataIdentifiers[0x6183] = "Tageszaehler 7letztes"  	 # or Nockenwellenwinkel Sollwert Einlass
UDS_RDBI.dataIdentifiers[0x6184] = "Tageszaehler 6letztes"
UDS_RDBI.dataIdentifiers[0x6185] = "Tageszaehler 5letztes"
UDS_RDBI.dataIdentifiers[0x6186] = "Tageszaehler 4letztes"
UDS_RDBI.dataIdentifiers[0x6187] = "Tageszaehler 3letztes"
UDS_RDBI.dataIdentifiers[0x6188] = "Tageszaehler vorletztes"
UDS_RDBI.dataIdentifiers[0x6189] = "Tageszaehler letztes"
UDS_RDBI.dataIdentifiers[0x618a] = "Oelstand erstmaliges"
UDS_RDBI.dataIdentifiers[0x618b] = "Oelstand 9letztes"
UDS_RDBI.dataIdentifiers[0x618c] = "Oelstand 8letztes"
UDS_RDBI.dataIdentifiers[0x618d] = "Oelstand 7letztes"
UDS_RDBI.dataIdentifiers[0x618e] = "Oelstand 6letztes"
UDS_RDBI.dataIdentifiers[0x618f] = "Oelstand 5letztes"
UDS_RDBI.dataIdentifiers[0x6190] = "Oelstand 4letztes"
UDS_RDBI.dataIdentifiers[0x6191] = "Oelstand 3letztes"
UDS_RDBI.dataIdentifiers[0x6192] = "Oelstand vorletztes"
UDS_RDBI.dataIdentifiers[0x6193] = "Oelstand letztes"
UDS_RDBI.dataIdentifiers[0x6194] = "Verbrauch fl ssiger Kraftstoff seit RESET"
UDS_RDBI.dataIdentifiers[0x6195] = "Verbrauch fl ssiger Kraftstoff seit START"
UDS_RDBI.dataIdentifiers[0x6196] = "Verbrauch gasf rmiger Kraftstoff seit RESET"
UDS_RDBI.dataIdentifiers[0x6197] = "Verbrauch gasf rmiger Kraftstoff seit START"
UDS_RDBI.dataIdentifiers[0x6198] = "Verbrauch elektrischer Energie seit RESET"
UDS_RDBI.dataIdentifiers[0x6199] = "Verbrauch elektrischer Energie seit Start"
UDS_RDBI.dataIdentifiers[0x619a] = "Distance seit RESET Kraftstoff"
UDS_RDBI.dataIdentifiers[0x619b] = "Distance seit START Kraftstoff"
UDS_RDBI.dataIdentifiers[0x619c] = "Distance seit RESET el Energie"
UDS_RDBI.dataIdentifiers[0x619d] = "Distance seit START el Energie"
UDS_RDBI.dataIdentifiers[0x619e] = "Anzeige ECO Beschleunigung"
UDS_RDBI.dataIdentifiers[0x619f] = "Anzeige ECO Rollen"
UDS_RDBI.dataIdentifiers[0x61a0] = "Anzeige Bonus Reichweite"
UDS_RDBI.dataIdentifiers[0x61a1] = "Anzeige ECO Gesamt"
UDS_RDBI.dataIdentifiers[0x61a2] = "Anzeige ECO Konstanz"
UDS_RDBI.dataIdentifiers[0x61b0] = "Stoppverbot Verursacher Benzinmotor KatWarmUp"
UDS_RDBI.dataIdentifiers[0x61b1] = "Stoppverbot Verursacher Benzinmotor Katheizen"
UDS_RDBI.dataIdentifiers[0x61b2] = "Stoppverbot Verursacher Benzinmotor Diag KG Entlueftung"
UDS_RDBI.dataIdentifiers[0x61b3] = "Stoppverbot Verursacher Benzinmotor Tankentlueftung"
UDS_RDBI.dataIdentifiers[0x61b4] = "Stoppverbot Verursacher Benzinmotor Diag Tankentlueftung"
UDS_RDBI.dataIdentifiers[0x61b5] = "Stoppverbot Verursacher Benzinmotor Gemischadaption"
UDS_RDBI.dataIdentifiers[0x61b6] = "Stoppverbot Verursacher Benzinmotor Erststart"
UDS_RDBI.dataIdentifiers[0x61b7] = "Stoppverbot Verursacher Benzinmotor Diag Abgas"
UDS_RDBI.dataIdentifiers[0x61b8] = "Stoppverbot Verursacher Benzinmotor OPF"
UDS_RDBI.dataIdentifiers[0x61b9] = "Stoppverbot Verursacher Benzinmotor Umgebungsbedingungen"
UDS_RDBI.dataIdentifiers[0x61ba] = "Stoppverbot Verursacher Benzinmotor Geberradadaption"
UDS_RDBI.dataIdentifiers[0x61bb] = "Stoppverbot Verursacher Benzinmotor Thermomanagement"
UDS_RDBI.dataIdentifiers[0x61bc] = "Stoppverbot Verursacher Benzinmotor Zylindergleichstellung"
UDS_RDBI.dataIdentifiers[0x61bd] = "Stoppverbot Verursacher Benzinmotor Testeranforderung Bandende"
UDS_RDBI.dataIdentifiers[0x61c0] = "Start Stopp vorhStartanforderer Benzinmotor"
UDS_RDBI.dataIdentifiers[0x6200] = "Warnspeicherreset Read ASSYST Warnspeicher km Stand Warnspeicherreset"  	 # or Start Stopp Vorbedingungen mech Getriebe
UDS_RDBI.dataIdentifiers[0x6201] = "Start Stopp Fehlerstatus"  	 # or Zaehler Min Schalter Read ASSYST Warnspeicher Zaehler Min Schalter
UDS_RDBI.dataIdentifiers[0x6202] = "Zaehler Min"  	 # or Stoppverbot Verursacher ASSP
UDS_RDBI.dataIdentifiers[0x6203] = "Start Stopp Startanforderer HDC"  	 # or Zaehler Ueberfuellung Read ASSYST Warnspeicher Zaehler Ueberfuellung
UDS_RDBI.dataIdentifiers[0x6204] = "Stoppverbot Verursacher System"  	 # or Zaehler Unterfuellung 2 Read ASSYST Warnspeicher Zaehler Unterfuellung
UDS_RDBI.dataIdentifiers[0x6205] = "Typ erstmaliges Auftreten Read ASSYST Warnspeicher Typ erstmaliges"  	 # or Start Stopp vorhFStatus
UDS_RDBI.dataIdentifiers[0x6206] = "Start Stopp vorhFStatus km Stand"  	 # or Typ 9letztes Auftreten Read ASSYST Warnspeicher Typ 9letztes
UDS_RDBI.dataIdentifiers[0x6207] = "Typ 8letztes Auftreten Read ASSYST Warnspeicher Typ 8letztes"  	 # or Stoppverbot Verursacher STCSys
UDS_RDBI.dataIdentifiers[0x6208] = "Start Stopp Startanforderer STC"  	 # or Typ 7letztes Auftreten Read ASSYST Warnspeicher Typ 7letztes
UDS_RDBI.dataIdentifiers[0x6209] = "Typ 6letztes Auftreten Read ASSYST Warnspeicher Typ 6letztes"  	 # or Start Stopp erweiterte Analyse
UDS_RDBI.dataIdentifiers[0x620a] = "Typ 5letztes Auftreten Read ASSYST Warnspeicher Typ 5letztes"  	 # or Start Stopp Interface MSG CPC
UDS_RDBI.dataIdentifiers[0x620b] = "Start Stopp Interface CPC MSG"  	 # or Typ 4letztes Auftreten Read ASSYST Warnspeicher Typ 4letztes
UDS_RDBI.dataIdentifiers[0x620c] = "Typ 3letztes Auftreten Read ASSYST Warnspeicher Typ 3letztes"  	 # or Startanforderung Hybrid
UDS_RDBI.dataIdentifiers[0x620d] = "Startanforderung Erststart"  	 # or Typ vorletztes Auftreten Read ASSYST Warnspeicher Typ vorletztes
UDS_RDBI.dataIdentifiers[0x620e] = "Typ letztmaliges Auftreten Read ASSYST Warnspeicher Typ letztmaliges"
UDS_RDBI.dataIdentifiers[0x620f] = "Getriebefreigabe Automatgetriebe"
UDS_RDBI.dataIdentifiers[0x6210] = "Sekundaerluft Aktiv"  	 # or erstmaliges Auftreten Read ASSYST Warnspeicher km Stand erstmaliges
UDS_RDBI.dataIdentifiers[0x6211] = "9letztes Auftreten Read ASSYST Warnspeicher km Stand 9letztes"  	 # or Sekundaerluftdiagnose Aktiv, SLS-Diagnose aktiv
UDS_RDBI.dataIdentifiers[0x6212] = "Sekundaerluft Relative Sekundaerluftmasse"  	 # or 8letztes Auftreten Read ASSYST Warnspeicher km Stand 8letztes
UDS_RDBI.dataIdentifiers[0x6213] = "Stoppverbot Verursacher Ringspeicher 4"  	 # or 7letztes Auftreten Read ASSYST Warnspeicher km Stand 7letztes
UDS_RDBI.dataIdentifiers[0x6214] = "Stoppverbot Verursacher Ringspeicher 5"  	 # or Sekundaerluft Relative SL Masse Gefiltert, 6letztes Auftreten Read ASSYST Warnspeicher km Stand 6letztes
UDS_RDBI.dataIdentifiers[0x6215] = "5letztes Auftreten Read ASSYST Warnspeicher km Stand 5letztes"
UDS_RDBI.dataIdentifiers[0x6216] = "Sekundaerluft Relative SL Masse Ventil Check"  	 # or 4letztes Auftreten Read ASSYST Warnspeicher km Stand 4letztes
UDS_RDBI.dataIdentifiers[0x6217] = "3letztes Auftreten Read ASSYST Warnspeicher km Stand 3letztes"
UDS_RDBI.dataIdentifiers[0x6218] = "vorletztes Auftreten Read ASSYST Warnspeicher km Stand vorletztes"
UDS_RDBI.dataIdentifiers[0x6219] = "letztes Auftreten Read ASSYST Warnspeicher km Stand letztes"
UDS_RDBI.dataIdentifiers[0x621a] = "Oeldatensatz erstmaligesAuftreten"  	 # or ID Oeldatensatz erstmaligesAuftreten, Oeldatensatz erstmaligesAuftreten Read ASSYST Warnspeicher ID Oeldatensatz erstmaligesAuftreten
UDS_RDBI.dataIdentifiers[0x621b] = "Oeldatensatz 9letztes Auftreten Read ASSYST Warnspeicher ID Oeldatensatz 9letztes"  	 # or ID Oeldatensatz 9letztes, Oeldatensatz 9letztes
UDS_RDBI.dataIdentifiers[0x621c] = "ID Oeldatensatz 8letztes"  	 # or Oeldatensatz 8letztes, Oeldatensatz 8letztes Auftreten Read ASSYST Warnspeicher ID Oeldatensatz 8letztes
UDS_RDBI.dataIdentifiers[0x621d] = "Oeldatensatz 7letztes"  	 # or Oeldatensatz 7letztes Auftreten Read ASSYST Warnspeicher ID Oeldatensatz 7letztes, ID Oeldatensatz 7letztes
UDS_RDBI.dataIdentifiers[0x621e] = "Oeldatensatz 6letztes Auftreten Read ASSYST Warnspeicher ID Oeldatensatz 6letztes"  	 # or Oeldatensatz 6letztes, ID Oeldatensatz 6letztes
UDS_RDBI.dataIdentifiers[0x621f] = "Oeldatensatz 5letztes Auftreten Read ASSYST Warnspeicher ID Oeldatensatz 5letztes"  	 # or ID Oeldatensatz 5letztes, Oeldatensatz 5letztes
UDS_RDBI.dataIdentifiers[0x6220] = "Oeldatensatz 4letztes"  	 # or Kupplungsschutz km Ueberschreiten Kupplungstemperatur erstmalig, Oeldatensatz 4letztes Auftreten Read ASSYST Warnspeicher ID Oeldatensatz 4letztes, ID Oeldatensatz 4letztes, Tankdichtigkeitspruefung Druckverlustgradient Ist
UDS_RDBI.dataIdentifiers[0x6221] = "ID Oeldatensatz 3letztes"  	 # or Oeldatensatz 3letztes Auftreten Read ASSYST Warnspeicher ID Oeldatensatz 3letztes, Oeldatensatz 3letztes, Kupplungsschutz Kupplungstemperatur erstmalig, Tankdichtigkeitspruefung Druckverlustgradient Fehlerschwelle
UDS_RDBI.dataIdentifiers[0x6222] = "ID Oeldatensatz vorletztes"  	 # or Oeldatensatz vorletztes, Oeldatensatz vorletztes Auftreten Read ASSYST Warnspeicher ID Oeldatensatz vorletztes, Kupplungsschutz Anzahl Halten am Berg Stufe1, Tankdichtigkeitspruefung Aufbaugradient Vorhanden
UDS_RDBI.dataIdentifiers[0x6223] = "Oeldatensatz letztes Auftreten Read ASSYST Warnspeicher ID Oeldatensatz letztes"  	 # or Tankdichtigkeitspruefung Fertig, Oeldatensatz letztes, Kupplungsschutz Anzahl Halten am Berg Stufe2, ID Oeldatensatz letztes
UDS_RDBI.dataIdentifiers[0x6224] = "Kupplungsschutz km Halten am Berg Stufe1"  	 # or Geschwindigkeit erstmaligesAuftreten Read ASSYST Warnspeicher Geschwindigkeit erstmaligesAuftreten, Tankdichtigkeitspruefung
UDS_RDBI.dataIdentifiers[0x6225] = "Geschwindigkeit 9letztes Auftreten Read ASSYST Warnspeicher Geschwindigkeit 9letztes"  	 # or Kupplungsschutz Kupplungstemperatur Halten am Berg Stufe1, Tankdichtigkeitspruefung Abbruchstatus
UDS_RDBI.dataIdentifiers[0x6226] = "Kupplungsschutz Ringspeicher"  	 # or Tankdichtigkeitspruefung Grobleck Erkannt, Geschwindigkeit 8letztes Auftreten Read ASSYST Warnspeicher Geschwindigkeit 8letztes
UDS_RDBI.dataIdentifiers[0x6227] = "Geschwindigkeit 7letztes Auftreten Read ASSYST Warnspeicher Geschwindigkeit 7letztes"  	 # or Tankdichtigkeitspruefung Ausgasung Zu Gross, Kupplungsschutz Ringspeicher Kupplungstemperatur
UDS_RDBI.dataIdentifiers[0x6228] = "Tankdichtigkeitspruefung Aktiv"  	 # or Geschwindigkeit 6letztes Auftreten Read ASSYST Warnspeicher Geschwindigkeit 6letztes, Kupplungsschutz Ringspeicher km
UDS_RDBI.dataIdentifiers[0x6229] = "Geschwindigkeit 5letztes Auftreten Read ASSYST Warnspeicher Geschwindigkeit 5letztes"  	 # or Tankdichtigkeitspruefung Sammelabbruch, Kupplungsschutz Ringspeicher Dauer
UDS_RDBI.dataIdentifiers[0x622a] = "Tankdichtigkeitspruefung Unterdruckabbaugradient"  	 # or Geschwindigkeit 4letztes Auftreten Read ASSYST Warnspeicher Geschwindigkeit 4letztes
UDS_RDBI.dataIdentifiers[0x622b] = "Geschwindigkeit 3letztes Auftreten Read ASSYST Warnspeicher Geschwindigkeit 3letztes"
UDS_RDBI.dataIdentifiers[0x622c] = "Geschwindigkeit vorletztes Auftreten Read ASSYST Warnspeicher Geschwindigkeit vorletztes"
UDS_RDBI.dataIdentifiers[0x622d] = "Geschwindigkeit letztes Auftreten Read ASSYST Warnspeicher Geschwindigkeit letztes"
UDS_RDBI.dataIdentifiers[0x6230] = "Tankdichtigkeitspruefung Lambdaregler Abbruch"  	 # or Drehzahl erstmaliges Auftreten Read ASSYST Warnspeicher Drehzahl erstmaliges, Kupplungsschutz Anzahl Kombimeldung Kupplung heiss
UDS_RDBI.dataIdentifiers[0x6231] = "Tankdichtigkeitspruefung Max Abweichung Lambda"  	 # or Kupplungsschutz km letzte Anzeige Kupplung heiss, Drehzahl 9letztes Auftreten Read ASSYST Warnspeicher Drehzahl 9letztes
UDS_RDBI.dataIdentifiers[0x6232] = "Drehzahl 8letztes Auftreten Read ASSYST Warnspeicher Drehzahl 8letztes"  	 # or Tankentlueftung Ausgasungswert
UDS_RDBI.dataIdentifiers[0x6233] = "Kupplungsschutz km erster HauptplausiError"  	 # or Drehzahl 7letztes Auftreten Read ASSYST Warnspeicher Drehzahl 7letztes, Tankentlueftung Zeit Seit Start Minus Parkzeit
UDS_RDBI.dataIdentifiers[0x6234] = "Kupplungsschutz km letzter HauptplausiError"  	 # or Drehzahl 6letztes Auftreten Read ASSYST Warnspeicher Drehzahl 6letztes, Tankdichtigkeitspruefung Basisbedingung Erfuellt
UDS_RDBI.dataIdentifiers[0x6235] = "Drehzahl 5letztes Auftreten Read ASSYST Warnspeicher Drehzahl 5letztes"  	 # or Kupplungsschutz Laufstrecke mit HauptplausiError, Tankdichtigkeitspruefung Freigabebedingung Sperrfehler
UDS_RDBI.dataIdentifiers[0x6236] = "Drehzahl 4letztes Auftreten Read ASSYST Warnspeicher Drehzahl 4letztes"  	 # or Tankdichtigkeitspruefung Freigabebedingung Lambda
UDS_RDBI.dataIdentifiers[0x6237] = "Drehzahl 3letztes Auftreten Read ASSYST Warnspeicher Drehzahl 3letztes"  	 # or Tankdichtigkeitspruefung Freigabebedingung Tankdruck
UDS_RDBI.dataIdentifiers[0x6238] = "Drehzahl vorletztes Auftreten Read ASSYST Warnspeicher Drehzahl vorletztes"  	 # or Tankdichtigkeitspruefung Freigabebedingung Batteriespannung
UDS_RDBI.dataIdentifiers[0x6239] = "Tankdichtigkeitspruefung Freigabebedingung Einspritzventile"  	 # or Drehzahl letztes Auftreten Read ASSYST Warnspeicher Drehzahl letztes, Segelvorbedingung Fahrzustand
UDS_RDBI.dataIdentifiers[0x623a] = "Oeltemperatur erstmaliges Auftreten Read ASSYST Warnspeicher Oeltemperatur erstmaliges"  	 # or Segelausloeser letztes Segeln
UDS_RDBI.dataIdentifiers[0x623b] = "Oeltemperatur 9letztes Auftreten Read ASSYST Warnspeicher Oeltemperatur 9letztes"
UDS_RDBI.dataIdentifiers[0x623c] = "Oeltemperatur 8letztes Auftreten Read ASSYST Warnspeicher Oeltemperatur 8letztes"  	 # or Segeleintrittsbedingung
UDS_RDBI.dataIdentifiers[0x623d] = "Segelaustrittsbedingung letztes Segeln"  	 # or Oeltemperatur 7letztes Auftreten Read ASSYST Warnspeicher Oeltemperatur 7letztes
UDS_RDBI.dataIdentifiers[0x623e] = "Oeltemperatur 6letztes"
UDS_RDBI.dataIdentifiers[0x623f] = "Segelaustrittsbedingungen"  	 # or Oeltemperatur 5letztes Auftreten Read ASSYST Warnspeicher Oeltemperatur 5letztes
UDS_RDBI.dataIdentifiers[0x6240] = "Oeltemperatur 4letztes Auftreten Read ASSYST Warnspeicher Oeltemperatur 4letztes"  	 # or Tankdichtigkeitspruefung Freigabebedingung Erkannt
UDS_RDBI.dataIdentifiers[0x6241] = "Tankentlueftung Relativer Gemischanteil"  	 # or Relativer Gemischanteil Tankentlueftung, Oeltemperatur 3letztes Auftreten Read ASSYST Warnspeicher Oeltemperatur 3letztes
UDS_RDBI.dataIdentifiers[0x6242] = "Oeltemperatur vorletztes Auftreten Read ASSYST Warnspeicher Oeltemperatur vorletztes"  	 # or Tankentlueftung Massenstrom, Massenstrom Tankentlueftung ins Saugrohr
UDS_RDBI.dataIdentifiers[0x6243] = "Oeltemperatur letztes Auftreten Read ASSYST Warnspeicher Oeltemperatur letztes"
UDS_RDBI.dataIdentifiers[0x6244] = "Aktivkohlefilter Beladung"  	 # or Beladung des Aktivkohlefilters, Segelverbot Verursacher Motor, rel Motorlast erstmaliges Auftreten Read ASSYST Warnspeicher rel Motorlast erstmaliges
UDS_RDBI.dataIdentifiers[0x6245] = "Relative Kraftstoffmasse"  	 # or rel Motorlast 9letztes Auftreten Read ASSYST Warnspeicher rel Motorlast 9letztes, Kraftstoffmasse Relativ
UDS_RDBI.dataIdentifiers[0x6246] = "rel Motorlast 8letztes Auftreten Read ASSYST Warnspeicher rel Motorlast 8letztes"  	 # or Aktivkohlefilter Beladung gefiltert, Beladung des Aktivkohlefilters - gefiltert
UDS_RDBI.dataIdentifiers[0x6247] = "Segelverf gbarkeit"  	 # or rel Motorlast 7letztes Auftreten Read ASSYST Warnspeicher rel Motorlast 7letztes
UDS_RDBI.dataIdentifiers[0x6248] = "rel Motorlast 6letztes Auftreten Read ASSYST Warnspeicher rel Motorlast 6letztes"  	 # or Segelstrategie
UDS_RDBI.dataIdentifiers[0x6249] = "rel Motorlast 5letztes Auftreten Read ASSYST Warnspeicher rel Motorlast 5letztes"
UDS_RDBI.dataIdentifiers[0x624a] = "rel Motorlast 4letztes Auftreten Read ASSYST Warnspeicher rel Motorlast 4letztes"
UDS_RDBI.dataIdentifiers[0x624b] = "Tankentlueftung LPV Sollwert"  	 # or rel Motorlast 3letztes Auftreten Read ASSYST Warnspeicher rel Motorlast 3letztes
UDS_RDBI.dataIdentifiers[0x624c] = "Tankentlueftung aktiv"  	 # or rel Motorlast vorletztes Auftreten Read ASSYST Warnspeicher rel Motorlast vorletztes
UDS_RDBI.dataIdentifiers[0x624d] = "rel Motorlast letztes Auftreten Read ASSYST Warnspeicher rel Motorlast letztes"
UDS_RDBI.dataIdentifiers[0x624e] = "Zaehler Sensorfehler"
UDS_RDBI.dataIdentifiers[0x6250] = "Segeln"  	 # or Restlaufzeit Read ASSYST Serviceintervall Restlaufzeit, Serviceintervall Restlaufzeit
UDS_RDBI.dataIdentifiers[0x6251] = "Strecke seit Oelwechsel Read ASSYST Serviceintervall Strecke seit Oelwechsel"  	 # or Serviceintervall Strecke seit Oelwechsel, Klopfregelung Freigabe, Freigabe Klopfregelung, Segeln Aktiv
UDS_RDBI.dataIdentifiers[0x6252] = "Segeln Anforderung Motor"  	 # or Serviceintervall Restlaufstrecke Anzeige, Restlaufstrecke Anzeige Read ASSYST Serviceintervall Restlaufstrecke Anzeige
UDS_RDBI.dataIdentifiers[0x6253] = "Startlaufstrecke Oelfehlvolumen"  	 # or Lenkwinkel Adaptiert Max, Serviceintervall Startlaufstrecke Oelfehlvolumen, Ladungsbewegungsklappe Freigabe, Startlaufstrecke Oelfehlvolumen Read ASSYST Serviceintervall Startlaufstrecke Oelfehlvolumen
UDS_RDBI.dataIdentifiers[0x6254] = "Serviceintervall Restlaufstrecke Intern"  	 # or Lenkwinkel Adaptiert Max Links
UDS_RDBI.dataIdentifiers[0x6255] = "Restlaufstrecke AdBlue Read ASSYST Serviceintervall Restlaufstrecke AdBlue"
UDS_RDBI.dataIdentifiers[0x6256] = "Schaltlinienverschiebung"  	 # or Istmoment Verbrennungsmotor
UDS_RDBI.dataIdentifiers[0x6257] = "Fehlerspeicher Kilometer Seit Loeschen Read Fehlerspeicher Kilometer Seit Loeschen"  	 # or Sollmoment Verbrennungsmotor, Gefahrene Kilometer seit letztem Fehlerspeicher loeschen oder Powerfail, Fehlerspeicher Kilometer Seit Loeschen F M Veh dist on last clear nvv
UDS_RDBI.dataIdentifiers[0x6258] = "Bedingung Einspritzventile aktiv"  	 # or Istmoment Elektromaschine, Einspritzventile Freigabe
UDS_RDBI.dataIdentifiers[0x6259] = "Sollmoment Elektromaschine"
UDS_RDBI.dataIdentifiers[0x625a] = "Fehlerspeicher Zeit Seit Loeschen Read Fehlerspeicher Zeit Seit Loeschen"  	 # or Fehlerspeicher Zeit Seit Loeschen F M Elapsed time since clear, Sollmoment aus der Momentenkoordination
UDS_RDBI.dataIdentifiers[0x625b] = "Statussignal aus der Momentenkoordination"
UDS_RDBI.dataIdentifiers[0x6260] = "LLDrehzahlbegrenzung Zeitzaehler bis Aktivierung"  	 # or Einspritzung Uebergangskomp Adaptfaktor BA
UDS_RDBI.dataIdentifiers[0x6261] = "Restlaufstrecke Kraftstoff Read 1 ASSYST Serviceintervall Restlaufstrecke Kraftstoff"  	 # or LLDrehzahlbegrenzung Zeitzaehler aktiv
UDS_RDBI.dataIdentifiers[0x6262] = "Einspritzung Uebergangskomp Adaptfaktor VA"  	 # or Serviceintervall Tageszaehler, LLDrehzahlbegrenzung aktuelle Drehzahlgrenze
UDS_RDBI.dataIdentifiers[0x6263] = "Serviceintervall Freigegebene Oelsorten Byte1"  	 # or Lastkurvenvorgabe Hybrid
UDS_RDBI.dataIdentifiers[0x6264] = "Massenstrom Nebenfuellungssignal Korrektur Faktor"  	 # or Korrekturfaktor Massenstrom NFS, Lastkurvenvorgabe Hybrid Fehlerstatus, Serviceintervall Freigegebene Oelsorten Byte2
UDS_RDBI.dataIdentifiers[0x6265] = "Korrekturfaktor langsamer MSA"  	 # or Serviceintervall Startlaufzeit, Status Hybrid Modus Schalter, Massenstrom Langsamer Abgleich Korrektur
UDS_RDBI.dataIdentifiers[0x6266] = "Korrekturfaktor langsamer MSA (auch bei Fehlerfall in Betrieb)"  	 # or Lastkurvenvorgabe Hybrid zulaessiges min Moment
UDS_RDBI.dataIdentifiers[0x6267] = "Korrekturfaktor Massenstrom NFS (HFM-Fehler o. DK aktiv)"  	 # or Massenstrom Nebenfuellungssignal Korrektur Fehlerfall, Lastkurvenvorgabe Hybrid zulaessiges max Moment
UDS_RDBI.dataIdentifiers[0x6268] = "Massenstrom Schneller Abgleich Korrektur"
UDS_RDBI.dataIdentifiers[0x6269] = "Drosselklappe Leckluftmassenstrom"
UDS_RDBI.dataIdentifiers[0x626a] = "Massenstrom Abgas Kat"
UDS_RDBI.dataIdentifiers[0x626b] = "Abgasmassenstrom im Kat (DE"
UDS_RDBI.dataIdentifiers[0x626c] = "Massenstrom Abgas Hauptkat"
UDS_RDBI.dataIdentifiers[0x626d] = "Abgasmassenstrom Hauptkat (DE"
UDS_RDBI.dataIdentifiers[0x626e] = "Massenstrom Nebenfuellungssignal Korrektur Offset"
UDS_RDBI.dataIdentifiers[0x6270] = "Multiplikative Korrektur von fupsrl"  	 # or MonLev3 trap reason error code
UDS_RDBI.dataIdentifiers[0x6271] = "Offsetkorrektur von pbrintuk w HFM/DSS Adaption"  	 # or MonLev3 last occurred reset type
UDS_RDBI.dataIdentifiers[0x6272] = "Momentenadaption Leerlauf Klima Fahrstufe"  	 # or MonLev3 reset causing core id
UDS_RDBI.dataIdentifiers[0x6273] = "MonLev3 last occurred reset symptom"  	 # or Momentenadaption Leerlauf Fahrstufe
UDS_RDBI.dataIdentifiers[0x6274] = "MonLev3 data error address"  	 # or Momentenadaption Leerlauf Klima
UDS_RDBI.dataIdentifiers[0x6275] = "MonLev3 SMU alarm handler error code0"  	 # or Momentenadaption Leerlauf
UDS_RDBI.dataIdentifiers[0x6276] = "MonLev3 caller stack error address0"
UDS_RDBI.dataIdentifiers[0x6277] = "Momentenadaption Leerlauf Langzeitintegral"  	 # or Delta Moment aus Momentenadaption - zeitl. Mittelwert des I-Anteils
UDS_RDBI.dataIdentifiers[0x6278] = "Anzahl Starts mit Benzin im Oel"
UDS_RDBI.dataIdentifiers[0x6279] = "Adaptierter Max. Lenkwinkel"
UDS_RDBI.dataIdentifiers[0x627a] = "Massenstrom ueber DK Offsetadaption eingeschwungen"
UDS_RDBI.dataIdentifiers[0x6280] = "HV Interlockfehler OpenCableDetection"
UDS_RDBI.dataIdentifiers[0x6281] = "HV Interlockfehler OpenCableDetection Interlock Zeitstempel"
UDS_RDBI.dataIdentifiers[0x6282] = "HV Isolationsfehlererkennung Widerstand Zustand1"
UDS_RDBI.dataIdentifiers[0x6283] = "Status der Wegfahrsperre"  	 # or HV Isolationsfehlererkennung Widerstand Zustand2
UDS_RDBI.dataIdentifiers[0x6284] = "HV Isolationsfehlererkennung Widerstand Zustand3"
UDS_RDBI.dataIdentifiers[0x6285] = "HV Isolationsfehlererkennung Widerstand Zustand4"
UDS_RDBI.dataIdentifiers[0x6286] = "HV Isolationsfehlererkennung Widerstand Zustand5"
UDS_RDBI.dataIdentifiers[0x6287] = "HV Isolationsfehlererkennung Widerstand Zustand6"
UDS_RDBI.dataIdentifiers[0x6288] = "HV Isolationsfehlererkennung Widerstand Zustand7"
UDS_RDBI.dataIdentifiers[0x6289] = "HV Isolationsfehlererkennung Widerstand Zustand8"
UDS_RDBI.dataIdentifiers[0x628a] = "HV Isolationsfehlererkennung Widerstand Zustand9"
UDS_RDBI.dataIdentifiers[0x628b] = "HV Isolationsfehlererkennung Widerstand Zustand10"
UDS_RDBI.dataIdentifiers[0x6290] = "HV Sperre durch Motorhaube und Klemme15"
UDS_RDBI.dataIdentifiers[0x6291] = "Ueberwachungserweiterung Freigabe"
UDS_RDBI.dataIdentifiers[0x6292] = "Ueberwachungserweiterung Einzelfreigabe"
UDS_RDBI.dataIdentifiers[0x6293] = "Ueberwachungserweiterung MSG Anforderung aktiv"
UDS_RDBI.dataIdentifiers[0x62a0] = "Luefteranforderung Klima"
UDS_RDBI.dataIdentifiers[0x62a1] = "Luefteranforderung Ladelufttemperatur"
UDS_RDBI.dataIdentifiers[0x62a2] = "Luefteranforderung Tube Hybrid"
UDS_RDBI.dataIdentifiers[0x62a3] = "Luefteranforderung Getriebeoeltemperatur"
UDS_RDBI.dataIdentifiers[0x62a4] = "Luefteranforderung allgemein"
UDS_RDBI.dataIdentifiers[0x62a5] = "Luefteranforderung Kuehlmitteltemperatur dynamisch"
UDS_RDBI.dataIdentifiers[0x62a6] = "Luefteranforderung Kuehlmitteltemperatur NT1"
UDS_RDBI.dataIdentifiers[0x62a7] = "Luefteranforderung Kuehlmitteltemperatur NT2"
UDS_RDBI.dataIdentifiers[0x62b0] = "Masseband Widerstand DCDCWandler"
UDS_RDBI.dataIdentifiers[0x62b1] = "Masseband Widerstand Motor"
UDS_RDBI.dataIdentifiers[0x62b2] = "Masseband Widerstand Vertrauensintervall DCDCWandler"
UDS_RDBI.dataIdentifiers[0x62b3] = "Masseband Widerstand Vertrauensintervall Motor"
UDS_RDBI.dataIdentifiers[0x62b4] = "Masseband Widerstandswert gueltig DCDCWandler"
UDS_RDBI.dataIdentifiers[0x62b5] = "Masseband Widerstandswert gueltig Motor"
UDS_RDBI.dataIdentifiers[0x62b6] = "Masseband Spannungsdifferenz"
UDS_RDBI.dataIdentifiers[0x62c0] = "Start Stopp letzter misslungener Autostart km Stand"
UDS_RDBI.dataIdentifiers[0x62c1] = "Start Stopp letzter misslungener Autostart Analysewerte1"
UDS_RDBI.dataIdentifiers[0x62c2] = "Start Stopp letzter misslungener Autostart Analysewerte2"
UDS_RDBI.dataIdentifiers[0x62c3] = "Start Stopp Startanforderer Verursacher System"
UDS_RDBI.dataIdentifiers[0x62c4] = "Start Stopp Startanforderer Verursacher motorisch"
UDS_RDBI.dataIdentifiers[0x62c5] = "Drive Betrebsart aktuell"
UDS_RDBI.dataIdentifiers[0x62c6] = "Drive Betriebsart Aggregate"
UDS_RDBI.dataIdentifiers[0x62c7] = "Drive Aggegrate Zustand"
UDS_RDBI.dataIdentifiers[0x62c8] = "Drive erlaubte Betriebszust nde"  	 # or Drive erlaubte Betriebszustaende
UDS_RDBI.dataIdentifiers[0x62c9] = "Drive Ursprungfehler"
UDS_RDBI.dataIdentifiers[0x62ca] = "Start Stopp Startanforderer Verursacher Motorlauf"
UDS_RDBI.dataIdentifiers[0x62cb] = "Start Stopp Startanforderer Verursacher Motorlauf"
UDS_RDBI.dataIdentifiers[0x62cc] = "Start Stopp Startanforderer Systemstart Fehlerstatus"
UDS_RDBI.dataIdentifiers[0x62cd] = "Start Stopp Freigabe Zustandsberuhigung"
UDS_RDBI.dataIdentifiers[0x62ce] = "Drive Zustand Freigabe E Fahrt"
UDS_RDBI.dataIdentifiers[0x62cf] = "Start Stopp Startanforderung Zustand"
UDS_RDBI.dataIdentifiers[0x62d0] = "Engine In Use Histogram Ringpuffer OBL"
UDS_RDBI.dataIdentifiers[0x62d1] = "Drive Betriebsstrategie"
UDS_RDBI.dataIdentifiers[0x62df] = "Klimakompressor Drehzahl"
UDS_RDBI.dataIdentifiers[0x6300] = "Klimakompressor Strom"
UDS_RDBI.dataIdentifiers[0x6301] = "Klimakompressor Strom 48VEbene"
UDS_RDBI.dataIdentifiers[0x6302] = "Off Adaption Lernfilter Aktuell"
UDS_RDBI.dataIdentifiers[0x6303] = "Drive Lademoment minimal"
UDS_RDBI.dataIdentifiers[0x6304] = "DCDC HV Strom aktuell"
UDS_RDBI.dataIdentifiers[0x6305] = "Arbeitsdrehzahlregelung Aktivierungsbit plausibilisiert"
UDS_RDBI.dataIdentifiers[0x6306] = "Arbeitsdrehzahlregelung geforderte Motordrehzahl plausibilisert"
UDS_RDBI.dataIdentifiers[0x6307] = "Arbeitsdrehzahlregelung Max Moment Anforderung"
UDS_RDBI.dataIdentifiers[0x6308] = "Arbeitsdrehzahlregelung Momentenanforderung"
UDS_RDBI.dataIdentifiers[0x6309] = "Bremslichtsignal"
UDS_RDBI.dataIdentifiers[0x630a] = "Arbeitsdrehzalregelung Drehzahlanforderung plausibel"
UDS_RDBI.dataIdentifiers[0x630b] = "Arbeitsdrehzalregelung Plausibilisierung Fehler"
UDS_RDBI.dataIdentifiers[0x630c] = "Arbeitsdrehzahlregelung Min Moment Anforderung"
UDS_RDBI.dataIdentifiers[0x630d] = "Arbeitsdrehzahlregelung Durchgriff"
UDS_RDBI.dataIdentifiers[0x630e] = "Arbeitsdrehzahlregelung Momentenvorgabe I Anteil"
UDS_RDBI.dataIdentifiers[0x630f] = "Arbeitsdrehzahlregelung Momentenvorgabe P Anteil"
UDS_RDBI.dataIdentifiers[0x6310] = "Arbeitsdrehzahlregelung Momentenvorgabe D Anteil"
UDS_RDBI.dataIdentifiers[0x6311] = "Motormoment Max"
UDS_RDBI.dataIdentifiers[0x6312] = "Motormoment Min"
UDS_RDBI.dataIdentifiers[0x6313] = "Arbeitsdrehzahlregelung aktiv"
UDS_RDBI.dataIdentifiers[0x6314] = "Arbeitsdrehzahlregelung aktiv Sq"
UDS_RDBI.dataIdentifiers[0x6315] = "Arbeitsdrehzahlregelung geforderte Motordrehzahl"
UDS_RDBI.dataIdentifiers[0x6316] = "Arbeitsdrehzahlregelung geforderte Motordrehzahl Sq"
UDS_RDBI.dataIdentifiers[0x6317] = "Arbeitsdrehzahlregelung Info Plaus Fehler"
UDS_RDBI.dataIdentifiers[0x6330] = "Head Unit Variante Ruecksetzen erfolgreich"
UDS_RDBI.dataIdentifiers[0x6331] = "Luftmassenaenderung Pro Arbeitsspiel"
UDS_RDBI.dataIdentifiers[0x6332] = "Momentenanforderung Durch Reduzierstufe Ist"
UDS_RDBI.dataIdentifiers[0x6333] = "Momentenanforderung Durch Reduzierstufe Soll"
UDS_RDBI.dataIdentifiers[0x6334] = "Abgastemperatur Im Hauptkat Modelliert"
UDS_RDBI.dataIdentifiers[0x6335] = "Kat (DE"
UDS_RDBI.dataIdentifiers[0x6336] = "Phasengebernotlauf Phasensuche aktiv"
UDS_RDBI.dataIdentifiers[0x6337] = "Gangvorgabe"
UDS_RDBI.dataIdentifiers[0x6338] = "Ganganzeige aktueller Gang"
UDS_RDBI.dataIdentifiers[0x6339] = "Ganganzeige Zielgang"
UDS_RDBI.dataIdentifiers[0x633a] = "Abgastemperatur Nach Hauptkat Modelliert"
UDS_RDBI.dataIdentifiers[0x633b] = "Nach Kat (DE"
UDS_RDBI.dataIdentifiers[0x633c] = "Abgastemperatur Im Frontkat Modelliert"
UDS_RDBI.dataIdentifiers[0x633e] = "Abgastemperatur Im Kruemmer Modelliert"
UDS_RDBI.dataIdentifiers[0x6340] = "Ganganzeige aktuell eingelegter Gang"
UDS_RDBI.dataIdentifiers[0x6341] = "Ganganzeige aktuell eingelegter Gang SignalQualifier"
UDS_RDBI.dataIdentifiers[0x6342] = "Programmierbares Sondermodul Fehlerergebnis Start Stop"
UDS_RDBI.dataIdentifiers[0x6343] = "Programmierbares Sondermodul Motor Fern Stop aktiv"
UDS_RDBI.dataIdentifiers[0x6344] = "Programmierbares Sondermodul Motor Fern Start aktiv"
UDS_RDBI.dataIdentifiers[0x6345] = "Fahrzeuggeschwindigkeit Fehlerstatus"
UDS_RDBI.dataIdentifiers[0x6346] = "Fahrzeuggeschwindigkeit"
UDS_RDBI.dataIdentifiers[0x6347] = "Ueberwachung Freigabe Schluesselstart"
UDS_RDBI.dataIdentifiers[0x6350] = "Powernet Data Hochvolt "
UDS_RDBI.dataIdentifiers[0x6351] = "Fahrzeuggeschwindigkeit ungefiltert"
UDS_RDBI.dataIdentifiers[0x6355] = "Kundenereignis erforderlich"
UDS_RDBI.dataIdentifiers[0x6356] = "Schuetzschaltung Verhinderer Cat1 Fehler"
UDS_RDBI.dataIdentifiers[0x6357] = "Schuetzschaltung Verhinderer Cat1 SNA"
UDS_RDBI.dataIdentifiers[0x6358] = "Schuetzschaltung Verhinderer Cat2 Fehler"
UDS_RDBI.dataIdentifiers[0x6359] = "Schuetzschaltung Verhinderer Cat2 SNA"
UDS_RDBI.dataIdentifiers[0x6360] = "Messe Modus"
UDS_RDBI.dataIdentifiers[0x6361] = "Automatikgetrtiebe Schaltmodus PT4"
UDS_RDBI.dataIdentifiers[0x6362] = "Automatikgetrtiebe man Modus permanent PT3"
UDS_RDBI.dataIdentifiers[0x6364] = "Standy Mode aktiv"
UDS_RDBI.dataIdentifiers[0x6370] = "Laufzeit gesamt"
UDS_RDBI.dataIdentifiers[0x6371] = "Laufzeit gesamt"
UDS_RDBI.dataIdentifiers[0x6372] = "Fahrzeuggeschwindigkeit CAN"
UDS_RDBI.dataIdentifiers[0x6373] = "ESP Drehmomentanforderung Sperre"
UDS_RDBI.dataIdentifiers[0x6374] = "ART Momentenschnittstelle Sperre"
UDS_RDBI.dataIdentifiers[0x6375] = "Drehmomentanforderung Sperre irreversibel"
UDS_RDBI.dataIdentifiers[0x6376] = "Erststartmodus"
UDS_RDBI.dataIdentifiers[0x6377] = "Zuendung"
UDS_RDBI.dataIdentifiers[0x6378] = "Tempomat Momentenanforderung"
UDS_RDBI.dataIdentifiers[0x6379] = "Tempomat Momentenanforderung Sq"
UDS_RDBI.dataIdentifiers[0x637a] = "On Adaption Status DMDADAP"
UDS_RDBI.dataIdentifiers[0x637b] = "On Adaption Fertig Bereich unten"
UDS_RDBI.dataIdentifiers[0x637c] = "On Adaption Fertig Bereich Mitte"
UDS_RDBI.dataIdentifiers[0x637d] = "On Adaption Fertig Bereich oben"
UDS_RDBI.dataIdentifiers[0x637e] = "Off Adaption Zaehlindex"
UDS_RDBI.dataIdentifiers[0x6380] = "Tempomat Momentenanforderung Erh hung"
UDS_RDBI.dataIdentifiers[0x6381] = "ESP SBC Momentenanforderung"
UDS_RDBI.dataIdentifiers[0x6382] = "ESP SBC Momentenanforderung Sq"
UDS_RDBI.dataIdentifiers[0x6383] = "Getriebe Momentenanforderung"
UDS_RDBI.dataIdentifiers[0x6384] = "Getriebe Momentenanforderung Sq"  	 # or Zuendung Zaehler Gesamt
UDS_RDBI.dataIdentifiers[0x6385] = "Getriebe Momentenwunsch max"
UDS_RDBI.dataIdentifiers[0x6386] = "W hlhebelpositionssensor Fehler y Richtung"
UDS_RDBI.dataIdentifiers[0x6387] = "Waehlhebeldiagnose Min Motormoment"
UDS_RDBI.dataIdentifiers[0x6388] = "Abgasklappe Endstufe Sollwert PWM"
UDS_RDBI.dataIdentifiers[0x6389] = "Abgasklappe Zustandsautomat Vorgaengerbetriebsart"
UDS_RDBI.dataIdentifiers[0x6390] = "Abgasklappe Position Winkel"
UDS_RDBI.dataIdentifiers[0x6391] = "Abgasklappe Sollwert"
UDS_RDBI.dataIdentifiers[0x6392] = "Abgasklappe Lageregelung Sollwert intern"
UDS_RDBI.dataIdentifiers[0x6393] = "Abgasklappe Sollwert final"
UDS_RDBI.dataIdentifiers[0x6394] = "Abgasklappe Endstufe Spannung Sq"
UDS_RDBI.dataIdentifiers[0x6395] = "Abgasklappe Losreisszaehler aktiv"
UDS_RDBI.dataIdentifiers[0x6396] = "Abgasklappe Temperatur Sq"
UDS_RDBI.dataIdentifiers[0x6397] = "Abgasklappe Zaehler Fehlerheilung"
UDS_RDBI.dataIdentifiers[0x6398] = "Motorzustand aktuell"
UDS_RDBI.dataIdentifiers[0x6399] = "Drehzahl Antriebsstrang gefiltert"
UDS_RDBI.dataIdentifiers[0x6406] = "Anzahl restl. Fahrzyklen f. Stoppverbot im Fahrzeugwerk"
UDS_RDBI.dataIdentifiers[0x6407] = "Stoppverbot durch irreversible Fehlerreaktion mit Kraftstoffabschaltung"
UDS_RDBI.dataIdentifiers[0x6420] = "Gemischadaption FAPAFG laeuft"
UDS_RDBI.dataIdentifiers[0x6421] = "Gemischadaption FAPAFG fertig"
UDS_RDBI.dataIdentifiers[0x6422] = "Gemischadaption FAPAFG Betriebspunktanzeige"
UDS_RDBI.dataIdentifiers[0x6423] = "Gemischadaption FAPAFG Reset Gradientenstabilitaet"
UDS_RDBI.dataIdentifiers[0x6424] = "Gemischadaption FAPAFG Reset Offsetstabilitaet"
UDS_RDBI.dataIdentifiers[0x6425] = "Gemischadaption FAPAFG Momenten Reserve"
UDS_RDBI.dataIdentifiers[0x6426] = "Gemischadaption FAPAFG DTC durch FAPAFG oder Basisfunktion"
UDS_RDBI.dataIdentifiers[0x6427] = "Gemischadaption FAPAFG Solldrehzahl"
UDS_RDBI.dataIdentifiers[0x6428] = "Gemischadaption FAPAFG Offset Massenstrom adaptiert"
UDS_RDBI.dataIdentifiers[0x6429] = "Gemischadaption FAPAFG Offset Saugrohrdruck adaptiert"
UDS_RDBI.dataIdentifiers[0x642a] = "Gemischadaption FAPAFG Lastanforderung"
UDS_RDBI.dataIdentifiers[0x642b] = "Gemischadaption FAPAFG Abbruchgrund Ueberwachung"
UDS_RDBI.dataIdentifiers[0x642c] = "Gemischadaption FAPAFG Ueberwachung freigeschaltet"
UDS_RDBI.dataIdentifiers[0x6430] = "Saugrohrdruck gefiltert"
UDS_RDBI.dataIdentifiers[0x6431] = "Motordrehmoment koordiniert fuer Fuellung"
UDS_RDBI.dataIdentifiers[0x6432] = "Saugrohrdruck gefiltert plausibilisiert"
UDS_RDBI.dataIdentifiers[0x6433] = "Motordrehmoment Referenzmoment"
UDS_RDBI.dataIdentifiers[0x6434] = "Motordrehmoment Verlust gefiltert"
UDS_RDBI.dataIdentifiers[0x6435] = "Off Adaption Fertig Bereich1 EOL"
UDS_RDBI.dataIdentifiers[0x6436] = "Off Adaption Lernfilter Aktuell KatheizSegment"
UDS_RDBI.dataIdentifiers[0x6437] = "Off Adaption Lernfilter Resetzaehler"
UDS_RDBI.dataIdentifiers[0x6438] = "Off Adaption Lernfilter Resetzaehler KatheizSegment"
UDS_RDBI.dataIdentifiers[0x6439] = "Off Adaption Ergebniswert DMDFOF3 KatheizSegment"
UDS_RDBI.dataIdentifiers[0x643a] = "Off Adaption Filterwert Segmentabw KatheizSegment"
UDS_RDBI.dataIdentifiers[0x643b] = "Off Adaption korrigierte Segmentdauer"
UDS_RDBI.dataIdentifiers[0x6442] = "Ladedruck Regelabweichung"
UDS_RDBI.dataIdentifiers[0x6443] = "Ladedruck Regelabweichung gemittelt"
UDS_RDBI.dataIdentifiers[0x6444] = "Ladedruckregelung I Anteil"
UDS_RDBI.dataIdentifiers[0x6445] = "Ladedruckregelung Sollwert"
UDS_RDBI.dataIdentifiers[0x6450] = "Start Stop Analysewerte Fehlercode1"
UDS_RDBI.dataIdentifiers[0x6451] = "Start Stop Analysewerte Fehlercode2"
UDS_RDBI.dataIdentifiers[0x6452] = "Start Stop Analysewerte Fehlercode3"
UDS_RDBI.dataIdentifiers[0x6453] = "Start Stop Analysewerte Fehlercode4"
UDS_RDBI.dataIdentifiers[0x6454] = "Start Stop Analysewerte Fehlercode5"
UDS_RDBI.dataIdentifiers[0x6455] = "Ueberwachung Status Diagnose1"
UDS_RDBI.dataIdentifiers[0x6456] = "Ueberwachung Status Diagnose2"
UDS_RDBI.dataIdentifiers[0x6457] = "Bremsmoment Fahrer"
UDS_RDBI.dataIdentifiers[0x6458] = "Motorkuehlkreislauf Temperatur"
UDS_RDBI.dataIdentifiers[0x6459] = "Umgebungsvariable1"
UDS_RDBI.dataIdentifiers[0x6460] = "Umgebungsvariable2"
UDS_RDBI.dataIdentifiers[0x6461] = "Umgebungsvariable3"
UDS_RDBI.dataIdentifiers[0x6470] = "Expansionsventil Fehlerstatus"
UDS_RDBI.dataIdentifiers[0x6471] = "Drehschieberventil Fail Safe Ena Flag"
UDS_RDBI.dataIdentifiers[0x6472] = "Drehschieberventil Hybrid Codier Byte Fehler"
UDS_RDBI.dataIdentifiers[0x6473] = "Drehschieberventil Hybrid Codier Byte Fehler"
UDS_RDBI.dataIdentifiers[0x6474] = "Drehschieberventil BMS Fail Safe Ena Flag"
UDS_RDBI.dataIdentifiers[0x6475] = "Kuehlmittelpumpe Ladeluft Bypass Drehzahl"
UDS_RDBI.dataIdentifiers[0x6476] = "Kuehlmittelpumpe Ladeluft Bypass Drehzahl Sq"
UDS_RDBI.dataIdentifiers[0x6477] = "Kuehlmittelpumpe Ladeluft Bypass Fehler"
UDS_RDBI.dataIdentifiers[0x6478] = "Kuehlmittelpumpe Ladeluft Sollwert Sq"
UDS_RDBI.dataIdentifiers[0x6479] = "Kuehlmittelpumpe NT1 Fehlerstatus"
UDS_RDBI.dataIdentifiers[0x6480] = "Kuehlmittelpumpe LVPTC Fehler"
UDS_RDBI.dataIdentifiers[0x6481] = "Kuehlmittelpumpe BMS Drehzahl"
UDS_RDBI.dataIdentifiers[0x6482] = "Kuehlmittelpumpe BMS Sollwert Sq"
UDS_RDBI.dataIdentifiers[0x6483] = "Kuehlmittelpumpe BMS Bypass Fehler"
UDS_RDBI.dataIdentifiers[0x6484] = "Kuehlerjalousie LIN Istposition"
UDS_RDBI.dataIdentifiers[0x6485] = "Kuehlerjalousie LIN Status Init"
UDS_RDBI.dataIdentifiers[0x6486] = "Kuehlerjalousie LIN Fehlerheilung max"
UDS_RDBI.dataIdentifiers[0x6487] = "Kuehlerjalousie LIN Umgebungsdaten"
UDS_RDBI.dataIdentifiers[0x6490] = "Luefteranforderung Ladeluftkuehlung"
UDS_RDBI.dataIdentifiers[0x6491] = "Luefteraktivierung Anforderung Sq"
UDS_RDBI.dataIdentifiers[0x6492] = "Luefter LIN Umgebungsdaten"
UDS_RDBI.dataIdentifiers[0x649c] = "Gemischadaption Prioritaet Count Down Zeitzaehler"
UDS_RDBI.dataIdentifiers[0x64a0] = "Aussetzer Laufunruhe Testgroesse zu gross akt Betriebsbereich"
UDS_RDBI.dataIdentifiers[0x64a1] = "Aussetzer Laufunruhe zu gross akt Betriebsbereich"
UDS_RDBI.dataIdentifiers[0x64a2] = "Aussetzer erkannt"
UDS_RDBI.dataIdentifiers[0x6500] = "Ueberwachung Reset Status 0"
UDS_RDBI.dataIdentifiers[0x6501] = "Innenwiderstand HV-Batterie beim Laden"
UDS_RDBI.dataIdentifiers[0x6502] = "Innenwiderstand HV-Batterie beim Entladen"
UDS_RDBI.dataIdentifiers[0x6503] = "Batteriestrom der HV-Batterie"
UDS_RDBI.dataIdentifiers[0x6504] = "Stromintegral zur Bestimmung der Kapazitaet der HV-Batterie"  	 # or Ueberwachung Reset Status 4
UDS_RDBI.dataIdentifiers[0x6505] = "Ueberwachung Reset Status 5"  	 # or Ladezustand (SOC) der HV-Batterie
UDS_RDBI.dataIdentifiers[0x6506] = "Ueberwachung Reset Status 6"  	 # or Ladezustand (SOC) der HV-Batterie nach Spannungs-tabelle
UDS_RDBI.dataIdentifiers[0x6507] = "Ueberwachung Reset Status 7"
UDS_RDBI.dataIdentifiers[0x6508] = "Ueberwachung Software Reset Status 0"
UDS_RDBI.dataIdentifiers[0x6509] = "Ueberwachung Software Reset Status"
UDS_RDBI.dataIdentifiers[0x6510] = "OCV-Kennlinie der HV-Batterie"
UDS_RDBI.dataIdentifiers[0x6511] = "Ueberwachung Software Reset Status"
UDS_RDBI.dataIdentifiers[0x6512] = "Ueberwachung Software Reset Status 4"
UDS_RDBI.dataIdentifiers[0x6513] = "Ueberwachung Software Reset Status 5"
UDS_RDBI.dataIdentifiers[0x6514] = "Ueberwachung Software Reset Status 6"
UDS_RDBI.dataIdentifiers[0x6515] = "Ueberwachung Software Reset Status 7"
UDS_RDBI.dataIdentifiers[0x6527] = "Ueberwachung Ebene2 Limit Max Moment"
UDS_RDBI.dataIdentifiers[0x6528] = "Ueberwachung Ebene2 Limit Min Moment"
UDS_RDBI.dataIdentifiers[0x6529] = "Ueberwachung Moment koord max Wert"
UDS_RDBI.dataIdentifiers[0x6530] = "Momentenwunsch Fahrer effektiv"
UDS_RDBI.dataIdentifiers[0x6531] = "Ueberwachung ESP koord Sollmoment"
UDS_RDBI.dataIdentifiers[0x6532] = "Ueberwachung ESP koord Sollmoment"
UDS_RDBI.dataIdentifiers[0x6533] = "Ueberwachung ESP lim koord Sollmoment"
UDS_RDBI.dataIdentifiers[0x6534] = "Ueberwachung PT Istmoment Ebene"
UDS_RDBI.dataIdentifiers[0x6535] = "Ueberwachung zul Sollmoment Ebene"
UDS_RDBI.dataIdentifiers[0x6536] = "Ueberwachung Verbrennungsmotor Sollmoment Ebene"
UDS_RDBI.dataIdentifiers[0x6537] = "Ueberwachung red Sollmoment Ebene"
UDS_RDBI.dataIdentifiers[0x6538] = "Ueberwachung PT Sollmoment Ebene"
UDS_RDBI.dataIdentifiers[0x6539] = "Ueberwachung PT lim Sollmoment Ebene"
UDS_RDBI.dataIdentifiers[0x6540] = "Klopferkennung Referenzpegel HWZyl1"  	 # or Ueberwachung Istgang plaus Ebene
UDS_RDBI.dataIdentifiers[0x6541] = "Ueberwachung Gesamtbremsmoment plaus Ebene"  	 # or Klopferkennung Referenzpegel HWZyl2
UDS_RDBI.dataIdentifiers[0x6542] = "Ueberwachung E Maschine Istmoment plaus Ebene"  	 # or Klopferkennung Referenzpegel HWZyl3
UDS_RDBI.dataIdentifiers[0x6543] = "Ueberwachung Verbrennungsmotor Drehzahl Ebene"
UDS_RDBI.dataIdentifiers[0x6544] = "Verbrennungsmotor Start abgeschlossen"
UDS_RDBI.dataIdentifiers[0x6545] = "Enermanag Losfahrschutz aktiv"
UDS_RDBI.dataIdentifiers[0x6546] = "Vorklimatisierung Konditionierung aktiv"
UDS_RDBI.dataIdentifiers[0x6572] = "Ueberwachung Hybrid Status Diagnose Ebene2"
UDS_RDBI.dataIdentifiers[0x6580] = "Lambdaabweichung HWZyl1"
UDS_RDBI.dataIdentifiers[0x6581] = "Lambdaabweichung HWZyl2"
UDS_RDBI.dataIdentifiers[0x6582] = "Lambdaabweichung HWZyl3"
UDS_RDBI.dataIdentifiers[0x65a0] = "Aussetzerzaehler Homogen HWZyl1"
UDS_RDBI.dataIdentifiers[0x65a1] = "Aussetzerzaehler Homogen HWZyl2"
UDS_RDBI.dataIdentifiers[0x65a2] = "Aussetzerzaehler Homogen HWZyl3"
UDS_RDBI.dataIdentifiers[0x65c1] = "Schubabschalte Bereitschaft Bauteileschutz"
UDS_RDBI.dataIdentifiers[0x65c2] = "Schubabschalte Bereitschaft TEV Schliessen"
UDS_RDBI.dataIdentifiers[0x65c4] = "Schubabschalte Bereitschaft Freigabe"
UDS_RDBI.dataIdentifiers[0x65c5] = "Schubabschalte Bereitschaft Abgastemperaturmodell"
UDS_RDBI.dataIdentifiers[0x65c6] = "Abgasstrang Bauteileschutz aktiv"
UDS_RDBI.dataIdentifiers[0x65e0] = "FBS Renault Diagnosedaten verfuegbar"
UDS_RDBI.dataIdentifiers[0x65e1] = "FBS Renault Diagnosedaten Teil1"
UDS_RDBI.dataIdentifiers[0x65e2] = "FBS Renault Diagnosedaten Teil2"
UDS_RDBI.dataIdentifiers[0x65e3] = "FBS Renault Diagnosedaten Teil3"
UDS_RDBI.dataIdentifiers[0x65e4] = "FBS Renault Startfreigabe Steuergeraet"
UDS_RDBI.dataIdentifiers[0x65e5] = "FBS Renault Startfreigabe EZS gesichert"
UDS_RDBI.dataIdentifiers[0x65e6] = "FBS Renault Startfreigabe EZS Autorisierung"
UDS_RDBI.dataIdentifiers[0x65e7] = "FBS Renault Startfreigabe EZS Kommunikation"
UDS_RDBI.dataIdentifiers[0x65e8] = "FBS Renault Startfreigabe"
UDS_RDBI.dataIdentifiers[0x6640] = "Tempomat"
UDS_RDBI.dataIdentifiers[0x6667] = "Motorzustand Nachstartanreicherung abgeschaltet"
UDS_RDBI.dataIdentifiers[0x6800] = "Egf flgDtm"  	 # or EGFC DTM EGFC DTM
UDS_RDBI.dataIdentifiers[0x6801] = "EgfPwrStg ctrSt"  	 # or EGFC Hw State EGFC Hw State
UDS_RDBI.dataIdentifiers[0x6802] = "EGFC Err Mode EGFC Err"  	 # or Egf sq
UDS_RDBI.dataIdentifiers[0x6803] = "SCRT Err Mode SCRT Err"
UDS_RDBI.dataIdentifiers[0x6804] = "EgfAgSnsr1Volt sq"  	 # or EGFP Raw Err Mode EGFP Raw Err
UDS_RDBI.dataIdentifiers[0x6805] = "LEGRT Raw Err Mode LEGRT Raw Err"
UDS_RDBI.dataIdentifiers[0x6806] = "TSPC Med Err Mode TSPC Med Err"
UDS_RDBI.dataIdentifiers[0x6807] = "LEGRFP Raw Err Mode LEGRFP Raw Err"  	 # or EgrfAgSnsr1Volt sq
UDS_RDBI.dataIdentifiers[0x6808] = "EGT Err Mode EGT Err"
UDS_RDBI.dataIdentifiers[0x6809] = "LEGRT Err Mode LEGRT Err"
UDS_RDBI.dataIdentifiers[0x680a] = "DPFLR PDiff Raw Err"  	 # or LEGR PDiff Raw Err Mode LEGR PDiff Raw Err
UDS_RDBI.dataIdentifiers[0x680b] = "AAP Err Mode AAP Err"
UDS_RDBI.dataIdentifiers[0x680c] = "EGP Err Mode EGP Err"
UDS_RDBI.dataIdentifiers[0x680d] = "ECT Err Mode ECT Err"
UDS_RDBI.dataIdentifiers[0x680e] = "DPFLR Pdiff Err"  	 # or LEGR Pdiff Err Mode LEGR PDiff Err
UDS_RDBI.dataIdentifiers[0x680f] = "EGFP Err Mode EGFP Err"  	 # or EgfPosn sq
UDS_RDBI.dataIdentifiers[0x6810] = "Eng Run Mode Eng Run"
UDS_RDBI.dataIdentifiers[0x6811] = "IgnSwRun Mode IgnSwRun"
UDS_RDBI.dataIdentifiers[0x6812] = "Exhaust gas flap EGFC BreakAway ActvCntr"  	 # or EGFC BreakAway ActvCntr EGFC BreakAway ActvCntr
UDS_RDBI.dataIdentifiers[0x6813] = "EgfPosnLrn flgAcv"  	 # or EGFC PosnLrn Actv Mode EGFC PosnLrn Actv
UDS_RDBI.dataIdentifiers[0x6814] = "EGFC PosnLrn EnvAbtd Mode EGFC PosnLrn EnvAbtd"  	 # or EgfPosnLrn flgAbtd
UDS_RDBI.dataIdentifiers[0x6815] = "EGFC PosnLrn Err Mode EGFC PosnLrn Err"  	 # or EgfPosnLrn flgFlt
UDS_RDBI.dataIdentifiers[0x6816] = "EGFC PosnLrn Rdy Mode EGFC PosnLrn Rdy"  	 # or EgfPosnLrn flgRdy
UDS_RDBI.dataIdentifiers[0x6820] = "EgfPwrStgVolt Volt"
UDS_RDBI.dataIdentifiers[0x6821] = "st EgrfDiagcTest"  	 # or Egrf flgDtm
UDS_RDBI.dataIdentifiers[0x6822] = "st EgrfPwrStg"  	 # or EgrfPwrStg ctrSt
UDS_RDBI.dataIdentifiers[0x6823] = "EgrfPosnCtl percSpDtm"  	 # or perc EgrfAgSpDiag
UDS_RDBI.dataIdentifiers[0x6824] = "err Egrf"  	 # or Egrf sq
UDS_RDBI.dataIdentifiers[0x6825] = "EgrfPwrStg percPwmSp"  	 # or perc EgrfPwmSp
UDS_RDBI.dataIdentifiers[0x6826] = "st Egrf"
UDS_RDBI.dataIdentifiers[0x682b] = "flg ErgfPosnLrnAbtd"  	 # or EgrfPosnLrn flgAbtd
UDS_RDBI.dataIdentifiers[0x682c] = "flg EgrfPosnLrnFlt"  	 # or EgrfPosnLrn flgFlt
UDS_RDBI.dataIdentifiers[0x682d] = "n Eng"
UDS_RDBI.dataIdentifiers[0x682e] = "In vehicle total distance Read In vehicle total distance"
UDS_RDBI.dataIdentifiers[0x6834] = "flg EgrfPosnLrnSucs"  	 # or EgrfPosnLrn flgSucs
UDS_RDBI.dataIdentifiers[0x6835] = "perc EgrfAgSp"  	 # or EgrfPosnCtl percSp
UDS_RDBI.dataIdentifiers[0x6836] = "EgfPwrStg flgSwOffReq"  	 # or Exhaust gas flap PwrOffReq
UDS_RDBI.dataIdentifiers[0x6837] = "Exhaust gas flap EngStrtDis"  	 # or EgfSm flgEngStrtDi
UDS_RDBI.dataIdentifiers[0x6838] = "Exhaust gas flap PosnLrn succ mode"  	 # or EgfPosnLrn flgSucs
UDS_RDBI.dataIdentifiers[0x6839] = "LEGRT Tdrift Freeze"
UDS_RDBI.dataIdentifiers[0x683a] = "LEGRT Tdrift Freeze"
UDS_RDBI.dataIdentifiers[0x683b] = "LEGRT Phys Max"
UDS_RDBI.dataIdentifiers[0x683c] = "LEGRT Start"
UDS_RDBI.dataIdentifiers[0x683f] = "EgfSm ctrSt"
UDS_RDBI.dataIdentifiers[0x6841] = "EgrfPwrStgVolt Volt"
UDS_RDBI.dataIdentifiers[0x6b00] = "Read MIB Entry"
UDS_RDBI.dataIdentifiers[0xaa01] = "Module Temp Sensor 5"
UDS_RDBI.dataIdentifiers[0xaa02] = "Module Temp Sensor 5 Voltage"
UDS_RDBI.dataIdentifiers[0xaa03] = "Inlet Coolant Temp Sensor"
UDS_RDBI.dataIdentifiers[0xaa04] = "Inlet Coolant Temp Sensor Voltage"
UDS_RDBI.dataIdentifiers[0xaa05] = "Pump"
UDS_RDBI.dataIdentifiers[0xaa21] = "Module 21 Voltage Sensor"
UDS_RDBI.dataIdentifiers[0xaa22] = "Module 22 Voltage Sensor"
UDS_RDBI.dataIdentifiers[0xaa23] = "Module 23 Voltage Sensor"
UDS_RDBI.dataIdentifiers[0xaa24] = "Module 24 Voltage Sensor"
UDS_RDBI.dataIdentifiers[0xaa25] = "Module 25 Voltage Sensor"
UDS_RDBI.dataIdentifiers[0xaa26] = "Module 26 Voltage Sensor"
UDS_RDBI.dataIdentifiers[0xaa27] = "Liquid Coolant outlet Temp Voltage"
UDS_RDBI.dataIdentifiers[0xaa28] = "Liquid Coolant outlet Temp"
UDS_RDBI.dataIdentifiers[0xaa29] = "Liquid Coolant Pump Command"
UDS_RDBI.dataIdentifiers[0xaa30] = "Liquid Coolant Pump Speed feedback"
UDS_RDBI.dataIdentifiers[0xaa31] = "Open Cable Detection status"
UDS_RDBI.dataIdentifiers[0xaa32] = "Status of Command of Pump Function"
UDS_RDBI.dataIdentifiers[0xaa33] = "Status of Command of FAN Function"
UDS_RDBI.dataIdentifiers[0xaa34] = "Status of Contactor Device Control Function"
UDS_RDBI.dataIdentifiers[0xaa35] = "battery Status of Isolation Fault Diagnostic Control "
UDS_RDBI.dataIdentifiers[0xaa36] = "Status of Contactor Weld Check"
UDS_RDBI.dataIdentifiers[0xaa37] = "Status of Active Discharge"
UDS_RDBI.dataIdentifiers[0xaa42] = "Control Module Voltage"
UDS_RDBI.dataIdentifiers[0xb000] = "Readiness Katalysator"
UDS_RDBI.dataIdentifiers[0xb001] = "iness Lufteinblasung"  	 # or Readiness Sekundaerluftsystem
UDS_RDBI.dataIdentifiers[0xb002] = "iness O2 Sonde"  	 # or Readiness O2-Sonde
UDS_RDBI.dataIdentifiers[0xb003] = "iness O2 Sondenheizung"  	 # or Readiness O2-Sondenheizung
UDS_RDBI.dataIdentifiers[0xb004] = "ora2 LR-Adaption Additiv"
UDS_RDBI.dataIdentifiers[0xb005] = "ora LR-Adaption Additiv"  	 # or Zyklusflag GA LR Adaption Additiv
UDS_RDBI.dataIdentifiers[0xb006] = "fra2 LR-Adaption Multiplikativ"
UDS_RDBI.dataIdentifiers[0xb007] = "fra LR-Adaption Multiplikativ"  	 # or Zyklusflag GA LR Adaption Multiplikativ
UDS_RDBI.dataIdentifiers[0xb008] = "dylsu LSU Dynamikdiagnose"  	 # or Zyklusflag LSU Dynamikdiagnose
UDS_RDBI.dataIdentifiers[0xb009] = "dylsu2 LSU Dynamikdiagnose"
UDS_RDBI.dataIdentifiers[0xb010] = "helsu LSU Fehlerpfad HELSU"
UDS_RDBI.dataIdentifiers[0xb011] = "EZS Typ Baureihe"  	 # or helsu2 LSU Fehlerpfad HELSU, EZS Typ
UDS_RDBI.dataIdentifiers[0xb012] = "Zyklusflag LS Heizung Hinter Hauptkat"  	 # or hsh LS Heizung hinter Kat (DE, HF Empfangsdaten
UDS_RDBI.dataIdentifiers[0xb013] = "hsh2 LS Heizung hinter Kat (DE"
UDS_RDBI.dataIdentifiers[0xb014] = "Zyklusflag LS Heizung Hinter Hauptkat Endstufe"  	 # or hshe LS Heizung hinter Kat (DE
UDS_RDBI.dataIdentifiers[0xb015] = "hshe2 LS Heizung hinter Kat (DE"
UDS_RDBI.dataIdentifiers[0xb016] = "Zyklusflag LS Heizung Vor Kat"  	 # or hsv LS Heizung vor Kat
UDS_RDBI.dataIdentifiers[0xb017] = "hsv2 LS Heizung vor Kat"
UDS_RDBI.dataIdentifiers[0xb018] = "Zyklusflag LS Heizung Vor Kat Endstufe"  	 # or hsve LS Heizung vor Kat Endstufe
UDS_RDBI.dataIdentifiers[0xb019] = "hsve2 LS Heizung vor Kat Endstufe"
UDS_RDBI.dataIdentifiers[0xb020] = "Tiefentladeschutz"  	 # or iclsu LSU Auswerte IC
UDS_RDBI.dataIdentifiers[0xb021] = "iclsu2 LSU Auswerte IC"
UDS_RDBI.dataIdentifiers[0xb022] = "lash LS Alterung hinter Kat (DE"  	 # or Zyklusflag LS Alterung Hinter Hauptkat
UDS_RDBI.dataIdentifiers[0xb023] = "lash2 LS Alterung hinter Kat (DE"
UDS_RDBI.dataIdentifiers[0xb024] = "lshv LS Vertauschung Hinter Kat (DE"
UDS_RDBI.dataIdentifiers[0xb025] = "lsvv LS Vertauschung Vor Kat"
UDS_RDBI.dataIdentifiers[0xb026] = "ulsu LS an Luft"
UDS_RDBI.dataIdentifiers[0xb027] = "ulsu2 LS an Luft"
UDS_RDBI.dataIdentifiers[0xb028] = "Zyklusflag LS Hinter Hauptkat"  	 # or lsh LS hinter Kat (DE
UDS_RDBI.dataIdentifiers[0xb029] = "lsh2 LS hinter Kat (DE"
UDS_RDBI.dataIdentifiers[0xb030] = "lsuia LS Leitung an Bond IA"
UDS_RDBI.dataIdentifiers[0xb031] = "lsuia2 LS Leitung an Bond IA"
UDS_RDBI.dataIdentifiers[0xb032] = "lsuip Leitungssunterbrechung an IP"
UDS_RDBI.dataIdentifiers[0xb033] = "lsuip2 Leitungssunterbrechung an IP"
UDS_RDBI.dataIdentifiers[0xb034] = "lsuks Kurzschluss Sondenleitung"
UDS_RDBI.dataIdentifiers[0xb035] = "lsuks2 Kurzschluss Sondenleitung"
UDS_RDBI.dataIdentifiers[0xb036] = "lsuun LS Leitung an Bond UN"
UDS_RDBI.dataIdentifiers[0xb037] = "lsuun2 LS Leitung an Bond UN"
UDS_RDBI.dataIdentifiers[0xb038] = "lsuvm LS Leitung an Bond VM"
UDS_RDBI.dataIdentifiers[0xb039] = "lsuvm2 LS Leitung an Bond VM"
UDS_RDBI.dataIdentifiers[0xb040] = "lsv LS vor Kat"
UDS_RDBI.dataIdentifiers[0xb041] = "lsv2 LS vor Kat"
UDS_RDBI.dataIdentifiers[0xb042] = "lsve Elektrischer Fehler Vor Kat"
UDS_RDBI.dataIdentifiers[0xb043] = "lsve2 Elektrischer Fehler Vor Kat"
UDS_RDBI.dataIdentifiers[0xb044] = "pllsu Plausibilitaet der LSU"  	 # or Zyklusflag Plausibilitaet der LSU
UDS_RDBI.dataIdentifiers[0xb045] = "pllsu2 Plausibilitaet der LSU"
UDS_RDBI.dataIdentifiers[0xb046] = "Zyklusflag NW Einlass Zuordnung NW ZU KW"  	 # or nwkwe Zuordnung Einlass NW zu KW
UDS_RDBI.dataIdentifiers[0xb047] = "nwkwe2 Zuordnung Einlass NW zu KW"
UDS_RDBI.dataIdentifiers[0xb048] = "nwkwa Zuordnung Auslass NW zu KW"
UDS_RDBI.dataIdentifiers[0xb049] = "nwkwa2 Zuordnung Auslass NW zu KW"
UDS_RDBI.dataIdentifiers[0xb050] = "Zyklusflag NW Einlass Verriegelungsposition Start"  	 # or nwvpe Verriegelungsposition Einlass waehrend Start
UDS_RDBI.dataIdentifiers[0xb051] = "nwvpe2 Verriegelungsposition Einlass waehrend Start"
UDS_RDBI.dataIdentifiers[0xb052] = "nwvpa Verriegelungsposition Auslass waehrend Start"
UDS_RDBI.dataIdentifiers[0xb053] = "nwvpa2 Verriegelungsposition Auslass waehrend Start"
UDS_RDBI.dataIdentifiers[0xb054] = "Zyklusflag Sekundaerluftsystem"  	 # or sls Sekundaerluftsystem
UDS_RDBI.dataIdentifiers[0xb055] = "sls2 Sekundaerluftsystem"
UDS_RDBI.dataIdentifiers[0xb056] = "Zyklusflag Sekundaerluftventil"  	 # or slv Sekundaerventil
UDS_RDBI.dataIdentifiers[0xb057] = "slv2 Sekundaerventil"
UDS_RDBI.dataIdentifiers[0xb058] = "Zyklusflag Sekundaerluftpumpe Endstufe"  	 # or slpe Sekundaerpumpe Endstufe
UDS_RDBI.dataIdentifiers[0xb059] = "slve Sekundaerventil Endstufe"  	 # or Zyklusflag Sekundaerluftventil Endstufe
UDS_RDBI.dataIdentifiers[0xb060] = "Zyklusflag Absperrventil Aktivkohlefilter"
UDS_RDBI.dataIdentifiers[0xb061] = "Zyklusflag Tankentlueftlungssystem Feinleck"
UDS_RDBI.dataIdentifiers[0xb063] = "Zyklusflag Tankentlueftlungssystem Kleinstleck"
UDS_RDBI.dataIdentifiers[0xb100] = "Readiness PID01"
UDS_RDBI.dataIdentifiers[0xb101] = "iness PID41"
UDS_RDBI.dataIdentifiers[0xb200] = "HFA Product Identification Function ID"
UDS_RDBI.dataIdentifiers[0xb500] = "Counter Motorstarts"
UDS_RDBI.dataIdentifiers[0xb501] = "Allgemeiner Nenner"
UDS_RDBI.dataIdentifiers[0xb502] = "Katalysator rechts"
UDS_RDBI.dataIdentifiers[0xb503] = "Katalysator rechts"
UDS_RDBI.dataIdentifiers[0xb504] = "Katalysator links"
UDS_RDBI.dataIdentifiers[0xb505] = "Katalysator links"
UDS_RDBI.dataIdentifiers[0xb506] = "EVAP"  	 # or Tankdichtigkeitsdiagnose 05mm
UDS_RDBI.dataIdentifiers[0xb507] = "EVAP"  	 # or Tankdichtigkeitsdiagnose 05mm
UDS_RDBI.dataIdentifiers[0xb508] = "Sekundaerluftsystem"
UDS_RDBI.dataIdentifiers[0xb509] = "Sekundaerluftsystem"
UDS_RDBI.dataIdentifiers[0xb510] = "Sonde vorKat Mode9 rechts"
UDS_RDBI.dataIdentifiers[0xb511] = "Sonde vorKat Mode9 rechts"
UDS_RDBI.dataIdentifiers[0xb512] = "Sonde vorKat Mode9 links"
UDS_RDBI.dataIdentifiers[0xb513] = "Sonde vorKat Mode9 links"
UDS_RDBI.dataIdentifiers[0xb514] = "AGR oder NoWe Verstellung Mode9"  	
UDS_RDBI.dataIdentifiers[0xb515] = "AGR oder NoWe Verstellung Mode9"  	
UDS_RDBI.dataIdentifiers[0xb51a] = "OBD RBM Werte als Hex-Dump"
UDS_RDBI.dataIdentifiers[0xb51b] = "Erweiterte RBM Werte als Hex-Dump"
UDS_RDBI.dataIdentifiers[0xb520] = "Tankdichtigkeitsdiagnose 1 mm"  	
UDS_RDBI.dataIdentifiers[0xb521] = "Tankdichtigkeitsdiagnose 1 mm"  	
UDS_RDBI.dataIdentifiers[0xb522] = "Tankdichtigkeitsdiagnose Grobleck"
UDS_RDBI.dataIdentifiers[0xb523] = "Tankdichtigkeitsdiagnose Grobleck"
UDS_RDBI.dataIdentifiers[0xb524] = "Tankentlueftungsprinzipdiagnose"
UDS_RDBI.dataIdentifiers[0xb525] = "Tankentlueftungsprinzipdiagnose"
UDS_RDBI.dataIdentifiers[0xb526] = "Sonde hinter Kat rechts"  	
UDS_RDBI.dataIdentifiers[0xb527] = "Sonde hinter Kat rechts"  	
UDS_RDBI.dataIdentifiers[0xb528] = "Sonde hinterKat links"  	
UDS_RDBI.dataIdentifiers[0xb529] = "Sonde hinterKat links"  	
UDS_RDBI.dataIdentifiers[0xb530] = "Sondenheizung vor Kat rechts"  	
UDS_RDBI.dataIdentifiers[0xb531] = "Sondenheizung vor Kat rechts"  	
UDS_RDBI.dataIdentifiers[0xb532] = "Sondenheizung vor Kat links"  	
UDS_RDBI.dataIdentifiers[0xb533] = "Sondenheizung vor Kat links"  	
UDS_RDBI.dataIdentifiers[0xb534] = "Sondenheizung hinterKat rechts"  	
UDS_RDBI.dataIdentifiers[0xb535] = "Sondenheizung hinterKat rechts"  	
UDS_RDBI.dataIdentifiers[0xb536] = "Sondenheizung hinter Kat links"  	
UDS_RDBI.dataIdentifiers[0xb537] = "Sondenheizung hinter Kat links"  	
UDS_RDBI.dataIdentifiers[0xb538] = "Kurbelgehaeuse Entlueftung"
UDS_RDBI.dataIdentifiers[0xb539] = "Kurbelgehaeuse Entlueftung"
UDS_RDBI.dataIdentifiers[0xb540] = "Motortemperatursensor haengt kalt"
UDS_RDBI.dataIdentifiers[0xb541] = "Motortemperatursensor haengt kalt"
UDS_RDBI.dataIdentifiers[0xb542] = "Motortemperatursensor haengt warm"
UDS_RDBI.dataIdentifiers[0xb543] = "Motortemperatursensor haengt warm"
UDS_RDBI.dataIdentifiers[0xb544] = "Temperatursensor PremAir"
UDS_RDBI.dataIdentifiers[0xb545] = "Temperatursensor PremAir"
UDS_RDBI.dataIdentifiers[0xb546] = "Ansauglufttemperatursensor"
UDS_RDBI.dataIdentifiers[0xb547] = "Ansauglufttemperatursensor"
UDS_RDBI.dataIdentifiers[0xb548] = "Umgebungslufttemperatursensor"
UDS_RDBI.dataIdentifiers[0xb549] = "Umgebungslufttemperatursensor"
UDS_RDBI.dataIdentifiers[0xb550] = "Umgebungsluftdrucksensor"
UDS_RDBI.dataIdentifiers[0xb551] = "Umgebungsluftdrucksensor"
UDS_RDBI.dataIdentifiers[0xb552] = "Saugrohrdrucksensor"
UDS_RDBI.dataIdentifiers[0xb553] = "Saugrohrdrucksensor"
UDS_RDBI.dataIdentifiers[0xb554] = "Ladedrucksensor"
UDS_RDBI.dataIdentifiers[0xb555] = "NennerLadedrucksensor"
UDS_RDBI.dataIdentifiers[0xb556] = "Heissfilmluftmassensensor"
UDS_RDBI.dataIdentifiers[0xb557] = "Heissfilmluftmassensensor"
UDS_RDBI.dataIdentifiers[0xb558] = "Tankdrucksensor"
UDS_RDBI.dataIdentifiers[0xb559] = "Tankdrucksensor"
UDS_RDBI.dataIdentifiers[0xb560] = "Aktivkohleabsperrventil"
UDS_RDBI.dataIdentifiers[0xb561] = "Aktivkohleabsperrventil"
UDS_RDBI.dataIdentifiers[0xb562] = "Drosselklappe Lage Pruefung"
UDS_RDBI.dataIdentifiers[0xb563] = "Drosselklappe Lage Pruefung"
UDS_RDBI.dataIdentifiers[0xb564] = "Drosselklappe Bereich Pruefung"
UDS_RDBI.dataIdentifiers[0xb565] = "Drosselklappe Bereich Pruefung"
UDS_RDBI.dataIdentifiers[0xb566] = "Versatz NoWe Auslass rechts"
UDS_RDBI.dataIdentifiers[0xb567] = "Versatz NoWe Auslass rechts"
UDS_RDBI.dataIdentifiers[0xb568] = "Versatz NoWe Auslass links"
UDS_RDBI.dataIdentifiers[0xb569] = "Versatz NoWe Auslass links"
UDS_RDBI.dataIdentifiers[0xb570] = "Versatz NoWe Einlass rechts"
UDS_RDBI.dataIdentifiers[0xb571] = "Versatz NoWe Einlass rechts"
UDS_RDBI.dataIdentifiers[0xb572] = "Versatz NoWe Einlass links"
UDS_RDBI.dataIdentifiers[0xb573] = "Versatz NoWe Einlass links"
UDS_RDBI.dataIdentifiers[0xb574] = "Fahrzeuggeschwindigkeit"
UDS_RDBI.dataIdentifiers[0xb575] = "Fahrzeuggeschwindigkeit"
UDS_RDBI.dataIdentifiers[0xb576] = "Leerlaufregelung"
UDS_RDBI.dataIdentifiers[0xb577] = "Leerlaufregelung"
UDS_RDBI.dataIdentifiers[0xb578] = "Sonde hinterKat Schwingungspruefung rechts"  	
UDS_RDBI.dataIdentifiers[0xb579] = "Sonde hinterKat Schwingungspruefung rechts"  	
UDS_RDBI.dataIdentifiers[0xb580] = "Sonde hinterKat Schwingungspruefung links"  	
UDS_RDBI.dataIdentifiers[0xb581] = "Sonde hinterKat Schwingungspruefung links"  	
UDS_RDBI.dataIdentifiers[0xc000] = "fuer Warmstartleitung"  	 # or Korrekturwert Anfettung Start
UDS_RDBI.dataIdentifiers[0xc001] = "Sensor High Range"  	 # or Reset Zaehler Warmstartleitung
UDS_RDBI.dataIdentifiers[0xc002] = "Sensor Medium Range"
UDS_RDBI.dataIdentifiers[0xc003] = "Sensor Low Range"
UDS_RDBI.dataIdentifiers[0xc004] = "Max Block Resistance"
UDS_RDBI.dataIdentifiers[0xc005] = "Contactor Closure Inhibit"
UDS_RDBI.dataIdentifiers[0xc006] = "Pack Voltage"
UDS_RDBI.dataIdentifiers[0xc007] = "Pack Voltage (Source)"
UDS_RDBI.dataIdentifiers[0xc008] = "BUS voltage"
UDS_RDBI.dataIdentifiers[0xc009] = "BUS voltage (Source)"
UDS_RDBI.dataIdentifiers[0xc00a] = "Abgleich Energmanag Trip Computer perHour"
UDS_RDBI.dataIdentifiers[0xc00b] = "Abgleich Energmanag Crash Reset"
UDS_RDBI.dataIdentifiers[0xc010] = "Precharge Fail Penalty Time"
UDS_RDBI.dataIdentifiers[0xc011] = "Korrekturwert Hybrid Ladezustand Modus Quick Charge"
UDS_RDBI.dataIdentifiers[0xc012] = "HV Contactor Command"
UDS_RDBI.dataIdentifiers[0xc013] = "Produktionsmodus Interlock Freigabe"  	 # or HV Isolation Fault Diagnostic Stat
UDS_RDBI.dataIdentifiers[0xc014] = "Present Reasons Contactors Opened "
UDS_RDBI.dataIdentifiers[0xc015] = "Contactor 12 volt feed"
UDS_RDBI.dataIdentifiers[0xc016] = "Pump 12 volt feed"
UDS_RDBI.dataIdentifiers[0xc017] = "Produktionsmodus E Maschine neutral Freigabe"  	 # or HV Isolation Fault Diagnostic Stat
UDS_RDBI.dataIdentifiers[0xc018] = "Service Disconnect"
UDS_RDBI.dataIdentifiers[0xc019] = "HVIL"
UDS_RDBI.dataIdentifiers[0xc020] = "connector inputs 12v"
UDS_RDBI.dataIdentifiers[0xc021] = "Kuehlaggregat Chillerventil CO2 Befuellmodus"
UDS_RDBI.dataIdentifiers[0xc022] = "Abgasklappe obere Regelbereichsgrenze"
UDS_RDBI.dataIdentifiers[0xc023] = "Abgasklappe untere Regelbereichsgrenze"
UDS_RDBI.dataIdentifiers[0xc100] = "Laufzeit mit Motorlauf"
UDS_RDBI.dataIdentifiers[0xc101] = "Fahrt"
UDS_RDBI.dataIdentifiers[0xc102] = "Leerlauf"
UDS_RDBI.dataIdentifiers[0xc103] = "Laufzeit ohne Motorlauf"
UDS_RDBI.dataIdentifiers[0xc104] = "Startvorgaenge"
UDS_RDBI.dataIdentifiers[0xc105] = "Qualitaetsfaktor"
UDS_RDBI.dataIdentifiers[0xc106] = "Oelreset Anzahl"
UDS_RDBI.dataIdentifiers[0xc107] = "Nachfuellungen Anzahl"
UDS_RDBI.dataIdentifiers[0xc108] = "Fahrzeuguebergabe durchgefuehrt"
UDS_RDBI.dataIdentifiers[0xc109] = "Fahrzeuguebergabe Offset Strecke"
UDS_RDBI.dataIdentifiers[0xc110] = "Tag letzter Motoraus"
UDS_RDBI.dataIdentifiers[0xc111] = "Tag letzter Motorlauf"
UDS_RDBI.dataIdentifiers[0xc112] = "Oelverduennung"
UDS_RDBI.dataIdentifiers[0xc120] = ""
UDS_RDBI.dataIdentifiers[0xc121] = "Restlaufstrecke Anzeige"
UDS_RDBI.dataIdentifiers[0xc122] = "Restlaufzeit"
UDS_RDBI.dataIdentifiers[0xc123] = "Laufzeit mit Motor"
UDS_RDBI.dataIdentifiers[0xc124] = "Fahrt"
UDS_RDBI.dataIdentifiers[0xc125] = "Leerlauf"
UDS_RDBI.dataIdentifiers[0xc126] = "Startvorgaenge"
UDS_RDBI.dataIdentifiers[0xc127] = "Qualitaetsfaktor"
UDS_RDBI.dataIdentifiers[0xc128] = "gesamt"
UDS_RDBI.dataIdentifiers[0xc129] = "korr"
UDS_RDBI.dataIdentifiers[0xc130] = "Kilometerklasse"
UDS_RDBI.dataIdentifiers[0xc131] = ""
UDS_RDBI.dataIdentifiers[0xc132] = "Service Datum"
UDS_RDBI.dataIdentifiers[0xc133] = "Oelverduennung"
UDS_RDBI.dataIdentifiers[0xc134] = "vor Wartung"
UDS_RDBI.dataIdentifiers[0xc135] = "Datenuebergabe"
UDS_RDBI.dataIdentifiers[0xc136] = "Datenuebergabe zuletzt bestaetigt"
UDS_RDBI.dataIdentifiers[0xc137] = "Datenuebergabe Backup zuletzt bestaetigt"
UDS_RDBI.dataIdentifiers[0xc140] = "Ladestrom Tarifumschaltung MobisFr Zeitvektor"
UDS_RDBI.dataIdentifiers[0xc141] = "Ladestrom Tarifumschaltung MobisFr Kostenvektor"
UDS_RDBI.dataIdentifiers[0xc142] = "Ladestrom Tarifumschaltung MobisFr Leistungsbegrenzungsvektor"
UDS_RDBI.dataIdentifiers[0xc143] = "Ladestrom Tarifumschaltung SamstagSonntag Zeitvektor"
UDS_RDBI.dataIdentifiers[0xc144] = "Ladestrom Tarifumschaltung SamstagSonntag Kostenvektor"
UDS_RDBI.dataIdentifiers[0xc145] = "Ladestrom Tarifumschaltung SamstagSonntag Leistungsbegrenzungsvektor"
UDS_RDBI.dataIdentifiers[0xc146] = "Ladestrom Tarifumschaltung Aktivierungsstatus"
UDS_RDBI.dataIdentifiers[0xc147] = "Ladestrom Tarifumschaltung OrtsbasierterStromtarif"
UDS_RDBI.dataIdentifiers[0xc148] = "Kraftstoffverbrauch Lebenszeit Gesamtkilometerstand Nackommastellen"
UDS_RDBI.dataIdentifiers[0xc149] = "Kraftstoffverbrauch Lebenszeit Gesamtkilometerstand"
UDS_RDBI.dataIdentifiers[0xc150] = "Kraftstoffvolumen Lebenszeit Nachkommastellen"
UDS_RDBI.dataIdentifiers[0xc151] = "Kraftstoffvolumen Lebenszeit"
UDS_RDBI.dataIdentifiers[0xc27a] = "Fahrzeuguebergabe durchgefuehrt ASSYST Fahrzeuguebergabe durchgefuehrt"
UDS_RDBI.dataIdentifiers[0xc406] = "Ladestrom Tarifumschaltung MobisFr Zeitvektor"
UDS_RDBI.dataIdentifiers[0xc407] = "Ladestrom Tarifumschaltung MobisFr Kostenvektor"
UDS_RDBI.dataIdentifiers[0xc408] = "Ladestrom Tarifumschaltung MobisFr Leistungsbegrenzungsvektor"
UDS_RDBI.dataIdentifiers[0xc409] = "Ladestrom Tarifumschaltung SamstagSonntag Zeitvektor"
UDS_RDBI.dataIdentifiers[0xc40a] = "Ladestrom Tarifumschaltung SamstagSonntag Kostenvektor"
UDS_RDBI.dataIdentifiers[0xc40b] = "Ladestrom Tarifumschaltung SamstagSonntag Leistungsbegrenzungsvektor"
UDS_RDBI.dataIdentifiers[0xc40c] = "Ladestrom Tarifumschaltung Aktivierungsstatus"
UDS_RDBI.dataIdentifiers[0xc800] = "EgfPosn agIdle"  	 # or TAC LrndIdlePosn
UDS_RDBI.dataIdentifiers[0xc801] = "TAC BreakAway Actv Cntr"  	 # or EgfBreakAwy ctrAcv
UDS_RDBI.dataIdentifiers[0xc802] = "TAC Clng DrvCycCntr"  	 # or EgfClng ctrDrvCyc
UDS_RDBI.dataIdentifiers[0xc803] = "throttle actuator control learned lower position"
UDS_RDBI.dataIdentifiers[0xc804] = "TAC LrndUpPosn"
UDS_RDBI.dataIdentifiers[0xc805] = "EgfPosnLrn ctrDrvCyc"  	 # or throttle actuator control position learning driving cycle counter
UDS_RDBI.dataIdentifiers[0xc806] = "EgrfPosn agIdle"  	 # or angle EGR flap idle
UDS_RDBI.dataIdentifiers[0xc807] = "EgrfPosnCtl agRngLo"  	 # or angle EGR flap lower block
UDS_RDBI.dataIdentifiers[0xc808] = "angle EGR flap upper block"  	 # or EgrfPosnCtl agRngHi
UDS_RDBI.dataIdentifiers[0xc809] = "ctr EgrFBreakAwyAcv"  	 # or ctr EgrFlapBreakAwyAcv
UDS_RDBI.dataIdentifiers[0xc80a] = "ctr EgrFPosnLrnDrvCyc"  	 # or ctr EgrFlapPosnLrnDrvCyc
UDS_RDBI.dataIdentifiers[0xc80b] = "ctr EgrFClngDrvCyc"  	 # or ctr EgrFlapClngDrvCyc
UDS_RDBI.dataIdentifiers[0xc80c] = "LEGR PDiff Adap Offs"
UDS_RDBI.dataIdentifiers[0xcf00] = "EOL Enable Disable sensors"
UDS_RDBI.dataIdentifiers[0xcf01] = "Internal Software Version Information"
UDS_RDBI.dataIdentifiers[0xcf02] = "EOL BLDC Driver Status"
UDS_RDBI.dataIdentifiers[0xcf03] = "Pressure sensor output Read Response Parameters Pressure sensor output"
UDS_RDBI.dataIdentifiers[0xcf04] = "EOL FLS and FPS status"
UDS_RDBI.dataIdentifiers[0xcf10] = "EOL Identification"
UDS_RDBI.dataIdentifiers[0xcf50] = "Write SBC Register"
UDS_RDBI.dataIdentifiers[0xd000] = "Anfettung Start Nachstart"
UDS_RDBI.dataIdentifiers[0xd001] = "Klemmenschaltung Read IO Control"  	 # or Klemmenschaltung, SH F LED1 1 Read IO Control
UDS_RDBI.dataIdentifiers[0xd002] = "SH F LED2 Read IO Control"  	 # or Zentralverriegelung Read IO Control
UDS_RDBI.dataIdentifiers[0xd003] = "DSM Notpfad"  	 # or Regelschwelle Lambda nach KAT (DE, SH F OUT Read IO Control, DSM Notpfad Read IO Control, Lambda Regelschwelle nach Kat
UDS_RDBI.dataIdentifiers[0xd004] = "Lastschlagdaempfung Korrektur"  	 # or Steering Wheel Angle
UDS_RDBI.dataIdentifiers[0xd005] = "Laufruhe Empfindlichkeit Korrektur"  	 # or Empfindlichkeit der Laufruhebewertung
UDS_RDBI.dataIdentifiers[0xd006] = "Batterietrennschalter Read IO Control"
UDS_RDBI.dataIdentifiers[0xd007] = "Ignition Switch"  	 # or Suchbeleuchtung Taster Read IO Control, Leerlaufsolldrehzahl Mit Fahrstufe
UDS_RDBI.dataIdentifiers[0xd008] = "Entfall Sicherungsstifte"  	 # or Leistungsgewicht Korrektur, Korrekturfaktor Leistungsgewicht, Entfall Sicherungsstifte Read IO Control
UDS_RDBI.dataIdentifiers[0xd009] = "MKV Korrektur"
UDS_RDBI.dataIdentifiers[0xd010] = "Fahrertuerkontakplausibilitaet"  	 # or ROZ Korrektur
UDS_RDBI.dataIdentifiers[0xd011] = "SH BF LED1 Read IO Control"
UDS_RDBI.dataIdentifiers[0xd012] = "SH BF LED2 Read IO Control"
UDS_RDBI.dataIdentifiers[0xd013] = "SH BF OUT Read IO Control"
UDS_RDBI.dataIdentifiers[0xd014] = "Haptisches Fahrpedalmodul"
UDS_RDBI.dataIdentifiers[0xd015] = "Kuehlmittelpumpe HVBatteriekuehlung"
UDS_RDBI.dataIdentifiers[0xd016] = "Kuehlmittel Drehschieberventil BMS"
UDS_RDBI.dataIdentifiers[0xd017] = "Hochvolt Auslenkung Ladezustand"
UDS_RDBI.dataIdentifiers[0xd018] = "Anforderung Stromloser Zustand"
UDS_RDBI.dataIdentifiers[0xd019] = "SAM Bordnetzumschaltung"
UDS_RDBI.dataIdentifiers[0xd020] = "SH DPLUS Read IO Control"
UDS_RDBI.dataIdentifiers[0xd021] = "Check Engine Lamp"  	 # or Check Engine, Systemwarnlampe
UDS_RDBI.dataIdentifiers[0xd022] = "Entladestrompuls El Kaeltemittelverdichter"  	 # or Drehschieber des Waermemanagements
UDS_RDBI.dataIdentifiers[0xd023] = "SOC Vorgabe"  	 # or Drosselklappenwinkel
UDS_RDBI.dataIdentifiers[0xd024] = "Einspritzventil HWZyl1"  	 # or Ausblendmuster Einspritzventile
UDS_RDBI.dataIdentifiers[0xd025] = "Kuehlaggregat Chillerventil CO2"  	 # or Gemischanpassung
UDS_RDBI.dataIdentifiers[0xd026] = "Abgasklappe Otto rechts Read IO Control"  	 # or Abgasklappe Otto rechts, Erregerstrombegrenzung
UDS_RDBI.dataIdentifiers[0xd027] = "Regelspannung"
UDS_RDBI.dataIdentifiers[0xd028] = "Abgasklappe Otto links"  	 # or Rampenzeit
UDS_RDBI.dataIdentifiers[0xd029] = "Drehzahlschwelle"
UDS_RDBI.dataIdentifiers[0xd030] = "Heizabsperrventil"
UDS_RDBI.dataIdentifiers[0xd031] = "Kuehlerjalousie Fahrsoftware"  	 # or Kuehlerjalousie Testervorgabe, Kuehlerjalousie LIN Read Kuehlerjalousie
UDS_RDBI.dataIdentifiers[0xd032] = "Kuehlmittelpumpe Getriebeoelkuehlung"  	 # or Lambdaregelung
UDS_RDBI.dataIdentifiers[0xd033] = "Kuehlmittelpumpe LIN Read Kuehlmittelpumpe"
UDS_RDBI.dataIdentifiers[0xd034] = "Heizkreislauf HV Batterie Absperrventil"
UDS_RDBI.dataIdentifiers[0xd035] = "Nachlaufverlaengerung FBS"
UDS_RDBI.dataIdentifiers[0xd036] = "Nockenwellensteller Auslass"
UDS_RDBI.dataIdentifiers[0xd037] = "Anforderung Schubbetrieb"
UDS_RDBI.dataIdentifiers[0xd038] = "Kuehlmittelpumpe Bypass"
UDS_RDBI.dataIdentifiers[0xd039] = "X1 HotLoop Pump"  	 # or Luefter LIN Read Luefter
UDS_RDBI.dataIdentifiers[0xd03a] = "Luefter PWM"
UDS_RDBI.dataIdentifiers[0xd040] = "X1 ColdLoop Pump"  	 # or Kuehlmittel Drehschieberventil LIN Read Kuehlmittel Drehschieberventil
UDS_RDBI.dataIdentifiers[0xd041] = "X1 HVLoop Pump"  	 # or Sondenheizung normierte Leistung Nach KAT
UDS_RDBI.dataIdentifiers[0xd042] = "X1 BatLoop Pump"  	 # or Kuehlmittel Drehschieberventil 2
UDS_RDBI.dataIdentifiers[0xd043] = "Fahrstufe Vorgabe"  	 # or X1 HotLoop Valve1, Sondenheizung Vor KAT
UDS_RDBI.dataIdentifiers[0xd044] = "X1 HotLoop Valve2"
UDS_RDBI.dataIdentifiers[0xd045] = "X1 HotLoop BatHeaterValve"  	 # or Saugrohrumschaltung
UDS_RDBI.dataIdentifiers[0xd046] = "X1 HotLoop BypassValve"
UDS_RDBI.dataIdentifiers[0xd047] = "X1 ColdLoop BypassValve"
UDS_RDBI.dataIdentifiers[0xd048] = "Tumbleklappe"  	 # or X1 BatLoop Valve
UDS_RDBI.dataIdentifiers[0xd049] = "X1 FrontFan"  	 # or Zuendwinkelverstellung
UDS_RDBI.dataIdentifiers[0xd050] = "X1 EngOilFan PWM"
UDS_RDBI.dataIdentifiers[0xd051] = "X1 EngBayFan PWM"  	 # or Einspritzzeit Rechts Array
UDS_RDBI.dataIdentifiers[0xd052] = "X1 HVSideFan PWM"
UDS_RDBI.dataIdentifiers[0xd055] = "NT Absperrventil"
UDS_RDBI.dataIdentifiers[0xd061] = "Anhebung der Leerlaufdrehzahl"
UDS_RDBI.dataIdentifiers[0xd062] = "Wastegate Read Wastegate"
UDS_RDBI.dataIdentifiers[0xd068] = "Schubumluftventil"
UDS_RDBI.dataIdentifiers[0xd06f] = "Ladeluftkuehlmittelpumpe kontinuierlich"
UDS_RDBI.dataIdentifiers[0xd073] = "Motoroelpumpe Ventil"  	 # or Ventil Motoroelpumpe
UDS_RDBI.dataIdentifiers[0xd082] = "Momentenvorgabe Verbr. motor Hybrid"
UDS_RDBI.dataIdentifiers[0xd084] = "DMTL Tanksystem - Pumpe"
UDS_RDBI.dataIdentifiers[0xd085] = "DMTL Tanksystem - Ventil"
UDS_RDBI.dataIdentifiers[0xd086] = "DMTL Tanksystem - Heizung"
UDS_RDBI.dataIdentifiers[0xd088] = "Energmanag Hochvolt Auslenkung Ladezustand"
UDS_RDBI.dataIdentifiers[0xd089] = "Entladestrompuls Elektromaschine"
UDS_RDBI.dataIdentifiers[0xd090] = "Entladestrompuls DCDC Umsetzer"
UDS_RDBI.dataIdentifiers[0xd092] = "Energmanag Anforderung Stromloser Zustand"  	 # or Anforderung an Energiemanagement - stromloser Zustand
UDS_RDBI.dataIdentifiers[0xd093] = "Regenerierventil LPV"
UDS_RDBI.dataIdentifiers[0xd100] = "DDPRelayControl"  	 # or Feste Widerstandsvorgabe Hebelgeber primaer sekundaer
UDS_RDBI.dataIdentifiers[0xd101] = "FixedVoltageMode"
UDS_RDBI.dataIdentifiers[0xd102] = "DDPStartFunction"  	 # or Klemme87 Read Klemme87
UDS_RDBI.dataIdentifiers[0xd103] = "Stop Start Relay"
UDS_RDBI.dataIdentifiers[0xd123] = "Bremskreis Unterdruckpumpe"
UDS_RDBI.dataIdentifiers[0xd124] = "Luefter Heck"
UDS_RDBI.dataIdentifiers[0xd125] = "Klimakompressor"
UDS_RDBI.dataIdentifiers[0xd126] = "Kuehlkreislauf Absperrventil"
UDS_RDBI.dataIdentifiers[0xd201] = "Kuehlmittelpumpe NT2 15W BMS"
UDS_RDBI.dataIdentifiers[0xd202] = "Kuehlaggregat Umschaltventil"
UDS_RDBI.dataIdentifiers[0xd204] = "Kuehlmittelpumpe Plugin Hybrid Read Kuehlmittelpumpe Plugin Hybrid"
UDS_RDBI.dataIdentifiers[0xd205] = "Kuehlaggregat Expansionsventil"
UDS_RDBI.dataIdentifiers[0xd206] = "Kuehlmittel Drehschieberventil BMS"
UDS_RDBI.dataIdentifiers[0xd208] = "Kuehlermaskenjalousie"
UDS_RDBI.dataIdentifiers[0xd209] = "Kuehlmittelpumpe AMG LIN PRES LIN CP CAC2TransActlSpd"
UDS_RDBI.dataIdentifiers[0xd20a] = "PTC Zuheizer Plugin Hybrid"
UDS_RDBI.dataIdentifiers[0xd211] = "verbaute Steuergeraete Ist Chassis1 Lesen"  	 # or verbaute Steuergeraete Ist Chassis1 CGW
UDS_RDBI.dataIdentifiers[0xd212] = "verbaute Steuergeraete Ist Chassis2 CGW"  	 # or verbaute Steuergeraete Ist Chassis2 Lesen
UDS_RDBI.dataIdentifiers[0xd213] = "verbaute Steuergeraete Ist Diagnostic Lesen"  	 # or verbaute Steuergeraete Ist Diagnostic CGW
UDS_RDBI.dataIdentifiers[0xd800] = "EGFP SetVal Diag EGFP SetVal Diag"  	 # or EgfPosn perc
UDS_RDBI.dataIdentifiers[0xd801] = "EgrfPosn perc"  	 # or perc EgrfAgTrnsp
UDS_RDBI.dataIdentifiers[0xd802] = "ICF SetVal"
UDS_RDBI.dataIdentifiers[0xd900] = "VTA HW Ausgaenge"
UDS_RDBI.dataIdentifiers[0xdb06] = "IOC Kraftstoffpumpe Control PWM Vorgabe ohne Schwellen"
UDS_RDBI.dataIdentifiers[0xdb10] = "IOC Kraftstoffpumpe Control Druckvorgabe ohne Schwellen"
UDS_RDBI.dataIdentifiers[0xdb14] = "IOC Kraftstoffpumpe Control Volumenvorgabe ohne Schwellen"
UDS_RDBI.dataIdentifiers[0xdb18] = "IOC Kraftstoffpumpe Control Drehzahlvorgabe ohne Schwellen"
UDS_RDBI.dataIdentifiers[0xdb22] = "IOC Kraftstoffpumpe Control Spannungsvorgabe ohne Schwellen"
UDS_RDBI.dataIdentifiers[0xdb26] = "IOC Kraftstoffdrucksensor Messoffset"
UDS_RDBI.dataIdentifiers[0xdb30] = "IOC Kraftstoffpumpe Control Phasenstrom Vorgabe ohne Schwellen"
UDS_RDBI.dataIdentifiers[0xdf00] = "EOL BLDC Driver Config"
UDS_RDBI.dataIdentifiers[0xdf06] = "EOL IOC Kraftstoffpumpe Control PWM Vorgabe ohne Schwellen"
UDS_RDBI.dataIdentifiers[0xdf18] = "EOL IOC Kraftstoffpumpe Control Drehzahlvorgabe ohne Schwellen"
UDS_RDBI.dataIdentifiers[0xe010] = "Engine In Use Histogram"
UDS_RDBI.dataIdentifiers[0xef00] = "EF01 EF20"  	 # or Software Module Information Applikation Autosar, Software Module Information CANrmation Applikation Autosar ADC AR MAJOR VERSION, ECU Extract Version, SW Module Identification Application AUTOSAR AUTOSAR Module ID, SW Module Identification Application AUTOSAR
UDS_RDBI.dataIdentifiers[0xef02] = "02 DTC that caused required freeze frame data storage"  	 # or Standard Reprogramming SW Package Information, Standard Software FBL Package Information
UDS_RDBI.dataIdentifiers[0xef03] = "SW Integration package ID Major Version"  	 # or Standard Application SW Package Information, Standard Software Package Information, SW Integration package ID Major Version SIP ID Build Version
UDS_RDBI.dataIdentifiers[0xef04] = "SSA Version Information"  	 # or 02 Calculated LOAD value
UDS_RDBI.dataIdentifiers[0xef05] = "02 Engine coolant temperature"
UDS_RDBI.dataIdentifiers[0xef06] = "Short Term Fuel Trim Bank"
UDS_RDBI.dataIdentifiers[0xef07] = "Long Term Fuel Trim Bank"
UDS_RDBI.dataIdentifiers[0xef0a] = "02 Fuel Pressure Gauge"
UDS_RDBI.dataIdentifiers[0xef0b] = "Intake Manifold Absolute Pressure OBD EF0B"
UDS_RDBI.dataIdentifiers[0xef0c] = "Stored engine speed"
UDS_RDBI.dataIdentifiers[0xef0d] = "02 Vehicle speed sensor"
UDS_RDBI.dataIdentifiers[0xef0e] = "02 Ignition timing advance for cylinder"
UDS_RDBI.dataIdentifiers[0xef0f] = "Stored intake air temperature"
UDS_RDBI.dataIdentifiers[0xef11] = "02 Absolute throttle position"
UDS_RDBI.dataIdentifiers[0xef1e] = "02 Auxiliary Input"
UDS_RDBI.dataIdentifiers[0xef1f] = "02 Time Since Engine Start"
UDS_RDBI.dataIdentifiers[0xef20] = "EF21 EF40"
UDS_RDBI.dataIdentifiers[0xef22] = "02 Fuel Pressure relative to manifold vacuum"
UDS_RDBI.dataIdentifiers[0xef23] = "02 Fuel rail pressure"
UDS_RDBI.dataIdentifiers[0xef2e] = "02 Commanded Evaporative Purge"
UDS_RDBI.dataIdentifiers[0xef2f] = "02 Fuel Level Input"
UDS_RDBI.dataIdentifiers[0xef31] = "02 Distance travelled since diagnostic trouble codes cleared"
UDS_RDBI.dataIdentifiers[0xef32] = "Stored raw tank differential pressure"
UDS_RDBI.dataIdentifiers[0xef33] = "02 Barometric Pressure"
UDS_RDBI.dataIdentifiers[0xef3c] = "02 Catalyst Temperature Bank 1 Sensor"
UDS_RDBI.dataIdentifiers[0xef40] = "EF41 EF60"
UDS_RDBI.dataIdentifiers[0xef42] = "02 Control module voltage"
UDS_RDBI.dataIdentifiers[0xef43] = "02 Absolute Load Value"
UDS_RDBI.dataIdentifiers[0xef44] = "02 Fuel Air Commanded Equivalence Ratio"
UDS_RDBI.dataIdentifiers[0xef45] = "02 Relative Throttle Position"
UDS_RDBI.dataIdentifiers[0xef46] = "02 Ambient air temperature same scaling as IAT 0F"
UDS_RDBI.dataIdentifiers[0xef47] = "02 Absolute Throttle Position B"
UDS_RDBI.dataIdentifiers[0xef48] = "02 Absolute Throttle Position C"
UDS_RDBI.dataIdentifiers[0xef49] = "02 Absolute Throttle Position D"
UDS_RDBI.dataIdentifiers[0xef4a] = "02 Absolute Throttle Position E"
UDS_RDBI.dataIdentifiers[0xef4c] = "02 Commanded Throttle Actuator Control"
UDS_RDBI.dataIdentifiers[0xef82] = "States of the monitoring ECU for CAN network diagnosis"
UDS_RDBI.dataIdentifiers[0xf010] = "Temperature Counter Erase"
UDS_RDBI.dataIdentifiers[0xf011] = "Appl SW Program Data Version"
UDS_RDBI.dataIdentifiers[0xf012] = "VehicleManufacturerECUSoftwareNumber Ref C"
UDS_RDBI.dataIdentifiers[0xf014] = "Network Configuration FlexRay Network"
UDS_RDBI.dataIdentifiers[0xf050] = "RB SW Version information"
UDS_RDBI.dataIdentifiers[0xf0e0] = "FD01 FEFF"
UDS_RDBI.dataIdentifiers[0xf0ff] = "RSA reset componant"
UDS_RDBI.dataIdentifiers[0xf100] = "ECU Identifikation: ECU Origin (DiagVersion)"  	 # or Entriegeln, ActiveDiagnosticInformation Active Diagnostic Session, Active Diagnostic Status of ECU, Aktive Diagnose Information Aktive SG Software, F100 Active Diagnostic Session
UDS_RDBI.dataIdentifiers[0xf103] = "Vedoc Relevant Information Read Hardware Part Number"  	
UDS_RDBI.dataIdentifiers[0xf104] = "Read Ecu Name"
UDS_RDBI.dataIdentifiers[0xf10a] = "ECU Origin ECU Origin"
UDS_RDBI.dataIdentifiers[0xf10b] = "ECU Identification"
UDS_RDBI.dataIdentifiers[0xf10d] = "UDS Diagnostic Protocol Version MBN 10747"  	 # or Version Diagnoseprotokoll DPRS Major Version, Version Diagnoseprotokoll Diagnostic Performance Requirements Standard, DDS Package Release
UDS_RDBI.dataIdentifiers[0xf10e] = "Prozessortyp Identifikation"  	 # or FlexRay Configuration Information, Prozessortyp
UDS_RDBI.dataIdentifiers[0xf10f] = "OSEK Module Information Communication Layer Patch Level"  	 # or OSEKModuleInformation Communication Layer Patch Level, OSEKModuleInformation, OSEK-Modulinformation, OSEK Modulinformation Betriebssystem Spezifikation
UDS_RDBI.dataIdentifiers[0xf111] = "ECU Identifikation: HW Partnumber"  	
UDS_RDBI.dataIdentifiers[0xf112] = "Chrysler Group Hardware"
UDS_RDBI.dataIdentifiers[0xf11d] = "HW SW Version Produktion BL SV SW Version Major"
UDS_RDBI.dataIdentifiers[0xf121] = "MercedesCarGroupSoftware"  	
UDS_RDBI.dataIdentifiers[0xf132] = "ECU Teilenummer"
UDS_RDBI.dataIdentifiers[0xf150] = "HardwareVersion HW"  	
UDS_RDBI.dataIdentifiers[0xf151] = "SoftwareVersion SW"  	
UDS_RDBI.dataIdentifiers[0xf152] = "Mechanik Version ME patch Level"
UDS_RDBI.dataIdentifiers[0xf153] = "Boot Software Version"  	
UDS_RDBI.dataIdentifiers[0xf154] = "HardwareSupplier Read"  	
UDS_RDBI.dataIdentifiers[0xf155] = "SoftwareSupplier Read"
UDS_RDBI.dataIdentifiers[0xf156] = "Layered Network Information Baud Rate"
UDS_RDBI.dataIdentifiers[0xf158] = "Vehicle Information Body Style"
UDS_RDBI.dataIdentifiers[0xf159] = "TCU Model Type HW Connection Capability"  	
UDS_RDBI.dataIdentifiers[0xf15a] = "Fingerprint History Code"  	
UDS_RDBI.dataIdentifiers[0xf15b] = "Read Fingerprint"  	
UDS_RDBI.dataIdentifiers[0xf160] = "Software Module Information Communication Matrix Last Channel LSB"  	
UDS_RDBI.dataIdentifiers[0xf161] = "Software Module Information PT CAN"  	
UDS_RDBI.dataIdentifiers[0xf162] = "Software Module Information PT Sensor CAN"  	
UDS_RDBI.dataIdentifiers[0xf163] = "Software Module Information Hybrid CAN"  	
UDS_RDBI.dataIdentifiers[0xf164] = "Software Module Information FlexRay"  	
UDS_RDBI.dataIdentifiers[0xf170] = "CAN Phys Layer Info Chassis CAN"  	
UDS_RDBI.dataIdentifiers[0xf171] = "CAN Phys Layer Info PT CAN"  	
UDS_RDBI.dataIdentifiers[0xf172] = "CAN Phys Layer Info PT Sensor CAN"  	
UDS_RDBI.dataIdentifiers[0xf173] = "CAN Phys Layer Info Hybrid CAN"  	
UDS_RDBI.dataIdentifiers[0xf174] = "CAN Phys Layer Info 4 Baud Rate 0 Last Channel BTR0 Channel 4"  	
UDS_RDBI.dataIdentifiers[0xf182] = "Calibration number"
UDS_RDBI.dataIdentifiers[0xf188] = "VehicleManufacturerECUSoftwareNumber Ref C"
UDS_RDBI.dataIdentifiers[0xf18c] = "ECU Serial Number"  	
UDS_RDBI.dataIdentifiers[0xf190] = "VIN Original"
UDS_RDBI.dataIdentifiers[0xf194] = "systemSupplierECUSoftwareNumber"
UDS_RDBI.dataIdentifiers[0xf195] = "systemSupplierECUSoftwareVersionNumber",
UDS_RDBI.dataIdentifiers[0xf196] = "ExhaustRegulationorTypeApprovalNumber"  	
UDS_RDBI.dataIdentifiers[0xf197] = "SystemNameorEngineType"  	 # or System Supplier SBOOT Software Version Number
UDS_RDBI.dataIdentifiers[0xf198] = "System Supplier CBOOT Software Version Number"
UDS_RDBI.dataIdentifiers[0xf199] = "System Supplier CAL DATA Software Version Number"
UDS_RDBI.dataIdentifiers[0xf1a0] = "VIN Aktuell VIN"
UDS_RDBI.dataIdentifiers[0xf1a6] = "FlexRay Node Information"
UDS_RDBI.dataIdentifiers[0xf1b0] = "Nummernblock Lieferant"
UDS_RDBI.dataIdentifiers[0xf1c0] = "F1C1 F1E0"
UDS_RDBI.dataIdentifiers[0xf1f0] = "BPCM Controller Hardware DCX"
UDS_RDBI.dataIdentifiers[0xf1f1] = "BPCM Controller Hardware Version DCX"
UDS_RDBI.dataIdentifiers[0xf1f5] = "System Identification - Barcode"
UDS_RDBI.dataIdentifiers[0xf1ff] = "Mercedes Serial Number"
UDS_RDBI.dataIdentifiers[0xf252] = "Temprature Counter Erase"
UDS_RDBI.dataIdentifiers[0xf300] = "Dynamically Define Identifier by Identifier F300"
UDS_RDBI.dataIdentifiers[0xf301] = "HwAcc SST O Read IO Control"
UDS_RDBI.dataIdentifiers[0xf303] = "HwAcc SST I"
UDS_RDBI.dataIdentifiers[0xf310] = "HwAcc DIAG O Read IO Control"
UDS_RDBI.dataIdentifiers[0xf311] = "HwAcc SYS O Read IO Control"
UDS_RDBI.dataIdentifiers[0xf312] = "HwAcc DIAG I"
UDS_RDBI.dataIdentifiers[0xf313] = "HwAcc SYS I"
UDS_RDBI.dataIdentifiers[0xf318] = "HwAcc HSD O Read IO Control"
UDS_RDBI.dataIdentifiers[0xf31a] = "HwAcc HSD I"
UDS_RDBI.dataIdentifiers[0xf320] = "HwAcc SBC I"
UDS_RDBI.dataIdentifiers[0xf321] = "HwAcc SBC O Read IO Control"
UDS_RDBI.dataIdentifiers[0xf3b0] = "Read SW Varianten Information Erwartete Variante"  	
UDS_RDBI.dataIdentifiers[0xf3b1] = "Read Version LF ASIC SD408 SW Version High Nibble im Flash"
UDS_RDBI.dataIdentifiers[0xf400] = "F401 F420"  	 # or Flash Verriegelung
UDS_RDBI.dataIdentifiers[0xf401] = "PID F401"
UDS_RDBI.dataIdentifiers[0xf403] = "system status"
UDS_RDBI.dataIdentifiers[0xf404] = "Calculated LOAD value"
UDS_RDBI.dataIdentifiers[0xf405] = "Engine coolant temperature"
UDS_RDBI.dataIdentifiers[0xf406] = "SHORT TERM FUEL TRIM"
UDS_RDBI.dataIdentifiers[0xf407] = "Long Term Fuel Trim"
UDS_RDBI.dataIdentifiers[0xf40a] = "Pressure Gauge"
UDS_RDBI.dataIdentifiers[0xf40b] = "Raw manifold pressure from sensor"
UDS_RDBI.dataIdentifiers[0xf40c] = "Engine RPM"
UDS_RDBI.dataIdentifiers[0xf40d] = "Vehicle speed sensor OBD F40D"
UDS_RDBI.dataIdentifiers[0xf40e] = "Ignition timing advance for cylinder 1 OBD F40E"
UDS_RDBI.dataIdentifiers[0xf40f] = "Raw manifold air temperature sensor"
UDS_RDBI.dataIdentifiers[0xf410] = "Air flow rate from mass air flow sensor OBD F410"
UDS_RDBI.dataIdentifiers[0xf411] = "Absolute throttle position"
UDS_RDBI.dataIdentifiers[0xf413] = "Location of oxygen sensors"
UDS_RDBI.dataIdentifiers[0xf414] = "Bank 1 Sensor"
UDS_RDBI.dataIdentifiers[0xf415] = "Oxygen downstream sensor output voltage"
UDS_RDBI.dataIdentifiers[0xf41c] = "OBD requirements to wich vehicle is designed OBD F41C"
UDS_RDBI.dataIdentifiers[0xf41e] = "Auxiliary Input"
UDS_RDBI.dataIdentifiers[0xf41f] = "Time Since Engine Start"
UDS_RDBI.dataIdentifiers[0xf420] = "F421 F440"
UDS_RDBI.dataIdentifiers[0xf421] = "Distance travelled while MIL is activated"
UDS_RDBI.dataIdentifiers[0xf422] = "Pressure relative to manifold vacuum"
UDS_RDBI.dataIdentifiers[0xf423] = "rail pressure"
UDS_RDBI.dataIdentifiers[0xf424] = "Oxygen sensor monitoring Sensor"
UDS_RDBI.dataIdentifiers[0xf425] = "Oxygen sensor monitoring Sensor"
UDS_RDBI.dataIdentifiers[0xf426] = "Oxygen sensor heater monitoring"
UDS_RDBI.dataIdentifiers[0xf42c] = "Commanded EGR"
UDS_RDBI.dataIdentifiers[0xf42d] = "EGR Error"
UDS_RDBI.dataIdentifiers[0xf42e] = "Commanded Evaporative Purge"
UDS_RDBI.dataIdentifiers[0xf42f] = "Level Input"
UDS_RDBI.dataIdentifiers[0xf430] = "Number of warm ups since diagnostic trouble codes cleared OBD F430"
UDS_RDBI.dataIdentifiers[0xf431] = "Distance travelled since diagnostic trouble codes cleared"
UDS_RDBI.dataIdentifiers[0xf432] = "Raw Tank differential pressure"
UDS_RDBI.dataIdentifiers[0xf433] = "Barometric Pressure"
UDS_RDBI.dataIdentifiers[0xf43c] = "Catalyst Temperature Bank 1 Sensor"
UDS_RDBI.dataIdentifiers[0xf43d] = "Catalyst Temperature Bank 2 Sensor"
UDS_RDBI.dataIdentifiers[0xf43e] = "Catalyst Temperature Bank 1 Sensor"
UDS_RDBI.dataIdentifiers[0xf43f] = "Catalyst Temperature Bank 2 Sensor"
UDS_RDBI.dataIdentifiers[0xf440] = "F441 F460"
UDS_RDBI.dataIdentifiers[0xf441] = "PID F441"
UDS_RDBI.dataIdentifiers[0xf442] = "Control module voltage"
UDS_RDBI.dataIdentifiers[0xf443] = "Absolute Load Value"
UDS_RDBI.dataIdentifiers[0xf444] = "Air Commanded Equivalence Ratio"
UDS_RDBI.dataIdentifiers[0xf445] = "Relative Throttle Position"
UDS_RDBI.dataIdentifiers[0xf446] = "Ambient air temperature"
UDS_RDBI.dataIdentifiers[0xf447] = "Absolute Throttle Position B"
UDS_RDBI.dataIdentifiers[0xf448] = "Absolute Throttle Position C"
UDS_RDBI.dataIdentifiers[0xf449] = "Accelerator Pedal Position D"
UDS_RDBI.dataIdentifiers[0xf44a] = "Accelerator Pedal Position E"
UDS_RDBI.dataIdentifiers[0xf44b] = "Accelerator Pedal Position F"
UDS_RDBI.dataIdentifiers[0xf44c] = "Commanded Throttle Actuator Control"
UDS_RDBI.dataIdentifiers[0xf44e] = "Engine run time since DTCs cleared"
UDS_RDBI.dataIdentifiers[0xf44f] = "Maximum value for Intake Manifold Absolute Pressure"
UDS_RDBI.dataIdentifiers[0xf453] = "Absolute Evap System Vapor Pressure"
UDS_RDBI.dataIdentifiers[0xf454] = "Evap System Vapor Pressure"
UDS_RDBI.dataIdentifiers[0xf45c] = "Engine Oil Temperature"
UDS_RDBI.dataIdentifiers[0xf45d] = "Injection Timing"
UDS_RDBI.dataIdentifiers[0xf45e] = "Engine Fuel Rate"
UDS_RDBI.dataIdentifiers[0xf460] = "F461 F480"
UDS_RDBI.dataIdentifiers[0xf461] = "Driver s Demand Engine Percent Torque"
UDS_RDBI.dataIdentifiers[0xf462] = "Actual Engine Percent Torque"
UDS_RDBI.dataIdentifiers[0xf463] = "Engine Reference Torque"
UDS_RDBI.dataIdentifiers[0xf464] = "Engine Percent Torque At Point"
UDS_RDBI.dataIdentifiers[0xf469] = "Commanded EGR and EGR Error"
UDS_RDBI.dataIdentifiers[0xf46a] = "Commanded Diesel Intake Air Flow Control and Relative Intake Air Flow Position"
UDS_RDBI.dataIdentifiers[0xf46b] = "Exhaust Gas Recirculation Temperature"
UDS_RDBI.dataIdentifiers[0xf46d] = "Pressure Control System"
UDS_RDBI.dataIdentifiers[0xf470] = "Boost Pressure Control"
UDS_RDBI.dataIdentifiers[0xf473] = "Exhaust Pressure"
UDS_RDBI.dataIdentifiers[0xf475] = "Turbocharger A Temperature"
UDS_RDBI.dataIdentifiers[0xf477] = "Charge Air Cooler Temperature CACT"
UDS_RDBI.dataIdentifiers[0xf47a] = "Diesel Particulate Filter DPF Bank"
UDS_RDBI.dataIdentifiers[0xf47c] = "Diesel Particulate Filter DPF Temperature"
UDS_RDBI.dataIdentifiers[0xf480] = "F481 F4A0"
UDS_RDBI.dataIdentifiers[0xf488] = "SCR Inducement System"
UDS_RDBI.dataIdentifiers[0xf48b] = "Diesel Aftertreatment"
UDS_RDBI.dataIdentifiers[0xf48c] = "Sensor Wide Range"
UDS_RDBI.dataIdentifiers[0xf490] = "WWH OBD Vehicle OBD System information"
UDS_RDBI.dataIdentifiers[0xf491] = "WWH OBD ECU OBD System Information"
UDS_RDBI.dataIdentifiers[0xf493] = "WWH OBD Vehicle counters supported"
UDS_RDBI.dataIdentifiers[0xf494] = "NOx control driver inducement system status"
UDS_RDBI.dataIdentifiers[0xf600] = "F600 F620"
UDS_RDBI.dataIdentifiers[0xf601] = "OBDMID Oxygen sensor diagnostic for service 06 OBD F601"
UDS_RDBI.dataIdentifiers[0xf602] = "06 Upstream Oxygen sensor diagnostic"
UDS_RDBI.dataIdentifiers[0xf620] = "F621 F640"
UDS_RDBI.dataIdentifiers[0xf621] = "06 Catalyst diagnostic"
UDS_RDBI.dataIdentifiers[0xf631] = "DC motor valve"
UDS_RDBI.dataIdentifiers[0xf635] = "06 VVT Diagnostic"
UDS_RDBI.dataIdentifiers[0xf639] = "OBDMID Evaporation monitoring fuel cap misssing"
UDS_RDBI.dataIdentifiers[0xf63a] = "OBDMID Evaporation monitoring large leak diagnostic"
UDS_RDBI.dataIdentifiers[0xf63b] = "OBDMID Evaporation monitoring 1mm leak diagnostic"
UDS_RDBI.dataIdentifiers[0xf640] = "F641 F660"
UDS_RDBI.dataIdentifiers[0xf641] = "Downstream oxygen sensor heater monitoring"
UDS_RDBI.dataIdentifiers[0xf642] = "Upstream oxygen sensor heater monitoring"
UDS_RDBI.dataIdentifiers[0xf660] = "F661 F680"
UDS_RDBI.dataIdentifiers[0xf680] = "F681 F6A0"
UDS_RDBI.dataIdentifiers[0xf681] = "system diagnostic"
UDS_RDBI.dataIdentifiers[0xf685] = "Turbocharger Monitor diagnostic"
UDS_RDBI.dataIdentifiers[0xf6a0] = "F6A1 F6C0"
UDS_RDBI.dataIdentifiers[0xf6a1] = "OBDMID Misfire diagnostic"
UDS_RDBI.dataIdentifiers[0xf6b2] = "Diesel Particulate Filter Diagnostic"
UDS_RDBI.dataIdentifiers[0xf6c0] = "F6C1 F6E0"
UDS_RDBI.dataIdentifiers[0xf6e0] = "F6E1 F6FF"
UDS_RDBI.dataIdentifiers[0xf6e3] = "EGR Low Pressure System Diagnostic"
UDS_RDBI.dataIdentifiers[0xf6e4] = "Turbocharger Monitor Bank1"
UDS_RDBI.dataIdentifiers[0xf6e5] = "Engine Cooling Temperature Monitoring"
UDS_RDBI.dataIdentifiers[0xf6e8] = "06 Evaporation diagnosis"
UDS_RDBI.dataIdentifiers[0xf800] = "F801 F820"
UDS_RDBI.dataIdentifiers[0xf802] = "OBDMID Vehicle identification number"
UDS_RDBI.dataIdentifiers[0xf804] = "OBD CALIDs"  	
UDS_RDBI.dataIdentifiers[0xf805] = "ZBS Number"
UDS_RDBI.dataIdentifiers[0xf806] = "Calibration verification numbers"  	
UDS_RDBI.dataIdentifiers[0xf808] = "In Use Monitor Performance Ratio"  	 # or HEX Gasoline, IUPR gasoline
UDS_RDBI.dataIdentifiers[0xf80a] = "09 systemNameorEngineType"
UDS_RDBI.dataIdentifiers[0xf80b] = "IUPR diesel"  	 # or HEX Diesel
UDS_RDBI.dataIdentifiers[0xf80f] = "09 exhaustRegulationorTypeApprovalNumber"
UDS_RDBI.dataIdentifiers[0xf810] = "09 PROTOCOL IDENTIFICATION"
UDS_RDBI.dataIdentifiers[0xf811] = "09 WWH OBD GTR NUMBER"
UDS_RDBI.dataIdentifiers[0xf813] = "Certification Test Group Engine Family Number CTGEFN"
UDS_RDBI.dataIdentifiers[0xfb04] = "CAL-ID"
UDS_RDBI.dataIdentifiers[0xfd00] = "Implicit Variant Coding Read Car Type STRUCTURE Car with Ethanolsensor"  	
UDS_RDBI.dataIdentifiers[0xfd01] = "UH Minimum Module Voltage"  	 # or Engine speed 1 Read Engine speed
UDS_RDBI.dataIdentifiers[0xfd02] = "PM"  	 # or UH Lifetime Minimum OCV
UDS_RDBI.dataIdentifiers[0xfd03] = "UH Coolant Inlet Temperature"  	 # or SBW Infos
UDS_RDBI.dataIdentifiers[0xfd04] = "Temperaturspeicher Leiterplatte loeschen"  	 # or Temperatur Leiterplatte, Total-Kodierung, injection cut off
UDS_RDBI.dataIdentifiers[0xfd05] = "UH Module Coolant Delta"  	 # or Terminal 15 status after debouncing
UDS_RDBI.dataIdentifiers[0xfd06] = "Widerstandswerte Hebelgeber Hebelgeber Links"  	 # or UH Total Time Contactors Closed, Widerstandswerte Hebelgeber, system ECU sub state
UDS_RDBI.dataIdentifiers[0xfd07] = "State of synchronisation"  	 # or RBM Festsitzerkennung Hebelgeber Denominator, UH Total Time of Operation, Festsitzerkennung Hebelgeber
UDS_RDBI.dataIdentifiers[0xfd08] = "Diagnosis power stage entry conditions fulfilled"  	 # or UH Isolation Fault Diagnostic
UDS_RDBI.dataIdentifiers[0xfd09] = "cut off"
UDS_RDBI.dataIdentifiers[0xfd0a] = "Condition end of start"
UDS_RDBI.dataIdentifiers[0xfd0b] = "Opening angle set point TDC angle reference"
UDS_RDBI.dataIdentifiers[0xfd0c] = "Injection abortion counter"
UDS_RDBI.dataIdentifiers[0xfd0d] = "Dwell time"
UDS_RDBI.dataIdentifiers[0xfd0e] = "Applied ignition angle"
UDS_RDBI.dataIdentifiers[0xfd0f] = "Condition for active ignition circuit diagnosis"
UDS_RDBI.dataIdentifiers[0xfd10] = "Ignition powerstage error flag byte"
UDS_RDBI.dataIdentifiers[0xfd11] = "Flagbyte SPI error"
UDS_RDBI.dataIdentifiers[0xfd12] = "Flagword for stimulated ignition misfires"
UDS_RDBI.dataIdentifiers[0xfd13] = "Engine state"
UDS_RDBI.dataIdentifiers[0xfd14] = "State of crankshaft signal evaluation"
UDS_RDBI.dataIdentifiers[0xfd15] = "Starter status"
UDS_RDBI.dataIdentifiers[0xfd16] = "state of error wrong crankshaft signal"
UDS_RDBI.dataIdentifiers[0xfd17] = "Reason of cranksahft error"
UDS_RDBI.dataIdentifiers[0xfd18] = "State of camshaft position"
UDS_RDBI.dataIdentifiers[0xfd19] = "State of the camshaft diagnosis"
UDS_RDBI.dataIdentifiers[0xfd1a] = "voltage"
UDS_RDBI.dataIdentifiers[0xfd1b] = "Dew point"
UDS_RDBI.dataIdentifiers[0xfd1c] = "Bit heating on HEGO sensor 1 bank"
UDS_RDBI.dataIdentifiers[0xfd1d] = "Internal resistance HEGO sensor 1 bank"
UDS_RDBI.dataIdentifiers[0xfd1e] = "Signal acquisition of HEGO sensor 1 bank 1 Bit measurement of internal resistance enabled"
UDS_RDBI.dataIdentifiers[0xfd1f] = "Bit heating on HEGO sensor 2 bank"
UDS_RDBI.dataIdentifiers[0xfd20] = "FD21 FD40"  	 # or Cobasys UH Security Access
UDS_RDBI.dataIdentifiers[0xfd21] = "Internal resistance HEGO sensor 2 bank"  	 # or Cobasys Reset Usage History
UDS_RDBI.dataIdentifiers[0xfd22] = "Signal acquisition of HEGO sensor 2 bank 1 Bit measurement of internal resistance enabled"
UDS_RDBI.dataIdentifiers[0xfd23] = "Cycle flag for diagnosis LSU sensor 1 bank"
UDS_RDBI.dataIdentifiers[0xfd24] = "Ceramics temperature sensor 1 bank"
UDS_RDBI.dataIdentifiers[0xfd25] = "LSU temperature valid sensor 1 bank"
UDS_RDBI.dataIdentifiers[0xfd26] = "CJ135 Electrical diagnosis allowed"
UDS_RDBI.dataIdentifiers[0xfd27] = "Lambda actual value"
UDS_RDBI.dataIdentifiers[0xfd28] = "LSU Signal quality"
UDS_RDBI.dataIdentifiers[0xfd29] = "LSU Pump current"
UDS_RDBI.dataIdentifiers[0xfd2a] = "Signal quality for internal LSU temperature"
UDS_RDBI.dataIdentifiers[0xfd2b] = "Knock sensor diagnosis active lower threshold"
UDS_RDBI.dataIdentifiers[0xfd2c] = "KS diagnosis current value lower threshold UDKSV6UN"
UDS_RDBI.dataIdentifiers[0xfd2d] = "Reference level knock control"
UDS_RDBI.dataIdentifiers[0xfd2e] = "Knock amplification factor"
UDS_RDBI.dataIdentifiers[0xfd2f] = "Air charge load"
UDS_RDBI.dataIdentifiers[0xfd30] = "PSP request"  	 # or Cobasys UH Amp Hrs In
UDS_RDBI.dataIdentifiers[0xfd31] = "PSP powerstage command"  	 # or Cobasys UH Amp Hrs Out
UDS_RDBI.dataIdentifiers[0xfd32] = "Cobasys UH Last Abuse Cond"  	 # or Manifold pressure sensor voltage
UDS_RDBI.dataIdentifiers[0xfd33] = "Cobasys Activate Service CAN"  	 # or Boost pressure sensor voltage
UDS_RDBI.dataIdentifiers[0xfd34] = "Manifold air temperature sensor voltage"
UDS_RDBI.dataIdentifiers[0xfd35] = "Temperature Upstream Throttle voltage"
UDS_RDBI.dataIdentifiers[0xfd36] = "Throttle valve sensor feedback 1 voltage"
UDS_RDBI.dataIdentifiers[0xfd37] = "Throttle valve sensor feedback 2 voltage"
UDS_RDBI.dataIdentifiers[0xfd38] = "H Bridge throttle command"
UDS_RDBI.dataIdentifiers[0xfd39] = "H Bridge throttle inhibition"
UDS_RDBI.dataIdentifiers[0xfd3a] = "Pop off command"
UDS_RDBI.dataIdentifiers[0xfd3b] = "VVT Intake powerstage command"
UDS_RDBI.dataIdentifiers[0xfd3c] = "Waste gate powerstage command"
UDS_RDBI.dataIdentifiers[0xfd3d] = "Engine temperature voltage"
UDS_RDBI.dataIdentifiers[0xfd3e] = "Engine temperature"
UDS_RDBI.dataIdentifiers[0xfd3f] = "FanDIO 0 powerstage command"
UDS_RDBI.dataIdentifiers[0xfd40] = "FD41 FD60"
UDS_RDBI.dataIdentifiers[0xfd41] = "FanDIO 1 powerstage command"
UDS_RDBI.dataIdentifiers[0xfd42] = "CThmst2 powerstage command"
UDS_RDBI.dataIdentifiers[0xfd43] = "FAN powerstage command"
UDS_RDBI.dataIdentifiers[0xfd44] = "CThmst powerstage command"
UDS_RDBI.dataIdentifiers[0xfd45] = "OilPCtl powerstage command"
UDS_RDBI.dataIdentifiers[0xfd46] = "DPTC powerstage command"
UDS_RDBI.dataIdentifiers[0xfd47] = "ACCOM powerstage command"
UDS_RDBI.dataIdentifiers[0xfd48] = "CPURGEV powerstage command"
UDS_RDBI.dataIdentifiers[0xfd49] = "Shtr powerstage command"
UDS_RDBI.dataIdentifiers[0xfd4a] = "Raw load on the Alternator"
UDS_RDBI.dataIdentifiers[0xfd4b] = "Accelerator pedal brute value sensor 1 without limitations"
UDS_RDBI.dataIdentifiers[0xfd4d] = "Gas pedal value sensor"
UDS_RDBI.dataIdentifiers[0xfd4e] = "WG position voltage"
UDS_RDBI.dataIdentifiers[0xfd4f] = "Brake switch raw value"
UDS_RDBI.dataIdentifiers[0xfd50] = "AC switch raw value"
UDS_RDBI.dataIdentifiers[0xfd51] = "Cruise control and speed limiter steering wheel push buttons raw value"
UDS_RDBI.dataIdentifiers[0xfd52] = "Input of the cruise control main switch raw value"
UDS_RDBI.dataIdentifiers[0xfd53] = "Speed limiter main switch raw value"
UDS_RDBI.dataIdentifiers[0xfd54] = "Clutch raw value"
UDS_RDBI.dataIdentifiers[0xfd55] = "State of the begin high of the clutch pedal raw value"
UDS_RDBI.dataIdentifiers[0xfd56] = "CAC powerstage command"
UDS_RDBI.dataIdentifiers[0xfd57] = "H Bridge Waste Gate direction information"
UDS_RDBI.dataIdentifiers[0xfd58] = "H Bridge Waste Gate command"
UDS_RDBI.dataIdentifiers[0xfd59] = "Reset ID of the last reset reason"
UDS_RDBI.dataIdentifiers[0xfd5a] = "Dynamically switched environmental condition messages depending on error reaction"
UDS_RDBI.dataIdentifiers[0xfd5b] = "Dynamically switched environmental condition messages depending on error reaction"
UDS_RDBI.dataIdentifiers[0xfd5c] = "Dynamically switched environmental condition messages depending on error reaction"
UDS_RDBI.dataIdentifiers[0xfd5d] = "Dynamically switched environmental condition messages depending on error reaction 4"
UDS_RDBI.dataIdentifiers[0xfd5e] = "Output voltage of HEGO sensor 1 bank 1 extended range"
UDS_RDBI.dataIdentifiers[0xfd5f] = "Output voltage of HEGO sensor 2 bank 1 extended range"
UDS_RDBI.dataIdentifiers[0xfd60] = "FD61 FD80"
UDS_RDBI.dataIdentifiers[0xfd61] = "Bit internal resistance is valid HEGO sensor 1 bank"
UDS_RDBI.dataIdentifiers[0xfd62] = "Bit internal resistance is valid HEGO sensor 2 bank"
UDS_RDBI.dataIdentifiers[0xfd64] = "Vacuum pump command"
UDS_RDBI.dataIdentifiers[0xfd65] = "Vacumm pressure sensor value"
UDS_RDBI.dataIdentifiers[0xfd66] = "Condition for knocking Knocking event detected"
UDS_RDBI.dataIdentifiers[0xfd67] = "Condition for knock control active"
UDS_RDBI.dataIdentifiers[0xfd68] = "integrator value with offset correction Instantaneous knock noise for each cylinder 0"
UDS_RDBI.dataIdentifiers[0xfd69] = "integrator value with offset correction Instantaneous knock noise for each cylinder"
UDS_RDBI.dataIdentifiers[0xfd6a] = "integrator value with offset correction Instantaneous knock noise for each cylinder"
UDS_RDBI.dataIdentifiers[0xfd6b] = "measured Ip raw value sensor 1 bank"
UDS_RDBI.dataIdentifiers[0xfd6c] = "measured CJ135 Mode sensor 1 bank"
UDS_RDBI.dataIdentifiers[0xfd6d] = "probable CJ135 Mode sensor 1 bank"
UDS_RDBI.dataIdentifiers[0xfd6e] = "Duty cycle control powerstage heater sensor 1 bank"
UDS_RDBI.dataIdentifiers[0xfd6f] = "Lambda signal quality sensor 1 bank"
UDS_RDBI.dataIdentifiers[0xfd70] = "effective heater voltage reqested by heater control from heater power stage control sensor 1 bank"
UDS_RDBI.dataIdentifiers[0xfd71] = "cylinder counter of knock control"
UDS_RDBI.dataIdentifiers[0xfd72] = "Knock amplification factor 0"
UDS_RDBI.dataIdentifiers[0xfd73] = "Knock amplification factor"
UDS_RDBI.dataIdentifiers[0xfd74] = "Knock amplification factor"
UDS_RDBI.dataIdentifiers[0xfd75] = "Normalized reference level of knock control"
UDS_RDBI.dataIdentifiers[0xfd76] = "Normalized reference level of knock control"
UDS_RDBI.dataIdentifiers[0xfd77] = "Normalized reference level of knock control"
UDS_RDBI.dataIdentifiers[0xfd78] = "normalized reference level of knock control"
UDS_RDBI.dataIdentifiers[0xfd79] = "Effective injection time"
UDS_RDBI.dataIdentifiers[0xfd7a] = "Effective injection time for cylinder"
UDS_RDBI.dataIdentifiers[0xfd7b] = "Effective injection time for cylinder 4"
UDS_RDBI.dataIdentifiers[0xfd7c] = "Applied ignition angle for cylinder"
UDS_RDBI.dataIdentifiers[0xfd7d] = "Applied ignition angle for cylinder"
UDS_RDBI.dataIdentifiers[0xfd7e] = "Applied ignition angle for cylinder 4"
UDS_RDBI.dataIdentifiers[0xfd7f] = "Knock amplification factor"
UDS_RDBI.dataIdentifiers[0xfd80] = "Effective injection time"
UDS_RDBI.dataIdentifiers[0xfd81] = "Effective injection time"
UDS_RDBI.dataIdentifiers[0xfd82] = "Applied ignition angle"
UDS_RDBI.dataIdentifiers[0xfd83] = "Applied ignition angle"
UDS_RDBI.dataIdentifiers[0xfd84] = "Applied ignition angle"
UDS_RDBI.dataIdentifiers[0xfdd2] = "ROE Variant"
UDS_RDBI.dataIdentifiers[0xfe00] = "ISFTFiltVC"
UDS_RDBI.dataIdentifiers[0xfe01] = "HwAcc SST O"
UDS_RDBI.dataIdentifiers[0xfe02] = "BTCIIBSNormal"
UDS_RDBI.dataIdentifiers[0xfe03] = "START STOP"
UDS_RDBI.dataIdentifiers[0xfe04] = "BTCCIC"
UDS_RDBI.dataIdentifiers[0xfe05] = "BTCCShunt"
UDS_RDBI.dataIdentifiers[0xfe06] = "BTCCBattery"
UDS_RDBI.dataIdentifiers[0xfe07] = "BTCRShunt"
UDS_RDBI.dataIdentifiers[0xfe08] = "BTCTauIS"
UDS_RDBI.dataIdentifiers[0xfe09] = "BTCTauIA"
UDS_RDBI.dataIdentifiers[0xfe10] = "POWER SUPPLY AND BATTERY SWITCH IO"
UDS_RDBI.dataIdentifiers[0xfe11] = "HwAcc SYS O"
UDS_RDBI.dataIdentifiers[0xfe12] = "POWER SUPPLY AND BATTERY SWITCH"
UDS_RDBI.dataIdentifiers[0xfe13] = "BTCTauBA"
UDS_RDBI.dataIdentifiers[0xfe14] = "OB PowerSupply Switching STUETZKONZEPT IO"
UDS_RDBI.dataIdentifiers[0xfe15] = "OB PowerSupply Switching STUETZKONZEPT"
UDS_RDBI.dataIdentifiers[0xfe16] = "WURQuiesActvLmt"
UDS_RDBI.dataIdentifiers[0xfe17] = "WURVoltLmt"
UDS_RDBI.dataIdentifiers[0xfe18] = "SHIFT BY WIRE IO"
UDS_RDBI.dataIdentifiers[0xfe19] = "SHIFT BY WIRE"
UDS_RDBI.dataIdentifiers[0xfe1a] = "Door Contacts"
UDS_RDBI.dataIdentifiers[0xfe1b] = "Door Contacts IO"
UDS_RDBI.dataIdentifiers[0xfe20] = "SBC LIN"
UDS_RDBI.dataIdentifiers[0xfe21] = "SBC LIN IO"
UDS_RDBI.dataIdentifiers[0xfe22] = "CAN Interfaces IO"
UDS_RDBI.dataIdentifiers[0xfe23] = "BTS"
UDS_RDBI.dataIdentifiers[0xfe24] = "BTS IO"
UDS_RDBI.dataIdentifiers[0xfe25] = "LADESCHALTUNG Charging Circuit IO"
UDS_RDBI.dataIdentifiers[0xfe26] = "LADESCHALTUNG Charging Circuit"
UDS_RDBI.dataIdentifiers[0xfe27] = "TAG3 LIN HFA LIN BLE IO"
UDS_RDBI.dataIdentifiers[0xfe28] = "Ethernet IO"
UDS_RDBI.dataIdentifiers[0xfe29] = "Ethernet"
UDS_RDBI.dataIdentifiers[0xfe2a] = "DRCIGradient3"
UDS_RDBI.dataIdentifiers[0xfe2b] = "DRCIGradient4"
UDS_RDBI.dataIdentifiers[0xfe2c] = "DRCIGradient5"
UDS_RDBI.dataIdentifiers[0xfe2d] = "DRCTClass1"
UDS_RDBI.dataIdentifiers[0xfe2e] = "DRCTClass2"
UDS_RDBI.dataIdentifiers[0xfe2f] = "DRCTClass3"
UDS_RDBI.dataIdentifiers[0xfe30] = " 100Base Tx IO"
UDS_RDBI.dataIdentifiers[0xfe31] = "Broadr Reach IO"
UDS_RDBI.dataIdentifiers[0xfe32] = "DRCIClass3"
UDS_RDBI.dataIdentifiers[0xfe33] = "DRCIClass4"
UDS_RDBI.dataIdentifiers[0xfe34] = "DRCIClass5"
UDS_RDBI.dataIdentifiers[0xfe35] = "DRCRStepMax"
UDS_RDBI.dataIdentifiers[0xfe36] = "DRCFilterLow"
UDS_RDBI.dataIdentifiers[0xfe37] = "DRCFilterHigh"
UDS_RDBI.dataIdentifiers[0xfe38] = "ISFTM"
UDS_RDBI.dataIdentifiers[0xfe50] = "OMCMaxTransTime"
UDS_RDBI.dataIdentifiers[0xfee0] = "FEE1 FEFF"
UDS_RDBI.dataIdentifiers[0xfee5] = "Dummy message configuration for Ignition control tester request"
UDS_RDBI.dataIdentifiers[0xfee9] = "Dummy message configuration for Injection control tester request"
UDS_RDBI.dataIdentifiers[0xfeff] = "Supplier component reset"
UDS_RDBI.dataIdentifiers[0xff61] = "FIMs"
UDS_RDBI.dataIdentifiers[0xff62] = "inverter signals"
