/* 
   sand - helps you keep your diary
   
   ddecode.h - decoder for diary format 

   Copyright (C) 2001 Per Jonsson

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

*/

#ifndef __DDECODE_H__
#define __DDECODE_H__

typedef struct diary_base{
  size_t length;
  int position;
  char * text;
} dinfo;

typedef struct diary_time{
  int year;
  int month;
  int day;
  int hour;
  int minute;
  int seconds;
} dtime;

typedef struct diary_note{
  int length;
  dtime time;
  char * title;
  char * text;
} dnote;

#define DIARY_IS     1
#define DIARY_IS_NOT 2
#define DIARY_ERROR  4

#define DIARY_NEXT_NOTE -1 

#define ERR_INV_FORMAT -1
#define ERR_NO_SUCH_NOTE -2
#define DATE_OK 0

#define EXIT_EVIL  26

dnote ddecode_note(dinfo * d, int note);
dnote ddecode_note_next(dinfo * d);
int ddecode_init(dinfo * diary);
int ddecode_date(const dinfo  d, dnote * n, int p, int e);

dtime time_t2dtime(time_t t);

char * dencode_date (dnote n);
dnote dencode_note_now(char * s, char * p);
dnote dencode_note(char * s, char * p, time_t t);
int dencode_fputnote(dnote d, FILE * s);
#endif


