class TestUtilities < Test::Unit::TestCase
	include TapKit

	def setup
		@app = Application.new MODELS
		@ec  = @app.create_editing_context
	end

	# return array (raw rows)
	def test_raw_rows
		sql = "SELECT COUNT(*) FROM cd"
		rows = @ec.raw_rows(MODEL1, sql)

		# depend on database
		model = @app.model MODEL1
		adapter = @app.adapter model
		case model.adapter_name
		when 'MySQL' then
			assert rows.first.key?("COUNT(*)")
		when 'PostgreSQL' then
			assert rows.first.key?("count")
		when 'OpenBase' then
			assert rows.first.key?("*")
		end
	end
end
