class TestTime < Test::Unit::TestCase
	include TapKit

	def setup
		@time = Time.new(12,30,30)
	end

	def test_parse
		str = '12:30:30'
		time = Time.parse str
		assert_equal(12, time.hour)
		assert_equal(30, time.minute)
		assert_equal(30, time.second)
	end

	def test_new
		time = Time.new(12,30,30)
		assert_equal(12, time.hour)
		assert_equal(30, time.minute)
		assert_equal(30, time.second)
	end

	def test_new_with_time
		_time = ::Time.local(2003,12,15,12,30,30)
		time = Time.new_with_time _time

		assert_equal(12, time.hour)
		assert_equal(30, time.minute)
		assert_equal(30, time.second)
	end

	def test_now
		_time = ::Time.new
		time = Time.now

		assert_equal(_time.hour, time.hour)
		assert_equal(_time.min, time.minute)
		assert_equal(_time.sec, time.second)
	end

	# +, -
	def test_calc
		time1   = Time.new(12, 31, 0)
		time2   = Time.new(12, 30, 0)
		plus    = @time + 30
		minus1  = @time - 30
		minus2  = @time - ::Time.local(2003,12,15,12,30,0)
		_minus2 = @time.to_time - ::Time.local(2003,12,15,12,30,0)

		assert_equal(time1, plus)
		assert_equal(time2, minus1)
		assert_equal(_minus2, minus2)
	end

	# <=>
	def test_compare
		compare1 = @time <=> Time.new(12,30,30)
		compare2 = @time <=> Time.new(12,30,0)
		compare3 = @time <=> Time.new(12,30,31)

		assert_equal(0, compare1)
		assert_equal(1, compare2)
		assert_equal(-1, compare3)
	end

	def test_to_time
		time = @time.to_time
		assert_equal(12, time.hour)
		assert_equal(30, time.min)
		assert_equal(30, time.sec)
	end

	def test_to_s
		str = '12:30:30'
		assert_equal(str, @time.to_s)
	end
end


