class TestApplication < Test::Unit::TestCase
	include TapKit

	def setup
		@app = Application.new MODELS
		@ec  = @app.create_editing_context
	end

	def test_new
		assert_nothing_thrown { Application.new }
		assert_nothing_thrown { Application.new MODEL1 } # 1 model
		assert_nothing_thrown { Application.new MODELS } # 2 models array
	end

	# memory leak?
=begin
	def test_sql_debug
		read, write = IO.pipe

		app = Application.new MODEL1
		app.log_options[:sql] = true
		app.log_options[:out] = write
		ec = app.create_editing_context

		qualifier = Qualifier.format "title like '*'"
		fetchspec = FetchSpec.new('cd', qualifier)
		fetchspec.limit = 1
		objects   = ec.fetch fetchspec

		debug = read.gets
		assert_match(/SELECT/, debug)
		read.close
		write.close
	end
=end

	def test_encoding
		require 'kconv'
		teststr = "test ܸʸ" # Japanese EUC string
		encodings = {
			'jis' =>'jis', 'jis' =>'sjis', 'jis' =>'euc',
			'sjis'=>'jis', 'sjis'=>'sjis', 'sjis'=>'euc',
			'euc' =>'jis', 'euc' =>'sjis', 'euc' =>'euc'}
		kconv = {'jis'=>Kconv::JIS, 'sjis'=>Kconv::SJIS, 'euc'=>Kconv::EUC}

		model = @app.model MODEL1
		connection = model.connection
		dummy1 = Time.now.to_s # artist name
		dummy2 = 2000          # release year
		encodings.each do |input, output|
			# 1. insert (or update)
			connection['encoding'] = input
			test_obj = @ec.create 'cd'
			test_obj['title']   = teststr.kconv(kconv[input])
			test_obj['artist']  = dummy1
			test_obj['release'] = dummy2
			@ec.save

			binding   = [dummy1, dummy2]
			qualifier = Qualifier.format("(artist == %@) and (release == %@)", binding)
			fetchspec = FetchSpec.new('cd', qualifier)
			fetchspec.refresh = true
			objects   = @ec.fetch fetchspec
			object    = objects.first
			assert_equal(test_obj['title'], object['title'])

			# 2. fetch
			connection['encoding'] = output
			binding   = [dummy1, dummy2]
			qualifier = Qualifier.format("(artist == %@) and (release == %@)", binding)
			fetchspec = FetchSpec.new('cd', qualifier)
			fetchspec.refresh = true
			objects   = @ec.fetch fetchspec
			object    = objects.first
			assert_equal(teststr.kconv(kconv[output]), object['title'])
		end
	end

	def test_cache
		app = Application.new(MODEL2, '.')
		model = app.model(MODEL2)
		assert_equal(false, model.nil?)
		assert FileTest.exist?(model.cache_path)
		File.delete model.cache_path
	end
end
