module TapKit

	class GlobalIDStore
		def initialize
			@store = {}
		end

		def gids
			@store.keys
		end

		def objects
			@store.values
		end

		def add( gid, object )
			unless @store.value? object then
				@store[gid] = object
			end
		end

		def forget( object )
			@store.delete_if do |key, value|
				if value == object then
					true
				else
					false
				end
			end
		end

		def forget_for_gid( gid )
			@store.delete gid
		end

		def gid( object )
			@store.each do |_gid, _object|
				if object == _object then
					return _gid
				end
			end
			nil
		end

		def gid?( gid )
			if @store[gid] then
				true
			else
				false
			end
		end

		def object( gid )
			@store[gid]
		end

		def object?( object )
			@store.each do |key, value|
				if object == value then
					return true
				end
			end
			false
		end
	end


	# Abstract class for global ID.
	class GlobalID
		GID_CHANGED_NOTIFICATION = :gid_changed_notification

		def clone
			self
		end

		def temporary?
			false
		end
	end

	class KeyGlobalID < GlobalID
		attr_reader :entity_name, :hash

		def initialize( entity_name, key_values )
			@entity_name = entity_name
			@key_values  = key_values

			# build hash code
			list = []
			list << @key_values.keys
			list << @key_values.values
			@hash = @entity_name.hash ^ list.hash
		end

		def eql?( other )
			if KeyGlobalID === other then
				if (@entity_name == other.entity_name) and \
					(@key_values == other.key_values) then
					true
				else
					false
				end
			else
				false
			end
		end

		def ==( other )
			if @hash == other.hash then
				true
			else
				false
			end
		end

		def key_values
			@key_values.dup
		end

		def key_count
			@key_values.size
		end
	end

	class TemporaryGlobalID < GlobalID
		def temporary?
			true
		end

		def to_s
			"TempGID:#{id}"
		end
	end


end
