
module TapKit
	class DatabaseObject
		include Aliasable

		attr_accessor :editing_context

		def initialize
			@state = {}
		end

		# Sets all properties to nil.
		def clear
			@state.clear
		end

		def to_many_key?( key )
			if all_to_many_relationship_keys.include? key then
				true
			else
				false
			end
		end

		def snapshot
			snapshot = Snapshot.new
			snapshot.update_from_object(@editing_context, self)
			snapshot
		end

		def update_from_snapshot( snapshot )
			all_property_keys.each do |key|
				if value = snapshot[key] then
					if to_one_relationship_keys.include?(key) and (value != nil) then
						value = @editing_context.fault value
					elsif to_many_relationship_keys.include?(key) and (value != nil) then
						value = @editing_context.array_fault(value.source_gid, key)
					end
					_init_stored_value(key, value)
				end
			end
		end

		def _init_stored_value( key, value ) #:nodoc:
			@state[key] = value
		end

		def will_change
			oc.notify_will_change self
		end


		##
		## using ClassDescription methods
		##

		def class_description( detail_key = nil )
			if detail_key then
				@class_description.class_description detail_key
			else
				@class_description
			end
		end

		def delete_rule( relationship_key )
			@class_description.delete_rule relationship_key
		end

		def entity_name
			@class_description.entity_name
		end

		def all_property_keys
			@class_description.all_property_keys
		end

		def property_keys
			@class_description.property_keys
		end

		def all_attribute_keys
			@class_description.all_attribute_keys
		end

		def attribute_keys
			@class_description.attribute_keys
		end

		def all_to_one_relationship_keys
			@class_description.all_to_one_relationship_keys
		end

		def to_one_relationship_keys
			@class_description.to_one_relationship_keys
		end

		def all_to_many_relationship_keys
			@class_description.all_to_many_relationship_keys
		end
		
		def to_many_relationship_keys
			@class_description.to_many_relationship_keys
		end

		def propagate_delete( editing_context )
			@class_description.propagate_delete(self, editing_context)
		end

		def inverse( relationship_key )
			@class_description.inverse relationship_key
		end
	end


	class CustomObject < DatabaseObject
		include Faulting, KeyValueCodingAdditions, StoredKeyValueCoding, Validation, \
			RelationshipManipulation

		attr_reader :fault_handler

		class << self
			def access_instance_variables?
				true
			end

			def use_stored_accessors?
				true
			end
		end

		def awake_from_update( editing_context )
		end

		def awake_from_fetch( editing_context )
			@class_description.awake_from_fetch(self, editing_context)
		end

		def awake_from_insertion( editing_context )
			@class_description.awake_from_insertion(self, editing_context)
		end

		alias []  retrieve_value_for_keypath
		alias []= take_value_for_keypath

		def to_s
			str = ''
			if fault? then
				str = @fault_handler.to_s
			else
				str = '{'
				property_keys.each do |key|
					value = retrieve_stored_value key
					if GenericRecord === value then
						if value.fault? then
							str << "#{key} = #{value.fault_handler}"
						else
							str << "#{key} = <GenericRecord>"
						end
					else
						str << "#{key} = #{value.inspect}"
					end
					unless key == property_keys.last then
						str << ', '
					end
				end
				str << '}'
			end
			str
		end

		alias inspect to_s

		def each
			property_keys.each do |key|
				value = retrieve_stored_value key
				yield value
			end
		end
	end


	class GenericRecord < CustomObject

		def initialize( description = nil )
			super()
			@class_description = description
		end

	end

end
