module TapKit

	# == Top level objects
	# ModelGroup, ObjectStoreCoordinator, ObserverCenter, SharedEditingContext
	class Application
		attr_reader :model_group, :fetch_timestamp_lag, :observer_center, :notification_center
		attr_reader :object_store, :shared_editing_context, :databases
		attr_accessor :log_options

		def initialize( paths = [], cache_path = nil )
			@observer_center        = ObserverCenter.new
			@notification_center    = NotificationCenter.new
			@model_group            = ModelGroup.new self
			@object_store           = ObjectStoreCoordinator.new self
			@shared_editing_context = SharedEditingContext.new @object_store
			@databases              = {}
			@log_options            = {:sql => false, :out => $stdout}

			if String === paths then
				paths = [paths]
			end
			add_models(paths, cache_path)

			@notification_center.add(DatabaseContext, :handle_notification,
				ObjectStoreCoordinator::COS_NEEDED_NOTIFICATION)
		end

		def add_database( model, db )
			@databases[model] = db
		end

		def database( model )
			@databases[model]
		end

		def adapter( model )
			if db = @databases[model] then
				db.adapter
			end
		end

		def add_model( model, cache_path = nil )
			@model_group.add(model, cache_path)
		end

		alias << add_model

		def add_models( models, cache_path = nil )
			models.each do |model|
				add_model(model, cache_path)
			end
		end

		def models
			@model_group.models
		end

		def model( name )
			@model_group.model name
		end

		def entities
			@model_group.entities
		end

		def entity( name )
			@model_group.entity name
		end

		def create_editing_context
			ec = EditingContext.new @object_store
			ec.shared_editing_context = @shared_editing_context
			ec
		end

		alias ec create_editing_context
	end
end

