/**
* @file src/llvmir2hll/semantics/semantics/win_api_semantics/get_name_of_param/r.cpp
* @brief Implementation of the initialization of WinAPI functions.
* @copyright (c) 2017 Avast Software, licensed under the MIT license
*/

#include "retdec/llvmir2hll/semantics/semantics/win_api_semantics/get_name_of_param/r.h"

namespace retdec {
namespace llvmir2hll {
namespace semantics {
namespace win_api {

/**
* @brief Initializes the given map with info about functions starting with R.
*/
void initFuncParamNamesMap_R(FuncParamNamesMap &funcParamNamesMap) {
	//
	// windows.h
	//
	ADD_PARAM_NAME("RaiseException", 1, "dwExceptionCode"); // DWORD
	ADD_PARAM_NAME("RaiseException", 2, "dwExceptionFlags"); // DWORD
	ADD_PARAM_NAME("RaiseException", 3, "nNumberOfArguments"); // DWORD
	ADD_PARAM_NAME("RaiseException", 4, "lpArguments"); // CONST ULONG_PTR *
	ADD_PARAM_NAME("ReOpenFile", 1, "hOriginalFile"); // HANDLE
	ADD_PARAM_NAME("ReOpenFile", 2, "dwDesiredAccess"); // DWORD
	ADD_PARAM_NAME("ReOpenFile", 3, "dwShareMode"); // DWORD
	ADD_PARAM_NAME("ReOpenFile", 4, "dwFlagsAndAttributes"); // DWORD
	ADD_PARAM_NAME("ReadConsoleA", 1, "hConsoleInput"); // HANDLE
	ADD_PARAM_NAME("ReadConsoleA", 2, "lpBuffer"); // LPVOID
	ADD_PARAM_NAME("ReadConsoleA", 3, "nNumberOfCharsToRead"); // DWORD
	ADD_PARAM_NAME("ReadConsoleA", 4, "lpNumberOfCharsRead"); // LPDWORD
	ADD_PARAM_NAME("ReadConsoleA", 5, "lpReserved"); // LPVOID
	ADD_PARAM_NAME("ReadConsoleInputA", 1, "hConsoleInput"); // HANDLE
	ADD_PARAM_NAME("ReadConsoleInputA", 2, "lpBuffer"); // PINPUT_RECORD
	ADD_PARAM_NAME("ReadConsoleInputA", 3, "nLength"); // DWORD
	ADD_PARAM_NAME("ReadConsoleInputA", 4, "lpNumberOfEventsRead"); // LPDWORD
	ADD_PARAM_NAME("ReadConsoleInputW", 1, "hConsoleInput"); // HANDLE
	ADD_PARAM_NAME("ReadConsoleInputW", 2, "lpBuffer"); // PINPUT_RECORD
	ADD_PARAM_NAME("ReadConsoleInputW", 3, "nLength"); // DWORD
	ADD_PARAM_NAME("ReadConsoleInputW", 4, "lpNumberOfEventsRead"); // LPDWORD
	ADD_PARAM_NAME("ReadConsoleOutputA", 1, "hConsoleOutput"); // HANDLE
	ADD_PARAM_NAME("ReadConsoleOutputA", 2, "lpBuffer"); // PCHAR_INFO
	ADD_PARAM_NAME("ReadConsoleOutputA", 3, "dwBufferSize"); // COORD
	ADD_PARAM_NAME("ReadConsoleOutputA", 4, "dwBufferCoord"); // COORD
	ADD_PARAM_NAME("ReadConsoleOutputA", 5, "lpReadRegion"); // PSMALL_RECT
	ADD_PARAM_NAME("ReadConsoleOutputAttribute", 1, "hConsoleOutput"); // HANDLE
	ADD_PARAM_NAME("ReadConsoleOutputAttribute", 2, "lpAttribute"); // LPWORD
	ADD_PARAM_NAME("ReadConsoleOutputAttribute", 3, "nLength"); // DWORD
	ADD_PARAM_NAME("ReadConsoleOutputAttribute", 4, "dwReadCoord"); // COORD
	ADD_PARAM_NAME("ReadConsoleOutputAttribute", 5, "lpNumberOfAttrsRead"); // LPDWORD
	ADD_PARAM_NAME("ReadConsoleOutputCharacterA", 1, "hConsoleOutput"); // HANDLE
	ADD_PARAM_NAME("ReadConsoleOutputCharacterA", 2, "lpCharacter"); // LPSTR
	ADD_PARAM_NAME("ReadConsoleOutputCharacterA", 3, "nLength"); // DWORD
	ADD_PARAM_NAME("ReadConsoleOutputCharacterA", 4, "dwReadCoord"); // COORD
	ADD_PARAM_NAME("ReadConsoleOutputCharacterA", 5, "lpNumberOfCharsRead"); // LPDWORD
	ADD_PARAM_NAME("ReadConsoleOutputCharacterW", 1, "hConsoleOutput"); // HANDLE
	ADD_PARAM_NAME("ReadConsoleOutputCharacterW", 2, "lpCharacter"); // LPWSTR
	ADD_PARAM_NAME("ReadConsoleOutputCharacterW", 3, "nLength"); // DWORD
	ADD_PARAM_NAME("ReadConsoleOutputCharacterW", 4, "dwReadCoord"); // COORD
	ADD_PARAM_NAME("ReadConsoleOutputCharacterW", 5, "lpNumberOfCharsRead"); // LPDWORD
	ADD_PARAM_NAME("ReadConsoleOutputW", 1, "hConsoleOutput"); // HANDLE
	ADD_PARAM_NAME("ReadConsoleOutputW", 2, "lpBuffer"); // PCHAR_INFO
	ADD_PARAM_NAME("ReadConsoleOutputW", 3, "dwBufferSize"); // COORD
	ADD_PARAM_NAME("ReadConsoleOutputW", 4, "dwBufferCoord"); // COORD
	ADD_PARAM_NAME("ReadConsoleOutputW", 5, "lpReadRegion"); // PSMALL_RECT
	ADD_PARAM_NAME("ReadConsoleW", 1, "hConsoleInput"); // HANDLE
	ADD_PARAM_NAME("ReadConsoleW", 2, "lpBuffer"); // LPVOID
	ADD_PARAM_NAME("ReadConsoleW", 3, "nNumberOfCharsToRead"); // DWORD
	ADD_PARAM_NAME("ReadConsoleW", 4, "lpNumberOfCharsRead"); // LPDWORD
	ADD_PARAM_NAME("ReadConsoleW", 5, "lpReserved"); // LPVOID
	ADD_PARAM_NAME("ReadDirectoryChangesW", 1, "hDirectory"); // HANDLE
	ADD_PARAM_NAME("ReadDirectoryChangesW", 2, "lpBuffer"); // LPVOID
	ADD_PARAM_NAME("ReadDirectoryChangesW", 3, "nBufferLength"); // DWORD
	ADD_PARAM_NAME("ReadDirectoryChangesW", 4, "bWatchSubtree"); // WINBOOL
	ADD_PARAM_NAME("ReadDirectoryChangesW", 5, "dwNotifyFilter"); // DWORD
	ADD_PARAM_NAME("ReadDirectoryChangesW", 6, "lpBytesReturned"); // LPDWORD
	ADD_PARAM_NAME("ReadDirectoryChangesW", 7, "lpOverlapped"); // LPOVERLAPPED
	ADD_PARAM_NAME("ReadDirectoryChangesW", 8, "lpCompletionRoutine"); // LPOVERLAPPED_COMPLETION_ROUTINE
	ADD_PARAM_NAME("ReadEncryptedFileRaw", 1, "pfExportCallback"); // PFE_EXPORT_FUNC
	ADD_PARAM_NAME("ReadEncryptedFileRaw", 2, "pvCallbackContext"); // PVOID
	ADD_PARAM_NAME("ReadEncryptedFileRaw", 3, "pvContext"); // PVOID
	ADD_PARAM_NAME("ReadEventLogA", 1, "hEventLog"); // HANDLE
	ADD_PARAM_NAME("ReadEventLogA", 2, "dwReadFlags"); // DWORD
	ADD_PARAM_NAME("ReadEventLogA", 3, "dwRecordOffset"); // DWORD
	ADD_PARAM_NAME("ReadEventLogA", 4, "lpBuffer"); // LPVOID
	ADD_PARAM_NAME("ReadEventLogA", 5, "nNumberOfBytesToRead"); // DWORD
	ADD_PARAM_NAME("ReadEventLogA", 6, "pnBytesRead"); // DWORD *
	ADD_PARAM_NAME("ReadEventLogA", 7, "pnMinNumberOfBytesNeeded"); // DWORD *
	ADD_PARAM_NAME("ReadEventLogW", 1, "hEventLog"); // HANDLE
	ADD_PARAM_NAME("ReadEventLogW", 2, "dwReadFlags"); // DWORD
	ADD_PARAM_NAME("ReadEventLogW", 3, "dwRecordOffset"); // DWORD
	ADD_PARAM_NAME("ReadEventLogW", 4, "lpBuffer"); // LPVOID
	ADD_PARAM_NAME("ReadEventLogW", 5, "nNumberOfBytesToRead"); // DWORD
	ADD_PARAM_NAME("ReadEventLogW", 6, "pnBytesRead"); // DWORD *
	ADD_PARAM_NAME("ReadEventLogW", 7, "pnMinNumberOfBytesNeeded"); // DWORD *
	ADD_PARAM_NAME("ReadFile", 1, "hFile"); // HANDLE
	ADD_PARAM_NAME("ReadFile", 2, "lpBuffer"); // LPVOID
	ADD_PARAM_NAME("ReadFile", 3, "nNumberOfBytesToRead"); // DWORD
	ADD_PARAM_NAME("ReadFile", 4, "lpNumberOfBytesRead"); // LPDWORD
	ADD_PARAM_NAME("ReadFile", 5, "lpOverlapped"); // LPOVERLAPPED
	ADD_PARAM_NAME("ReadFileEx", 1, "hFile"); // HANDLE
	ADD_PARAM_NAME("ReadFileEx", 2, "lpBuffer"); // LPVOID
	ADD_PARAM_NAME("ReadFileEx", 3, "nNumberOfBytesToRead"); // DWORD
	ADD_PARAM_NAME("ReadFileEx", 4, "lpOverlapped"); // LPOVERLAPPED
	ADD_PARAM_NAME("ReadFileEx", 5, "lpCompletionRoutine"); // LPOVERLAPPED_COMPLETION_ROUTINE
	ADD_PARAM_NAME("ReadFileScatter", 1, "hFile"); // HANDLE
	ADD_PARAM_NAME("ReadFileScatter", 2, "aSegmentArray"); // FILE_SEGMENT_ELEMENT []
	ADD_PARAM_NAME("ReadFileScatter", 3, "nNumberOfBytesToRead"); // DWORD
	ADD_PARAM_NAME("ReadFileScatter", 4, "lpReserved"); // LPDWORD
	ADD_PARAM_NAME("ReadFileScatter", 5, "lpOverlapped"); // LPOVERLAPPED
	ADD_PARAM_NAME("ReadPrinter", 1, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("ReadPrinter", 2, "pBuf"); // LPVOID
	ADD_PARAM_NAME("ReadPrinter", 3, "cbBuf"); // DWORD
	ADD_PARAM_NAME("ReadPrinter", 4, "pNoBytesRead"); // LPDWORD
	ADD_PARAM_NAME("ReadProcessMemory", 1, "hProcess"); // HANDLE
	ADD_PARAM_NAME("ReadProcessMemory", 2, "lpBaseAddress"); // LPCVOID
	ADD_PARAM_NAME("ReadProcessMemory", 3, "lpBuffer"); // LPVOID
	ADD_PARAM_NAME("ReadProcessMemory", 4, "nSize"); // SIZE_T
	ADD_PARAM_NAME("ReadProcessMemory", 5, "lpNumberOfBytesRead"); // SIZE_T *
	ADD_PARAM_NAME("RealChildWindowFromPoint", 1, "hwndParent"); // HWND
	ADD_PARAM_NAME("RealChildWindowFromPoint", 2, "ptParentClientCoords"); // POINT
	ADD_PARAM_NAME("RealGetWindowClassA", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("RealGetWindowClassA", 2, "ptszClassName"); // LPSTR
	ADD_PARAM_NAME("RealGetWindowClassA", 3, "cchClassNameMax"); // UINT
	ADD_PARAM_NAME("RealGetWindowClassW", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("RealGetWindowClassW", 2, "ptszClassName"); // LPWSTR
	ADD_PARAM_NAME("RealGetWindowClassW", 3, "cchClassNameMax"); // UINT
	ADD_PARAM_NAME("RealizePalette", 1, "hdc"); // HDC
	ADD_PARAM_NAME("RectInRegion", 1, "hrgn"); // HRGN
	ADD_PARAM_NAME("RectInRegion", 2, "lprect"); // CONST RECT *
	ADD_PARAM_NAME("RectVisible", 1, "hdc"); // HDC
	ADD_PARAM_NAME("RectVisible", 2, "lprect"); // CONST RECT *
	ADD_PARAM_NAME("Rectangle", 1, "hdc"); // HDC
	ADD_PARAM_NAME("Rectangle", 2, "left"); // int
	ADD_PARAM_NAME("Rectangle", 3, "top"); // int
	ADD_PARAM_NAME("Rectangle", 4, "right"); // int
	ADD_PARAM_NAME("Rectangle", 5, "bottom"); // int
	ADD_PARAM_NAME("RedrawWindow", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("RedrawWindow", 2, "lprcUpdate"); // CONST RECT *
	ADD_PARAM_NAME("RedrawWindow", 3, "hrgnUpdate"); // HRGN
	ADD_PARAM_NAME("RedrawWindow", 4, "flags"); // UINT
	ADD_PARAM_NAME("RegCloseKey", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegConnectRegistryA", 1, "lpMachineName"); // LPCSTR
	ADD_PARAM_NAME("RegConnectRegistryA", 2, "hKey"); // HKEY
	ADD_PARAM_NAME("RegConnectRegistryA", 3, "phkResult"); // PHKEY
	ADD_PARAM_NAME("RegConnectRegistryExA", 1, "lpMachineName"); // LPCSTR
	ADD_PARAM_NAME("RegConnectRegistryExA", 2, "hKey"); // HKEY
	ADD_PARAM_NAME("RegConnectRegistryExA", 3, "Flags"); // ULONG
	ADD_PARAM_NAME("RegConnectRegistryExA", 4, "phkResult"); // PHKEY
	ADD_PARAM_NAME("RegConnectRegistryExW", 1, "lpMachineName"); // LPCWSTR
	ADD_PARAM_NAME("RegConnectRegistryExW", 2, "hKey"); // HKEY
	ADD_PARAM_NAME("RegConnectRegistryExW", 3, "Flags"); // ULONG
	ADD_PARAM_NAME("RegConnectRegistryExW", 4, "phkResult"); // PHKEY
	ADD_PARAM_NAME("RegConnectRegistryW", 1, "lpMachineName"); // LPCWSTR
	ADD_PARAM_NAME("RegConnectRegistryW", 2, "hKey"); // HKEY
	ADD_PARAM_NAME("RegConnectRegistryW", 3, "phkResult"); // PHKEY
	ADD_PARAM_NAME("RegCopyTreeA", 1, "hKeySrc"); // HKEY
	ADD_PARAM_NAME("RegCopyTreeA", 2, "lpSubKey"); // LPCSTR
	ADD_PARAM_NAME("RegCopyTreeA", 3, "hKeyDest"); // HKEY
	ADD_PARAM_NAME("RegCopyTreeW", 1, "hKeySrc"); // HKEY
	ADD_PARAM_NAME("RegCopyTreeW", 2, "lpSubKey"); // LPCWSTR
	ADD_PARAM_NAME("RegCopyTreeW", 3, "hKeyDest"); // HKEY
	ADD_PARAM_NAME("RegCreateKeyA", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegCreateKeyA", 2, "lpSubKey"); // LPCSTR
	ADD_PARAM_NAME("RegCreateKeyA", 3, "phkResult"); // PHKEY
	ADD_PARAM_NAME("RegCreateKeyExA", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegCreateKeyExA", 2, "lpSubKey"); // LPCSTR
	ADD_PARAM_NAME("RegCreateKeyExA", 3, "Reserved"); // DWORD
	ADD_PARAM_NAME("RegCreateKeyExA", 4, "lpClass"); // LPSTR
	ADD_PARAM_NAME("RegCreateKeyExA", 5, "dwOptions"); // DWORD
	ADD_PARAM_NAME("RegCreateKeyExA", 6, "samDesired"); // REGSAM
	ADD_PARAM_NAME("RegCreateKeyExA", 7, "lpSecurityAttributes"); // LPSECURITY_ATTRIBUTES
	ADD_PARAM_NAME("RegCreateKeyExA", 8, "phkResult"); // PHKEY
	ADD_PARAM_NAME("RegCreateKeyExA", 9, "lpdwDisposition"); // LPDWORD
	ADD_PARAM_NAME("RegCreateKeyExW", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegCreateKeyExW", 2, "lpSubKey"); // LPCWSTR
	ADD_PARAM_NAME("RegCreateKeyExW", 3, "Reserved"); // DWORD
	ADD_PARAM_NAME("RegCreateKeyExW", 4, "lpClass"); // LPWSTR
	ADD_PARAM_NAME("RegCreateKeyExW", 5, "dwOptions"); // DWORD
	ADD_PARAM_NAME("RegCreateKeyExW", 6, "samDesired"); // REGSAM
	ADD_PARAM_NAME("RegCreateKeyExW", 7, "lpSecurityAttributes"); // LPSECURITY_ATTRIBUTES
	ADD_PARAM_NAME("RegCreateKeyExW", 8, "phkResult"); // PHKEY
	ADD_PARAM_NAME("RegCreateKeyExW", 9, "lpdwDisposition"); // LPDWORD
	ADD_PARAM_NAME("RegCreateKeyTransactedA", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegCreateKeyTransactedA", 2, "lpSubKey"); // LPCSTR
	ADD_PARAM_NAME("RegCreateKeyTransactedA", 3, "Reserved"); // DWORD
	ADD_PARAM_NAME("RegCreateKeyTransactedA", 4, "lpClass"); // LPSTR
	ADD_PARAM_NAME("RegCreateKeyTransactedA", 5, "dwOptions"); // DWORD
	ADD_PARAM_NAME("RegCreateKeyTransactedA", 6, "samDesired"); // REGSAM
	ADD_PARAM_NAME("RegCreateKeyTransactedA", 7, "lpSecurityAttributes"); // const LPSECURITY_ATTRIBUTES
	ADD_PARAM_NAME("RegCreateKeyTransactedA", 8, "phkResult"); // PHKEY
	ADD_PARAM_NAME("RegCreateKeyTransactedA", 9, "lpdwDisposition"); // LPDWORD
	ADD_PARAM_NAME("RegCreateKeyTransactedA", 10, "hTransaction"); // HANDLE
	ADD_PARAM_NAME("RegCreateKeyTransactedA", 11, "pExtendedParemeter"); // PVOID
	ADD_PARAM_NAME("RegCreateKeyTransactedW", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegCreateKeyTransactedW", 2, "lpSubKey"); // LPCWSTR
	ADD_PARAM_NAME("RegCreateKeyTransactedW", 3, "Reserved"); // DWORD
	ADD_PARAM_NAME("RegCreateKeyTransactedW", 4, "lpClass"); // LPWSTR
	ADD_PARAM_NAME("RegCreateKeyTransactedW", 5, "dwOptions"); // DWORD
	ADD_PARAM_NAME("RegCreateKeyTransactedW", 6, "samDesired"); // REGSAM
	ADD_PARAM_NAME("RegCreateKeyTransactedW", 7, "lpSecurityAttributes"); // const LPSECURITY_ATTRIBUTES
	ADD_PARAM_NAME("RegCreateKeyTransactedW", 8, "phkResult"); // PHKEY
	ADD_PARAM_NAME("RegCreateKeyTransactedW", 9, "lpdwDisposition"); // LPDWORD
	ADD_PARAM_NAME("RegCreateKeyTransactedW", 10, "hTransaction"); // HANDLE
	ADD_PARAM_NAME("RegCreateKeyTransactedW", 11, "pExtendedParemeter"); // PVOID
	ADD_PARAM_NAME("RegCreateKeyW", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegCreateKeyW", 2, "lpSubKey"); // LPCWSTR
	ADD_PARAM_NAME("RegCreateKeyW", 3, "phkResult"); // PHKEY
	ADD_PARAM_NAME("RegDeleteKeyA", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegDeleteKeyA", 2, "lpSubKey"); // LPCSTR
	ADD_PARAM_NAME("RegDeleteKeyExA", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegDeleteKeyExA", 2, "lpSubKey"); // LPCSTR
	ADD_PARAM_NAME("RegDeleteKeyExA", 3, "samDesired"); // REGSAM
	ADD_PARAM_NAME("RegDeleteKeyExA", 4, "Reserved"); // DWORD
	ADD_PARAM_NAME("RegDeleteKeyExW", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegDeleteKeyExW", 2, "lpSubKey"); // LPCWSTR
	ADD_PARAM_NAME("RegDeleteKeyExW", 3, "samDesired"); // REGSAM
	ADD_PARAM_NAME("RegDeleteKeyExW", 4, "Reserved"); // DWORD
	ADD_PARAM_NAME("RegDeleteKeyTransactedA", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegDeleteKeyTransactedA", 2, "lpSubKey"); // LPCSTR
	ADD_PARAM_NAME("RegDeleteKeyTransactedA", 3, "samDesired"); // REGSAM
	ADD_PARAM_NAME("RegDeleteKeyTransactedA", 4, "Reserved"); // DWORD
	ADD_PARAM_NAME("RegDeleteKeyTransactedA", 5, "hTransaction"); // HANDLE
	ADD_PARAM_NAME("RegDeleteKeyTransactedA", 6, "pExtendedParameter"); // PVOID
	ADD_PARAM_NAME("RegDeleteKeyTransactedW", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegDeleteKeyTransactedW", 2, "lpSubKey"); // LPCWSTR
	ADD_PARAM_NAME("RegDeleteKeyTransactedW", 3, "samDesired"); // REGSAM
	ADD_PARAM_NAME("RegDeleteKeyTransactedW", 4, "Reserved"); // DWORD
	ADD_PARAM_NAME("RegDeleteKeyTransactedW", 5, "hTransaction"); // HANDLE
	ADD_PARAM_NAME("RegDeleteKeyTransactedW", 6, "pExtendedParameter"); // PVOID
	ADD_PARAM_NAME("RegDeleteKeyValueA", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegDeleteKeyValueA", 2, "lpSubKey"); // LPCSTR
	ADD_PARAM_NAME("RegDeleteKeyValueA", 3, "lpValueName"); // LPCSTR
	ADD_PARAM_NAME("RegDeleteKeyValueW", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegDeleteKeyValueW", 2, "lpSubKey"); // LPCWSTR
	ADD_PARAM_NAME("RegDeleteKeyValueW", 3, "lpValueName"); // LPCWSTR
	ADD_PARAM_NAME("RegDeleteKeyW", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegDeleteKeyW", 2, "lpSubKey"); // LPCWSTR
	ADD_PARAM_NAME("RegDeleteTreeA", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegDeleteTreeA", 2, "lpSubKey"); // LPCSTR
	ADD_PARAM_NAME("RegDeleteTreeW", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegDeleteTreeW", 2, "lpSubKey"); // LPCWSTR
	ADD_PARAM_NAME("RegDeleteValueA", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegDeleteValueA", 2, "lpValueName"); // LPCSTR
	ADD_PARAM_NAME("RegDeleteValueW", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegDeleteValueW", 2, "lpValueName"); // LPCWSTR
	ADD_PARAM_NAME("RegDisableReflectionKey", 1, "hBase"); // HKEY
	ADD_PARAM_NAME("RegEnableReflectionKey", 1, "hBase"); // HKEY
	ADD_PARAM_NAME("RegEnumKeyA", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegEnumKeyA", 2, "dwIndex"); // DWORD
	ADD_PARAM_NAME("RegEnumKeyA", 3, "lpName"); // LPSTR
	ADD_PARAM_NAME("RegEnumKeyA", 4, "cchName"); // DWORD
	ADD_PARAM_NAME("RegEnumKeyExA", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegEnumKeyExA", 2, "dwIndex"); // DWORD
	ADD_PARAM_NAME("RegEnumKeyExA", 3, "lpName"); // LPSTR
	ADD_PARAM_NAME("RegEnumKeyExA", 4, "lpcchName"); // LPDWORD
	ADD_PARAM_NAME("RegEnumKeyExA", 5, "lpReserved"); // LPDWORD
	ADD_PARAM_NAME("RegEnumKeyExA", 6, "lpClass"); // LPSTR
	ADD_PARAM_NAME("RegEnumKeyExA", 7, "lpcchClass"); // LPDWORD
	ADD_PARAM_NAME("RegEnumKeyExA", 8, "lpftLastWriteTime"); // PFILETIME
	ADD_PARAM_NAME("RegEnumKeyExW", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegEnumKeyExW", 2, "dwIndex"); // DWORD
	ADD_PARAM_NAME("RegEnumKeyExW", 3, "lpName"); // LPWSTR
	ADD_PARAM_NAME("RegEnumKeyExW", 4, "lpcchName"); // LPDWORD
	ADD_PARAM_NAME("RegEnumKeyExW", 5, "lpReserved"); // LPDWORD
	ADD_PARAM_NAME("RegEnumKeyExW", 6, "lpClass"); // LPWSTR
	ADD_PARAM_NAME("RegEnumKeyExW", 7, "lpcchClass"); // LPDWORD
	ADD_PARAM_NAME("RegEnumKeyExW", 8, "lpftLastWriteTime"); // PFILETIME
	ADD_PARAM_NAME("RegEnumKeyW", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegEnumKeyW", 2, "dwIndex"); // DWORD
	ADD_PARAM_NAME("RegEnumKeyW", 3, "lpName"); // LPWSTR
	ADD_PARAM_NAME("RegEnumKeyW", 4, "cchName"); // DWORD
	ADD_PARAM_NAME("RegEnumValueA", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegEnumValueA", 2, "dwIndex"); // DWORD
	ADD_PARAM_NAME("RegEnumValueA", 3, "lpValueName"); // LPSTR
	ADD_PARAM_NAME("RegEnumValueA", 4, "lpcchValueName"); // LPDWORD
	ADD_PARAM_NAME("RegEnumValueA", 5, "lpReserved"); // LPDWORD
	ADD_PARAM_NAME("RegEnumValueA", 6, "lpType"); // LPDWORD
	ADD_PARAM_NAME("RegEnumValueA", 7, "lpData"); // LPBYTE
	ADD_PARAM_NAME("RegEnumValueA", 8, "lpcbData"); // LPDWORD
	ADD_PARAM_NAME("RegEnumValueW", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegEnumValueW", 2, "dwIndex"); // DWORD
	ADD_PARAM_NAME("RegEnumValueW", 3, "lpValueName"); // LPWSTR
	ADD_PARAM_NAME("RegEnumValueW", 4, "lpcchValueName"); // LPDWORD
	ADD_PARAM_NAME("RegEnumValueW", 5, "lpReserved"); // LPDWORD
	ADD_PARAM_NAME("RegEnumValueW", 6, "lpType"); // LPDWORD
	ADD_PARAM_NAME("RegEnumValueW", 7, "lpData"); // LPBYTE
	ADD_PARAM_NAME("RegEnumValueW", 8, "lpcbData"); // LPDWORD
	ADD_PARAM_NAME("RegFlushKey", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegGetKeySecurity", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegGetKeySecurity", 2, "SecurityInformation"); // SECURITY_INFORMATION
	ADD_PARAM_NAME("RegGetKeySecurity", 3, "pSecurityDescriptor"); // PSECURITY_DESCRIPTOR
	ADD_PARAM_NAME("RegGetKeySecurity", 4, "lpcbSecurityDescriptor"); // LPDWORD
	ADD_PARAM_NAME("RegGetValueA", 1, "hkey"); // HKEY
	ADD_PARAM_NAME("RegGetValueA", 2, "lpSubKey"); // LPCSTR
	ADD_PARAM_NAME("RegGetValueA", 3, "lpValue"); // LPCSTR
	ADD_PARAM_NAME("RegGetValueA", 4, "dwFlags"); // DWORD
	ADD_PARAM_NAME("RegGetValueA", 5, "pdwType"); // LPDWORD
	ADD_PARAM_NAME("RegGetValueA", 6, "pvData"); // PVOID
	ADD_PARAM_NAME("RegGetValueA", 7, "pcbData"); // LPDWORD
	ADD_PARAM_NAME("RegGetValueW", 1, "hkey"); // HKEY
	ADD_PARAM_NAME("RegGetValueW", 2, "lpSubKey"); // LPCWSTR
	ADD_PARAM_NAME("RegGetValueW", 3, "lpValue"); // LPCWSTR
	ADD_PARAM_NAME("RegGetValueW", 4, "dwFlags"); // DWORD
	ADD_PARAM_NAME("RegGetValueW", 5, "pdwType"); // LPDWORD
	ADD_PARAM_NAME("RegGetValueW", 6, "pvData"); // PVOID
	ADD_PARAM_NAME("RegGetValueW", 7, "pcbData"); // LPDWORD
	ADD_PARAM_NAME("RegLoadAppKeyA", 1, "lpFile"); // LPCSTR
	ADD_PARAM_NAME("RegLoadAppKeyA", 2, "phkResult"); // PHKEY
	ADD_PARAM_NAME("RegLoadAppKeyA", 3, "samDesired"); // REGSAM
	ADD_PARAM_NAME("RegLoadAppKeyA", 4, "dwOptions"); // DWORD
	ADD_PARAM_NAME("RegLoadAppKeyA", 5, "Reserved"); // DWORD
	ADD_PARAM_NAME("RegLoadAppKeyW", 1, "lpFile"); // LPCWSTR
	ADD_PARAM_NAME("RegLoadAppKeyW", 2, "phkResult"); // PHKEY
	ADD_PARAM_NAME("RegLoadAppKeyW", 3, "samDesired"); // REGSAM
	ADD_PARAM_NAME("RegLoadAppKeyW", 4, "dwOptions"); // DWORD
	ADD_PARAM_NAME("RegLoadAppKeyW", 5, "Reserved"); // DWORD
	ADD_PARAM_NAME("RegLoadKeyA", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegLoadKeyA", 2, "lpSubKey"); // LPCSTR
	ADD_PARAM_NAME("RegLoadKeyA", 3, "lpFile"); // LPCSTR
	ADD_PARAM_NAME("RegLoadKeyW", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegLoadKeyW", 2, "lpSubKey"); // LPCWSTR
	ADD_PARAM_NAME("RegLoadKeyW", 3, "lpFile"); // LPCWSTR
	ADD_PARAM_NAME("RegLoadMUIStringA", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegLoadMUIStringA", 2, "pszValue"); // LPCSTR
	ADD_PARAM_NAME("RegLoadMUIStringA", 3, "pszOutBuf"); // LPSTR
	ADD_PARAM_NAME("RegLoadMUIStringA", 4, "cbOutBuf"); // DWORD
	ADD_PARAM_NAME("RegLoadMUIStringA", 5, "pcbData"); // LPDWORD
	ADD_PARAM_NAME("RegLoadMUIStringA", 6, "Flags"); // DWORD
	ADD_PARAM_NAME("RegLoadMUIStringA", 7, "pszDirectory"); // LPCSTR
	ADD_PARAM_NAME("RegLoadMUIStringW", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegLoadMUIStringW", 2, "pszValue"); // LPCWSTR
	ADD_PARAM_NAME("RegLoadMUIStringW", 3, "pszOutBuf"); // LPWSTR
	ADD_PARAM_NAME("RegLoadMUIStringW", 4, "cbOutBuf"); // DWORD
	ADD_PARAM_NAME("RegLoadMUIStringW", 5, "pcbData"); // LPDWORD
	ADD_PARAM_NAME("RegLoadMUIStringW", 6, "Flags"); // DWORD
	ADD_PARAM_NAME("RegLoadMUIStringW", 7, "pszDirectory"); // LPCWSTR
	ADD_PARAM_NAME("RegNotifyChangeKeyValue", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegNotifyChangeKeyValue", 2, "bWatchSubtree"); // WINBOOL
	ADD_PARAM_NAME("RegNotifyChangeKeyValue", 3, "dwNotifyFilter"); // DWORD
	ADD_PARAM_NAME("RegNotifyChangeKeyValue", 4, "hEvent"); // HANDLE
	ADD_PARAM_NAME("RegNotifyChangeKeyValue", 5, "fAsynchronous"); // WINBOOL
	ADD_PARAM_NAME("RegOpenCurrentUser", 1, "samDesired"); // REGSAM
	ADD_PARAM_NAME("RegOpenCurrentUser", 2, "phkResult"); // PHKEY
	ADD_PARAM_NAME("RegOpenKeyA", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegOpenKeyA", 2, "lpSubKey"); // LPCSTR
	ADD_PARAM_NAME("RegOpenKeyA", 3, "phkResult"); // PHKEY
	ADD_PARAM_NAME("RegOpenKeyExA", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegOpenKeyExA", 2, "lpSubKey"); // LPCSTR
	ADD_PARAM_NAME("RegOpenKeyExA", 3, "ulOptions"); // DWORD
	ADD_PARAM_NAME("RegOpenKeyExA", 4, "samDesired"); // REGSAM
	ADD_PARAM_NAME("RegOpenKeyExA", 5, "phkResult"); // PHKEY
	ADD_PARAM_NAME("RegOpenKeyExW", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegOpenKeyExW", 2, "lpSubKey"); // LPCWSTR
	ADD_PARAM_NAME("RegOpenKeyExW", 3, "ulOptions"); // DWORD
	ADD_PARAM_NAME("RegOpenKeyExW", 4, "samDesired"); // REGSAM
	ADD_PARAM_NAME("RegOpenKeyExW", 5, "phkResult"); // PHKEY
	ADD_PARAM_NAME("RegOpenKeyTransactedA", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegOpenKeyTransactedA", 2, "lpSubKey"); // LPCSTR
	ADD_PARAM_NAME("RegOpenKeyTransactedA", 3, "ulOptions"); // DWORD
	ADD_PARAM_NAME("RegOpenKeyTransactedA", 4, "samDesired"); // REGSAM
	ADD_PARAM_NAME("RegOpenKeyTransactedA", 5, "phkResult"); // PHKEY
	ADD_PARAM_NAME("RegOpenKeyTransactedA", 6, "hTransaction"); // HANDLE
	ADD_PARAM_NAME("RegOpenKeyTransactedA", 7, "pExtendedParameter"); // PVOID
	ADD_PARAM_NAME("RegOpenKeyTransactedW", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegOpenKeyTransactedW", 2, "lpSubKey"); // LPCWSTR
	ADD_PARAM_NAME("RegOpenKeyTransactedW", 3, "ulOptions"); // DWORD
	ADD_PARAM_NAME("RegOpenKeyTransactedW", 4, "samDesired"); // REGSAM
	ADD_PARAM_NAME("RegOpenKeyTransactedW", 5, "phkResult"); // PHKEY
	ADD_PARAM_NAME("RegOpenKeyTransactedW", 6, "hTransaction"); // HANDLE
	ADD_PARAM_NAME("RegOpenKeyTransactedW", 7, "pExtendedParameter"); // PVOID
	ADD_PARAM_NAME("RegOpenKeyW", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegOpenKeyW", 2, "lpSubKey"); // LPCWSTR
	ADD_PARAM_NAME("RegOpenKeyW", 3, "phkResult"); // PHKEY
	ADD_PARAM_NAME("RegOpenUserClassesRoot", 1, "hToken"); // HANDLE
	ADD_PARAM_NAME("RegOpenUserClassesRoot", 2, "dwOptions"); // DWORD
	ADD_PARAM_NAME("RegOpenUserClassesRoot", 3, "samDesired"); // REGSAM
	ADD_PARAM_NAME("RegOpenUserClassesRoot", 4, "phkResult"); // PHKEY
	ADD_PARAM_NAME("RegOverridePredefKey", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegOverridePredefKey", 2, "hNewHKey"); // HKEY
	ADD_PARAM_NAME("RegQueryInfoKeyA", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegQueryInfoKeyA", 2, "lpClass"); // LPSTR
	ADD_PARAM_NAME("RegQueryInfoKeyA", 3, "lpcchClass"); // LPDWORD
	ADD_PARAM_NAME("RegQueryInfoKeyA", 4, "lpReserved"); // LPDWORD
	ADD_PARAM_NAME("RegQueryInfoKeyA", 5, "lpcSubKeys"); // LPDWORD
	ADD_PARAM_NAME("RegQueryInfoKeyA", 6, "lpcbMaxSubKeyLen"); // LPDWORD
	ADD_PARAM_NAME("RegQueryInfoKeyA", 7, "lpcbMaxClassLen"); // LPDWORD
	ADD_PARAM_NAME("RegQueryInfoKeyA", 8, "lpcValues"); // LPDWORD
	ADD_PARAM_NAME("RegQueryInfoKeyA", 9, "lpcbMaxValueNameLen"); // LPDWORD
	ADD_PARAM_NAME("RegQueryInfoKeyA", 10, "lpcbMaxValueLen"); // LPDWORD
	ADD_PARAM_NAME("RegQueryInfoKeyA", 11, "lpcbSecurityDescriptor"); // LPDWORD
	ADD_PARAM_NAME("RegQueryInfoKeyA", 12, "lpftLastWriteTime"); // PFILETIME
	ADD_PARAM_NAME("RegQueryInfoKeyW", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegQueryInfoKeyW", 2, "lpClass"); // LPWSTR
	ADD_PARAM_NAME("RegQueryInfoKeyW", 3, "lpcchClass"); // LPDWORD
	ADD_PARAM_NAME("RegQueryInfoKeyW", 4, "lpReserved"); // LPDWORD
	ADD_PARAM_NAME("RegQueryInfoKeyW", 5, "lpcSubKeys"); // LPDWORD
	ADD_PARAM_NAME("RegQueryInfoKeyW", 6, "lpcbMaxSubKeyLen"); // LPDWORD
	ADD_PARAM_NAME("RegQueryInfoKeyW", 7, "lpcbMaxClassLen"); // LPDWORD
	ADD_PARAM_NAME("RegQueryInfoKeyW", 8, "lpcValues"); // LPDWORD
	ADD_PARAM_NAME("RegQueryInfoKeyW", 9, "lpcbMaxValueNameLen"); // LPDWORD
	ADD_PARAM_NAME("RegQueryInfoKeyW", 10, "lpcbMaxValueLen"); // LPDWORD
	ADD_PARAM_NAME("RegQueryInfoKeyW", 11, "lpcbSecurityDescriptor"); // LPDWORD
	ADD_PARAM_NAME("RegQueryInfoKeyW", 12, "lpftLastWriteTime"); // PFILETIME
	ADD_PARAM_NAME("RegQueryMultipleValuesA", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegQueryMultipleValuesA", 2, "val_list"); // PVALENTA
	ADD_PARAM_NAME("RegQueryMultipleValuesA", 3, "num_vals"); // DWORD
	ADD_PARAM_NAME("RegQueryMultipleValuesA", 4, "lpValueBuf"); // LPSTR
	ADD_PARAM_NAME("RegQueryMultipleValuesA", 5, "ldwTotsize"); // LPDWORD
	ADD_PARAM_NAME("RegQueryMultipleValuesW", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegQueryMultipleValuesW", 2, "val_list"); // PVALENTW
	ADD_PARAM_NAME("RegQueryMultipleValuesW", 3, "num_vals"); // DWORD
	ADD_PARAM_NAME("RegQueryMultipleValuesW", 4, "lpValueBuf"); // LPWSTR
	ADD_PARAM_NAME("RegQueryMultipleValuesW", 5, "ldwTotsize"); // LPDWORD
	ADD_PARAM_NAME("RegQueryReflectionKey", 1, "hBase"); // HKEY
	ADD_PARAM_NAME("RegQueryReflectionKey", 2, "bIsReflectionDisabled"); // WINBOOL *
	ADD_PARAM_NAME("RegQueryValueA", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegQueryValueA", 2, "lpSubKey"); // LPCSTR
	ADD_PARAM_NAME("RegQueryValueA", 3, "lpData"); // LPSTR
	ADD_PARAM_NAME("RegQueryValueA", 4, "lpcbData"); // PLONG
	ADD_PARAM_NAME("RegQueryValueExA", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegQueryValueExA", 2, "lpValueName"); // LPCSTR
	ADD_PARAM_NAME("RegQueryValueExA", 3, "lpReserved"); // LPDWORD
	ADD_PARAM_NAME("RegQueryValueExA", 4, "lpType"); // LPDWORD
	ADD_PARAM_NAME("RegQueryValueExA", 5, "lpData"); // LPBYTE
	ADD_PARAM_NAME("RegQueryValueExA", 6, "lpcbData"); // LPDWORD
	ADD_PARAM_NAME("RegQueryValueExW", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegQueryValueExW", 2, "lpValueName"); // LPCWSTR
	ADD_PARAM_NAME("RegQueryValueExW", 3, "lpReserved"); // LPDWORD
	ADD_PARAM_NAME("RegQueryValueExW", 4, "lpType"); // LPDWORD
	ADD_PARAM_NAME("RegQueryValueExW", 5, "lpData"); // LPBYTE
	ADD_PARAM_NAME("RegQueryValueExW", 6, "lpcbData"); // LPDWORD
	ADD_PARAM_NAME("RegQueryValueW", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegQueryValueW", 2, "lpSubKey"); // LPCWSTR
	ADD_PARAM_NAME("RegQueryValueW", 3, "lpData"); // LPWSTR
	ADD_PARAM_NAME("RegQueryValueW", 4, "lpcbData"); // PLONG
	ADD_PARAM_NAME("RegReplaceKeyA", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegReplaceKeyA", 2, "lpSubKey"); // LPCSTR
	ADD_PARAM_NAME("RegReplaceKeyA", 3, "lpNewFile"); // LPCSTR
	ADD_PARAM_NAME("RegReplaceKeyA", 4, "lpOldFile"); // LPCSTR
	ADD_PARAM_NAME("RegReplaceKeyW", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegReplaceKeyW", 2, "lpSubKey"); // LPCWSTR
	ADD_PARAM_NAME("RegReplaceKeyW", 3, "lpNewFile"); // LPCWSTR
	ADD_PARAM_NAME("RegReplaceKeyW", 4, "lpOldFile"); // LPCWSTR
	ADD_PARAM_NAME("RegRestoreKeyA", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegRestoreKeyA", 2, "lpFile"); // LPCSTR
	ADD_PARAM_NAME("RegRestoreKeyA", 3, "dwFlags"); // DWORD
	ADD_PARAM_NAME("RegRestoreKeyW", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegRestoreKeyW", 2, "lpFile"); // LPCWSTR
	ADD_PARAM_NAME("RegRestoreKeyW", 3, "dwFlags"); // DWORD
	ADD_PARAM_NAME("RegSaveKeyA", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegSaveKeyA", 2, "lpFile"); // LPCSTR
	ADD_PARAM_NAME("RegSaveKeyA", 3, "lpSecurityAttributes"); // LPSECURITY_ATTRIBUTES
	ADD_PARAM_NAME("RegSaveKeyExA", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegSaveKeyExA", 2, "lpFile"); // LPCSTR
	ADD_PARAM_NAME("RegSaveKeyExA", 3, "lpSecurityAttributes"); // LPSECURITY_ATTRIBUTES
	ADD_PARAM_NAME("RegSaveKeyExA", 4, "Flags"); // DWORD
	ADD_PARAM_NAME("RegSaveKeyExW", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegSaveKeyExW", 2, "lpFile"); // LPCWSTR
	ADD_PARAM_NAME("RegSaveKeyExW", 3, "lpSecurityAttributes"); // LPSECURITY_ATTRIBUTES
	ADD_PARAM_NAME("RegSaveKeyExW", 4, "Flags"); // DWORD
	ADD_PARAM_NAME("RegSaveKeyW", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegSaveKeyW", 2, "lpFile"); // LPCWSTR
	ADD_PARAM_NAME("RegSaveKeyW", 3, "lpSecurityAttributes"); // LPSECURITY_ATTRIBUTES
	ADD_PARAM_NAME("RegSetKeySecurity", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegSetKeySecurity", 2, "SecurityInformation"); // SECURITY_INFORMATION
	ADD_PARAM_NAME("RegSetKeySecurity", 3, "pSecurityDescriptor"); // PSECURITY_DESCRIPTOR
	ADD_PARAM_NAME("RegSetKeyValueA", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegSetKeyValueA", 2, "lpSubKey"); // LPCSTR
	ADD_PARAM_NAME("RegSetKeyValueA", 3, "lpValueName"); // LPCSTR
	ADD_PARAM_NAME("RegSetKeyValueA", 4, "dwType"); // DWORD
	ADD_PARAM_NAME("RegSetKeyValueA", 5, "lpData"); // LPCVOID
	ADD_PARAM_NAME("RegSetKeyValueA", 6, "cbData"); // DWORD
	ADD_PARAM_NAME("RegSetKeyValueW", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegSetKeyValueW", 2, "lpSubKey"); // LPCSTR
	ADD_PARAM_NAME("RegSetKeyValueW", 3, "lpValueName"); // LPCSTR
	ADD_PARAM_NAME("RegSetKeyValueW", 4, "dwType"); // DWORD
	ADD_PARAM_NAME("RegSetKeyValueW", 5, "lpData"); // LPCVOID
	ADD_PARAM_NAME("RegSetKeyValueW", 6, "cbData"); // DWORD
	ADD_PARAM_NAME("RegSetValueA", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegSetValueA", 2, "lpSubKey"); // LPCSTR
	ADD_PARAM_NAME("RegSetValueA", 3, "dwType"); // DWORD
	ADD_PARAM_NAME("RegSetValueA", 4, "lpData"); // LPCSTR
	ADD_PARAM_NAME("RegSetValueA", 5, "cbData"); // DWORD
	ADD_PARAM_NAME("RegSetValueExA", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegSetValueExA", 2, "lpValueName"); // LPCSTR
	ADD_PARAM_NAME("RegSetValueExA", 3, "Reserved"); // DWORD
	ADD_PARAM_NAME("RegSetValueExA", 4, "dwType"); // DWORD
	ADD_PARAM_NAME("RegSetValueExA", 5, "lpData"); // CONST BYTE *
	ADD_PARAM_NAME("RegSetValueExA", 6, "cbData"); // DWORD
	ADD_PARAM_NAME("RegSetValueExW", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegSetValueExW", 2, "lpValueName"); // LPCWSTR
	ADD_PARAM_NAME("RegSetValueExW", 3, "Reserved"); // DWORD
	ADD_PARAM_NAME("RegSetValueExW", 4, "dwType"); // DWORD
	ADD_PARAM_NAME("RegSetValueExW", 5, "lpData"); // CONST BYTE *
	ADD_PARAM_NAME("RegSetValueExW", 6, "cbData"); // DWORD
	ADD_PARAM_NAME("RegSetValueW", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegSetValueW", 2, "lpSubKey"); // LPCWSTR
	ADD_PARAM_NAME("RegSetValueW", 3, "dwType"); // DWORD
	ADD_PARAM_NAME("RegSetValueW", 4, "lpData"); // LPCWSTR
	ADD_PARAM_NAME("RegSetValueW", 5, "cbData"); // DWORD
	ADD_PARAM_NAME("RegUnLoadKeyA", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegUnLoadKeyA", 2, "lpSubKey"); // LPCSTR
	ADD_PARAM_NAME("RegUnLoadKeyW", 1, "hKey"); // HKEY
	ADD_PARAM_NAME("RegUnLoadKeyW", 2, "lpSubKey"); // LPCWSTR
	ADD_PARAM_NAME("RegisterApplicationRecoveryCallback", 1, "pRecoveryCallback"); // APPLICATION_RECOVERY_CALLBACK
	ADD_PARAM_NAME("RegisterApplicationRecoveryCallback", 2, "pvParameter"); // PVOID
	ADD_PARAM_NAME("RegisterApplicationRecoveryCallback", 3, "dwPingInterval"); // DWORD
	ADD_PARAM_NAME("RegisterApplicationRecoveryCallback", 4, "dwFlags"); // DWORD
	ADD_PARAM_NAME("RegisterApplicationRestart", 1, "pwzCommandline"); // PCWSTR
	ADD_PARAM_NAME("RegisterApplicationRestart", 2, "dwFlags"); // DWORD
	ADD_PARAM_NAME("RegisterClassA", 1, "lpWndClass"); // CONST WNDCLASSA *
	ADD_PARAM_NAME("RegisterClassExA", 1, "lpwcx"); // CONST WNDCLASSEX *
	ADD_PARAM_NAME("RegisterClassExW", 1, "lpwcx"); // CONST WNDCLASSEX *
	ADD_PARAM_NAME("RegisterClassW", 1, "lpWndClass"); // CONST WNDCLASSW *
	ADD_PARAM_NAME("RegisterClipboardFormatA", 1, "lpszFormat"); // LPCSTR
	ADD_PARAM_NAME("RegisterClipboardFormatW", 1, "lpszFormat"); // LPCWSTR
	ADD_PARAM_NAME("RegisterDeviceNotificationA", 1, "hRecipient"); // HANDLE
	ADD_PARAM_NAME("RegisterDeviceNotificationA", 2, "NotificationFilter"); // LPVOID
	ADD_PARAM_NAME("RegisterDeviceNotificationA", 3, "Flags"); // DWORD
	ADD_PARAM_NAME("RegisterDeviceNotificationW", 1, "hRecipient"); // HANDLE
	ADD_PARAM_NAME("RegisterDeviceNotificationW", 2, "NotificationFilter"); // LPVOID
	ADD_PARAM_NAME("RegisterDeviceNotificationW", 3, "Flags"); // DWORD
	ADD_PARAM_NAME("RegisterEventSourceA", 1, "lpUNCServerName"); // LPCSTR
	ADD_PARAM_NAME("RegisterEventSourceA", 2, "lpSourceName"); // LPCSTR
	ADD_PARAM_NAME("RegisterEventSourceW", 1, "lpUNCServerName"); // LPCWSTR
	ADD_PARAM_NAME("RegisterEventSourceW", 2, "lpSourceName"); // LPCWSTR
	ADD_PARAM_NAME("RegisterHotKey", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("RegisterHotKey", 2, "id"); // int
	ADD_PARAM_NAME("RegisterHotKey", 3, "fsModifiers"); // UINT
	ADD_PARAM_NAME("RegisterHotKey", 4, "vk"); // UINT
	ADD_PARAM_NAME("RegisterPowerSettingNotification", 1, "hRecipient"); // HANDLE
	ADD_PARAM_NAME("RegisterPowerSettingNotification", 2, "PowerSettingGuid"); // LPCGUID
	ADD_PARAM_NAME("RegisterPowerSettingNotification", 3, "Flags"); // DWORD
	ADD_PARAM_NAME("RegisterRawInputDevices", 1, "pRawInputDevices"); // PCRAWINPUTDEVICE
	ADD_PARAM_NAME("RegisterRawInputDevices", 2, "uiNumDevices"); // UINT
	ADD_PARAM_NAME("RegisterRawInputDevices", 3, "cbSize"); // UINT
	ADD_PARAM_NAME("RegisterServiceCtrlHandlerA", 1, "lpServiceName"); // LPCSTR
	ADD_PARAM_NAME("RegisterServiceCtrlHandlerA", 2, "lpHandlerProc"); // LPHANDLER_FUNCTION
	ADD_PARAM_NAME("RegisterServiceCtrlHandlerExA", 1, "lpServiceName"); // LPCSTR
	ADD_PARAM_NAME("RegisterServiceCtrlHandlerExA", 2, "lpHandlerProc"); // LPHANDLER_FUNCTION_EX
	ADD_PARAM_NAME("RegisterServiceCtrlHandlerExA", 3, "lpContext"); // LPVOID
	ADD_PARAM_NAME("RegisterServiceCtrlHandlerExW", 1, "lpServiceName"); // LPCWSTR
	ADD_PARAM_NAME("RegisterServiceCtrlHandlerExW", 2, "lpHandlerProc"); // LPHANDLER_FUNCTION_EX
	ADD_PARAM_NAME("RegisterServiceCtrlHandlerExW", 3, "lpContext"); // LPVOID
	ADD_PARAM_NAME("RegisterServiceCtrlHandlerW", 1, "lpServiceName"); // LPCWSTR
	ADD_PARAM_NAME("RegisterServiceCtrlHandlerW", 2, "lpHandlerProc"); // LPHANDLER_FUNCTION
	ADD_PARAM_NAME("RegisterShellHookWindow", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("RegisterTouchWindow", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("RegisterTouchWindow", 2, "ulFlags"); // ULONG
	ADD_PARAM_NAME("RegisterWaitForSingleObject", 1, "phNewWaitObject"); // PHANDLE
	ADD_PARAM_NAME("RegisterWaitForSingleObject", 2, "hObject"); // HANDLE
	ADD_PARAM_NAME("RegisterWaitForSingleObject", 3, "Callback"); // WAITORTIMERCALLBACK
	ADD_PARAM_NAME("RegisterWaitForSingleObject", 4, "Context"); // PVOID
	ADD_PARAM_NAME("RegisterWaitForSingleObject", 5, "dwMilliseconds"); // ULONG
	ADD_PARAM_NAME("RegisterWaitForSingleObject", 6, "dwFlags"); // ULONG
	ADD_PARAM_NAME("RegisterWaitForSingleObjectEx", 1, "hObject"); // HANDLE
	ADD_PARAM_NAME("RegisterWaitForSingleObjectEx", 2, "Callback"); // WAITORTIMERCALLBACK
	ADD_PARAM_NAME("RegisterWaitForSingleObjectEx", 3, "Context"); // PVOID
	ADD_PARAM_NAME("RegisterWaitForSingleObjectEx", 4, "dwMilliseconds"); // ULONG
	ADD_PARAM_NAME("RegisterWaitForSingleObjectEx", 5, "dwFlags"); // ULONG
	ADD_PARAM_NAME("RegisterWindowMessageA", 1, "lpString"); // LPCSTR
	ADD_PARAM_NAME("RegisterWindowMessageW", 1, "lpString"); // LPCWSTR
	ADD_PARAM_NAME("ReleaseActCtx", 1, "hActCtx"); // HANDLE
	ADD_PARAM_NAME("ReleaseDC", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("ReleaseDC", 2, "hDC"); // HDC
	ADD_PARAM_NAME("ReleaseMutex", 1, "hMutex"); // HANDLE
	ADD_PARAM_NAME("ReleaseMutexWhenCallbackReturns", 1, "pci"); // PTP_CALLBACK_INSTANCE
	ADD_PARAM_NAME("ReleaseMutexWhenCallbackReturns", 2, "mut"); // HANDLE
	ADD_PARAM_NAME("ReleaseSRWLockExclusive", 1, "SRWLock"); // PSRWLOCK
	ADD_PARAM_NAME("ReleaseSRWLockShared", 1, "SRWLock"); // PSRWLOCK
	ADD_PARAM_NAME("ReleaseSemaphore", 1, "hSemaphore"); // HANDLE
	ADD_PARAM_NAME("ReleaseSemaphore", 2, "lReleaseCount"); // LONG
	ADD_PARAM_NAME("ReleaseSemaphore", 3, "lpPreviousCount"); // LPLONG
	ADD_PARAM_NAME("RemoveDirectoryA", 1, "lpPathName"); // LPCSTR
	ADD_PARAM_NAME("RemoveDirectoryTransactedA", 1, "lpPathName"); // LPCSTR
	ADD_PARAM_NAME("RemoveDirectoryTransactedA", 2, "hTransaction"); // HANDLE
	ADD_PARAM_NAME("RemoveDirectoryTransactedW", 1, "lpPathName"); // LPCWSTR
	ADD_PARAM_NAME("RemoveDirectoryTransactedW", 2, "hTransaction"); // HANDLE
	ADD_PARAM_NAME("RemoveDirectoryW", 1, "lpPathName"); // LPCWSTR
	ADD_PARAM_NAME("RemoveFontMemResourceEx", 1, "h"); // HANDLE
	ADD_PARAM_NAME("RemoveFontResourceA", 1, "lpFileName"); // LPCSTR
	ADD_PARAM_NAME("RemoveFontResourceExA", 1, "name"); // LPCSTR
	ADD_PARAM_NAME("RemoveFontResourceExA", 2, "fl"); // DWORD
	ADD_PARAM_NAME("RemoveFontResourceExA", 3, "pdv"); // PVOID
	ADD_PARAM_NAME("RemoveFontResourceExW", 1, "name"); // LPCWSTR
	ADD_PARAM_NAME("RemoveFontResourceExW", 2, "fl"); // DWORD
	ADD_PARAM_NAME("RemoveFontResourceExW", 3, "pdv"); // PVOID
	ADD_PARAM_NAME("RemoveFontResourceW", 1, "lpFileName"); // LPCWSTR
	ADD_PARAM_NAME("RemoveMenu", 1, "hMenu"); // HMENU
	ADD_PARAM_NAME("RemoveMenu", 2, "uPosition"); // UINT
	ADD_PARAM_NAME("RemoveMenu", 3, "uFlags"); // UINT
	ADD_PARAM_NAME("RemovePropA", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("RemovePropA", 2, "lpString"); // LPCSTR
	ADD_PARAM_NAME("RemovePropW", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("RemovePropW", 2, "lpString"); // LPCWSTR
	ADD_PARAM_NAME("RemoveSecureMemoryCacheCallback", 1, "pfnCallBack"); // PSECURE_MEMORY_CACHE_CALLBACK
	ADD_PARAM_NAME("RemoveUsersFromEncryptedFile", 1, "lpFileName"); // LPCWSTR
	ADD_PARAM_NAME("RemoveUsersFromEncryptedFile", 2, "pHashes"); // PENCRYPTION_CERTIFICATE_HASH_LIST
	ADD_PARAM_NAME("RemoveVectoredContinueHandler", 1, "Handle"); // PVOID
	ADD_PARAM_NAME("RemoveVectoredExceptionHandler", 1, "Handle"); // PVOID
	ADD_PARAM_NAME("ReplaceFileA", 1, "lpReplacedFileName"); // LPCSTR
	ADD_PARAM_NAME("ReplaceFileA", 2, "lpReplacementFileName"); // LPCSTR
	ADD_PARAM_NAME("ReplaceFileA", 3, "lpBackupFileName"); // LPCSTR
	ADD_PARAM_NAME("ReplaceFileA", 4, "dwReplaceFlags"); // DWORD
	ADD_PARAM_NAME("ReplaceFileA", 5, "lpExclude"); // LPVOID
	ADD_PARAM_NAME("ReplaceFileA", 6, "lpReserved"); // LPVOID
	ADD_PARAM_NAME("ReplaceFileW", 1, "lpReplacedFileName"); // LPCWSTR
	ADD_PARAM_NAME("ReplaceFileW", 2, "lpReplacementFileName"); // LPCWSTR
	ADD_PARAM_NAME("ReplaceFileW", 3, "lpBackupFileName"); // LPCWSTR
	ADD_PARAM_NAME("ReplaceFileW", 4, "dwReplaceFlags"); // DWORD
	ADD_PARAM_NAME("ReplaceFileW", 5, "lpExclude"); // LPVOID
	ADD_PARAM_NAME("ReplaceFileW", 6, "lpReserved"); // LPVOID
	ADD_PARAM_NAME("ReplyMessage", 1, "lResult"); // LRESULT
	ADD_PARAM_NAME("ReplyPrinterChangeNotification", 1, "hNotify"); // HANDLE
	ADD_PARAM_NAME("ReplyPrinterChangeNotification", 2, "fdwFlags"); // DWORD
	ADD_PARAM_NAME("ReplyPrinterChangeNotification", 3, "pdwResult"); // PDWORD
	ADD_PARAM_NAME("ReplyPrinterChangeNotification", 4, "pPrinterNotifyInfo"); // PVOID
	ADD_PARAM_NAME("ReplyPrinterChangeNotificationEx", 1, "hNotify"); // HANDLE
	ADD_PARAM_NAME("ReplyPrinterChangeNotificationEx", 2, "dwColor"); // DWORD
	ADD_PARAM_NAME("ReplyPrinterChangeNotificationEx", 3, "fdwFlags"); // DWORD
	ADD_PARAM_NAME("ReplyPrinterChangeNotificationEx", 4, "pdwResult"); // PDWORD
	ADD_PARAM_NAME("ReplyPrinterChangeNotificationEx", 5, "pPrinterNotifyInfo"); // PVOID
	ADD_PARAM_NAME("ReportEventA", 1, "hEventLog"); // HANDLE
	ADD_PARAM_NAME("ReportEventA", 2, "wType"); // WORD
	ADD_PARAM_NAME("ReportEventA", 3, "wCategory"); // WORD
	ADD_PARAM_NAME("ReportEventA", 4, "dwEventID"); // DWORD
	ADD_PARAM_NAME("ReportEventA", 5, "lpUserSid"); // PSID
	ADD_PARAM_NAME("ReportEventA", 6, "wNumStrings"); // WORD
	ADD_PARAM_NAME("ReportEventA", 7, "dwDataSize"); // DWORD
	ADD_PARAM_NAME("ReportEventA", 8, "lpStrings"); // LPCSTR *
	ADD_PARAM_NAME("ReportEventA", 9, "lpRawData"); // LPVOID
	ADD_PARAM_NAME("ReportEventW", 1, "hEventLog"); // HANDLE
	ADD_PARAM_NAME("ReportEventW", 2, "wType"); // WORD
	ADD_PARAM_NAME("ReportEventW", 3, "wCategory"); // WORD
	ADD_PARAM_NAME("ReportEventW", 4, "dwEventID"); // DWORD
	ADD_PARAM_NAME("ReportEventW", 5, "lpUserSid"); // PSID
	ADD_PARAM_NAME("ReportEventW", 6, "wNumStrings"); // WORD
	ADD_PARAM_NAME("ReportEventW", 7, "dwDataSize"); // DWORD
	ADD_PARAM_NAME("ReportEventW", 8, "lpStrings"); // LPCWSTR *
	ADD_PARAM_NAME("ReportEventW", 9, "lpRawData"); // LPVOID
	ADD_PARAM_NAME("RequestDeviceWakeup", 1, "hDevice"); // HANDLE
	ADD_PARAM_NAME("RequestWakeupLatency", 1, "latency"); // LATENCY_TIME
	ADD_PARAM_NAME("ResetDCA", 1, "hdc"); // HDC
	ADD_PARAM_NAME("ResetDCA", 2, "lpdm"); // CONST DEVMODEA *
	ADD_PARAM_NAME("ResetDCW", 1, "hdc"); // HDC
	ADD_PARAM_NAME("ResetDCW", 2, "lpdm"); // CONST DEVMODEW *
	ADD_PARAM_NAME("ResetEvent", 1, "hEvent"); // HANDLE
	ADD_PARAM_NAME("ResetPrinterA", 1, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("ResetPrinterA", 2, "pDefault"); // LPPRINTER_DEFAULTSA
	ADD_PARAM_NAME("ResetPrinterW", 1, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("ResetPrinterW", 2, "pDefault"); // LPPRINTER_DEFAULTSW
	ADD_PARAM_NAME("ResetWriteWatch", 1, "lpBaseAddress"); // LPVOID
	ADD_PARAM_NAME("ResetWriteWatch", 2, "dwRegionSize"); // SIZE_T
	ADD_PARAM_NAME("ResizePalette", 1, "hpal"); // HPALETTE
	ADD_PARAM_NAME("ResizePalette", 2, "n"); // UINT
	ADD_PARAM_NAME("RestoreDC", 1, "hdc"); // HDC
	ADD_PARAM_NAME("RestoreDC", 2, "nSavedDC"); // int
	ADD_PARAM_NAME("RestoreLastError", 1, "dwErrCode"); // DWORD
	ADD_PARAM_NAME("ResumeThread", 1, "hThread"); // HANDLE
	ADD_PARAM_NAME("RoundRect", 1, "hdc"); // HDC
	ADD_PARAM_NAME("RoundRect", 2, "left"); // int
	ADD_PARAM_NAME("RoundRect", 3, "top"); // int
	ADD_PARAM_NAME("RoundRect", 4, "right"); // int
	ADD_PARAM_NAME("RoundRect", 5, "bottom"); // int
	ADD_PARAM_NAME("RoundRect", 6, "width"); // int
	ADD_PARAM_NAME("RoundRect", 7, "height"); // int
	ADD_PARAM_NAME("RouterAllocBidiMem", 1, "NumBytes"); // size_t
	ADD_PARAM_NAME("RouterAllocBidiResponseContainer", 1, "Count"); // DWORD
	ADD_PARAM_NAME("RouterAllocPrinterNotifyInfo", 1, "cPrinterNotifyInfoData"); // DWORD
	ADD_PARAM_NAME("RouterFreeBidiMem", 1, "pMemPointer"); // PVOID
	ADD_PARAM_NAME("RouterFreeBidiResponseContainer", 1, "pData"); // PBIDI_RESPONSE_CONTAINER
	ADD_PARAM_NAME("RouterFreePrinterNotifyInfo", 1, "pInfo"); // PPRINTER_NOTIFY_INFO
	ADD_PARAM_NAME("RtlIsValidLocaleName", 1, "LocaleName"); // LPCWSTR
	ADD_PARAM_NAME("RtlIsValidLocaleName", 2, "Flags"); // ULONG
	ADD_PARAM_NAME("RtlSecureZeroMemory", 1, "ptr"); // PVOID
	ADD_PARAM_NAME("RtlSecureZeroMemory", 2, "cnt"); // SIZE_T
	ADD_PARAM_NAME("RtlUnwind", 1, "TargetFrame"); // PVOID
	ADD_PARAM_NAME("RtlUnwind", 2, "TargetIp"); // PVOID
	ADD_PARAM_NAME("RtlUnwind", 3, "ExceptionRecord"); // PEXCEPTION_RECORD
	ADD_PARAM_NAME("RtlUnwind", 4, "ReturnValue"); // PVOID
}

} // namespace win_api
} // namespace semantics
} // namespace llvmir2hll
} // namespace retdec
